package aiworkspace

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveMemberRole invokes the aiworkspace.RemoveMemberRole API synchronously
func (client *Client) RemoveMemberRole(request *RemoveMemberRoleRequest) (response *RemoveMemberRoleResponse, err error) {
	response = CreateRemoveMemberRoleResponse()
	err = client.DoAction(request, response)
	return
}

// RemoveMemberRoleWithChan invokes the aiworkspace.RemoveMemberRole API asynchronously
func (client *Client) RemoveMemberRoleWithChan(request *RemoveMemberRoleRequest) (<-chan *RemoveMemberRoleResponse, <-chan error) {
	responseChan := make(chan *RemoveMemberRoleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveMemberRole(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveMemberRoleWithCallback invokes the aiworkspace.RemoveMemberRole API asynchronously
func (client *Client) RemoveMemberRoleWithCallback(request *RemoveMemberRoleRequest, callback func(response *RemoveMemberRoleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveMemberRoleResponse
		var err error
		defer close(result)
		response, err = client.RemoveMemberRole(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveMemberRoleRequest is the request struct for api RemoveMemberRole
type RemoveMemberRoleRequest struct {
	*requests.RoaRequest
	RoleName    string `position:"Path" name:"RoleName"`
	WorkspaceId string `position:"Path" name:"WorkspaceId"`
	MemberId    string `position:"Path" name:"MemberId"`
}

// RemoveMemberRoleResponse is the response struct for api RemoveMemberRole
type RemoveMemberRoleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRemoveMemberRoleRequest creates a request to invoke RemoveMemberRole API
func CreateRemoveMemberRoleRequest() (request *RemoveMemberRoleRequest) {
	request = &RemoveMemberRoleRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("AIWorkSpace", "2021-02-04", "RemoveMemberRole", "/api/v1/workspaces/[WorkspaceId]/members/[MemberId]/roles/[RoleName]", "", "")
	request.Method = requests.DELETE
	return
}

// CreateRemoveMemberRoleResponse creates a response to parse from RemoveMemberRole response
func CreateRemoveMemberRoleResponse() (response *RemoveMemberRoleResponse) {
	response = &RemoveMemberRoleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
