package ahas_openapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteIsolationRule invokes the ahas_openapi.DeleteIsolationRule API synchronously
func (client *Client) DeleteIsolationRule(request *DeleteIsolationRuleRequest) (response *DeleteIsolationRuleResponse, err error) {
	response = CreateDeleteIsolationRuleResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteIsolationRuleWithChan invokes the ahas_openapi.DeleteIsolationRule API asynchronously
func (client *Client) DeleteIsolationRuleWithChan(request *DeleteIsolationRuleRequest) (<-chan *DeleteIsolationRuleResponse, <-chan error) {
	responseChan := make(chan *DeleteIsolationRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteIsolationRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteIsolationRuleWithCallback invokes the ahas_openapi.DeleteIsolationRule API asynchronously
func (client *Client) DeleteIsolationRuleWithCallback(request *DeleteIsolationRuleRequest, callback func(response *DeleteIsolationRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteIsolationRuleResponse
		var err error
		defer close(result)
		response, err = client.DeleteIsolationRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteIsolationRuleRequest is the request struct for api DeleteIsolationRule
type DeleteIsolationRuleRequest struct {
	*requests.RpcRequest
	AhasRegionId string           `position:"Query" name:"AhasRegionId"`
	RuleId       requests.Integer `position:"Query" name:"RuleId"`
}

// DeleteIsolationRuleResponse is the response struct for api DeleteIsolationRule
type DeleteIsolationRuleResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDeleteIsolationRuleRequest creates a request to invoke DeleteIsolationRule API
func CreateDeleteIsolationRuleRequest() (request *DeleteIsolationRuleRequest) {
	request = &DeleteIsolationRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ahas-openapi", "2019-09-01", "DeleteIsolationRule", "ahas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteIsolationRuleResponse creates a response to parse from DeleteIsolationRule response
func CreateDeleteIsolationRuleResponse() (response *DeleteIsolationRuleResponse) {
	response = &DeleteIsolationRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
