// Code generated by protoc-gen-go-grpc. DO NOT EDIT.

package gnmi

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

// GNMIClient is the client API for GNMI service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type GNMIClient interface {
	// Capabilities allows the client to retrieve the set of capabilities that
	// is supported by the target. This allows the target to validate the
	// service version that is implemented and retrieve the set of models that
	// the target supports. The models can then be specified in subsequent RPCs
	// to restrict the set of data that is utilized.
	// Reference: gNMI Specification Section 3.2
	Capabilities(ctx context.Context, in *CapabilityRequest, opts ...grpc.CallOption) (*CapabilityResponse, error)
	// Retrieve a snapshot of data from the target. A Get RPC requests that the
	// target snapshots a subset of the data tree as specified by the paths
	// included in the message and serializes this to be returned to the
	// client using the specified encoding.
	// Reference: gNMI Specification Section 3.3
	Get(ctx context.Context, in *GetRequest, opts ...grpc.CallOption) (*GetResponse, error)
	// Set allows the client to modify the state of data on the target. The
	// paths to modified along with the new values that the client wishes
	// to set the value to.
	// Reference: gNMI Specification Section 3.4
	Set(ctx context.Context, in *SetRequest, opts ...grpc.CallOption) (*SetResponse, error)
	// Subscribe allows a client to request the target to send it values
	// of particular paths within the data tree. These values may be streamed
	// at a particular cadence (STREAM), sent one off on a long-lived channel
	// (POLL), or sent as a one-off retrieval (ONCE).
	// Reference: gNMI Specification Section 3.5
	Subscribe(ctx context.Context, opts ...grpc.CallOption) (GNMI_SubscribeClient, error)
}

type gNMIClient struct {
	cc grpc.ClientConnInterface
}

func NewGNMIClient(cc grpc.ClientConnInterface) GNMIClient {
	return &gNMIClient{cc}
}

func (c *gNMIClient) Capabilities(ctx context.Context, in *CapabilityRequest, opts ...grpc.CallOption) (*CapabilityResponse, error) {
	out := new(CapabilityResponse)
	err := c.cc.Invoke(ctx, "/gnmi.gNMI/Capabilities", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gNMIClient) Get(ctx context.Context, in *GetRequest, opts ...grpc.CallOption) (*GetResponse, error) {
	out := new(GetResponse)
	err := c.cc.Invoke(ctx, "/gnmi.gNMI/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gNMIClient) Set(ctx context.Context, in *SetRequest, opts ...grpc.CallOption) (*SetResponse, error) {
	out := new(SetResponse)
	err := c.cc.Invoke(ctx, "/gnmi.gNMI/Set", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gNMIClient) Subscribe(ctx context.Context, opts ...grpc.CallOption) (GNMI_SubscribeClient, error) {
	stream, err := c.cc.NewStream(ctx, &GNMI_ServiceDesc.Streams[0], "/gnmi.gNMI/Subscribe", opts...)
	if err != nil {
		return nil, err
	}
	x := &gNMISubscribeClient{stream}
	return x, nil
}

type GNMI_SubscribeClient interface {
	Send(*SubscribeRequest) error
	Recv() (*SubscribeResponse, error)
	grpc.ClientStream
}

type gNMISubscribeClient struct {
	grpc.ClientStream
}

func (x *gNMISubscribeClient) Send(m *SubscribeRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *gNMISubscribeClient) Recv() (*SubscribeResponse, error) {
	m := new(SubscribeResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// GNMIServer is the server API for GNMI service.
// All implementations should embed UnimplementedGNMIServer
// for forward compatibility
type GNMIServer interface {
	// Capabilities allows the client to retrieve the set of capabilities that
	// is supported by the target. This allows the target to validate the
	// service version that is implemented and retrieve the set of models that
	// the target supports. The models can then be specified in subsequent RPCs
	// to restrict the set of data that is utilized.
	// Reference: gNMI Specification Section 3.2
	Capabilities(context.Context, *CapabilityRequest) (*CapabilityResponse, error)
	// Retrieve a snapshot of data from the target. A Get RPC requests that the
	// target snapshots a subset of the data tree as specified by the paths
	// included in the message and serializes this to be returned to the
	// client using the specified encoding.
	// Reference: gNMI Specification Section 3.3
	Get(context.Context, *GetRequest) (*GetResponse, error)
	// Set allows the client to modify the state of data on the target. The
	// paths to modified along with the new values that the client wishes
	// to set the value to.
	// Reference: gNMI Specification Section 3.4
	Set(context.Context, *SetRequest) (*SetResponse, error)
	// Subscribe allows a client to request the target to send it values
	// of particular paths within the data tree. These values may be streamed
	// at a particular cadence (STREAM), sent one off on a long-lived channel
	// (POLL), or sent as a one-off retrieval (ONCE).
	// Reference: gNMI Specification Section 3.5
	Subscribe(GNMI_SubscribeServer) error
}

// UnimplementedGNMIServer should be embedded to have forward compatible implementations.
type UnimplementedGNMIServer struct {
}

func (UnimplementedGNMIServer) Capabilities(context.Context, *CapabilityRequest) (*CapabilityResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Capabilities not implemented")
}
func (UnimplementedGNMIServer) Get(context.Context, *GetRequest) (*GetResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedGNMIServer) Set(context.Context, *SetRequest) (*SetResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Set not implemented")
}
func (UnimplementedGNMIServer) Subscribe(GNMI_SubscribeServer) error {
	return status.Errorf(codes.Unimplemented, "method Subscribe not implemented")
}

// UnsafeGNMIServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to GNMIServer will
// result in compilation errors.
type UnsafeGNMIServer interface {
	mustEmbedUnimplementedGNMIServer()
}

func RegisterGNMIServer(s grpc.ServiceRegistrar, srv GNMIServer) {
	s.RegisterService(&GNMI_ServiceDesc, srv)
}

func _GNMI_Capabilities_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CapabilityRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GNMIServer).Capabilities(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gnmi.gNMI/Capabilities",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GNMIServer).Capabilities(ctx, req.(*CapabilityRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GNMI_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GNMIServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gnmi.gNMI/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GNMIServer).Get(ctx, req.(*GetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GNMI_Set_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GNMIServer).Set(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gnmi.gNMI/Set",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GNMIServer).Set(ctx, req.(*SetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GNMI_Subscribe_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(GNMIServer).Subscribe(&gNMISubscribeServer{stream})
}

type GNMI_SubscribeServer interface {
	Send(*SubscribeResponse) error
	Recv() (*SubscribeRequest, error)
	grpc.ServerStream
}

type gNMISubscribeServer struct {
	grpc.ServerStream
}

func (x *gNMISubscribeServer) Send(m *SubscribeResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *gNMISubscribeServer) Recv() (*SubscribeRequest, error) {
	m := new(SubscribeRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// GNMI_ServiceDesc is the grpc.ServiceDesc for GNMI service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var GNMI_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "gnmi.gNMI",
	HandlerType: (*GNMIServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Capabilities",
			Handler:    _GNMI_Capabilities_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _GNMI_Get_Handler,
		},
		{
			MethodName: "Set",
			Handler:    _GNMI_Set_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Subscribe",
			Handler:       _GNMI_Subscribe_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "proto/gnmi/gnmi.proto",
}
