// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the disco-to-proto3-converter. DO NOT EDIT!
// Source Discovery file: compute.v1.json
// Source file revision: 20230307
// API name: compute
// API version: v1

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.30.0
// 	protoc        v3.21.12
// source: google/cloud/compute/v1/compute.proto

package computepb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	_ "google.golang.org/genproto/googleapis/cloud/extendedops"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This signifies the networking tier used for configuring this access configuration and can only take the following values: PREMIUM, STANDARD. If an AccessConfig is specified without a valid external IP address, an ephemeral IP will be created with this networkTier. If an AccessConfig with a valid external IP address is specified, it must match that of the networkTier associated with the Address resource owning that IP.
type AccessConfig_NetworkTier int32

const (
	// A value indicating that the enum field is not set.
	AccessConfig_UNDEFINED_NETWORK_TIER AccessConfig_NetworkTier = 0
	// Public internet quality with fixed bandwidth.
	AccessConfig_FIXED_STANDARD AccessConfig_NetworkTier = 310464328
	// High quality, Google-grade network tier, support for all networking products.
	AccessConfig_PREMIUM AccessConfig_NetworkTier = 399530551
	// Public internet quality, only limited support for other networking products.
	AccessConfig_STANDARD AccessConfig_NetworkTier = 484642493
	// (Output only) Temporary tier for FIXED_STANDARD when fixed standard tier is expired or not configured.
	AccessConfig_STANDARD_OVERRIDES_FIXED_STANDARD AccessConfig_NetworkTier = 465847234
)

// Enum value maps for AccessConfig_NetworkTier.
var (
	AccessConfig_NetworkTier_name = map[int32]string{
		0:         "UNDEFINED_NETWORK_TIER",
		310464328: "FIXED_STANDARD",
		399530551: "PREMIUM",
		484642493: "STANDARD",
		465847234: "STANDARD_OVERRIDES_FIXED_STANDARD",
	}
	AccessConfig_NetworkTier_value = map[string]int32{
		"UNDEFINED_NETWORK_TIER":            0,
		"FIXED_STANDARD":                    310464328,
		"PREMIUM":                           399530551,
		"STANDARD":                          484642493,
		"STANDARD_OVERRIDES_FIXED_STANDARD": 465847234,
	}
)

func (x AccessConfig_NetworkTier) Enum() *AccessConfig_NetworkTier {
	p := new(AccessConfig_NetworkTier)
	*p = x
	return p
}

func (x AccessConfig_NetworkTier) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AccessConfig_NetworkTier) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[0].Descriptor()
}

func (AccessConfig_NetworkTier) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[0]
}

func (x AccessConfig_NetworkTier) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AccessConfig_NetworkTier.Descriptor instead.
func (AccessConfig_NetworkTier) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{8, 0}
}

// The type of configuration. The default and only option is ONE_TO_ONE_NAT.
type AccessConfig_Type int32

const (
	// A value indicating that the enum field is not set.
	AccessConfig_UNDEFINED_TYPE AccessConfig_Type = 0
	AccessConfig_DIRECT_IPV6    AccessConfig_Type = 4397213
	AccessConfig_ONE_TO_ONE_NAT AccessConfig_Type = 84090205
)

// Enum value maps for AccessConfig_Type.
var (
	AccessConfig_Type_name = map[int32]string{
		0:        "UNDEFINED_TYPE",
		4397213:  "DIRECT_IPV6",
		84090205: "ONE_TO_ONE_NAT",
	}
	AccessConfig_Type_value = map[string]int32{
		"UNDEFINED_TYPE": 0,
		"DIRECT_IPV6":    4397213,
		"ONE_TO_ONE_NAT": 84090205,
	}
)

func (x AccessConfig_Type) Enum() *AccessConfig_Type {
	p := new(AccessConfig_Type)
	*p = x
	return p
}

func (x AccessConfig_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AccessConfig_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[1].Descriptor()
}

func (AccessConfig_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[1]
}

func (x AccessConfig_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AccessConfig_Type.Descriptor instead.
func (AccessConfig_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{8, 1}
}

// The type of address to reserve, either INTERNAL or EXTERNAL. If unspecified, defaults to EXTERNAL.
type Address_AddressType int32

const (
	// A value indicating that the enum field is not set.
	Address_UNDEFINED_ADDRESS_TYPE Address_AddressType = 0
	// A publicly visible external IP address.
	Address_EXTERNAL Address_AddressType = 35607499
	// A private network IP address, for use with an Instance or Internal Load Balancer forwarding rule.
	Address_INTERNAL         Address_AddressType = 279295677
	Address_UNSPECIFIED_TYPE Address_AddressType = 53933922
)

// Enum value maps for Address_AddressType.
var (
	Address_AddressType_name = map[int32]string{
		0:         "UNDEFINED_ADDRESS_TYPE",
		35607499:  "EXTERNAL",
		279295677: "INTERNAL",
		53933922:  "UNSPECIFIED_TYPE",
	}
	Address_AddressType_value = map[string]int32{
		"UNDEFINED_ADDRESS_TYPE": 0,
		"EXTERNAL":               35607499,
		"INTERNAL":               279295677,
		"UNSPECIFIED_TYPE":       53933922,
	}
)

func (x Address_AddressType) Enum() *Address_AddressType {
	p := new(Address_AddressType)
	*p = x
	return p
}

func (x Address_AddressType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Address_AddressType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[2].Descriptor()
}

func (Address_AddressType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[2]
}

func (x Address_AddressType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Address_AddressType.Descriptor instead.
func (Address_AddressType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{27, 0}
}

// The IP version that will be used by this address. Valid options are IPV4 or IPV6. This can only be specified for a global address.
type Address_IpVersion int32

const (
	// A value indicating that the enum field is not set.
	Address_UNDEFINED_IP_VERSION Address_IpVersion = 0
	Address_IPV4                 Address_IpVersion = 2254341
	Address_IPV6                 Address_IpVersion = 2254343
	Address_UNSPECIFIED_VERSION  Address_IpVersion = 21850000
)

// Enum value maps for Address_IpVersion.
var (
	Address_IpVersion_name = map[int32]string{
		0:        "UNDEFINED_IP_VERSION",
		2254341:  "IPV4",
		2254343:  "IPV6",
		21850000: "UNSPECIFIED_VERSION",
	}
	Address_IpVersion_value = map[string]int32{
		"UNDEFINED_IP_VERSION": 0,
		"IPV4":                 2254341,
		"IPV6":                 2254343,
		"UNSPECIFIED_VERSION":  21850000,
	}
)

func (x Address_IpVersion) Enum() *Address_IpVersion {
	p := new(Address_IpVersion)
	*p = x
	return p
}

func (x Address_IpVersion) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Address_IpVersion) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[3].Descriptor()
}

func (Address_IpVersion) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[3]
}

func (x Address_IpVersion) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Address_IpVersion.Descriptor instead.
func (Address_IpVersion) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{27, 1}
}

// The endpoint type of this address, which should be VM or NETLB. This is used for deciding which type of endpoint this address can be used after the external IPv6 address reservation.
type Address_Ipv6EndpointType int32

const (
	// A value indicating that the enum field is not set.
	Address_UNDEFINED_IPV6_ENDPOINT_TYPE Address_Ipv6EndpointType = 0
	// Reserved IPv6 address can be used on network load balancer.
	Address_NETLB Address_Ipv6EndpointType = 74173363
	// Reserved IPv6 address can be used on VM.
	Address_VM Address_Ipv6EndpointType = 2743
)

// Enum value maps for Address_Ipv6EndpointType.
var (
	Address_Ipv6EndpointType_name = map[int32]string{
		0:        "UNDEFINED_IPV6_ENDPOINT_TYPE",
		74173363: "NETLB",
		2743:     "VM",
	}
	Address_Ipv6EndpointType_value = map[string]int32{
		"UNDEFINED_IPV6_ENDPOINT_TYPE": 0,
		"NETLB":                        74173363,
		"VM":                           2743,
	}
)

func (x Address_Ipv6EndpointType) Enum() *Address_Ipv6EndpointType {
	p := new(Address_Ipv6EndpointType)
	*p = x
	return p
}

func (x Address_Ipv6EndpointType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Address_Ipv6EndpointType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[4].Descriptor()
}

func (Address_Ipv6EndpointType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[4]
}

func (x Address_Ipv6EndpointType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Address_Ipv6EndpointType.Descriptor instead.
func (Address_Ipv6EndpointType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{27, 2}
}

// This signifies the networking tier used for configuring this address and can only take the following values: PREMIUM or STANDARD. Internal IP addresses are always Premium Tier; global external IP addresses are always Premium Tier; regional external IP addresses can be either Standard or Premium Tier. If this field is not specified, it is assumed to be PREMIUM.
type Address_NetworkTier int32

const (
	// A value indicating that the enum field is not set.
	Address_UNDEFINED_NETWORK_TIER Address_NetworkTier = 0
	// Public internet quality with fixed bandwidth.
	Address_FIXED_STANDARD Address_NetworkTier = 310464328
	// High quality, Google-grade network tier, support for all networking products.
	Address_PREMIUM Address_NetworkTier = 399530551
	// Public internet quality, only limited support for other networking products.
	Address_STANDARD Address_NetworkTier = 484642493
	// (Output only) Temporary tier for FIXED_STANDARD when fixed standard tier is expired or not configured.
	Address_STANDARD_OVERRIDES_FIXED_STANDARD Address_NetworkTier = 465847234
)

// Enum value maps for Address_NetworkTier.
var (
	Address_NetworkTier_name = map[int32]string{
		0:         "UNDEFINED_NETWORK_TIER",
		310464328: "FIXED_STANDARD",
		399530551: "PREMIUM",
		484642493: "STANDARD",
		465847234: "STANDARD_OVERRIDES_FIXED_STANDARD",
	}
	Address_NetworkTier_value = map[string]int32{
		"UNDEFINED_NETWORK_TIER":            0,
		"FIXED_STANDARD":                    310464328,
		"PREMIUM":                           399530551,
		"STANDARD":                          484642493,
		"STANDARD_OVERRIDES_FIXED_STANDARD": 465847234,
	}
)

func (x Address_NetworkTier) Enum() *Address_NetworkTier {
	p := new(Address_NetworkTier)
	*p = x
	return p
}

func (x Address_NetworkTier) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Address_NetworkTier) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[5].Descriptor()
}

func (Address_NetworkTier) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[5]
}

func (x Address_NetworkTier) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Address_NetworkTier.Descriptor instead.
func (Address_NetworkTier) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{27, 3}
}

// The purpose of this resource, which can be one of the following values: - GCE_ENDPOINT for addresses that are used by VM instances, alias IP ranges, load balancers, and similar resources. - DNS_RESOLVER for a DNS resolver address in a subnetwork for a Cloud DNS inbound forwarder IP addresses (regional internal IP address in a subnet of a VPC network) - VPC_PEERING for global internal IP addresses used for private services access allocated ranges. - NAT_AUTO for the regional external IP addresses used by Cloud NAT when allocating addresses using automatic NAT IP address allocation. - IPSEC_INTERCONNECT for addresses created from a private IP range that are reserved for a VLAN attachment in an *HA VPN over Cloud Interconnect* configuration. These addresses are regional resources. - `SHARED_LOADBALANCER_VIP` for an internal IP address that is assigned to multiple internal forwarding rules. - `PRIVATE_SERVICE_CONNECT` for a private network address that is used to configure Private Service Connect. Only global internal addresses can use this purpose.
type Address_Purpose int32

const (
	// A value indicating that the enum field is not set.
	Address_UNDEFINED_PURPOSE Address_Purpose = 0
	// DNS resolver address in the subnetwork.
	Address_DNS_RESOLVER Address_Purpose = 476114556
	// VM internal/alias IP, Internal LB service IP, etc.
	Address_GCE_ENDPOINT Address_Purpose = 230515243
	// A regional internal IP address range reserved for the VLAN attachment that is used in HA VPN over Cloud Interconnect. This regional internal IP address range must not overlap with any IP address range of subnet/route in the VPC network and its peering networks. After the VLAN attachment is created with the reserved IP address range, when creating a new VPN gateway, its interface IP address is allocated from the associated VLAN attachment’s IP address range.
	Address_IPSEC_INTERCONNECT Address_Purpose = 340437251
	// External IP automatically reserved for Cloud NAT.
	Address_NAT_AUTO Address_Purpose = 163666477
	// A private network IP address that can be used to configure Private Service Connect. This purpose can be specified only for GLOBAL addresses of Type INTERNAL
	Address_PRIVATE_SERVICE_CONNECT Address_Purpose = 48134724
	// A regional internal IP address range reserved for Serverless.
	Address_SERVERLESS Address_Purpose = 270492508
	// A private network IP address that can be shared by multiple Internal Load Balancer forwarding rules.
	Address_SHARED_LOADBALANCER_VIP Address_Purpose = 294447572
	// IP range for peer networks.
	Address_VPC_PEERING Address_Purpose = 400800170
)

// Enum value maps for Address_Purpose.
var (
	Address_Purpose_name = map[int32]string{
		0:         "UNDEFINED_PURPOSE",
		476114556: "DNS_RESOLVER",
		230515243: "GCE_ENDPOINT",
		340437251: "IPSEC_INTERCONNECT",
		163666477: "NAT_AUTO",
		48134724:  "PRIVATE_SERVICE_CONNECT",
		270492508: "SERVERLESS",
		294447572: "SHARED_LOADBALANCER_VIP",
		400800170: "VPC_PEERING",
	}
	Address_Purpose_value = map[string]int32{
		"UNDEFINED_PURPOSE":       0,
		"DNS_RESOLVER":            476114556,
		"GCE_ENDPOINT":            230515243,
		"IPSEC_INTERCONNECT":      340437251,
		"NAT_AUTO":                163666477,
		"PRIVATE_SERVICE_CONNECT": 48134724,
		"SERVERLESS":              270492508,
		"SHARED_LOADBALANCER_VIP": 294447572,
		"VPC_PEERING":             400800170,
	}
)

func (x Address_Purpose) Enum() *Address_Purpose {
	p := new(Address_Purpose)
	*p = x
	return p
}

func (x Address_Purpose) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Address_Purpose) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[6].Descriptor()
}

func (Address_Purpose) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[6]
}

func (x Address_Purpose) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Address_Purpose.Descriptor instead.
func (Address_Purpose) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{27, 4}
}

// [Output Only] The status of the address, which can be one of RESERVING, RESERVED, or IN_USE. An address that is RESERVING is currently in the process of being reserved. A RESERVED address is currently reserved and available to use. An IN_USE address is currently being used by another resource and is not available.
type Address_Status int32

const (
	// A value indicating that the enum field is not set.
	Address_UNDEFINED_STATUS Address_Status = 0
	// Address is being used by another resource and is not available.
	Address_IN_USE Address_Status = 17393485
	// Address is reserved and available to use.
	Address_RESERVED Address_Status = 432241448
	// Address is being reserved.
	Address_RESERVING Address_Status = 514587225
)

// Enum value maps for Address_Status.
var (
	Address_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		17393485:  "IN_USE",
		432241448: "RESERVED",
		514587225: "RESERVING",
	}
	Address_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"IN_USE":           17393485,
		"RESERVED":         432241448,
		"RESERVING":        514587225,
	}
)

func (x Address_Status) Enum() *Address_Status {
	p := new(Address_Status)
	*p = x
	return p
}

func (x Address_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Address_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[7].Descriptor()
}

func (Address_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[7]
}

func (x Address_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Address_Status.Descriptor instead.
func (Address_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{27, 5}
}

// Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI. For performance characteristics of SCSI over NVMe, see Local SSD performance.
type AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_Interface int32

const (
	// A value indicating that the enum field is not set.
	AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_UNDEFINED_INTERFACE AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_Interface = 0
	AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_NVME                AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_Interface = 2408800
	AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_SCSI                AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_Interface = 2539686
)

// Enum value maps for AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_Interface.
var (
	AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_Interface_name = map[int32]string{
		0:       "UNDEFINED_INTERFACE",
		2408800: "NVME",
		2539686: "SCSI",
	}
	AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_Interface_value = map[string]int32{
		"UNDEFINED_INTERFACE": 0,
		"NVME":                2408800,
		"SCSI":                2539686,
	}
)

func (x AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_Interface) Enum() *AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_Interface {
	p := new(AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_Interface)
	*p = x
	return p
}

func (x AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_Interface) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_Interface) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[8].Descriptor()
}

func (AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_Interface) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[8]
}

func (x AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_Interface) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_Interface.Descriptor instead.
func (AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_Interface) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{76, 0}
}

// [Output Only] The architecture of the attached disk. Valid values are ARM64 or X86_64.
type AttachedDisk_Architecture int32

const (
	// A value indicating that the enum field is not set.
	AttachedDisk_UNDEFINED_ARCHITECTURE AttachedDisk_Architecture = 0
	// Default value indicating Architecture is not set.
	AttachedDisk_ARCHITECTURE_UNSPECIFIED AttachedDisk_Architecture = 394750507
	// Machines with architecture ARM64
	AttachedDisk_ARM64 AttachedDisk_Architecture = 62547450
	// Machines with architecture X86_64
	AttachedDisk_X86_64 AttachedDisk_Architecture = 425300551
)

// Enum value maps for AttachedDisk_Architecture.
var (
	AttachedDisk_Architecture_name = map[int32]string{
		0:         "UNDEFINED_ARCHITECTURE",
		394750507: "ARCHITECTURE_UNSPECIFIED",
		62547450:  "ARM64",
		425300551: "X86_64",
	}
	AttachedDisk_Architecture_value = map[string]int32{
		"UNDEFINED_ARCHITECTURE":   0,
		"ARCHITECTURE_UNSPECIFIED": 394750507,
		"ARM64":                    62547450,
		"X86_64":                   425300551,
	}
)

func (x AttachedDisk_Architecture) Enum() *AttachedDisk_Architecture {
	p := new(AttachedDisk_Architecture)
	*p = x
	return p
}

func (x AttachedDisk_Architecture) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AttachedDisk_Architecture) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[9].Descriptor()
}

func (AttachedDisk_Architecture) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[9]
}

func (x AttachedDisk_Architecture) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AttachedDisk_Architecture.Descriptor instead.
func (AttachedDisk_Architecture) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{85, 0}
}

// Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. For most machine types, the default is SCSI. Local SSDs can use either NVME or SCSI. In certain configurations, persistent disks can use NVMe. For more information, see About persistent disks.
type AttachedDisk_Interface int32

const (
	// A value indicating that the enum field is not set.
	AttachedDisk_UNDEFINED_INTERFACE AttachedDisk_Interface = 0
	AttachedDisk_NVME                AttachedDisk_Interface = 2408800
	AttachedDisk_SCSI                AttachedDisk_Interface = 2539686
)

// Enum value maps for AttachedDisk_Interface.
var (
	AttachedDisk_Interface_name = map[int32]string{
		0:       "UNDEFINED_INTERFACE",
		2408800: "NVME",
		2539686: "SCSI",
	}
	AttachedDisk_Interface_value = map[string]int32{
		"UNDEFINED_INTERFACE": 0,
		"NVME":                2408800,
		"SCSI":                2539686,
	}
)

func (x AttachedDisk_Interface) Enum() *AttachedDisk_Interface {
	p := new(AttachedDisk_Interface)
	*p = x
	return p
}

func (x AttachedDisk_Interface) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AttachedDisk_Interface) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[10].Descriptor()
}

func (AttachedDisk_Interface) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[10]
}

func (x AttachedDisk_Interface) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AttachedDisk_Interface.Descriptor instead.
func (AttachedDisk_Interface) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{85, 1}
}

// The mode in which to attach this disk, either READ_WRITE or READ_ONLY. If not specified, the default is to attach the disk in READ_WRITE mode.
type AttachedDisk_Mode int32

const (
	// A value indicating that the enum field is not set.
	AttachedDisk_UNDEFINED_MODE AttachedDisk_Mode = 0
	// Attaches this disk in read-only mode. Multiple virtual machines can use a disk in read-only mode at a time.
	AttachedDisk_READ_ONLY AttachedDisk_Mode = 91950261
	// *[Default]* Attaches this disk in read-write mode. Only one virtual machine at a time can be attached to a disk in read-write mode.
	AttachedDisk_READ_WRITE AttachedDisk_Mode = 173607894
)

// Enum value maps for AttachedDisk_Mode.
var (
	AttachedDisk_Mode_name = map[int32]string{
		0:         "UNDEFINED_MODE",
		91950261:  "READ_ONLY",
		173607894: "READ_WRITE",
	}
	AttachedDisk_Mode_value = map[string]int32{
		"UNDEFINED_MODE": 0,
		"READ_ONLY":      91950261,
		"READ_WRITE":     173607894,
	}
)

func (x AttachedDisk_Mode) Enum() *AttachedDisk_Mode {
	p := new(AttachedDisk_Mode)
	*p = x
	return p
}

func (x AttachedDisk_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AttachedDisk_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[11].Descriptor()
}

func (AttachedDisk_Mode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[11]
}

func (x AttachedDisk_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AttachedDisk_Mode.Descriptor instead.
func (AttachedDisk_Mode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{85, 2}
}

// Specifies the type of the disk, either SCRATCH or PERSISTENT. If not specified, the default is PERSISTENT.
type AttachedDisk_Type int32

const (
	// A value indicating that the enum field is not set.
	AttachedDisk_UNDEFINED_TYPE AttachedDisk_Type = 0
	AttachedDisk_PERSISTENT     AttachedDisk_Type = 460683927
	AttachedDisk_SCRATCH        AttachedDisk_Type = 496778970
)

// Enum value maps for AttachedDisk_Type.
var (
	AttachedDisk_Type_name = map[int32]string{
		0:         "UNDEFINED_TYPE",
		460683927: "PERSISTENT",
		496778970: "SCRATCH",
	}
	AttachedDisk_Type_value = map[string]int32{
		"UNDEFINED_TYPE": 0,
		"PERSISTENT":     460683927,
		"SCRATCH":        496778970,
	}
)

func (x AttachedDisk_Type) Enum() *AttachedDisk_Type {
	p := new(AttachedDisk_Type)
	*p = x
	return p
}

func (x AttachedDisk_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AttachedDisk_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[12].Descriptor()
}

func (AttachedDisk_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[12]
}

func (x AttachedDisk_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AttachedDisk_Type.Descriptor instead.
func (AttachedDisk_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{85, 3}
}

// The architecture of the attached disk. Valid values are arm64 or x86_64.
type AttachedDiskInitializeParams_Architecture int32

const (
	// A value indicating that the enum field is not set.
	AttachedDiskInitializeParams_UNDEFINED_ARCHITECTURE AttachedDiskInitializeParams_Architecture = 0
	// Default value indicating Architecture is not set.
	AttachedDiskInitializeParams_ARCHITECTURE_UNSPECIFIED AttachedDiskInitializeParams_Architecture = 394750507
	// Machines with architecture ARM64
	AttachedDiskInitializeParams_ARM64 AttachedDiskInitializeParams_Architecture = 62547450
	// Machines with architecture X86_64
	AttachedDiskInitializeParams_X86_64 AttachedDiskInitializeParams_Architecture = 425300551
)

// Enum value maps for AttachedDiskInitializeParams_Architecture.
var (
	AttachedDiskInitializeParams_Architecture_name = map[int32]string{
		0:         "UNDEFINED_ARCHITECTURE",
		394750507: "ARCHITECTURE_UNSPECIFIED",
		62547450:  "ARM64",
		425300551: "X86_64",
	}
	AttachedDiskInitializeParams_Architecture_value = map[string]int32{
		"UNDEFINED_ARCHITECTURE":   0,
		"ARCHITECTURE_UNSPECIFIED": 394750507,
		"ARM64":                    62547450,
		"X86_64":                   425300551,
	}
)

func (x AttachedDiskInitializeParams_Architecture) Enum() *AttachedDiskInitializeParams_Architecture {
	p := new(AttachedDiskInitializeParams_Architecture)
	*p = x
	return p
}

func (x AttachedDiskInitializeParams_Architecture) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AttachedDiskInitializeParams_Architecture) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[13].Descriptor()
}

func (AttachedDiskInitializeParams_Architecture) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[13]
}

func (x AttachedDiskInitializeParams_Architecture) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AttachedDiskInitializeParams_Architecture.Descriptor instead.
func (AttachedDiskInitializeParams_Architecture) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{86, 0}
}

// Specifies which action to take on instance update with this disk. Default is to use the existing disk.
type AttachedDiskInitializeParams_OnUpdateAction int32

const (
	// A value indicating that the enum field is not set.
	AttachedDiskInitializeParams_UNDEFINED_ON_UPDATE_ACTION AttachedDiskInitializeParams_OnUpdateAction = 0
	// Always recreate the disk.
	AttachedDiskInitializeParams_RECREATE_DISK AttachedDiskInitializeParams_OnUpdateAction = 494767853
	// Recreate the disk if source (image, snapshot) of this disk is different from source of existing disk.
	AttachedDiskInitializeParams_RECREATE_DISK_IF_SOURCE_CHANGED AttachedDiskInitializeParams_OnUpdateAction = 398099712
	// Use the existing disk, this is the default behaviour.
	AttachedDiskInitializeParams_USE_EXISTING_DISK AttachedDiskInitializeParams_OnUpdateAction = 232682233
)

// Enum value maps for AttachedDiskInitializeParams_OnUpdateAction.
var (
	AttachedDiskInitializeParams_OnUpdateAction_name = map[int32]string{
		0:         "UNDEFINED_ON_UPDATE_ACTION",
		494767853: "RECREATE_DISK",
		398099712: "RECREATE_DISK_IF_SOURCE_CHANGED",
		232682233: "USE_EXISTING_DISK",
	}
	AttachedDiskInitializeParams_OnUpdateAction_value = map[string]int32{
		"UNDEFINED_ON_UPDATE_ACTION":      0,
		"RECREATE_DISK":                   494767853,
		"RECREATE_DISK_IF_SOURCE_CHANGED": 398099712,
		"USE_EXISTING_DISK":               232682233,
	}
)

func (x AttachedDiskInitializeParams_OnUpdateAction) Enum() *AttachedDiskInitializeParams_OnUpdateAction {
	p := new(AttachedDiskInitializeParams_OnUpdateAction)
	*p = x
	return p
}

func (x AttachedDiskInitializeParams_OnUpdateAction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AttachedDiskInitializeParams_OnUpdateAction) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[14].Descriptor()
}

func (AttachedDiskInitializeParams_OnUpdateAction) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[14]
}

func (x AttachedDiskInitializeParams_OnUpdateAction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AttachedDiskInitializeParams_OnUpdateAction.Descriptor instead.
func (AttachedDiskInitializeParams_OnUpdateAction) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{86, 1}
}

// The log type that this config enables.
type AuditLogConfig_LogType int32

const (
	// A value indicating that the enum field is not set.
	AuditLogConfig_UNDEFINED_LOG_TYPE AuditLogConfig_LogType = 0
	// Admin reads. Example: CloudIAM getIamPolicy
	AuditLogConfig_ADMIN_READ AuditLogConfig_LogType = 128951462
	// Data reads. Example: CloudSQL Users list
	AuditLogConfig_DATA_READ AuditLogConfig_LogType = 305224971
	// Data writes. Example: CloudSQL Users create
	AuditLogConfig_DATA_WRITE AuditLogConfig_LogType = 340181738
	// Default case. Should never be this.
	AuditLogConfig_LOG_TYPE_UNSPECIFIED AuditLogConfig_LogType = 154527053
)

// Enum value maps for AuditLogConfig_LogType.
var (
	AuditLogConfig_LogType_name = map[int32]string{
		0:         "UNDEFINED_LOG_TYPE",
		128951462: "ADMIN_READ",
		305224971: "DATA_READ",
		340181738: "DATA_WRITE",
		154527053: "LOG_TYPE_UNSPECIFIED",
	}
	AuditLogConfig_LogType_value = map[string]int32{
		"UNDEFINED_LOG_TYPE":   0,
		"ADMIN_READ":           128951462,
		"DATA_READ":            305224971,
		"DATA_WRITE":           340181738,
		"LOG_TYPE_UNSPECIFIED": 154527053,
	}
)

func (x AuditLogConfig_LogType) Enum() *AuditLogConfig_LogType {
	p := new(AuditLogConfig_LogType)
	*p = x
	return p
}

func (x AuditLogConfig_LogType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AuditLogConfig_LogType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[15].Descriptor()
}

func (AuditLogConfig_LogType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[15]
}

func (x AuditLogConfig_LogType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AuditLogConfig_LogType.Descriptor instead.
func (AuditLogConfig_LogType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{88, 0}
}

// This is deprecated and has no effect. Do not use.
type AuthorizationLoggingOptions_PermissionType int32

const (
	// A value indicating that the enum field is not set.
	AuthorizationLoggingOptions_UNDEFINED_PERMISSION_TYPE AuthorizationLoggingOptions_PermissionType = 0
	// This is deprecated and has no effect. Do not use.
	AuthorizationLoggingOptions_ADMIN_READ AuthorizationLoggingOptions_PermissionType = 128951462
	// This is deprecated and has no effect. Do not use.
	AuthorizationLoggingOptions_ADMIN_WRITE AuthorizationLoggingOptions_PermissionType = 244412079
	// This is deprecated and has no effect. Do not use.
	AuthorizationLoggingOptions_DATA_READ AuthorizationLoggingOptions_PermissionType = 305224971
	// This is deprecated and has no effect. Do not use.
	AuthorizationLoggingOptions_DATA_WRITE AuthorizationLoggingOptions_PermissionType = 340181738
	// This is deprecated and has no effect. Do not use.
	AuthorizationLoggingOptions_PERMISSION_TYPE_UNSPECIFIED AuthorizationLoggingOptions_PermissionType = 440313346
)

// Enum value maps for AuthorizationLoggingOptions_PermissionType.
var (
	AuthorizationLoggingOptions_PermissionType_name = map[int32]string{
		0:         "UNDEFINED_PERMISSION_TYPE",
		128951462: "ADMIN_READ",
		244412079: "ADMIN_WRITE",
		305224971: "DATA_READ",
		340181738: "DATA_WRITE",
		440313346: "PERMISSION_TYPE_UNSPECIFIED",
	}
	AuthorizationLoggingOptions_PermissionType_value = map[string]int32{
		"UNDEFINED_PERMISSION_TYPE":   0,
		"ADMIN_READ":                  128951462,
		"ADMIN_WRITE":                 244412079,
		"DATA_READ":                   305224971,
		"DATA_WRITE":                  340181738,
		"PERMISSION_TYPE_UNSPECIFIED": 440313346,
	}
)

func (x AuthorizationLoggingOptions_PermissionType) Enum() *AuthorizationLoggingOptions_PermissionType {
	p := new(AuthorizationLoggingOptions_PermissionType)
	*p = x
	return p
}

func (x AuthorizationLoggingOptions_PermissionType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AuthorizationLoggingOptions_PermissionType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[16].Descriptor()
}

func (AuthorizationLoggingOptions_PermissionType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[16]
}

func (x AuthorizationLoggingOptions_PermissionType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AuthorizationLoggingOptions_PermissionType.Descriptor instead.
func (AuthorizationLoggingOptions_PermissionType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{89, 0}
}

// [Output Only] The status of the autoscaler configuration. Current set of possible values: - PENDING: Autoscaler backend hasn't read new/updated configuration. - DELETING: Configuration is being deleted. - ACTIVE: Configuration is acknowledged to be effective. Some warnings might be present in the statusDetails field. - ERROR: Configuration has errors. Actionable for users. Details are present in the statusDetails field. New values might be added in the future.
type Autoscaler_Status int32

const (
	// A value indicating that the enum field is not set.
	Autoscaler_UNDEFINED_STATUS Autoscaler_Status = 0
	// Configuration is acknowledged to be effective
	Autoscaler_ACTIVE Autoscaler_Status = 314733318
	// Configuration is being deleted
	Autoscaler_DELETING Autoscaler_Status = 528602024
	// Configuration has errors. Actionable for users.
	Autoscaler_ERROR Autoscaler_Status = 66247144
	// Autoscaler backend hasn't read new/updated configuration
	Autoscaler_PENDING Autoscaler_Status = 35394935
)

// Enum value maps for Autoscaler_Status.
var (
	Autoscaler_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		314733318: "ACTIVE",
		528602024: "DELETING",
		66247144:  "ERROR",
		35394935:  "PENDING",
	}
	Autoscaler_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"ACTIVE":           314733318,
		"DELETING":         528602024,
		"ERROR":            66247144,
		"PENDING":          35394935,
	}
)

func (x Autoscaler_Status) Enum() *Autoscaler_Status {
	p := new(Autoscaler_Status)
	*p = x
	return p
}

func (x Autoscaler_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Autoscaler_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[17].Descriptor()
}

func (Autoscaler_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[17]
}

func (x Autoscaler_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Autoscaler_Status.Descriptor instead.
func (Autoscaler_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{90, 0}
}

// The type of error, warning, or notice returned. Current set of possible values: - ALL_INSTANCES_UNHEALTHY (WARNING): All instances in the instance group are unhealthy (not in RUNNING state). - BACKEND_SERVICE_DOES_NOT_EXIST (ERROR): There is no backend service attached to the instance group. - CAPPED_AT_MAX_NUM_REPLICAS (WARNING): Autoscaler recommends a size greater than maxNumReplicas. - CUSTOM_METRIC_DATA_POINTS_TOO_SPARSE (WARNING): The custom metric samples are not exported often enough to be a credible base for autoscaling. - CUSTOM_METRIC_INVALID (ERROR): The custom metric that was specified does not exist or does not have the necessary labels. - MIN_EQUALS_MAX (WARNING): The minNumReplicas is equal to maxNumReplicas. This means the autoscaler cannot add or remove instances from the instance group. - MISSING_CUSTOM_METRIC_DATA_POINTS (WARNING): The autoscaler did not receive any data from the custom metric configured for autoscaling. - MISSING_LOAD_BALANCING_DATA_POINTS (WARNING): The autoscaler is configured to scale based on a load balancing signal but the instance group has not received any requests from the load balancer. - MODE_OFF (WARNING): Autoscaling is turned off. The number of instances in the group won't change automatically. The autoscaling configuration is preserved. - MODE_ONLY_UP (WARNING): Autoscaling is in the "Autoscale only out" mode. The autoscaler can add instances but not remove any. - MORE_THAN_ONE_BACKEND_SERVICE (ERROR): The instance group cannot be autoscaled because it has more than one backend service attached to it. - NOT_ENOUGH_QUOTA_AVAILABLE (ERROR): There is insufficient quota for the necessary resources, such as CPU or number of instances. - REGION_RESOURCE_STOCKOUT (ERROR): Shown only for regional autoscalers: there is a resource stockout in the chosen region. - SCALING_TARGET_DOES_NOT_EXIST (ERROR): The target to be scaled does not exist. - UNSUPPORTED_MAX_RATE_LOAD_BALANCING_CONFIGURATION (ERROR): Autoscaling does not work with an HTTP/S load balancer that has been configured for maxRate. - ZONE_RESOURCE_STOCKOUT (ERROR): For zonal autoscalers: there is a resource stockout in the chosen zone. For regional autoscalers: in at least one of the zones you're using there is a resource stockout. New values might be added in the future. Some of the values might not be available in all API versions.
type AutoscalerStatusDetails_Type int32

const (
	// A value indicating that the enum field is not set.
	AutoscalerStatusDetails_UNDEFINED_TYPE AutoscalerStatusDetails_Type = 0
	// All instances in the instance group are unhealthy (not in RUNNING state).
	AutoscalerStatusDetails_ALL_INSTANCES_UNHEALTHY AutoscalerStatusDetails_Type = 404965477
	// There is no backend service attached to the instance group.
	AutoscalerStatusDetails_BACKEND_SERVICE_DOES_NOT_EXIST AutoscalerStatusDetails_Type = 191417626
	// Autoscaler recommends a size greater than maxNumReplicas.
	AutoscalerStatusDetails_CAPPED_AT_MAX_NUM_REPLICAS AutoscalerStatusDetails_Type = 518617
	// The custom metric samples are not exported often enough to be a credible base for autoscaling.
	AutoscalerStatusDetails_CUSTOM_METRIC_DATA_POINTS_TOO_SPARSE AutoscalerStatusDetails_Type = 328964659
	// The custom metric that was specified does not exist or does not have the necessary labels.
	AutoscalerStatusDetails_CUSTOM_METRIC_INVALID AutoscalerStatusDetails_Type = 204430550
	// The minNumReplicas is equal to maxNumReplicas. This means the autoscaler cannot add or remove instances from the instance group.
	AutoscalerStatusDetails_MIN_EQUALS_MAX AutoscalerStatusDetails_Type = 2821361
	// The autoscaler did not receive any data from the custom metric configured for autoscaling.
	AutoscalerStatusDetails_MISSING_CUSTOM_METRIC_DATA_POINTS AutoscalerStatusDetails_Type = 94885086
	// The autoscaler is configured to scale based on a load balancing signal but the instance group has not received any requests from the load balancer.
	AutoscalerStatusDetails_MISSING_LOAD_BALANCING_DATA_POINTS AutoscalerStatusDetails_Type = 509858898
	// Autoscaling is turned off. The number of instances in the group won't change automatically. The autoscaling configuration is preserved.
	AutoscalerStatusDetails_MODE_OFF AutoscalerStatusDetails_Type = 164169907
	// Autoscaling is in the "Autoscale only scale out" mode. Instances in the group will be only added.
	AutoscalerStatusDetails_MODE_ONLY_SCALE_OUT AutoscalerStatusDetails_Type = 3840994
	// Autoscaling is in the "Autoscale only out" mode. Instances in the group will be only added.
	AutoscalerStatusDetails_MODE_ONLY_UP AutoscalerStatusDetails_Type = 100969842
	// The instance group cannot be autoscaled because it has more than one backend service attached to it.
	AutoscalerStatusDetails_MORE_THAN_ONE_BACKEND_SERVICE AutoscalerStatusDetails_Type = 151922141
	// There is insufficient quota for the necessary resources, such as CPU or number of instances.
	AutoscalerStatusDetails_NOT_ENOUGH_QUOTA_AVAILABLE AutoscalerStatusDetails_Type = 403101631
	// Showed only for regional autoscalers: there is a resource stockout in the chosen region.
	AutoscalerStatusDetails_REGION_RESOURCE_STOCKOUT AutoscalerStatusDetails_Type = 528622846
	// The target to be scaled does not exist.
	AutoscalerStatusDetails_SCALING_TARGET_DOES_NOT_EXIST AutoscalerStatusDetails_Type = 122636699
	// For some scaling schedules minRequiredReplicas is greater than maxNumReplicas. Autoscaler always recommends at most maxNumReplicas instances.
	AutoscalerStatusDetails_SCHEDULED_INSTANCES_GREATER_THAN_AUTOSCALER_MAX AutoscalerStatusDetails_Type = 29275586
	// For some scaling schedules minRequiredReplicas is less than minNumReplicas. Autoscaler always recommends at least minNumReplicas instances.
	AutoscalerStatusDetails_SCHEDULED_INSTANCES_LESS_THAN_AUTOSCALER_MIN AutoscalerStatusDetails_Type = 398287669
	AutoscalerStatusDetails_UNKNOWN                                      AutoscalerStatusDetails_Type = 433141802
	// Autoscaling does not work with an HTTP/S load balancer that has been configured for maxRate.
	AutoscalerStatusDetails_UNSUPPORTED_MAX_RATE_LOAD_BALANCING_CONFIGURATION AutoscalerStatusDetails_Type = 330845009
	// For zonal autoscalers: there is a resource stockout in the chosen zone. For regional autoscalers: in at least one of the zones you're using there is a resource stockout.
	AutoscalerStatusDetails_ZONE_RESOURCE_STOCKOUT AutoscalerStatusDetails_Type = 210200502
)

// Enum value maps for AutoscalerStatusDetails_Type.
var (
	AutoscalerStatusDetails_Type_name = map[int32]string{
		0:         "UNDEFINED_TYPE",
		404965477: "ALL_INSTANCES_UNHEALTHY",
		191417626: "BACKEND_SERVICE_DOES_NOT_EXIST",
		518617:    "CAPPED_AT_MAX_NUM_REPLICAS",
		328964659: "CUSTOM_METRIC_DATA_POINTS_TOO_SPARSE",
		204430550: "CUSTOM_METRIC_INVALID",
		2821361:   "MIN_EQUALS_MAX",
		94885086:  "MISSING_CUSTOM_METRIC_DATA_POINTS",
		509858898: "MISSING_LOAD_BALANCING_DATA_POINTS",
		164169907: "MODE_OFF",
		3840994:   "MODE_ONLY_SCALE_OUT",
		100969842: "MODE_ONLY_UP",
		151922141: "MORE_THAN_ONE_BACKEND_SERVICE",
		403101631: "NOT_ENOUGH_QUOTA_AVAILABLE",
		528622846: "REGION_RESOURCE_STOCKOUT",
		122636699: "SCALING_TARGET_DOES_NOT_EXIST",
		29275586:  "SCHEDULED_INSTANCES_GREATER_THAN_AUTOSCALER_MAX",
		398287669: "SCHEDULED_INSTANCES_LESS_THAN_AUTOSCALER_MIN",
		433141802: "UNKNOWN",
		330845009: "UNSUPPORTED_MAX_RATE_LOAD_BALANCING_CONFIGURATION",
		210200502: "ZONE_RESOURCE_STOCKOUT",
	}
	AutoscalerStatusDetails_Type_value = map[string]int32{
		"UNDEFINED_TYPE":                                  0,
		"ALL_INSTANCES_UNHEALTHY":                         404965477,
		"BACKEND_SERVICE_DOES_NOT_EXIST":                  191417626,
		"CAPPED_AT_MAX_NUM_REPLICAS":                      518617,
		"CUSTOM_METRIC_DATA_POINTS_TOO_SPARSE":            328964659,
		"CUSTOM_METRIC_INVALID":                           204430550,
		"MIN_EQUALS_MAX":                                  2821361,
		"MISSING_CUSTOM_METRIC_DATA_POINTS":               94885086,
		"MISSING_LOAD_BALANCING_DATA_POINTS":              509858898,
		"MODE_OFF":                                        164169907,
		"MODE_ONLY_SCALE_OUT":                             3840994,
		"MODE_ONLY_UP":                                    100969842,
		"MORE_THAN_ONE_BACKEND_SERVICE":                   151922141,
		"NOT_ENOUGH_QUOTA_AVAILABLE":                      403101631,
		"REGION_RESOURCE_STOCKOUT":                        528622846,
		"SCALING_TARGET_DOES_NOT_EXIST":                   122636699,
		"SCHEDULED_INSTANCES_GREATER_THAN_AUTOSCALER_MAX": 29275586,
		"SCHEDULED_INSTANCES_LESS_THAN_AUTOSCALER_MIN":    398287669,
		"UNKNOWN": 433141802,
		"UNSUPPORTED_MAX_RATE_LOAD_BALANCING_CONFIGURATION": 330845009,
		"ZONE_RESOURCE_STOCKOUT":                            210200502,
	}
)

func (x AutoscalerStatusDetails_Type) Enum() *AutoscalerStatusDetails_Type {
	p := new(AutoscalerStatusDetails_Type)
	*p = x
	return p
}

func (x AutoscalerStatusDetails_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AutoscalerStatusDetails_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[18].Descriptor()
}

func (AutoscalerStatusDetails_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[18]
}

func (x AutoscalerStatusDetails_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AutoscalerStatusDetails_Type.Descriptor instead.
func (AutoscalerStatusDetails_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{93, 0}
}

// Defines operating mode for this policy.
type AutoscalingPolicy_Mode int32

const (
	// A value indicating that the enum field is not set.
	AutoscalingPolicy_UNDEFINED_MODE AutoscalingPolicy_Mode = 0
	// Do not automatically scale the MIG in or out. The recommended_size field contains the size of MIG that would be set if the actuation mode was enabled.
	AutoscalingPolicy_OFF AutoscalingPolicy_Mode = 78159
	// Automatically scale the MIG in and out according to the policy.
	AutoscalingPolicy_ON AutoscalingPolicy_Mode = 2527
	// Automatically create VMs according to the policy, but do not scale the MIG in.
	AutoscalingPolicy_ONLY_SCALE_OUT AutoscalingPolicy_Mode = 152713670
	// Automatically create VMs according to the policy, but do not scale the MIG in.
	AutoscalingPolicy_ONLY_UP AutoscalingPolicy_Mode = 478095374
)

// Enum value maps for AutoscalingPolicy_Mode.
var (
	AutoscalingPolicy_Mode_name = map[int32]string{
		0:         "UNDEFINED_MODE",
		78159:     "OFF",
		2527:      "ON",
		152713670: "ONLY_SCALE_OUT",
		478095374: "ONLY_UP",
	}
	AutoscalingPolicy_Mode_value = map[string]int32{
		"UNDEFINED_MODE": 0,
		"OFF":            78159,
		"ON":             2527,
		"ONLY_SCALE_OUT": 152713670,
		"ONLY_UP":        478095374,
	}
)

func (x AutoscalingPolicy_Mode) Enum() *AutoscalingPolicy_Mode {
	p := new(AutoscalingPolicy_Mode)
	*p = x
	return p
}

func (x AutoscalingPolicy_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AutoscalingPolicy_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[19].Descriptor()
}

func (AutoscalingPolicy_Mode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[19]
}

func (x AutoscalingPolicy_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AutoscalingPolicy_Mode.Descriptor instead.
func (AutoscalingPolicy_Mode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{95, 0}
}

// Indicates whether predictive autoscaling based on CPU metric is enabled. Valid values are: * NONE (default). No predictive method is used. The autoscaler scales the group to meet current demand based on real-time metrics. * OPTIMIZE_AVAILABILITY. Predictive autoscaling improves availability by monitoring daily and weekly load patterns and scaling out ahead of anticipated demand.
type AutoscalingPolicyCpuUtilization_PredictiveMethod int32

const (
	// A value indicating that the enum field is not set.
	AutoscalingPolicyCpuUtilization_UNDEFINED_PREDICTIVE_METHOD AutoscalingPolicyCpuUtilization_PredictiveMethod = 0
	// No predictive method is used. The autoscaler scales the group to meet current demand based on real-time metrics
	AutoscalingPolicyCpuUtilization_NONE AutoscalingPolicyCpuUtilization_PredictiveMethod = 2402104
	// Predictive autoscaling improves availability by monitoring daily and weekly load patterns and scaling out ahead of anticipated demand.
	AutoscalingPolicyCpuUtilization_OPTIMIZE_AVAILABILITY AutoscalingPolicyCpuUtilization_PredictiveMethod = 11629437
)

// Enum value maps for AutoscalingPolicyCpuUtilization_PredictiveMethod.
var (
	AutoscalingPolicyCpuUtilization_PredictiveMethod_name = map[int32]string{
		0:        "UNDEFINED_PREDICTIVE_METHOD",
		2402104:  "NONE",
		11629437: "OPTIMIZE_AVAILABILITY",
	}
	AutoscalingPolicyCpuUtilization_PredictiveMethod_value = map[string]int32{
		"UNDEFINED_PREDICTIVE_METHOD": 0,
		"NONE":                        2402104,
		"OPTIMIZE_AVAILABILITY":       11629437,
	}
)

func (x AutoscalingPolicyCpuUtilization_PredictiveMethod) Enum() *AutoscalingPolicyCpuUtilization_PredictiveMethod {
	p := new(AutoscalingPolicyCpuUtilization_PredictiveMethod)
	*p = x
	return p
}

func (x AutoscalingPolicyCpuUtilization_PredictiveMethod) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AutoscalingPolicyCpuUtilization_PredictiveMethod) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[20].Descriptor()
}

func (AutoscalingPolicyCpuUtilization_PredictiveMethod) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[20]
}

func (x AutoscalingPolicyCpuUtilization_PredictiveMethod) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AutoscalingPolicyCpuUtilization_PredictiveMethod.Descriptor instead.
func (AutoscalingPolicyCpuUtilization_PredictiveMethod) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{96, 0}
}

// Defines how target utilization value is expressed for a Stackdriver Monitoring metric. Either GAUGE, DELTA_PER_SECOND, or DELTA_PER_MINUTE.
type AutoscalingPolicyCustomMetricUtilization_UtilizationTargetType int32

const (
	// A value indicating that the enum field is not set.
	AutoscalingPolicyCustomMetricUtilization_UNDEFINED_UTILIZATION_TARGET_TYPE AutoscalingPolicyCustomMetricUtilization_UtilizationTargetType = 0
	// Sets the utilization target value for a cumulative or delta metric, expressed as the rate of growth per minute.
	AutoscalingPolicyCustomMetricUtilization_DELTA_PER_MINUTE AutoscalingPolicyCustomMetricUtilization_UtilizationTargetType = 87432861
	// Sets the utilization target value for a cumulative or delta metric, expressed as the rate of growth per second.
	AutoscalingPolicyCustomMetricUtilization_DELTA_PER_SECOND AutoscalingPolicyCustomMetricUtilization_UtilizationTargetType = 255180029
	// Sets the utilization target value for a gauge metric. The autoscaler will collect the average utilization of the virtual machines from the last couple of minutes, and compare the value to the utilization target value to perform autoscaling.
	AutoscalingPolicyCustomMetricUtilization_GAUGE AutoscalingPolicyCustomMetricUtilization_UtilizationTargetType = 67590361
)

// Enum value maps for AutoscalingPolicyCustomMetricUtilization_UtilizationTargetType.
var (
	AutoscalingPolicyCustomMetricUtilization_UtilizationTargetType_name = map[int32]string{
		0:         "UNDEFINED_UTILIZATION_TARGET_TYPE",
		87432861:  "DELTA_PER_MINUTE",
		255180029: "DELTA_PER_SECOND",
		67590361:  "GAUGE",
	}
	AutoscalingPolicyCustomMetricUtilization_UtilizationTargetType_value = map[string]int32{
		"UNDEFINED_UTILIZATION_TARGET_TYPE": 0,
		"DELTA_PER_MINUTE":                  87432861,
		"DELTA_PER_SECOND":                  255180029,
		"GAUGE":                             67590361,
	}
)

func (x AutoscalingPolicyCustomMetricUtilization_UtilizationTargetType) Enum() *AutoscalingPolicyCustomMetricUtilization_UtilizationTargetType {
	p := new(AutoscalingPolicyCustomMetricUtilization_UtilizationTargetType)
	*p = x
	return p
}

func (x AutoscalingPolicyCustomMetricUtilization_UtilizationTargetType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AutoscalingPolicyCustomMetricUtilization_UtilizationTargetType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[21].Descriptor()
}

func (AutoscalingPolicyCustomMetricUtilization_UtilizationTargetType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[21]
}

func (x AutoscalingPolicyCustomMetricUtilization_UtilizationTargetType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AutoscalingPolicyCustomMetricUtilization_UtilizationTargetType.Descriptor instead.
func (AutoscalingPolicyCustomMetricUtilization_UtilizationTargetType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{97, 0}
}

// Specifies how to determine whether the backend of a load balancer can handle additional traffic or is fully loaded. For usage guidelines, see Connection balancing mode. Backends must use compatible balancing modes. For more information, see Supported balancing modes and target capacity settings and Restrictions and guidance for instance groups. Note: Currently, if you use the API to configure incompatible balancing modes, the configuration might be accepted even though it has no impact and is ignored. Specifically, Backend.maxUtilization is ignored when Backend.balancingMode is RATE. In the future, this incompatible combination will be rejected.
type Backend_BalancingMode int32

const (
	// A value indicating that the enum field is not set.
	Backend_UNDEFINED_BALANCING_MODE Backend_BalancingMode = 0
	// Balance based on the number of simultaneous connections.
	Backend_CONNECTION Backend_BalancingMode = 246311646
	// Balance based on requests per second (RPS).
	Backend_RATE Backend_BalancingMode = 2508000
	// Balance based on the backend utilization.
	Backend_UTILIZATION Backend_BalancingMode = 157008386
)

// Enum value maps for Backend_BalancingMode.
var (
	Backend_BalancingMode_name = map[int32]string{
		0:         "UNDEFINED_BALANCING_MODE",
		246311646: "CONNECTION",
		2508000:   "RATE",
		157008386: "UTILIZATION",
	}
	Backend_BalancingMode_value = map[string]int32{
		"UNDEFINED_BALANCING_MODE": 0,
		"CONNECTION":               246311646,
		"RATE":                     2508000,
		"UTILIZATION":              157008386,
	}
)

func (x Backend_BalancingMode) Enum() *Backend_BalancingMode {
	p := new(Backend_BalancingMode)
	*p = x
	return p
}

func (x Backend_BalancingMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Backend_BalancingMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[22].Descriptor()
}

func (Backend_BalancingMode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[22]
}

func (x Backend_BalancingMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Backend_BalancingMode.Descriptor instead.
func (Backend_BalancingMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{101, 0}
}

// Compress text responses using Brotli or gzip compression, based on the client's Accept-Encoding header.
type BackendBucket_CompressionMode int32

const (
	// A value indicating that the enum field is not set.
	BackendBucket_UNDEFINED_COMPRESSION_MODE BackendBucket_CompressionMode = 0
	// Automatically uses the best compression based on the Accept-Encoding header sent by the client.
	BackendBucket_AUTOMATIC BackendBucket_CompressionMode = 165298699
	// Disables compression. Existing compressed responses cached by Cloud CDN will not be served to clients.
	BackendBucket_DISABLED BackendBucket_CompressionMode = 516696700
)

// Enum value maps for BackendBucket_CompressionMode.
var (
	BackendBucket_CompressionMode_name = map[int32]string{
		0:         "UNDEFINED_COMPRESSION_MODE",
		165298699: "AUTOMATIC",
		516696700: "DISABLED",
	}
	BackendBucket_CompressionMode_value = map[string]int32{
		"UNDEFINED_COMPRESSION_MODE": 0,
		"AUTOMATIC":                  165298699,
		"DISABLED":                   516696700,
	}
)

func (x BackendBucket_CompressionMode) Enum() *BackendBucket_CompressionMode {
	p := new(BackendBucket_CompressionMode)
	*p = x
	return p
}

func (x BackendBucket_CompressionMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackendBucket_CompressionMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[23].Descriptor()
}

func (BackendBucket_CompressionMode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[23]
}

func (x BackendBucket_CompressionMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackendBucket_CompressionMode.Descriptor instead.
func (BackendBucket_CompressionMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{102, 0}
}

// Specifies the cache setting for all responses from this backend. The possible values are: USE_ORIGIN_HEADERS Requires the origin to set valid caching headers to cache content. Responses without these headers will not be cached at Google's edge, and will require a full trip to the origin on every request, potentially impacting performance and increasing load on the origin server. FORCE_CACHE_ALL Cache all content, ignoring any "private", "no-store" or "no-cache" directives in Cache-Control response headers. Warning: this may result in Cloud CDN caching private, per-user (user identifiable) content. CACHE_ALL_STATIC Automatically cache static content, including common image formats, media (video and audio), and web assets (JavaScript and CSS). Requests and responses that are marked as uncacheable, as well as dynamic content (including HTML), will not be cached.
type BackendBucketCdnPolicy_CacheMode int32

const (
	// A value indicating that the enum field is not set.
	BackendBucketCdnPolicy_UNDEFINED_CACHE_MODE BackendBucketCdnPolicy_CacheMode = 0
	// Automatically cache static content, including common image formats, media (video and audio), and web assets (JavaScript and CSS). Requests and responses that are marked as uncacheable, as well as dynamic content (including HTML), will not be cached.
	BackendBucketCdnPolicy_CACHE_ALL_STATIC BackendBucketCdnPolicy_CacheMode = 355027945
	// Cache all content, ignoring any "private", "no-store" or "no-cache" directives in Cache-Control response headers. Warning: this may result in Cloud CDN caching private, per-user (user identifiable) content.
	BackendBucketCdnPolicy_FORCE_CACHE_ALL    BackendBucketCdnPolicy_CacheMode = 486026928
	BackendBucketCdnPolicy_INVALID_CACHE_MODE BackendBucketCdnPolicy_CacheMode = 381295560
	// Requires the origin to set valid caching headers to cache content. Responses without these headers will not be cached at Google's edge, and will require a full trip to the origin on every request, potentially impacting performance and increasing load on the origin server.
	BackendBucketCdnPolicy_USE_ORIGIN_HEADERS BackendBucketCdnPolicy_CacheMode = 55380261
)

// Enum value maps for BackendBucketCdnPolicy_CacheMode.
var (
	BackendBucketCdnPolicy_CacheMode_name = map[int32]string{
		0:         "UNDEFINED_CACHE_MODE",
		355027945: "CACHE_ALL_STATIC",
		486026928: "FORCE_CACHE_ALL",
		381295560: "INVALID_CACHE_MODE",
		55380261:  "USE_ORIGIN_HEADERS",
	}
	BackendBucketCdnPolicy_CacheMode_value = map[string]int32{
		"UNDEFINED_CACHE_MODE": 0,
		"CACHE_ALL_STATIC":     355027945,
		"FORCE_CACHE_ALL":      486026928,
		"INVALID_CACHE_MODE":   381295560,
		"USE_ORIGIN_HEADERS":   55380261,
	}
)

func (x BackendBucketCdnPolicy_CacheMode) Enum() *BackendBucketCdnPolicy_CacheMode {
	p := new(BackendBucketCdnPolicy_CacheMode)
	*p = x
	return p
}

func (x BackendBucketCdnPolicy_CacheMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackendBucketCdnPolicy_CacheMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[24].Descriptor()
}

func (BackendBucketCdnPolicy_CacheMode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[24]
}

func (x BackendBucketCdnPolicy_CacheMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackendBucketCdnPolicy_CacheMode.Descriptor instead.
func (BackendBucketCdnPolicy_CacheMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{103, 0}
}

// Compress text responses using Brotli or gzip compression, based on the client's Accept-Encoding header.
type BackendService_CompressionMode int32

const (
	// A value indicating that the enum field is not set.
	BackendService_UNDEFINED_COMPRESSION_MODE BackendService_CompressionMode = 0
	// Automatically uses the best compression based on the Accept-Encoding header sent by the client.
	BackendService_AUTOMATIC BackendService_CompressionMode = 165298699
	// Disables compression. Existing compressed responses cached by Cloud CDN will not be served to clients.
	BackendService_DISABLED BackendService_CompressionMode = 516696700
)

// Enum value maps for BackendService_CompressionMode.
var (
	BackendService_CompressionMode_name = map[int32]string{
		0:         "UNDEFINED_COMPRESSION_MODE",
		165298699: "AUTOMATIC",
		516696700: "DISABLED",
	}
	BackendService_CompressionMode_value = map[string]int32{
		"UNDEFINED_COMPRESSION_MODE": 0,
		"AUTOMATIC":                  165298699,
		"DISABLED":                   516696700,
	}
)

func (x BackendService_CompressionMode) Enum() *BackendService_CompressionMode {
	p := new(BackendService_CompressionMode)
	*p = x
	return p
}

func (x BackendService_CompressionMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackendService_CompressionMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[25].Descriptor()
}

func (BackendService_CompressionMode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[25]
}

func (x BackendService_CompressionMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackendService_CompressionMode.Descriptor instead.
func (BackendService_CompressionMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{108, 0}
}

// Specifies the load balancer type. A backend service created for one type of load balancer cannot be used with another. For more information, refer to Choosing a load balancer.
type BackendService_LoadBalancingScheme int32

const (
	// A value indicating that the enum field is not set.
	BackendService_UNDEFINED_LOAD_BALANCING_SCHEME BackendService_LoadBalancingScheme = 0
	// Signifies that this will be used for external HTTP(S), SSL Proxy, TCP Proxy, or Network Load Balancing
	BackendService_EXTERNAL BackendService_LoadBalancingScheme = 35607499
	// Signifies that this will be used for External Managed HTTP(S) Load Balancing.
	BackendService_EXTERNAL_MANAGED BackendService_LoadBalancingScheme = 512006923
	// Signifies that this will be used for Internal TCP/UDP Load Balancing.
	BackendService_INTERNAL BackendService_LoadBalancingScheme = 279295677
	// Signifies that this will be used for Internal HTTP(S) Load Balancing.
	BackendService_INTERNAL_MANAGED BackendService_LoadBalancingScheme = 37350397
	// Signifies that this will be used by Traffic Director.
	BackendService_INTERNAL_SELF_MANAGED         BackendService_LoadBalancingScheme = 236211150
	BackendService_INVALID_LOAD_BALANCING_SCHEME BackendService_LoadBalancingScheme = 275352060
)

// Enum value maps for BackendService_LoadBalancingScheme.
var (
	BackendService_LoadBalancingScheme_name = map[int32]string{
		0:         "UNDEFINED_LOAD_BALANCING_SCHEME",
		35607499:  "EXTERNAL",
		512006923: "EXTERNAL_MANAGED",
		279295677: "INTERNAL",
		37350397:  "INTERNAL_MANAGED",
		236211150: "INTERNAL_SELF_MANAGED",
		275352060: "INVALID_LOAD_BALANCING_SCHEME",
	}
	BackendService_LoadBalancingScheme_value = map[string]int32{
		"UNDEFINED_LOAD_BALANCING_SCHEME": 0,
		"EXTERNAL":                        35607499,
		"EXTERNAL_MANAGED":                512006923,
		"INTERNAL":                        279295677,
		"INTERNAL_MANAGED":                37350397,
		"INTERNAL_SELF_MANAGED":           236211150,
		"INVALID_LOAD_BALANCING_SCHEME":   275352060,
	}
)

func (x BackendService_LoadBalancingScheme) Enum() *BackendService_LoadBalancingScheme {
	p := new(BackendService_LoadBalancingScheme)
	*p = x
	return p
}

func (x BackendService_LoadBalancingScheme) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackendService_LoadBalancingScheme) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[26].Descriptor()
}

func (BackendService_LoadBalancingScheme) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[26]
}

func (x BackendService_LoadBalancingScheme) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackendService_LoadBalancingScheme.Descriptor instead.
func (BackendService_LoadBalancingScheme) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{108, 1}
}

// The load balancing algorithm used within the scope of the locality. The possible values are: - ROUND_ROBIN: This is a simple policy in which each healthy backend is selected in round robin order. This is the default. - LEAST_REQUEST: An O(1) algorithm which selects two random healthy hosts and picks the host which has fewer active requests. - RING_HASH: The ring/modulo hash load balancer implements consistent hashing to backends. The algorithm has the property that the addition/removal of a host from a set of N hosts only affects 1/N of the requests. - RANDOM: The load balancer selects a random healthy host. - ORIGINAL_DESTINATION: Backend host is selected based on the client connection metadata, i.e., connections are opened to the same address as the destination address of the incoming connection before the connection was redirected to the load balancer. - MAGLEV: used as a drop in replacement for the ring hash load balancer. Maglev is not as stable as ring hash but has faster table lookup build times and host selection times. For more information about Maglev, see https://ai.google/research/pubs/pub44824 This field is applicable to either: - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED. - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED. If sessionAffinity is not NONE, and this field is not set to MAGLEV or RING_HASH, session affinity settings will not take effect. Only ROUND_ROBIN and RING_HASH are supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
type BackendService_LocalityLbPolicy int32

const (
	// A value indicating that the enum field is not set.
	BackendService_UNDEFINED_LOCALITY_LB_POLICY BackendService_LocalityLbPolicy = 0
	BackendService_INVALID_LB_POLICY            BackendService_LocalityLbPolicy = 323318707
	// An O(1) algorithm which selects two random healthy hosts and picks the host which has fewer active requests.
	BackendService_LEAST_REQUEST BackendService_LocalityLbPolicy = 46604921
	// This algorithm implements consistent hashing to backends. Maglev can be used as a drop in replacement for the ring hash load balancer. Maglev is not as stable as ring hash but has faster table lookup build times and host selection times. For more information about Maglev, see https://ai.google/research/pubs/pub44824
	BackendService_MAGLEV BackendService_LocalityLbPolicy = 119180266
	// Backend host is selected based on the client connection metadata, i.e., connections are opened to the same address as the destination address of the incoming connection before the connection was redirected to the load balancer.
	BackendService_ORIGINAL_DESTINATION BackendService_LocalityLbPolicy = 166297216
	// The load balancer selects a random healthy host.
	BackendService_RANDOM BackendService_LocalityLbPolicy = 262527171
	// The ring/modulo hash load balancer implements consistent hashing to backends. The algorithm has the property that the addition/removal of a host from a set of N hosts only affects 1/N of the requests.
	BackendService_RING_HASH BackendService_LocalityLbPolicy = 432795069
	// This is a simple policy in which each healthy backend is selected in round robin order. This is the default.
	BackendService_ROUND_ROBIN BackendService_LocalityLbPolicy = 153895801
	// Per-instance weighted Load Balancing via health check reported weights. If set, the Backend Service must configure a non legacy HTTP-based Health Check, and health check replies are expected to contain non-standard HTTP response header field X-Load-Balancing-Endpoint-Weight to specify the per-instance weights. If set, Load Balancing is weighted based on the per-instance weights reported in the last processed health check replies, as long as every instance either reported a valid weight or had UNAVAILABLE_WEIGHT. Otherwise, Load Balancing remains equal-weight. This option is only supported in Network Load Balancing.
	BackendService_WEIGHTED_MAGLEV BackendService_LocalityLbPolicy = 254930962
)

// Enum value maps for BackendService_LocalityLbPolicy.
var (
	BackendService_LocalityLbPolicy_name = map[int32]string{
		0:         "UNDEFINED_LOCALITY_LB_POLICY",
		323318707: "INVALID_LB_POLICY",
		46604921:  "LEAST_REQUEST",
		119180266: "MAGLEV",
		166297216: "ORIGINAL_DESTINATION",
		262527171: "RANDOM",
		432795069: "RING_HASH",
		153895801: "ROUND_ROBIN",
		254930962: "WEIGHTED_MAGLEV",
	}
	BackendService_LocalityLbPolicy_value = map[string]int32{
		"UNDEFINED_LOCALITY_LB_POLICY": 0,
		"INVALID_LB_POLICY":            323318707,
		"LEAST_REQUEST":                46604921,
		"MAGLEV":                       119180266,
		"ORIGINAL_DESTINATION":         166297216,
		"RANDOM":                       262527171,
		"RING_HASH":                    432795069,
		"ROUND_ROBIN":                  153895801,
		"WEIGHTED_MAGLEV":              254930962,
	}
)

func (x BackendService_LocalityLbPolicy) Enum() *BackendService_LocalityLbPolicy {
	p := new(BackendService_LocalityLbPolicy)
	*p = x
	return p
}

func (x BackendService_LocalityLbPolicy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackendService_LocalityLbPolicy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[27].Descriptor()
}

func (BackendService_LocalityLbPolicy) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[27]
}

func (x BackendService_LocalityLbPolicy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackendService_LocalityLbPolicy.Descriptor instead.
func (BackendService_LocalityLbPolicy) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{108, 2}
}

// The protocol this BackendService uses to communicate with backends. Possible values are HTTP, HTTPS, HTTP2, TCP, SSL, UDP or GRPC. depending on the chosen load balancer or Traffic Director configuration. Refer to the documentation for the load balancers or for Traffic Director for more information. Must be set to GRPC when the backend service is referenced by a URL map that is bound to target gRPC proxy.
type BackendService_Protocol int32

const (
	// A value indicating that the enum field is not set.
	BackendService_UNDEFINED_PROTOCOL BackendService_Protocol = 0
	// gRPC (available for Traffic Director).
	BackendService_GRPC BackendService_Protocol = 2196510
	BackendService_HTTP BackendService_Protocol = 2228360
	// HTTP/2 with SSL.
	BackendService_HTTP2 BackendService_Protocol = 69079210
	BackendService_HTTPS BackendService_Protocol = 69079243
	// TCP proxying with SSL.
	BackendService_SSL BackendService_Protocol = 82412
	// TCP proxying or TCP pass-through.
	BackendService_TCP BackendService_Protocol = 82881
	// UDP.
	BackendService_UDP BackendService_Protocol = 83873
	// If a Backend Service has UNSPECIFIED as its protocol, it can be used with any L3/L4 Forwarding Rules.
	BackendService_UNSPECIFIED BackendService_Protocol = 526786327
)

// Enum value maps for BackendService_Protocol.
var (
	BackendService_Protocol_name = map[int32]string{
		0:         "UNDEFINED_PROTOCOL",
		2196510:   "GRPC",
		2228360:   "HTTP",
		69079210:  "HTTP2",
		69079243:  "HTTPS",
		82412:     "SSL",
		82881:     "TCP",
		83873:     "UDP",
		526786327: "UNSPECIFIED",
	}
	BackendService_Protocol_value = map[string]int32{
		"UNDEFINED_PROTOCOL": 0,
		"GRPC":               2196510,
		"HTTP":               2228360,
		"HTTP2":              69079210,
		"HTTPS":              69079243,
		"SSL":                82412,
		"TCP":                82881,
		"UDP":                83873,
		"UNSPECIFIED":        526786327,
	}
)

func (x BackendService_Protocol) Enum() *BackendService_Protocol {
	p := new(BackendService_Protocol)
	*p = x
	return p
}

func (x BackendService_Protocol) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackendService_Protocol) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[28].Descriptor()
}

func (BackendService_Protocol) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[28]
}

func (x BackendService_Protocol) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackendService_Protocol.Descriptor instead.
func (BackendService_Protocol) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{108, 3}
}

// Type of session affinity to use. The default is NONE. Only NONE and HEADER_FIELD are supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true. For more details, see: [Session Affinity](https://cloud.google.com/load-balancing/docs/backend-service#session_affinity).
type BackendService_SessionAffinity int32

const (
	// A value indicating that the enum field is not set.
	BackendService_UNDEFINED_SESSION_AFFINITY BackendService_SessionAffinity = 0
	// 2-tuple hash on packet's source and destination IP addresses. Connections from the same source IP address to the same destination IP address will be served by the same backend VM while that VM remains healthy.
	BackendService_CLIENT_IP BackendService_SessionAffinity = 345665051
	// 1-tuple hash only on packet's source IP address. Connections from the same source IP address will be served by the same backend VM while that VM remains healthy. This option can only be used for Internal TCP/UDP Load Balancing.
	BackendService_CLIENT_IP_NO_DESTINATION BackendService_SessionAffinity = 106122516
	// 5-tuple hash on packet's source and destination IP addresses, IP protocol, and source and destination ports. Connections for the same IP protocol from the same source IP address and port to the same destination IP address and port will be served by the same backend VM while that VM remains healthy. This option cannot be used for HTTP(S) load balancing.
	BackendService_CLIENT_IP_PORT_PROTO BackendService_SessionAffinity = 221722926
	// 3-tuple hash on packet's source and destination IP addresses, and IP protocol. Connections for the same IP protocol from the same source IP address to the same destination IP address will be served by the same backend VM while that VM remains healthy. This option cannot be used for HTTP(S) load balancing.
	BackendService_CLIENT_IP_PROTO BackendService_SessionAffinity = 25322148
	// Hash based on a cookie generated by the L7 loadbalancer. Only valid for HTTP(S) load balancing.
	BackendService_GENERATED_COOKIE BackendService_SessionAffinity = 370321204
	// The hash is based on a user specified header field.
	BackendService_HEADER_FIELD BackendService_SessionAffinity = 200737960
	// The hash is based on a user provided cookie.
	BackendService_HTTP_COOKIE BackendService_SessionAffinity = 494981627
	// No session affinity. Connections from the same client IP may go to any instance in the pool.
	BackendService_NONE BackendService_SessionAffinity = 2402104
)

// Enum value maps for BackendService_SessionAffinity.
var (
	BackendService_SessionAffinity_name = map[int32]string{
		0:         "UNDEFINED_SESSION_AFFINITY",
		345665051: "CLIENT_IP",
		106122516: "CLIENT_IP_NO_DESTINATION",
		221722926: "CLIENT_IP_PORT_PROTO",
		25322148:  "CLIENT_IP_PROTO",
		370321204: "GENERATED_COOKIE",
		200737960: "HEADER_FIELD",
		494981627: "HTTP_COOKIE",
		2402104:   "NONE",
	}
	BackendService_SessionAffinity_value = map[string]int32{
		"UNDEFINED_SESSION_AFFINITY": 0,
		"CLIENT_IP":                  345665051,
		"CLIENT_IP_NO_DESTINATION":   106122516,
		"CLIENT_IP_PORT_PROTO":       221722926,
		"CLIENT_IP_PROTO":            25322148,
		"GENERATED_COOKIE":           370321204,
		"HEADER_FIELD":               200737960,
		"HTTP_COOKIE":                494981627,
		"NONE":                       2402104,
	}
)

func (x BackendService_SessionAffinity) Enum() *BackendService_SessionAffinity {
	p := new(BackendService_SessionAffinity)
	*p = x
	return p
}

func (x BackendService_SessionAffinity) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackendService_SessionAffinity) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[29].Descriptor()
}

func (BackendService_SessionAffinity) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[29]
}

func (x BackendService_SessionAffinity) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackendService_SessionAffinity.Descriptor instead.
func (BackendService_SessionAffinity) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{108, 4}
}

// Specifies the cache setting for all responses from this backend. The possible values are: USE_ORIGIN_HEADERS Requires the origin to set valid caching headers to cache content. Responses without these headers will not be cached at Google's edge, and will require a full trip to the origin on every request, potentially impacting performance and increasing load on the origin server. FORCE_CACHE_ALL Cache all content, ignoring any "private", "no-store" or "no-cache" directives in Cache-Control response headers. Warning: this may result in Cloud CDN caching private, per-user (user identifiable) content. CACHE_ALL_STATIC Automatically cache static content, including common image formats, media (video and audio), and web assets (JavaScript and CSS). Requests and responses that are marked as uncacheable, as well as dynamic content (including HTML), will not be cached.
type BackendServiceCdnPolicy_CacheMode int32

const (
	// A value indicating that the enum field is not set.
	BackendServiceCdnPolicy_UNDEFINED_CACHE_MODE BackendServiceCdnPolicy_CacheMode = 0
	// Automatically cache static content, including common image formats, media (video and audio), and web assets (JavaScript and CSS). Requests and responses that are marked as uncacheable, as well as dynamic content (including HTML), will not be cached.
	BackendServiceCdnPolicy_CACHE_ALL_STATIC BackendServiceCdnPolicy_CacheMode = 355027945
	// Cache all content, ignoring any "private", "no-store" or "no-cache" directives in Cache-Control response headers. Warning: this may result in Cloud CDN caching private, per-user (user identifiable) content.
	BackendServiceCdnPolicy_FORCE_CACHE_ALL    BackendServiceCdnPolicy_CacheMode = 486026928
	BackendServiceCdnPolicy_INVALID_CACHE_MODE BackendServiceCdnPolicy_CacheMode = 381295560
	// Requires the origin to set valid caching headers to cache content. Responses without these headers will not be cached at Google's edge, and will require a full trip to the origin on every request, potentially impacting performance and increasing load on the origin server.
	BackendServiceCdnPolicy_USE_ORIGIN_HEADERS BackendServiceCdnPolicy_CacheMode = 55380261
)

// Enum value maps for BackendServiceCdnPolicy_CacheMode.
var (
	BackendServiceCdnPolicy_CacheMode_name = map[int32]string{
		0:         "UNDEFINED_CACHE_MODE",
		355027945: "CACHE_ALL_STATIC",
		486026928: "FORCE_CACHE_ALL",
		381295560: "INVALID_CACHE_MODE",
		55380261:  "USE_ORIGIN_HEADERS",
	}
	BackendServiceCdnPolicy_CacheMode_value = map[string]int32{
		"UNDEFINED_CACHE_MODE": 0,
		"CACHE_ALL_STATIC":     355027945,
		"FORCE_CACHE_ALL":      486026928,
		"INVALID_CACHE_MODE":   381295560,
		"USE_ORIGIN_HEADERS":   55380261,
	}
)

func (x BackendServiceCdnPolicy_CacheMode) Enum() *BackendServiceCdnPolicy_CacheMode {
	p := new(BackendServiceCdnPolicy_CacheMode)
	*p = x
	return p
}

func (x BackendServiceCdnPolicy_CacheMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackendServiceCdnPolicy_CacheMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[30].Descriptor()
}

func (BackendServiceCdnPolicy_CacheMode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[30]
}

func (x BackendServiceCdnPolicy_CacheMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackendServiceCdnPolicy_CacheMode.Descriptor instead.
func (BackendServiceCdnPolicy_CacheMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{110, 0}
}

// Specifies connection persistence when backends are unhealthy. The default value is DEFAULT_FOR_PROTOCOL. If set to DEFAULT_FOR_PROTOCOL, the existing connections persist on unhealthy backends only for connection-oriented protocols (TCP and SCTP) and only if the Tracking Mode is PER_CONNECTION (default tracking mode) or the Session Affinity is configured for 5-tuple. They do not persist for UDP. If set to NEVER_PERSIST, after a backend becomes unhealthy, the existing connections on the unhealthy backend are never persisted on the unhealthy backend. They are always diverted to newly selected healthy backends (unless all backends are unhealthy). If set to ALWAYS_PERSIST, existing connections always persist on unhealthy backends regardless of protocol and session affinity. It is generally not recommended to use this mode overriding the default. For more details, see [Connection Persistence for Network Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-backend-service#connection-persistence) and [Connection Persistence for Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal#connection-persistence).
type BackendServiceConnectionTrackingPolicy_ConnectionPersistenceOnUnhealthyBackends int32

const (
	// A value indicating that the enum field is not set.
	BackendServiceConnectionTrackingPolicy_UNDEFINED_CONNECTION_PERSISTENCE_ON_UNHEALTHY_BACKENDS BackendServiceConnectionTrackingPolicy_ConnectionPersistenceOnUnhealthyBackends = 0
	BackendServiceConnectionTrackingPolicy_ALWAYS_PERSIST                                         BackendServiceConnectionTrackingPolicy_ConnectionPersistenceOnUnhealthyBackends = 38400900
	BackendServiceConnectionTrackingPolicy_DEFAULT_FOR_PROTOCOL                                   BackendServiceConnectionTrackingPolicy_ConnectionPersistenceOnUnhealthyBackends = 145265356
	BackendServiceConnectionTrackingPolicy_NEVER_PERSIST                                          BackendServiceConnectionTrackingPolicy_ConnectionPersistenceOnUnhealthyBackends = 138646241
)

// Enum value maps for BackendServiceConnectionTrackingPolicy_ConnectionPersistenceOnUnhealthyBackends.
var (
	BackendServiceConnectionTrackingPolicy_ConnectionPersistenceOnUnhealthyBackends_name = map[int32]string{
		0:         "UNDEFINED_CONNECTION_PERSISTENCE_ON_UNHEALTHY_BACKENDS",
		38400900:  "ALWAYS_PERSIST",
		145265356: "DEFAULT_FOR_PROTOCOL",
		138646241: "NEVER_PERSIST",
	}
	BackendServiceConnectionTrackingPolicy_ConnectionPersistenceOnUnhealthyBackends_value = map[string]int32{
		"UNDEFINED_CONNECTION_PERSISTENCE_ON_UNHEALTHY_BACKENDS": 0,
		"ALWAYS_PERSIST":       38400900,
		"DEFAULT_FOR_PROTOCOL": 145265356,
		"NEVER_PERSIST":        138646241,
	}
)

func (x BackendServiceConnectionTrackingPolicy_ConnectionPersistenceOnUnhealthyBackends) Enum() *BackendServiceConnectionTrackingPolicy_ConnectionPersistenceOnUnhealthyBackends {
	p := new(BackendServiceConnectionTrackingPolicy_ConnectionPersistenceOnUnhealthyBackends)
	*p = x
	return p
}

func (x BackendServiceConnectionTrackingPolicy_ConnectionPersistenceOnUnhealthyBackends) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackendServiceConnectionTrackingPolicy_ConnectionPersistenceOnUnhealthyBackends) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[31].Descriptor()
}

func (BackendServiceConnectionTrackingPolicy_ConnectionPersistenceOnUnhealthyBackends) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[31]
}

func (x BackendServiceConnectionTrackingPolicy_ConnectionPersistenceOnUnhealthyBackends) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackendServiceConnectionTrackingPolicy_ConnectionPersistenceOnUnhealthyBackends.Descriptor instead.
func (BackendServiceConnectionTrackingPolicy_ConnectionPersistenceOnUnhealthyBackends) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{113, 0}
}

// Specifies the key used for connection tracking. There are two options: - PER_CONNECTION: This is the default mode. The Connection Tracking is performed as per the Connection Key (default Hash Method) for the specific protocol. - PER_SESSION: The Connection Tracking is performed as per the configured Session Affinity. It matches the configured Session Affinity. For more details, see [Tracking Mode for Network Load Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-backend-service#tracking-mode) and [Tracking Mode for Internal TCP/UDP Load Balancing](https://cloud.google.com/load-balancing/docs/internal#tracking-mode).
type BackendServiceConnectionTrackingPolicy_TrackingMode int32

const (
	// A value indicating that the enum field is not set.
	BackendServiceConnectionTrackingPolicy_UNDEFINED_TRACKING_MODE BackendServiceConnectionTrackingPolicy_TrackingMode = 0
	BackendServiceConnectionTrackingPolicy_INVALID_TRACKING_MODE   BackendServiceConnectionTrackingPolicy_TrackingMode = 49234371
	BackendServiceConnectionTrackingPolicy_PER_CONNECTION          BackendServiceConnectionTrackingPolicy_TrackingMode = 85162848
	BackendServiceConnectionTrackingPolicy_PER_SESSION             BackendServiceConnectionTrackingPolicy_TrackingMode = 182099252
)

// Enum value maps for BackendServiceConnectionTrackingPolicy_TrackingMode.
var (
	BackendServiceConnectionTrackingPolicy_TrackingMode_name = map[int32]string{
		0:         "UNDEFINED_TRACKING_MODE",
		49234371:  "INVALID_TRACKING_MODE",
		85162848:  "PER_CONNECTION",
		182099252: "PER_SESSION",
	}
	BackendServiceConnectionTrackingPolicy_TrackingMode_value = map[string]int32{
		"UNDEFINED_TRACKING_MODE": 0,
		"INVALID_TRACKING_MODE":   49234371,
		"PER_CONNECTION":          85162848,
		"PER_SESSION":             182099252,
	}
)

func (x BackendServiceConnectionTrackingPolicy_TrackingMode) Enum() *BackendServiceConnectionTrackingPolicy_TrackingMode {
	p := new(BackendServiceConnectionTrackingPolicy_TrackingMode)
	*p = x
	return p
}

func (x BackendServiceConnectionTrackingPolicy_TrackingMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackendServiceConnectionTrackingPolicy_TrackingMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[32].Descriptor()
}

func (BackendServiceConnectionTrackingPolicy_TrackingMode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[32]
}

func (x BackendServiceConnectionTrackingPolicy_TrackingMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackendServiceConnectionTrackingPolicy_TrackingMode.Descriptor instead.
func (BackendServiceConnectionTrackingPolicy_TrackingMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{113, 1}
}

// The name of a locality load-balancing policy. Valid values include ROUND_ROBIN and, for Java clients, LEAST_REQUEST. For information about these values, see the description of localityLbPolicy. Do not specify the same policy more than once for a backend. If you do, the configuration is rejected.
type BackendServiceLocalityLoadBalancingPolicyConfigPolicy_Name int32

const (
	// A value indicating that the enum field is not set.
	BackendServiceLocalityLoadBalancingPolicyConfigPolicy_UNDEFINED_NAME    BackendServiceLocalityLoadBalancingPolicyConfigPolicy_Name = 0
	BackendServiceLocalityLoadBalancingPolicyConfigPolicy_INVALID_LB_POLICY BackendServiceLocalityLoadBalancingPolicyConfigPolicy_Name = 323318707
	// An O(1) algorithm which selects two random healthy hosts and picks the host which has fewer active requests.
	BackendServiceLocalityLoadBalancingPolicyConfigPolicy_LEAST_REQUEST BackendServiceLocalityLoadBalancingPolicyConfigPolicy_Name = 46604921
	// This algorithm implements consistent hashing to backends. Maglev can be used as a drop in replacement for the ring hash load balancer. Maglev is not as stable as ring hash but has faster table lookup build times and host selection times. For more information about Maglev, see https://ai.google/research/pubs/pub44824
	BackendServiceLocalityLoadBalancingPolicyConfigPolicy_MAGLEV BackendServiceLocalityLoadBalancingPolicyConfigPolicy_Name = 119180266
	// Backend host is selected based on the client connection metadata, i.e., connections are opened to the same address as the destination address of the incoming connection before the connection was redirected to the load balancer.
	BackendServiceLocalityLoadBalancingPolicyConfigPolicy_ORIGINAL_DESTINATION BackendServiceLocalityLoadBalancingPolicyConfigPolicy_Name = 166297216
	// The load balancer selects a random healthy host.
	BackendServiceLocalityLoadBalancingPolicyConfigPolicy_RANDOM BackendServiceLocalityLoadBalancingPolicyConfigPolicy_Name = 262527171
	// The ring/modulo hash load balancer implements consistent hashing to backends. The algorithm has the property that the addition/removal of a host from a set of N hosts only affects 1/N of the requests.
	BackendServiceLocalityLoadBalancingPolicyConfigPolicy_RING_HASH BackendServiceLocalityLoadBalancingPolicyConfigPolicy_Name = 432795069
	// This is a simple policy in which each healthy backend is selected in round robin order. This is the default.
	BackendServiceLocalityLoadBalancingPolicyConfigPolicy_ROUND_ROBIN BackendServiceLocalityLoadBalancingPolicyConfigPolicy_Name = 153895801
	// Per-instance weighted Load Balancing via health check reported weights. If set, the Backend Service must configure a non legacy HTTP-based Health Check, and health check replies are expected to contain non-standard HTTP response header field X-Load-Balancing-Endpoint-Weight to specify the per-instance weights. If set, Load Balancing is weighted based on the per-instance weights reported in the last processed health check replies, as long as every instance either reported a valid weight or had UNAVAILABLE_WEIGHT. Otherwise, Load Balancing remains equal-weight. This option is only supported in Network Load Balancing.
	BackendServiceLocalityLoadBalancingPolicyConfigPolicy_WEIGHTED_MAGLEV BackendServiceLocalityLoadBalancingPolicyConfigPolicy_Name = 254930962
)

// Enum value maps for BackendServiceLocalityLoadBalancingPolicyConfigPolicy_Name.
var (
	BackendServiceLocalityLoadBalancingPolicyConfigPolicy_Name_name = map[int32]string{
		0:         "UNDEFINED_NAME",
		323318707: "INVALID_LB_POLICY",
		46604921:  "LEAST_REQUEST",
		119180266: "MAGLEV",
		166297216: "ORIGINAL_DESTINATION",
		262527171: "RANDOM",
		432795069: "RING_HASH",
		153895801: "ROUND_ROBIN",
		254930962: "WEIGHTED_MAGLEV",
	}
	BackendServiceLocalityLoadBalancingPolicyConfigPolicy_Name_value = map[string]int32{
		"UNDEFINED_NAME":       0,
		"INVALID_LB_POLICY":    323318707,
		"LEAST_REQUEST":        46604921,
		"MAGLEV":               119180266,
		"ORIGINAL_DESTINATION": 166297216,
		"RANDOM":               262527171,
		"RING_HASH":            432795069,
		"ROUND_ROBIN":          153895801,
		"WEIGHTED_MAGLEV":      254930962,
	}
)

func (x BackendServiceLocalityLoadBalancingPolicyConfigPolicy_Name) Enum() *BackendServiceLocalityLoadBalancingPolicyConfigPolicy_Name {
	p := new(BackendServiceLocalityLoadBalancingPolicyConfigPolicy_Name)
	*p = x
	return p
}

func (x BackendServiceLocalityLoadBalancingPolicyConfigPolicy_Name) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackendServiceLocalityLoadBalancingPolicyConfigPolicy_Name) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[33].Descriptor()
}

func (BackendServiceLocalityLoadBalancingPolicyConfigPolicy_Name) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[33]
}

func (x BackendServiceLocalityLoadBalancingPolicyConfigPolicy_Name) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackendServiceLocalityLoadBalancingPolicyConfigPolicy_Name.Descriptor instead.
func (BackendServiceLocalityLoadBalancingPolicyConfigPolicy_Name) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{120, 0}
}

// This field can only be specified if logging is enabled for this backend service. Configures whether all, none or a subset of optional fields should be added to the reported logs. One of [INCLUDE_ALL_OPTIONAL, EXCLUDE_ALL_OPTIONAL, CUSTOM]. Default is EXCLUDE_ALL_OPTIONAL.
type BackendServiceLogConfig_OptionalMode int32

const (
	// A value indicating that the enum field is not set.
	BackendServiceLogConfig_UNDEFINED_OPTIONAL_MODE BackendServiceLogConfig_OptionalMode = 0
	// A subset of optional fields.
	BackendServiceLogConfig_CUSTOM BackendServiceLogConfig_OptionalMode = 388595569
	// None optional fields.
	BackendServiceLogConfig_EXCLUDE_ALL_OPTIONAL BackendServiceLogConfig_OptionalMode = 168636099
	// All optional fields.
	BackendServiceLogConfig_INCLUDE_ALL_OPTIONAL BackendServiceLogConfig_OptionalMode = 535606965
)

// Enum value maps for BackendServiceLogConfig_OptionalMode.
var (
	BackendServiceLogConfig_OptionalMode_name = map[int32]string{
		0:         "UNDEFINED_OPTIONAL_MODE",
		388595569: "CUSTOM",
		168636099: "EXCLUDE_ALL_OPTIONAL",
		535606965: "INCLUDE_ALL_OPTIONAL",
	}
	BackendServiceLogConfig_OptionalMode_value = map[string]int32{
		"UNDEFINED_OPTIONAL_MODE": 0,
		"CUSTOM":                  388595569,
		"EXCLUDE_ALL_OPTIONAL":    168636099,
		"INCLUDE_ALL_OPTIONAL":    535606965,
	}
)

func (x BackendServiceLogConfig_OptionalMode) Enum() *BackendServiceLogConfig_OptionalMode {
	p := new(BackendServiceLogConfig_OptionalMode)
	*p = x
	return p
}

func (x BackendServiceLogConfig_OptionalMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackendServiceLogConfig_OptionalMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[34].Descriptor()
}

func (BackendServiceLogConfig_OptionalMode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[34]
}

func (x BackendServiceLogConfig_OptionalMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackendServiceLogConfig_OptionalMode.Descriptor instead.
func (BackendServiceLogConfig_OptionalMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{121, 0}
}

// The diagnostic code specifies the local system's reason for the last change in session state. This allows remote systems to determine the reason that the previous session failed, for example. These diagnostic codes are specified in section 4.1 of RFC5880
type BfdPacket_Diagnostic int32

const (
	// A value indicating that the enum field is not set.
	BfdPacket_UNDEFINED_DIAGNOSTIC           BfdPacket_Diagnostic = 0
	BfdPacket_ADMINISTRATIVELY_DOWN          BfdPacket_Diagnostic = 121685798
	BfdPacket_CONCATENATED_PATH_DOWN         BfdPacket_Diagnostic = 26186892
	BfdPacket_CONTROL_DETECTION_TIME_EXPIRED BfdPacket_Diagnostic = 135478383
	BfdPacket_DIAGNOSTIC_UNSPECIFIED         BfdPacket_Diagnostic = 58720895
	BfdPacket_ECHO_FUNCTION_FAILED           BfdPacket_Diagnostic = 220687466
	BfdPacket_FORWARDING_PLANE_RESET         BfdPacket_Diagnostic = 19715882
	BfdPacket_NEIGHBOR_SIGNALED_SESSION_DOWN BfdPacket_Diagnostic = 374226742
	BfdPacket_NO_DIAGNOSTIC                  BfdPacket_Diagnostic = 222503141
	BfdPacket_PATH_DOWN                      BfdPacket_Diagnostic = 290605180
	BfdPacket_REVERSE_CONCATENATED_PATH_DOWN BfdPacket_Diagnostic = 479337129
)

// Enum value maps for BfdPacket_Diagnostic.
var (
	BfdPacket_Diagnostic_name = map[int32]string{
		0:         "UNDEFINED_DIAGNOSTIC",
		121685798: "ADMINISTRATIVELY_DOWN",
		26186892:  "CONCATENATED_PATH_DOWN",
		135478383: "CONTROL_DETECTION_TIME_EXPIRED",
		58720895:  "DIAGNOSTIC_UNSPECIFIED",
		220687466: "ECHO_FUNCTION_FAILED",
		19715882:  "FORWARDING_PLANE_RESET",
		374226742: "NEIGHBOR_SIGNALED_SESSION_DOWN",
		222503141: "NO_DIAGNOSTIC",
		290605180: "PATH_DOWN",
		479337129: "REVERSE_CONCATENATED_PATH_DOWN",
	}
	BfdPacket_Diagnostic_value = map[string]int32{
		"UNDEFINED_DIAGNOSTIC":           0,
		"ADMINISTRATIVELY_DOWN":          121685798,
		"CONCATENATED_PATH_DOWN":         26186892,
		"CONTROL_DETECTION_TIME_EXPIRED": 135478383,
		"DIAGNOSTIC_UNSPECIFIED":         58720895,
		"ECHO_FUNCTION_FAILED":           220687466,
		"FORWARDING_PLANE_RESET":         19715882,
		"NEIGHBOR_SIGNALED_SESSION_DOWN": 374226742,
		"NO_DIAGNOSTIC":                  222503141,
		"PATH_DOWN":                      290605180,
		"REVERSE_CONCATENATED_PATH_DOWN": 479337129,
	}
)

func (x BfdPacket_Diagnostic) Enum() *BfdPacket_Diagnostic {
	p := new(BfdPacket_Diagnostic)
	*p = x
	return p
}

func (x BfdPacket_Diagnostic) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BfdPacket_Diagnostic) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[35].Descriptor()
}

func (BfdPacket_Diagnostic) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[35]
}

func (x BfdPacket_Diagnostic) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BfdPacket_Diagnostic.Descriptor instead.
func (BfdPacket_Diagnostic) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{124, 0}
}

// The current BFD session state as seen by the transmitting system. These states are specified in section 4.1 of RFC5880
type BfdPacket_State int32

const (
	// A value indicating that the enum field is not set.
	BfdPacket_UNDEFINED_STATE   BfdPacket_State = 0
	BfdPacket_ADMIN_DOWN        BfdPacket_State = 128544690
	BfdPacket_DOWN              BfdPacket_State = 2104482
	BfdPacket_INIT              BfdPacket_State = 2252048
	BfdPacket_STATE_UNSPECIFIED BfdPacket_State = 470755401
	BfdPacket_UP                BfdPacket_State = 2715
)

// Enum value maps for BfdPacket_State.
var (
	BfdPacket_State_name = map[int32]string{
		0:         "UNDEFINED_STATE",
		128544690: "ADMIN_DOWN",
		2104482:   "DOWN",
		2252048:   "INIT",
		470755401: "STATE_UNSPECIFIED",
		2715:      "UP",
	}
	BfdPacket_State_value = map[string]int32{
		"UNDEFINED_STATE":   0,
		"ADMIN_DOWN":        128544690,
		"DOWN":              2104482,
		"INIT":              2252048,
		"STATE_UNSPECIFIED": 470755401,
		"UP":                2715,
	}
)

func (x BfdPacket_State) Enum() *BfdPacket_State {
	p := new(BfdPacket_State)
	*p = x
	return p
}

func (x BfdPacket_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BfdPacket_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[36].Descriptor()
}

func (BfdPacket_State) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[36]
}

func (x BfdPacket_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BfdPacket_State.Descriptor instead.
func (BfdPacket_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{124, 1}
}

// The BFD session initialization mode for this BGP peer. If set to ACTIVE, the Cloud Router will initiate the BFD session for this BGP peer. If set to PASSIVE, the Cloud Router will wait for the peer router to initiate the BFD session for this BGP peer. If set to DISABLED, BFD is disabled for this BGP peer.
type BfdStatus_BfdSessionInitializationMode int32

const (
	// A value indicating that the enum field is not set.
	BfdStatus_UNDEFINED_BFD_SESSION_INITIALIZATION_MODE BfdStatus_BfdSessionInitializationMode = 0
	BfdStatus_ACTIVE                                    BfdStatus_BfdSessionInitializationMode = 314733318
	BfdStatus_DISABLED                                  BfdStatus_BfdSessionInitializationMode = 516696700
	BfdStatus_PASSIVE                                   BfdStatus_BfdSessionInitializationMode = 462813959
)

// Enum value maps for BfdStatus_BfdSessionInitializationMode.
var (
	BfdStatus_BfdSessionInitializationMode_name = map[int32]string{
		0:         "UNDEFINED_BFD_SESSION_INITIALIZATION_MODE",
		314733318: "ACTIVE",
		516696700: "DISABLED",
		462813959: "PASSIVE",
	}
	BfdStatus_BfdSessionInitializationMode_value = map[string]int32{
		"UNDEFINED_BFD_SESSION_INITIALIZATION_MODE": 0,
		"ACTIVE":   314733318,
		"DISABLED": 516696700,
		"PASSIVE":  462813959,
	}
)

func (x BfdStatus_BfdSessionInitializationMode) Enum() *BfdStatus_BfdSessionInitializationMode {
	p := new(BfdStatus_BfdSessionInitializationMode)
	*p = x
	return p
}

func (x BfdStatus_BfdSessionInitializationMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BfdStatus_BfdSessionInitializationMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[37].Descriptor()
}

func (BfdStatus_BfdSessionInitializationMode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[37]
}

func (x BfdStatus_BfdSessionInitializationMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BfdStatus_BfdSessionInitializationMode.Descriptor instead.
func (BfdStatus_BfdSessionInitializationMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{125, 0}
}

// The diagnostic code specifies the local system's reason for the last change in session state. This allows remote systems to determine the reason that the previous session failed, for example. These diagnostic codes are specified in section 4.1 of RFC5880
type BfdStatus_LocalDiagnostic int32

const (
	// A value indicating that the enum field is not set.
	BfdStatus_UNDEFINED_LOCAL_DIAGNOSTIC     BfdStatus_LocalDiagnostic = 0
	BfdStatus_ADMINISTRATIVELY_DOWN          BfdStatus_LocalDiagnostic = 121685798
	BfdStatus_CONCATENATED_PATH_DOWN         BfdStatus_LocalDiagnostic = 26186892
	BfdStatus_CONTROL_DETECTION_TIME_EXPIRED BfdStatus_LocalDiagnostic = 135478383
	BfdStatus_DIAGNOSTIC_UNSPECIFIED         BfdStatus_LocalDiagnostic = 58720895
	BfdStatus_ECHO_FUNCTION_FAILED           BfdStatus_LocalDiagnostic = 220687466
	BfdStatus_FORWARDING_PLANE_RESET         BfdStatus_LocalDiagnostic = 19715882
	BfdStatus_NEIGHBOR_SIGNALED_SESSION_DOWN BfdStatus_LocalDiagnostic = 374226742
	BfdStatus_NO_DIAGNOSTIC                  BfdStatus_LocalDiagnostic = 222503141
	BfdStatus_PATH_DOWN                      BfdStatus_LocalDiagnostic = 290605180
	BfdStatus_REVERSE_CONCATENATED_PATH_DOWN BfdStatus_LocalDiagnostic = 479337129
)

// Enum value maps for BfdStatus_LocalDiagnostic.
var (
	BfdStatus_LocalDiagnostic_name = map[int32]string{
		0:         "UNDEFINED_LOCAL_DIAGNOSTIC",
		121685798: "ADMINISTRATIVELY_DOWN",
		26186892:  "CONCATENATED_PATH_DOWN",
		135478383: "CONTROL_DETECTION_TIME_EXPIRED",
		58720895:  "DIAGNOSTIC_UNSPECIFIED",
		220687466: "ECHO_FUNCTION_FAILED",
		19715882:  "FORWARDING_PLANE_RESET",
		374226742: "NEIGHBOR_SIGNALED_SESSION_DOWN",
		222503141: "NO_DIAGNOSTIC",
		290605180: "PATH_DOWN",
		479337129: "REVERSE_CONCATENATED_PATH_DOWN",
	}
	BfdStatus_LocalDiagnostic_value = map[string]int32{
		"UNDEFINED_LOCAL_DIAGNOSTIC":     0,
		"ADMINISTRATIVELY_DOWN":          121685798,
		"CONCATENATED_PATH_DOWN":         26186892,
		"CONTROL_DETECTION_TIME_EXPIRED": 135478383,
		"DIAGNOSTIC_UNSPECIFIED":         58720895,
		"ECHO_FUNCTION_FAILED":           220687466,
		"FORWARDING_PLANE_RESET":         19715882,
		"NEIGHBOR_SIGNALED_SESSION_DOWN": 374226742,
		"NO_DIAGNOSTIC":                  222503141,
		"PATH_DOWN":                      290605180,
		"REVERSE_CONCATENATED_PATH_DOWN": 479337129,
	}
)

func (x BfdStatus_LocalDiagnostic) Enum() *BfdStatus_LocalDiagnostic {
	p := new(BfdStatus_LocalDiagnostic)
	*p = x
	return p
}

func (x BfdStatus_LocalDiagnostic) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BfdStatus_LocalDiagnostic) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[38].Descriptor()
}

func (BfdStatus_LocalDiagnostic) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[38]
}

func (x BfdStatus_LocalDiagnostic) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BfdStatus_LocalDiagnostic.Descriptor instead.
func (BfdStatus_LocalDiagnostic) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{125, 1}
}

// The current BFD session state as seen by the transmitting system. These states are specified in section 4.1 of RFC5880
type BfdStatus_LocalState int32

const (
	// A value indicating that the enum field is not set.
	BfdStatus_UNDEFINED_LOCAL_STATE BfdStatus_LocalState = 0
	BfdStatus_ADMIN_DOWN            BfdStatus_LocalState = 128544690
	BfdStatus_DOWN                  BfdStatus_LocalState = 2104482
	BfdStatus_INIT                  BfdStatus_LocalState = 2252048
	BfdStatus_STATE_UNSPECIFIED     BfdStatus_LocalState = 470755401
	BfdStatus_UP                    BfdStatus_LocalState = 2715
)

// Enum value maps for BfdStatus_LocalState.
var (
	BfdStatus_LocalState_name = map[int32]string{
		0:         "UNDEFINED_LOCAL_STATE",
		128544690: "ADMIN_DOWN",
		2104482:   "DOWN",
		2252048:   "INIT",
		470755401: "STATE_UNSPECIFIED",
		2715:      "UP",
	}
	BfdStatus_LocalState_value = map[string]int32{
		"UNDEFINED_LOCAL_STATE": 0,
		"ADMIN_DOWN":            128544690,
		"DOWN":                  2104482,
		"INIT":                  2252048,
		"STATE_UNSPECIFIED":     470755401,
		"UP":                    2715,
	}
)

func (x BfdStatus_LocalState) Enum() *BfdStatus_LocalState {
	p := new(BfdStatus_LocalState)
	*p = x
	return p
}

func (x BfdStatus_LocalState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BfdStatus_LocalState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[39].Descriptor()
}

func (BfdStatus_LocalState) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[39]
}

func (x BfdStatus_LocalState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BfdStatus_LocalState.Descriptor instead.
func (BfdStatus_LocalState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{125, 2}
}

// The category of the commitment. Category MACHINE specifies commitments composed of machine resources such as VCPU or MEMORY, listed in resources. Category LICENSE specifies commitments composed of software licenses, listed in licenseResources. Note that only MACHINE commitments should have a Type specified.
type Commitment_Category int32

const (
	// A value indicating that the enum field is not set.
	Commitment_UNDEFINED_CATEGORY   Commitment_Category = 0
	Commitment_CATEGORY_UNSPECIFIED Commitment_Category = 509189462
	Commitment_LICENSE              Commitment_Category = 347869217
	Commitment_MACHINE              Commitment_Category = 469553191
)

// Enum value maps for Commitment_Category.
var (
	Commitment_Category_name = map[int32]string{
		0:         "UNDEFINED_CATEGORY",
		509189462: "CATEGORY_UNSPECIFIED",
		347869217: "LICENSE",
		469553191: "MACHINE",
	}
	Commitment_Category_value = map[string]int32{
		"UNDEFINED_CATEGORY":   0,
		"CATEGORY_UNSPECIFIED": 509189462,
		"LICENSE":              347869217,
		"MACHINE":              469553191,
	}
)

func (x Commitment_Category) Enum() *Commitment_Category {
	p := new(Commitment_Category)
	*p = x
	return p
}

func (x Commitment_Category) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Commitment_Category) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[40].Descriptor()
}

func (Commitment_Category) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[40]
}

func (x Commitment_Category) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Commitment_Category.Descriptor instead.
func (Commitment_Category) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{138, 0}
}

// The plan for this commitment, which determines duration and discount rate. The currently supported plans are TWELVE_MONTH (1 year), and THIRTY_SIX_MONTH (3 years).
type Commitment_Plan int32

const (
	// A value indicating that the enum field is not set.
	Commitment_UNDEFINED_PLAN   Commitment_Plan = 0
	Commitment_INVALID          Commitment_Plan = 530283991
	Commitment_THIRTY_SIX_MONTH Commitment_Plan = 266295942
	Commitment_TWELVE_MONTH     Commitment_Plan = 173083962
)

// Enum value maps for Commitment_Plan.
var (
	Commitment_Plan_name = map[int32]string{
		0:         "UNDEFINED_PLAN",
		530283991: "INVALID",
		266295942: "THIRTY_SIX_MONTH",
		173083962: "TWELVE_MONTH",
	}
	Commitment_Plan_value = map[string]int32{
		"UNDEFINED_PLAN":   0,
		"INVALID":          530283991,
		"THIRTY_SIX_MONTH": 266295942,
		"TWELVE_MONTH":     173083962,
	}
)

func (x Commitment_Plan) Enum() *Commitment_Plan {
	p := new(Commitment_Plan)
	*p = x
	return p
}

func (x Commitment_Plan) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Commitment_Plan) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[41].Descriptor()
}

func (Commitment_Plan) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[41]
}

func (x Commitment_Plan) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Commitment_Plan.Descriptor instead.
func (Commitment_Plan) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{138, 1}
}

// [Output Only] Status of the commitment with regards to eventual expiration (each commitment has an end date defined). One of the following values: NOT_YET_ACTIVE, ACTIVE, EXPIRED.
type Commitment_Status int32

const (
	// A value indicating that the enum field is not set.
	Commitment_UNDEFINED_STATUS Commitment_Status = 0
	Commitment_ACTIVE           Commitment_Status = 314733318
	// Deprecate CANCELED status. Will use separate status to differentiate cancel by mergeCud or manual cancellation.
	Commitment_CANCELLED      Commitment_Status = 41957681
	Commitment_CREATING       Commitment_Status = 455564985
	Commitment_EXPIRED        Commitment_Status = 482489093
	Commitment_NOT_YET_ACTIVE Commitment_Status = 20607337
)

// Enum value maps for Commitment_Status.
var (
	Commitment_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		314733318: "ACTIVE",
		41957681:  "CANCELLED",
		455564985: "CREATING",
		482489093: "EXPIRED",
		20607337:  "NOT_YET_ACTIVE",
	}
	Commitment_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"ACTIVE":           314733318,
		"CANCELLED":        41957681,
		"CREATING":         455564985,
		"EXPIRED":          482489093,
		"NOT_YET_ACTIVE":   20607337,
	}
)

func (x Commitment_Status) Enum() *Commitment_Status {
	p := new(Commitment_Status)
	*p = x
	return p
}

func (x Commitment_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Commitment_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[42].Descriptor()
}

func (Commitment_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[42]
}

func (x Commitment_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Commitment_Status.Descriptor instead.
func (Commitment_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{138, 2}
}

// The type of commitment, which affects the discount rate and the eligible resources. Type MEMORY_OPTIMIZED specifies a commitment that will only apply to memory optimized machines. Type ACCELERATOR_OPTIMIZED specifies a commitment that will only apply to accelerator optimized machines.
type Commitment_Type int32

const (
	// A value indicating that the enum field is not set.
	Commitment_UNDEFINED_TYPE        Commitment_Type = 0
	Commitment_ACCELERATOR_OPTIMIZED Commitment_Type = 280848403
	Commitment_COMPUTE_OPTIMIZED     Commitment_Type = 158349023
	Commitment_COMPUTE_OPTIMIZED_C2D Commitment_Type = 383246453
	Commitment_COMPUTE_OPTIMIZED_C3  Commitment_Type = 428004784
	Commitment_GENERAL_PURPOSE       Commitment_Type = 299793543
	Commitment_GENERAL_PURPOSE_E2    Commitment_Type = 301911877
	Commitment_GENERAL_PURPOSE_N2    Commitment_Type = 301912156
	Commitment_GENERAL_PURPOSE_N2D   Commitment_Type = 232471400
	Commitment_GENERAL_PURPOSE_T2D   Commitment_Type = 232477166
	Commitment_MEMORY_OPTIMIZED      Commitment_Type = 281753417
	Commitment_MEMORY_OPTIMIZED_M3   Commitment_Type = 276301372
	Commitment_TYPE_UNSPECIFIED      Commitment_Type = 437714322
)

// Enum value maps for Commitment_Type.
var (
	Commitment_Type_name = map[int32]string{
		0:         "UNDEFINED_TYPE",
		280848403: "ACCELERATOR_OPTIMIZED",
		158349023: "COMPUTE_OPTIMIZED",
		383246453: "COMPUTE_OPTIMIZED_C2D",
		428004784: "COMPUTE_OPTIMIZED_C3",
		299793543: "GENERAL_PURPOSE",
		301911877: "GENERAL_PURPOSE_E2",
		301912156: "GENERAL_PURPOSE_N2",
		232471400: "GENERAL_PURPOSE_N2D",
		232477166: "GENERAL_PURPOSE_T2D",
		281753417: "MEMORY_OPTIMIZED",
		276301372: "MEMORY_OPTIMIZED_M3",
		437714322: "TYPE_UNSPECIFIED",
	}
	Commitment_Type_value = map[string]int32{
		"UNDEFINED_TYPE":        0,
		"ACCELERATOR_OPTIMIZED": 280848403,
		"COMPUTE_OPTIMIZED":     158349023,
		"COMPUTE_OPTIMIZED_C2D": 383246453,
		"COMPUTE_OPTIMIZED_C3":  428004784,
		"GENERAL_PURPOSE":       299793543,
		"GENERAL_PURPOSE_E2":    301911877,
		"GENERAL_PURPOSE_N2":    301912156,
		"GENERAL_PURPOSE_N2D":   232471400,
		"GENERAL_PURPOSE_T2D":   232477166,
		"MEMORY_OPTIMIZED":      281753417,
		"MEMORY_OPTIMIZED_M3":   276301372,
		"TYPE_UNSPECIFIED":      437714322,
	}
)

func (x Commitment_Type) Enum() *Commitment_Type {
	p := new(Commitment_Type)
	*p = x
	return p
}

func (x Commitment_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Commitment_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[43].Descriptor()
}

func (Commitment_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[43]
}

func (x Commitment_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Commitment_Type.Descriptor instead.
func (Commitment_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{138, 3}
}

// This is deprecated and has no effect. Do not use.
// Additional supported values which may be not listed in the enum directly due to technical reasons:
// NO_ATTR
type Condition_Iam int32

const (
	// A value indicating that the enum field is not set.
	Condition_UNDEFINED_IAM Condition_Iam = 0
	// This is deprecated and has no effect. Do not use.
	Condition_APPROVER Condition_Iam = 357258949
	// This is deprecated and has no effect. Do not use.
	Condition_ATTRIBUTION Condition_Iam = 232465503
	// This is deprecated and has no effect. Do not use.
	Condition_AUTHORITY Condition_Iam = 504108835
	// This is deprecated and has no effect. Do not use.
	Condition_CREDENTIALS_TYPE Condition_Iam = 348222141
	// This is deprecated and has no effect. Do not use.
	Condition_CREDS_ASSERTION Condition_Iam = 332343272
	// This is deprecated and has no effect. Do not use.
	Condition_JUSTIFICATION_TYPE Condition_Iam = 206147719
	// This is deprecated and has no effect. Do not use.
	Condition_SECURITY_REALM Condition_Iam = 526269616
)

// Enum value maps for Condition_Iam.
var (
	Condition_Iam_name = map[int32]string{
		0:         "UNDEFINED_IAM",
		357258949: "APPROVER",
		232465503: "ATTRIBUTION",
		504108835: "AUTHORITY",
		348222141: "CREDENTIALS_TYPE",
		332343272: "CREDS_ASSERTION",
		206147719: "JUSTIFICATION_TYPE",
		526269616: "SECURITY_REALM",
	}
	Condition_Iam_value = map[string]int32{
		"UNDEFINED_IAM":      0,
		"APPROVER":           357258949,
		"ATTRIBUTION":        232465503,
		"AUTHORITY":          504108835,
		"CREDENTIALS_TYPE":   348222141,
		"CREDS_ASSERTION":    332343272,
		"JUSTIFICATION_TYPE": 206147719,
		"SECURITY_REALM":     526269616,
	}
)

func (x Condition_Iam) Enum() *Condition_Iam {
	p := new(Condition_Iam)
	*p = x
	return p
}

func (x Condition_Iam) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Condition_Iam) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[44].Descriptor()
}

func (Condition_Iam) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[44]
}

func (x Condition_Iam) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Condition_Iam.Descriptor instead.
func (Condition_Iam) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{142, 0}
}

// This is deprecated and has no effect. Do not use.
type Condition_Op int32

const (
	// A value indicating that the enum field is not set.
	Condition_UNDEFINED_OP Condition_Op = 0
	// This is deprecated and has no effect. Do not use.
	Condition_DISCHARGED Condition_Op = 266338274
	// This is deprecated and has no effect. Do not use.
	Condition_EQUALS Condition_Op = 442201023
	// This is deprecated and has no effect. Do not use.
	Condition_IN Condition_Op = 2341
	// This is deprecated and has no effect. Do not use.
	Condition_NOT_EQUALS Condition_Op = 19718859
	// This is deprecated and has no effect. Do not use.
	Condition_NOT_IN Condition_Op = 161144369
	// This is deprecated and has no effect. Do not use.
	Condition_NO_OP Condition_Op = 74481951
)

// Enum value maps for Condition_Op.
var (
	Condition_Op_name = map[int32]string{
		0:         "UNDEFINED_OP",
		266338274: "DISCHARGED",
		442201023: "EQUALS",
		2341:      "IN",
		19718859:  "NOT_EQUALS",
		161144369: "NOT_IN",
		74481951:  "NO_OP",
	}
	Condition_Op_value = map[string]int32{
		"UNDEFINED_OP": 0,
		"DISCHARGED":   266338274,
		"EQUALS":       442201023,
		"IN":           2341,
		"NOT_EQUALS":   19718859,
		"NOT_IN":       161144369,
		"NO_OP":        74481951,
	}
)

func (x Condition_Op) Enum() *Condition_Op {
	p := new(Condition_Op)
	*p = x
	return p
}

func (x Condition_Op) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Condition_Op) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[45].Descriptor()
}

func (Condition_Op) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[45]
}

func (x Condition_Op) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Condition_Op.Descriptor instead.
func (Condition_Op) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{142, 1}
}

// This is deprecated and has no effect. Do not use.
// Additional supported values which may be not listed in the enum directly due to technical reasons:
// NO_ATTR
type Condition_Sys int32

const (
	// A value indicating that the enum field is not set.
	Condition_UNDEFINED_SYS Condition_Sys = 0
	// This is deprecated and has no effect. Do not use.
	Condition_IP Condition_Sys = 2343
	// This is deprecated and has no effect. Do not use.
	Condition_NAME Condition_Sys = 2388619
	// This is deprecated and has no effect. Do not use.
	Condition_REGION Condition_Sys = 266017524
	// This is deprecated and has no effect. Do not use.
	Condition_SERVICE Condition_Sys = 17781397
)

// Enum value maps for Condition_Sys.
var (
	Condition_Sys_name = map[int32]string{
		0:         "UNDEFINED_SYS",
		2343:      "IP",
		2388619:   "NAME",
		266017524: "REGION",
		17781397:  "SERVICE",
	}
	Condition_Sys_value = map[string]int32{
		"UNDEFINED_SYS": 0,
		"IP":            2343,
		"NAME":          2388619,
		"REGION":        266017524,
		"SERVICE":       17781397,
	}
)

func (x Condition_Sys) Enum() *Condition_Sys {
	p := new(Condition_Sys)
	*p = x
	return p
}

func (x Condition_Sys) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Condition_Sys) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[46].Descriptor()
}

func (Condition_Sys) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[46]
}

func (x Condition_Sys) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Condition_Sys.Descriptor instead.
func (Condition_Sys) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{142, 2}
}

// The deprecation state of this resource. This can be ACTIVE, DEPRECATED, OBSOLETE, or DELETED. Operations which communicate the end of life date for an image, can use ACTIVE. Operations which create a new resource using a DEPRECATED resource will return successfully, but with a warning indicating the deprecated resource and recommending its replacement. Operations which use OBSOLETE or DELETED resources will be rejected and result in an error.
type DeprecationStatus_State int32

const (
	// A value indicating that the enum field is not set.
	DeprecationStatus_UNDEFINED_STATE DeprecationStatus_State = 0
	DeprecationStatus_ACTIVE          DeprecationStatus_State = 314733318
	DeprecationStatus_DELETED         DeprecationStatus_State = 120962041
	DeprecationStatus_DEPRECATED      DeprecationStatus_State = 463360435
	DeprecationStatus_OBSOLETE        DeprecationStatus_State = 66532761
)

// Enum value maps for DeprecationStatus_State.
var (
	DeprecationStatus_State_name = map[int32]string{
		0:         "UNDEFINED_STATE",
		314733318: "ACTIVE",
		120962041: "DELETED",
		463360435: "DEPRECATED",
		66532761:  "OBSOLETE",
	}
	DeprecationStatus_State_value = map[string]int32{
		"UNDEFINED_STATE": 0,
		"ACTIVE":          314733318,
		"DELETED":         120962041,
		"DEPRECATED":      463360435,
		"OBSOLETE":        66532761,
	}
)

func (x DeprecationStatus_State) Enum() *DeprecationStatus_State {
	p := new(DeprecationStatus_State)
	*p = x
	return p
}

func (x DeprecationStatus_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DeprecationStatus_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[47].Descriptor()
}

func (DeprecationStatus_State) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[47]
}

func (x DeprecationStatus_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DeprecationStatus_State.Descriptor instead.
func (DeprecationStatus_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{244, 0}
}

// The architecture of the disk. Valid values are ARM64 or X86_64.
type Disk_Architecture int32

const (
	// A value indicating that the enum field is not set.
	Disk_UNDEFINED_ARCHITECTURE Disk_Architecture = 0
	// Default value indicating Architecture is not set.
	Disk_ARCHITECTURE_UNSPECIFIED Disk_Architecture = 394750507
	// Machines with architecture ARM64
	Disk_ARM64 Disk_Architecture = 62547450
	// Machines with architecture X86_64
	Disk_X86_64 Disk_Architecture = 425300551
)

// Enum value maps for Disk_Architecture.
var (
	Disk_Architecture_name = map[int32]string{
		0:         "UNDEFINED_ARCHITECTURE",
		394750507: "ARCHITECTURE_UNSPECIFIED",
		62547450:  "ARM64",
		425300551: "X86_64",
	}
	Disk_Architecture_value = map[string]int32{
		"UNDEFINED_ARCHITECTURE":   0,
		"ARCHITECTURE_UNSPECIFIED": 394750507,
		"ARM64":                    62547450,
		"X86_64":                   425300551,
	}
)

func (x Disk_Architecture) Enum() *Disk_Architecture {
	p := new(Disk_Architecture)
	*p = x
	return p
}

func (x Disk_Architecture) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Disk_Architecture) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[48].Descriptor()
}

func (Disk_Architecture) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[48]
}

func (x Disk_Architecture) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Disk_Architecture.Descriptor instead.
func (Disk_Architecture) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{250, 0}
}

// [Output Only] The status of disk creation. - CREATING: Disk is provisioning. - RESTORING: Source data is being copied into the disk. - FAILED: Disk creation failed. - READY: Disk is ready for use. - DELETING: Disk is deleting.
type Disk_Status int32

const (
	// A value indicating that the enum field is not set.
	Disk_UNDEFINED_STATUS Disk_Status = 0
	// Disk is provisioning
	Disk_CREATING Disk_Status = 455564985
	// Disk is deleting.
	Disk_DELETING Disk_Status = 528602024
	// Disk creation failed.
	Disk_FAILED Disk_Status = 455706685
	// Disk is ready for use.
	Disk_READY Disk_Status = 77848963
	// Source data is being copied into the disk.
	Disk_RESTORING Disk_Status = 404263851
)

// Enum value maps for Disk_Status.
var (
	Disk_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		455564985: "CREATING",
		528602024: "DELETING",
		455706685: "FAILED",
		77848963:  "READY",
		404263851: "RESTORING",
	}
	Disk_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"CREATING":         455564985,
		"DELETING":         528602024,
		"FAILED":           455706685,
		"READY":            77848963,
		"RESTORING":        404263851,
	}
)

func (x Disk_Status) Enum() *Disk_Status {
	p := new(Disk_Status)
	*p = x
	return p
}

func (x Disk_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Disk_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[49].Descriptor()
}

func (Disk_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[49]
}

func (x Disk_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Disk_Status.Descriptor instead.
func (Disk_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{250, 1}
}

// Specifies whether to include the disk and what image to use. Possible values are: - source-image: to use the same image that was used to create the source instance's corresponding disk. Applicable to the boot disk and additional read-write disks. - source-image-family: to use the same image family that was used to create the source instance's corresponding disk. Applicable to the boot disk and additional read-write disks. - custom-image: to use a user-provided image url for disk creation. Applicable to the boot disk and additional read-write disks. - attach-read-only: to attach a read-only disk. Applicable to read-only disks. - do-not-include: to exclude a disk from the template. Applicable to additional read-write disks, local SSDs, and read-only disks.
type DiskInstantiationConfig_InstantiateFrom int32

const (
	// A value indicating that the enum field is not set.
	DiskInstantiationConfig_UNDEFINED_INSTANTIATE_FROM DiskInstantiationConfig_InstantiateFrom = 0
	// Attach the existing disk in read-only mode. The request will fail if the disk was attached in read-write mode on the source instance. Applicable to: read-only disks.
	DiskInstantiationConfig_ATTACH_READ_ONLY DiskInstantiationConfig_InstantiateFrom = 513775419
	// Create a blank disk. The disk will be created unformatted. Applicable to: additional read-write disks, local SSDs.
	DiskInstantiationConfig_BLANK DiskInstantiationConfig_InstantiateFrom = 63281460
	// Use the custom image specified in the custom_image field. Applicable to: boot disk, additional read-write disks.
	DiskInstantiationConfig_CUSTOM_IMAGE DiskInstantiationConfig_InstantiateFrom = 196311789
	// Use the default instantiation option for the corresponding type of disk. For boot disk and any other R/W disks, new custom images will be created from each disk. For read-only disks, they will be attached in read-only mode. Local SSD disks will be created as blank volumes.
	DiskInstantiationConfig_DEFAULT DiskInstantiationConfig_InstantiateFrom = 115302945
	// Do not include the disk in the instance template. Applicable to: additional read-write disks, local SSDs, read-only disks.
	DiskInstantiationConfig_DO_NOT_INCLUDE DiskInstantiationConfig_InstantiateFrom = 104218952
	// Use the same source image used for creation of the source instance's corresponding disk. The request will fail if the source VM's disk was created from a snapshot. Applicable to: boot disk, additional read-write disks.
	DiskInstantiationConfig_SOURCE_IMAGE DiskInstantiationConfig_InstantiateFrom = 62631959
	// Use the same source image family used for creation of the source instance's corresponding disk. The request will fail if the source image of the source disk does not belong to any image family. Applicable to: boot disk, additional read-write disks.
	DiskInstantiationConfig_SOURCE_IMAGE_FAMILY DiskInstantiationConfig_InstantiateFrom = 76850316
)

// Enum value maps for DiskInstantiationConfig_InstantiateFrom.
var (
	DiskInstantiationConfig_InstantiateFrom_name = map[int32]string{
		0:         "UNDEFINED_INSTANTIATE_FROM",
		513775419: "ATTACH_READ_ONLY",
		63281460:  "BLANK",
		196311789: "CUSTOM_IMAGE",
		115302945: "DEFAULT",
		104218952: "DO_NOT_INCLUDE",
		62631959:  "SOURCE_IMAGE",
		76850316:  "SOURCE_IMAGE_FAMILY",
	}
	DiskInstantiationConfig_InstantiateFrom_value = map[string]int32{
		"UNDEFINED_INSTANTIATE_FROM": 0,
		"ATTACH_READ_ONLY":           513775419,
		"BLANK":                      63281460,
		"CUSTOM_IMAGE":               196311789,
		"DEFAULT":                    115302945,
		"DO_NOT_INCLUDE":             104218952,
		"SOURCE_IMAGE":               62631959,
		"SOURCE_IMAGE_FAMILY":        76850316,
	}
)

func (x DiskInstantiationConfig_InstantiateFrom) Enum() *DiskInstantiationConfig_InstantiateFrom {
	p := new(DiskInstantiationConfig_InstantiateFrom)
	*p = x
	return p
}

func (x DiskInstantiationConfig_InstantiateFrom) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DiskInstantiationConfig_InstantiateFrom) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[50].Descriptor()
}

func (DiskInstantiationConfig_InstantiateFrom) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[50]
}

func (x DiskInstantiationConfig_InstantiateFrom) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DiskInstantiationConfig_InstantiateFrom.Descriptor instead.
func (DiskInstantiationConfig_InstantiateFrom) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{252, 0}
}

// The distribution shape to which the group converges either proactively or on resize events (depending on the value set in updatePolicy.instanceRedistributionType).
type DistributionPolicy_TargetShape int32

const (
	// A value indicating that the enum field is not set.
	DistributionPolicy_UNDEFINED_TARGET_SHAPE DistributionPolicy_TargetShape = 0
	// The group picks zones for creating VM instances to fulfill the requested number of VMs within present resource constraints and to maximize utilization of unused zonal reservations. Recommended for batch workloads that do not require high availability.
	DistributionPolicy_ANY DistributionPolicy_TargetShape = 64972
	// The group prioritizes acquisition of resources, scheduling VMs in zones where resources are available while distributing VMs as evenly as possible across selected zones to minimize the impact of zonal failure. Recommended for highly available serving workloads.
	DistributionPolicy_BALANCED DistributionPolicy_TargetShape = 468409608
	// The group schedules VM instance creation and deletion to achieve and maintain an even number of managed instances across the selected zones. The distribution is even when the number of managed instances does not differ by more than 1 between any two zones. Recommended for highly available serving workloads.
	DistributionPolicy_EVEN DistributionPolicy_TargetShape = 2140442
)

// Enum value maps for DistributionPolicy_TargetShape.
var (
	DistributionPolicy_TargetShape_name = map[int32]string{
		0:         "UNDEFINED_TARGET_SHAPE",
		64972:     "ANY",
		468409608: "BALANCED",
		2140442:   "EVEN",
	}
	DistributionPolicy_TargetShape_value = map[string]int32{
		"UNDEFINED_TARGET_SHAPE": 0,
		"ANY":                    64972,
		"BALANCED":               468409608,
		"EVEN":                   2140442,
	}
)

func (x DistributionPolicy_TargetShape) Enum() *DistributionPolicy_TargetShape {
	p := new(DistributionPolicy_TargetShape)
	*p = x
	return p
}

func (x DistributionPolicy_TargetShape) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DistributionPolicy_TargetShape) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[51].Descriptor()
}

func (DistributionPolicy_TargetShape) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[51]
}

func (x DistributionPolicy_TargetShape) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DistributionPolicy_TargetShape.Descriptor instead.
func (DistributionPolicy_TargetShape) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{265, 0}
}

// The type of the peering route.
type ExchangedPeeringRoute_Type int32

const (
	// A value indicating that the enum field is not set.
	ExchangedPeeringRoute_UNDEFINED_TYPE ExchangedPeeringRoute_Type = 0
	// For routes exported from local network.
	ExchangedPeeringRoute_DYNAMIC_PEERING_ROUTE ExchangedPeeringRoute_Type = 469794858
	// The peering route.
	ExchangedPeeringRoute_STATIC_PEERING_ROUTE ExchangedPeeringRoute_Type = 473407545
	// The peering route corresponding to subnetwork range.
	ExchangedPeeringRoute_SUBNET_PEERING_ROUTE ExchangedPeeringRoute_Type = 465782504
)

// Enum value maps for ExchangedPeeringRoute_Type.
var (
	ExchangedPeeringRoute_Type_name = map[int32]string{
		0:         "UNDEFINED_TYPE",
		469794858: "DYNAMIC_PEERING_ROUTE",
		473407545: "STATIC_PEERING_ROUTE",
		465782504: "SUBNET_PEERING_ROUTE",
	}
	ExchangedPeeringRoute_Type_value = map[string]int32{
		"UNDEFINED_TYPE":        0,
		"DYNAMIC_PEERING_ROUTE": 469794858,
		"STATIC_PEERING_ROUTE":  473407545,
		"SUBNET_PEERING_ROUTE":  465782504,
	}
)

func (x ExchangedPeeringRoute_Type) Enum() *ExchangedPeeringRoute_Type {
	p := new(ExchangedPeeringRoute_Type)
	*p = x
	return p
}

func (x ExchangedPeeringRoute_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExchangedPeeringRoute_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[52].Descriptor()
}

func (ExchangedPeeringRoute_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[52]
}

func (x ExchangedPeeringRoute_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ExchangedPeeringRoute_Type.Descriptor instead.
func (ExchangedPeeringRoute_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{274, 0}
}

// Indicates the user-supplied redundancy type of this external VPN gateway.
type ExternalVpnGateway_RedundancyType int32

const (
	// A value indicating that the enum field is not set.
	ExternalVpnGateway_UNDEFINED_REDUNDANCY_TYPE ExternalVpnGateway_RedundancyType = 0
	// The external VPN gateway has four public IP addresses; at the time of writing this API, the AWS virtual private gateway is an example which has four public IP addresses for high availability connections; there should be two VPN connections in the AWS virtual private gateway , each AWS VPN connection has two public IP addresses; please make sure to put two public IP addresses from one AWS VPN connection into interfaces 0 and 1 of this external VPN gateway, and put the other two public IP addresses from another AWS VPN connection into interfaces 2 and 3 of this external VPN gateway. When displaying highly available configuration status for the VPN tunnels connected to FOUR_IPS_REDUNDANCY external VPN gateway, Google will always detect whether interfaces 0 and 1 are connected on one interface of HA Cloud VPN gateway, and detect whether interfaces 2 and 3 are connected to another interface of the HA Cloud VPN gateway.
	ExternalVpnGateway_FOUR_IPS_REDUNDANCY ExternalVpnGateway_RedundancyType = 520087913
	// The external VPN gateway has only one public IP address which internally provide redundancy or failover.
	ExternalVpnGateway_SINGLE_IP_INTERNALLY_REDUNDANT ExternalVpnGateway_RedundancyType = 133914873
	// The external VPN gateway has two public IP addresses which are redundant with each other, the following two types of setup on your on-premises side would have this type of redundancy: (1) Two separate on-premises gateways, each with one public IP address, the two on-premises gateways are redundant with each other. (2) A single on-premise gateway with two public IP addresses that are redundant with eatch other.
	ExternalVpnGateway_TWO_IPS_REDUNDANCY ExternalVpnGateway_RedundancyType = 367049635
)

// Enum value maps for ExternalVpnGateway_RedundancyType.
var (
	ExternalVpnGateway_RedundancyType_name = map[int32]string{
		0:         "UNDEFINED_REDUNDANCY_TYPE",
		520087913: "FOUR_IPS_REDUNDANCY",
		133914873: "SINGLE_IP_INTERNALLY_REDUNDANT",
		367049635: "TWO_IPS_REDUNDANCY",
	}
	ExternalVpnGateway_RedundancyType_value = map[string]int32{
		"UNDEFINED_REDUNDANCY_TYPE":      0,
		"FOUR_IPS_REDUNDANCY":            520087913,
		"SINGLE_IP_INTERNALLY_REDUNDANT": 133914873,
		"TWO_IPS_REDUNDANCY":             367049635,
	}
)

func (x ExternalVpnGateway_RedundancyType) Enum() *ExternalVpnGateway_RedundancyType {
	p := new(ExternalVpnGateway_RedundancyType)
	*p = x
	return p
}

func (x ExternalVpnGateway_RedundancyType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExternalVpnGateway_RedundancyType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[53].Descriptor()
}

func (ExternalVpnGateway_RedundancyType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[53]
}

func (x ExternalVpnGateway_RedundancyType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ExternalVpnGateway_RedundancyType.Descriptor instead.
func (ExternalVpnGateway_RedundancyType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{278, 0}
}

// The file type of source file.
type FileContentBuffer_FileType int32

const (
	// A value indicating that the enum field is not set.
	FileContentBuffer_UNDEFINED_FILE_TYPE FileContentBuffer_FileType = 0
	FileContentBuffer_BIN                 FileContentBuffer_FileType = 65767
	FileContentBuffer_UNDEFINED           FileContentBuffer_FileType = 137851184
	FileContentBuffer_X509                FileContentBuffer_FileType = 2674086
)

// Enum value maps for FileContentBuffer_FileType.
var (
	FileContentBuffer_FileType_name = map[int32]string{
		0:         "UNDEFINED_FILE_TYPE",
		65767:     "BIN",
		137851184: "UNDEFINED",
		2674086:   "X509",
	}
	FileContentBuffer_FileType_value = map[string]int32{
		"UNDEFINED_FILE_TYPE": 0,
		"BIN":                 65767,
		"UNDEFINED":           137851184,
		"X509":                2674086,
	}
)

func (x FileContentBuffer_FileType) Enum() *FileContentBuffer_FileType {
	p := new(FileContentBuffer_FileType)
	*p = x
	return p
}

func (x FileContentBuffer_FileType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FileContentBuffer_FileType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[54].Descriptor()
}

func (FileContentBuffer_FileType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[54]
}

func (x FileContentBuffer_FileType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FileContentBuffer_FileType.Descriptor instead.
func (FileContentBuffer_FileType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{281, 0}
}

// Direction of traffic to which this firewall applies, either `INGRESS` or `EGRESS`. The default is `INGRESS`. For `EGRESS` traffic, you cannot specify the sourceTags fields.
type Firewall_Direction int32

const (
	// A value indicating that the enum field is not set.
	Firewall_UNDEFINED_DIRECTION Firewall_Direction = 0
	// Indicates that firewall should apply to outgoing traffic.
	Firewall_EGRESS Firewall_Direction = 432880501
	// Indicates that firewall should apply to incoming traffic.
	Firewall_INGRESS Firewall_Direction = 516931221
)

// Enum value maps for Firewall_Direction.
var (
	Firewall_Direction_name = map[int32]string{
		0:         "UNDEFINED_DIRECTION",
		432880501: "EGRESS",
		516931221: "INGRESS",
	}
	Firewall_Direction_value = map[string]int32{
		"UNDEFINED_DIRECTION": 0,
		"EGRESS":              432880501,
		"INGRESS":             516931221,
	}
)

func (x Firewall_Direction) Enum() *Firewall_Direction {
	p := new(Firewall_Direction)
	*p = x
	return p
}

func (x Firewall_Direction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Firewall_Direction) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[55].Descriptor()
}

func (Firewall_Direction) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[55]
}

func (x Firewall_Direction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Firewall_Direction.Descriptor instead.
func (Firewall_Direction) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{282, 0}
}

// This field can only be specified for a particular firewall rule if logging is enabled for that rule. This field denotes whether to include or exclude metadata for firewall logs.
type FirewallLogConfig_Metadata int32

const (
	// A value indicating that the enum field is not set.
	FirewallLogConfig_UNDEFINED_METADATA   FirewallLogConfig_Metadata = 0
	FirewallLogConfig_EXCLUDE_ALL_METADATA FirewallLogConfig_Metadata = 334519954
	FirewallLogConfig_INCLUDE_ALL_METADATA FirewallLogConfig_Metadata = 164619908
)

// Enum value maps for FirewallLogConfig_Metadata.
var (
	FirewallLogConfig_Metadata_name = map[int32]string{
		0:         "UNDEFINED_METADATA",
		334519954: "EXCLUDE_ALL_METADATA",
		164619908: "INCLUDE_ALL_METADATA",
	}
	FirewallLogConfig_Metadata_value = map[string]int32{
		"UNDEFINED_METADATA":   0,
		"EXCLUDE_ALL_METADATA": 334519954,
		"INCLUDE_ALL_METADATA": 164619908,
	}
)

func (x FirewallLogConfig_Metadata) Enum() *FirewallLogConfig_Metadata {
	p := new(FirewallLogConfig_Metadata)
	*p = x
	return p
}

func (x FirewallLogConfig_Metadata) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FirewallLogConfig_Metadata) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[56].Descriptor()
}

func (FirewallLogConfig_Metadata) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[56]
}

func (x FirewallLogConfig_Metadata) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FirewallLogConfig_Metadata.Descriptor instead.
func (FirewallLogConfig_Metadata) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{284, 0}
}

// The direction in which this rule applies.
type FirewallPolicyRule_Direction int32

const (
	// A value indicating that the enum field is not set.
	FirewallPolicyRule_UNDEFINED_DIRECTION FirewallPolicyRule_Direction = 0
	FirewallPolicyRule_EGRESS              FirewallPolicyRule_Direction = 432880501
	FirewallPolicyRule_INGRESS             FirewallPolicyRule_Direction = 516931221
)

// Enum value maps for FirewallPolicyRule_Direction.
var (
	FirewallPolicyRule_Direction_name = map[int32]string{
		0:         "UNDEFINED_DIRECTION",
		432880501: "EGRESS",
		516931221: "INGRESS",
	}
	FirewallPolicyRule_Direction_value = map[string]int32{
		"UNDEFINED_DIRECTION": 0,
		"EGRESS":              432880501,
		"INGRESS":             516931221,
	}
)

func (x FirewallPolicyRule_Direction) Enum() *FirewallPolicyRule_Direction {
	p := new(FirewallPolicyRule_Direction)
	*p = x
	return p
}

func (x FirewallPolicyRule_Direction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FirewallPolicyRule_Direction) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[57].Descriptor()
}

func (FirewallPolicyRule_Direction) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[57]
}

func (x FirewallPolicyRule_Direction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FirewallPolicyRule_Direction.Descriptor instead.
func (FirewallPolicyRule_Direction) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{289, 0}
}

// [Output Only] State of the secure tag, either `EFFECTIVE` or `INEFFECTIVE`. A secure tag is `INEFFECTIVE` when it is deleted or its network is deleted.
type FirewallPolicyRuleSecureTag_State int32

const (
	// A value indicating that the enum field is not set.
	FirewallPolicyRuleSecureTag_UNDEFINED_STATE FirewallPolicyRuleSecureTag_State = 0
	FirewallPolicyRuleSecureTag_EFFECTIVE       FirewallPolicyRuleSecureTag_State = 244201863
	FirewallPolicyRuleSecureTag_INEFFECTIVE     FirewallPolicyRuleSecureTag_State = 304458242
)

// Enum value maps for FirewallPolicyRuleSecureTag_State.
var (
	FirewallPolicyRuleSecureTag_State_name = map[int32]string{
		0:         "UNDEFINED_STATE",
		244201863: "EFFECTIVE",
		304458242: "INEFFECTIVE",
	}
	FirewallPolicyRuleSecureTag_State_value = map[string]int32{
		"UNDEFINED_STATE": 0,
		"EFFECTIVE":       244201863,
		"INEFFECTIVE":     304458242,
	}
)

func (x FirewallPolicyRuleSecureTag_State) Enum() *FirewallPolicyRuleSecureTag_State {
	p := new(FirewallPolicyRuleSecureTag_State)
	*p = x
	return p
}

func (x FirewallPolicyRuleSecureTag_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FirewallPolicyRuleSecureTag_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[58].Descriptor()
}

func (FirewallPolicyRuleSecureTag_State) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[58]
}

func (x FirewallPolicyRuleSecureTag_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FirewallPolicyRuleSecureTag_State.Descriptor instead.
func (FirewallPolicyRuleSecureTag_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{292, 0}
}

// The IP protocol to which this rule applies. For protocol forwarding, valid options are TCP, UDP, ESP, AH, SCTP, ICMP and L3_DEFAULT. The valid IP protocols are different for different load balancing products as described in [Load balancing features](https://cloud.google.com/load-balancing/docs/features#protocols_from_the_load_balancer_to_the_backends).
type ForwardingRule_IPProtocolEnum int32

const (
	// A value indicating that the enum field is not set.
	ForwardingRule_UNDEFINED_I_P_PROTOCOL_ENUM ForwardingRule_IPProtocolEnum = 0
	ForwardingRule_AH                          ForwardingRule_IPProtocolEnum = 2087
	ForwardingRule_ESP                         ForwardingRule_IPProtocolEnum = 68962
	ForwardingRule_ICMP                        ForwardingRule_IPProtocolEnum = 2241597
	ForwardingRule_L3_DEFAULT                  ForwardingRule_IPProtocolEnum = 48151369
	ForwardingRule_SCTP                        ForwardingRule_IPProtocolEnum = 2539724
	ForwardingRule_TCP                         ForwardingRule_IPProtocolEnum = 82881
	ForwardingRule_UDP                         ForwardingRule_IPProtocolEnum = 83873
)

// Enum value maps for ForwardingRule_IPProtocolEnum.
var (
	ForwardingRule_IPProtocolEnum_name = map[int32]string{
		0:        "UNDEFINED_I_P_PROTOCOL_ENUM",
		2087:     "AH",
		68962:    "ESP",
		2241597:  "ICMP",
		48151369: "L3_DEFAULT",
		2539724:  "SCTP",
		82881:    "TCP",
		83873:    "UDP",
	}
	ForwardingRule_IPProtocolEnum_value = map[string]int32{
		"UNDEFINED_I_P_PROTOCOL_ENUM": 0,
		"AH":                          2087,
		"ESP":                         68962,
		"ICMP":                        2241597,
		"L3_DEFAULT":                  48151369,
		"SCTP":                        2539724,
		"TCP":                         82881,
		"UDP":                         83873,
	}
)

func (x ForwardingRule_IPProtocolEnum) Enum() *ForwardingRule_IPProtocolEnum {
	p := new(ForwardingRule_IPProtocolEnum)
	*p = x
	return p
}

func (x ForwardingRule_IPProtocolEnum) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ForwardingRule_IPProtocolEnum) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[59].Descriptor()
}

func (ForwardingRule_IPProtocolEnum) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[59]
}

func (x ForwardingRule_IPProtocolEnum) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ForwardingRule_IPProtocolEnum.Descriptor instead.
func (ForwardingRule_IPProtocolEnum) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{294, 0}
}

// The IP Version that will be used by this forwarding rule. Valid options are IPV4 or IPV6.
type ForwardingRule_IpVersion int32

const (
	// A value indicating that the enum field is not set.
	ForwardingRule_UNDEFINED_IP_VERSION ForwardingRule_IpVersion = 0
	ForwardingRule_IPV4                 ForwardingRule_IpVersion = 2254341
	ForwardingRule_IPV6                 ForwardingRule_IpVersion = 2254343
	ForwardingRule_UNSPECIFIED_VERSION  ForwardingRule_IpVersion = 21850000
)

// Enum value maps for ForwardingRule_IpVersion.
var (
	ForwardingRule_IpVersion_name = map[int32]string{
		0:        "UNDEFINED_IP_VERSION",
		2254341:  "IPV4",
		2254343:  "IPV6",
		21850000: "UNSPECIFIED_VERSION",
	}
	ForwardingRule_IpVersion_value = map[string]int32{
		"UNDEFINED_IP_VERSION": 0,
		"IPV4":                 2254341,
		"IPV6":                 2254343,
		"UNSPECIFIED_VERSION":  21850000,
	}
)

func (x ForwardingRule_IpVersion) Enum() *ForwardingRule_IpVersion {
	p := new(ForwardingRule_IpVersion)
	*p = x
	return p
}

func (x ForwardingRule_IpVersion) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ForwardingRule_IpVersion) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[60].Descriptor()
}

func (ForwardingRule_IpVersion) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[60]
}

func (x ForwardingRule_IpVersion) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ForwardingRule_IpVersion.Descriptor instead.
func (ForwardingRule_IpVersion) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{294, 1}
}

// Specifies the forwarding rule type. For more information about forwarding rules, refer to Forwarding rule concepts.
type ForwardingRule_LoadBalancingScheme int32

const (
	// A value indicating that the enum field is not set.
	ForwardingRule_UNDEFINED_LOAD_BALANCING_SCHEME ForwardingRule_LoadBalancingScheme = 0
	ForwardingRule_EXTERNAL                        ForwardingRule_LoadBalancingScheme = 35607499
	ForwardingRule_EXTERNAL_MANAGED                ForwardingRule_LoadBalancingScheme = 512006923
	ForwardingRule_INTERNAL                        ForwardingRule_LoadBalancingScheme = 279295677
	ForwardingRule_INTERNAL_MANAGED                ForwardingRule_LoadBalancingScheme = 37350397
	ForwardingRule_INTERNAL_SELF_MANAGED           ForwardingRule_LoadBalancingScheme = 236211150
	ForwardingRule_INVALID                         ForwardingRule_LoadBalancingScheme = 530283991
)

// Enum value maps for ForwardingRule_LoadBalancingScheme.
var (
	ForwardingRule_LoadBalancingScheme_name = map[int32]string{
		0:         "UNDEFINED_LOAD_BALANCING_SCHEME",
		35607499:  "EXTERNAL",
		512006923: "EXTERNAL_MANAGED",
		279295677: "INTERNAL",
		37350397:  "INTERNAL_MANAGED",
		236211150: "INTERNAL_SELF_MANAGED",
		530283991: "INVALID",
	}
	ForwardingRule_LoadBalancingScheme_value = map[string]int32{
		"UNDEFINED_LOAD_BALANCING_SCHEME": 0,
		"EXTERNAL":                        35607499,
		"EXTERNAL_MANAGED":                512006923,
		"INTERNAL":                        279295677,
		"INTERNAL_MANAGED":                37350397,
		"INTERNAL_SELF_MANAGED":           236211150,
		"INVALID":                         530283991,
	}
)

func (x ForwardingRule_LoadBalancingScheme) Enum() *ForwardingRule_LoadBalancingScheme {
	p := new(ForwardingRule_LoadBalancingScheme)
	*p = x
	return p
}

func (x ForwardingRule_LoadBalancingScheme) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ForwardingRule_LoadBalancingScheme) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[61].Descriptor()
}

func (ForwardingRule_LoadBalancingScheme) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[61]
}

func (x ForwardingRule_LoadBalancingScheme) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ForwardingRule_LoadBalancingScheme.Descriptor instead.
func (ForwardingRule_LoadBalancingScheme) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{294, 2}
}

// This signifies the networking tier used for configuring this load balancer and can only take the following values: PREMIUM, STANDARD. For regional ForwardingRule, the valid values are PREMIUM and STANDARD. For GlobalForwardingRule, the valid value is PREMIUM. If this field is not specified, it is assumed to be PREMIUM. If IPAddress is specified, this value must be equal to the networkTier of the Address.
type ForwardingRule_NetworkTier int32

const (
	// A value indicating that the enum field is not set.
	ForwardingRule_UNDEFINED_NETWORK_TIER ForwardingRule_NetworkTier = 0
	// Public internet quality with fixed bandwidth.
	ForwardingRule_FIXED_STANDARD ForwardingRule_NetworkTier = 310464328
	// High quality, Google-grade network tier, support for all networking products.
	ForwardingRule_PREMIUM ForwardingRule_NetworkTier = 399530551
	// Public internet quality, only limited support for other networking products.
	ForwardingRule_STANDARD ForwardingRule_NetworkTier = 484642493
	// (Output only) Temporary tier for FIXED_STANDARD when fixed standard tier is expired or not configured.
	ForwardingRule_STANDARD_OVERRIDES_FIXED_STANDARD ForwardingRule_NetworkTier = 465847234
)

// Enum value maps for ForwardingRule_NetworkTier.
var (
	ForwardingRule_NetworkTier_name = map[int32]string{
		0:         "UNDEFINED_NETWORK_TIER",
		310464328: "FIXED_STANDARD",
		399530551: "PREMIUM",
		484642493: "STANDARD",
		465847234: "STANDARD_OVERRIDES_FIXED_STANDARD",
	}
	ForwardingRule_NetworkTier_value = map[string]int32{
		"UNDEFINED_NETWORK_TIER":            0,
		"FIXED_STANDARD":                    310464328,
		"PREMIUM":                           399530551,
		"STANDARD":                          484642493,
		"STANDARD_OVERRIDES_FIXED_STANDARD": 465847234,
	}
)

func (x ForwardingRule_NetworkTier) Enum() *ForwardingRule_NetworkTier {
	p := new(ForwardingRule_NetworkTier)
	*p = x
	return p
}

func (x ForwardingRule_NetworkTier) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ForwardingRule_NetworkTier) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[62].Descriptor()
}

func (ForwardingRule_NetworkTier) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[62]
}

func (x ForwardingRule_NetworkTier) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ForwardingRule_NetworkTier.Descriptor instead.
func (ForwardingRule_NetworkTier) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{294, 3}
}

type ForwardingRule_PscConnectionStatus int32

const (
	// A value indicating that the enum field is not set.
	ForwardingRule_UNDEFINED_PSC_CONNECTION_STATUS ForwardingRule_PscConnectionStatus = 0
	// The connection has been accepted by the producer.
	ForwardingRule_ACCEPTED ForwardingRule_PscConnectionStatus = 246714279
	// The connection has been closed by the producer and will not serve traffic going forward.
	ForwardingRule_CLOSED ForwardingRule_PscConnectionStatus = 380163436
	// The connection has been accepted by the producer, but the producer needs to take further action before the forwarding rule can serve traffic.
	ForwardingRule_NEEDS_ATTENTION ForwardingRule_PscConnectionStatus = 344491452
	// The connection is pending acceptance by the producer.
	ForwardingRule_PENDING ForwardingRule_PscConnectionStatus = 35394935
	// The connection has been rejected by the producer.
	ForwardingRule_REJECTED           ForwardingRule_PscConnectionStatus = 174130302
	ForwardingRule_STATUS_UNSPECIFIED ForwardingRule_PscConnectionStatus = 42133066
)

// Enum value maps for ForwardingRule_PscConnectionStatus.
var (
	ForwardingRule_PscConnectionStatus_name = map[int32]string{
		0:         "UNDEFINED_PSC_CONNECTION_STATUS",
		246714279: "ACCEPTED",
		380163436: "CLOSED",
		344491452: "NEEDS_ATTENTION",
		35394935:  "PENDING",
		174130302: "REJECTED",
		42133066:  "STATUS_UNSPECIFIED",
	}
	ForwardingRule_PscConnectionStatus_value = map[string]int32{
		"UNDEFINED_PSC_CONNECTION_STATUS": 0,
		"ACCEPTED":                        246714279,
		"CLOSED":                          380163436,
		"NEEDS_ATTENTION":                 344491452,
		"PENDING":                         35394935,
		"REJECTED":                        174130302,
		"STATUS_UNSPECIFIED":              42133066,
	}
)

func (x ForwardingRule_PscConnectionStatus) Enum() *ForwardingRule_PscConnectionStatus {
	p := new(ForwardingRule_PscConnectionStatus)
	*p = x
	return p
}

func (x ForwardingRule_PscConnectionStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ForwardingRule_PscConnectionStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[63].Descriptor()
}

func (ForwardingRule_PscConnectionStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[63]
}

func (x ForwardingRule_PscConnectionStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ForwardingRule_PscConnectionStatus.Descriptor instead.
func (ForwardingRule_PscConnectionStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{294, 4}
}

// Specifies how a port is selected for health checking. Can be one of the following values: USE_FIXED_PORT: Specifies a port number explicitly using the port field in the health check. Supported by backend services for pass-through load balancers and backend services for proxy load balancers. Not supported by target pools. The health check supports all backends supported by the backend service provided the backend can be health checked. For example, GCE_VM_IP network endpoint groups, GCE_VM_IP_PORT network endpoint groups, and instance group backends. USE_NAMED_PORT: Not supported. USE_SERVING_PORT: Provides an indirect method of specifying the health check port by referring to the backend service. Only supported by backend services for proxy load balancers. Not supported by target pools. Not supported by backend services for pass-through load balancers. Supports all backends that can be health checked; for example, GCE_VM_IP_PORT network endpoint groups and instance group backends. For GCE_VM_IP_PORT network endpoint group backends, the health check uses the port number specified for each endpoint in the network endpoint group. For instance group backends, the health check uses the port number determined by looking up the backend service's named port in the instance group's list of named ports.
type GRPCHealthCheck_PortSpecification int32

const (
	// A value indicating that the enum field is not set.
	GRPCHealthCheck_UNDEFINED_PORT_SPECIFICATION GRPCHealthCheck_PortSpecification = 0
	// The port number in the health check's port is used for health checking. Applies to network endpoint group and instance group backends.
	GRPCHealthCheck_USE_FIXED_PORT GRPCHealthCheck_PortSpecification = 190235748
	// Not supported.
	GRPCHealthCheck_USE_NAMED_PORT GRPCHealthCheck_PortSpecification = 349300671
	// For network endpoint group backends, the health check uses the port number specified on each endpoint in the network endpoint group. For instance group backends, the health check uses the port number specified for the backend service's named port defined in the instance group's named ports.
	GRPCHealthCheck_USE_SERVING_PORT GRPCHealthCheck_PortSpecification = 362637516
)

// Enum value maps for GRPCHealthCheck_PortSpecification.
var (
	GRPCHealthCheck_PortSpecification_name = map[int32]string{
		0:         "UNDEFINED_PORT_SPECIFICATION",
		190235748: "USE_FIXED_PORT",
		349300671: "USE_NAMED_PORT",
		362637516: "USE_SERVING_PORT",
	}
	GRPCHealthCheck_PortSpecification_value = map[string]int32{
		"UNDEFINED_PORT_SPECIFICATION": 0,
		"USE_FIXED_PORT":               190235748,
		"USE_NAMED_PORT":               349300671,
		"USE_SERVING_PORT":             362637516,
	}
)

func (x GRPCHealthCheck_PortSpecification) Enum() *GRPCHealthCheck_PortSpecification {
	p := new(GRPCHealthCheck_PortSpecification)
	*p = x
	return p
}

func (x GRPCHealthCheck_PortSpecification) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GRPCHealthCheck_PortSpecification) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[64].Descriptor()
}

func (GRPCHealthCheck_PortSpecification) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[64]
}

func (x GRPCHealthCheck_PortSpecification) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GRPCHealthCheck_PortSpecification.Descriptor instead.
func (GRPCHealthCheck_PortSpecification) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{300, 0}
}

// The ID of a supported feature. To add multiple values, use commas to separate values. Set to one or more of the following values: - VIRTIO_SCSI_MULTIQUEUE - WINDOWS - MULTI_IP_SUBNET - UEFI_COMPATIBLE - GVNIC - SEV_CAPABLE - SUSPEND_RESUME_COMPATIBLE - SEV_SNP_CAPABLE - TDX_CAPABLE For more information, see Enabling guest operating system features.
type GuestOsFeature_Type int32

const (
	// A value indicating that the enum field is not set.
	GuestOsFeature_UNDEFINED_TYPE           GuestOsFeature_Type = 0
	GuestOsFeature_FEATURE_TYPE_UNSPECIFIED GuestOsFeature_Type = 531767259
	GuestOsFeature_GVNIC                    GuestOsFeature_Type = 68209305
	GuestOsFeature_MULTI_IP_SUBNET          GuestOsFeature_Type = 151776719
	GuestOsFeature_SECURE_BOOT              GuestOsFeature_Type = 376811194
	GuestOsFeature_SEV_CAPABLE              GuestOsFeature_Type = 87083793
	GuestOsFeature_SEV_LIVE_MIGRATABLE      GuestOsFeature_Type = 392039820
	GuestOsFeature_SEV_SNP_CAPABLE          GuestOsFeature_Type = 426919
	GuestOsFeature_UEFI_COMPATIBLE          GuestOsFeature_Type = 195865408
	GuestOsFeature_VIRTIO_SCSI_MULTIQUEUE   GuestOsFeature_Type = 201597069
	GuestOsFeature_WINDOWS                  GuestOsFeature_Type = 456863331
)

// Enum value maps for GuestOsFeature_Type.
var (
	GuestOsFeature_Type_name = map[int32]string{
		0:         "UNDEFINED_TYPE",
		531767259: "FEATURE_TYPE_UNSPECIFIED",
		68209305:  "GVNIC",
		151776719: "MULTI_IP_SUBNET",
		376811194: "SECURE_BOOT",
		87083793:  "SEV_CAPABLE",
		392039820: "SEV_LIVE_MIGRATABLE",
		426919:    "SEV_SNP_CAPABLE",
		195865408: "UEFI_COMPATIBLE",
		201597069: "VIRTIO_SCSI_MULTIQUEUE",
		456863331: "WINDOWS",
	}
	GuestOsFeature_Type_value = map[string]int32{
		"UNDEFINED_TYPE":           0,
		"FEATURE_TYPE_UNSPECIFIED": 531767259,
		"GVNIC":                    68209305,
		"MULTI_IP_SUBNET":          151776719,
		"SECURE_BOOT":              376811194,
		"SEV_CAPABLE":              87083793,
		"SEV_LIVE_MIGRATABLE":      392039820,
		"SEV_SNP_CAPABLE":          426919,
		"UEFI_COMPATIBLE":          195865408,
		"VIRTIO_SCSI_MULTIQUEUE":   201597069,
		"WINDOWS":                  456863331,
	}
)

func (x GuestOsFeature_Type) Enum() *GuestOsFeature_Type {
	p := new(GuestOsFeature_Type)
	*p = x
	return p
}

func (x GuestOsFeature_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GuestOsFeature_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[65].Descriptor()
}

func (GuestOsFeature_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[65]
}

func (x GuestOsFeature_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GuestOsFeature_Type.Descriptor instead.
func (GuestOsFeature_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{441, 0}
}

// Specifies how a port is selected for health checking. Can be one of the following values: USE_FIXED_PORT: Specifies a port number explicitly using the port field in the health check. Supported by backend services for pass-through load balancers and backend services for proxy load balancers. Not supported by target pools. The health check supports all backends supported by the backend service provided the backend can be health checked. For example, GCE_VM_IP network endpoint groups, GCE_VM_IP_PORT network endpoint groups, and instance group backends. USE_NAMED_PORT: Not supported. USE_SERVING_PORT: Provides an indirect method of specifying the health check port by referring to the backend service. Only supported by backend services for proxy load balancers. Not supported by target pools. Not supported by backend services for pass-through load balancers. Supports all backends that can be health checked; for example, GCE_VM_IP_PORT network endpoint groups and instance group backends. For GCE_VM_IP_PORT network endpoint group backends, the health check uses the port number specified for each endpoint in the network endpoint group. For instance group backends, the health check uses the port number determined by looking up the backend service's named port in the instance group's list of named ports.
type HTTP2HealthCheck_PortSpecification int32

const (
	// A value indicating that the enum field is not set.
	HTTP2HealthCheck_UNDEFINED_PORT_SPECIFICATION HTTP2HealthCheck_PortSpecification = 0
	// The port number in the health check's port is used for health checking. Applies to network endpoint group and instance group backends.
	HTTP2HealthCheck_USE_FIXED_PORT HTTP2HealthCheck_PortSpecification = 190235748
	// Not supported.
	HTTP2HealthCheck_USE_NAMED_PORT HTTP2HealthCheck_PortSpecification = 349300671
	// For network endpoint group backends, the health check uses the port number specified on each endpoint in the network endpoint group. For instance group backends, the health check uses the port number specified for the backend service's named port defined in the instance group's named ports.
	HTTP2HealthCheck_USE_SERVING_PORT HTTP2HealthCheck_PortSpecification = 362637516
)

// Enum value maps for HTTP2HealthCheck_PortSpecification.
var (
	HTTP2HealthCheck_PortSpecification_name = map[int32]string{
		0:         "UNDEFINED_PORT_SPECIFICATION",
		190235748: "USE_FIXED_PORT",
		349300671: "USE_NAMED_PORT",
		362637516: "USE_SERVING_PORT",
	}
	HTTP2HealthCheck_PortSpecification_value = map[string]int32{
		"UNDEFINED_PORT_SPECIFICATION": 0,
		"USE_FIXED_PORT":               190235748,
		"USE_NAMED_PORT":               349300671,
		"USE_SERVING_PORT":             362637516,
	}
)

func (x HTTP2HealthCheck_PortSpecification) Enum() *HTTP2HealthCheck_PortSpecification {
	p := new(HTTP2HealthCheck_PortSpecification)
	*p = x
	return p
}

func (x HTTP2HealthCheck_PortSpecification) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HTTP2HealthCheck_PortSpecification) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[66].Descriptor()
}

func (HTTP2HealthCheck_PortSpecification) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[66]
}

func (x HTTP2HealthCheck_PortSpecification) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HTTP2HealthCheck_PortSpecification.Descriptor instead.
func (HTTP2HealthCheck_PortSpecification) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{442, 0}
}

// Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
type HTTP2HealthCheck_ProxyHeader int32

const (
	// A value indicating that the enum field is not set.
	HTTP2HealthCheck_UNDEFINED_PROXY_HEADER HTTP2HealthCheck_ProxyHeader = 0
	HTTP2HealthCheck_NONE                   HTTP2HealthCheck_ProxyHeader = 2402104
	HTTP2HealthCheck_PROXY_V1               HTTP2HealthCheck_ProxyHeader = 334352940
)

// Enum value maps for HTTP2HealthCheck_ProxyHeader.
var (
	HTTP2HealthCheck_ProxyHeader_name = map[int32]string{
		0:         "UNDEFINED_PROXY_HEADER",
		2402104:   "NONE",
		334352940: "PROXY_V1",
	}
	HTTP2HealthCheck_ProxyHeader_value = map[string]int32{
		"UNDEFINED_PROXY_HEADER": 0,
		"NONE":                   2402104,
		"PROXY_V1":               334352940,
	}
)

func (x HTTP2HealthCheck_ProxyHeader) Enum() *HTTP2HealthCheck_ProxyHeader {
	p := new(HTTP2HealthCheck_ProxyHeader)
	*p = x
	return p
}

func (x HTTP2HealthCheck_ProxyHeader) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HTTP2HealthCheck_ProxyHeader) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[67].Descriptor()
}

func (HTTP2HealthCheck_ProxyHeader) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[67]
}

func (x HTTP2HealthCheck_ProxyHeader) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HTTP2HealthCheck_ProxyHeader.Descriptor instead.
func (HTTP2HealthCheck_ProxyHeader) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{442, 1}
}

// Specifies how a port is selected for health checking. Can be one of the following values: USE_FIXED_PORT: Specifies a port number explicitly using the port field in the health check. Supported by backend services for pass-through load balancers and backend services for proxy load balancers. Also supported in legacy HTTP health checks for target pools. The health check supports all backends supported by the backend service provided the backend can be health checked. For example, GCE_VM_IP network endpoint groups, GCE_VM_IP_PORT network endpoint groups, and instance group backends. USE_NAMED_PORT: Not supported. USE_SERVING_PORT: Provides an indirect method of specifying the health check port by referring to the backend service. Only supported by backend services for proxy load balancers. Not supported by target pools. Not supported by backend services for pass-through load balancers. Supports all backends that can be health checked; for example, GCE_VM_IP_PORT network endpoint groups and instance group backends. For GCE_VM_IP_PORT network endpoint group backends, the health check uses the port number specified for each endpoint in the network endpoint group. For instance group backends, the health check uses the port number determined by looking up the backend service's named port in the instance group's list of named ports.
type HTTPHealthCheck_PortSpecification int32

const (
	// A value indicating that the enum field is not set.
	HTTPHealthCheck_UNDEFINED_PORT_SPECIFICATION HTTPHealthCheck_PortSpecification = 0
	// The port number in the health check's port is used for health checking. Applies to network endpoint group and instance group backends.
	HTTPHealthCheck_USE_FIXED_PORT HTTPHealthCheck_PortSpecification = 190235748
	// Not supported.
	HTTPHealthCheck_USE_NAMED_PORT HTTPHealthCheck_PortSpecification = 349300671
	// For network endpoint group backends, the health check uses the port number specified on each endpoint in the network endpoint group. For instance group backends, the health check uses the port number specified for the backend service's named port defined in the instance group's named ports.
	HTTPHealthCheck_USE_SERVING_PORT HTTPHealthCheck_PortSpecification = 362637516
)

// Enum value maps for HTTPHealthCheck_PortSpecification.
var (
	HTTPHealthCheck_PortSpecification_name = map[int32]string{
		0:         "UNDEFINED_PORT_SPECIFICATION",
		190235748: "USE_FIXED_PORT",
		349300671: "USE_NAMED_PORT",
		362637516: "USE_SERVING_PORT",
	}
	HTTPHealthCheck_PortSpecification_value = map[string]int32{
		"UNDEFINED_PORT_SPECIFICATION": 0,
		"USE_FIXED_PORT":               190235748,
		"USE_NAMED_PORT":               349300671,
		"USE_SERVING_PORT":             362637516,
	}
)

func (x HTTPHealthCheck_PortSpecification) Enum() *HTTPHealthCheck_PortSpecification {
	p := new(HTTPHealthCheck_PortSpecification)
	*p = x
	return p
}

func (x HTTPHealthCheck_PortSpecification) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HTTPHealthCheck_PortSpecification) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[68].Descriptor()
}

func (HTTPHealthCheck_PortSpecification) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[68]
}

func (x HTTPHealthCheck_PortSpecification) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HTTPHealthCheck_PortSpecification.Descriptor instead.
func (HTTPHealthCheck_PortSpecification) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{443, 0}
}

// Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
type HTTPHealthCheck_ProxyHeader int32

const (
	// A value indicating that the enum field is not set.
	HTTPHealthCheck_UNDEFINED_PROXY_HEADER HTTPHealthCheck_ProxyHeader = 0
	HTTPHealthCheck_NONE                   HTTPHealthCheck_ProxyHeader = 2402104
	HTTPHealthCheck_PROXY_V1               HTTPHealthCheck_ProxyHeader = 334352940
)

// Enum value maps for HTTPHealthCheck_ProxyHeader.
var (
	HTTPHealthCheck_ProxyHeader_name = map[int32]string{
		0:         "UNDEFINED_PROXY_HEADER",
		2402104:   "NONE",
		334352940: "PROXY_V1",
	}
	HTTPHealthCheck_ProxyHeader_value = map[string]int32{
		"UNDEFINED_PROXY_HEADER": 0,
		"NONE":                   2402104,
		"PROXY_V1":               334352940,
	}
)

func (x HTTPHealthCheck_ProxyHeader) Enum() *HTTPHealthCheck_ProxyHeader {
	p := new(HTTPHealthCheck_ProxyHeader)
	*p = x
	return p
}

func (x HTTPHealthCheck_ProxyHeader) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HTTPHealthCheck_ProxyHeader) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[69].Descriptor()
}

func (HTTPHealthCheck_ProxyHeader) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[69]
}

func (x HTTPHealthCheck_ProxyHeader) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HTTPHealthCheck_ProxyHeader.Descriptor instead.
func (HTTPHealthCheck_ProxyHeader) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{443, 1}
}

// Specifies how a port is selected for health checking. Can be one of the following values: USE_FIXED_PORT: Specifies a port number explicitly using the port field in the health check. Supported by backend services for pass-through load balancers and backend services for proxy load balancers. Not supported by target pools. The health check supports all backends supported by the backend service provided the backend can be health checked. For example, GCE_VM_IP network endpoint groups, GCE_VM_IP_PORT network endpoint groups, and instance group backends. USE_NAMED_PORT: Not supported. USE_SERVING_PORT: Provides an indirect method of specifying the health check port by referring to the backend service. Only supported by backend services for proxy load balancers. Not supported by target pools. Not supported by backend services for pass-through load balancers. Supports all backends that can be health checked; for example, GCE_VM_IP_PORT network endpoint groups and instance group backends. For GCE_VM_IP_PORT network endpoint group backends, the health check uses the port number specified for each endpoint in the network endpoint group. For instance group backends, the health check uses the port number determined by looking up the backend service's named port in the instance group's list of named ports.
type HTTPSHealthCheck_PortSpecification int32

const (
	// A value indicating that the enum field is not set.
	HTTPSHealthCheck_UNDEFINED_PORT_SPECIFICATION HTTPSHealthCheck_PortSpecification = 0
	// The port number in the health check's port is used for health checking. Applies to network endpoint group and instance group backends.
	HTTPSHealthCheck_USE_FIXED_PORT HTTPSHealthCheck_PortSpecification = 190235748
	// Not supported.
	HTTPSHealthCheck_USE_NAMED_PORT HTTPSHealthCheck_PortSpecification = 349300671
	// For network endpoint group backends, the health check uses the port number specified on each endpoint in the network endpoint group. For instance group backends, the health check uses the port number specified for the backend service's named port defined in the instance group's named ports.
	HTTPSHealthCheck_USE_SERVING_PORT HTTPSHealthCheck_PortSpecification = 362637516
)

// Enum value maps for HTTPSHealthCheck_PortSpecification.
var (
	HTTPSHealthCheck_PortSpecification_name = map[int32]string{
		0:         "UNDEFINED_PORT_SPECIFICATION",
		190235748: "USE_FIXED_PORT",
		349300671: "USE_NAMED_PORT",
		362637516: "USE_SERVING_PORT",
	}
	HTTPSHealthCheck_PortSpecification_value = map[string]int32{
		"UNDEFINED_PORT_SPECIFICATION": 0,
		"USE_FIXED_PORT":               190235748,
		"USE_NAMED_PORT":               349300671,
		"USE_SERVING_PORT":             362637516,
	}
)

func (x HTTPSHealthCheck_PortSpecification) Enum() *HTTPSHealthCheck_PortSpecification {
	p := new(HTTPSHealthCheck_PortSpecification)
	*p = x
	return p
}

func (x HTTPSHealthCheck_PortSpecification) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HTTPSHealthCheck_PortSpecification) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[70].Descriptor()
}

func (HTTPSHealthCheck_PortSpecification) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[70]
}

func (x HTTPSHealthCheck_PortSpecification) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HTTPSHealthCheck_PortSpecification.Descriptor instead.
func (HTTPSHealthCheck_PortSpecification) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{444, 0}
}

// Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
type HTTPSHealthCheck_ProxyHeader int32

const (
	// A value indicating that the enum field is not set.
	HTTPSHealthCheck_UNDEFINED_PROXY_HEADER HTTPSHealthCheck_ProxyHeader = 0
	HTTPSHealthCheck_NONE                   HTTPSHealthCheck_ProxyHeader = 2402104
	HTTPSHealthCheck_PROXY_V1               HTTPSHealthCheck_ProxyHeader = 334352940
)

// Enum value maps for HTTPSHealthCheck_ProxyHeader.
var (
	HTTPSHealthCheck_ProxyHeader_name = map[int32]string{
		0:         "UNDEFINED_PROXY_HEADER",
		2402104:   "NONE",
		334352940: "PROXY_V1",
	}
	HTTPSHealthCheck_ProxyHeader_value = map[string]int32{
		"UNDEFINED_PROXY_HEADER": 0,
		"NONE":                   2402104,
		"PROXY_V1":               334352940,
	}
)

func (x HTTPSHealthCheck_ProxyHeader) Enum() *HTTPSHealthCheck_ProxyHeader {
	p := new(HTTPSHealthCheck_ProxyHeader)
	*p = x
	return p
}

func (x HTTPSHealthCheck_ProxyHeader) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HTTPSHealthCheck_ProxyHeader) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[71].Descriptor()
}

func (HTTPSHealthCheck_ProxyHeader) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[71]
}

func (x HTTPSHealthCheck_ProxyHeader) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HTTPSHealthCheck_ProxyHeader.Descriptor instead.
func (HTTPSHealthCheck_ProxyHeader) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{444, 1}
}

// Specifies the type of the healthCheck, either TCP, SSL, HTTP, HTTPS, HTTP2 or GRPC. Exactly one of the protocol-specific health check fields must be specified, which must match type field.
type HealthCheck_Type int32

const (
	// A value indicating that the enum field is not set.
	HealthCheck_UNDEFINED_TYPE HealthCheck_Type = 0
	HealthCheck_GRPC           HealthCheck_Type = 2196510
	HealthCheck_HTTP           HealthCheck_Type = 2228360
	HealthCheck_HTTP2          HealthCheck_Type = 69079210
	HealthCheck_HTTPS          HealthCheck_Type = 69079243
	HealthCheck_INVALID        HealthCheck_Type = 530283991
	HealthCheck_SSL            HealthCheck_Type = 82412
	HealthCheck_TCP            HealthCheck_Type = 82881
)

// Enum value maps for HealthCheck_Type.
var (
	HealthCheck_Type_name = map[int32]string{
		0:         "UNDEFINED_TYPE",
		2196510:   "GRPC",
		2228360:   "HTTP",
		69079210:  "HTTP2",
		69079243:  "HTTPS",
		530283991: "INVALID",
		82412:     "SSL",
		82881:     "TCP",
	}
	HealthCheck_Type_value = map[string]int32{
		"UNDEFINED_TYPE": 0,
		"GRPC":           2196510,
		"HTTP":           2228360,
		"HTTP2":          69079210,
		"HTTPS":          69079243,
		"INVALID":        530283991,
		"SSL":            82412,
		"TCP":            82881,
	}
)

func (x HealthCheck_Type) Enum() *HealthCheck_Type {
	p := new(HealthCheck_Type)
	*p = x
	return p
}

func (x HealthCheck_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HealthCheck_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[72].Descriptor()
}

func (HealthCheck_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[72]
}

func (x HealthCheck_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HealthCheck_Type.Descriptor instead.
func (HealthCheck_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{445, 0}
}

// Optional. Policy for how the results from multiple health checks for the same endpoint are aggregated. Defaults to NO_AGGREGATION if unspecified. - NO_AGGREGATION. An EndpointHealth message is returned for each pair in the health check service. - AND. If any health check of an endpoint reports UNHEALTHY, then UNHEALTHY is the HealthState of the endpoint. If all health checks report HEALTHY, the HealthState of the endpoint is HEALTHY. . This is only allowed with regional HealthCheckService.
type HealthCheckService_HealthStatusAggregationPolicy int32

const (
	// A value indicating that the enum field is not set.
	HealthCheckService_UNDEFINED_HEALTH_STATUS_AGGREGATION_POLICY HealthCheckService_HealthStatusAggregationPolicy = 0
	// If any backend's health check reports UNHEALTHY, then UNHEALTHY is the HealthState of the entire health check service. If all backend's are healthy, the HealthState of the health check service is HEALTHY.
	HealthCheckService_AND HealthCheckService_HealthStatusAggregationPolicy = 64951
	// An EndpointHealth message is returned for each backend in the health check service.
	HealthCheckService_NO_AGGREGATION HealthCheckService_HealthStatusAggregationPolicy = 426445124
)

// Enum value maps for HealthCheckService_HealthStatusAggregationPolicy.
var (
	HealthCheckService_HealthStatusAggregationPolicy_name = map[int32]string{
		0:         "UNDEFINED_HEALTH_STATUS_AGGREGATION_POLICY",
		64951:     "AND",
		426445124: "NO_AGGREGATION",
	}
	HealthCheckService_HealthStatusAggregationPolicy_value = map[string]int32{
		"UNDEFINED_HEALTH_STATUS_AGGREGATION_POLICY": 0,
		"AND":            64951,
		"NO_AGGREGATION": 426445124,
	}
)

func (x HealthCheckService_HealthStatusAggregationPolicy) Enum() *HealthCheckService_HealthStatusAggregationPolicy {
	p := new(HealthCheckService_HealthStatusAggregationPolicy)
	*p = x
	return p
}

func (x HealthCheckService_HealthStatusAggregationPolicy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HealthCheckService_HealthStatusAggregationPolicy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[73].Descriptor()
}

func (HealthCheckService_HealthStatusAggregationPolicy) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[73]
}

func (x HealthCheckService_HealthStatusAggregationPolicy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HealthCheckService_HealthStatusAggregationPolicy.Descriptor instead.
func (HealthCheckService_HealthStatusAggregationPolicy) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{449, 0}
}

// Health state of the instance.
type HealthStatus_HealthState int32

const (
	// A value indicating that the enum field is not set.
	HealthStatus_UNDEFINED_HEALTH_STATE HealthStatus_HealthState = 0
	HealthStatus_HEALTHY                HealthStatus_HealthState = 439801213
	HealthStatus_UNHEALTHY              HealthStatus_HealthState = 462118084
)

// Enum value maps for HealthStatus_HealthState.
var (
	HealthStatus_HealthState_name = map[int32]string{
		0:         "UNDEFINED_HEALTH_STATE",
		439801213: "HEALTHY",
		462118084: "UNHEALTHY",
	}
	HealthStatus_HealthState_value = map[string]int32{
		"UNDEFINED_HEALTH_STATE": 0,
		"HEALTHY":                439801213,
		"UNHEALTHY":              462118084,
	}
)

func (x HealthStatus_HealthState) Enum() *HealthStatus_HealthState {
	p := new(HealthStatus_HealthState)
	*p = x
	return p
}

func (x HealthStatus_HealthState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HealthStatus_HealthState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[74].Descriptor()
}

func (HealthStatus_HealthState) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[74]
}

func (x HealthStatus_HealthState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HealthStatus_HealthState.Descriptor instead.
func (HealthStatus_HealthState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{454, 0}
}

type HealthStatus_WeightError int32

const (
	// A value indicating that the enum field is not set.
	HealthStatus_UNDEFINED_WEIGHT_ERROR HealthStatus_WeightError = 0
	// The response to a Health Check probe had the HTTP response header field X-Load-Balancing-Endpoint-Weight, but its content was invalid (i.e., not a non-negative single-precision floating-point number in decimal string representation).
	HealthStatus_INVALID_WEIGHT HealthStatus_WeightError = 383698400
	// The response to a Health Check probe did not have the HTTP response header field X-Load-Balancing-Endpoint-Weight.
	HealthStatus_MISSING_WEIGHT HealthStatus_WeightError = 384027537
	// This is the value when the accompanied health status is either TIMEOUT (i.e.,the Health Check probe was not able to get a response in time) or UNKNOWN. For the latter, it should be typically because there has not been sufficient time to parse and report the weight for a new backend (which is with 0.0.0.0 ip address). However, it can be also due to an outage case for which the health status is explicitly reset to UNKNOWN.
	HealthStatus_UNAVAILABLE_WEIGHT HealthStatus_WeightError = 439464295
	// This is the default value when WeightReportMode is DISABLE, and is also the initial value when WeightReportMode has just updated to ENABLE or DRY_RUN and there has not been sufficient time to parse and report the backend weight.
	HealthStatus_WEIGHT_NONE HealthStatus_WeightError = 502428831
)

// Enum value maps for HealthStatus_WeightError.
var (
	HealthStatus_WeightError_name = map[int32]string{
		0:         "UNDEFINED_WEIGHT_ERROR",
		383698400: "INVALID_WEIGHT",
		384027537: "MISSING_WEIGHT",
		439464295: "UNAVAILABLE_WEIGHT",
		502428831: "WEIGHT_NONE",
	}
	HealthStatus_WeightError_value = map[string]int32{
		"UNDEFINED_WEIGHT_ERROR": 0,
		"INVALID_WEIGHT":         383698400,
		"MISSING_WEIGHT":         384027537,
		"UNAVAILABLE_WEIGHT":     439464295,
		"WEIGHT_NONE":            502428831,
	}
)

func (x HealthStatus_WeightError) Enum() *HealthStatus_WeightError {
	p := new(HealthStatus_WeightError)
	*p = x
	return p
}

func (x HealthStatus_WeightError) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HealthStatus_WeightError) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[75].Descriptor()
}

func (HealthStatus_WeightError) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[75]
}

func (x HealthStatus_WeightError) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HealthStatus_WeightError.Descriptor instead.
func (HealthStatus_WeightError) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{454, 1}
}

// Health state of the network endpoint determined based on the health checks configured.
type HealthStatusForNetworkEndpoint_HealthState int32

const (
	// A value indicating that the enum field is not set.
	HealthStatusForNetworkEndpoint_UNDEFINED_HEALTH_STATE HealthStatusForNetworkEndpoint_HealthState = 0
	// Endpoint is being drained.
	HealthStatusForNetworkEndpoint_DRAINING HealthStatusForNetworkEndpoint_HealthState = 480455402
	// Endpoint is healthy.
	HealthStatusForNetworkEndpoint_HEALTHY HealthStatusForNetworkEndpoint_HealthState = 439801213
	// Endpoint is unhealthy.
	HealthStatusForNetworkEndpoint_UNHEALTHY HealthStatusForNetworkEndpoint_HealthState = 462118084
	// Health status of the endpoint is unknown.
	HealthStatusForNetworkEndpoint_UNKNOWN HealthStatusForNetworkEndpoint_HealthState = 433141802
)

// Enum value maps for HealthStatusForNetworkEndpoint_HealthState.
var (
	HealthStatusForNetworkEndpoint_HealthState_name = map[int32]string{
		0:         "UNDEFINED_HEALTH_STATE",
		480455402: "DRAINING",
		439801213: "HEALTHY",
		462118084: "UNHEALTHY",
		433141802: "UNKNOWN",
	}
	HealthStatusForNetworkEndpoint_HealthState_value = map[string]int32{
		"UNDEFINED_HEALTH_STATE": 0,
		"DRAINING":               480455402,
		"HEALTHY":                439801213,
		"UNHEALTHY":              462118084,
		"UNKNOWN":                433141802,
	}
)

func (x HealthStatusForNetworkEndpoint_HealthState) Enum() *HealthStatusForNetworkEndpoint_HealthState {
	p := new(HealthStatusForNetworkEndpoint_HealthState)
	*p = x
	return p
}

func (x HealthStatusForNetworkEndpoint_HealthState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HealthStatusForNetworkEndpoint_HealthState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[76].Descriptor()
}

func (HealthStatusForNetworkEndpoint_HealthState) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[76]
}

func (x HealthStatusForNetworkEndpoint_HealthState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HealthStatusForNetworkEndpoint_HealthState.Descriptor instead.
func (HealthStatusForNetworkEndpoint_HealthState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{455, 0}
}

// The HTTP Status code to use for this RedirectAction. Supported values are: - MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to 301. - FOUND, which corresponds to 302. - SEE_OTHER which corresponds to 303. - TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request method is retained. - PERMANENT_REDIRECT, which corresponds to 308. In this case, the request method is retained.
type HttpRedirectAction_RedirectResponseCode int32

const (
	// A value indicating that the enum field is not set.
	HttpRedirectAction_UNDEFINED_REDIRECT_RESPONSE_CODE HttpRedirectAction_RedirectResponseCode = 0
	// Http Status Code 302 - Found.
	HttpRedirectAction_FOUND HttpRedirectAction_RedirectResponseCode = 67084130
	// Http Status Code 301 - Moved Permanently.
	HttpRedirectAction_MOVED_PERMANENTLY_DEFAULT HttpRedirectAction_RedirectResponseCode = 386698449
	// Http Status Code 308 - Permanent Redirect maintaining HTTP method.
	HttpRedirectAction_PERMANENT_REDIRECT HttpRedirectAction_RedirectResponseCode = 382006381
	// Http Status Code 303 - See Other.
	HttpRedirectAction_SEE_OTHER HttpRedirectAction_RedirectResponseCode = 445380580
	// Http Status Code 307 - Temporary Redirect maintaining HTTP method.
	HttpRedirectAction_TEMPORARY_REDIRECT HttpRedirectAction_RedirectResponseCode = 489550378
)

// Enum value maps for HttpRedirectAction_RedirectResponseCode.
var (
	HttpRedirectAction_RedirectResponseCode_name = map[int32]string{
		0:         "UNDEFINED_REDIRECT_RESPONSE_CODE",
		67084130:  "FOUND",
		386698449: "MOVED_PERMANENTLY_DEFAULT",
		382006381: "PERMANENT_REDIRECT",
		445380580: "SEE_OTHER",
		489550378: "TEMPORARY_REDIRECT",
	}
	HttpRedirectAction_RedirectResponseCode_value = map[string]int32{
		"UNDEFINED_REDIRECT_RESPONSE_CODE": 0,
		"FOUND":                            67084130,
		"MOVED_PERMANENTLY_DEFAULT":        386698449,
		"PERMANENT_REDIRECT":               382006381,
		"SEE_OTHER":                        445380580,
		"TEMPORARY_REDIRECT":               489550378,
	}
)

func (x HttpRedirectAction_RedirectResponseCode) Enum() *HttpRedirectAction_RedirectResponseCode {
	p := new(HttpRedirectAction_RedirectResponseCode)
	*p = x
	return p
}

func (x HttpRedirectAction_RedirectResponseCode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HttpRedirectAction_RedirectResponseCode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[77].Descriptor()
}

func (HttpRedirectAction_RedirectResponseCode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[77]
}

func (x HttpRedirectAction_RedirectResponseCode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HttpRedirectAction_RedirectResponseCode.Descriptor instead.
func (HttpRedirectAction_RedirectResponseCode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{466, 0}
}

// The architecture of the image. Valid values are ARM64 or X86_64.
type Image_Architecture int32

const (
	// A value indicating that the enum field is not set.
	Image_UNDEFINED_ARCHITECTURE Image_Architecture = 0
	// Default value indicating Architecture is not set.
	Image_ARCHITECTURE_UNSPECIFIED Image_Architecture = 394750507
	// Machines with architecture ARM64
	Image_ARM64 Image_Architecture = 62547450
	// Machines with architecture X86_64
	Image_X86_64 Image_Architecture = 425300551
)

// Enum value maps for Image_Architecture.
var (
	Image_Architecture_name = map[int32]string{
		0:         "UNDEFINED_ARCHITECTURE",
		394750507: "ARCHITECTURE_UNSPECIFIED",
		62547450:  "ARM64",
		425300551: "X86_64",
	}
	Image_Architecture_value = map[string]int32{
		"UNDEFINED_ARCHITECTURE":   0,
		"ARCHITECTURE_UNSPECIFIED": 394750507,
		"ARM64":                    62547450,
		"X86_64":                   425300551,
	}
)

func (x Image_Architecture) Enum() *Image_Architecture {
	p := new(Image_Architecture)
	*p = x
	return p
}

func (x Image_Architecture) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Image_Architecture) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[78].Descriptor()
}

func (Image_Architecture) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[78]
}

func (x Image_Architecture) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Image_Architecture.Descriptor instead.
func (Image_Architecture) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{471, 0}
}

// The type of the image used to create this disk. The default and only valid value is RAW.
type Image_SourceType int32

const (
	// A value indicating that the enum field is not set.
	Image_UNDEFINED_SOURCE_TYPE Image_SourceType = 0
	Image_RAW                   Image_SourceType = 80904
)

// Enum value maps for Image_SourceType.
var (
	Image_SourceType_name = map[int32]string{
		0:     "UNDEFINED_SOURCE_TYPE",
		80904: "RAW",
	}
	Image_SourceType_value = map[string]int32{
		"UNDEFINED_SOURCE_TYPE": 0,
		"RAW":                   80904,
	}
)

func (x Image_SourceType) Enum() *Image_SourceType {
	p := new(Image_SourceType)
	*p = x
	return p
}

func (x Image_SourceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Image_SourceType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[79].Descriptor()
}

func (Image_SourceType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[79]
}

func (x Image_SourceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Image_SourceType.Descriptor instead.
func (Image_SourceType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{471, 1}
}

// [Output Only] The status of the image. An image can be used to create other resources, such as instances, only after the image has been successfully created and the status is set to READY. Possible values are FAILED, PENDING, or READY.
type Image_Status int32

const (
	// A value indicating that the enum field is not set.
	Image_UNDEFINED_STATUS Image_Status = 0
	// Image is deleting.
	Image_DELETING Image_Status = 528602024
	// Image creation failed due to an error.
	Image_FAILED Image_Status = 455706685
	// Image hasn't been created as yet.
	Image_PENDING Image_Status = 35394935
	// Image has been successfully created.
	Image_READY Image_Status = 77848963
)

// Enum value maps for Image_Status.
var (
	Image_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		528602024: "DELETING",
		455706685: "FAILED",
		35394935:  "PENDING",
		77848963:  "READY",
	}
	Image_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"DELETING":         528602024,
		"FAILED":           455706685,
		"PENDING":          35394935,
		"READY":            77848963,
	}
)

func (x Image_Status) Enum() *Image_Status {
	p := new(Image_Status)
	*p = x
	return p
}

func (x Image_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Image_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[80].Descriptor()
}

func (Image_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[80]
}

func (x Image_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Image_Status.Descriptor instead.
func (Image_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{471, 2}
}

// KeyRevocationActionType of the instance. Supported options are "STOP" and "NONE". The default value is "NONE" if it is not specified.
type Instance_KeyRevocationActionType int32

const (
	// A value indicating that the enum field is not set.
	Instance_UNDEFINED_KEY_REVOCATION_ACTION_TYPE Instance_KeyRevocationActionType = 0
	// Default value. This value is unused.
	Instance_KEY_REVOCATION_ACTION_TYPE_UNSPECIFIED Instance_KeyRevocationActionType = 467110106
	// Indicates user chose no operation.
	Instance_NONE Instance_KeyRevocationActionType = 2402104
	// Indicates user chose to opt for VM shutdown on key revocation.
	Instance_STOP Instance_KeyRevocationActionType = 2555906
)

// Enum value maps for Instance_KeyRevocationActionType.
var (
	Instance_KeyRevocationActionType_name = map[int32]string{
		0:         "UNDEFINED_KEY_REVOCATION_ACTION_TYPE",
		467110106: "KEY_REVOCATION_ACTION_TYPE_UNSPECIFIED",
		2402104:   "NONE",
		2555906:   "STOP",
	}
	Instance_KeyRevocationActionType_value = map[string]int32{
		"UNDEFINED_KEY_REVOCATION_ACTION_TYPE":   0,
		"KEY_REVOCATION_ACTION_TYPE_UNSPECIFIED": 467110106,
		"NONE":                                   2402104,
		"STOP":                                   2555906,
	}
)

func (x Instance_KeyRevocationActionType) Enum() *Instance_KeyRevocationActionType {
	p := new(Instance_KeyRevocationActionType)
	*p = x
	return p
}

func (x Instance_KeyRevocationActionType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Instance_KeyRevocationActionType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[81].Descriptor()
}

func (Instance_KeyRevocationActionType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[81]
}

func (x Instance_KeyRevocationActionType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Instance_KeyRevocationActionType.Descriptor instead.
func (Instance_KeyRevocationActionType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{547, 0}
}

// The private IPv6 google access type for the VM. If not specified, use INHERIT_FROM_SUBNETWORK as default.
type Instance_PrivateIpv6GoogleAccess int32

const (
	// A value indicating that the enum field is not set.
	Instance_UNDEFINED_PRIVATE_IPV6_GOOGLE_ACCESS Instance_PrivateIpv6GoogleAccess = 0
	// Bidirectional private IPv6 access to/from Google services. If specified, the subnetwork who is attached to the instance's default network interface will be assigned an internal IPv6 prefix if it doesn't have before.
	Instance_ENABLE_BIDIRECTIONAL_ACCESS_TO_GOOGLE Instance_PrivateIpv6GoogleAccess = 427975994
	// Outbound private IPv6 access from VMs in this subnet to Google services. If specified, the subnetwork who is attached to the instance's default network interface will be assigned an internal IPv6 prefix if it doesn't have before.
	Instance_ENABLE_OUTBOUND_VM_ACCESS_TO_GOOGLE Instance_PrivateIpv6GoogleAccess = 288210263
	// Each network interface inherits PrivateIpv6GoogleAccess from its subnetwork.
	Instance_INHERIT_FROM_SUBNETWORK Instance_PrivateIpv6GoogleAccess = 530256959
)

// Enum value maps for Instance_PrivateIpv6GoogleAccess.
var (
	Instance_PrivateIpv6GoogleAccess_name = map[int32]string{
		0:         "UNDEFINED_PRIVATE_IPV6_GOOGLE_ACCESS",
		427975994: "ENABLE_BIDIRECTIONAL_ACCESS_TO_GOOGLE",
		288210263: "ENABLE_OUTBOUND_VM_ACCESS_TO_GOOGLE",
		530256959: "INHERIT_FROM_SUBNETWORK",
	}
	Instance_PrivateIpv6GoogleAccess_value = map[string]int32{
		"UNDEFINED_PRIVATE_IPV6_GOOGLE_ACCESS":  0,
		"ENABLE_BIDIRECTIONAL_ACCESS_TO_GOOGLE": 427975994,
		"ENABLE_OUTBOUND_VM_ACCESS_TO_GOOGLE":   288210263,
		"INHERIT_FROM_SUBNETWORK":               530256959,
	}
)

func (x Instance_PrivateIpv6GoogleAccess) Enum() *Instance_PrivateIpv6GoogleAccess {
	p := new(Instance_PrivateIpv6GoogleAccess)
	*p = x
	return p
}

func (x Instance_PrivateIpv6GoogleAccess) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Instance_PrivateIpv6GoogleAccess) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[82].Descriptor()
}

func (Instance_PrivateIpv6GoogleAccess) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[82]
}

func (x Instance_PrivateIpv6GoogleAccess) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Instance_PrivateIpv6GoogleAccess.Descriptor instead.
func (Instance_PrivateIpv6GoogleAccess) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{547, 1}
}

// [Output Only] The status of the instance. One of the following values: PROVISIONING, STAGING, RUNNING, STOPPING, SUSPENDING, SUSPENDED, REPAIRING, and TERMINATED. For more information about the status of the instance, see Instance life cycle.
type Instance_Status int32

const (
	// A value indicating that the enum field is not set.
	Instance_UNDEFINED_STATUS Instance_Status = 0
	// The Nanny is halted and we are performing tear down tasks like network deprogramming, releasing quota, IP, tearing down disks etc.
	Instance_DEPROVISIONING Instance_Status = 428935662
	// Resources are being allocated for the instance.
	Instance_PROVISIONING Instance_Status = 290896621
	// The instance is in repair.
	Instance_REPAIRING Instance_Status = 413483285
	// The instance is running.
	Instance_RUNNING Instance_Status = 121282975
	// All required resources have been allocated and the instance is being started.
	Instance_STAGING Instance_Status = 431072283
	// The instance has stopped successfully.
	Instance_STOPPED Instance_Status = 444276141
	// The instance is currently stopping (either being deleted or killed).
	Instance_STOPPING Instance_Status = 350791796
	// The instance has suspended.
	Instance_SUSPENDED Instance_Status = 51223995
	// The instance is suspending.
	Instance_SUSPENDING Instance_Status = 514206246
	// The instance has stopped (either by explicit action or underlying failure).
	Instance_TERMINATED Instance_Status = 250018339
)

// Enum value maps for Instance_Status.
var (
	Instance_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		428935662: "DEPROVISIONING",
		290896621: "PROVISIONING",
		413483285: "REPAIRING",
		121282975: "RUNNING",
		431072283: "STAGING",
		444276141: "STOPPED",
		350791796: "STOPPING",
		51223995:  "SUSPENDED",
		514206246: "SUSPENDING",
		250018339: "TERMINATED",
	}
	Instance_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"DEPROVISIONING":   428935662,
		"PROVISIONING":     290896621,
		"REPAIRING":        413483285,
		"RUNNING":          121282975,
		"STAGING":          431072283,
		"STOPPED":          444276141,
		"STOPPING":         350791796,
		"SUSPENDED":        51223995,
		"SUSPENDING":       514206246,
		"TERMINATED":       250018339,
	}
)

func (x Instance_Status) Enum() *Instance_Status {
	p := new(Instance_Status)
	*p = x
	return p
}

func (x Instance_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Instance_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[83].Descriptor()
}

func (Instance_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[83]
}

func (x Instance_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Instance_Status.Descriptor instead.
func (Instance_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{547, 2}
}

// Pagination behavior of the listManagedInstances API method for this managed instance group.
type InstanceGroupManager_ListManagedInstancesResults int32

const (
	// A value indicating that the enum field is not set.
	InstanceGroupManager_UNDEFINED_LIST_MANAGED_INSTANCES_RESULTS InstanceGroupManager_ListManagedInstancesResults = 0
	// (Default) Pagination is disabled for the group's listManagedInstances API method. maxResults and pageToken query parameters are ignored and all instances are returned in a single response.
	InstanceGroupManager_PAGELESS InstanceGroupManager_ListManagedInstancesResults = 32183464
	// Pagination is enabled for the group's listManagedInstances API method. maxResults and pageToken query parameters are respected.
	InstanceGroupManager_PAGINATED InstanceGroupManager_ListManagedInstancesResults = 40190637
)

// Enum value maps for InstanceGroupManager_ListManagedInstancesResults.
var (
	InstanceGroupManager_ListManagedInstancesResults_name = map[int32]string{
		0:        "UNDEFINED_LIST_MANAGED_INSTANCES_RESULTS",
		32183464: "PAGELESS",
		40190637: "PAGINATED",
	}
	InstanceGroupManager_ListManagedInstancesResults_value = map[string]int32{
		"UNDEFINED_LIST_MANAGED_INSTANCES_RESULTS": 0,
		"PAGELESS":  32183464,
		"PAGINATED": 40190637,
	}
)

func (x InstanceGroupManager_ListManagedInstancesResults) Enum() *InstanceGroupManager_ListManagedInstancesResults {
	p := new(InstanceGroupManager_ListManagedInstancesResults)
	*p = x
	return p
}

func (x InstanceGroupManager_ListManagedInstancesResults) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstanceGroupManager_ListManagedInstancesResults) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[84].Descriptor()
}

func (InstanceGroupManager_ListManagedInstancesResults) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[84]
}

func (x InstanceGroupManager_ListManagedInstancesResults) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstanceGroupManager_ListManagedInstancesResults.Descriptor instead.
func (InstanceGroupManager_ListManagedInstancesResults) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{554, 0}
}

// The instance redistribution policy for regional managed instance groups. Valid values are: - PROACTIVE (default): The group attempts to maintain an even distribution of VM instances across zones in the region. - NONE: For non-autoscaled groups, proactive redistribution is disabled.
// Additional supported values which may be not listed in the enum directly due to technical reasons:
// NONE
// PROACTIVE
type InstanceGroupManagerUpdatePolicy_InstanceRedistributionType int32

const (
	// A value indicating that the enum field is not set.
	InstanceGroupManagerUpdatePolicy_UNDEFINED_INSTANCE_REDISTRIBUTION_TYPE InstanceGroupManagerUpdatePolicy_InstanceRedistributionType = 0
)

// Enum value maps for InstanceGroupManagerUpdatePolicy_InstanceRedistributionType.
var (
	InstanceGroupManagerUpdatePolicy_InstanceRedistributionType_name = map[int32]string{
		0: "UNDEFINED_INSTANCE_REDISTRIBUTION_TYPE",
	}
	InstanceGroupManagerUpdatePolicy_InstanceRedistributionType_value = map[string]int32{
		"UNDEFINED_INSTANCE_REDISTRIBUTION_TYPE": 0,
	}
)

func (x InstanceGroupManagerUpdatePolicy_InstanceRedistributionType) Enum() *InstanceGroupManagerUpdatePolicy_InstanceRedistributionType {
	p := new(InstanceGroupManagerUpdatePolicy_InstanceRedistributionType)
	*p = x
	return p
}

func (x InstanceGroupManagerUpdatePolicy_InstanceRedistributionType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstanceGroupManagerUpdatePolicy_InstanceRedistributionType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[85].Descriptor()
}

func (InstanceGroupManagerUpdatePolicy_InstanceRedistributionType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[85]
}

func (x InstanceGroupManagerUpdatePolicy_InstanceRedistributionType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstanceGroupManagerUpdatePolicy_InstanceRedistributionType.Descriptor instead.
func (InstanceGroupManagerUpdatePolicy_InstanceRedistributionType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{563, 0}
}

// Minimal action to be taken on an instance. Use this option to minimize disruption as much as possible or to apply a more disruptive action than is necessary. - To limit disruption as much as possible, set the minimal action to REFRESH. If your update requires a more disruptive action, Compute Engine performs the necessary action to execute the update. - To apply a more disruptive action than is strictly necessary, set the minimal action to RESTART or REPLACE. For example, Compute Engine does not need to restart a VM to change its metadata. But if your application reads instance metadata only when a VM is restarted, you can set the minimal action to RESTART in order to pick up metadata changes.
// Additional supported values which may be not listed in the enum directly due to technical reasons:
// NONE
// REFRESH
// REPLACE
// RESTART
type InstanceGroupManagerUpdatePolicy_MinimalAction int32

const (
	// A value indicating that the enum field is not set.
	InstanceGroupManagerUpdatePolicy_UNDEFINED_MINIMAL_ACTION InstanceGroupManagerUpdatePolicy_MinimalAction = 0
)

// Enum value maps for InstanceGroupManagerUpdatePolicy_MinimalAction.
var (
	InstanceGroupManagerUpdatePolicy_MinimalAction_name = map[int32]string{
		0: "UNDEFINED_MINIMAL_ACTION",
	}
	InstanceGroupManagerUpdatePolicy_MinimalAction_value = map[string]int32{
		"UNDEFINED_MINIMAL_ACTION": 0,
	}
)

func (x InstanceGroupManagerUpdatePolicy_MinimalAction) Enum() *InstanceGroupManagerUpdatePolicy_MinimalAction {
	p := new(InstanceGroupManagerUpdatePolicy_MinimalAction)
	*p = x
	return p
}

func (x InstanceGroupManagerUpdatePolicy_MinimalAction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstanceGroupManagerUpdatePolicy_MinimalAction) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[86].Descriptor()
}

func (InstanceGroupManagerUpdatePolicy_MinimalAction) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[86]
}

func (x InstanceGroupManagerUpdatePolicy_MinimalAction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstanceGroupManagerUpdatePolicy_MinimalAction.Descriptor instead.
func (InstanceGroupManagerUpdatePolicy_MinimalAction) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{563, 1}
}

// Most disruptive action that is allowed to be taken on an instance. You can specify either NONE to forbid any actions, REFRESH to allow actions that do not need instance restart, RESTART to allow actions that can be applied without instance replacing or REPLACE to allow all possible actions. If the Updater determines that the minimal update action needed is more disruptive than most disruptive allowed action you specify it will not perform the update at all.
// Additional supported values which may be not listed in the enum directly due to technical reasons:
// NONE
// REFRESH
// REPLACE
// RESTART
type InstanceGroupManagerUpdatePolicy_MostDisruptiveAllowedAction int32

const (
	// A value indicating that the enum field is not set.
	InstanceGroupManagerUpdatePolicy_UNDEFINED_MOST_DISRUPTIVE_ALLOWED_ACTION InstanceGroupManagerUpdatePolicy_MostDisruptiveAllowedAction = 0
)

// Enum value maps for InstanceGroupManagerUpdatePolicy_MostDisruptiveAllowedAction.
var (
	InstanceGroupManagerUpdatePolicy_MostDisruptiveAllowedAction_name = map[int32]string{
		0: "UNDEFINED_MOST_DISRUPTIVE_ALLOWED_ACTION",
	}
	InstanceGroupManagerUpdatePolicy_MostDisruptiveAllowedAction_value = map[string]int32{
		"UNDEFINED_MOST_DISRUPTIVE_ALLOWED_ACTION": 0,
	}
)

func (x InstanceGroupManagerUpdatePolicy_MostDisruptiveAllowedAction) Enum() *InstanceGroupManagerUpdatePolicy_MostDisruptiveAllowedAction {
	p := new(InstanceGroupManagerUpdatePolicy_MostDisruptiveAllowedAction)
	*p = x
	return p
}

func (x InstanceGroupManagerUpdatePolicy_MostDisruptiveAllowedAction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstanceGroupManagerUpdatePolicy_MostDisruptiveAllowedAction) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[87].Descriptor()
}

func (InstanceGroupManagerUpdatePolicy_MostDisruptiveAllowedAction) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[87]
}

func (x InstanceGroupManagerUpdatePolicy_MostDisruptiveAllowedAction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstanceGroupManagerUpdatePolicy_MostDisruptiveAllowedAction.Descriptor instead.
func (InstanceGroupManagerUpdatePolicy_MostDisruptiveAllowedAction) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{563, 2}
}

// What action should be used to replace instances. See minimal_action.REPLACE
type InstanceGroupManagerUpdatePolicy_ReplacementMethod int32

const (
	// A value indicating that the enum field is not set.
	InstanceGroupManagerUpdatePolicy_UNDEFINED_REPLACEMENT_METHOD InstanceGroupManagerUpdatePolicy_ReplacementMethod = 0
	// Instances will be recreated (with the same name)
	InstanceGroupManagerUpdatePolicy_RECREATE InstanceGroupManagerUpdatePolicy_ReplacementMethod = 522644719
	// Default option: instances will be deleted and created (with a new name)
	InstanceGroupManagerUpdatePolicy_SUBSTITUTE InstanceGroupManagerUpdatePolicy_ReplacementMethod = 280924314
)

// Enum value maps for InstanceGroupManagerUpdatePolicy_ReplacementMethod.
var (
	InstanceGroupManagerUpdatePolicy_ReplacementMethod_name = map[int32]string{
		0:         "UNDEFINED_REPLACEMENT_METHOD",
		522644719: "RECREATE",
		280924314: "SUBSTITUTE",
	}
	InstanceGroupManagerUpdatePolicy_ReplacementMethod_value = map[string]int32{
		"UNDEFINED_REPLACEMENT_METHOD": 0,
		"RECREATE":                     522644719,
		"SUBSTITUTE":                   280924314,
	}
)

func (x InstanceGroupManagerUpdatePolicy_ReplacementMethod) Enum() *InstanceGroupManagerUpdatePolicy_ReplacementMethod {
	p := new(InstanceGroupManagerUpdatePolicy_ReplacementMethod)
	*p = x
	return p
}

func (x InstanceGroupManagerUpdatePolicy_ReplacementMethod) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstanceGroupManagerUpdatePolicy_ReplacementMethod) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[88].Descriptor()
}

func (InstanceGroupManagerUpdatePolicy_ReplacementMethod) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[88]
}

func (x InstanceGroupManagerUpdatePolicy_ReplacementMethod) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstanceGroupManagerUpdatePolicy_ReplacementMethod.Descriptor instead.
func (InstanceGroupManagerUpdatePolicy_ReplacementMethod) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{563, 3}
}

// The type of update process. You can specify either PROACTIVE so that the instance group manager proactively executes actions in order to bring instances to their target versions or OPPORTUNISTIC so that no action is proactively executed but the update will be performed as part of other actions (for example, resizes or recreateInstances calls).
// Additional supported values which may be not listed in the enum directly due to technical reasons:
// PROACTIVE
type InstanceGroupManagerUpdatePolicy_Type int32

const (
	// A value indicating that the enum field is not set.
	InstanceGroupManagerUpdatePolicy_UNDEFINED_TYPE InstanceGroupManagerUpdatePolicy_Type = 0
	// No action is being proactively performed in order to bring this IGM to its target version distribution (regardless of whether this distribution is expressed using instanceTemplate or versions field).
	InstanceGroupManagerUpdatePolicy_OPPORTUNISTIC InstanceGroupManagerUpdatePolicy_Type = 429530089
)

// Enum value maps for InstanceGroupManagerUpdatePolicy_Type.
var (
	InstanceGroupManagerUpdatePolicy_Type_name = map[int32]string{
		0:         "UNDEFINED_TYPE",
		429530089: "OPPORTUNISTIC",
	}
	InstanceGroupManagerUpdatePolicy_Type_value = map[string]int32{
		"UNDEFINED_TYPE": 0,
		"OPPORTUNISTIC":  429530089,
	}
)

func (x InstanceGroupManagerUpdatePolicy_Type) Enum() *InstanceGroupManagerUpdatePolicy_Type {
	p := new(InstanceGroupManagerUpdatePolicy_Type)
	*p = x
	return p
}

func (x InstanceGroupManagerUpdatePolicy_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstanceGroupManagerUpdatePolicy_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[89].Descriptor()
}

func (InstanceGroupManagerUpdatePolicy_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[89]
}

func (x InstanceGroupManagerUpdatePolicy_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstanceGroupManagerUpdatePolicy_Type.Descriptor instead.
func (InstanceGroupManagerUpdatePolicy_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{563, 4}
}

// The minimal action that you want to perform on each instance during the update: - REPLACE: At minimum, delete the instance and create it again. - RESTART: Stop the instance and start it again. - REFRESH: Do not stop the instance. - NONE: Do not disrupt the instance at all. By default, the minimum action is NONE. If your update requires a more disruptive action than you set with this flag, the necessary action is performed to execute the update.
// Additional supported values which may be not listed in the enum directly due to technical reasons:
// NONE
// REFRESH
// REPLACE
// RESTART
type InstanceGroupManagersApplyUpdatesRequest_MinimalAction int32

const (
	// A value indicating that the enum field is not set.
	InstanceGroupManagersApplyUpdatesRequest_UNDEFINED_MINIMAL_ACTION InstanceGroupManagersApplyUpdatesRequest_MinimalAction = 0
)

// Enum value maps for InstanceGroupManagersApplyUpdatesRequest_MinimalAction.
var (
	InstanceGroupManagersApplyUpdatesRequest_MinimalAction_name = map[int32]string{
		0: "UNDEFINED_MINIMAL_ACTION",
	}
	InstanceGroupManagersApplyUpdatesRequest_MinimalAction_value = map[string]int32{
		"UNDEFINED_MINIMAL_ACTION": 0,
	}
)

func (x InstanceGroupManagersApplyUpdatesRequest_MinimalAction) Enum() *InstanceGroupManagersApplyUpdatesRequest_MinimalAction {
	p := new(InstanceGroupManagersApplyUpdatesRequest_MinimalAction)
	*p = x
	return p
}

func (x InstanceGroupManagersApplyUpdatesRequest_MinimalAction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstanceGroupManagersApplyUpdatesRequest_MinimalAction) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[90].Descriptor()
}

func (InstanceGroupManagersApplyUpdatesRequest_MinimalAction) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[90]
}

func (x InstanceGroupManagersApplyUpdatesRequest_MinimalAction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstanceGroupManagersApplyUpdatesRequest_MinimalAction.Descriptor instead.
func (InstanceGroupManagersApplyUpdatesRequest_MinimalAction) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{566, 0}
}

// The most disruptive action that you want to perform on each instance during the update: - REPLACE: Delete the instance and create it again. - RESTART: Stop the instance and start it again. - REFRESH: Do not stop the instance. - NONE: Do not disrupt the instance at all. By default, the most disruptive allowed action is REPLACE. If your update requires a more disruptive action than you set with this flag, the update request will fail.
// Additional supported values which may be not listed in the enum directly due to technical reasons:
// NONE
// REFRESH
// REPLACE
// RESTART
type InstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction int32

const (
	// A value indicating that the enum field is not set.
	InstanceGroupManagersApplyUpdatesRequest_UNDEFINED_MOST_DISRUPTIVE_ALLOWED_ACTION InstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction = 0
)

// Enum value maps for InstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction.
var (
	InstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction_name = map[int32]string{
		0: "UNDEFINED_MOST_DISRUPTIVE_ALLOWED_ACTION",
	}
	InstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction_value = map[string]int32{
		"UNDEFINED_MOST_DISRUPTIVE_ALLOWED_ACTION": 0,
	}
)

func (x InstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction) Enum() *InstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction {
	p := new(InstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction)
	*p = x
	return p
}

func (x InstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[91].Descriptor()
}

func (InstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[91]
}

func (x InstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction.Descriptor instead.
func (InstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{566, 1}
}

// A filter for the state of the instances in the instance group. Valid options are ALL or RUNNING. If you do not specify this parameter the list includes all instances regardless of their state.
type InstanceGroupsListInstancesRequest_InstanceState int32

const (
	// A value indicating that the enum field is not set.
	InstanceGroupsListInstancesRequest_UNDEFINED_INSTANCE_STATE InstanceGroupsListInstancesRequest_InstanceState = 0
	// Includes all instances in the generated list regardless of their state.
	InstanceGroupsListInstancesRequest_ALL InstanceGroupsListInstancesRequest_InstanceState = 64897
	// Includes instances in the generated list only if they have a RUNNING state.
	InstanceGroupsListInstancesRequest_RUNNING InstanceGroupsListInstancesRequest_InstanceState = 121282975
)

// Enum value maps for InstanceGroupsListInstancesRequest_InstanceState.
var (
	InstanceGroupsListInstancesRequest_InstanceState_name = map[int32]string{
		0:         "UNDEFINED_INSTANCE_STATE",
		64897:     "ALL",
		121282975: "RUNNING",
	}
	InstanceGroupsListInstancesRequest_InstanceState_value = map[string]int32{
		"UNDEFINED_INSTANCE_STATE": 0,
		"ALL":                      64897,
		"RUNNING":                  121282975,
	}
)

func (x InstanceGroupsListInstancesRequest_InstanceState) Enum() *InstanceGroupsListInstancesRequest_InstanceState {
	p := new(InstanceGroupsListInstancesRequest_InstanceState)
	*p = x
	return p
}

func (x InstanceGroupsListInstancesRequest_InstanceState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstanceGroupsListInstancesRequest_InstanceState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[92].Descriptor()
}

func (InstanceGroupsListInstancesRequest_InstanceState) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[92]
}

func (x InstanceGroupsListInstancesRequest_InstanceState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstanceGroupsListInstancesRequest_InstanceState.Descriptor instead.
func (InstanceGroupsListInstancesRequest_InstanceState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{581, 0}
}

// [Output Only] Action that managed instance group was executing on the instance when the error occurred. Possible values:
type InstanceManagedByIgmErrorInstanceActionDetails_Action int32

const (
	// A value indicating that the enum field is not set.
	InstanceManagedByIgmErrorInstanceActionDetails_UNDEFINED_ACTION InstanceManagedByIgmErrorInstanceActionDetails_Action = 0
	// The managed instance group is abandoning this instance. The instance will be removed from the instance group and from any target pools that are associated with this group.
	InstanceManagedByIgmErrorInstanceActionDetails_ABANDONING InstanceManagedByIgmErrorInstanceActionDetails_Action = 388244813
	// The managed instance group is creating this instance. If the group fails to create this instance, it will try again until it is successful.
	InstanceManagedByIgmErrorInstanceActionDetails_CREATING InstanceManagedByIgmErrorInstanceActionDetails_Action = 455564985
	// The managed instance group is attempting to create this instance only once. If the group fails to create this instance, it does not try again and the group's targetSize value is decreased.
	InstanceManagedByIgmErrorInstanceActionDetails_CREATING_WITHOUT_RETRIES InstanceManagedByIgmErrorInstanceActionDetails_Action = 428843785
	// The managed instance group is permanently deleting this instance.
	InstanceManagedByIgmErrorInstanceActionDetails_DELETING InstanceManagedByIgmErrorInstanceActionDetails_Action = 528602024
	// The managed instance group has not scheduled any actions for this instance.
	InstanceManagedByIgmErrorInstanceActionDetails_NONE InstanceManagedByIgmErrorInstanceActionDetails_Action = 2402104
	// The managed instance group is recreating this instance.
	InstanceManagedByIgmErrorInstanceActionDetails_RECREATING InstanceManagedByIgmErrorInstanceActionDetails_Action = 287278572
	// The managed instance group is applying configuration changes to the instance without stopping it. For example, the group can update the target pool list for an instance without stopping that instance.
	InstanceManagedByIgmErrorInstanceActionDetails_REFRESHING InstanceManagedByIgmErrorInstanceActionDetails_Action = 163266343
	// The managed instance group is restarting this instance.
	InstanceManagedByIgmErrorInstanceActionDetails_RESTARTING InstanceManagedByIgmErrorInstanceActionDetails_Action = 320534387
	// The managed instance group is resuming this instance.
	InstanceManagedByIgmErrorInstanceActionDetails_RESUMING InstanceManagedByIgmErrorInstanceActionDetails_Action = 446856618
	// The managed instance group is starting this instance.
	InstanceManagedByIgmErrorInstanceActionDetails_STARTING InstanceManagedByIgmErrorInstanceActionDetails_Action = 488820800
	// The managed instance group is stopping this instance.
	InstanceManagedByIgmErrorInstanceActionDetails_STOPPING InstanceManagedByIgmErrorInstanceActionDetails_Action = 350791796
	// The managed instance group is suspending this instance.
	InstanceManagedByIgmErrorInstanceActionDetails_SUSPENDING InstanceManagedByIgmErrorInstanceActionDetails_Action = 514206246
	// The managed instance group is verifying this already created instance. Verification happens every time the instance is (re)created or restarted and consists of: 1. Waiting until health check specified as part of this managed instance group's autohealing policy reports HEALTHY. Note: Applies only if autohealing policy has a health check specified 2. Waiting for addition verification steps performed as post-instance creation (subject to future extensions).
	InstanceManagedByIgmErrorInstanceActionDetails_VERIFYING InstanceManagedByIgmErrorInstanceActionDetails_Action = 16982185
)

// Enum value maps for InstanceManagedByIgmErrorInstanceActionDetails_Action.
var (
	InstanceManagedByIgmErrorInstanceActionDetails_Action_name = map[int32]string{
		0:         "UNDEFINED_ACTION",
		388244813: "ABANDONING",
		455564985: "CREATING",
		428843785: "CREATING_WITHOUT_RETRIES",
		528602024: "DELETING",
		2402104:   "NONE",
		287278572: "RECREATING",
		163266343: "REFRESHING",
		320534387: "RESTARTING",
		446856618: "RESUMING",
		488820800: "STARTING",
		350791796: "STOPPING",
		514206246: "SUSPENDING",
		16982185:  "VERIFYING",
	}
	InstanceManagedByIgmErrorInstanceActionDetails_Action_value = map[string]int32{
		"UNDEFINED_ACTION":         0,
		"ABANDONING":               388244813,
		"CREATING":                 455564985,
		"CREATING_WITHOUT_RETRIES": 428843785,
		"DELETING":                 528602024,
		"NONE":                     2402104,
		"RECREATING":               287278572,
		"REFRESHING":               163266343,
		"RESTARTING":               320534387,
		"RESUMING":                 446856618,
		"STARTING":                 488820800,
		"STOPPING":                 350791796,
		"SUSPENDING":               514206246,
		"VERIFYING":                16982185,
	}
)

func (x InstanceManagedByIgmErrorInstanceActionDetails_Action) Enum() *InstanceManagedByIgmErrorInstanceActionDetails_Action {
	p := new(InstanceManagedByIgmErrorInstanceActionDetails_Action)
	*p = x
	return p
}

func (x InstanceManagedByIgmErrorInstanceActionDetails_Action) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstanceManagedByIgmErrorInstanceActionDetails_Action) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[93].Descriptor()
}

func (InstanceManagedByIgmErrorInstanceActionDetails_Action) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[93]
}

func (x InstanceManagedByIgmErrorInstanceActionDetails_Action) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstanceManagedByIgmErrorInstanceActionDetails_Action.Descriptor instead.
func (InstanceManagedByIgmErrorInstanceActionDetails_Action) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{588, 0}
}

// KeyRevocationActionType of the instance. Supported options are "STOP" and "NONE". The default value is "NONE" if it is not specified.
type InstanceProperties_KeyRevocationActionType int32

const (
	// A value indicating that the enum field is not set.
	InstanceProperties_UNDEFINED_KEY_REVOCATION_ACTION_TYPE InstanceProperties_KeyRevocationActionType = 0
	// Default value. This value is unused.
	InstanceProperties_KEY_REVOCATION_ACTION_TYPE_UNSPECIFIED InstanceProperties_KeyRevocationActionType = 467110106
	// Indicates user chose no operation.
	InstanceProperties_NONE InstanceProperties_KeyRevocationActionType = 2402104
	// Indicates user chose to opt for VM shutdown on key revocation.
	InstanceProperties_STOP InstanceProperties_KeyRevocationActionType = 2555906
)

// Enum value maps for InstanceProperties_KeyRevocationActionType.
var (
	InstanceProperties_KeyRevocationActionType_name = map[int32]string{
		0:         "UNDEFINED_KEY_REVOCATION_ACTION_TYPE",
		467110106: "KEY_REVOCATION_ACTION_TYPE_UNSPECIFIED",
		2402104:   "NONE",
		2555906:   "STOP",
	}
	InstanceProperties_KeyRevocationActionType_value = map[string]int32{
		"UNDEFINED_KEY_REVOCATION_ACTION_TYPE":   0,
		"KEY_REVOCATION_ACTION_TYPE_UNSPECIFIED": 467110106,
		"NONE":                                   2402104,
		"STOP":                                   2555906,
	}
)

func (x InstanceProperties_KeyRevocationActionType) Enum() *InstanceProperties_KeyRevocationActionType {
	p := new(InstanceProperties_KeyRevocationActionType)
	*p = x
	return p
}

func (x InstanceProperties_KeyRevocationActionType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstanceProperties_KeyRevocationActionType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[94].Descriptor()
}

func (InstanceProperties_KeyRevocationActionType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[94]
}

func (x InstanceProperties_KeyRevocationActionType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstanceProperties_KeyRevocationActionType.Descriptor instead.
func (InstanceProperties_KeyRevocationActionType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{592, 0}
}

// The private IPv6 google access type for VMs. If not specified, use INHERIT_FROM_SUBNETWORK as default. Note that for MachineImage, this is not supported yet.
type InstanceProperties_PrivateIpv6GoogleAccess int32

const (
	// A value indicating that the enum field is not set.
	InstanceProperties_UNDEFINED_PRIVATE_IPV6_GOOGLE_ACCESS InstanceProperties_PrivateIpv6GoogleAccess = 0
	// Bidirectional private IPv6 access to/from Google services. If specified, the subnetwork who is attached to the instance's default network interface will be assigned an internal IPv6 prefix if it doesn't have before.
	InstanceProperties_ENABLE_BIDIRECTIONAL_ACCESS_TO_GOOGLE InstanceProperties_PrivateIpv6GoogleAccess = 427975994
	// Outbound private IPv6 access from VMs in this subnet to Google services. If specified, the subnetwork who is attached to the instance's default network interface will be assigned an internal IPv6 prefix if it doesn't have before.
	InstanceProperties_ENABLE_OUTBOUND_VM_ACCESS_TO_GOOGLE InstanceProperties_PrivateIpv6GoogleAccess = 288210263
	// Each network interface inherits PrivateIpv6GoogleAccess from its subnetwork.
	InstanceProperties_INHERIT_FROM_SUBNETWORK InstanceProperties_PrivateIpv6GoogleAccess = 530256959
)

// Enum value maps for InstanceProperties_PrivateIpv6GoogleAccess.
var (
	InstanceProperties_PrivateIpv6GoogleAccess_name = map[int32]string{
		0:         "UNDEFINED_PRIVATE_IPV6_GOOGLE_ACCESS",
		427975994: "ENABLE_BIDIRECTIONAL_ACCESS_TO_GOOGLE",
		288210263: "ENABLE_OUTBOUND_VM_ACCESS_TO_GOOGLE",
		530256959: "INHERIT_FROM_SUBNETWORK",
	}
	InstanceProperties_PrivateIpv6GoogleAccess_value = map[string]int32{
		"UNDEFINED_PRIVATE_IPV6_GOOGLE_ACCESS":  0,
		"ENABLE_BIDIRECTIONAL_ACCESS_TO_GOOGLE": 427975994,
		"ENABLE_OUTBOUND_VM_ACCESS_TO_GOOGLE":   288210263,
		"INHERIT_FROM_SUBNETWORK":               530256959,
	}
)

func (x InstanceProperties_PrivateIpv6GoogleAccess) Enum() *InstanceProperties_PrivateIpv6GoogleAccess {
	p := new(InstanceProperties_PrivateIpv6GoogleAccess)
	*p = x
	return p
}

func (x InstanceProperties_PrivateIpv6GoogleAccess) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstanceProperties_PrivateIpv6GoogleAccess) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[95].Descriptor()
}

func (InstanceProperties_PrivateIpv6GoogleAccess) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[95]
}

func (x InstanceProperties_PrivateIpv6GoogleAccess) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstanceProperties_PrivateIpv6GoogleAccess.Descriptor instead.
func (InstanceProperties_PrivateIpv6GoogleAccess) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{592, 1}
}

// [Output Only] The status of the instance.
type InstanceWithNamedPorts_Status int32

const (
	// A value indicating that the enum field is not set.
	InstanceWithNamedPorts_UNDEFINED_STATUS InstanceWithNamedPorts_Status = 0
	// The Nanny is halted and we are performing tear down tasks like network deprogramming, releasing quota, IP, tearing down disks etc.
	InstanceWithNamedPorts_DEPROVISIONING InstanceWithNamedPorts_Status = 428935662
	// Resources are being allocated for the instance.
	InstanceWithNamedPorts_PROVISIONING InstanceWithNamedPorts_Status = 290896621
	// The instance is in repair.
	InstanceWithNamedPorts_REPAIRING InstanceWithNamedPorts_Status = 413483285
	// The instance is running.
	InstanceWithNamedPorts_RUNNING InstanceWithNamedPorts_Status = 121282975
	// All required resources have been allocated and the instance is being started.
	InstanceWithNamedPorts_STAGING InstanceWithNamedPorts_Status = 431072283
	// The instance has stopped successfully.
	InstanceWithNamedPorts_STOPPED InstanceWithNamedPorts_Status = 444276141
	// The instance is currently stopping (either being deleted or killed).
	InstanceWithNamedPorts_STOPPING InstanceWithNamedPorts_Status = 350791796
	// The instance has suspended.
	InstanceWithNamedPorts_SUSPENDED InstanceWithNamedPorts_Status = 51223995
	// The instance is suspending.
	InstanceWithNamedPorts_SUSPENDING InstanceWithNamedPorts_Status = 514206246
	// The instance has stopped (either by explicit action or underlying failure).
	InstanceWithNamedPorts_TERMINATED InstanceWithNamedPorts_Status = 250018339
)

// Enum value maps for InstanceWithNamedPorts_Status.
var (
	InstanceWithNamedPorts_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		428935662: "DEPROVISIONING",
		290896621: "PROVISIONING",
		413483285: "REPAIRING",
		121282975: "RUNNING",
		431072283: "STAGING",
		444276141: "STOPPED",
		350791796: "STOPPING",
		51223995:  "SUSPENDED",
		514206246: "SUSPENDING",
		250018339: "TERMINATED",
	}
	InstanceWithNamedPorts_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"DEPROVISIONING":   428935662,
		"PROVISIONING":     290896621,
		"REPAIRING":        413483285,
		"RUNNING":          121282975,
		"STAGING":          431072283,
		"STOPPED":          444276141,
		"STOPPING":         350791796,
		"SUSPENDED":        51223995,
		"SUSPENDING":       514206246,
		"TERMINATED":       250018339,
	}
)

func (x InstanceWithNamedPorts_Status) Enum() *InstanceWithNamedPorts_Status {
	p := new(InstanceWithNamedPorts_Status)
	*p = x
	return p
}

func (x InstanceWithNamedPorts_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstanceWithNamedPorts_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[96].Descriptor()
}

func (InstanceWithNamedPorts_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[96]
}

func (x InstanceWithNamedPorts_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstanceWithNamedPorts_Status.Descriptor instead.
func (InstanceWithNamedPorts_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{598, 0}
}

// [Output Only] The type of the firewall policy. Can be one of HIERARCHY, NETWORK, NETWORK_REGIONAL.
type InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type int32

const (
	// A value indicating that the enum field is not set.
	InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_UNDEFINED_TYPE   InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type = 0
	InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_HIERARCHY        InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type = 69902869
	InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_NETWORK          InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type = 413984270
	InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_NETWORK_REGIONAL InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type = 190804272
	InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_UNSPECIFIED      InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type = 526786327
)

// Enum value maps for InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type.
var (
	InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type_name = map[int32]string{
		0:         "UNDEFINED_TYPE",
		69902869:  "HIERARCHY",
		413984270: "NETWORK",
		190804272: "NETWORK_REGIONAL",
		526786327: "UNSPECIFIED",
	}
	InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type_value = map[string]int32{
		"UNDEFINED_TYPE":   0,
		"HIERARCHY":        69902869,
		"NETWORK":          413984270,
		"NETWORK_REGIONAL": 190804272,
		"UNSPECIFIED":      526786327,
	}
)

func (x InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type) Enum() *InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type {
	p := new(InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type)
	*p = x
	return p
}

func (x InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[97].Descriptor()
}

func (InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[97]
}

func (x InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type.Descriptor instead.
func (InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{601, 0}
}

// Type of interconnect, which can take one of the following values: - PARTNER: A partner-managed interconnection shared between customers though a partner. - DEDICATED: A dedicated physical interconnection with the customer. Note that a value IT_PRIVATE has been deprecated in favor of DEDICATED.
type Interconnect_InterconnectType int32

const (
	// A value indicating that the enum field is not set.
	Interconnect_UNDEFINED_INTERCONNECT_TYPE Interconnect_InterconnectType = 0
	// A dedicated physical interconnection with the customer.
	Interconnect_DEDICATED Interconnect_InterconnectType = 258411983
	// [Deprecated] A private, physical interconnection with the customer.
	Interconnect_IT_PRIVATE Interconnect_InterconnectType = 335677007
	// A partner-managed interconnection shared between customers via partner.
	Interconnect_PARTNER Interconnect_InterconnectType = 461924520
)

// Enum value maps for Interconnect_InterconnectType.
var (
	Interconnect_InterconnectType_name = map[int32]string{
		0:         "UNDEFINED_INTERCONNECT_TYPE",
		258411983: "DEDICATED",
		335677007: "IT_PRIVATE",
		461924520: "PARTNER",
	}
	Interconnect_InterconnectType_value = map[string]int32{
		"UNDEFINED_INTERCONNECT_TYPE": 0,
		"DEDICATED":                   258411983,
		"IT_PRIVATE":                  335677007,
		"PARTNER":                     461924520,
	}
)

func (x Interconnect_InterconnectType) Enum() *Interconnect_InterconnectType {
	p := new(Interconnect_InterconnectType)
	*p = x
	return p
}

func (x Interconnect_InterconnectType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Interconnect_InterconnectType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[98].Descriptor()
}

func (Interconnect_InterconnectType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[98]
}

func (x Interconnect_InterconnectType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Interconnect_InterconnectType.Descriptor instead.
func (Interconnect_InterconnectType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{612, 0}
}

// Type of link requested, which can take one of the following values: - LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics - LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics. Note that this field indicates the speed of each of the links in the bundle, not the speed of the entire bundle.
type Interconnect_LinkType int32

const (
	// A value indicating that the enum field is not set.
	Interconnect_UNDEFINED_LINK_TYPE Interconnect_LinkType = 0
	// 100G Ethernet, LR Optics.
	Interconnect_LINK_TYPE_ETHERNET_100G_LR Interconnect_LinkType = 337672551
	// 10G Ethernet, LR Optics. [(rate_bps) = 10000000000];
	Interconnect_LINK_TYPE_ETHERNET_10G_LR Interconnect_LinkType = 236739749
)

// Enum value maps for Interconnect_LinkType.
var (
	Interconnect_LinkType_name = map[int32]string{
		0:         "UNDEFINED_LINK_TYPE",
		337672551: "LINK_TYPE_ETHERNET_100G_LR",
		236739749: "LINK_TYPE_ETHERNET_10G_LR",
	}
	Interconnect_LinkType_value = map[string]int32{
		"UNDEFINED_LINK_TYPE":        0,
		"LINK_TYPE_ETHERNET_100G_LR": 337672551,
		"LINK_TYPE_ETHERNET_10G_LR":  236739749,
	}
)

func (x Interconnect_LinkType) Enum() *Interconnect_LinkType {
	p := new(Interconnect_LinkType)
	*p = x
	return p
}

func (x Interconnect_LinkType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Interconnect_LinkType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[99].Descriptor()
}

func (Interconnect_LinkType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[99]
}

func (x Interconnect_LinkType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Interconnect_LinkType.Descriptor instead.
func (Interconnect_LinkType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{612, 1}
}

// [Output Only] The current status of this Interconnect's functionality, which can take one of the following values: - OS_ACTIVE: A valid Interconnect, which is turned up and is ready to use. Attachments may be provisioned on this Interconnect. - OS_UNPROVISIONED: An Interconnect that has not completed turnup. No attachments may be provisioned on this Interconnect. - OS_UNDER_MAINTENANCE: An Interconnect that is undergoing internal maintenance. No attachments may be provisioned or updated on this Interconnect.
type Interconnect_OperationalStatus int32

const (
	// A value indicating that the enum field is not set.
	Interconnect_UNDEFINED_OPERATIONAL_STATUS Interconnect_OperationalStatus = 0
	// The interconnect is valid, turned up, and ready to use. Attachments may be provisioned on this interconnect.
	Interconnect_OS_ACTIVE Interconnect_OperationalStatus = 55721409
	// The interconnect has not completed turnup. No attachments may be provisioned on this interconnect.
	Interconnect_OS_UNPROVISIONED Interconnect_OperationalStatus = 239771840
)

// Enum value maps for Interconnect_OperationalStatus.
var (
	Interconnect_OperationalStatus_name = map[int32]string{
		0:         "UNDEFINED_OPERATIONAL_STATUS",
		55721409:  "OS_ACTIVE",
		239771840: "OS_UNPROVISIONED",
	}
	Interconnect_OperationalStatus_value = map[string]int32{
		"UNDEFINED_OPERATIONAL_STATUS": 0,
		"OS_ACTIVE":                    55721409,
		"OS_UNPROVISIONED":             239771840,
	}
)

func (x Interconnect_OperationalStatus) Enum() *Interconnect_OperationalStatus {
	p := new(Interconnect_OperationalStatus)
	*p = x
	return p
}

func (x Interconnect_OperationalStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Interconnect_OperationalStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[100].Descriptor()
}

func (Interconnect_OperationalStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[100]
}

func (x Interconnect_OperationalStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Interconnect_OperationalStatus.Descriptor instead.
func (Interconnect_OperationalStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{612, 2}
}

// [Output Only] The current state of Interconnect functionality, which can take one of the following values: - ACTIVE: The Interconnect is valid, turned up and ready to use. Attachments may be provisioned on this Interconnect. - UNPROVISIONED: The Interconnect has not completed turnup. No attachments may be provisioned on this Interconnect. - UNDER_MAINTENANCE: The Interconnect is undergoing internal maintenance. No attachments may be provisioned or updated on this Interconnect.
type Interconnect_State int32

const (
	// A value indicating that the enum field is not set.
	Interconnect_UNDEFINED_STATE Interconnect_State = 0
	// The interconnect is valid, turned up, and ready to use. Attachments may be provisioned on this interconnect.
	Interconnect_ACTIVE Interconnect_State = 314733318
	// The interconnect has not completed turnup. No attachments may be provisioned on this interconnect.
	Interconnect_UNPROVISIONED Interconnect_State = 517333979
)

// Enum value maps for Interconnect_State.
var (
	Interconnect_State_name = map[int32]string{
		0:         "UNDEFINED_STATE",
		314733318: "ACTIVE",
		517333979: "UNPROVISIONED",
	}
	Interconnect_State_value = map[string]int32{
		"UNDEFINED_STATE": 0,
		"ACTIVE":          314733318,
		"UNPROVISIONED":   517333979,
	}
)

func (x Interconnect_State) Enum() *Interconnect_State {
	p := new(Interconnect_State)
	*p = x
	return p
}

func (x Interconnect_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Interconnect_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[101].Descriptor()
}

func (Interconnect_State) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[101]
}

func (x Interconnect_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Interconnect_State.Descriptor instead.
func (Interconnect_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{612, 3}
}

// Provisioned bandwidth capacity for the interconnect attachment. For attachments of type DEDICATED, the user can set the bandwidth. For attachments of type PARTNER, the Google Partner that is operating the interconnect must set the bandwidth. Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED, and can take one of the following values: - BPS_50M: 50 Mbit/s - BPS_100M: 100 Mbit/s - BPS_200M: 200 Mbit/s - BPS_300M: 300 Mbit/s - BPS_400M: 400 Mbit/s - BPS_500M: 500 Mbit/s - BPS_1G: 1 Gbit/s - BPS_2G: 2 Gbit/s - BPS_5G: 5 Gbit/s - BPS_10G: 10 Gbit/s - BPS_20G: 20 Gbit/s - BPS_50G: 50 Gbit/s
type InterconnectAttachment_Bandwidth int32

const (
	// A value indicating that the enum field is not set.
	InterconnectAttachment_UNDEFINED_BANDWIDTH InterconnectAttachment_Bandwidth = 0
	// 100 Mbit/s
	InterconnectAttachment_BPS_100M InterconnectAttachment_Bandwidth = 49547958
	// 10 Gbit/s
	InterconnectAttachment_BPS_10G InterconnectAttachment_Bandwidth = 278693006
	// 1 Gbit/s
	InterconnectAttachment_BPS_1G InterconnectAttachment_Bandwidth = 355358448
	// 200 Mbit/s
	InterconnectAttachment_BPS_200M InterconnectAttachment_Bandwidth = 49577749
	// 20 Gbit/s
	InterconnectAttachment_BPS_20G InterconnectAttachment_Bandwidth = 278693967
	// 2 Gbit/s
	InterconnectAttachment_BPS_2G InterconnectAttachment_Bandwidth = 355358479
	// 300 Mbit/s
	InterconnectAttachment_BPS_300M InterconnectAttachment_Bandwidth = 49607540
	// 400 Mbit/s
	InterconnectAttachment_BPS_400M InterconnectAttachment_Bandwidth = 49637331
	// 500 Mbit/s
	InterconnectAttachment_BPS_500M InterconnectAttachment_Bandwidth = 49667122
	// 50 Gbit/s
	InterconnectAttachment_BPS_50G InterconnectAttachment_Bandwidth = 278696850
	// 50 Mbit/s
	InterconnectAttachment_BPS_50M InterconnectAttachment_Bandwidth = 278696856
	// 5 Gbit/s
	InterconnectAttachment_BPS_5G InterconnectAttachment_Bandwidth = 355358572
)

// Enum value maps for InterconnectAttachment_Bandwidth.
var (
	InterconnectAttachment_Bandwidth_name = map[int32]string{
		0:         "UNDEFINED_BANDWIDTH",
		49547958:  "BPS_100M",
		278693006: "BPS_10G",
		355358448: "BPS_1G",
		49577749:  "BPS_200M",
		278693967: "BPS_20G",
		355358479: "BPS_2G",
		49607540:  "BPS_300M",
		49637331:  "BPS_400M",
		49667122:  "BPS_500M",
		278696850: "BPS_50G",
		278696856: "BPS_50M",
		355358572: "BPS_5G",
	}
	InterconnectAttachment_Bandwidth_value = map[string]int32{
		"UNDEFINED_BANDWIDTH": 0,
		"BPS_100M":            49547958,
		"BPS_10G":             278693006,
		"BPS_1G":              355358448,
		"BPS_200M":            49577749,
		"BPS_20G":             278693967,
		"BPS_2G":              355358479,
		"BPS_300M":            49607540,
		"BPS_400M":            49637331,
		"BPS_500M":            49667122,
		"BPS_50G":             278696850,
		"BPS_50M":             278696856,
		"BPS_5G":              355358572,
	}
)

func (x InterconnectAttachment_Bandwidth) Enum() *InterconnectAttachment_Bandwidth {
	p := new(InterconnectAttachment_Bandwidth)
	*p = x
	return p
}

func (x InterconnectAttachment_Bandwidth) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectAttachment_Bandwidth) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[102].Descriptor()
}

func (InterconnectAttachment_Bandwidth) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[102]
}

func (x InterconnectAttachment_Bandwidth) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectAttachment_Bandwidth.Descriptor instead.
func (InterconnectAttachment_Bandwidth) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{613, 0}
}

// Desired availability domain for the attachment. Only available for type PARTNER, at creation time, and can take one of the following values: - AVAILABILITY_DOMAIN_ANY - AVAILABILITY_DOMAIN_1 - AVAILABILITY_DOMAIN_2 For improved reliability, customers should configure a pair of attachments, one per availability domain. The selected availability domain will be provided to the Partner via the pairing key, so that the provisioned circuit will lie in the specified domain. If not specified, the value will default to AVAILABILITY_DOMAIN_ANY.
type InterconnectAttachment_EdgeAvailabilityDomain int32

const (
	// A value indicating that the enum field is not set.
	InterconnectAttachment_UNDEFINED_EDGE_AVAILABILITY_DOMAIN InterconnectAttachment_EdgeAvailabilityDomain = 0
	InterconnectAttachment_AVAILABILITY_DOMAIN_1              InterconnectAttachment_EdgeAvailabilityDomain = 349552090
	InterconnectAttachment_AVAILABILITY_DOMAIN_2              InterconnectAttachment_EdgeAvailabilityDomain = 349552091
	InterconnectAttachment_AVAILABILITY_DOMAIN_ANY            InterconnectAttachment_EdgeAvailabilityDomain = 375256373
)

// Enum value maps for InterconnectAttachment_EdgeAvailabilityDomain.
var (
	InterconnectAttachment_EdgeAvailabilityDomain_name = map[int32]string{
		0:         "UNDEFINED_EDGE_AVAILABILITY_DOMAIN",
		349552090: "AVAILABILITY_DOMAIN_1",
		349552091: "AVAILABILITY_DOMAIN_2",
		375256373: "AVAILABILITY_DOMAIN_ANY",
	}
	InterconnectAttachment_EdgeAvailabilityDomain_value = map[string]int32{
		"UNDEFINED_EDGE_AVAILABILITY_DOMAIN": 0,
		"AVAILABILITY_DOMAIN_1":              349552090,
		"AVAILABILITY_DOMAIN_2":              349552091,
		"AVAILABILITY_DOMAIN_ANY":            375256373,
	}
)

func (x InterconnectAttachment_EdgeAvailabilityDomain) Enum() *InterconnectAttachment_EdgeAvailabilityDomain {
	p := new(InterconnectAttachment_EdgeAvailabilityDomain)
	*p = x
	return p
}

func (x InterconnectAttachment_EdgeAvailabilityDomain) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectAttachment_EdgeAvailabilityDomain) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[103].Descriptor()
}

func (InterconnectAttachment_EdgeAvailabilityDomain) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[103]
}

func (x InterconnectAttachment_EdgeAvailabilityDomain) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectAttachment_EdgeAvailabilityDomain.Descriptor instead.
func (InterconnectAttachment_EdgeAvailabilityDomain) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{613, 1}
}

// Indicates the user-supplied encryption option of this VLAN attachment (interconnectAttachment). Can only be specified at attachment creation for PARTNER or DEDICATED attachments. Possible values are: - NONE - This is the default value, which means that the VLAN attachment carries unencrypted traffic. VMs are able to send traffic to, or receive traffic from, such a VLAN attachment. - IPSEC - The VLAN attachment carries only encrypted traffic that is encrypted by an IPsec device, such as an HA VPN gateway or third-party IPsec VPN. VMs cannot directly send traffic to, or receive traffic from, such a VLAN attachment. To use *HA VPN over Cloud Interconnect*, the VLAN attachment must be created with this option.
type InterconnectAttachment_Encryption int32

const (
	// A value indicating that the enum field is not set.
	InterconnectAttachment_UNDEFINED_ENCRYPTION InterconnectAttachment_Encryption = 0
	// The interconnect attachment will carry only encrypted traffic that is encrypted by an IPsec device such as HA VPN gateway; VMs cannot directly send traffic to or receive traffic from such an interconnect attachment. To use HA VPN over Cloud Interconnect, the interconnect attachment must be created with this option.
	InterconnectAttachment_IPSEC InterconnectAttachment_Encryption = 69882282
	// This is the default value, which means the Interconnect Attachment will carry unencrypted traffic. VMs will be able to send traffic to or receive traffic from such interconnect attachment.
	InterconnectAttachment_NONE InterconnectAttachment_Encryption = 2402104
)

// Enum value maps for InterconnectAttachment_Encryption.
var (
	InterconnectAttachment_Encryption_name = map[int32]string{
		0:        "UNDEFINED_ENCRYPTION",
		69882282: "IPSEC",
		2402104:  "NONE",
	}
	InterconnectAttachment_Encryption_value = map[string]int32{
		"UNDEFINED_ENCRYPTION": 0,
		"IPSEC":                69882282,
		"NONE":                 2402104,
	}
)

func (x InterconnectAttachment_Encryption) Enum() *InterconnectAttachment_Encryption {
	p := new(InterconnectAttachment_Encryption)
	*p = x
	return p
}

func (x InterconnectAttachment_Encryption) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectAttachment_Encryption) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[104].Descriptor()
}

func (InterconnectAttachment_Encryption) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[104]
}

func (x InterconnectAttachment_Encryption) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectAttachment_Encryption.Descriptor instead.
func (InterconnectAttachment_Encryption) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{613, 2}
}

// [Output Only] The current status of whether or not this interconnect attachment is functional, which can take one of the following values: - OS_ACTIVE: The attachment has been turned up and is ready to use. - OS_UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete.
type InterconnectAttachment_OperationalStatus int32

const (
	// A value indicating that the enum field is not set.
	InterconnectAttachment_UNDEFINED_OPERATIONAL_STATUS InterconnectAttachment_OperationalStatus = 0
	// Indicates that attachment has been turned up and is ready to use.
	InterconnectAttachment_OS_ACTIVE InterconnectAttachment_OperationalStatus = 55721409
	// Indicates that attachment is not ready to use yet, because turnup is not complete.
	InterconnectAttachment_OS_UNPROVISIONED InterconnectAttachment_OperationalStatus = 239771840
)

// Enum value maps for InterconnectAttachment_OperationalStatus.
var (
	InterconnectAttachment_OperationalStatus_name = map[int32]string{
		0:         "UNDEFINED_OPERATIONAL_STATUS",
		55721409:  "OS_ACTIVE",
		239771840: "OS_UNPROVISIONED",
	}
	InterconnectAttachment_OperationalStatus_value = map[string]int32{
		"UNDEFINED_OPERATIONAL_STATUS": 0,
		"OS_ACTIVE":                    55721409,
		"OS_UNPROVISIONED":             239771840,
	}
)

func (x InterconnectAttachment_OperationalStatus) Enum() *InterconnectAttachment_OperationalStatus {
	p := new(InterconnectAttachment_OperationalStatus)
	*p = x
	return p
}

func (x InterconnectAttachment_OperationalStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectAttachment_OperationalStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[105].Descriptor()
}

func (InterconnectAttachment_OperationalStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[105]
}

func (x InterconnectAttachment_OperationalStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectAttachment_OperationalStatus.Descriptor instead.
func (InterconnectAttachment_OperationalStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{613, 3}
}

// The stack type for this interconnect attachment to identify whether the IPv6 feature is enabled or not. If not specified, IPV4_ONLY will be used. This field can be both set at interconnect attachments creation and update interconnect attachment operations.
type InterconnectAttachment_StackType int32

const (
	// A value indicating that the enum field is not set.
	InterconnectAttachment_UNDEFINED_STACK_TYPE InterconnectAttachment_StackType = 0
	// The interconnect attachment can have both IPv4 and IPv6 addresses.
	InterconnectAttachment_IPV4_IPV6 InterconnectAttachment_StackType = 22197249
	// The interconnect attachment will only be assigned IPv4 addresses.
	InterconnectAttachment_IPV4_ONLY InterconnectAttachment_StackType = 22373798
)

// Enum value maps for InterconnectAttachment_StackType.
var (
	InterconnectAttachment_StackType_name = map[int32]string{
		0:        "UNDEFINED_STACK_TYPE",
		22197249: "IPV4_IPV6",
		22373798: "IPV4_ONLY",
	}
	InterconnectAttachment_StackType_value = map[string]int32{
		"UNDEFINED_STACK_TYPE": 0,
		"IPV4_IPV6":            22197249,
		"IPV4_ONLY":            22373798,
	}
)

func (x InterconnectAttachment_StackType) Enum() *InterconnectAttachment_StackType {
	p := new(InterconnectAttachment_StackType)
	*p = x
	return p
}

func (x InterconnectAttachment_StackType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectAttachment_StackType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[106].Descriptor()
}

func (InterconnectAttachment_StackType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[106]
}

func (x InterconnectAttachment_StackType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectAttachment_StackType.Descriptor instead.
func (InterconnectAttachment_StackType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{613, 4}
}

// [Output Only] The current state of this attachment's functionality. Enum values ACTIVE and UNPROVISIONED are shared by DEDICATED/PRIVATE, PARTNER, and PARTNER_PROVIDER interconnect attachments, while enum values PENDING_PARTNER, PARTNER_REQUEST_RECEIVED, and PENDING_CUSTOMER are used for only PARTNER and PARTNER_PROVIDER interconnect attachments. This state can take one of the following values: - ACTIVE: The attachment has been turned up and is ready to use. - UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete. - PENDING_PARTNER: A newly-created PARTNER attachment that has not yet been configured on the Partner side. - PARTNER_REQUEST_RECEIVED: A PARTNER attachment is in the process of provisioning after a PARTNER_PROVIDER attachment was created that references it. - PENDING_CUSTOMER: A PARTNER or PARTNER_PROVIDER attachment that is waiting for a customer to activate it. - DEFUNCT: The attachment was deleted externally and is no longer functional. This could be because the associated Interconnect was removed, or because the other side of a Partner attachment was deleted.
type InterconnectAttachment_State int32

const (
	// A value indicating that the enum field is not set.
	InterconnectAttachment_UNDEFINED_STATE InterconnectAttachment_State = 0
	// Indicates that attachment has been turned up and is ready to use.
	InterconnectAttachment_ACTIVE InterconnectAttachment_State = 314733318
	// The attachment was deleted externally and is no longer functional. This could be because the associated Interconnect was wiped out, or because the other side of a Partner attachment was deleted.
	InterconnectAttachment_DEFUNCT InterconnectAttachment_State = 115891759
	// A PARTNER attachment is in the process of provisioning after a PARTNER_PROVIDER attachment was created that references it.
	InterconnectAttachment_PARTNER_REQUEST_RECEIVED InterconnectAttachment_State = 513587304
	// PARTNER or PARTNER_PROVIDER attachment that is waiting for the customer to activate.
	InterconnectAttachment_PENDING_CUSTOMER InterconnectAttachment_State = 167494054
	// A newly created PARTNER attachment that has not yet been configured on the Partner side.
	InterconnectAttachment_PENDING_PARTNER   InterconnectAttachment_State = 387890656
	InterconnectAttachment_STATE_UNSPECIFIED InterconnectAttachment_State = 470755401
	// Indicates that attachment is not ready to use yet, because turnup is not complete.
	InterconnectAttachment_UNPROVISIONED InterconnectAttachment_State = 517333979
)

// Enum value maps for InterconnectAttachment_State.
var (
	InterconnectAttachment_State_name = map[int32]string{
		0:         "UNDEFINED_STATE",
		314733318: "ACTIVE",
		115891759: "DEFUNCT",
		513587304: "PARTNER_REQUEST_RECEIVED",
		167494054: "PENDING_CUSTOMER",
		387890656: "PENDING_PARTNER",
		470755401: "STATE_UNSPECIFIED",
		517333979: "UNPROVISIONED",
	}
	InterconnectAttachment_State_value = map[string]int32{
		"UNDEFINED_STATE":          0,
		"ACTIVE":                   314733318,
		"DEFUNCT":                  115891759,
		"PARTNER_REQUEST_RECEIVED": 513587304,
		"PENDING_CUSTOMER":         167494054,
		"PENDING_PARTNER":          387890656,
		"STATE_UNSPECIFIED":        470755401,
		"UNPROVISIONED":            517333979,
	}
)

func (x InterconnectAttachment_State) Enum() *InterconnectAttachment_State {
	p := new(InterconnectAttachment_State)
	*p = x
	return p
}

func (x InterconnectAttachment_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectAttachment_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[107].Descriptor()
}

func (InterconnectAttachment_State) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[107]
}

func (x InterconnectAttachment_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectAttachment_State.Descriptor instead.
func (InterconnectAttachment_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{613, 5}
}

// The type of interconnect attachment this is, which can take one of the following values: - DEDICATED: an attachment to a Dedicated Interconnect. - PARTNER: an attachment to a Partner Interconnect, created by the customer. - PARTNER_PROVIDER: an attachment to a Partner Interconnect, created by the partner.
type InterconnectAttachment_Type int32

const (
	// A value indicating that the enum field is not set.
	InterconnectAttachment_UNDEFINED_TYPE InterconnectAttachment_Type = 0
	// Attachment to a dedicated interconnect.
	InterconnectAttachment_DEDICATED InterconnectAttachment_Type = 258411983
	// Attachment to a partner interconnect, created by the customer.
	InterconnectAttachment_PARTNER InterconnectAttachment_Type = 461924520
	// Attachment to a partner interconnect, created by the partner.
	InterconnectAttachment_PARTNER_PROVIDER InterconnectAttachment_Type = 483261352
)

// Enum value maps for InterconnectAttachment_Type.
var (
	InterconnectAttachment_Type_name = map[int32]string{
		0:         "UNDEFINED_TYPE",
		258411983: "DEDICATED",
		461924520: "PARTNER",
		483261352: "PARTNER_PROVIDER",
	}
	InterconnectAttachment_Type_value = map[string]int32{
		"UNDEFINED_TYPE":   0,
		"DEDICATED":        258411983,
		"PARTNER":          461924520,
		"PARTNER_PROVIDER": 483261352,
	}
)

func (x InterconnectAttachment_Type) Enum() *InterconnectAttachment_Type {
	p := new(InterconnectAttachment_Type)
	*p = x
	return p
}

func (x InterconnectAttachment_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectAttachment_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[108].Descriptor()
}

func (InterconnectAttachment_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[108]
}

func (x InterconnectAttachment_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectAttachment_Type.Descriptor instead.
func (InterconnectAttachment_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{613, 6}
}

// The aggregation type of the bundle interface.
type InterconnectDiagnostics_BundleAggregationType int32

const (
	// A value indicating that the enum field is not set.
	InterconnectDiagnostics_UNDEFINED_BUNDLE_AGGREGATION_TYPE InterconnectDiagnostics_BundleAggregationType = 0
	// LACP is enabled.
	InterconnectDiagnostics_BUNDLE_AGGREGATION_TYPE_LACP InterconnectDiagnostics_BundleAggregationType = 27758925
	// LACP is disabled.
	InterconnectDiagnostics_BUNDLE_AGGREGATION_TYPE_STATIC InterconnectDiagnostics_BundleAggregationType = 50678873
)

// Enum value maps for InterconnectDiagnostics_BundleAggregationType.
var (
	InterconnectDiagnostics_BundleAggregationType_name = map[int32]string{
		0:        "UNDEFINED_BUNDLE_AGGREGATION_TYPE",
		27758925: "BUNDLE_AGGREGATION_TYPE_LACP",
		50678873: "BUNDLE_AGGREGATION_TYPE_STATIC",
	}
	InterconnectDiagnostics_BundleAggregationType_value = map[string]int32{
		"UNDEFINED_BUNDLE_AGGREGATION_TYPE": 0,
		"BUNDLE_AGGREGATION_TYPE_LACP":      27758925,
		"BUNDLE_AGGREGATION_TYPE_STATIC":    50678873,
	}
)

func (x InterconnectDiagnostics_BundleAggregationType) Enum() *InterconnectDiagnostics_BundleAggregationType {
	p := new(InterconnectDiagnostics_BundleAggregationType)
	*p = x
	return p
}

func (x InterconnectDiagnostics_BundleAggregationType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectDiagnostics_BundleAggregationType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[109].Descriptor()
}

func (InterconnectDiagnostics_BundleAggregationType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[109]
}

func (x InterconnectDiagnostics_BundleAggregationType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectDiagnostics_BundleAggregationType.Descriptor instead.
func (InterconnectDiagnostics_BundleAggregationType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{620, 0}
}

// The operational status of the bundle interface.
type InterconnectDiagnostics_BundleOperationalStatus int32

const (
	// A value indicating that the enum field is not set.
	InterconnectDiagnostics_UNDEFINED_BUNDLE_OPERATIONAL_STATUS InterconnectDiagnostics_BundleOperationalStatus = 0
	// If bundleAggregationType is LACP: LACP is not established and/or all links in the bundle have DOWN operational status. If bundleAggregationType is STATIC: one or more links in the bundle has DOWN operational status.
	InterconnectDiagnostics_BUNDLE_OPERATIONAL_STATUS_DOWN InterconnectDiagnostics_BundleOperationalStatus = 453842693
	// If bundleAggregationType is LACP: LACP is established and at least one link in the bundle has UP operational status. If bundleAggregationType is STATIC: all links in the bundle (typically just one) have UP operational status.
	InterconnectDiagnostics_BUNDLE_OPERATIONAL_STATUS_UP InterconnectDiagnostics_BundleOperationalStatus = 161366462
)

// Enum value maps for InterconnectDiagnostics_BundleOperationalStatus.
var (
	InterconnectDiagnostics_BundleOperationalStatus_name = map[int32]string{
		0:         "UNDEFINED_BUNDLE_OPERATIONAL_STATUS",
		453842693: "BUNDLE_OPERATIONAL_STATUS_DOWN",
		161366462: "BUNDLE_OPERATIONAL_STATUS_UP",
	}
	InterconnectDiagnostics_BundleOperationalStatus_value = map[string]int32{
		"UNDEFINED_BUNDLE_OPERATIONAL_STATUS": 0,
		"BUNDLE_OPERATIONAL_STATUS_DOWN":      453842693,
		"BUNDLE_OPERATIONAL_STATUS_UP":        161366462,
	}
)

func (x InterconnectDiagnostics_BundleOperationalStatus) Enum() *InterconnectDiagnostics_BundleOperationalStatus {
	p := new(InterconnectDiagnostics_BundleOperationalStatus)
	*p = x
	return p
}

func (x InterconnectDiagnostics_BundleOperationalStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectDiagnostics_BundleOperationalStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[110].Descriptor()
}

func (InterconnectDiagnostics_BundleOperationalStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[110]
}

func (x InterconnectDiagnostics_BundleOperationalStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectDiagnostics_BundleOperationalStatus.Descriptor instead.
func (InterconnectDiagnostics_BundleOperationalStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{620, 1}
}

// The state of a LACP link, which can take one of the following values: - ACTIVE: The link is configured and active within the bundle. - DETACHED: The link is not configured within the bundle. This means that the rest of the object should be empty.
type InterconnectDiagnosticsLinkLACPStatus_State int32

const (
	// A value indicating that the enum field is not set.
	InterconnectDiagnosticsLinkLACPStatus_UNDEFINED_STATE InterconnectDiagnosticsLinkLACPStatus_State = 0
	// The link is configured and active within the bundle.
	InterconnectDiagnosticsLinkLACPStatus_ACTIVE InterconnectDiagnosticsLinkLACPStatus_State = 314733318
	// The link is not configured within the bundle, this means the rest of the object should be empty.
	InterconnectDiagnosticsLinkLACPStatus_DETACHED InterconnectDiagnosticsLinkLACPStatus_State = 216562546
)

// Enum value maps for InterconnectDiagnosticsLinkLACPStatus_State.
var (
	InterconnectDiagnosticsLinkLACPStatus_State_name = map[int32]string{
		0:         "UNDEFINED_STATE",
		314733318: "ACTIVE",
		216562546: "DETACHED",
	}
	InterconnectDiagnosticsLinkLACPStatus_State_value = map[string]int32{
		"UNDEFINED_STATE": 0,
		"ACTIVE":          314733318,
		"DETACHED":        216562546,
	}
)

func (x InterconnectDiagnosticsLinkLACPStatus_State) Enum() *InterconnectDiagnosticsLinkLACPStatus_State {
	p := new(InterconnectDiagnosticsLinkLACPStatus_State)
	*p = x
	return p
}

func (x InterconnectDiagnosticsLinkLACPStatus_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectDiagnosticsLinkLACPStatus_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[111].Descriptor()
}

func (InterconnectDiagnosticsLinkLACPStatus_State) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[111]
}

func (x InterconnectDiagnosticsLinkLACPStatus_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectDiagnosticsLinkLACPStatus_State.Descriptor instead.
func (InterconnectDiagnosticsLinkLACPStatus_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{622, 0}
}

// The status of the current value when compared to the warning and alarm levels for the receiving or transmitting transceiver. Possible states include: - OK: The value has not crossed a warning threshold. - LOW_WARNING: The value has crossed below the low warning threshold. - HIGH_WARNING: The value has crossed above the high warning threshold. - LOW_ALARM: The value has crossed below the low alarm threshold. - HIGH_ALARM: The value has crossed above the high alarm threshold.
type InterconnectDiagnosticsLinkOpticalPower_State int32

const (
	// A value indicating that the enum field is not set.
	InterconnectDiagnosticsLinkOpticalPower_UNDEFINED_STATE InterconnectDiagnosticsLinkOpticalPower_State = 0
	// The value has crossed above the high alarm threshold.
	InterconnectDiagnosticsLinkOpticalPower_HIGH_ALARM InterconnectDiagnosticsLinkOpticalPower_State = 305363284
	// The value of the current optical power has crossed above the high warning threshold.
	InterconnectDiagnosticsLinkOpticalPower_HIGH_WARNING InterconnectDiagnosticsLinkOpticalPower_State = 220984799
	// The value of the current optical power has crossed below the low alarm threshold.
	InterconnectDiagnosticsLinkOpticalPower_LOW_ALARM InterconnectDiagnosticsLinkOpticalPower_State = 316659046
	// The value of the current optical power has crossed below the low warning threshold.
	InterconnectDiagnosticsLinkOpticalPower_LOW_WARNING InterconnectDiagnosticsLinkOpticalPower_State = 338793841
	// The value of the current optical power has not crossed a warning threshold.
	InterconnectDiagnosticsLinkOpticalPower_OK InterconnectDiagnosticsLinkOpticalPower_State = 2524
)

// Enum value maps for InterconnectDiagnosticsLinkOpticalPower_State.
var (
	InterconnectDiagnosticsLinkOpticalPower_State_name = map[int32]string{
		0:         "UNDEFINED_STATE",
		305363284: "HIGH_ALARM",
		220984799: "HIGH_WARNING",
		316659046: "LOW_ALARM",
		338793841: "LOW_WARNING",
		2524:      "OK",
	}
	InterconnectDiagnosticsLinkOpticalPower_State_value = map[string]int32{
		"UNDEFINED_STATE": 0,
		"HIGH_ALARM":      305363284,
		"HIGH_WARNING":    220984799,
		"LOW_ALARM":       316659046,
		"LOW_WARNING":     338793841,
		"OK":              2524,
	}
)

func (x InterconnectDiagnosticsLinkOpticalPower_State) Enum() *InterconnectDiagnosticsLinkOpticalPower_State {
	p := new(InterconnectDiagnosticsLinkOpticalPower_State)
	*p = x
	return p
}

func (x InterconnectDiagnosticsLinkOpticalPower_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectDiagnosticsLinkOpticalPower_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[112].Descriptor()
}

func (InterconnectDiagnosticsLinkOpticalPower_State) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[112]
}

func (x InterconnectDiagnosticsLinkOpticalPower_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectDiagnosticsLinkOpticalPower_State.Descriptor instead.
func (InterconnectDiagnosticsLinkOpticalPower_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{623, 0}
}

// The operational status of the link.
type InterconnectDiagnosticsLinkStatus_OperationalStatus int32

const (
	// A value indicating that the enum field is not set.
	InterconnectDiagnosticsLinkStatus_UNDEFINED_OPERATIONAL_STATUS InterconnectDiagnosticsLinkStatus_OperationalStatus = 0
	// The interface is unable to communicate with the remote end.
	InterconnectDiagnosticsLinkStatus_LINK_OPERATIONAL_STATUS_DOWN InterconnectDiagnosticsLinkStatus_OperationalStatus = 281653885
	// The interface has low level communication with the remote end.
	InterconnectDiagnosticsLinkStatus_LINK_OPERATIONAL_STATUS_UP InterconnectDiagnosticsLinkStatus_OperationalStatus = 305879862
)

// Enum value maps for InterconnectDiagnosticsLinkStatus_OperationalStatus.
var (
	InterconnectDiagnosticsLinkStatus_OperationalStatus_name = map[int32]string{
		0:         "UNDEFINED_OPERATIONAL_STATUS",
		281653885: "LINK_OPERATIONAL_STATUS_DOWN",
		305879862: "LINK_OPERATIONAL_STATUS_UP",
	}
	InterconnectDiagnosticsLinkStatus_OperationalStatus_value = map[string]int32{
		"UNDEFINED_OPERATIONAL_STATUS": 0,
		"LINK_OPERATIONAL_STATUS_DOWN": 281653885,
		"LINK_OPERATIONAL_STATUS_UP":   305879862,
	}
)

func (x InterconnectDiagnosticsLinkStatus_OperationalStatus) Enum() *InterconnectDiagnosticsLinkStatus_OperationalStatus {
	p := new(InterconnectDiagnosticsLinkStatus_OperationalStatus)
	*p = x
	return p
}

func (x InterconnectDiagnosticsLinkStatus_OperationalStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectDiagnosticsLinkStatus_OperationalStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[113].Descriptor()
}

func (InterconnectDiagnosticsLinkStatus_OperationalStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[113]
}

func (x InterconnectDiagnosticsLinkStatus_OperationalStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectDiagnosticsLinkStatus_OperationalStatus.Descriptor instead.
func (InterconnectDiagnosticsLinkStatus_OperationalStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{624, 0}
}

// [Output Only] Continent for this location, which can take one of the following values: - AFRICA - ASIA_PAC - EUROPE - NORTH_AMERICA - SOUTH_AMERICA
type InterconnectLocation_Continent int32

const (
	// A value indicating that the enum field is not set.
	InterconnectLocation_UNDEFINED_CONTINENT InterconnectLocation_Continent = 0
	InterconnectLocation_AFRICA              InterconnectLocation_Continent = 317443706
	InterconnectLocation_ASIA_PAC            InterconnectLocation_Continent = 119782269
	InterconnectLocation_C_AFRICA            InterconnectLocation_Continent = 71993846
	InterconnectLocation_C_ASIA_PAC          InterconnectLocation_Continent = 465668089
	InterconnectLocation_C_EUROPE            InterconnectLocation_Continent = 200369438
	InterconnectLocation_C_NORTH_AMERICA     InterconnectLocation_Continent = 275697048
	InterconnectLocation_C_SOUTH_AMERICA     InterconnectLocation_Continent = 397149792
	InterconnectLocation_EUROPE              InterconnectLocation_Continent = 445819298
	InterconnectLocation_NORTH_AMERICA       InterconnectLocation_Continent = 448015508
	InterconnectLocation_SOUTH_AMERICA       InterconnectLocation_Continent = 32597340
)

// Enum value maps for InterconnectLocation_Continent.
var (
	InterconnectLocation_Continent_name = map[int32]string{
		0:         "UNDEFINED_CONTINENT",
		317443706: "AFRICA",
		119782269: "ASIA_PAC",
		71993846:  "C_AFRICA",
		465668089: "C_ASIA_PAC",
		200369438: "C_EUROPE",
		275697048: "C_NORTH_AMERICA",
		397149792: "C_SOUTH_AMERICA",
		445819298: "EUROPE",
		448015508: "NORTH_AMERICA",
		32597340:  "SOUTH_AMERICA",
	}
	InterconnectLocation_Continent_value = map[string]int32{
		"UNDEFINED_CONTINENT": 0,
		"AFRICA":              317443706,
		"ASIA_PAC":            119782269,
		"C_AFRICA":            71993846,
		"C_ASIA_PAC":          465668089,
		"C_EUROPE":            200369438,
		"C_NORTH_AMERICA":     275697048,
		"C_SOUTH_AMERICA":     397149792,
		"EUROPE":              445819298,
		"NORTH_AMERICA":       448015508,
		"SOUTH_AMERICA":       32597340,
	}
)

func (x InterconnectLocation_Continent) Enum() *InterconnectLocation_Continent {
	p := new(InterconnectLocation_Continent)
	*p = x
	return p
}

func (x InterconnectLocation_Continent) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectLocation_Continent) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[114].Descriptor()
}

func (InterconnectLocation_Continent) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[114]
}

func (x InterconnectLocation_Continent) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectLocation_Continent.Descriptor instead.
func (InterconnectLocation_Continent) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{626, 0}
}

// [Output Only] The status of this InterconnectLocation, which can take one of the following values: - CLOSED: The InterconnectLocation is closed and is unavailable for provisioning new Interconnects. - AVAILABLE: The InterconnectLocation is available for provisioning new Interconnects.
type InterconnectLocation_Status int32

const (
	// A value indicating that the enum field is not set.
	InterconnectLocation_UNDEFINED_STATUS InterconnectLocation_Status = 0
	// The InterconnectLocation is available for provisioning new Interconnects.
	InterconnectLocation_AVAILABLE InterconnectLocation_Status = 442079913
	// The InterconnectLocation is closed for provisioning new Interconnects.
	InterconnectLocation_CLOSED InterconnectLocation_Status = 380163436
)

// Enum value maps for InterconnectLocation_Status.
var (
	InterconnectLocation_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		442079913: "AVAILABLE",
		380163436: "CLOSED",
	}
	InterconnectLocation_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"AVAILABLE":        442079913,
		"CLOSED":           380163436,
	}
)

func (x InterconnectLocation_Status) Enum() *InterconnectLocation_Status {
	p := new(InterconnectLocation_Status)
	*p = x
	return p
}

func (x InterconnectLocation_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectLocation_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[115].Descriptor()
}

func (InterconnectLocation_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[115]
}

func (x InterconnectLocation_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectLocation_Status.Descriptor instead.
func (InterconnectLocation_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{626, 1}
}

// Identifies the network presence of this location.
type InterconnectLocationRegionInfo_LocationPresence int32

const (
	// A value indicating that the enum field is not set.
	InterconnectLocationRegionInfo_UNDEFINED_LOCATION_PRESENCE InterconnectLocationRegionInfo_LocationPresence = 0
	// This region is not in any common network presence with this InterconnectLocation.
	InterconnectLocationRegionInfo_GLOBAL InterconnectLocationRegionInfo_LocationPresence = 494663587
	// This region shares the same regional network presence as this InterconnectLocation.
	InterconnectLocationRegionInfo_LOCAL_REGION InterconnectLocationRegionInfo_LocationPresence = 403535464
	// [Deprecated] This region is not in any common network presence with this InterconnectLocation.
	InterconnectLocationRegionInfo_LP_GLOBAL InterconnectLocationRegionInfo_LocationPresence = 429584062
	// [Deprecated] This region shares the same regional network presence as this InterconnectLocation.
	InterconnectLocationRegionInfo_LP_LOCAL_REGION InterconnectLocationRegionInfo_LocationPresence = 488598851
)

// Enum value maps for InterconnectLocationRegionInfo_LocationPresence.
var (
	InterconnectLocationRegionInfo_LocationPresence_name = map[int32]string{
		0:         "UNDEFINED_LOCATION_PRESENCE",
		494663587: "GLOBAL",
		403535464: "LOCAL_REGION",
		429584062: "LP_GLOBAL",
		488598851: "LP_LOCAL_REGION",
	}
	InterconnectLocationRegionInfo_LocationPresence_value = map[string]int32{
		"UNDEFINED_LOCATION_PRESENCE": 0,
		"GLOBAL":                      494663587,
		"LOCAL_REGION":                403535464,
		"LP_GLOBAL":                   429584062,
		"LP_LOCAL_REGION":             488598851,
	}
)

func (x InterconnectLocationRegionInfo_LocationPresence) Enum() *InterconnectLocationRegionInfo_LocationPresence {
	p := new(InterconnectLocationRegionInfo_LocationPresence)
	*p = x
	return p
}

func (x InterconnectLocationRegionInfo_LocationPresence) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectLocationRegionInfo_LocationPresence) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[116].Descriptor()
}

func (InterconnectLocationRegionInfo_LocationPresence) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[116]
}

func (x InterconnectLocationRegionInfo_LocationPresence) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectLocationRegionInfo_LocationPresence.Descriptor instead.
func (InterconnectLocationRegionInfo_LocationPresence) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{628, 0}
}

// Form this outage is expected to take, which can take one of the following values: - OUTAGE: The Interconnect may be completely out of service for some or all of the specified window. - PARTIAL_OUTAGE: Some circuits comprising the Interconnect as a whole should remain up, but with reduced bandwidth. Note that the versions of this enum prefixed with "IT_" have been deprecated in favor of the unprefixed values.
type InterconnectOutageNotification_IssueType int32

const (
	// A value indicating that the enum field is not set.
	InterconnectOutageNotification_UNDEFINED_ISSUE_TYPE InterconnectOutageNotification_IssueType = 0
	// [Deprecated] The Interconnect may be completely out of service for some or all of the specified window.
	InterconnectOutageNotification_IT_OUTAGE InterconnectOutageNotification_IssueType = 175779973
	// [Deprecated] Some circuits comprising the Interconnect will be out of service during the expected window. The interconnect as a whole should remain up, albeit with reduced bandwidth.
	InterconnectOutageNotification_IT_PARTIAL_OUTAGE InterconnectOutageNotification_IssueType = 92103971
	// The Interconnect may be completely out of service for some or all of the specified window.
	InterconnectOutageNotification_OUTAGE InterconnectOutageNotification_IssueType = 195285745
	// Some circuits comprising the Interconnect will be out of service during the expected window. The interconnect as a whole should remain up, albeit with reduced bandwidth.
	InterconnectOutageNotification_PARTIAL_OUTAGE InterconnectOutageNotification_IssueType = 147053455
)

// Enum value maps for InterconnectOutageNotification_IssueType.
var (
	InterconnectOutageNotification_IssueType_name = map[int32]string{
		0:         "UNDEFINED_ISSUE_TYPE",
		175779973: "IT_OUTAGE",
		92103971:  "IT_PARTIAL_OUTAGE",
		195285745: "OUTAGE",
		147053455: "PARTIAL_OUTAGE",
	}
	InterconnectOutageNotification_IssueType_value = map[string]int32{
		"UNDEFINED_ISSUE_TYPE": 0,
		"IT_OUTAGE":            175779973,
		"IT_PARTIAL_OUTAGE":    92103971,
		"OUTAGE":               195285745,
		"PARTIAL_OUTAGE":       147053455,
	}
)

func (x InterconnectOutageNotification_IssueType) Enum() *InterconnectOutageNotification_IssueType {
	p := new(InterconnectOutageNotification_IssueType)
	*p = x
	return p
}

func (x InterconnectOutageNotification_IssueType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectOutageNotification_IssueType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[117].Descriptor()
}

func (InterconnectOutageNotification_IssueType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[117]
}

func (x InterconnectOutageNotification_IssueType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectOutageNotification_IssueType.Descriptor instead.
func (InterconnectOutageNotification_IssueType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{629, 0}
}

// The party that generated this notification, which can take the following value: - GOOGLE: this notification as generated by Google. Note that the value of NSRC_GOOGLE has been deprecated in favor of GOOGLE.
type InterconnectOutageNotification_Source int32

const (
	// A value indicating that the enum field is not set.
	InterconnectOutageNotification_UNDEFINED_SOURCE InterconnectOutageNotification_Source = 0
	// This notification was generated by Google.
	InterconnectOutageNotification_GOOGLE InterconnectOutageNotification_Source = 497439289
	// [Deprecated] This notification was generated by Google.
	InterconnectOutageNotification_NSRC_GOOGLE InterconnectOutageNotification_Source = 510574562
)

// Enum value maps for InterconnectOutageNotification_Source.
var (
	InterconnectOutageNotification_Source_name = map[int32]string{
		0:         "UNDEFINED_SOURCE",
		497439289: "GOOGLE",
		510574562: "NSRC_GOOGLE",
	}
	InterconnectOutageNotification_Source_value = map[string]int32{
		"UNDEFINED_SOURCE": 0,
		"GOOGLE":           497439289,
		"NSRC_GOOGLE":      510574562,
	}
)

func (x InterconnectOutageNotification_Source) Enum() *InterconnectOutageNotification_Source {
	p := new(InterconnectOutageNotification_Source)
	*p = x
	return p
}

func (x InterconnectOutageNotification_Source) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectOutageNotification_Source) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[118].Descriptor()
}

func (InterconnectOutageNotification_Source) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[118]
}

func (x InterconnectOutageNotification_Source) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectOutageNotification_Source.Descriptor instead.
func (InterconnectOutageNotification_Source) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{629, 1}
}

// State of this notification, which can take one of the following values: - ACTIVE: This outage notification is active. The event could be in the past, present, or future. See start_time and end_time for scheduling. - CANCELLED: The outage associated with this notification was cancelled before the outage was due to start. - COMPLETED: The outage associated with this notification is complete. Note that the versions of this enum prefixed with "NS_" have been deprecated in favor of the unprefixed values.
type InterconnectOutageNotification_State int32

const (
	// A value indicating that the enum field is not set.
	InterconnectOutageNotification_UNDEFINED_STATE InterconnectOutageNotification_State = 0
	// This outage notification is active. The event could be in the future, present, or past. See start_time and end_time for scheduling.
	InterconnectOutageNotification_ACTIVE InterconnectOutageNotification_State = 314733318
	// The outage associated with this notification was cancelled before the outage was due to start.
	InterconnectOutageNotification_CANCELLED InterconnectOutageNotification_State = 41957681
	// The outage associated with this notification is complete.
	InterconnectOutageNotification_COMPLETED InterconnectOutageNotification_State = 309921323
	// [Deprecated] This outage notification is active. The event could be in the future, present, or past. See start_time and end_time for scheduling.
	InterconnectOutageNotification_NS_ACTIVE InterconnectOutageNotification_State = 252563136
	// [Deprecated] The outage associated with this notification was canceled before the outage was due to start.
	InterconnectOutageNotification_NS_CANCELED InterconnectOutageNotification_State = 506579411
)

// Enum value maps for InterconnectOutageNotification_State.
var (
	InterconnectOutageNotification_State_name = map[int32]string{
		0:         "UNDEFINED_STATE",
		314733318: "ACTIVE",
		41957681:  "CANCELLED",
		309921323: "COMPLETED",
		252563136: "NS_ACTIVE",
		506579411: "NS_CANCELED",
	}
	InterconnectOutageNotification_State_value = map[string]int32{
		"UNDEFINED_STATE": 0,
		"ACTIVE":          314733318,
		"CANCELLED":       41957681,
		"COMPLETED":       309921323,
		"NS_ACTIVE":       252563136,
		"NS_CANCELED":     506579411,
	}
)

func (x InterconnectOutageNotification_State) Enum() *InterconnectOutageNotification_State {
	p := new(InterconnectOutageNotification_State)
	*p = x
	return p
}

func (x InterconnectOutageNotification_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectOutageNotification_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[119].Descriptor()
}

func (InterconnectOutageNotification_State) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[119]
}

func (x InterconnectOutageNotification_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectOutageNotification_State.Descriptor instead.
func (InterconnectOutageNotification_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{629, 2}
}

// [Output Only] Current state of this License Code.
type LicenseCode_State int32

const (
	// A value indicating that the enum field is not set.
	LicenseCode_UNDEFINED_STATE LicenseCode_State = 0
	// Machines are not allowed to attach boot disks with this License Code. Requests to create new resources with this license will be rejected.
	LicenseCode_DISABLED LicenseCode_State = 516696700
	// Use is allowed for anyone with USE_READ_ONLY access to this License Code.
	LicenseCode_ENABLED LicenseCode_State = 182130465
	// Use of this license is limited to a project whitelist.
	LicenseCode_RESTRICTED        LicenseCode_State = 261551195
	LicenseCode_STATE_UNSPECIFIED LicenseCode_State = 470755401
	// Reserved state.
	LicenseCode_TERMINATED LicenseCode_State = 250018339
)

// Enum value maps for LicenseCode_State.
var (
	LicenseCode_State_name = map[int32]string{
		0:         "UNDEFINED_STATE",
		516696700: "DISABLED",
		182130465: "ENABLED",
		261551195: "RESTRICTED",
		470755401: "STATE_UNSPECIFIED",
		250018339: "TERMINATED",
	}
	LicenseCode_State_value = map[string]int32{
		"UNDEFINED_STATE":   0,
		"DISABLED":          516696700,
		"ENABLED":           182130465,
		"RESTRICTED":        261551195,
		"STATE_UNSPECIFIED": 470755401,
		"TERMINATED":        250018339,
	}
)

func (x LicenseCode_State) Enum() *LicenseCode_State {
	p := new(LicenseCode_State)
	*p = x
	return p
}

func (x LicenseCode_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LicenseCode_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[120].Descriptor()
}

func (LicenseCode_State) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[120]
}

func (x LicenseCode_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LicenseCode_State.Descriptor instead.
func (LicenseCode_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{634, 0}
}

// The direction of the exchanged routes.
type ListPeeringRoutesNetworksRequest_Direction int32

const (
	// A value indicating that the enum field is not set.
	ListPeeringRoutesNetworksRequest_UNDEFINED_DIRECTION ListPeeringRoutesNetworksRequest_Direction = 0
	// For routes exported from peer network.
	ListPeeringRoutesNetworksRequest_INCOMING ListPeeringRoutesNetworksRequest_Direction = 338552870
	// For routes exported from local network.
	ListPeeringRoutesNetworksRequest_OUTGOING ListPeeringRoutesNetworksRequest_Direction = 307438444
)

// Enum value maps for ListPeeringRoutesNetworksRequest_Direction.
var (
	ListPeeringRoutesNetworksRequest_Direction_name = map[int32]string{
		0:         "UNDEFINED_DIRECTION",
		338552870: "INCOMING",
		307438444: "OUTGOING",
	}
	ListPeeringRoutesNetworksRequest_Direction_value = map[string]int32{
		"UNDEFINED_DIRECTION": 0,
		"INCOMING":            338552870,
		"OUTGOING":            307438444,
	}
)

func (x ListPeeringRoutesNetworksRequest_Direction) Enum() *ListPeeringRoutesNetworksRequest_Direction {
	p := new(ListPeeringRoutesNetworksRequest_Direction)
	*p = x
	return p
}

func (x ListPeeringRoutesNetworksRequest_Direction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ListPeeringRoutesNetworksRequest_Direction) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[121].Descriptor()
}

func (ListPeeringRoutesNetworksRequest_Direction) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[121]
}

func (x ListPeeringRoutesNetworksRequest_Direction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ListPeeringRoutesNetworksRequest_Direction.Descriptor instead.
func (ListPeeringRoutesNetworksRequest_Direction) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{688, 0}
}

// Strategy for distributing VMs across zones in a region.
type LocationPolicy_TargetShape int32

const (
	// A value indicating that the enum field is not set.
	LocationPolicy_UNDEFINED_TARGET_SHAPE LocationPolicy_TargetShape = 0
	// GCE picks zones for creating VM instances to fulfill the requested number of VMs within present resource constraints and to maximize utilization of unused zonal reservations. Recommended for batch workloads that do not require high availability.
	LocationPolicy_ANY LocationPolicy_TargetShape = 64972
	// GCE always selects a single zone for all the VMs, optimizing for resource quotas, available reservations and general capacity. Recommended for batch workloads that cannot tollerate distribution over multiple zones. This the default shape in Bulk Insert and Capacity Advisor APIs.
	LocationPolicy_ANY_SINGLE_ZONE LocationPolicy_TargetShape = 61100880
	// GCE prioritizes acquisition of resources, scheduling VMs in zones where resources are available while distributing VMs as evenly as possible across allowed zones to minimize the impact of zonal failure. Recommended for highly available serving workloads.
	LocationPolicy_BALANCED LocationPolicy_TargetShape = 468409608
)

// Enum value maps for LocationPolicy_TargetShape.
var (
	LocationPolicy_TargetShape_name = map[int32]string{
		0:         "UNDEFINED_TARGET_SHAPE",
		64972:     "ANY",
		61100880:  "ANY_SINGLE_ZONE",
		468409608: "BALANCED",
	}
	LocationPolicy_TargetShape_value = map[string]int32{
		"UNDEFINED_TARGET_SHAPE": 0,
		"ANY":                    64972,
		"ANY_SINGLE_ZONE":        61100880,
		"BALANCED":               468409608,
	}
)

func (x LocationPolicy_TargetShape) Enum() *LocationPolicy_TargetShape {
	p := new(LocationPolicy_TargetShape)
	*p = x
	return p
}

func (x LocationPolicy_TargetShape) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LocationPolicy_TargetShape) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[122].Descriptor()
}

func (LocationPolicy_TargetShape) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[122]
}

func (x LocationPolicy_TargetShape) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LocationPolicy_TargetShape.Descriptor instead.
func (LocationPolicy_TargetShape) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{744, 0}
}

// Preference for a given location. Set to either ALLOW or DENY.
type LocationPolicyLocation_Preference int32

const (
	// A value indicating that the enum field is not set.
	LocationPolicyLocation_UNDEFINED_PREFERENCE LocationPolicyLocation_Preference = 0
	// Location is allowed for use.
	LocationPolicyLocation_ALLOW LocationPolicyLocation_Preference = 62368553
	// Location is prohibited.
	LocationPolicyLocation_DENY LocationPolicyLocation_Preference = 2094604
	// Default value, unused.
	LocationPolicyLocation_PREFERENCE_UNSPECIFIED LocationPolicyLocation_Preference = 496219571
)

// Enum value maps for LocationPolicyLocation_Preference.
var (
	LocationPolicyLocation_Preference_name = map[int32]string{
		0:         "UNDEFINED_PREFERENCE",
		62368553:  "ALLOW",
		2094604:   "DENY",
		496219571: "PREFERENCE_UNSPECIFIED",
	}
	LocationPolicyLocation_Preference_value = map[string]int32{
		"UNDEFINED_PREFERENCE":   0,
		"ALLOW":                  62368553,
		"DENY":                   2094604,
		"PREFERENCE_UNSPECIFIED": 496219571,
	}
)

func (x LocationPolicyLocation_Preference) Enum() *LocationPolicyLocation_Preference {
	p := new(LocationPolicyLocation_Preference)
	*p = x
	return p
}

func (x LocationPolicyLocation_Preference) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LocationPolicyLocation_Preference) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[123].Descriptor()
}

func (LocationPolicyLocation_Preference) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[123]
}

func (x LocationPolicyLocation_Preference) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LocationPolicyLocation_Preference.Descriptor instead.
func (LocationPolicyLocation_Preference) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{745, 0}
}

// This is deprecated and has no effect. Do not use.
type LogConfigCloudAuditOptions_LogName int32

const (
	// A value indicating that the enum field is not set.
	LogConfigCloudAuditOptions_UNDEFINED_LOG_NAME LogConfigCloudAuditOptions_LogName = 0
	// This is deprecated and has no effect. Do not use.
	LogConfigCloudAuditOptions_ADMIN_ACTIVITY LogConfigCloudAuditOptions_LogName = 427503135
	// This is deprecated and has no effect. Do not use.
	LogConfigCloudAuditOptions_DATA_ACCESS LogConfigCloudAuditOptions_LogName = 238070681
	// This is deprecated and has no effect. Do not use.
	LogConfigCloudAuditOptions_UNSPECIFIED_LOG_NAME LogConfigCloudAuditOptions_LogName = 410515182
)

// Enum value maps for LogConfigCloudAuditOptions_LogName.
var (
	LogConfigCloudAuditOptions_LogName_name = map[int32]string{
		0:         "UNDEFINED_LOG_NAME",
		427503135: "ADMIN_ACTIVITY",
		238070681: "DATA_ACCESS",
		410515182: "UNSPECIFIED_LOG_NAME",
	}
	LogConfigCloudAuditOptions_LogName_value = map[string]int32{
		"UNDEFINED_LOG_NAME":   0,
		"ADMIN_ACTIVITY":       427503135,
		"DATA_ACCESS":          238070681,
		"UNSPECIFIED_LOG_NAME": 410515182,
	}
)

func (x LogConfigCloudAuditOptions_LogName) Enum() *LogConfigCloudAuditOptions_LogName {
	p := new(LogConfigCloudAuditOptions_LogName)
	*p = x
	return p
}

func (x LogConfigCloudAuditOptions_LogName) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LogConfigCloudAuditOptions_LogName) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[124].Descriptor()
}

func (LogConfigCloudAuditOptions_LogName) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[124]
}

func (x LogConfigCloudAuditOptions_LogName) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LogConfigCloudAuditOptions_LogName.Descriptor instead.
func (LogConfigCloudAuditOptions_LogName) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{748, 0}
}

// This is deprecated and has no effect. Do not use.
type LogConfigDataAccessOptions_LogMode int32

const (
	// A value indicating that the enum field is not set.
	LogConfigDataAccessOptions_UNDEFINED_LOG_MODE LogConfigDataAccessOptions_LogMode = 0
	// This is deprecated and has no effect. Do not use.
	LogConfigDataAccessOptions_LOG_FAIL_CLOSED LogConfigDataAccessOptions_LogMode = 360469778
	// This is deprecated and has no effect. Do not use.
	LogConfigDataAccessOptions_LOG_MODE_UNSPECIFIED LogConfigDataAccessOptions_LogMode = 88160822
)

// Enum value maps for LogConfigDataAccessOptions_LogMode.
var (
	LogConfigDataAccessOptions_LogMode_name = map[int32]string{
		0:         "UNDEFINED_LOG_MODE",
		360469778: "LOG_FAIL_CLOSED",
		88160822:  "LOG_MODE_UNSPECIFIED",
	}
	LogConfigDataAccessOptions_LogMode_value = map[string]int32{
		"UNDEFINED_LOG_MODE":   0,
		"LOG_FAIL_CLOSED":      360469778,
		"LOG_MODE_UNSPECIFIED": 88160822,
	}
)

func (x LogConfigDataAccessOptions_LogMode) Enum() *LogConfigDataAccessOptions_LogMode {
	p := new(LogConfigDataAccessOptions_LogMode)
	*p = x
	return p
}

func (x LogConfigDataAccessOptions_LogMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LogConfigDataAccessOptions_LogMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[125].Descriptor()
}

func (LogConfigDataAccessOptions_LogMode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[125]
}

func (x LogConfigDataAccessOptions_LogMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LogConfigDataAccessOptions_LogMode.Descriptor instead.
func (LogConfigDataAccessOptions_LogMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{751, 0}
}

// [Output Only] The status of the machine image. One of the following values: INVALID, CREATING, READY, DELETING, and UPLOADING.
type MachineImage_Status int32

const (
	// A value indicating that the enum field is not set.
	MachineImage_UNDEFINED_STATUS MachineImage_Status = 0
	MachineImage_CREATING         MachineImage_Status = 455564985
	MachineImage_DELETING         MachineImage_Status = 528602024
	MachineImage_INVALID          MachineImage_Status = 530283991
	MachineImage_READY            MachineImage_Status = 77848963
	MachineImage_UPLOADING        MachineImage_Status = 267603489
)

// Enum value maps for MachineImage_Status.
var (
	MachineImage_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		455564985: "CREATING",
		528602024: "DELETING",
		530283991: "INVALID",
		77848963:  "READY",
		267603489: "UPLOADING",
	}
	MachineImage_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"CREATING":         455564985,
		"DELETING":         528602024,
		"INVALID":          530283991,
		"READY":            77848963,
		"UPLOADING":        267603489,
	}
)

func (x MachineImage_Status) Enum() *MachineImage_Status {
	p := new(MachineImage_Status)
	*p = x
	return p
}

func (x MachineImage_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MachineImage_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[126].Descriptor()
}

func (MachineImage_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[126]
}

func (x MachineImage_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MachineImage_Status.Descriptor instead.
func (MachineImage_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{752, 0}
}

// [Output Only] The current action that the managed instance group has scheduled for the instance. Possible values: - NONE The instance is running, and the managed instance group does not have any scheduled actions for this instance. - CREATING The managed instance group is creating this instance. If the group fails to create this instance, it will try again until it is successful. - CREATING_WITHOUT_RETRIES The managed instance group is attempting to create this instance only once. If the group fails to create this instance, it does not try again and the group's targetSize value is decreased instead. - RECREATING The managed instance group is recreating this instance. - DELETING The managed instance group is permanently deleting this instance. - ABANDONING The managed instance group is abandoning this instance. The instance will be removed from the instance group and from any target pools that are associated with this group. - RESTARTING The managed instance group is restarting the instance. - REFRESHING The managed instance group is applying configuration changes to the instance without stopping it. For example, the group can update the target pool list for an instance without stopping that instance. - VERIFYING The managed instance group has created the instance and it is in the process of being verified.
// Additional supported values which may be not listed in the enum directly due to technical reasons:
// STOPPING
// SUSPENDING
type ManagedInstance_CurrentAction int32

const (
	// A value indicating that the enum field is not set.
	ManagedInstance_UNDEFINED_CURRENT_ACTION ManagedInstance_CurrentAction = 0
	// The managed instance group is abandoning this instance. The instance will be removed from the instance group and from any target pools that are associated with this group.
	ManagedInstance_ABANDONING ManagedInstance_CurrentAction = 388244813
	// The managed instance group is creating this instance. If the group fails to create this instance, it will try again until it is successful.
	ManagedInstance_CREATING ManagedInstance_CurrentAction = 455564985
	// The managed instance group is attempting to create this instance only once. If the group fails to create this instance, it does not try again and the group's targetSize value is decreased.
	ManagedInstance_CREATING_WITHOUT_RETRIES ManagedInstance_CurrentAction = 428843785
	// The managed instance group is permanently deleting this instance.
	ManagedInstance_DELETING ManagedInstance_CurrentAction = 528602024
	// The managed instance group has not scheduled any actions for this instance.
	ManagedInstance_NONE ManagedInstance_CurrentAction = 2402104
	// The managed instance group is recreating this instance.
	ManagedInstance_RECREATING ManagedInstance_CurrentAction = 287278572
	// The managed instance group is applying configuration changes to the instance without stopping it. For example, the group can update the target pool list for an instance without stopping that instance.
	ManagedInstance_REFRESHING ManagedInstance_CurrentAction = 163266343
	// The managed instance group is restarting this instance.
	ManagedInstance_RESTARTING ManagedInstance_CurrentAction = 320534387
	// The managed instance group is resuming this instance.
	ManagedInstance_RESUMING ManagedInstance_CurrentAction = 446856618
	// The managed instance group is starting this instance.
	ManagedInstance_STARTING ManagedInstance_CurrentAction = 488820800
	// The managed instance group is verifying this already created instance. Verification happens every time the instance is (re)created or restarted and consists of: 1. Waiting until health check specified as part of this managed instance group's autohealing policy reports HEALTHY. Note: Applies only if autohealing policy has a health check specified 2. Waiting for addition verification steps performed as post-instance creation (subject to future extensions).
	ManagedInstance_VERIFYING ManagedInstance_CurrentAction = 16982185
)

// Enum value maps for ManagedInstance_CurrentAction.
var (
	ManagedInstance_CurrentAction_name = map[int32]string{
		0:         "UNDEFINED_CURRENT_ACTION",
		388244813: "ABANDONING",
		455564985: "CREATING",
		428843785: "CREATING_WITHOUT_RETRIES",
		528602024: "DELETING",
		2402104:   "NONE",
		287278572: "RECREATING",
		163266343: "REFRESHING",
		320534387: "RESTARTING",
		446856618: "RESUMING",
		488820800: "STARTING",
		16982185:  "VERIFYING",
	}
	ManagedInstance_CurrentAction_value = map[string]int32{
		"UNDEFINED_CURRENT_ACTION": 0,
		"ABANDONING":               388244813,
		"CREATING":                 455564985,
		"CREATING_WITHOUT_RETRIES": 428843785,
		"DELETING":                 528602024,
		"NONE":                     2402104,
		"RECREATING":               287278572,
		"REFRESHING":               163266343,
		"RESTARTING":               320534387,
		"RESUMING":                 446856618,
		"STARTING":                 488820800,
		"VERIFYING":                16982185,
	}
)

func (x ManagedInstance_CurrentAction) Enum() *ManagedInstance_CurrentAction {
	p := new(ManagedInstance_CurrentAction)
	*p = x
	return p
}

func (x ManagedInstance_CurrentAction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ManagedInstance_CurrentAction) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[127].Descriptor()
}

func (ManagedInstance_CurrentAction) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[127]
}

func (x ManagedInstance_CurrentAction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ManagedInstance_CurrentAction.Descriptor instead.
func (ManagedInstance_CurrentAction) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{758, 0}
}

// [Output Only] The status of the instance. This field is empty when the instance does not exist.
// Additional supported values which may be not listed in the enum directly due to technical reasons:
// STOPPING
// SUSPENDING
type ManagedInstance_InstanceStatus int32

const (
	// A value indicating that the enum field is not set.
	ManagedInstance_UNDEFINED_INSTANCE_STATUS ManagedInstance_InstanceStatus = 0
	// The Nanny is halted and we are performing tear down tasks like network deprogramming, releasing quota, IP, tearing down disks etc.
	ManagedInstance_DEPROVISIONING ManagedInstance_InstanceStatus = 428935662
	// Resources are being allocated for the instance.
	ManagedInstance_PROVISIONING ManagedInstance_InstanceStatus = 290896621
	// The instance is in repair.
	ManagedInstance_REPAIRING ManagedInstance_InstanceStatus = 413483285
	// The instance is running.
	ManagedInstance_RUNNING ManagedInstance_InstanceStatus = 121282975
	// All required resources have been allocated and the instance is being started.
	ManagedInstance_STAGING ManagedInstance_InstanceStatus = 431072283
	// The instance has stopped successfully.
	ManagedInstance_STOPPED  ManagedInstance_InstanceStatus = 444276141
	ManagedInstance_STOPPING ManagedInstance_InstanceStatus = 350791796
	// The instance has suspended.
	ManagedInstance_SUSPENDED  ManagedInstance_InstanceStatus = 51223995
	ManagedInstance_SUSPENDING ManagedInstance_InstanceStatus = 514206246
	// The instance has stopped (either by explicit action or underlying failure).
	ManagedInstance_TERMINATED ManagedInstance_InstanceStatus = 250018339
)

// Enum value maps for ManagedInstance_InstanceStatus.
var (
	ManagedInstance_InstanceStatus_name = map[int32]string{
		0:         "UNDEFINED_INSTANCE_STATUS",
		428935662: "DEPROVISIONING",
		290896621: "PROVISIONING",
		413483285: "REPAIRING",
		121282975: "RUNNING",
		431072283: "STAGING",
		444276141: "STOPPED",
		350791796: "STOPPING",
		51223995:  "SUSPENDED",
		514206246: "SUSPENDING",
		250018339: "TERMINATED",
	}
	ManagedInstance_InstanceStatus_value = map[string]int32{
		"UNDEFINED_INSTANCE_STATUS": 0,
		"DEPROVISIONING":            428935662,
		"PROVISIONING":              290896621,
		"REPAIRING":                 413483285,
		"RUNNING":                   121282975,
		"STAGING":                   431072283,
		"STOPPED":                   444276141,
		"STOPPING":                  350791796,
		"SUSPENDED":                 51223995,
		"SUSPENDING":                514206246,
		"TERMINATED":                250018339,
	}
)

func (x ManagedInstance_InstanceStatus) Enum() *ManagedInstance_InstanceStatus {
	p := new(ManagedInstance_InstanceStatus)
	*p = x
	return p
}

func (x ManagedInstance_InstanceStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ManagedInstance_InstanceStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[128].Descriptor()
}

func (ManagedInstance_InstanceStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[128]
}

func (x ManagedInstance_InstanceStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ManagedInstance_InstanceStatus.Descriptor instead.
func (ManagedInstance_InstanceStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{758, 1}
}

// [Output Only] The current detailed instance health state.
type ManagedInstanceInstanceHealth_DetailedHealthState int32

const (
	// A value indicating that the enum field is not set.
	ManagedInstanceInstanceHealth_UNDEFINED_DETAILED_HEALTH_STATE ManagedInstanceInstanceHealth_DetailedHealthState = 0
	// The instance is being drained. The existing connections to the instance have time to complete, but the new ones are being refused.
	ManagedInstanceInstanceHealth_DRAINING ManagedInstanceInstanceHealth_DetailedHealthState = 480455402
	// The instance is reachable i.e. a connection to the application health checking endpoint can be established, and conforms to the requirements defined by the health check.
	ManagedInstanceInstanceHealth_HEALTHY ManagedInstanceInstanceHealth_DetailedHealthState = 439801213
	// The instance is unreachable i.e. a connection to the application health checking endpoint cannot be established, or the server does not respond within the specified timeout.
	ManagedInstanceInstanceHealth_TIMEOUT ManagedInstanceInstanceHealth_DetailedHealthState = 477813057
	// The instance is reachable, but does not conform to the requirements defined by the health check.
	ManagedInstanceInstanceHealth_UNHEALTHY ManagedInstanceInstanceHealth_DetailedHealthState = 462118084
	// The health checking system is aware of the instance but its health is not known at the moment.
	ManagedInstanceInstanceHealth_UNKNOWN ManagedInstanceInstanceHealth_DetailedHealthState = 433141802
)

// Enum value maps for ManagedInstanceInstanceHealth_DetailedHealthState.
var (
	ManagedInstanceInstanceHealth_DetailedHealthState_name = map[int32]string{
		0:         "UNDEFINED_DETAILED_HEALTH_STATE",
		480455402: "DRAINING",
		439801213: "HEALTHY",
		477813057: "TIMEOUT",
		462118084: "UNHEALTHY",
		433141802: "UNKNOWN",
	}
	ManagedInstanceInstanceHealth_DetailedHealthState_value = map[string]int32{
		"UNDEFINED_DETAILED_HEALTH_STATE": 0,
		"DRAINING":                        480455402,
		"HEALTHY":                         439801213,
		"TIMEOUT":                         477813057,
		"UNHEALTHY":                       462118084,
		"UNKNOWN":                         433141802,
	}
)

func (x ManagedInstanceInstanceHealth_DetailedHealthState) Enum() *ManagedInstanceInstanceHealth_DetailedHealthState {
	p := new(ManagedInstanceInstanceHealth_DetailedHealthState)
	*p = x
	return p
}

func (x ManagedInstanceInstanceHealth_DetailedHealthState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ManagedInstanceInstanceHealth_DetailedHealthState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[129].Descriptor()
}

func (ManagedInstanceInstanceHealth_DetailedHealthState) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[129]
}

func (x ManagedInstanceInstanceHealth_DetailedHealthState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ManagedInstanceInstanceHealth_DetailedHealthState.Descriptor instead.
func (ManagedInstanceInstanceHealth_DetailedHealthState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{759, 0}
}

// Specifies how individual filter label matches within the list of filterLabels and contributes toward the overall metadataFilter match. Supported values are: - MATCH_ANY: at least one of the filterLabels must have a matching label in the provided metadata. - MATCH_ALL: all filterLabels must have matching labels in the provided metadata.
type MetadataFilter_FilterMatchCriteria int32

const (
	// A value indicating that the enum field is not set.
	MetadataFilter_UNDEFINED_FILTER_MATCH_CRITERIA MetadataFilter_FilterMatchCriteria = 0
	// Specifies that all filterLabels must match for the metadataFilter to be considered a match.
	MetadataFilter_MATCH_ALL MetadataFilter_FilterMatchCriteria = 180663271
	// Specifies that any filterLabel must match for the metadataFilter to be considered a match.
	MetadataFilter_MATCH_ANY MetadataFilter_FilterMatchCriteria = 180663346
	// Indicates that the match criteria was not set. A metadataFilter must never be created with this value.
	MetadataFilter_NOT_SET MetadataFilter_FilterMatchCriteria = 163646646
)

// Enum value maps for MetadataFilter_FilterMatchCriteria.
var (
	MetadataFilter_FilterMatchCriteria_name = map[int32]string{
		0:         "UNDEFINED_FILTER_MATCH_CRITERIA",
		180663271: "MATCH_ALL",
		180663346: "MATCH_ANY",
		163646646: "NOT_SET",
	}
	MetadataFilter_FilterMatchCriteria_value = map[string]int32{
		"UNDEFINED_FILTER_MATCH_CRITERIA": 0,
		"MATCH_ALL":                       180663271,
		"MATCH_ANY":                       180663346,
		"NOT_SET":                         163646646,
	}
)

func (x MetadataFilter_FilterMatchCriteria) Enum() *MetadataFilter_FilterMatchCriteria {
	p := new(MetadataFilter_FilterMatchCriteria)
	*p = x
	return p
}

func (x MetadataFilter_FilterMatchCriteria) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MetadataFilter_FilterMatchCriteria) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[130].Descriptor()
}

func (MetadataFilter_FilterMatchCriteria) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[130]
}

func (x MetadataFilter_FilterMatchCriteria) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MetadataFilter_FilterMatchCriteria.Descriptor instead.
func (MetadataFilter_FilterMatchCriteria) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{763, 0}
}

// The network firewall policy enforcement order. Can be either AFTER_CLASSIC_FIREWALL or BEFORE_CLASSIC_FIREWALL. Defaults to AFTER_CLASSIC_FIREWALL if the field is not specified.
type Network_NetworkFirewallPolicyEnforcementOrder int32

const (
	// A value indicating that the enum field is not set.
	Network_UNDEFINED_NETWORK_FIREWALL_POLICY_ENFORCEMENT_ORDER Network_NetworkFirewallPolicyEnforcementOrder = 0
	Network_AFTER_CLASSIC_FIREWALL                              Network_NetworkFirewallPolicyEnforcementOrder = 154582608
	Network_BEFORE_CLASSIC_FIREWALL                             Network_NetworkFirewallPolicyEnforcementOrder = 338458349
)

// Enum value maps for Network_NetworkFirewallPolicyEnforcementOrder.
var (
	Network_NetworkFirewallPolicyEnforcementOrder_name = map[int32]string{
		0:         "UNDEFINED_NETWORK_FIREWALL_POLICY_ENFORCEMENT_ORDER",
		154582608: "AFTER_CLASSIC_FIREWALL",
		338458349: "BEFORE_CLASSIC_FIREWALL",
	}
	Network_NetworkFirewallPolicyEnforcementOrder_value = map[string]int32{
		"UNDEFINED_NETWORK_FIREWALL_POLICY_ENFORCEMENT_ORDER": 0,
		"AFTER_CLASSIC_FIREWALL":                              154582608,
		"BEFORE_CLASSIC_FIREWALL":                             338458349,
	}
)

func (x Network_NetworkFirewallPolicyEnforcementOrder) Enum() *Network_NetworkFirewallPolicyEnforcementOrder {
	p := new(Network_NetworkFirewallPolicyEnforcementOrder)
	*p = x
	return p
}

func (x Network_NetworkFirewallPolicyEnforcementOrder) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Network_NetworkFirewallPolicyEnforcementOrder) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[131].Descriptor()
}

func (Network_NetworkFirewallPolicyEnforcementOrder) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[131]
}

func (x Network_NetworkFirewallPolicyEnforcementOrder) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Network_NetworkFirewallPolicyEnforcementOrder.Descriptor instead.
func (Network_NetworkFirewallPolicyEnforcementOrder) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{769, 0}
}

type NetworkAttachment_ConnectionPreference int32

const (
	// A value indicating that the enum field is not set.
	NetworkAttachment_UNDEFINED_CONNECTION_PREFERENCE NetworkAttachment_ConnectionPreference = 0
	NetworkAttachment_ACCEPT_AUTOMATIC                NetworkAttachment_ConnectionPreference = 75250580
	NetworkAttachment_ACCEPT_MANUAL                   NetworkAttachment_ConnectionPreference = 373061341
	NetworkAttachment_INVALID                         NetworkAttachment_ConnectionPreference = 530283991
)

// Enum value maps for NetworkAttachment_ConnectionPreference.
var (
	NetworkAttachment_ConnectionPreference_name = map[int32]string{
		0:         "UNDEFINED_CONNECTION_PREFERENCE",
		75250580:  "ACCEPT_AUTOMATIC",
		373061341: "ACCEPT_MANUAL",
		530283991: "INVALID",
	}
	NetworkAttachment_ConnectionPreference_value = map[string]int32{
		"UNDEFINED_CONNECTION_PREFERENCE": 0,
		"ACCEPT_AUTOMATIC":                75250580,
		"ACCEPT_MANUAL":                   373061341,
		"INVALID":                         530283991,
	}
)

func (x NetworkAttachment_ConnectionPreference) Enum() *NetworkAttachment_ConnectionPreference {
	p := new(NetworkAttachment_ConnectionPreference)
	*p = x
	return p
}

func (x NetworkAttachment_ConnectionPreference) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkAttachment_ConnectionPreference) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[132].Descriptor()
}

func (NetworkAttachment_ConnectionPreference) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[132]
}

func (x NetworkAttachment_ConnectionPreference) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkAttachment_ConnectionPreference.Descriptor instead.
func (NetworkAttachment_ConnectionPreference) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{770, 0}
}

// The status of a connected endpoint to this network attachment.
type NetworkAttachmentConnectedEndpoint_Status int32

const (
	// A value indicating that the enum field is not set.
	NetworkAttachmentConnectedEndpoint_UNDEFINED_STATUS NetworkAttachmentConnectedEndpoint_Status = 0
	// The consumer allows traffic from the producer to reach its VPC.
	NetworkAttachmentConnectedEndpoint_ACCEPTED NetworkAttachmentConnectedEndpoint_Status = 246714279
	// The consumer network attachment no longer exists.
	NetworkAttachmentConnectedEndpoint_CLOSED NetworkAttachmentConnectedEndpoint_Status = 380163436
	// The consumer needs to take further action before traffic can be served.
	NetworkAttachmentConnectedEndpoint_NEEDS_ATTENTION NetworkAttachmentConnectedEndpoint_Status = 344491452
	// The consumer neither allows nor prohibits traffic from the producer to reach its VPC.
	NetworkAttachmentConnectedEndpoint_PENDING NetworkAttachmentConnectedEndpoint_Status = 35394935
	// The consumer prohibits traffic from the producer to reach its VPC.
	NetworkAttachmentConnectedEndpoint_REJECTED           NetworkAttachmentConnectedEndpoint_Status = 174130302
	NetworkAttachmentConnectedEndpoint_STATUS_UNSPECIFIED NetworkAttachmentConnectedEndpoint_Status = 42133066
)

// Enum value maps for NetworkAttachmentConnectedEndpoint_Status.
var (
	NetworkAttachmentConnectedEndpoint_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		246714279: "ACCEPTED",
		380163436: "CLOSED",
		344491452: "NEEDS_ATTENTION",
		35394935:  "PENDING",
		174130302: "REJECTED",
		42133066:  "STATUS_UNSPECIFIED",
	}
	NetworkAttachmentConnectedEndpoint_Status_value = map[string]int32{
		"UNDEFINED_STATUS":   0,
		"ACCEPTED":           246714279,
		"CLOSED":             380163436,
		"NEEDS_ATTENTION":    344491452,
		"PENDING":            35394935,
		"REJECTED":           174130302,
		"STATUS_UNSPECIFIED": 42133066,
	}
)

func (x NetworkAttachmentConnectedEndpoint_Status) Enum() *NetworkAttachmentConnectedEndpoint_Status {
	p := new(NetworkAttachmentConnectedEndpoint_Status)
	*p = x
	return p
}

func (x NetworkAttachmentConnectedEndpoint_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkAttachmentConnectedEndpoint_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[133].Descriptor()
}

func (NetworkAttachmentConnectedEndpoint_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[133]
}

func (x NetworkAttachmentConnectedEndpoint_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkAttachmentConnectedEndpoint_Status.Descriptor instead.
func (NetworkAttachmentConnectedEndpoint_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{772, 0}
}

// Type of network endpoints in this network endpoint group. Can be one of GCE_VM_IP, GCE_VM_IP_PORT, NON_GCP_PRIVATE_IP_PORT, INTERNET_FQDN_PORT, INTERNET_IP_PORT, SERVERLESS, PRIVATE_SERVICE_CONNECT.
type NetworkEndpointGroup_NetworkEndpointType int32

const (
	// A value indicating that the enum field is not set.
	NetworkEndpointGroup_UNDEFINED_NETWORK_ENDPOINT_TYPE NetworkEndpointGroup_NetworkEndpointType = 0
	// The network endpoint is represented by an IP address.
	NetworkEndpointGroup_GCE_VM_IP NetworkEndpointGroup_NetworkEndpointType = 401880793
	// The network endpoint is represented by IP address and port pair.
	NetworkEndpointGroup_GCE_VM_IP_PORT NetworkEndpointGroup_NetworkEndpointType = 501838375
	// The network endpoint is represented by fully qualified domain name and port.
	NetworkEndpointGroup_INTERNET_FQDN_PORT NetworkEndpointGroup_NetworkEndpointType = 404154477
	// The network endpoint is represented by an internet IP address and port.
	NetworkEndpointGroup_INTERNET_IP_PORT NetworkEndpointGroup_NetworkEndpointType = 477719963
	// The network endpoint is represented by an IP address and port. The endpoint belongs to a VM or pod running in a customer's on-premises.
	NetworkEndpointGroup_NON_GCP_PRIVATE_IP_PORT NetworkEndpointGroup_NetworkEndpointType = 336447968
	// The network endpoint is either public Google APIs or services exposed by other GCP Project with a Service Attachment. The connection is set up by private service connect
	NetworkEndpointGroup_PRIVATE_SERVICE_CONNECT NetworkEndpointGroup_NetworkEndpointType = 48134724
	// The network endpoint is handled by specified serverless infrastructure.
	NetworkEndpointGroup_SERVERLESS NetworkEndpointGroup_NetworkEndpointType = 270492508
)

// Enum value maps for NetworkEndpointGroup_NetworkEndpointType.
var (
	NetworkEndpointGroup_NetworkEndpointType_name = map[int32]string{
		0:         "UNDEFINED_NETWORK_ENDPOINT_TYPE",
		401880793: "GCE_VM_IP",
		501838375: "GCE_VM_IP_PORT",
		404154477: "INTERNET_FQDN_PORT",
		477719963: "INTERNET_IP_PORT",
		336447968: "NON_GCP_PRIVATE_IP_PORT",
		48134724:  "PRIVATE_SERVICE_CONNECT",
		270492508: "SERVERLESS",
	}
	NetworkEndpointGroup_NetworkEndpointType_value = map[string]int32{
		"UNDEFINED_NETWORK_ENDPOINT_TYPE": 0,
		"GCE_VM_IP":                       401880793,
		"GCE_VM_IP_PORT":                  501838375,
		"INTERNET_FQDN_PORT":              404154477,
		"INTERNET_IP_PORT":                477719963,
		"NON_GCP_PRIVATE_IP_PORT":         336447968,
		"PRIVATE_SERVICE_CONNECT":         48134724,
		"SERVERLESS":                      270492508,
	}
)

func (x NetworkEndpointGroup_NetworkEndpointType) Enum() *NetworkEndpointGroup_NetworkEndpointType {
	p := new(NetworkEndpointGroup_NetworkEndpointType)
	*p = x
	return p
}

func (x NetworkEndpointGroup_NetworkEndpointType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkEndpointGroup_NetworkEndpointType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[134].Descriptor()
}

func (NetworkEndpointGroup_NetworkEndpointType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[134]
}

func (x NetworkEndpointGroup_NetworkEndpointType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkEndpointGroup_NetworkEndpointType.Descriptor instead.
func (NetworkEndpointGroup_NetworkEndpointType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{779, 0}
}

// [Output Only] The connection status of the PSC Forwarding Rule.
type NetworkEndpointGroupPscData_PscConnectionStatus int32

const (
	// A value indicating that the enum field is not set.
	NetworkEndpointGroupPscData_UNDEFINED_PSC_CONNECTION_STATUS NetworkEndpointGroupPscData_PscConnectionStatus = 0
	// The connection has been accepted by the producer.
	NetworkEndpointGroupPscData_ACCEPTED NetworkEndpointGroupPscData_PscConnectionStatus = 246714279
	// The connection has been closed by the producer and will not serve traffic going forward.
	NetworkEndpointGroupPscData_CLOSED NetworkEndpointGroupPscData_PscConnectionStatus = 380163436
	// The connection has been accepted by the producer, but the producer needs to take further action before the forwarding rule can serve traffic.
	NetworkEndpointGroupPscData_NEEDS_ATTENTION NetworkEndpointGroupPscData_PscConnectionStatus = 344491452
	// The connection is pending acceptance by the producer.
	NetworkEndpointGroupPscData_PENDING NetworkEndpointGroupPscData_PscConnectionStatus = 35394935
	// The connection has been rejected by the producer.
	NetworkEndpointGroupPscData_REJECTED           NetworkEndpointGroupPscData_PscConnectionStatus = 174130302
	NetworkEndpointGroupPscData_STATUS_UNSPECIFIED NetworkEndpointGroupPscData_PscConnectionStatus = 42133066
)

// Enum value maps for NetworkEndpointGroupPscData_PscConnectionStatus.
var (
	NetworkEndpointGroupPscData_PscConnectionStatus_name = map[int32]string{
		0:         "UNDEFINED_PSC_CONNECTION_STATUS",
		246714279: "ACCEPTED",
		380163436: "CLOSED",
		344491452: "NEEDS_ATTENTION",
		35394935:  "PENDING",
		174130302: "REJECTED",
		42133066:  "STATUS_UNSPECIFIED",
	}
	NetworkEndpointGroupPscData_PscConnectionStatus_value = map[string]int32{
		"UNDEFINED_PSC_CONNECTION_STATUS": 0,
		"ACCEPTED":                        246714279,
		"CLOSED":                          380163436,
		"NEEDS_ATTENTION":                 344491452,
		"PENDING":                         35394935,
		"REJECTED":                        174130302,
		"STATUS_UNSPECIFIED":              42133066,
	}
)

func (x NetworkEndpointGroupPscData_PscConnectionStatus) Enum() *NetworkEndpointGroupPscData_PscConnectionStatus {
	p := new(NetworkEndpointGroupPscData_PscConnectionStatus)
	*p = x
	return p
}

func (x NetworkEndpointGroupPscData_PscConnectionStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkEndpointGroupPscData_PscConnectionStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[135].Descriptor()
}

func (NetworkEndpointGroupPscData_PscConnectionStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[135]
}

func (x NetworkEndpointGroupPscData_PscConnectionStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkEndpointGroupPscData_PscConnectionStatus.Descriptor instead.
func (NetworkEndpointGroupPscData_PscConnectionStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{785, 0}
}

// Optional query parameter for showing the health status of each network endpoint. Valid options are SKIP or SHOW. If you don't specify this parameter, the health status of network endpoints will not be provided.
type NetworkEndpointGroupsListEndpointsRequest_HealthStatus int32

const (
	// A value indicating that the enum field is not set.
	NetworkEndpointGroupsListEndpointsRequest_UNDEFINED_HEALTH_STATUS NetworkEndpointGroupsListEndpointsRequest_HealthStatus = 0
	// Show the health status for each network endpoint. Impacts latency of the call.
	NetworkEndpointGroupsListEndpointsRequest_SHOW NetworkEndpointGroupsListEndpointsRequest_HealthStatus = 2544381
	// Health status for network endpoints will not be provided.
	NetworkEndpointGroupsListEndpointsRequest_SKIP NetworkEndpointGroupsListEndpointsRequest_HealthStatus = 2547071
)

// Enum value maps for NetworkEndpointGroupsListEndpointsRequest_HealthStatus.
var (
	NetworkEndpointGroupsListEndpointsRequest_HealthStatus_name = map[int32]string{
		0:       "UNDEFINED_HEALTH_STATUS",
		2544381: "SHOW",
		2547071: "SKIP",
	}
	NetworkEndpointGroupsListEndpointsRequest_HealthStatus_value = map[string]int32{
		"UNDEFINED_HEALTH_STATUS": 0,
		"SHOW":                    2544381,
		"SKIP":                    2547071,
	}
)

func (x NetworkEndpointGroupsListEndpointsRequest_HealthStatus) Enum() *NetworkEndpointGroupsListEndpointsRequest_HealthStatus {
	p := new(NetworkEndpointGroupsListEndpointsRequest_HealthStatus)
	*p = x
	return p
}

func (x NetworkEndpointGroupsListEndpointsRequest_HealthStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkEndpointGroupsListEndpointsRequest_HealthStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[136].Descriptor()
}

func (NetworkEndpointGroupsListEndpointsRequest_HealthStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[136]
}

func (x NetworkEndpointGroupsListEndpointsRequest_HealthStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkEndpointGroupsListEndpointsRequest_HealthStatus.Descriptor instead.
func (NetworkEndpointGroupsListEndpointsRequest_HealthStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{788, 0}
}

// [Output Only] One of EXTERNAL, INTERNAL to indicate whether the IP can be accessed from the Internet. This field is always inherited from its subnetwork. Valid only if stackType is IPV4_IPV6.
type NetworkInterface_Ipv6AccessType int32

const (
	// A value indicating that the enum field is not set.
	NetworkInterface_UNDEFINED_IPV6_ACCESS_TYPE NetworkInterface_Ipv6AccessType = 0
	// This network interface can have external IPv6.
	NetworkInterface_EXTERNAL NetworkInterface_Ipv6AccessType = 35607499
	// This network interface can have internal IPv6.
	NetworkInterface_INTERNAL                     NetworkInterface_Ipv6AccessType = 279295677
	NetworkInterface_UNSPECIFIED_IPV6_ACCESS_TYPE NetworkInterface_Ipv6AccessType = 313080613
)

// Enum value maps for NetworkInterface_Ipv6AccessType.
var (
	NetworkInterface_Ipv6AccessType_name = map[int32]string{
		0:         "UNDEFINED_IPV6_ACCESS_TYPE",
		35607499:  "EXTERNAL",
		279295677: "INTERNAL",
		313080613: "UNSPECIFIED_IPV6_ACCESS_TYPE",
	}
	NetworkInterface_Ipv6AccessType_value = map[string]int32{
		"UNDEFINED_IPV6_ACCESS_TYPE":   0,
		"EXTERNAL":                     35607499,
		"INTERNAL":                     279295677,
		"UNSPECIFIED_IPV6_ACCESS_TYPE": 313080613,
	}
)

func (x NetworkInterface_Ipv6AccessType) Enum() *NetworkInterface_Ipv6AccessType {
	p := new(NetworkInterface_Ipv6AccessType)
	*p = x
	return p
}

func (x NetworkInterface_Ipv6AccessType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkInterface_Ipv6AccessType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[137].Descriptor()
}

func (NetworkInterface_Ipv6AccessType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[137]
}

func (x NetworkInterface_Ipv6AccessType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkInterface_Ipv6AccessType.Descriptor instead.
func (NetworkInterface_Ipv6AccessType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{792, 0}
}

// The type of vNIC to be used on this interface. This may be gVNIC or VirtioNet.
type NetworkInterface_NicType int32

const (
	// A value indicating that the enum field is not set.
	NetworkInterface_UNDEFINED_NIC_TYPE NetworkInterface_NicType = 0
	// GVNIC
	NetworkInterface_GVNIC NetworkInterface_NicType = 68209305
	// No type specified.
	NetworkInterface_UNSPECIFIED_NIC_TYPE NetworkInterface_NicType = 67411801
	// VIRTIO
	NetworkInterface_VIRTIO_NET NetworkInterface_NicType = 452123481
)

// Enum value maps for NetworkInterface_NicType.
var (
	NetworkInterface_NicType_name = map[int32]string{
		0:         "UNDEFINED_NIC_TYPE",
		68209305:  "GVNIC",
		67411801:  "UNSPECIFIED_NIC_TYPE",
		452123481: "VIRTIO_NET",
	}
	NetworkInterface_NicType_value = map[string]int32{
		"UNDEFINED_NIC_TYPE":   0,
		"GVNIC":                68209305,
		"UNSPECIFIED_NIC_TYPE": 67411801,
		"VIRTIO_NET":           452123481,
	}
)

func (x NetworkInterface_NicType) Enum() *NetworkInterface_NicType {
	p := new(NetworkInterface_NicType)
	*p = x
	return p
}

func (x NetworkInterface_NicType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkInterface_NicType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[138].Descriptor()
}

func (NetworkInterface_NicType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[138]
}

func (x NetworkInterface_NicType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkInterface_NicType.Descriptor instead.
func (NetworkInterface_NicType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{792, 1}
}

// The stack type for this network interface to identify whether the IPv6 feature is enabled or not. If not specified, IPV4_ONLY will be used. This field can be both set at instance creation and update network interface operations.
type NetworkInterface_StackType int32

const (
	// A value indicating that the enum field is not set.
	NetworkInterface_UNDEFINED_STACK_TYPE NetworkInterface_StackType = 0
	// The network interface can have both IPv4 and IPv6 addresses.
	NetworkInterface_IPV4_IPV6 NetworkInterface_StackType = 22197249
	// The network interface will be assigned IPv4 address.
	NetworkInterface_IPV4_ONLY              NetworkInterface_StackType = 22373798
	NetworkInterface_UNSPECIFIED_STACK_TYPE NetworkInterface_StackType = 298084569
)

// Enum value maps for NetworkInterface_StackType.
var (
	NetworkInterface_StackType_name = map[int32]string{
		0:         "UNDEFINED_STACK_TYPE",
		22197249:  "IPV4_IPV6",
		22373798:  "IPV4_ONLY",
		298084569: "UNSPECIFIED_STACK_TYPE",
	}
	NetworkInterface_StackType_value = map[string]int32{
		"UNDEFINED_STACK_TYPE":   0,
		"IPV4_IPV6":              22197249,
		"IPV4_ONLY":              22373798,
		"UNSPECIFIED_STACK_TYPE": 298084569,
	}
)

func (x NetworkInterface_StackType) Enum() *NetworkInterface_StackType {
	p := new(NetworkInterface_StackType)
	*p = x
	return p
}

func (x NetworkInterface_StackType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkInterface_StackType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[139].Descriptor()
}

func (NetworkInterface_StackType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[139]
}

func (x NetworkInterface_StackType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkInterface_StackType.Descriptor instead.
func (NetworkInterface_StackType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{792, 2}
}

// Which IP version(s) of traffic and routes are allowed to be imported or exported between peer networks. The default value is IPV4_ONLY.
type NetworkPeering_StackType int32

const (
	// A value indicating that the enum field is not set.
	NetworkPeering_UNDEFINED_STACK_TYPE NetworkPeering_StackType = 0
	// This Peering will allow IPv4 traffic and routes to be exchanged. Additionally if the matching peering is IPV4_IPV6, IPv6 traffic and routes will be exchanged as well.
	NetworkPeering_IPV4_IPV6 NetworkPeering_StackType = 22197249
	// This Peering will only allow IPv4 traffic and routes to be exchanged, even if the matching peering is IPV4_IPV6.
	NetworkPeering_IPV4_ONLY NetworkPeering_StackType = 22373798
)

// Enum value maps for NetworkPeering_StackType.
var (
	NetworkPeering_StackType_name = map[int32]string{
		0:        "UNDEFINED_STACK_TYPE",
		22197249: "IPV4_IPV6",
		22373798: "IPV4_ONLY",
	}
	NetworkPeering_StackType_value = map[string]int32{
		"UNDEFINED_STACK_TYPE": 0,
		"IPV4_IPV6":            22197249,
		"IPV4_ONLY":            22373798,
	}
)

func (x NetworkPeering_StackType) Enum() *NetworkPeering_StackType {
	p := new(NetworkPeering_StackType)
	*p = x
	return p
}

func (x NetworkPeering_StackType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkPeering_StackType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[140].Descriptor()
}

func (NetworkPeering_StackType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[140]
}

func (x NetworkPeering_StackType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkPeering_StackType.Descriptor instead.
func (NetworkPeering_StackType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{794, 0}
}

// [Output Only] State for the peering, either `ACTIVE` or `INACTIVE`. The peering is `ACTIVE` when there's a matching configuration in the peer network.
type NetworkPeering_State int32

const (
	// A value indicating that the enum field is not set.
	NetworkPeering_UNDEFINED_STATE NetworkPeering_State = 0
	// Matching configuration exists on the peer.
	NetworkPeering_ACTIVE NetworkPeering_State = 314733318
	// There is no matching configuration on the peer, including the case when peer does not exist.
	NetworkPeering_INACTIVE NetworkPeering_State = 270421099
)

// Enum value maps for NetworkPeering_State.
var (
	NetworkPeering_State_name = map[int32]string{
		0:         "UNDEFINED_STATE",
		314733318: "ACTIVE",
		270421099: "INACTIVE",
	}
	NetworkPeering_State_value = map[string]int32{
		"UNDEFINED_STATE": 0,
		"ACTIVE":          314733318,
		"INACTIVE":        270421099,
	}
)

func (x NetworkPeering_State) Enum() *NetworkPeering_State {
	p := new(NetworkPeering_State)
	*p = x
	return p
}

func (x NetworkPeering_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkPeering_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[141].Descriptor()
}

func (NetworkPeering_State) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[141]
}

func (x NetworkPeering_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkPeering_State.Descriptor instead.
func (NetworkPeering_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{794, 1}
}

type NetworkPerformanceConfig_TotalEgressBandwidthTier int32

const (
	// A value indicating that the enum field is not set.
	NetworkPerformanceConfig_UNDEFINED_TOTAL_EGRESS_BANDWIDTH_TIER NetworkPerformanceConfig_TotalEgressBandwidthTier = 0
	NetworkPerformanceConfig_DEFAULT                               NetworkPerformanceConfig_TotalEgressBandwidthTier = 115302945
	NetworkPerformanceConfig_TIER_1                                NetworkPerformanceConfig_TotalEgressBandwidthTier = 326919444
)

// Enum value maps for NetworkPerformanceConfig_TotalEgressBandwidthTier.
var (
	NetworkPerformanceConfig_TotalEgressBandwidthTier_name = map[int32]string{
		0:         "UNDEFINED_TOTAL_EGRESS_BANDWIDTH_TIER",
		115302945: "DEFAULT",
		326919444: "TIER_1",
	}
	NetworkPerformanceConfig_TotalEgressBandwidthTier_value = map[string]int32{
		"UNDEFINED_TOTAL_EGRESS_BANDWIDTH_TIER": 0,
		"DEFAULT":                               115302945,
		"TIER_1":                                326919444,
	}
)

func (x NetworkPerformanceConfig_TotalEgressBandwidthTier) Enum() *NetworkPerformanceConfig_TotalEgressBandwidthTier {
	p := new(NetworkPerformanceConfig_TotalEgressBandwidthTier)
	*p = x
	return p
}

func (x NetworkPerformanceConfig_TotalEgressBandwidthTier) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkPerformanceConfig_TotalEgressBandwidthTier) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[142].Descriptor()
}

func (NetworkPerformanceConfig_TotalEgressBandwidthTier) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[142]
}

func (x NetworkPerformanceConfig_TotalEgressBandwidthTier) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkPerformanceConfig_TotalEgressBandwidthTier.Descriptor instead.
func (NetworkPerformanceConfig_TotalEgressBandwidthTier) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{795, 0}
}

// The network-wide routing mode to use. If set to REGIONAL, this network's Cloud Routers will only advertise routes with subnets of this network in the same region as the router. If set to GLOBAL, this network's Cloud Routers will advertise routes with all subnets of this network, across regions.
type NetworkRoutingConfig_RoutingMode int32

const (
	// A value indicating that the enum field is not set.
	NetworkRoutingConfig_UNDEFINED_ROUTING_MODE NetworkRoutingConfig_RoutingMode = 0
	NetworkRoutingConfig_GLOBAL                 NetworkRoutingConfig_RoutingMode = 494663587
	NetworkRoutingConfig_REGIONAL               NetworkRoutingConfig_RoutingMode = 92288543
)

// Enum value maps for NetworkRoutingConfig_RoutingMode.
var (
	NetworkRoutingConfig_RoutingMode_name = map[int32]string{
		0:         "UNDEFINED_ROUTING_MODE",
		494663587: "GLOBAL",
		92288543:  "REGIONAL",
	}
	NetworkRoutingConfig_RoutingMode_value = map[string]int32{
		"UNDEFINED_ROUTING_MODE": 0,
		"GLOBAL":                 494663587,
		"REGIONAL":               92288543,
	}
)

func (x NetworkRoutingConfig_RoutingMode) Enum() *NetworkRoutingConfig_RoutingMode {
	p := new(NetworkRoutingConfig_RoutingMode)
	*p = x
	return p
}

func (x NetworkRoutingConfig_RoutingMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkRoutingConfig_RoutingMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[143].Descriptor()
}

func (NetworkRoutingConfig_RoutingMode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[143]
}

func (x NetworkRoutingConfig_RoutingMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkRoutingConfig_RoutingMode.Descriptor instead.
func (NetworkRoutingConfig_RoutingMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{796, 0}
}

// [Output Only] The type of the firewall policy.
type NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type int32

const (
	// A value indicating that the enum field is not set.
	NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_UNDEFINED_TYPE NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type = 0
	NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_HIERARCHY      NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type = 69902869
	NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_NETWORK        NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type = 413984270
	NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_UNSPECIFIED    NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type = 526786327
)

// Enum value maps for NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type.
var (
	NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type_name = map[int32]string{
		0:         "UNDEFINED_TYPE",
		69902869:  "HIERARCHY",
		413984270: "NETWORK",
		526786327: "UNSPECIFIED",
	}
	NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type_value = map[string]int32{
		"UNDEFINED_TYPE": 0,
		"HIERARCHY":      69902869,
		"NETWORK":        413984270,
		"UNSPECIFIED":    526786327,
	}
)

func (x NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type) Enum() *NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type {
	p := new(NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type)
	*p = x
	return p
}

func (x NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[144].Descriptor()
}

func (NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[144]
}

func (x NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type.Descriptor instead.
func (NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{799, 0}
}

// Specifies how to handle instances when a node in the group undergoes maintenance. Set to one of: DEFAULT, RESTART_IN_PLACE, or MIGRATE_WITHIN_NODE_GROUP. The default value is DEFAULT. For more information, see Maintenance policies.
type NodeGroup_MaintenancePolicy int32

const (
	// A value indicating that the enum field is not set.
	NodeGroup_UNDEFINED_MAINTENANCE_POLICY NodeGroup_MaintenancePolicy = 0
	// Allow the node and corresponding instances to retain default maintenance behavior.
	NodeGroup_DEFAULT                        NodeGroup_MaintenancePolicy = 115302945
	NodeGroup_MAINTENANCE_POLICY_UNSPECIFIED NodeGroup_MaintenancePolicy = 72964182
	// When maintenance must be done on a node, the instances on that node will be moved to other nodes in the group. Instances with onHostMaintenance = MIGRATE will live migrate to their destinations while instances with onHostMaintenance = TERMINATE will terminate and then restart on their destination nodes if automaticRestart = true.
	NodeGroup_MIGRATE_WITHIN_NODE_GROUP NodeGroup_MaintenancePolicy = 153483394
	// Instances in this group will restart on the same node when maintenance has completed. Instances must have onHostMaintenance = TERMINATE, and they will only restart if automaticRestart = true.
	NodeGroup_RESTART_IN_PLACE NodeGroup_MaintenancePolicy = 228647325
)

// Enum value maps for NodeGroup_MaintenancePolicy.
var (
	NodeGroup_MaintenancePolicy_name = map[int32]string{
		0:         "UNDEFINED_MAINTENANCE_POLICY",
		115302945: "DEFAULT",
		72964182:  "MAINTENANCE_POLICY_UNSPECIFIED",
		153483394: "MIGRATE_WITHIN_NODE_GROUP",
		228647325: "RESTART_IN_PLACE",
	}
	NodeGroup_MaintenancePolicy_value = map[string]int32{
		"UNDEFINED_MAINTENANCE_POLICY":   0,
		"DEFAULT":                        115302945,
		"MAINTENANCE_POLICY_UNSPECIFIED": 72964182,
		"MIGRATE_WITHIN_NODE_GROUP":      153483394,
		"RESTART_IN_PLACE":               228647325,
	}
)

func (x NodeGroup_MaintenancePolicy) Enum() *NodeGroup_MaintenancePolicy {
	p := new(NodeGroup_MaintenancePolicy)
	*p = x
	return p
}

func (x NodeGroup_MaintenancePolicy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NodeGroup_MaintenancePolicy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[145].Descriptor()
}

func (NodeGroup_MaintenancePolicy) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[145]
}

func (x NodeGroup_MaintenancePolicy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NodeGroup_MaintenancePolicy.Descriptor instead.
func (NodeGroup_MaintenancePolicy) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{802, 0}
}

type NodeGroup_Status int32

const (
	// A value indicating that the enum field is not set.
	NodeGroup_UNDEFINED_STATUS NodeGroup_Status = 0
	NodeGroup_CREATING         NodeGroup_Status = 455564985
	NodeGroup_DELETING         NodeGroup_Status = 528602024
	NodeGroup_INVALID          NodeGroup_Status = 530283991
	NodeGroup_READY            NodeGroup_Status = 77848963
)

// Enum value maps for NodeGroup_Status.
var (
	NodeGroup_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		455564985: "CREATING",
		528602024: "DELETING",
		530283991: "INVALID",
		77848963:  "READY",
	}
	NodeGroup_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"CREATING":         455564985,
		"DELETING":         528602024,
		"INVALID":          530283991,
		"READY":            77848963,
	}
)

func (x NodeGroup_Status) Enum() *NodeGroup_Status {
	p := new(NodeGroup_Status)
	*p = x
	return p
}

func (x NodeGroup_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NodeGroup_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[146].Descriptor()
}

func (NodeGroup_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[146]
}

func (x NodeGroup_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NodeGroup_Status.Descriptor instead.
func (NodeGroup_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{802, 1}
}

// The autoscaling mode. Set to one of: ON, OFF, or ONLY_SCALE_OUT. For more information, see Autoscaler modes.
type NodeGroupAutoscalingPolicy_Mode int32

const (
	// A value indicating that the enum field is not set.
	NodeGroupAutoscalingPolicy_UNDEFINED_MODE   NodeGroupAutoscalingPolicy_Mode = 0
	NodeGroupAutoscalingPolicy_MODE_UNSPECIFIED NodeGroupAutoscalingPolicy_Mode = 371348091
	// Autoscaling is disabled.
	NodeGroupAutoscalingPolicy_OFF NodeGroupAutoscalingPolicy_Mode = 78159
	// Autocaling is fully enabled.
	NodeGroupAutoscalingPolicy_ON NodeGroupAutoscalingPolicy_Mode = 2527
	// Autoscaling will only scale out and will not remove nodes.
	NodeGroupAutoscalingPolicy_ONLY_SCALE_OUT NodeGroupAutoscalingPolicy_Mode = 152713670
)

// Enum value maps for NodeGroupAutoscalingPolicy_Mode.
var (
	NodeGroupAutoscalingPolicy_Mode_name = map[int32]string{
		0:         "UNDEFINED_MODE",
		371348091: "MODE_UNSPECIFIED",
		78159:     "OFF",
		2527:      "ON",
		152713670: "ONLY_SCALE_OUT",
	}
	NodeGroupAutoscalingPolicy_Mode_value = map[string]int32{
		"UNDEFINED_MODE":   0,
		"MODE_UNSPECIFIED": 371348091,
		"OFF":              78159,
		"ON":               2527,
		"ONLY_SCALE_OUT":   152713670,
	}
)

func (x NodeGroupAutoscalingPolicy_Mode) Enum() *NodeGroupAutoscalingPolicy_Mode {
	p := new(NodeGroupAutoscalingPolicy_Mode)
	*p = x
	return p
}

func (x NodeGroupAutoscalingPolicy_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NodeGroupAutoscalingPolicy_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[147].Descriptor()
}

func (NodeGroupAutoscalingPolicy_Mode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[147]
}

func (x NodeGroupAutoscalingPolicy_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NodeGroupAutoscalingPolicy_Mode.Descriptor instead.
func (NodeGroupAutoscalingPolicy_Mode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{804, 0}
}

// CPU overcommit.
type NodeGroupNode_CpuOvercommitType int32

const (
	// A value indicating that the enum field is not set.
	NodeGroupNode_UNDEFINED_CPU_OVERCOMMIT_TYPE   NodeGroupNode_CpuOvercommitType = 0
	NodeGroupNode_CPU_OVERCOMMIT_TYPE_UNSPECIFIED NodeGroupNode_CpuOvercommitType = 520665615
	NodeGroupNode_ENABLED                         NodeGroupNode_CpuOvercommitType = 182130465
	NodeGroupNode_NONE                            NodeGroupNode_CpuOvercommitType = 2402104
)

// Enum value maps for NodeGroupNode_CpuOvercommitType.
var (
	NodeGroupNode_CpuOvercommitType_name = map[int32]string{
		0:         "UNDEFINED_CPU_OVERCOMMIT_TYPE",
		520665615: "CPU_OVERCOMMIT_TYPE_UNSPECIFIED",
		182130465: "ENABLED",
		2402104:   "NONE",
	}
	NodeGroupNode_CpuOvercommitType_value = map[string]int32{
		"UNDEFINED_CPU_OVERCOMMIT_TYPE":   0,
		"CPU_OVERCOMMIT_TYPE_UNSPECIFIED": 520665615,
		"ENABLED":                         182130465,
		"NONE":                            2402104,
	}
)

func (x NodeGroupNode_CpuOvercommitType) Enum() *NodeGroupNode_CpuOvercommitType {
	p := new(NodeGroupNode_CpuOvercommitType)
	*p = x
	return p
}

func (x NodeGroupNode_CpuOvercommitType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NodeGroupNode_CpuOvercommitType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[148].Descriptor()
}

func (NodeGroupNode_CpuOvercommitType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[148]
}

func (x NodeGroupNode_CpuOvercommitType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NodeGroupNode_CpuOvercommitType.Descriptor instead.
func (NodeGroupNode_CpuOvercommitType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{807, 0}
}

type NodeGroupNode_Status int32

const (
	// A value indicating that the enum field is not set.
	NodeGroupNode_UNDEFINED_STATUS NodeGroupNode_Status = 0
	NodeGroupNode_CREATING         NodeGroupNode_Status = 455564985
	NodeGroupNode_DELETING         NodeGroupNode_Status = 528602024
	NodeGroupNode_INVALID          NodeGroupNode_Status = 530283991
	NodeGroupNode_READY            NodeGroupNode_Status = 77848963
	NodeGroupNode_REPAIRING        NodeGroupNode_Status = 413483285
)

// Enum value maps for NodeGroupNode_Status.
var (
	NodeGroupNode_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		455564985: "CREATING",
		528602024: "DELETING",
		530283991: "INVALID",
		77848963:  "READY",
		413483285: "REPAIRING",
	}
	NodeGroupNode_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"CREATING":         455564985,
		"DELETING":         528602024,
		"INVALID":          530283991,
		"READY":            77848963,
		"REPAIRING":        413483285,
	}
)

func (x NodeGroupNode_Status) Enum() *NodeGroupNode_Status {
	p := new(NodeGroupNode_Status)
	*p = x
	return p
}

func (x NodeGroupNode_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NodeGroupNode_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[149].Descriptor()
}

func (NodeGroupNode_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[149]
}

func (x NodeGroupNode_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NodeGroupNode_Status.Descriptor instead.
func (NodeGroupNode_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{807, 1}
}

// CPU overcommit.
type NodeTemplate_CpuOvercommitType int32

const (
	// A value indicating that the enum field is not set.
	NodeTemplate_UNDEFINED_CPU_OVERCOMMIT_TYPE   NodeTemplate_CpuOvercommitType = 0
	NodeTemplate_CPU_OVERCOMMIT_TYPE_UNSPECIFIED NodeTemplate_CpuOvercommitType = 520665615
	NodeTemplate_ENABLED                         NodeTemplate_CpuOvercommitType = 182130465
	NodeTemplate_NONE                            NodeTemplate_CpuOvercommitType = 2402104
)

// Enum value maps for NodeTemplate_CpuOvercommitType.
var (
	NodeTemplate_CpuOvercommitType_name = map[int32]string{
		0:         "UNDEFINED_CPU_OVERCOMMIT_TYPE",
		520665615: "CPU_OVERCOMMIT_TYPE_UNSPECIFIED",
		182130465: "ENABLED",
		2402104:   "NONE",
	}
	NodeTemplate_CpuOvercommitType_value = map[string]int32{
		"UNDEFINED_CPU_OVERCOMMIT_TYPE":   0,
		"CPU_OVERCOMMIT_TYPE_UNSPECIFIED": 520665615,
		"ENABLED":                         182130465,
		"NONE":                            2402104,
	}
)

func (x NodeTemplate_CpuOvercommitType) Enum() *NodeTemplate_CpuOvercommitType {
	p := new(NodeTemplate_CpuOvercommitType)
	*p = x
	return p
}

func (x NodeTemplate_CpuOvercommitType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NodeTemplate_CpuOvercommitType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[150].Descriptor()
}

func (NodeTemplate_CpuOvercommitType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[150]
}

func (x NodeTemplate_CpuOvercommitType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NodeTemplate_CpuOvercommitType.Descriptor instead.
func (NodeTemplate_CpuOvercommitType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{814, 0}
}

// [Output Only] The status of the node template. One of the following values: CREATING, READY, and DELETING.
type NodeTemplate_Status int32

const (
	// A value indicating that the enum field is not set.
	NodeTemplate_UNDEFINED_STATUS NodeTemplate_Status = 0
	// Resources are being allocated.
	NodeTemplate_CREATING NodeTemplate_Status = 455564985
	// The node template is currently being deleted.
	NodeTemplate_DELETING NodeTemplate_Status = 528602024
	// Invalid status.
	NodeTemplate_INVALID NodeTemplate_Status = 530283991
	// The node template is ready.
	NodeTemplate_READY NodeTemplate_Status = 77848963
)

// Enum value maps for NodeTemplate_Status.
var (
	NodeTemplate_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		455564985: "CREATING",
		528602024: "DELETING",
		530283991: "INVALID",
		77848963:  "READY",
	}
	NodeTemplate_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"CREATING":         455564985,
		"DELETING":         528602024,
		"INVALID":          530283991,
		"READY":            77848963,
	}
)

func (x NodeTemplate_Status) Enum() *NodeTemplate_Status {
	p := new(NodeTemplate_Status)
	*p = x
	return p
}

func (x NodeTemplate_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NodeTemplate_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[151].Descriptor()
}

func (NodeTemplate_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[151]
}

func (x NodeTemplate_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NodeTemplate_Status.Descriptor instead.
func (NodeTemplate_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{814, 1}
}

// [Output Only] The status of the operation, which can be one of the following: `PENDING`, `RUNNING`, or `DONE`.
type Operation_Status int32

const (
	// A value indicating that the enum field is not set.
	Operation_UNDEFINED_STATUS Operation_Status = 0
	Operation_DONE             Operation_Status = 2104194
	Operation_PENDING          Operation_Status = 35394935
	Operation_RUNNING          Operation_Status = 121282975
)

// Enum value maps for Operation_Status.
var (
	Operation_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		2104194:   "DONE",
		35394935:  "PENDING",
		121282975: "RUNNING",
	}
	Operation_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"DONE":             2104194,
		"PENDING":          35394935,
		"RUNNING":          121282975,
	}
)

func (x Operation_Status) Enum() *Operation_Status {
	p := new(Operation_Status)
	*p = x
	return p
}

func (x Operation_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Operation_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[152].Descriptor()
}

func (Operation_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[152]
}

func (x Operation_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Operation_Status.Descriptor instead.
func (Operation_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{826, 0}
}

// From how long ago in the past these intervals were observed.
type PacketIntervals_Duration int32

const (
	// A value indicating that the enum field is not set.
	PacketIntervals_UNDEFINED_DURATION   PacketIntervals_Duration = 0
	PacketIntervals_DURATION_UNSPECIFIED PacketIntervals_Duration = 529071340
	PacketIntervals_HOUR                 PacketIntervals_Duration = 2223588
	// From BfdSession object creation time.
	PacketIntervals_MAX    PacketIntervals_Duration = 76100
	PacketIntervals_MINUTE PacketIntervals_Duration = 126786068
)

// Enum value maps for PacketIntervals_Duration.
var (
	PacketIntervals_Duration_name = map[int32]string{
		0:         "UNDEFINED_DURATION",
		529071340: "DURATION_UNSPECIFIED",
		2223588:   "HOUR",
		76100:     "MAX",
		126786068: "MINUTE",
	}
	PacketIntervals_Duration_value = map[string]int32{
		"UNDEFINED_DURATION":   0,
		"DURATION_UNSPECIFIED": 529071340,
		"HOUR":                 2223588,
		"MAX":                  76100,
		"MINUTE":               126786068,
	}
)

func (x PacketIntervals_Duration) Enum() *PacketIntervals_Duration {
	p := new(PacketIntervals_Duration)
	*p = x
	return p
}

func (x PacketIntervals_Duration) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PacketIntervals_Duration) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[153].Descriptor()
}

func (PacketIntervals_Duration) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[153]
}

func (x PacketIntervals_Duration) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PacketIntervals_Duration.Descriptor instead.
func (PacketIntervals_Duration) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{831, 0}
}

// The type of packets for which inter-packet intervals were computed.
type PacketIntervals_Type int32

const (
	// A value indicating that the enum field is not set.
	PacketIntervals_UNDEFINED_TYPE PacketIntervals_Type = 0
	// Only applies to Echo packets. This shows the intervals between sending and receiving the same packet.
	PacketIntervals_LOOPBACK PacketIntervals_Type = 356174219
	// Intervals between received packets.
	PacketIntervals_RECEIVE PacketIntervals_Type = 189660867
	// Intervals between transmitted packets.
	PacketIntervals_TRANSMIT         PacketIntervals_Type = 452903600
	PacketIntervals_TYPE_UNSPECIFIED PacketIntervals_Type = 437714322
)

// Enum value maps for PacketIntervals_Type.
var (
	PacketIntervals_Type_name = map[int32]string{
		0:         "UNDEFINED_TYPE",
		356174219: "LOOPBACK",
		189660867: "RECEIVE",
		452903600: "TRANSMIT",
		437714322: "TYPE_UNSPECIFIED",
	}
	PacketIntervals_Type_value = map[string]int32{
		"UNDEFINED_TYPE":   0,
		"LOOPBACK":         356174219,
		"RECEIVE":          189660867,
		"TRANSMIT":         452903600,
		"TYPE_UNSPECIFIED": 437714322,
	}
)

func (x PacketIntervals_Type) Enum() *PacketIntervals_Type {
	p := new(PacketIntervals_Type)
	*p = x
	return p
}

func (x PacketIntervals_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PacketIntervals_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[154].Descriptor()
}

func (PacketIntervals_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[154]
}

func (x PacketIntervals_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PacketIntervals_Type.Descriptor instead.
func (PacketIntervals_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{831, 1}
}

// Indicates whether or not this packet mirroring takes effect. If set to FALSE, this packet mirroring policy will not be enforced on the network. The default is TRUE.
type PacketMirroring_Enable int32

const (
	// A value indicating that the enum field is not set.
	PacketMirroring_UNDEFINED_ENABLE PacketMirroring_Enable = 0
	PacketMirroring_FALSE            PacketMirroring_Enable = 66658563
	PacketMirroring_TRUE             PacketMirroring_Enable = 2583950
)

// Enum value maps for PacketMirroring_Enable.
var (
	PacketMirroring_Enable_name = map[int32]string{
		0:        "UNDEFINED_ENABLE",
		66658563: "FALSE",
		2583950:  "TRUE",
	}
	PacketMirroring_Enable_value = map[string]int32{
		"UNDEFINED_ENABLE": 0,
		"FALSE":            66658563,
		"TRUE":             2583950,
	}
)

func (x PacketMirroring_Enable) Enum() *PacketMirroring_Enable {
	p := new(PacketMirroring_Enable)
	*p = x
	return p
}

func (x PacketMirroring_Enable) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PacketMirroring_Enable) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[155].Descriptor()
}

func (PacketMirroring_Enable) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[155]
}

func (x PacketMirroring_Enable) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PacketMirroring_Enable.Descriptor instead.
func (PacketMirroring_Enable) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{832, 0}
}

// Direction of traffic to mirror, either INGRESS, EGRESS, or BOTH. The default is BOTH.
type PacketMirroringFilter_Direction int32

const (
	// A value indicating that the enum field is not set.
	PacketMirroringFilter_UNDEFINED_DIRECTION PacketMirroringFilter_Direction = 0
	// Default, both directions are mirrored.
	PacketMirroringFilter_BOTH PacketMirroringFilter_Direction = 2044801
	// Only egress traffic is mirrored.
	PacketMirroringFilter_EGRESS PacketMirroringFilter_Direction = 432880501
	// Only ingress traffic is mirrored.
	PacketMirroringFilter_INGRESS PacketMirroringFilter_Direction = 516931221
)

// Enum value maps for PacketMirroringFilter_Direction.
var (
	PacketMirroringFilter_Direction_name = map[int32]string{
		0:         "UNDEFINED_DIRECTION",
		2044801:   "BOTH",
		432880501: "EGRESS",
		516931221: "INGRESS",
	}
	PacketMirroringFilter_Direction_value = map[string]int32{
		"UNDEFINED_DIRECTION": 0,
		"BOTH":                2044801,
		"EGRESS":              432880501,
		"INGRESS":             516931221,
	}
)

func (x PacketMirroringFilter_Direction) Enum() *PacketMirroringFilter_Direction {
	p := new(PacketMirroringFilter_Direction)
	*p = x
	return p
}

func (x PacketMirroringFilter_Direction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PacketMirroringFilter_Direction) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[156].Descriptor()
}

func (PacketMirroringFilter_Direction) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[156]
}

func (x PacketMirroringFilter_Direction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PacketMirroringFilter_Direction.Descriptor instead.
func (PacketMirroringFilter_Direction) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{834, 0}
}

// The status of applying this per-instance configuration on the corresponding managed instance.
type PerInstanceConfig_Status int32

const (
	// A value indicating that the enum field is not set.
	PerInstanceConfig_UNDEFINED_STATUS PerInstanceConfig_Status = 0
	// The per-instance configuration is being applied to the instance, but is not yet effective, possibly waiting for the instance to, for example, REFRESH.
	PerInstanceConfig_APPLYING PerInstanceConfig_Status = 352003508
	// The per-instance configuration deletion is being applied on the instance, possibly waiting for the instance to, for example, REFRESH.
	PerInstanceConfig_DELETING PerInstanceConfig_Status = 528602024
	// The per-instance configuration is effective on the instance, meaning that all disks, ips and metadata specified in this configuration are attached or set on the instance.
	PerInstanceConfig_EFFECTIVE PerInstanceConfig_Status = 244201863
	// *[Default]* The default status, when no per-instance configuration exists.
	PerInstanceConfig_NONE PerInstanceConfig_Status = 2402104
	// The per-instance configuration is set on an instance but not been applied yet.
	PerInstanceConfig_UNAPPLIED PerInstanceConfig_Status = 483935140
	// The per-instance configuration has been deleted, but the deletion is not yet applied.
	PerInstanceConfig_UNAPPLIED_DELETION PerInstanceConfig_Status = 313956873
)

// Enum value maps for PerInstanceConfig_Status.
var (
	PerInstanceConfig_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		352003508: "APPLYING",
		528602024: "DELETING",
		244201863: "EFFECTIVE",
		2402104:   "NONE",
		483935140: "UNAPPLIED",
		313956873: "UNAPPLIED_DELETION",
	}
	PerInstanceConfig_Status_value = map[string]int32{
		"UNDEFINED_STATUS":   0,
		"APPLYING":           352003508,
		"DELETING":           528602024,
		"EFFECTIVE":          244201863,
		"NONE":               2402104,
		"UNAPPLIED":          483935140,
		"UNAPPLIED_DELETION": 313956873,
	}
)

func (x PerInstanceConfig_Status) Enum() *PerInstanceConfig_Status {
	p := new(PerInstanceConfig_Status)
	*p = x
	return p
}

func (x PerInstanceConfig_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PerInstanceConfig_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[157].Descriptor()
}

func (PerInstanceConfig_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[157]
}

func (x PerInstanceConfig_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PerInstanceConfig_Status.Descriptor instead.
func (PerInstanceConfig_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{889, 0}
}

// These stateful disks will never be deleted during autohealing, update, instance recreate operations. This flag is used to configure if the disk should be deleted after it is no longer used by the group, e.g. when the given instance or the whole MIG is deleted. Note: disks attached in READ_ONLY mode cannot be auto-deleted.
type PreservedStatePreservedDisk_AutoDelete int32

const (
	// A value indicating that the enum field is not set.
	PreservedStatePreservedDisk_UNDEFINED_AUTO_DELETE          PreservedStatePreservedDisk_AutoDelete = 0
	PreservedStatePreservedDisk_NEVER                          PreservedStatePreservedDisk_AutoDelete = 74175084
	PreservedStatePreservedDisk_ON_PERMANENT_INSTANCE_DELETION PreservedStatePreservedDisk_AutoDelete = 95727719
)

// Enum value maps for PreservedStatePreservedDisk_AutoDelete.
var (
	PreservedStatePreservedDisk_AutoDelete_name = map[int32]string{
		0:        "UNDEFINED_AUTO_DELETE",
		74175084: "NEVER",
		95727719: "ON_PERMANENT_INSTANCE_DELETION",
	}
	PreservedStatePreservedDisk_AutoDelete_value = map[string]int32{
		"UNDEFINED_AUTO_DELETE":          0,
		"NEVER":                          74175084,
		"ON_PERMANENT_INSTANCE_DELETION": 95727719,
	}
)

func (x PreservedStatePreservedDisk_AutoDelete) Enum() *PreservedStatePreservedDisk_AutoDelete {
	p := new(PreservedStatePreservedDisk_AutoDelete)
	*p = x
	return p
}

func (x PreservedStatePreservedDisk_AutoDelete) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PreservedStatePreservedDisk_AutoDelete) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[158].Descriptor()
}

func (PreservedStatePreservedDisk_AutoDelete) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[158]
}

func (x PreservedStatePreservedDisk_AutoDelete) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PreservedStatePreservedDisk_AutoDelete.Descriptor instead.
func (PreservedStatePreservedDisk_AutoDelete) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{893, 0}
}

// The mode in which to attach this disk, either READ_WRITE or READ_ONLY. If not specified, the default is to attach the disk in READ_WRITE mode.
type PreservedStatePreservedDisk_Mode int32

const (
	// A value indicating that the enum field is not set.
	PreservedStatePreservedDisk_UNDEFINED_MODE PreservedStatePreservedDisk_Mode = 0
	// Attaches this disk in read-only mode. Multiple VM instances can use a disk in READ_ONLY mode at a time.
	PreservedStatePreservedDisk_READ_ONLY PreservedStatePreservedDisk_Mode = 91950261
	// *[Default]* Attaches this disk in READ_WRITE mode. Only one VM instance at a time can be attached to a disk in READ_WRITE mode.
	PreservedStatePreservedDisk_READ_WRITE PreservedStatePreservedDisk_Mode = 173607894
)

// Enum value maps for PreservedStatePreservedDisk_Mode.
var (
	PreservedStatePreservedDisk_Mode_name = map[int32]string{
		0:         "UNDEFINED_MODE",
		91950261:  "READ_ONLY",
		173607894: "READ_WRITE",
	}
	PreservedStatePreservedDisk_Mode_value = map[string]int32{
		"UNDEFINED_MODE": 0,
		"READ_ONLY":      91950261,
		"READ_WRITE":     173607894,
	}
)

func (x PreservedStatePreservedDisk_Mode) Enum() *PreservedStatePreservedDisk_Mode {
	p := new(PreservedStatePreservedDisk_Mode)
	*p = x
	return p
}

func (x PreservedStatePreservedDisk_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PreservedStatePreservedDisk_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[159].Descriptor()
}

func (PreservedStatePreservedDisk_Mode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[159]
}

func (x PreservedStatePreservedDisk_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PreservedStatePreservedDisk_Mode.Descriptor instead.
func (PreservedStatePreservedDisk_Mode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{893, 1}
}

// This signifies the default network tier used for configuring resources of the project and can only take the following values: PREMIUM, STANDARD. Initially the default network tier is PREMIUM.
type Project_DefaultNetworkTier int32

const (
	// A value indicating that the enum field is not set.
	Project_UNDEFINED_DEFAULT_NETWORK_TIER Project_DefaultNetworkTier = 0
	// Public internet quality with fixed bandwidth.
	Project_FIXED_STANDARD Project_DefaultNetworkTier = 310464328
	// High quality, Google-grade network tier, support for all networking products.
	Project_PREMIUM Project_DefaultNetworkTier = 399530551
	// Public internet quality, only limited support for other networking products.
	Project_STANDARD Project_DefaultNetworkTier = 484642493
	// (Output only) Temporary tier for FIXED_STANDARD when fixed standard tier is expired or not configured.
	Project_STANDARD_OVERRIDES_FIXED_STANDARD Project_DefaultNetworkTier = 465847234
)

// Enum value maps for Project_DefaultNetworkTier.
var (
	Project_DefaultNetworkTier_name = map[int32]string{
		0:         "UNDEFINED_DEFAULT_NETWORK_TIER",
		310464328: "FIXED_STANDARD",
		399530551: "PREMIUM",
		484642493: "STANDARD",
		465847234: "STANDARD_OVERRIDES_FIXED_STANDARD",
	}
	Project_DefaultNetworkTier_value = map[string]int32{
		"UNDEFINED_DEFAULT_NETWORK_TIER":    0,
		"FIXED_STANDARD":                    310464328,
		"PREMIUM":                           399530551,
		"STANDARD":                          484642493,
		"STANDARD_OVERRIDES_FIXED_STANDARD": 465847234,
	}
)

func (x Project_DefaultNetworkTier) Enum() *Project_DefaultNetworkTier {
	p := new(Project_DefaultNetworkTier)
	*p = x
	return p
}

func (x Project_DefaultNetworkTier) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Project_DefaultNetworkTier) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[160].Descriptor()
}

func (Project_DefaultNetworkTier) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[160]
}

func (x Project_DefaultNetworkTier) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Project_DefaultNetworkTier.Descriptor instead.
func (Project_DefaultNetworkTier) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{895, 0}
}

// [Output Only] Default internal DNS setting used by VMs running in this project.
type Project_VmDnsSetting int32

const (
	// A value indicating that the enum field is not set.
	Project_UNDEFINED_VM_DNS_SETTING   Project_VmDnsSetting = 0
	Project_GLOBAL_DEFAULT             Project_VmDnsSetting = 345419141
	Project_UNSPECIFIED_VM_DNS_SETTING Project_VmDnsSetting = 35691930
	Project_ZONAL_DEFAULT              Project_VmDnsSetting = 368475782
	Project_ZONAL_ONLY                 Project_VmDnsSetting = 521198951
)

// Enum value maps for Project_VmDnsSetting.
var (
	Project_VmDnsSetting_name = map[int32]string{
		0:         "UNDEFINED_VM_DNS_SETTING",
		345419141: "GLOBAL_DEFAULT",
		35691930:  "UNSPECIFIED_VM_DNS_SETTING",
		368475782: "ZONAL_DEFAULT",
		521198951: "ZONAL_ONLY",
	}
	Project_VmDnsSetting_value = map[string]int32{
		"UNDEFINED_VM_DNS_SETTING":   0,
		"GLOBAL_DEFAULT":             345419141,
		"UNSPECIFIED_VM_DNS_SETTING": 35691930,
		"ZONAL_DEFAULT":              368475782,
		"ZONAL_ONLY":                 521198951,
	}
)

func (x Project_VmDnsSetting) Enum() *Project_VmDnsSetting {
	p := new(Project_VmDnsSetting)
	*p = x
	return p
}

func (x Project_VmDnsSetting) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Project_VmDnsSetting) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[161].Descriptor()
}

func (Project_VmDnsSetting) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[161]
}

func (x Project_VmDnsSetting) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Project_VmDnsSetting.Descriptor instead.
func (Project_VmDnsSetting) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{895, 1}
}

// [Output Only] The role this project has in a shared VPC configuration. Currently, only projects with the host role, which is specified by the value HOST, are differentiated.
type Project_XpnProjectStatus int32

const (
	// A value indicating that the enum field is not set.
	Project_UNDEFINED_XPN_PROJECT_STATUS   Project_XpnProjectStatus = 0
	Project_HOST                           Project_XpnProjectStatus = 2223528
	Project_UNSPECIFIED_XPN_PROJECT_STATUS Project_XpnProjectStatus = 340393257
)

// Enum value maps for Project_XpnProjectStatus.
var (
	Project_XpnProjectStatus_name = map[int32]string{
		0:         "UNDEFINED_XPN_PROJECT_STATUS",
		2223528:   "HOST",
		340393257: "UNSPECIFIED_XPN_PROJECT_STATUS",
	}
	Project_XpnProjectStatus_value = map[string]int32{
		"UNDEFINED_XPN_PROJECT_STATUS":   0,
		"HOST":                           2223528,
		"UNSPECIFIED_XPN_PROJECT_STATUS": 340393257,
	}
)

func (x Project_XpnProjectStatus) Enum() *Project_XpnProjectStatus {
	p := new(Project_XpnProjectStatus)
	*p = x
	return p
}

func (x Project_XpnProjectStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Project_XpnProjectStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[162].Descriptor()
}

func (Project_XpnProjectStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[162]
}

func (x Project_XpnProjectStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Project_XpnProjectStatus.Descriptor instead.
func (Project_XpnProjectStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{895, 2}
}

// Default network tier to be set.
type ProjectsSetDefaultNetworkTierRequest_NetworkTier int32

const (
	// A value indicating that the enum field is not set.
	ProjectsSetDefaultNetworkTierRequest_UNDEFINED_NETWORK_TIER ProjectsSetDefaultNetworkTierRequest_NetworkTier = 0
	// Public internet quality with fixed bandwidth.
	ProjectsSetDefaultNetworkTierRequest_FIXED_STANDARD ProjectsSetDefaultNetworkTierRequest_NetworkTier = 310464328
	// High quality, Google-grade network tier, support for all networking products.
	ProjectsSetDefaultNetworkTierRequest_PREMIUM ProjectsSetDefaultNetworkTierRequest_NetworkTier = 399530551
	// Public internet quality, only limited support for other networking products.
	ProjectsSetDefaultNetworkTierRequest_STANDARD ProjectsSetDefaultNetworkTierRequest_NetworkTier = 484642493
	// (Output only) Temporary tier for FIXED_STANDARD when fixed standard tier is expired or not configured.
	ProjectsSetDefaultNetworkTierRequest_STANDARD_OVERRIDES_FIXED_STANDARD ProjectsSetDefaultNetworkTierRequest_NetworkTier = 465847234
)

// Enum value maps for ProjectsSetDefaultNetworkTierRequest_NetworkTier.
var (
	ProjectsSetDefaultNetworkTierRequest_NetworkTier_name = map[int32]string{
		0:         "UNDEFINED_NETWORK_TIER",
		310464328: "FIXED_STANDARD",
		399530551: "PREMIUM",
		484642493: "STANDARD",
		465847234: "STANDARD_OVERRIDES_FIXED_STANDARD",
	}
	ProjectsSetDefaultNetworkTierRequest_NetworkTier_value = map[string]int32{
		"UNDEFINED_NETWORK_TIER":            0,
		"FIXED_STANDARD":                    310464328,
		"PREMIUM":                           399530551,
		"STANDARD":                          484642493,
		"STANDARD_OVERRIDES_FIXED_STANDARD": 465847234,
	}
)

func (x ProjectsSetDefaultNetworkTierRequest_NetworkTier) Enum() *ProjectsSetDefaultNetworkTierRequest_NetworkTier {
	p := new(ProjectsSetDefaultNetworkTierRequest_NetworkTier)
	*p = x
	return p
}

func (x ProjectsSetDefaultNetworkTierRequest_NetworkTier) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ProjectsSetDefaultNetworkTierRequest_NetworkTier) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[163].Descriptor()
}

func (ProjectsSetDefaultNetworkTierRequest_NetworkTier) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[163]
}

func (x ProjectsSetDefaultNetworkTierRequest_NetworkTier) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ProjectsSetDefaultNetworkTierRequest_NetworkTier.Descriptor instead.
func (ProjectsSetDefaultNetworkTierRequest_NetworkTier) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{900, 0}
}

// The status of the public advertised prefix. Possible values include: - `INITIAL`: RPKI validation is complete. - `PTR_CONFIGURED`: User has configured the PTR. - `VALIDATED`: Reverse DNS lookup is successful. - `REVERSE_DNS_LOOKUP_FAILED`: Reverse DNS lookup failed. - `PREFIX_CONFIGURATION_IN_PROGRESS`: The prefix is being configured. - `PREFIX_CONFIGURATION_COMPLETE`: The prefix is fully configured. - `PREFIX_REMOVAL_IN_PROGRESS`: The prefix is being removed.
type PublicAdvertisedPrefix_Status int32

const (
	// A value indicating that the enum field is not set.
	PublicAdvertisedPrefix_UNDEFINED_STATUS PublicAdvertisedPrefix_Status = 0
	// RPKI validation is complete.
	PublicAdvertisedPrefix_INITIAL PublicAdvertisedPrefix_Status = 518841124
	// The prefix is fully configured.
	PublicAdvertisedPrefix_PREFIX_CONFIGURATION_COMPLETE PublicAdvertisedPrefix_Status = 480889551
	// The prefix is being configured.
	PublicAdvertisedPrefix_PREFIX_CONFIGURATION_IN_PROGRESS PublicAdvertisedPrefix_Status = 378550961
	// The prefix is being removed.
	PublicAdvertisedPrefix_PREFIX_REMOVAL_IN_PROGRESS PublicAdvertisedPrefix_Status = 284375783
	// User has configured the PTR.
	PublicAdvertisedPrefix_PTR_CONFIGURED PublicAdvertisedPrefix_Status = 513497167
	// Reverse DNS lookup failed.
	PublicAdvertisedPrefix_REVERSE_DNS_LOOKUP_FAILED PublicAdvertisedPrefix_Status = 295755183
	// Reverse DNS lookup is successful.
	PublicAdvertisedPrefix_VALIDATED PublicAdvertisedPrefix_Status = 66197998
)

// Enum value maps for PublicAdvertisedPrefix_Status.
var (
	PublicAdvertisedPrefix_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		518841124: "INITIAL",
		480889551: "PREFIX_CONFIGURATION_COMPLETE",
		378550961: "PREFIX_CONFIGURATION_IN_PROGRESS",
		284375783: "PREFIX_REMOVAL_IN_PROGRESS",
		513497167: "PTR_CONFIGURED",
		295755183: "REVERSE_DNS_LOOKUP_FAILED",
		66197998:  "VALIDATED",
	}
	PublicAdvertisedPrefix_Status_value = map[string]int32{
		"UNDEFINED_STATUS":                 0,
		"INITIAL":                          518841124,
		"PREFIX_CONFIGURATION_COMPLETE":    480889551,
		"PREFIX_CONFIGURATION_IN_PROGRESS": 378550961,
		"PREFIX_REMOVAL_IN_PROGRESS":       284375783,
		"PTR_CONFIGURED":                   513497167,
		"REVERSE_DNS_LOOKUP_FAILED":        295755183,
		"VALIDATED":                        66197998,
	}
)

func (x PublicAdvertisedPrefix_Status) Enum() *PublicAdvertisedPrefix_Status {
	p := new(PublicAdvertisedPrefix_Status)
	*p = x
	return p
}

func (x PublicAdvertisedPrefix_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PublicAdvertisedPrefix_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[164].Descriptor()
}

func (PublicAdvertisedPrefix_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[164]
}

func (x PublicAdvertisedPrefix_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PublicAdvertisedPrefix_Status.Descriptor instead.
func (PublicAdvertisedPrefix_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{901, 0}
}

// [Output Only] The status of the public delegated prefix, which can be one of following values: - `INITIALIZING` The public delegated prefix is being initialized and addresses cannot be created yet. - `READY_TO_ANNOUNCE` The public delegated prefix is a live migration prefix and is active. - `ANNOUNCED` The public delegated prefix is active. - `DELETING` The public delegated prefix is being deprovsioned.
type PublicDelegatedPrefix_Status int32

const (
	// A value indicating that the enum field is not set.
	PublicDelegatedPrefix_UNDEFINED_STATUS PublicDelegatedPrefix_Status = 0
	// The public delegated prefix is active.
	PublicDelegatedPrefix_ANNOUNCED PublicDelegatedPrefix_Status = 365103355
	// The public delegated prefix is being deprovsioned.
	PublicDelegatedPrefix_DELETING PublicDelegatedPrefix_Status = 528602024
	// The public delegated prefix is being initialized and addresses cannot be created yet.
	PublicDelegatedPrefix_INITIALIZING PublicDelegatedPrefix_Status = 306588749
	// The public delegated prefix is currently withdrawn but ready to be announced.
	PublicDelegatedPrefix_READY_TO_ANNOUNCE PublicDelegatedPrefix_Status = 64641265
)

// Enum value maps for PublicDelegatedPrefix_Status.
var (
	PublicDelegatedPrefix_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		365103355: "ANNOUNCED",
		528602024: "DELETING",
		306588749: "INITIALIZING",
		64641265:  "READY_TO_ANNOUNCE",
	}
	PublicDelegatedPrefix_Status_value = map[string]int32{
		"UNDEFINED_STATUS":  0,
		"ANNOUNCED":         365103355,
		"DELETING":          528602024,
		"INITIALIZING":      306588749,
		"READY_TO_ANNOUNCE": 64641265,
	}
)

func (x PublicDelegatedPrefix_Status) Enum() *PublicDelegatedPrefix_Status {
	p := new(PublicDelegatedPrefix_Status)
	*p = x
	return p
}

func (x PublicDelegatedPrefix_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PublicDelegatedPrefix_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[165].Descriptor()
}

func (PublicDelegatedPrefix_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[165]
}

func (x PublicDelegatedPrefix_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PublicDelegatedPrefix_Status.Descriptor instead.
func (PublicDelegatedPrefix_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{904, 0}
}

// [Output Only] The status of the sub public delegated prefix.
type PublicDelegatedPrefixPublicDelegatedSubPrefix_Status int32

const (
	// A value indicating that the enum field is not set.
	PublicDelegatedPrefixPublicDelegatedSubPrefix_UNDEFINED_STATUS PublicDelegatedPrefixPublicDelegatedSubPrefix_Status = 0
	PublicDelegatedPrefixPublicDelegatedSubPrefix_ACTIVE           PublicDelegatedPrefixPublicDelegatedSubPrefix_Status = 314733318
	PublicDelegatedPrefixPublicDelegatedSubPrefix_INACTIVE         PublicDelegatedPrefixPublicDelegatedSubPrefix_Status = 270421099
)

// Enum value maps for PublicDelegatedPrefixPublicDelegatedSubPrefix_Status.
var (
	PublicDelegatedPrefixPublicDelegatedSubPrefix_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		314733318: "ACTIVE",
		270421099: "INACTIVE",
	}
	PublicDelegatedPrefixPublicDelegatedSubPrefix_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"ACTIVE":           314733318,
		"INACTIVE":         270421099,
	}
)

func (x PublicDelegatedPrefixPublicDelegatedSubPrefix_Status) Enum() *PublicDelegatedPrefixPublicDelegatedSubPrefix_Status {
	p := new(PublicDelegatedPrefixPublicDelegatedSubPrefix_Status)
	*p = x
	return p
}

func (x PublicDelegatedPrefixPublicDelegatedSubPrefix_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PublicDelegatedPrefixPublicDelegatedSubPrefix_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[166].Descriptor()
}

func (PublicDelegatedPrefixPublicDelegatedSubPrefix_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[166]
}

func (x PublicDelegatedPrefixPublicDelegatedSubPrefix_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PublicDelegatedPrefixPublicDelegatedSubPrefix_Status.Descriptor instead.
func (PublicDelegatedPrefixPublicDelegatedSubPrefix_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{907, 0}
}

// [Output Only] Name of the quota metric.
type Quota_Metric int32

const (
	// A value indicating that the enum field is not set.
	Quota_UNDEFINED_METRIC                Quota_Metric = 0
	Quota_A2_CPUS                         Quota_Metric = 153206585
	Quota_AFFINITY_GROUPS                 Quota_Metric = 108303563
	Quota_AUTOSCALERS                     Quota_Metric = 471248988
	Quota_BACKEND_BUCKETS                 Quota_Metric = 137626846
	Quota_BACKEND_SERVICES                Quota_Metric = 269623753
	Quota_C2D_CPUS                        Quota_Metric = 508182517
	Quota_C2_CPUS                         Quota_Metric = 317601211
	Quota_C3_CPUS                         Quota_Metric = 346230362
	Quota_COMMITMENTS                     Quota_Metric = 456141790
	Quota_COMMITTED_A2_CPUS               Quota_Metric = 59330902
	Quota_COMMITTED_C2D_CPUS              Quota_Metric = 282390904
	Quota_COMMITTED_C2_CPUS               Quota_Metric = 223725528
	Quota_COMMITTED_C3_CPUS               Quota_Metric = 252354679
	Quota_COMMITTED_CPUS                  Quota_Metric = 292394702
	Quota_COMMITTED_E2_CPUS               Quota_Metric = 388120154
	Quota_COMMITTED_LICENSES              Quota_Metric = 357606869
	Quota_COMMITTED_LOCAL_SSD_TOTAL_GB    Quota_Metric = 308393480
	Quota_COMMITTED_M3_CPUS               Quota_Metric = 585985
	Quota_COMMITTED_MEMORY_OPTIMIZED_CPUS Quota_Metric = 489057886
	Quota_COMMITTED_N2A_CPUS              Quota_Metric = 40064304
	Quota_COMMITTED_N2D_CPUS              Quota_Metric = 125951757
	Quota_COMMITTED_N2_CPUS               Quota_Metric = 322589603
	Quota_COMMITTED_NVIDIA_A100_80GB_GPUS Quota_Metric = 464326565
	Quota_COMMITTED_NVIDIA_A100_GPUS      Quota_Metric = 375799445
	Quota_COMMITTED_NVIDIA_K80_GPUS       Quota_Metric = 3857188
	Quota_COMMITTED_NVIDIA_P100_GPUS      Quota_Metric = 107528100
	Quota_COMMITTED_NVIDIA_P4_GPUS        Quota_Metric = 347952897
	Quota_COMMITTED_NVIDIA_T4_GPUS        Quota_Metric = 139871237
	Quota_COMMITTED_NVIDIA_V100_GPUS      Quota_Metric = 219562
	Quota_COMMITTED_T2A_CPUS              Quota_Metric = 296378986
	Quota_COMMITTED_T2D_CPUS              Quota_Metric = 382266439
	// Guest CPUs
	Quota_CPUS                                                   Quota_Metric = 2075595
	Quota_CPUS_ALL_REGIONS                                       Quota_Metric = 470911149
	Quota_DISKS_TOTAL_GB                                         Quota_Metric = 353520543
	Quota_E2_CPUS                                                Quota_Metric = 481995837
	Quota_EXTERNAL_MANAGED_FORWARDING_RULES                      Quota_Metric = 150790089
	Quota_EXTERNAL_NETWORK_LB_FORWARDING_RULES                   Quota_Metric = 374298265
	Quota_EXTERNAL_PROTOCOL_FORWARDING_RULES                     Quota_Metric = 63478888
	Quota_EXTERNAL_VPN_GATEWAYS                                  Quota_Metric = 272457134
	Quota_FIREWALLS                                              Quota_Metric = 374485843
	Quota_FORWARDING_RULES                                       Quota_Metric = 432668949
	Quota_GLOBAL_EXTERNAL_MANAGED_BACKEND_SERVICES               Quota_Metric = 164566753
	Quota_GLOBAL_EXTERNAL_MANAGED_FORWARDING_RULES               Quota_Metric = 327611949
	Quota_GLOBAL_EXTERNAL_PROXY_LB_BACKEND_SERVICES              Quota_Metric = 400256169
	Quota_GLOBAL_INTERNAL_ADDRESSES                              Quota_Metric = 42738332
	Quota_GLOBAL_INTERNAL_MANAGED_BACKEND_SERVICES               Quota_Metric = 256608303
	Quota_GLOBAL_INTERNAL_TRAFFIC_DIRECTOR_BACKEND_SERVICES      Quota_Metric = 323514196
	Quota_GPUS_ALL_REGIONS                                       Quota_Metric = 39387177
	Quota_HEALTH_CHECKS                                          Quota_Metric = 289347502
	Quota_IMAGES                                                 Quota_Metric = 15562360
	Quota_INSTANCES                                              Quota_Metric = 131337822
	Quota_INSTANCE_GROUPS                                        Quota_Metric = 355919038
	Quota_INSTANCE_GROUP_MANAGERS                                Quota_Metric = 101798192
	Quota_INSTANCE_TEMPLATES                                     Quota_Metric = 226188271
	Quota_INTERCONNECTS                                          Quota_Metric = 415204741
	Quota_INTERCONNECT_ATTACHMENTS_PER_REGION                    Quota_Metric = 159968086
	Quota_INTERCONNECT_ATTACHMENTS_TOTAL_MBPS                    Quota_Metric = 425090419
	Quota_INTERCONNECT_TOTAL_GBPS                                Quota_Metric = 285341866
	Quota_INTERNAL_ADDRESSES                                     Quota_Metric = 197899392
	Quota_INTERNAL_TRAFFIC_DIRECTOR_FORWARDING_RULES             Quota_Metric = 266433668
	Quota_IN_PLACE_SNAPSHOTS                                     Quota_Metric = 151359133
	Quota_IN_USE_ADDRESSES                                       Quota_Metric = 402125072
	Quota_IN_USE_BACKUP_SCHEDULES                                Quota_Metric = 32786705
	Quota_IN_USE_SNAPSHOT_SCHEDULES                              Quota_Metric = 462104083
	Quota_LOCAL_SSD_TOTAL_GB                                     Quota_Metric = 330878021
	Quota_M1_CPUS                                                Quota_Metric = 37203366
	Quota_M2_CPUS                                                Quota_Metric = 65832517
	Quota_M3_CPUS                                                Quota_Metric = 94461668
	Quota_MACHINE_IMAGES                                         Quota_Metric = 446986640
	Quota_N2A_CPUS                                               Quota_Metric = 265855917
	Quota_N2D_CPUS                                               Quota_Metric = 351743370
	Quota_N2_CPUS                                                Quota_Metric = 416465286
	Quota_NETWORKS                                               Quota_Metric = 485481477
	Quota_NETWORK_ATTACHMENTS                                    Quota_Metric = 149028575
	Quota_NETWORK_ENDPOINT_GROUPS                                Quota_Metric = 102144909
	Quota_NETWORK_FIREWALL_POLICIES                              Quota_Metric = 101117374
	Quota_NODE_GROUPS                                            Quota_Metric = 24624817
	Quota_NODE_TEMPLATES                                         Quota_Metric = 474896668
	Quota_NVIDIA_A100_80GB_GPUS                                  Quota_Metric = 286389320
	Quota_NVIDIA_A100_GPUS                                       Quota_Metric = 504872978
	Quota_NVIDIA_K80_GPUS                                        Quota_Metric = 163886599
	Quota_NVIDIA_P100_GPUS                                       Quota_Metric = 236601633
	Quota_NVIDIA_P100_VWS_GPUS                                   Quota_Metric = 213970574
	Quota_NVIDIA_P4_GPUS                                         Quota_Metric = 283841470
	Quota_NVIDIA_P4_VWS_GPUS                                     Quota_Metric = 528296619
	Quota_NVIDIA_T4_GPUS                                         Quota_Metric = 75759810
	Quota_NVIDIA_T4_VWS_GPUS                                     Quota_Metric = 319813039
	Quota_NVIDIA_V100_GPUS                                       Quota_Metric = 129293095
	Quota_PACKET_MIRRORINGS                                      Quota_Metric = 15578407
	Quota_PD_EXTREME_TOTAL_PROVISIONED_IOPS                      Quota_Metric = 69593965
	Quota_PREEMPTIBLE_CPUS                                       Quota_Metric = 251184841
	Quota_PREEMPTIBLE_LOCAL_SSD_GB                               Quota_Metric = 260819336
	Quota_PREEMPTIBLE_NVIDIA_A100_80GB_GPUS                      Quota_Metric = 151942410
	Quota_PREEMPTIBLE_NVIDIA_A100_GPUS                           Quota_Metric = 68832784
	Quota_PREEMPTIBLE_NVIDIA_K80_GPUS                            Quota_Metric = 374960201
	Quota_PREEMPTIBLE_NVIDIA_P100_GPUS                           Quota_Metric = 337432351
	Quota_PREEMPTIBLE_NVIDIA_P100_VWS_GPUS                       Quota_Metric = 313544076
	Quota_PREEMPTIBLE_NVIDIA_P4_GPUS                             Quota_Metric = 429197628
	Quota_PREEMPTIBLE_NVIDIA_P4_VWS_GPUS                         Quota_Metric = 252981545
	Quota_PREEMPTIBLE_NVIDIA_T4_GPUS                             Quota_Metric = 221115968
	Quota_PREEMPTIBLE_NVIDIA_T4_VWS_GPUS                         Quota_Metric = 44497965
	Quota_PREEMPTIBLE_NVIDIA_V100_GPUS                           Quota_Metric = 230123813
	Quota_PSC_ILB_CONSUMER_FORWARDING_RULES_PER_PRODUCER_NETWORK Quota_Metric = 231164291
	Quota_PSC_INTERNAL_LB_FORWARDING_RULES                       Quota_Metric = 169005435
	Quota_PUBLIC_ADVERTISED_PREFIXES                             Quota_Metric = 471371980
	Quota_PUBLIC_DELEGATED_PREFIXES                              Quota_Metric = 532465974
	Quota_REGIONAL_AUTOSCALERS                                   Quota_Metric = 29363772
	Quota_REGIONAL_EXTERNAL_MANAGED_BACKEND_SERVICES             Quota_Metric = 4240989
	Quota_REGIONAL_EXTERNAL_NETWORK_LB_BACKEND_SERVICES          Quota_Metric = 409564525
	Quota_REGIONAL_INSTANCE_GROUP_MANAGERS                       Quota_Metric = 37543696
	Quota_REGIONAL_INTERNAL_LB_BACKEND_SERVICES                  Quota_Metric = 137983760
	Quota_REGIONAL_INTERNAL_MANAGED_BACKEND_SERVICES             Quota_Metric = 96282539
	Quota_RESERVATIONS                                           Quota_Metric = 32644647
	Quota_RESOURCE_POLICIES                                      Quota_Metric = 83955297
	Quota_ROUTERS                                                Quota_Metric = 493018666
	Quota_ROUTES                                                 Quota_Metric = 275680074
	Quota_SECURITY_POLICIES                                      Quota_Metric = 189518703
	Quota_SECURITY_POLICIES_PER_REGION                           Quota_Metric = 249041734
	Quota_SECURITY_POLICY_CEVAL_RULES                            Quota_Metric = 470815689
	Quota_SECURITY_POLICY_RULES                                  Quota_Metric = 203549225
	Quota_SECURITY_POLICY_RULES_PER_REGION                       Quota_Metric = 126510156
	Quota_SERVICE_ATTACHMENTS                                    Quota_Metric = 471521510
	// The total number of snapshots allowed for a single project.
	Quota_SNAPSHOTS                           Quota_Metric = 343405327
	Quota_SSD_TOTAL_GB                        Quota_Metric = 161732561
	Quota_SSL_CERTIFICATES                    Quota_Metric = 378372399
	Quota_STATIC_ADDRESSES                    Quota_Metric = 93624049
	Quota_STATIC_BYOIP_ADDRESSES              Quota_Metric = 275809649
	Quota_STATIC_EXTERNAL_IPV6_ADDRESS_RANGES Quota_Metric = 472346774
	Quota_SUBNETWORKS                         Quota_Metric = 421330469
	Quota_T2A_CPUS                            Quota_Metric = 522170599
	Quota_T2D_CPUS                            Quota_Metric = 71187140
	Quota_TARGET_HTTPS_PROXIES                Quota_Metric = 219522506
	Quota_TARGET_HTTP_PROXIES                 Quota_Metric = 164117155
	Quota_TARGET_INSTANCES                    Quota_Metric = 284519728
	Quota_TARGET_POOLS                        Quota_Metric = 348261257
	Quota_TARGET_SSL_PROXIES                  Quota_Metric = 159216235
	Quota_TARGET_TCP_PROXIES                  Quota_Metric = 182243136
	Quota_TARGET_VPN_GATEWAYS                 Quota_Metric = 75029928
	Quota_URL_MAPS                            Quota_Metric = 378660743
	Quota_VPN_GATEWAYS                        Quota_Metric = 35620282
	Quota_VPN_TUNNELS                         Quota_Metric = 104327296
	Quota_XPN_SERVICE_PROJECTS                Quota_Metric = 95191981
)

// Enum value maps for Quota_Metric.
var (
	Quota_Metric_name = map[int32]string{
		0:         "UNDEFINED_METRIC",
		153206585: "A2_CPUS",
		108303563: "AFFINITY_GROUPS",
		471248988: "AUTOSCALERS",
		137626846: "BACKEND_BUCKETS",
		269623753: "BACKEND_SERVICES",
		508182517: "C2D_CPUS",
		317601211: "C2_CPUS",
		346230362: "C3_CPUS",
		456141790: "COMMITMENTS",
		59330902:  "COMMITTED_A2_CPUS",
		282390904: "COMMITTED_C2D_CPUS",
		223725528: "COMMITTED_C2_CPUS",
		252354679: "COMMITTED_C3_CPUS",
		292394702: "COMMITTED_CPUS",
		388120154: "COMMITTED_E2_CPUS",
		357606869: "COMMITTED_LICENSES",
		308393480: "COMMITTED_LOCAL_SSD_TOTAL_GB",
		585985:    "COMMITTED_M3_CPUS",
		489057886: "COMMITTED_MEMORY_OPTIMIZED_CPUS",
		40064304:  "COMMITTED_N2A_CPUS",
		125951757: "COMMITTED_N2D_CPUS",
		322589603: "COMMITTED_N2_CPUS",
		464326565: "COMMITTED_NVIDIA_A100_80GB_GPUS",
		375799445: "COMMITTED_NVIDIA_A100_GPUS",
		3857188:   "COMMITTED_NVIDIA_K80_GPUS",
		107528100: "COMMITTED_NVIDIA_P100_GPUS",
		347952897: "COMMITTED_NVIDIA_P4_GPUS",
		139871237: "COMMITTED_NVIDIA_T4_GPUS",
		219562:    "COMMITTED_NVIDIA_V100_GPUS",
		296378986: "COMMITTED_T2A_CPUS",
		382266439: "COMMITTED_T2D_CPUS",
		2075595:   "CPUS",
		470911149: "CPUS_ALL_REGIONS",
		353520543: "DISKS_TOTAL_GB",
		481995837: "E2_CPUS",
		150790089: "EXTERNAL_MANAGED_FORWARDING_RULES",
		374298265: "EXTERNAL_NETWORK_LB_FORWARDING_RULES",
		63478888:  "EXTERNAL_PROTOCOL_FORWARDING_RULES",
		272457134: "EXTERNAL_VPN_GATEWAYS",
		374485843: "FIREWALLS",
		432668949: "FORWARDING_RULES",
		164566753: "GLOBAL_EXTERNAL_MANAGED_BACKEND_SERVICES",
		327611949: "GLOBAL_EXTERNAL_MANAGED_FORWARDING_RULES",
		400256169: "GLOBAL_EXTERNAL_PROXY_LB_BACKEND_SERVICES",
		42738332:  "GLOBAL_INTERNAL_ADDRESSES",
		256608303: "GLOBAL_INTERNAL_MANAGED_BACKEND_SERVICES",
		323514196: "GLOBAL_INTERNAL_TRAFFIC_DIRECTOR_BACKEND_SERVICES",
		39387177:  "GPUS_ALL_REGIONS",
		289347502: "HEALTH_CHECKS",
		15562360:  "IMAGES",
		131337822: "INSTANCES",
		355919038: "INSTANCE_GROUPS",
		101798192: "INSTANCE_GROUP_MANAGERS",
		226188271: "INSTANCE_TEMPLATES",
		415204741: "INTERCONNECTS",
		159968086: "INTERCONNECT_ATTACHMENTS_PER_REGION",
		425090419: "INTERCONNECT_ATTACHMENTS_TOTAL_MBPS",
		285341866: "INTERCONNECT_TOTAL_GBPS",
		197899392: "INTERNAL_ADDRESSES",
		266433668: "INTERNAL_TRAFFIC_DIRECTOR_FORWARDING_RULES",
		151359133: "IN_PLACE_SNAPSHOTS",
		402125072: "IN_USE_ADDRESSES",
		32786705:  "IN_USE_BACKUP_SCHEDULES",
		462104083: "IN_USE_SNAPSHOT_SCHEDULES",
		330878021: "LOCAL_SSD_TOTAL_GB",
		37203366:  "M1_CPUS",
		65832517:  "M2_CPUS",
		94461668:  "M3_CPUS",
		446986640: "MACHINE_IMAGES",
		265855917: "N2A_CPUS",
		351743370: "N2D_CPUS",
		416465286: "N2_CPUS",
		485481477: "NETWORKS",
		149028575: "NETWORK_ATTACHMENTS",
		102144909: "NETWORK_ENDPOINT_GROUPS",
		101117374: "NETWORK_FIREWALL_POLICIES",
		24624817:  "NODE_GROUPS",
		474896668: "NODE_TEMPLATES",
		286389320: "NVIDIA_A100_80GB_GPUS",
		504872978: "NVIDIA_A100_GPUS",
		163886599: "NVIDIA_K80_GPUS",
		236601633: "NVIDIA_P100_GPUS",
		213970574: "NVIDIA_P100_VWS_GPUS",
		283841470: "NVIDIA_P4_GPUS",
		528296619: "NVIDIA_P4_VWS_GPUS",
		75759810:  "NVIDIA_T4_GPUS",
		319813039: "NVIDIA_T4_VWS_GPUS",
		129293095: "NVIDIA_V100_GPUS",
		15578407:  "PACKET_MIRRORINGS",
		69593965:  "PD_EXTREME_TOTAL_PROVISIONED_IOPS",
		251184841: "PREEMPTIBLE_CPUS",
		260819336: "PREEMPTIBLE_LOCAL_SSD_GB",
		151942410: "PREEMPTIBLE_NVIDIA_A100_80GB_GPUS",
		68832784:  "PREEMPTIBLE_NVIDIA_A100_GPUS",
		374960201: "PREEMPTIBLE_NVIDIA_K80_GPUS",
		337432351: "PREEMPTIBLE_NVIDIA_P100_GPUS",
		313544076: "PREEMPTIBLE_NVIDIA_P100_VWS_GPUS",
		429197628: "PREEMPTIBLE_NVIDIA_P4_GPUS",
		252981545: "PREEMPTIBLE_NVIDIA_P4_VWS_GPUS",
		221115968: "PREEMPTIBLE_NVIDIA_T4_GPUS",
		44497965:  "PREEMPTIBLE_NVIDIA_T4_VWS_GPUS",
		230123813: "PREEMPTIBLE_NVIDIA_V100_GPUS",
		231164291: "PSC_ILB_CONSUMER_FORWARDING_RULES_PER_PRODUCER_NETWORK",
		169005435: "PSC_INTERNAL_LB_FORWARDING_RULES",
		471371980: "PUBLIC_ADVERTISED_PREFIXES",
		532465974: "PUBLIC_DELEGATED_PREFIXES",
		29363772:  "REGIONAL_AUTOSCALERS",
		4240989:   "REGIONAL_EXTERNAL_MANAGED_BACKEND_SERVICES",
		409564525: "REGIONAL_EXTERNAL_NETWORK_LB_BACKEND_SERVICES",
		37543696:  "REGIONAL_INSTANCE_GROUP_MANAGERS",
		137983760: "REGIONAL_INTERNAL_LB_BACKEND_SERVICES",
		96282539:  "REGIONAL_INTERNAL_MANAGED_BACKEND_SERVICES",
		32644647:  "RESERVATIONS",
		83955297:  "RESOURCE_POLICIES",
		493018666: "ROUTERS",
		275680074: "ROUTES",
		189518703: "SECURITY_POLICIES",
		249041734: "SECURITY_POLICIES_PER_REGION",
		470815689: "SECURITY_POLICY_CEVAL_RULES",
		203549225: "SECURITY_POLICY_RULES",
		126510156: "SECURITY_POLICY_RULES_PER_REGION",
		471521510: "SERVICE_ATTACHMENTS",
		343405327: "SNAPSHOTS",
		161732561: "SSD_TOTAL_GB",
		378372399: "SSL_CERTIFICATES",
		93624049:  "STATIC_ADDRESSES",
		275809649: "STATIC_BYOIP_ADDRESSES",
		472346774: "STATIC_EXTERNAL_IPV6_ADDRESS_RANGES",
		421330469: "SUBNETWORKS",
		522170599: "T2A_CPUS",
		71187140:  "T2D_CPUS",
		219522506: "TARGET_HTTPS_PROXIES",
		164117155: "TARGET_HTTP_PROXIES",
		284519728: "TARGET_INSTANCES",
		348261257: "TARGET_POOLS",
		159216235: "TARGET_SSL_PROXIES",
		182243136: "TARGET_TCP_PROXIES",
		75029928:  "TARGET_VPN_GATEWAYS",
		378660743: "URL_MAPS",
		35620282:  "VPN_GATEWAYS",
		104327296: "VPN_TUNNELS",
		95191981:  "XPN_SERVICE_PROJECTS",
	}
	Quota_Metric_value = map[string]int32{
		"UNDEFINED_METRIC":                          0,
		"A2_CPUS":                                   153206585,
		"AFFINITY_GROUPS":                           108303563,
		"AUTOSCALERS":                               471248988,
		"BACKEND_BUCKETS":                           137626846,
		"BACKEND_SERVICES":                          269623753,
		"C2D_CPUS":                                  508182517,
		"C2_CPUS":                                   317601211,
		"C3_CPUS":                                   346230362,
		"COMMITMENTS":                               456141790,
		"COMMITTED_A2_CPUS":                         59330902,
		"COMMITTED_C2D_CPUS":                        282390904,
		"COMMITTED_C2_CPUS":                         223725528,
		"COMMITTED_C3_CPUS":                         252354679,
		"COMMITTED_CPUS":                            292394702,
		"COMMITTED_E2_CPUS":                         388120154,
		"COMMITTED_LICENSES":                        357606869,
		"COMMITTED_LOCAL_SSD_TOTAL_GB":              308393480,
		"COMMITTED_M3_CPUS":                         585985,
		"COMMITTED_MEMORY_OPTIMIZED_CPUS":           489057886,
		"COMMITTED_N2A_CPUS":                        40064304,
		"COMMITTED_N2D_CPUS":                        125951757,
		"COMMITTED_N2_CPUS":                         322589603,
		"COMMITTED_NVIDIA_A100_80GB_GPUS":           464326565,
		"COMMITTED_NVIDIA_A100_GPUS":                375799445,
		"COMMITTED_NVIDIA_K80_GPUS":                 3857188,
		"COMMITTED_NVIDIA_P100_GPUS":                107528100,
		"COMMITTED_NVIDIA_P4_GPUS":                  347952897,
		"COMMITTED_NVIDIA_T4_GPUS":                  139871237,
		"COMMITTED_NVIDIA_V100_GPUS":                219562,
		"COMMITTED_T2A_CPUS":                        296378986,
		"COMMITTED_T2D_CPUS":                        382266439,
		"CPUS":                                      2075595,
		"CPUS_ALL_REGIONS":                          470911149,
		"DISKS_TOTAL_GB":                            353520543,
		"E2_CPUS":                                   481995837,
		"EXTERNAL_MANAGED_FORWARDING_RULES":         150790089,
		"EXTERNAL_NETWORK_LB_FORWARDING_RULES":      374298265,
		"EXTERNAL_PROTOCOL_FORWARDING_RULES":        63478888,
		"EXTERNAL_VPN_GATEWAYS":                     272457134,
		"FIREWALLS":                                 374485843,
		"FORWARDING_RULES":                          432668949,
		"GLOBAL_EXTERNAL_MANAGED_BACKEND_SERVICES":  164566753,
		"GLOBAL_EXTERNAL_MANAGED_FORWARDING_RULES":  327611949,
		"GLOBAL_EXTERNAL_PROXY_LB_BACKEND_SERVICES": 400256169,
		"GLOBAL_INTERNAL_ADDRESSES":                 42738332,
		"GLOBAL_INTERNAL_MANAGED_BACKEND_SERVICES":  256608303,
		"GLOBAL_INTERNAL_TRAFFIC_DIRECTOR_BACKEND_SERVICES": 323514196,
		"GPUS_ALL_REGIONS":                           39387177,
		"HEALTH_CHECKS":                              289347502,
		"IMAGES":                                     15562360,
		"INSTANCES":                                  131337822,
		"INSTANCE_GROUPS":                            355919038,
		"INSTANCE_GROUP_MANAGERS":                    101798192,
		"INSTANCE_TEMPLATES":                         226188271,
		"INTERCONNECTS":                              415204741,
		"INTERCONNECT_ATTACHMENTS_PER_REGION":        159968086,
		"INTERCONNECT_ATTACHMENTS_TOTAL_MBPS":        425090419,
		"INTERCONNECT_TOTAL_GBPS":                    285341866,
		"INTERNAL_ADDRESSES":                         197899392,
		"INTERNAL_TRAFFIC_DIRECTOR_FORWARDING_RULES": 266433668,
		"IN_PLACE_SNAPSHOTS":                         151359133,
		"IN_USE_ADDRESSES":                           402125072,
		"IN_USE_BACKUP_SCHEDULES":                    32786705,
		"IN_USE_SNAPSHOT_SCHEDULES":                  462104083,
		"LOCAL_SSD_TOTAL_GB":                         330878021,
		"M1_CPUS":                                    37203366,
		"M2_CPUS":                                    65832517,
		"M3_CPUS":                                    94461668,
		"MACHINE_IMAGES":                             446986640,
		"N2A_CPUS":                                   265855917,
		"N2D_CPUS":                                   351743370,
		"N2_CPUS":                                    416465286,
		"NETWORKS":                                   485481477,
		"NETWORK_ATTACHMENTS":                        149028575,
		"NETWORK_ENDPOINT_GROUPS":                    102144909,
		"NETWORK_FIREWALL_POLICIES":                  101117374,
		"NODE_GROUPS":                                24624817,
		"NODE_TEMPLATES":                             474896668,
		"NVIDIA_A100_80GB_GPUS":                      286389320,
		"NVIDIA_A100_GPUS":                           504872978,
		"NVIDIA_K80_GPUS":                            163886599,
		"NVIDIA_P100_GPUS":                           236601633,
		"NVIDIA_P100_VWS_GPUS":                       213970574,
		"NVIDIA_P4_GPUS":                             283841470,
		"NVIDIA_P4_VWS_GPUS":                         528296619,
		"NVIDIA_T4_GPUS":                             75759810,
		"NVIDIA_T4_VWS_GPUS":                         319813039,
		"NVIDIA_V100_GPUS":                           129293095,
		"PACKET_MIRRORINGS":                          15578407,
		"PD_EXTREME_TOTAL_PROVISIONED_IOPS":          69593965,
		"PREEMPTIBLE_CPUS":                           251184841,
		"PREEMPTIBLE_LOCAL_SSD_GB":                   260819336,
		"PREEMPTIBLE_NVIDIA_A100_80GB_GPUS":          151942410,
		"PREEMPTIBLE_NVIDIA_A100_GPUS":               68832784,
		"PREEMPTIBLE_NVIDIA_K80_GPUS":                374960201,
		"PREEMPTIBLE_NVIDIA_P100_GPUS":               337432351,
		"PREEMPTIBLE_NVIDIA_P100_VWS_GPUS":           313544076,
		"PREEMPTIBLE_NVIDIA_P4_GPUS":                 429197628,
		"PREEMPTIBLE_NVIDIA_P4_VWS_GPUS":             252981545,
		"PREEMPTIBLE_NVIDIA_T4_GPUS":                 221115968,
		"PREEMPTIBLE_NVIDIA_T4_VWS_GPUS":             44497965,
		"PREEMPTIBLE_NVIDIA_V100_GPUS":               230123813,
		"PSC_ILB_CONSUMER_FORWARDING_RULES_PER_PRODUCER_NETWORK": 231164291,
		"PSC_INTERNAL_LB_FORWARDING_RULES":                       169005435,
		"PUBLIC_ADVERTISED_PREFIXES":                             471371980,
		"PUBLIC_DELEGATED_PREFIXES":                              532465974,
		"REGIONAL_AUTOSCALERS":                                   29363772,
		"REGIONAL_EXTERNAL_MANAGED_BACKEND_SERVICES":             4240989,
		"REGIONAL_EXTERNAL_NETWORK_LB_BACKEND_SERVICES":          409564525,
		"REGIONAL_INSTANCE_GROUP_MANAGERS":                       37543696,
		"REGIONAL_INTERNAL_LB_BACKEND_SERVICES":                  137983760,
		"REGIONAL_INTERNAL_MANAGED_BACKEND_SERVICES":             96282539,
		"RESERVATIONS":                        32644647,
		"RESOURCE_POLICIES":                   83955297,
		"ROUTERS":                             493018666,
		"ROUTES":                              275680074,
		"SECURITY_POLICIES":                   189518703,
		"SECURITY_POLICIES_PER_REGION":        249041734,
		"SECURITY_POLICY_CEVAL_RULES":         470815689,
		"SECURITY_POLICY_RULES":               203549225,
		"SECURITY_POLICY_RULES_PER_REGION":    126510156,
		"SERVICE_ATTACHMENTS":                 471521510,
		"SNAPSHOTS":                           343405327,
		"SSD_TOTAL_GB":                        161732561,
		"SSL_CERTIFICATES":                    378372399,
		"STATIC_ADDRESSES":                    93624049,
		"STATIC_BYOIP_ADDRESSES":              275809649,
		"STATIC_EXTERNAL_IPV6_ADDRESS_RANGES": 472346774,
		"SUBNETWORKS":                         421330469,
		"T2A_CPUS":                            522170599,
		"T2D_CPUS":                            71187140,
		"TARGET_HTTPS_PROXIES":                219522506,
		"TARGET_HTTP_PROXIES":                 164117155,
		"TARGET_INSTANCES":                    284519728,
		"TARGET_POOLS":                        348261257,
		"TARGET_SSL_PROXIES":                  159216235,
		"TARGET_TCP_PROXIES":                  182243136,
		"TARGET_VPN_GATEWAYS":                 75029928,
		"URL_MAPS":                            378660743,
		"VPN_GATEWAYS":                        35620282,
		"VPN_TUNNELS":                         104327296,
		"XPN_SERVICE_PROJECTS":                95191981,
	}
)

func (x Quota_Metric) Enum() *Quota_Metric {
	p := new(Quota_Metric)
	*p = x
	return p
}

func (x Quota_Metric) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Quota_Metric) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[167].Descriptor()
}

func (Quota_Metric) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[167]
}

func (x Quota_Metric) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Quota_Metric.Descriptor instead.
func (Quota_Metric) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{909, 0}
}

// The format used to encode and transmit the block device, which should be TAR. This is just a container and transmission format and not a runtime format. Provided by the client when the disk image is created.
type RawDisk_ContainerType int32

const (
	// A value indicating that the enum field is not set.
	RawDisk_UNDEFINED_CONTAINER_TYPE RawDisk_ContainerType = 0
	RawDisk_TAR                      RawDisk_ContainerType = 82821
)

// Enum value maps for RawDisk_ContainerType.
var (
	RawDisk_ContainerType_name = map[int32]string{
		0:     "UNDEFINED_CONTAINER_TYPE",
		82821: "TAR",
	}
	RawDisk_ContainerType_value = map[string]int32{
		"UNDEFINED_CONTAINER_TYPE": 0,
		"TAR":                      82821,
	}
)

func (x RawDisk_ContainerType) Enum() *RawDisk_ContainerType {
	p := new(RawDisk_ContainerType)
	*p = x
	return p
}

func (x RawDisk_ContainerType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RawDisk_ContainerType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[168].Descriptor()
}

func (RawDisk_ContainerType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[168]
}

func (x RawDisk_ContainerType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RawDisk_ContainerType.Descriptor instead.
func (RawDisk_ContainerType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{911, 0}
}

// [Output Only] Status of the region, either UP or DOWN.
type Region_Status int32

const (
	// A value indicating that the enum field is not set.
	Region_UNDEFINED_STATUS Region_Status = 0
	Region_DOWN             Region_Status = 2104482
	Region_UP               Region_Status = 2715
)

// Enum value maps for Region_Status.
var (
	Region_Status_name = map[int32]string{
		0:       "UNDEFINED_STATUS",
		2104482: "DOWN",
		2715:    "UP",
	}
	Region_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"DOWN":             2104482,
		"UP":               2715,
	}
)

func (x Region_Status) Enum() *Region_Status {
	p := new(Region_Status)
	*p = x
	return p
}

func (x Region_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Region_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[169].Descriptor()
}

func (Region_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[169]
}

func (x Region_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Region_Status.Descriptor instead.
func (Region_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{915, 0}
}

// The minimal action that you want to perform on each instance during the update: - REPLACE: At minimum, delete the instance and create it again. - RESTART: Stop the instance and start it again. - REFRESH: Do not stop the instance. - NONE: Do not disrupt the instance at all. By default, the minimum action is NONE. If your update requires a more disruptive action than you set with this flag, the necessary action is performed to execute the update.
// Additional supported values which may be not listed in the enum directly due to technical reasons:
// NONE
// REFRESH
// REPLACE
// RESTART
type RegionInstanceGroupManagersApplyUpdatesRequest_MinimalAction int32

const (
	// A value indicating that the enum field is not set.
	RegionInstanceGroupManagersApplyUpdatesRequest_UNDEFINED_MINIMAL_ACTION RegionInstanceGroupManagersApplyUpdatesRequest_MinimalAction = 0
)

// Enum value maps for RegionInstanceGroupManagersApplyUpdatesRequest_MinimalAction.
var (
	RegionInstanceGroupManagersApplyUpdatesRequest_MinimalAction_name = map[int32]string{
		0: "UNDEFINED_MINIMAL_ACTION",
	}
	RegionInstanceGroupManagersApplyUpdatesRequest_MinimalAction_value = map[string]int32{
		"UNDEFINED_MINIMAL_ACTION": 0,
	}
)

func (x RegionInstanceGroupManagersApplyUpdatesRequest_MinimalAction) Enum() *RegionInstanceGroupManagersApplyUpdatesRequest_MinimalAction {
	p := new(RegionInstanceGroupManagersApplyUpdatesRequest_MinimalAction)
	*p = x
	return p
}

func (x RegionInstanceGroupManagersApplyUpdatesRequest_MinimalAction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RegionInstanceGroupManagersApplyUpdatesRequest_MinimalAction) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[170].Descriptor()
}

func (RegionInstanceGroupManagersApplyUpdatesRequest_MinimalAction) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[170]
}

func (x RegionInstanceGroupManagersApplyUpdatesRequest_MinimalAction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RegionInstanceGroupManagersApplyUpdatesRequest_MinimalAction.Descriptor instead.
func (RegionInstanceGroupManagersApplyUpdatesRequest_MinimalAction) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{927, 0}
}

// The most disruptive action that you want to perform on each instance during the update: - REPLACE: Delete the instance and create it again. - RESTART: Stop the instance and start it again. - REFRESH: Do not stop the instance. - NONE: Do not disrupt the instance at all. By default, the most disruptive allowed action is REPLACE. If your update requires a more disruptive action than you set with this flag, the update request will fail.
// Additional supported values which may be not listed in the enum directly due to technical reasons:
// NONE
// REFRESH
// REPLACE
// RESTART
type RegionInstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction int32

const (
	// A value indicating that the enum field is not set.
	RegionInstanceGroupManagersApplyUpdatesRequest_UNDEFINED_MOST_DISRUPTIVE_ALLOWED_ACTION RegionInstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction = 0
)

// Enum value maps for RegionInstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction.
var (
	RegionInstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction_name = map[int32]string{
		0: "UNDEFINED_MOST_DISRUPTIVE_ALLOWED_ACTION",
	}
	RegionInstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction_value = map[string]int32{
		"UNDEFINED_MOST_DISRUPTIVE_ALLOWED_ACTION": 0,
	}
)

func (x RegionInstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction) Enum() *RegionInstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction {
	p := new(RegionInstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction)
	*p = x
	return p
}

func (x RegionInstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RegionInstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[171].Descriptor()
}

func (RegionInstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[171]
}

func (x RegionInstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RegionInstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction.Descriptor instead.
func (RegionInstanceGroupManagersApplyUpdatesRequest_MostDisruptiveAllowedAction) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{927, 1}
}

// Instances in which state should be returned. Valid options are: 'ALL', 'RUNNING'. By default, it lists all instances.
type RegionInstanceGroupsListInstancesRequest_InstanceState int32

const (
	// A value indicating that the enum field is not set.
	RegionInstanceGroupsListInstancesRequest_UNDEFINED_INSTANCE_STATE RegionInstanceGroupsListInstancesRequest_InstanceState = 0
	// Matches any status of the instances, running, non-running and others.
	RegionInstanceGroupsListInstancesRequest_ALL RegionInstanceGroupsListInstancesRequest_InstanceState = 64897
	// Instance is in RUNNING state if it is running.
	RegionInstanceGroupsListInstancesRequest_RUNNING RegionInstanceGroupsListInstancesRequest_InstanceState = 121282975
)

// Enum value maps for RegionInstanceGroupsListInstancesRequest_InstanceState.
var (
	RegionInstanceGroupsListInstancesRequest_InstanceState_name = map[int32]string{
		0:         "UNDEFINED_INSTANCE_STATE",
		64897:     "ALL",
		121282975: "RUNNING",
	}
	RegionInstanceGroupsListInstancesRequest_InstanceState_value = map[string]int32{
		"UNDEFINED_INSTANCE_STATE": 0,
		"ALL":                      64897,
		"RUNNING":                  121282975,
	}
)

func (x RegionInstanceGroupsListInstancesRequest_InstanceState) Enum() *RegionInstanceGroupsListInstancesRequest_InstanceState {
	p := new(RegionInstanceGroupsListInstancesRequest_InstanceState)
	*p = x
	return p
}

func (x RegionInstanceGroupsListInstancesRequest_InstanceState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RegionInstanceGroupsListInstancesRequest_InstanceState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[172].Descriptor()
}

func (RegionInstanceGroupsListInstancesRequest_InstanceState) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[172]
}

func (x RegionInstanceGroupsListInstancesRequest_InstanceState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RegionInstanceGroupsListInstancesRequest_InstanceState.Descriptor instead.
func (RegionInstanceGroupsListInstancesRequest_InstanceState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{937, 0}
}

// [Output Only] The type of the firewall policy. Can be one of HIERARCHY, NETWORK, NETWORK_REGIONAL.
type RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type int32

const (
	// A value indicating that the enum field is not set.
	RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_UNDEFINED_TYPE   RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type = 0
	RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_HIERARCHY        RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type = 69902869
	RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_NETWORK          RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type = 413984270
	RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_NETWORK_REGIONAL RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type = 190804272
	RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_UNSPECIFIED      RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type = 526786327
)

// Enum value maps for RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type.
var (
	RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type_name = map[int32]string{
		0:         "UNDEFINED_TYPE",
		69902869:  "HIERARCHY",
		413984270: "NETWORK",
		190804272: "NETWORK_REGIONAL",
		526786327: "UNSPECIFIED",
	}
	RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type_value = map[string]int32{
		"UNDEFINED_TYPE":   0,
		"HIERARCHY":        69902869,
		"NETWORK":          413984270,
		"NETWORK_REGIONAL": 190804272,
		"UNSPECIFIED":      526786327,
	}
)

func (x RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type) Enum() *RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type {
	p := new(RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type)
	*p = x
	return p
}

func (x RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[173].Descriptor()
}

func (RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[173]
}

func (x RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type.Descriptor instead.
func (RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{941, 0}
}

// [Output Only] The status of the reservation.
type Reservation_Status int32

const (
	// A value indicating that the enum field is not set.
	Reservation_UNDEFINED_STATUS Reservation_Status = 0
	// Resources are being allocated for the reservation.
	Reservation_CREATING Reservation_Status = 455564985
	// Reservation is currently being deleted.
	Reservation_DELETING Reservation_Status = 528602024
	Reservation_INVALID  Reservation_Status = 530283991
	// Reservation has allocated all its resources.
	Reservation_READY Reservation_Status = 77848963
	// Reservation is currently being resized.
	Reservation_UPDATING Reservation_Status = 494614342
)

// Enum value maps for Reservation_Status.
var (
	Reservation_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		455564985: "CREATING",
		528602024: "DELETING",
		530283991: "INVALID",
		77848963:  "READY",
		494614342: "UPDATING",
	}
	Reservation_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"CREATING":         455564985,
		"DELETING":         528602024,
		"INVALID":          530283991,
		"READY":            77848963,
		"UPDATING":         494614342,
	}
)

func (x Reservation_Status) Enum() *Reservation_Status {
	p := new(Reservation_Status)
	*p = x
	return p
}

func (x Reservation_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Reservation_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[174].Descriptor()
}

func (Reservation_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[174]
}

func (x Reservation_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Reservation_Status.Descriptor instead.
func (Reservation_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{961, 0}
}

// Specifies the type of reservation from which this instance can consume resources: ANY_RESERVATION (default), SPECIFIC_RESERVATION, or NO_RESERVATION. See Consuming reserved instances for examples.
type ReservationAffinity_ConsumeReservationType int32

const (
	// A value indicating that the enum field is not set.
	ReservationAffinity_UNDEFINED_CONSUME_RESERVATION_TYPE ReservationAffinity_ConsumeReservationType = 0
	// Consume any allocation available.
	ReservationAffinity_ANY_RESERVATION ReservationAffinity_ConsumeReservationType = 200008121
	// Do not consume from any allocated capacity.
	ReservationAffinity_NO_RESERVATION ReservationAffinity_ConsumeReservationType = 169322030
	// Must consume from a specific reservation. Must specify key value fields for specifying the reservations.
	ReservationAffinity_SPECIFIC_RESERVATION ReservationAffinity_ConsumeReservationType = 229889055
	ReservationAffinity_UNSPECIFIED          ReservationAffinity_ConsumeReservationType = 526786327
)

// Enum value maps for ReservationAffinity_ConsumeReservationType.
var (
	ReservationAffinity_ConsumeReservationType_name = map[int32]string{
		0:         "UNDEFINED_CONSUME_RESERVATION_TYPE",
		200008121: "ANY_RESERVATION",
		169322030: "NO_RESERVATION",
		229889055: "SPECIFIC_RESERVATION",
		526786327: "UNSPECIFIED",
	}
	ReservationAffinity_ConsumeReservationType_value = map[string]int32{
		"UNDEFINED_CONSUME_RESERVATION_TYPE": 0,
		"ANY_RESERVATION":                    200008121,
		"NO_RESERVATION":                     169322030,
		"SPECIFIC_RESERVATION":               229889055,
		"UNSPECIFIED":                        526786327,
	}
)

func (x ReservationAffinity_ConsumeReservationType) Enum() *ReservationAffinity_ConsumeReservationType {
	p := new(ReservationAffinity_ConsumeReservationType)
	*p = x
	return p
}

func (x ReservationAffinity_ConsumeReservationType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ReservationAffinity_ConsumeReservationType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[175].Descriptor()
}

func (ReservationAffinity_ConsumeReservationType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[175]
}

func (x ReservationAffinity_ConsumeReservationType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ReservationAffinity_ConsumeReservationType.Descriptor instead.
func (ReservationAffinity_ConsumeReservationType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{962, 0}
}

// Type of resource for which this commitment applies. Possible values are VCPU, MEMORY, LOCAL_SSD, and ACCELERATOR.
type ResourceCommitment_Type int32

const (
	// A value indicating that the enum field is not set.
	ResourceCommitment_UNDEFINED_TYPE ResourceCommitment_Type = 0
	ResourceCommitment_ACCELERATOR    ResourceCommitment_Type = 429815371
	ResourceCommitment_LOCAL_SSD      ResourceCommitment_Type = 508934896
	ResourceCommitment_MEMORY         ResourceCommitment_Type = 123056385
	ResourceCommitment_UNSPECIFIED    ResourceCommitment_Type = 526786327
	ResourceCommitment_VCPU           ResourceCommitment_Type = 2628978
)

// Enum value maps for ResourceCommitment_Type.
var (
	ResourceCommitment_Type_name = map[int32]string{
		0:         "UNDEFINED_TYPE",
		429815371: "ACCELERATOR",
		508934896: "LOCAL_SSD",
		123056385: "MEMORY",
		526786327: "UNSPECIFIED",
		2628978:   "VCPU",
	}
	ResourceCommitment_Type_value = map[string]int32{
		"UNDEFINED_TYPE": 0,
		"ACCELERATOR":    429815371,
		"LOCAL_SSD":      508934896,
		"MEMORY":         123056385,
		"UNSPECIFIED":    526786327,
		"VCPU":           2628978,
	}
)

func (x ResourceCommitment_Type) Enum() *ResourceCommitment_Type {
	p := new(ResourceCommitment_Type)
	*p = x
	return p
}

func (x ResourceCommitment_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ResourceCommitment_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[176].Descriptor()
}

func (ResourceCommitment_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[176]
}

func (x ResourceCommitment_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ResourceCommitment_Type.Descriptor instead.
func (ResourceCommitment_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{973, 0}
}

// [Output Only] The status of resource policy creation.
type ResourcePolicy_Status int32

const (
	// A value indicating that the enum field is not set.
	ResourcePolicy_UNDEFINED_STATUS ResourcePolicy_Status = 0
	// Resource policy is being created.
	ResourcePolicy_CREATING ResourcePolicy_Status = 455564985
	// Resource policy is being deleted.
	ResourcePolicy_DELETING ResourcePolicy_Status = 528602024
	// Resource policy is expired and will not run again.
	ResourcePolicy_EXPIRED ResourcePolicy_Status = 482489093
	ResourcePolicy_INVALID ResourcePolicy_Status = 530283991
	// Resource policy is ready to be used.
	ResourcePolicy_READY ResourcePolicy_Status = 77848963
)

// Enum value maps for ResourcePolicy_Status.
var (
	ResourcePolicy_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		455564985: "CREATING",
		528602024: "DELETING",
		482489093: "EXPIRED",
		530283991: "INVALID",
		77848963:  "READY",
	}
	ResourcePolicy_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"CREATING":         455564985,
		"DELETING":         528602024,
		"EXPIRED":          482489093,
		"INVALID":          530283991,
		"READY":            77848963,
	}
)

func (x ResourcePolicy_Status) Enum() *ResourcePolicy_Status {
	p := new(ResourcePolicy_Status)
	*p = x
	return p
}

func (x ResourcePolicy_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ResourcePolicy_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[177].Descriptor()
}

func (ResourcePolicy_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[177]
}

func (x ResourcePolicy_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ResourcePolicy_Status.Descriptor instead.
func (ResourcePolicy_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{976, 0}
}

// Specifies network collocation
type ResourcePolicyGroupPlacementPolicy_Collocation int32

const (
	// A value indicating that the enum field is not set.
	ResourcePolicyGroupPlacementPolicy_UNDEFINED_COLLOCATION   ResourcePolicyGroupPlacementPolicy_Collocation = 0
	ResourcePolicyGroupPlacementPolicy_COLLOCATED              ResourcePolicyGroupPlacementPolicy_Collocation = 103257554
	ResourcePolicyGroupPlacementPolicy_UNSPECIFIED_COLLOCATION ResourcePolicyGroupPlacementPolicy_Collocation = 464308205
)

// Enum value maps for ResourcePolicyGroupPlacementPolicy_Collocation.
var (
	ResourcePolicyGroupPlacementPolicy_Collocation_name = map[int32]string{
		0:         "UNDEFINED_COLLOCATION",
		103257554: "COLLOCATED",
		464308205: "UNSPECIFIED_COLLOCATION",
	}
	ResourcePolicyGroupPlacementPolicy_Collocation_value = map[string]int32{
		"UNDEFINED_COLLOCATION":   0,
		"COLLOCATED":              103257554,
		"UNSPECIFIED_COLLOCATION": 464308205,
	}
)

func (x ResourcePolicyGroupPlacementPolicy_Collocation) Enum() *ResourcePolicyGroupPlacementPolicy_Collocation {
	p := new(ResourcePolicyGroupPlacementPolicy_Collocation)
	*p = x
	return p
}

func (x ResourcePolicyGroupPlacementPolicy_Collocation) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ResourcePolicyGroupPlacementPolicy_Collocation) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[178].Descriptor()
}

func (ResourcePolicyGroupPlacementPolicy_Collocation) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[178]
}

func (x ResourcePolicyGroupPlacementPolicy_Collocation) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ResourcePolicyGroupPlacementPolicy_Collocation.Descriptor instead.
func (ResourcePolicyGroupPlacementPolicy_Collocation) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{979, 0}
}

// Specifies the behavior to apply to scheduled snapshots when the source disk is deleted.
type ResourcePolicySnapshotSchedulePolicyRetentionPolicy_OnSourceDiskDelete int32

const (
	// A value indicating that the enum field is not set.
	ResourcePolicySnapshotSchedulePolicyRetentionPolicy_UNDEFINED_ON_SOURCE_DISK_DELETE   ResourcePolicySnapshotSchedulePolicyRetentionPolicy_OnSourceDiskDelete = 0
	ResourcePolicySnapshotSchedulePolicyRetentionPolicy_APPLY_RETENTION_POLICY            ResourcePolicySnapshotSchedulePolicyRetentionPolicy_OnSourceDiskDelete = 535071332
	ResourcePolicySnapshotSchedulePolicyRetentionPolicy_KEEP_AUTO_SNAPSHOTS               ResourcePolicySnapshotSchedulePolicyRetentionPolicy_OnSourceDiskDelete = 258925689
	ResourcePolicySnapshotSchedulePolicyRetentionPolicy_UNSPECIFIED_ON_SOURCE_DISK_DELETE ResourcePolicySnapshotSchedulePolicyRetentionPolicy_OnSourceDiskDelete = 239140769
)

// Enum value maps for ResourcePolicySnapshotSchedulePolicyRetentionPolicy_OnSourceDiskDelete.
var (
	ResourcePolicySnapshotSchedulePolicyRetentionPolicy_OnSourceDiskDelete_name = map[int32]string{
		0:         "UNDEFINED_ON_SOURCE_DISK_DELETE",
		535071332: "APPLY_RETENTION_POLICY",
		258925689: "KEEP_AUTO_SNAPSHOTS",
		239140769: "UNSPECIFIED_ON_SOURCE_DISK_DELETE",
	}
	ResourcePolicySnapshotSchedulePolicyRetentionPolicy_OnSourceDiskDelete_value = map[string]int32{
		"UNDEFINED_ON_SOURCE_DISK_DELETE":   0,
		"APPLY_RETENTION_POLICY":            535071332,
		"KEEP_AUTO_SNAPSHOTS":               258925689,
		"UNSPECIFIED_ON_SOURCE_DISK_DELETE": 239140769,
	}
)

func (x ResourcePolicySnapshotSchedulePolicyRetentionPolicy_OnSourceDiskDelete) Enum() *ResourcePolicySnapshotSchedulePolicyRetentionPolicy_OnSourceDiskDelete {
	p := new(ResourcePolicySnapshotSchedulePolicyRetentionPolicy_OnSourceDiskDelete)
	*p = x
	return p
}

func (x ResourcePolicySnapshotSchedulePolicyRetentionPolicy_OnSourceDiskDelete) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ResourcePolicySnapshotSchedulePolicyRetentionPolicy_OnSourceDiskDelete) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[179].Descriptor()
}

func (ResourcePolicySnapshotSchedulePolicyRetentionPolicy_OnSourceDiskDelete) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[179]
}

func (x ResourcePolicySnapshotSchedulePolicyRetentionPolicy_OnSourceDiskDelete) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ResourcePolicySnapshotSchedulePolicyRetentionPolicy_OnSourceDiskDelete.Descriptor instead.
func (ResourcePolicySnapshotSchedulePolicyRetentionPolicy_OnSourceDiskDelete) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{987, 0}
}

// Defines a schedule that runs on specific days of the week. Specify one or more days. The following options are available: MONDAY, TUESDAY, WEDNESDAY, THURSDAY, FRIDAY, SATURDAY, SUNDAY.
type ResourcePolicyWeeklyCycleDayOfWeek_Day int32

const (
	// A value indicating that the enum field is not set.
	ResourcePolicyWeeklyCycleDayOfWeek_UNDEFINED_DAY ResourcePolicyWeeklyCycleDayOfWeek_Day = 0
	ResourcePolicyWeeklyCycleDayOfWeek_FRIDAY        ResourcePolicyWeeklyCycleDayOfWeek_Day = 471398751
	ResourcePolicyWeeklyCycleDayOfWeek_INVALID       ResourcePolicyWeeklyCycleDayOfWeek_Day = 530283991
	ResourcePolicyWeeklyCycleDayOfWeek_MONDAY        ResourcePolicyWeeklyCycleDayOfWeek_Day = 132310288
	ResourcePolicyWeeklyCycleDayOfWeek_SATURDAY      ResourcePolicyWeeklyCycleDayOfWeek_Day = 279037881
	ResourcePolicyWeeklyCycleDayOfWeek_SUNDAY        ResourcePolicyWeeklyCycleDayOfWeek_Day = 309626320
	ResourcePolicyWeeklyCycleDayOfWeek_THURSDAY      ResourcePolicyWeeklyCycleDayOfWeek_Day = 207198682
	ResourcePolicyWeeklyCycleDayOfWeek_TUESDAY       ResourcePolicyWeeklyCycleDayOfWeek_Day = 277509677
	ResourcePolicyWeeklyCycleDayOfWeek_WEDNESDAY     ResourcePolicyWeeklyCycleDayOfWeek_Day = 422029110
)

// Enum value maps for ResourcePolicyWeeklyCycleDayOfWeek_Day.
var (
	ResourcePolicyWeeklyCycleDayOfWeek_Day_name = map[int32]string{
		0:         "UNDEFINED_DAY",
		471398751: "FRIDAY",
		530283991: "INVALID",
		132310288: "MONDAY",
		279037881: "SATURDAY",
		309626320: "SUNDAY",
		207198682: "THURSDAY",
		277509677: "TUESDAY",
		422029110: "WEDNESDAY",
	}
	ResourcePolicyWeeklyCycleDayOfWeek_Day_value = map[string]int32{
		"UNDEFINED_DAY": 0,
		"FRIDAY":        471398751,
		"INVALID":       530283991,
		"MONDAY":        132310288,
		"SATURDAY":      279037881,
		"SUNDAY":        309626320,
		"THURSDAY":      207198682,
		"TUESDAY":       277509677,
		"WEDNESDAY":     422029110,
	}
)

func (x ResourcePolicyWeeklyCycleDayOfWeek_Day) Enum() *ResourcePolicyWeeklyCycleDayOfWeek_Day {
	p := new(ResourcePolicyWeeklyCycleDayOfWeek_Day)
	*p = x
	return p
}

func (x ResourcePolicyWeeklyCycleDayOfWeek_Day) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ResourcePolicyWeeklyCycleDayOfWeek_Day) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[180].Descriptor()
}

func (ResourcePolicyWeeklyCycleDayOfWeek_Day) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[180]
}

func (x ResourcePolicyWeeklyCycleDayOfWeek_Day) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ResourcePolicyWeeklyCycleDayOfWeek_Day.Descriptor instead.
func (ResourcePolicyWeeklyCycleDayOfWeek_Day) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{991, 0}
}

// [Output only] The status of the route.
type Route_RouteStatus int32

const (
	// A value indicating that the enum field is not set.
	Route_UNDEFINED_ROUTE_STATUS Route_RouteStatus = 0
	// This route is processed and active.
	Route_ACTIVE Route_RouteStatus = 314733318
	// The route is dropped due to the VPC exceeding the dynamic route limit. For dynamic route limit, please refer to the Learned route example
	Route_DROPPED Route_RouteStatus = 496235424
	// This route is processed but inactive due to failure from the backend. The backend may have rejected the route
	Route_INACTIVE Route_RouteStatus = 270421099
	// This route is being processed internally. The status will change once processed.
	Route_PENDING Route_RouteStatus = 35394935
)

// Enum value maps for Route_RouteStatus.
var (
	Route_RouteStatus_name = map[int32]string{
		0:         "UNDEFINED_ROUTE_STATUS",
		314733318: "ACTIVE",
		496235424: "DROPPED",
		270421099: "INACTIVE",
		35394935:  "PENDING",
	}
	Route_RouteStatus_value = map[string]int32{
		"UNDEFINED_ROUTE_STATUS": 0,
		"ACTIVE":                 314733318,
		"DROPPED":                496235424,
		"INACTIVE":               270421099,
		"PENDING":                35394935,
	}
)

func (x Route_RouteStatus) Enum() *Route_RouteStatus {
	p := new(Route_RouteStatus)
	*p = x
	return p
}

func (x Route_RouteStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Route_RouteStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[181].Descriptor()
}

func (Route_RouteStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[181]
}

func (x Route_RouteStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Route_RouteStatus.Descriptor instead.
func (Route_RouteStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{994, 0}
}

// [Output Only] The type of this route, which can be one of the following values: - 'TRANSIT' for a transit route that this router learned from another Cloud Router and will readvertise to one of its BGP peers - 'SUBNET' for a route from a subnet of the VPC - 'BGP' for a route learned from a BGP peer of this router - 'STATIC' for a static route
type Route_RouteType int32

const (
	// A value indicating that the enum field is not set.
	Route_UNDEFINED_ROUTE_TYPE Route_RouteType = 0
	Route_BGP                  Route_RouteType = 65707
	Route_STATIC               Route_RouteType = 308331118
	Route_SUBNET               Route_RouteType = 309278557
	Route_TRANSIT              Route_RouteType = 187793843
)

// Enum value maps for Route_RouteType.
var (
	Route_RouteType_name = map[int32]string{
		0:         "UNDEFINED_ROUTE_TYPE",
		65707:     "BGP",
		308331118: "STATIC",
		309278557: "SUBNET",
		187793843: "TRANSIT",
	}
	Route_RouteType_value = map[string]int32{
		"UNDEFINED_ROUTE_TYPE": 0,
		"BGP":                  65707,
		"STATIC":               308331118,
		"SUBNET":               309278557,
		"TRANSIT":              187793843,
	}
)

func (x Route_RouteType) Enum() *Route_RouteType {
	p := new(Route_RouteType)
	*p = x
	return p
}

func (x Route_RouteType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Route_RouteType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[182].Descriptor()
}

func (Route_RouteType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[182]
}

func (x Route_RouteType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Route_RouteType.Descriptor instead.
func (Route_RouteType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{994, 1}
}

// [Output Only] The type of the AS Path, which can be one of the following values: - 'AS_SET': unordered set of autonomous systems that the route in has traversed - 'AS_SEQUENCE': ordered set of autonomous systems that the route has traversed - 'AS_CONFED_SEQUENCE': ordered set of Member Autonomous Systems in the local confederation that the route has traversed - 'AS_CONFED_SET': unordered set of Member Autonomous Systems in the local confederation that the route has traversed
type RouteAsPath_PathSegmentType int32

const (
	// A value indicating that the enum field is not set.
	RouteAsPath_UNDEFINED_PATH_SEGMENT_TYPE RouteAsPath_PathSegmentType = 0
	RouteAsPath_AS_CONFED_SEQUENCE          RouteAsPath_PathSegmentType = 222152624
	RouteAsPath_AS_CONFED_SET               RouteAsPath_PathSegmentType = 374040307
	RouteAsPath_AS_SEQUENCE                 RouteAsPath_PathSegmentType = 106735918
	RouteAsPath_AS_SET                      RouteAsPath_PathSegmentType = 329846453
)

// Enum value maps for RouteAsPath_PathSegmentType.
var (
	RouteAsPath_PathSegmentType_name = map[int32]string{
		0:         "UNDEFINED_PATH_SEGMENT_TYPE",
		222152624: "AS_CONFED_SEQUENCE",
		374040307: "AS_CONFED_SET",
		106735918: "AS_SEQUENCE",
		329846453: "AS_SET",
	}
	RouteAsPath_PathSegmentType_value = map[string]int32{
		"UNDEFINED_PATH_SEGMENT_TYPE": 0,
		"AS_CONFED_SEQUENCE":          222152624,
		"AS_CONFED_SET":               374040307,
		"AS_SEQUENCE":                 106735918,
		"AS_SET":                      329846453,
	}
)

func (x RouteAsPath_PathSegmentType) Enum() *RouteAsPath_PathSegmentType {
	p := new(RouteAsPath_PathSegmentType)
	*p = x
	return p
}

func (x RouteAsPath_PathSegmentType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RouteAsPath_PathSegmentType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[183].Descriptor()
}

func (RouteAsPath_PathSegmentType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[183]
}

func (x RouteAsPath_PathSegmentType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RouteAsPath_PathSegmentType.Descriptor instead.
func (RouteAsPath_PathSegmentType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{995, 0}
}

// User-specified flag to indicate which mode to use for advertisement. The options are DEFAULT or CUSTOM.
type RouterBgp_AdvertiseMode int32

const (
	// A value indicating that the enum field is not set.
	RouterBgp_UNDEFINED_ADVERTISE_MODE RouterBgp_AdvertiseMode = 0
	RouterBgp_CUSTOM                   RouterBgp_AdvertiseMode = 388595569
	RouterBgp_DEFAULT                  RouterBgp_AdvertiseMode = 115302945
)

// Enum value maps for RouterBgp_AdvertiseMode.
var (
	RouterBgp_AdvertiseMode_name = map[int32]string{
		0:         "UNDEFINED_ADVERTISE_MODE",
		388595569: "CUSTOM",
		115302945: "DEFAULT",
	}
	RouterBgp_AdvertiseMode_value = map[string]int32{
		"UNDEFINED_ADVERTISE_MODE": 0,
		"CUSTOM":                   388595569,
		"DEFAULT":                  115302945,
	}
)

func (x RouterBgp_AdvertiseMode) Enum() *RouterBgp_AdvertiseMode {
	p := new(RouterBgp_AdvertiseMode)
	*p = x
	return p
}

func (x RouterBgp_AdvertiseMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RouterBgp_AdvertiseMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[184].Descriptor()
}

func (RouterBgp_AdvertiseMode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[184]
}

func (x RouterBgp_AdvertiseMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RouterBgp_AdvertiseMode.Descriptor instead.
func (RouterBgp_AdvertiseMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1000, 0}
}

type RouterBgp_AdvertisedGroups int32

const (
	// A value indicating that the enum field is not set.
	RouterBgp_UNDEFINED_ADVERTISED_GROUPS RouterBgp_AdvertisedGroups = 0
	// Advertise all available subnets (including peer VPC subnets).
	RouterBgp_ALL_SUBNETS RouterBgp_AdvertisedGroups = 3622872
)

// Enum value maps for RouterBgp_AdvertisedGroups.
var (
	RouterBgp_AdvertisedGroups_name = map[int32]string{
		0:       "UNDEFINED_ADVERTISED_GROUPS",
		3622872: "ALL_SUBNETS",
	}
	RouterBgp_AdvertisedGroups_value = map[string]int32{
		"UNDEFINED_ADVERTISED_GROUPS": 0,
		"ALL_SUBNETS":                 3622872,
	}
)

func (x RouterBgp_AdvertisedGroups) Enum() *RouterBgp_AdvertisedGroups {
	p := new(RouterBgp_AdvertisedGroups)
	*p = x
	return p
}

func (x RouterBgp_AdvertisedGroups) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RouterBgp_AdvertisedGroups) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[185].Descriptor()
}

func (RouterBgp_AdvertisedGroups) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[185]
}

func (x RouterBgp_AdvertisedGroups) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RouterBgp_AdvertisedGroups.Descriptor instead.
func (RouterBgp_AdvertisedGroups) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1000, 1}
}

// User-specified flag to indicate which mode to use for advertisement.
type RouterBgpPeer_AdvertiseMode int32

const (
	// A value indicating that the enum field is not set.
	RouterBgpPeer_UNDEFINED_ADVERTISE_MODE RouterBgpPeer_AdvertiseMode = 0
	RouterBgpPeer_CUSTOM                   RouterBgpPeer_AdvertiseMode = 388595569
	RouterBgpPeer_DEFAULT                  RouterBgpPeer_AdvertiseMode = 115302945
)

// Enum value maps for RouterBgpPeer_AdvertiseMode.
var (
	RouterBgpPeer_AdvertiseMode_name = map[int32]string{
		0:         "UNDEFINED_ADVERTISE_MODE",
		388595569: "CUSTOM",
		115302945: "DEFAULT",
	}
	RouterBgpPeer_AdvertiseMode_value = map[string]int32{
		"UNDEFINED_ADVERTISE_MODE": 0,
		"CUSTOM":                   388595569,
		"DEFAULT":                  115302945,
	}
)

func (x RouterBgpPeer_AdvertiseMode) Enum() *RouterBgpPeer_AdvertiseMode {
	p := new(RouterBgpPeer_AdvertiseMode)
	*p = x
	return p
}

func (x RouterBgpPeer_AdvertiseMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RouterBgpPeer_AdvertiseMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[186].Descriptor()
}

func (RouterBgpPeer_AdvertiseMode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[186]
}

func (x RouterBgpPeer_AdvertiseMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RouterBgpPeer_AdvertiseMode.Descriptor instead.
func (RouterBgpPeer_AdvertiseMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1001, 0}
}

type RouterBgpPeer_AdvertisedGroups int32

const (
	// A value indicating that the enum field is not set.
	RouterBgpPeer_UNDEFINED_ADVERTISED_GROUPS RouterBgpPeer_AdvertisedGroups = 0
	// Advertise all available subnets (including peer VPC subnets).
	RouterBgpPeer_ALL_SUBNETS RouterBgpPeer_AdvertisedGroups = 3622872
)

// Enum value maps for RouterBgpPeer_AdvertisedGroups.
var (
	RouterBgpPeer_AdvertisedGroups_name = map[int32]string{
		0:       "UNDEFINED_ADVERTISED_GROUPS",
		3622872: "ALL_SUBNETS",
	}
	RouterBgpPeer_AdvertisedGroups_value = map[string]int32{
		"UNDEFINED_ADVERTISED_GROUPS": 0,
		"ALL_SUBNETS":                 3622872,
	}
)

func (x RouterBgpPeer_AdvertisedGroups) Enum() *RouterBgpPeer_AdvertisedGroups {
	p := new(RouterBgpPeer_AdvertisedGroups)
	*p = x
	return p
}

func (x RouterBgpPeer_AdvertisedGroups) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RouterBgpPeer_AdvertisedGroups) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[187].Descriptor()
}

func (RouterBgpPeer_AdvertisedGroups) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[187]
}

func (x RouterBgpPeer_AdvertisedGroups) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RouterBgpPeer_AdvertisedGroups.Descriptor instead.
func (RouterBgpPeer_AdvertisedGroups) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1001, 1}
}

// The status of the BGP peer connection. If set to FALSE, any active session with the peer is terminated and all associated routing information is removed. If set to TRUE, the peer connection can be established with routing information. The default is TRUE.
type RouterBgpPeer_Enable int32

const (
	// A value indicating that the enum field is not set.
	RouterBgpPeer_UNDEFINED_ENABLE RouterBgpPeer_Enable = 0
	RouterBgpPeer_FALSE            RouterBgpPeer_Enable = 66658563
	RouterBgpPeer_TRUE             RouterBgpPeer_Enable = 2583950
)

// Enum value maps for RouterBgpPeer_Enable.
var (
	RouterBgpPeer_Enable_name = map[int32]string{
		0:        "UNDEFINED_ENABLE",
		66658563: "FALSE",
		2583950:  "TRUE",
	}
	RouterBgpPeer_Enable_value = map[string]int32{
		"UNDEFINED_ENABLE": 0,
		"FALSE":            66658563,
		"TRUE":             2583950,
	}
)

func (x RouterBgpPeer_Enable) Enum() *RouterBgpPeer_Enable {
	p := new(RouterBgpPeer_Enable)
	*p = x
	return p
}

func (x RouterBgpPeer_Enable) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RouterBgpPeer_Enable) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[188].Descriptor()
}

func (RouterBgpPeer_Enable) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[188]
}

func (x RouterBgpPeer_Enable) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RouterBgpPeer_Enable.Descriptor instead.
func (RouterBgpPeer_Enable) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1001, 2}
}

// [Output Only] The resource that configures and manages this BGP peer. - MANAGED_BY_USER is the default value and can be managed by you or other users - MANAGED_BY_ATTACHMENT is a BGP peer that is configured and managed by Cloud Interconnect, specifically by an InterconnectAttachment of type PARTNER. Google automatically creates, updates, and deletes this type of BGP peer when the PARTNER InterconnectAttachment is created, updated, or deleted.
type RouterBgpPeer_ManagementType int32

const (
	// A value indicating that the enum field is not set.
	RouterBgpPeer_UNDEFINED_MANAGEMENT_TYPE RouterBgpPeer_ManagementType = 0
	// The BGP peer is automatically created for PARTNER type InterconnectAttachment; Google will automatically create/delete this BGP peer when the PARTNER InterconnectAttachment is created/deleted, and Google will update the ipAddress and peerIpAddress when the PARTNER InterconnectAttachment is provisioned. This type of BGP peer cannot be created or deleted, but can be modified for all fields except for name, ipAddress and peerIpAddress.
	RouterBgpPeer_MANAGED_BY_ATTACHMENT RouterBgpPeer_ManagementType = 458926411
	// Default value, the BGP peer is manually created and managed by user.
	RouterBgpPeer_MANAGED_BY_USER RouterBgpPeer_ManagementType = 317294067
)

// Enum value maps for RouterBgpPeer_ManagementType.
var (
	RouterBgpPeer_ManagementType_name = map[int32]string{
		0:         "UNDEFINED_MANAGEMENT_TYPE",
		458926411: "MANAGED_BY_ATTACHMENT",
		317294067: "MANAGED_BY_USER",
	}
	RouterBgpPeer_ManagementType_value = map[string]int32{
		"UNDEFINED_MANAGEMENT_TYPE": 0,
		"MANAGED_BY_ATTACHMENT":     458926411,
		"MANAGED_BY_USER":           317294067,
	}
)

func (x RouterBgpPeer_ManagementType) Enum() *RouterBgpPeer_ManagementType {
	p := new(RouterBgpPeer_ManagementType)
	*p = x
	return p
}

func (x RouterBgpPeer_ManagementType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RouterBgpPeer_ManagementType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[189].Descriptor()
}

func (RouterBgpPeer_ManagementType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[189]
}

func (x RouterBgpPeer_ManagementType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RouterBgpPeer_ManagementType.Descriptor instead.
func (RouterBgpPeer_ManagementType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1001, 3}
}

// The BFD session initialization mode for this BGP peer. If set to ACTIVE, the Cloud Router will initiate the BFD session for this BGP peer. If set to PASSIVE, the Cloud Router will wait for the peer router to initiate the BFD session for this BGP peer. If set to DISABLED, BFD is disabled for this BGP peer. The default is DISABLED.
type RouterBgpPeerBfd_SessionInitializationMode int32

const (
	// A value indicating that the enum field is not set.
	RouterBgpPeerBfd_UNDEFINED_SESSION_INITIALIZATION_MODE RouterBgpPeerBfd_SessionInitializationMode = 0
	RouterBgpPeerBfd_ACTIVE                                RouterBgpPeerBfd_SessionInitializationMode = 314733318
	RouterBgpPeerBfd_DISABLED                              RouterBgpPeerBfd_SessionInitializationMode = 516696700
	RouterBgpPeerBfd_PASSIVE                               RouterBgpPeerBfd_SessionInitializationMode = 462813959
)

// Enum value maps for RouterBgpPeerBfd_SessionInitializationMode.
var (
	RouterBgpPeerBfd_SessionInitializationMode_name = map[int32]string{
		0:         "UNDEFINED_SESSION_INITIALIZATION_MODE",
		314733318: "ACTIVE",
		516696700: "DISABLED",
		462813959: "PASSIVE",
	}
	RouterBgpPeerBfd_SessionInitializationMode_value = map[string]int32{
		"UNDEFINED_SESSION_INITIALIZATION_MODE": 0,
		"ACTIVE":                                314733318,
		"DISABLED":                              516696700,
		"PASSIVE":                               462813959,
	}
)

func (x RouterBgpPeerBfd_SessionInitializationMode) Enum() *RouterBgpPeerBfd_SessionInitializationMode {
	p := new(RouterBgpPeerBfd_SessionInitializationMode)
	*p = x
	return p
}

func (x RouterBgpPeerBfd_SessionInitializationMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RouterBgpPeerBfd_SessionInitializationMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[190].Descriptor()
}

func (RouterBgpPeerBfd_SessionInitializationMode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[190]
}

func (x RouterBgpPeerBfd_SessionInitializationMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RouterBgpPeerBfd_SessionInitializationMode.Descriptor instead.
func (RouterBgpPeerBfd_SessionInitializationMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1002, 0}
}

// [Output Only] The resource that configures and manages this interface. - MANAGED_BY_USER is the default value and can be managed directly by users. - MANAGED_BY_ATTACHMENT is an interface that is configured and managed by Cloud Interconnect, specifically, by an InterconnectAttachment of type PARTNER. Google automatically creates, updates, and deletes this type of interface when the PARTNER InterconnectAttachment is created, updated, or deleted.
type RouterInterface_ManagementType int32

const (
	// A value indicating that the enum field is not set.
	RouterInterface_UNDEFINED_MANAGEMENT_TYPE RouterInterface_ManagementType = 0
	// The interface is automatically created for PARTNER type InterconnectAttachment, Google will automatically create/update/delete this interface when the PARTNER InterconnectAttachment is created/provisioned/deleted. This type of interface cannot be manually managed by user.
	RouterInterface_MANAGED_BY_ATTACHMENT RouterInterface_ManagementType = 458926411
	// Default value, the interface is manually created and managed by user.
	RouterInterface_MANAGED_BY_USER RouterInterface_ManagementType = 317294067
)

// Enum value maps for RouterInterface_ManagementType.
var (
	RouterInterface_ManagementType_name = map[int32]string{
		0:         "UNDEFINED_MANAGEMENT_TYPE",
		458926411: "MANAGED_BY_ATTACHMENT",
		317294067: "MANAGED_BY_USER",
	}
	RouterInterface_ManagementType_value = map[string]int32{
		"UNDEFINED_MANAGEMENT_TYPE": 0,
		"MANAGED_BY_ATTACHMENT":     458926411,
		"MANAGED_BY_USER":           317294067,
	}
)

func (x RouterInterface_ManagementType) Enum() *RouterInterface_ManagementType {
	p := new(RouterInterface_ManagementType)
	*p = x
	return p
}

func (x RouterInterface_ManagementType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RouterInterface_ManagementType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[191].Descriptor()
}

func (RouterInterface_ManagementType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[191]
}

func (x RouterInterface_ManagementType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RouterInterface_ManagementType.Descriptor instead.
func (RouterInterface_ManagementType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1003, 0}
}

type RouterNat_EndpointTypes int32

const (
	// A value indicating that the enum field is not set.
	RouterNat_UNDEFINED_ENDPOINT_TYPES RouterNat_EndpointTypes = 0
	// This is used for Secure Web Gateway endpoints.
	RouterNat_ENDPOINT_TYPE_SWG RouterNat_EndpointTypes = 159344456
	// This is the default.
	RouterNat_ENDPOINT_TYPE_VM RouterNat_EndpointTypes = 57095474
)

// Enum value maps for RouterNat_EndpointTypes.
var (
	RouterNat_EndpointTypes_name = map[int32]string{
		0:         "UNDEFINED_ENDPOINT_TYPES",
		159344456: "ENDPOINT_TYPE_SWG",
		57095474:  "ENDPOINT_TYPE_VM",
	}
	RouterNat_EndpointTypes_value = map[string]int32{
		"UNDEFINED_ENDPOINT_TYPES": 0,
		"ENDPOINT_TYPE_SWG":        159344456,
		"ENDPOINT_TYPE_VM":         57095474,
	}
)

func (x RouterNat_EndpointTypes) Enum() *RouterNat_EndpointTypes {
	p := new(RouterNat_EndpointTypes)
	*p = x
	return p
}

func (x RouterNat_EndpointTypes) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RouterNat_EndpointTypes) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[192].Descriptor()
}

func (RouterNat_EndpointTypes) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[192]
}

func (x RouterNat_EndpointTypes) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RouterNat_EndpointTypes.Descriptor instead.
func (RouterNat_EndpointTypes) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1006, 0}
}

// Specify the NatIpAllocateOption, which can take one of the following values: - MANUAL_ONLY: Uses only Nat IP addresses provided by customers. When there are not enough specified Nat IPs, the Nat service fails for new VMs. - AUTO_ONLY: Nat IPs are allocated by Google Cloud Platform; customers can't specify any Nat IPs. When choosing AUTO_ONLY, then nat_ip should be empty.
type RouterNat_NatIpAllocateOption int32

const (
	// A value indicating that the enum field is not set.
	RouterNat_UNDEFINED_NAT_IP_ALLOCATE_OPTION RouterNat_NatIpAllocateOption = 0
	// Nat IPs are allocated by GCP; customers can not specify any Nat IPs.
	RouterNat_AUTO_ONLY RouterNat_NatIpAllocateOption = 182333500
	// Only use Nat IPs provided by customers. When specified Nat IPs are not enough then the Nat service fails for new VMs.
	RouterNat_MANUAL_ONLY RouterNat_NatIpAllocateOption = 261251205
)

// Enum value maps for RouterNat_NatIpAllocateOption.
var (
	RouterNat_NatIpAllocateOption_name = map[int32]string{
		0:         "UNDEFINED_NAT_IP_ALLOCATE_OPTION",
		182333500: "AUTO_ONLY",
		261251205: "MANUAL_ONLY",
	}
	RouterNat_NatIpAllocateOption_value = map[string]int32{
		"UNDEFINED_NAT_IP_ALLOCATE_OPTION": 0,
		"AUTO_ONLY":                        182333500,
		"MANUAL_ONLY":                      261251205,
	}
)

func (x RouterNat_NatIpAllocateOption) Enum() *RouterNat_NatIpAllocateOption {
	p := new(RouterNat_NatIpAllocateOption)
	*p = x
	return p
}

func (x RouterNat_NatIpAllocateOption) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RouterNat_NatIpAllocateOption) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[193].Descriptor()
}

func (RouterNat_NatIpAllocateOption) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[193]
}

func (x RouterNat_NatIpAllocateOption) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RouterNat_NatIpAllocateOption.Descriptor instead.
func (RouterNat_NatIpAllocateOption) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1006, 1}
}

// Specify the Nat option, which can take one of the following values: - ALL_SUBNETWORKS_ALL_IP_RANGES: All of the IP ranges in every Subnetwork are allowed to Nat. - ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES: All of the primary IP ranges in every Subnetwork are allowed to Nat. - LIST_OF_SUBNETWORKS: A list of Subnetworks are allowed to Nat (specified in the field subnetwork below) The default is SUBNETWORK_IP_RANGE_TO_NAT_OPTION_UNSPECIFIED. Note that if this field contains ALL_SUBNETWORKS_ALL_IP_RANGES or ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES, then there should not be any other Router.Nat section in any Router for this network in this region.
type RouterNat_SourceSubnetworkIpRangesToNat int32

const (
	// A value indicating that the enum field is not set.
	RouterNat_UNDEFINED_SOURCE_SUBNETWORK_IP_RANGES_TO_NAT RouterNat_SourceSubnetworkIpRangesToNat = 0
	// All the IP ranges in every Subnetwork are allowed to Nat.
	RouterNat_ALL_SUBNETWORKS_ALL_IP_RANGES RouterNat_SourceSubnetworkIpRangesToNat = 179964376
	// All the primary IP ranges in every Subnetwork are allowed to Nat.
	RouterNat_ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES RouterNat_SourceSubnetworkIpRangesToNat = 185573819
	// A list of Subnetworks are allowed to Nat (specified in the field subnetwork below)
	RouterNat_LIST_OF_SUBNETWORKS RouterNat_SourceSubnetworkIpRangesToNat = 517542270
)

// Enum value maps for RouterNat_SourceSubnetworkIpRangesToNat.
var (
	RouterNat_SourceSubnetworkIpRangesToNat_name = map[int32]string{
		0:         "UNDEFINED_SOURCE_SUBNETWORK_IP_RANGES_TO_NAT",
		179964376: "ALL_SUBNETWORKS_ALL_IP_RANGES",
		185573819: "ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES",
		517542270: "LIST_OF_SUBNETWORKS",
	}
	RouterNat_SourceSubnetworkIpRangesToNat_value = map[string]int32{
		"UNDEFINED_SOURCE_SUBNETWORK_IP_RANGES_TO_NAT": 0,
		"ALL_SUBNETWORKS_ALL_IP_RANGES":                179964376,
		"ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES":        185573819,
		"LIST_OF_SUBNETWORKS":                          517542270,
	}
)

func (x RouterNat_SourceSubnetworkIpRangesToNat) Enum() *RouterNat_SourceSubnetworkIpRangesToNat {
	p := new(RouterNat_SourceSubnetworkIpRangesToNat)
	*p = x
	return p
}

func (x RouterNat_SourceSubnetworkIpRangesToNat) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RouterNat_SourceSubnetworkIpRangesToNat) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[194].Descriptor()
}

func (RouterNat_SourceSubnetworkIpRangesToNat) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[194]
}

func (x RouterNat_SourceSubnetworkIpRangesToNat) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RouterNat_SourceSubnetworkIpRangesToNat.Descriptor instead.
func (RouterNat_SourceSubnetworkIpRangesToNat) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1006, 2}
}

// Specify the desired filtering of logs on this NAT. If unspecified, logs are exported for all connections handled by this NAT. This option can take one of the following values: - ERRORS_ONLY: Export logs only for connection failures. - TRANSLATIONS_ONLY: Export logs only for successful connections. - ALL: Export logs for all connections, successful and unsuccessful.
type RouterNatLogConfig_Filter int32

const (
	// A value indicating that the enum field is not set.
	RouterNatLogConfig_UNDEFINED_FILTER RouterNatLogConfig_Filter = 0
	// Export logs for all (successful and unsuccessful) connections.
	RouterNatLogConfig_ALL RouterNatLogConfig_Filter = 64897
	// Export logs for connection failures only.
	RouterNatLogConfig_ERRORS_ONLY RouterNatLogConfig_Filter = 307484672
	// Export logs for successful connections only.
	RouterNatLogConfig_TRANSLATIONS_ONLY RouterNatLogConfig_Filter = 357212649
)

// Enum value maps for RouterNatLogConfig_Filter.
var (
	RouterNatLogConfig_Filter_name = map[int32]string{
		0:         "UNDEFINED_FILTER",
		64897:     "ALL",
		307484672: "ERRORS_ONLY",
		357212649: "TRANSLATIONS_ONLY",
	}
	RouterNatLogConfig_Filter_value = map[string]int32{
		"UNDEFINED_FILTER":  0,
		"ALL":               64897,
		"ERRORS_ONLY":       307484672,
		"TRANSLATIONS_ONLY": 357212649,
	}
)

func (x RouterNatLogConfig_Filter) Enum() *RouterNatLogConfig_Filter {
	p := new(RouterNatLogConfig_Filter)
	*p = x
	return p
}

func (x RouterNatLogConfig_Filter) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RouterNatLogConfig_Filter) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[195].Descriptor()
}

func (RouterNatLogConfig_Filter) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[195]
}

func (x RouterNatLogConfig_Filter) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RouterNatLogConfig_Filter.Descriptor instead.
func (RouterNatLogConfig_Filter) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1007, 0}
}

type RouterNatSubnetworkToNat_SourceIpRangesToNat int32

const (
	// A value indicating that the enum field is not set.
	RouterNatSubnetworkToNat_UNDEFINED_SOURCE_IP_RANGES_TO_NAT RouterNatSubnetworkToNat_SourceIpRangesToNat = 0
	// The primary and all the secondary ranges are allowed to Nat.
	RouterNatSubnetworkToNat_ALL_IP_RANGES RouterNatSubnetworkToNat_SourceIpRangesToNat = 35608496
	// A list of secondary ranges are allowed to Nat.
	RouterNatSubnetworkToNat_LIST_OF_SECONDARY_IP_RANGES RouterNatSubnetworkToNat_SourceIpRangesToNat = 192289308
	// The primary range is allowed to Nat.
	RouterNatSubnetworkToNat_PRIMARY_IP_RANGE RouterNatSubnetworkToNat_SourceIpRangesToNat = 297109954
)

// Enum value maps for RouterNatSubnetworkToNat_SourceIpRangesToNat.
var (
	RouterNatSubnetworkToNat_SourceIpRangesToNat_name = map[int32]string{
		0:         "UNDEFINED_SOURCE_IP_RANGES_TO_NAT",
		35608496:  "ALL_IP_RANGES",
		192289308: "LIST_OF_SECONDARY_IP_RANGES",
		297109954: "PRIMARY_IP_RANGE",
	}
	RouterNatSubnetworkToNat_SourceIpRangesToNat_value = map[string]int32{
		"UNDEFINED_SOURCE_IP_RANGES_TO_NAT": 0,
		"ALL_IP_RANGES":                     35608496,
		"LIST_OF_SECONDARY_IP_RANGES":       192289308,
		"PRIMARY_IP_RANGE":                  297109954,
	}
)

func (x RouterNatSubnetworkToNat_SourceIpRangesToNat) Enum() *RouterNatSubnetworkToNat_SourceIpRangesToNat {
	p := new(RouterNatSubnetworkToNat_SourceIpRangesToNat)
	*p = x
	return p
}

func (x RouterNatSubnetworkToNat_SourceIpRangesToNat) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RouterNatSubnetworkToNat_SourceIpRangesToNat) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[196].Descriptor()
}

func (RouterNatSubnetworkToNat_SourceIpRangesToNat) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[196]
}

func (x RouterNatSubnetworkToNat_SourceIpRangesToNat) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RouterNatSubnetworkToNat_SourceIpRangesToNat.Descriptor instead.
func (RouterNatSubnetworkToNat_SourceIpRangesToNat) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1010, 0}
}

// Status of the BGP peer: {UP, DOWN}
type RouterStatusBgpPeerStatus_Status int32

const (
	// A value indicating that the enum field is not set.
	RouterStatusBgpPeerStatus_UNDEFINED_STATUS RouterStatusBgpPeerStatus_Status = 0
	RouterStatusBgpPeerStatus_DOWN             RouterStatusBgpPeerStatus_Status = 2104482
	RouterStatusBgpPeerStatus_UNKNOWN          RouterStatusBgpPeerStatus_Status = 433141802
	RouterStatusBgpPeerStatus_UP               RouterStatusBgpPeerStatus_Status = 2715
)

// Enum value maps for RouterStatusBgpPeerStatus_Status.
var (
	RouterStatusBgpPeerStatus_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		2104482:   "DOWN",
		433141802: "UNKNOWN",
		2715:      "UP",
	}
	RouterStatusBgpPeerStatus_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"DOWN":             2104482,
		"UNKNOWN":          433141802,
		"UP":               2715,
	}
)

func (x RouterStatusBgpPeerStatus_Status) Enum() *RouterStatusBgpPeerStatus_Status {
	p := new(RouterStatusBgpPeerStatus_Status)
	*p = x
	return p
}

func (x RouterStatusBgpPeerStatus_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RouterStatusBgpPeerStatus_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[197].Descriptor()
}

func (RouterStatusBgpPeerStatus_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[197]
}

func (x RouterStatusBgpPeerStatus_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RouterStatusBgpPeerStatus_Status.Descriptor instead.
func (RouterStatusBgpPeerStatus_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1012, 0}
}

// Indicates why particular status was returned.
type RouterStatusBgpPeerStatus_StatusReason int32

const (
	// A value indicating that the enum field is not set.
	RouterStatusBgpPeerStatus_UNDEFINED_STATUS_REASON RouterStatusBgpPeerStatus_StatusReason = 0
	// Indicates internal problems with configuration of MD5 authentication. This particular reason can only be returned when md5AuthEnabled is true and status is DOWN.
	RouterStatusBgpPeerStatus_MD5_AUTH_INTERNAL_PROBLEM RouterStatusBgpPeerStatus_StatusReason = 140462259
	RouterStatusBgpPeerStatus_STATUS_REASON_UNSPECIFIED RouterStatusBgpPeerStatus_StatusReason = 394331913
)

// Enum value maps for RouterStatusBgpPeerStatus_StatusReason.
var (
	RouterStatusBgpPeerStatus_StatusReason_name = map[int32]string{
		0:         "UNDEFINED_STATUS_REASON",
		140462259: "MD5_AUTH_INTERNAL_PROBLEM",
		394331913: "STATUS_REASON_UNSPECIFIED",
	}
	RouterStatusBgpPeerStatus_StatusReason_value = map[string]int32{
		"UNDEFINED_STATUS_REASON":   0,
		"MD5_AUTH_INTERNAL_PROBLEM": 140462259,
		"STATUS_REASON_UNSPECIFIED": 394331913,
	}
)

func (x RouterStatusBgpPeerStatus_StatusReason) Enum() *RouterStatusBgpPeerStatus_StatusReason {
	p := new(RouterStatusBgpPeerStatus_StatusReason)
	*p = x
	return p
}

func (x RouterStatusBgpPeerStatus_StatusReason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RouterStatusBgpPeerStatus_StatusReason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[198].Descriptor()
}

func (RouterStatusBgpPeerStatus_StatusReason) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[198]
}

func (x RouterStatusBgpPeerStatus_StatusReason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RouterStatusBgpPeerStatus_StatusReason.Descriptor instead.
func (RouterStatusBgpPeerStatus_StatusReason) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1012, 1}
}

// This is deprecated and has no effect. Do not use.
type Rule_Action int32

const (
	// A value indicating that the enum field is not set.
	Rule_UNDEFINED_ACTION Rule_Action = 0
	// This is deprecated and has no effect. Do not use.
	Rule_ALLOW Rule_Action = 62368553
	// This is deprecated and has no effect. Do not use.
	Rule_ALLOW_WITH_LOG Rule_Action = 76034177
	// This is deprecated and has no effect. Do not use.
	Rule_DENY Rule_Action = 2094604
	// This is deprecated and has no effect. Do not use.
	Rule_DENY_WITH_LOG Rule_Action = 351433982
	// This is deprecated and has no effect. Do not use.
	Rule_LOG Rule_Action = 75556
	// This is deprecated and has no effect. Do not use.
	Rule_NO_ACTION Rule_Action = 260643444
)

// Enum value maps for Rule_Action.
var (
	Rule_Action_name = map[int32]string{
		0:         "UNDEFINED_ACTION",
		62368553:  "ALLOW",
		76034177:  "ALLOW_WITH_LOG",
		2094604:   "DENY",
		351433982: "DENY_WITH_LOG",
		75556:     "LOG",
		260643444: "NO_ACTION",
	}
	Rule_Action_value = map[string]int32{
		"UNDEFINED_ACTION": 0,
		"ALLOW":            62368553,
		"ALLOW_WITH_LOG":   76034177,
		"DENY":             2094604,
		"DENY_WITH_LOG":    351433982,
		"LOG":              75556,
		"NO_ACTION":        260643444,
	}
)

func (x Rule_Action) Enum() *Rule_Action {
	p := new(Rule_Action)
	*p = x
	return p
}

func (x Rule_Action) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Rule_Action) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[199].Descriptor()
}

func (Rule_Action) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[199]
}

func (x Rule_Action) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Rule_Action.Descriptor instead.
func (Rule_Action) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1018, 0}
}

// Specifies how a port is selected for health checking. Can be one of the following values: USE_FIXED_PORT: Specifies a port number explicitly using the port field in the health check. Supported by backend services for pass-through load balancers and backend services for proxy load balancers. Not supported by target pools. The health check supports all backends supported by the backend service provided the backend can be health checked. For example, GCE_VM_IP network endpoint groups, GCE_VM_IP_PORT network endpoint groups, and instance group backends. USE_NAMED_PORT: Not supported. USE_SERVING_PORT: Provides an indirect method of specifying the health check port by referring to the backend service. Only supported by backend services for proxy load balancers. Not supported by target pools. Not supported by backend services for pass-through load balancers. Supports all backends that can be health checked; for example, GCE_VM_IP_PORT network endpoint groups and instance group backends. For GCE_VM_IP_PORT network endpoint group backends, the health check uses the port number specified for each endpoint in the network endpoint group. For instance group backends, the health check uses the port number determined by looking up the backend service's named port in the instance group's list of named ports.
type SSLHealthCheck_PortSpecification int32

const (
	// A value indicating that the enum field is not set.
	SSLHealthCheck_UNDEFINED_PORT_SPECIFICATION SSLHealthCheck_PortSpecification = 0
	// The port number in the health check's port is used for health checking. Applies to network endpoint group and instance group backends.
	SSLHealthCheck_USE_FIXED_PORT SSLHealthCheck_PortSpecification = 190235748
	// Not supported.
	SSLHealthCheck_USE_NAMED_PORT SSLHealthCheck_PortSpecification = 349300671
	// For network endpoint group backends, the health check uses the port number specified on each endpoint in the network endpoint group. For instance group backends, the health check uses the port number specified for the backend service's named port defined in the instance group's named ports.
	SSLHealthCheck_USE_SERVING_PORT SSLHealthCheck_PortSpecification = 362637516
)

// Enum value maps for SSLHealthCheck_PortSpecification.
var (
	SSLHealthCheck_PortSpecification_name = map[int32]string{
		0:         "UNDEFINED_PORT_SPECIFICATION",
		190235748: "USE_FIXED_PORT",
		349300671: "USE_NAMED_PORT",
		362637516: "USE_SERVING_PORT",
	}
	SSLHealthCheck_PortSpecification_value = map[string]int32{
		"UNDEFINED_PORT_SPECIFICATION": 0,
		"USE_FIXED_PORT":               190235748,
		"USE_NAMED_PORT":               349300671,
		"USE_SERVING_PORT":             362637516,
	}
)

func (x SSLHealthCheck_PortSpecification) Enum() *SSLHealthCheck_PortSpecification {
	p := new(SSLHealthCheck_PortSpecification)
	*p = x
	return p
}

func (x SSLHealthCheck_PortSpecification) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SSLHealthCheck_PortSpecification) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[200].Descriptor()
}

func (SSLHealthCheck_PortSpecification) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[200]
}

func (x SSLHealthCheck_PortSpecification) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SSLHealthCheck_PortSpecification.Descriptor instead.
func (SSLHealthCheck_PortSpecification) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1019, 0}
}

// Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
type SSLHealthCheck_ProxyHeader int32

const (
	// A value indicating that the enum field is not set.
	SSLHealthCheck_UNDEFINED_PROXY_HEADER SSLHealthCheck_ProxyHeader = 0
	SSLHealthCheck_NONE                   SSLHealthCheck_ProxyHeader = 2402104
	SSLHealthCheck_PROXY_V1               SSLHealthCheck_ProxyHeader = 334352940
)

// Enum value maps for SSLHealthCheck_ProxyHeader.
var (
	SSLHealthCheck_ProxyHeader_name = map[int32]string{
		0:         "UNDEFINED_PROXY_HEADER",
		2402104:   "NONE",
		334352940: "PROXY_V1",
	}
	SSLHealthCheck_ProxyHeader_value = map[string]int32{
		"UNDEFINED_PROXY_HEADER": 0,
		"NONE":                   2402104,
		"PROXY_V1":               334352940,
	}
)

func (x SSLHealthCheck_ProxyHeader) Enum() *SSLHealthCheck_ProxyHeader {
	p := new(SSLHealthCheck_ProxyHeader)
	*p = x
	return p
}

func (x SSLHealthCheck_ProxyHeader) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SSLHealthCheck_ProxyHeader) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[201].Descriptor()
}

func (SSLHealthCheck_ProxyHeader) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[201]
}

func (x SSLHealthCheck_ProxyHeader) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SSLHealthCheck_ProxyHeader.Descriptor instead.
func (SSLHealthCheck_ProxyHeader) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1019, 1}
}

// Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME.
type SavedAttachedDisk_Interface int32

const (
	// A value indicating that the enum field is not set.
	SavedAttachedDisk_UNDEFINED_INTERFACE SavedAttachedDisk_Interface = 0
	SavedAttachedDisk_NVME                SavedAttachedDisk_Interface = 2408800
	SavedAttachedDisk_SCSI                SavedAttachedDisk_Interface = 2539686
)

// Enum value maps for SavedAttachedDisk_Interface.
var (
	SavedAttachedDisk_Interface_name = map[int32]string{
		0:       "UNDEFINED_INTERFACE",
		2408800: "NVME",
		2539686: "SCSI",
	}
	SavedAttachedDisk_Interface_value = map[string]int32{
		"UNDEFINED_INTERFACE": 0,
		"NVME":                2408800,
		"SCSI":                2539686,
	}
)

func (x SavedAttachedDisk_Interface) Enum() *SavedAttachedDisk_Interface {
	p := new(SavedAttachedDisk_Interface)
	*p = x
	return p
}

func (x SavedAttachedDisk_Interface) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SavedAttachedDisk_Interface) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[202].Descriptor()
}

func (SavedAttachedDisk_Interface) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[202]
}

func (x SavedAttachedDisk_Interface) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SavedAttachedDisk_Interface.Descriptor instead.
func (SavedAttachedDisk_Interface) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1020, 0}
}

// The mode in which this disk is attached to the source instance, either READ_WRITE or READ_ONLY.
type SavedAttachedDisk_Mode int32

const (
	// A value indicating that the enum field is not set.
	SavedAttachedDisk_UNDEFINED_MODE SavedAttachedDisk_Mode = 0
	// Attaches this disk in read-only mode. Multiple virtual machines can use a disk in read-only mode at a time.
	SavedAttachedDisk_READ_ONLY SavedAttachedDisk_Mode = 91950261
	// *[Default]* Attaches this disk in read-write mode. Only one virtual machine at a time can be attached to a disk in read-write mode.
	SavedAttachedDisk_READ_WRITE SavedAttachedDisk_Mode = 173607894
)

// Enum value maps for SavedAttachedDisk_Mode.
var (
	SavedAttachedDisk_Mode_name = map[int32]string{
		0:         "UNDEFINED_MODE",
		91950261:  "READ_ONLY",
		173607894: "READ_WRITE",
	}
	SavedAttachedDisk_Mode_value = map[string]int32{
		"UNDEFINED_MODE": 0,
		"READ_ONLY":      91950261,
		"READ_WRITE":     173607894,
	}
)

func (x SavedAttachedDisk_Mode) Enum() *SavedAttachedDisk_Mode {
	p := new(SavedAttachedDisk_Mode)
	*p = x
	return p
}

func (x SavedAttachedDisk_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SavedAttachedDisk_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[203].Descriptor()
}

func (SavedAttachedDisk_Mode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[203]
}

func (x SavedAttachedDisk_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SavedAttachedDisk_Mode.Descriptor instead.
func (SavedAttachedDisk_Mode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1020, 1}
}

// [Output Only] An indicator whether storageBytes is in a stable state or it is being adjusted as a result of shared storage reallocation. This status can either be UPDATING, meaning the size of the snapshot is being updated, or UP_TO_DATE, meaning the size of the snapshot is up-to-date.
type SavedAttachedDisk_StorageBytesStatus int32

const (
	// A value indicating that the enum field is not set.
	SavedAttachedDisk_UNDEFINED_STORAGE_BYTES_STATUS SavedAttachedDisk_StorageBytesStatus = 0
	SavedAttachedDisk_UPDATING                       SavedAttachedDisk_StorageBytesStatus = 494614342
	SavedAttachedDisk_UP_TO_DATE                     SavedAttachedDisk_StorageBytesStatus = 101306702
)

// Enum value maps for SavedAttachedDisk_StorageBytesStatus.
var (
	SavedAttachedDisk_StorageBytesStatus_name = map[int32]string{
		0:         "UNDEFINED_STORAGE_BYTES_STATUS",
		494614342: "UPDATING",
		101306702: "UP_TO_DATE",
	}
	SavedAttachedDisk_StorageBytesStatus_value = map[string]int32{
		"UNDEFINED_STORAGE_BYTES_STATUS": 0,
		"UPDATING":                       494614342,
		"UP_TO_DATE":                     101306702,
	}
)

func (x SavedAttachedDisk_StorageBytesStatus) Enum() *SavedAttachedDisk_StorageBytesStatus {
	p := new(SavedAttachedDisk_StorageBytesStatus)
	*p = x
	return p
}

func (x SavedAttachedDisk_StorageBytesStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SavedAttachedDisk_StorageBytesStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[204].Descriptor()
}

func (SavedAttachedDisk_StorageBytesStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[204]
}

func (x SavedAttachedDisk_StorageBytesStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SavedAttachedDisk_StorageBytesStatus.Descriptor instead.
func (SavedAttachedDisk_StorageBytesStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1020, 2}
}

// Specifies the type of the attached disk, either SCRATCH or PERSISTENT.
type SavedAttachedDisk_Type int32

const (
	// A value indicating that the enum field is not set.
	SavedAttachedDisk_UNDEFINED_TYPE SavedAttachedDisk_Type = 0
	SavedAttachedDisk_PERSISTENT     SavedAttachedDisk_Type = 460683927
	SavedAttachedDisk_SCRATCH        SavedAttachedDisk_Type = 496778970
)

// Enum value maps for SavedAttachedDisk_Type.
var (
	SavedAttachedDisk_Type_name = map[int32]string{
		0:         "UNDEFINED_TYPE",
		460683927: "PERSISTENT",
		496778970: "SCRATCH",
	}
	SavedAttachedDisk_Type_value = map[string]int32{
		"UNDEFINED_TYPE": 0,
		"PERSISTENT":     460683927,
		"SCRATCH":        496778970,
	}
)

func (x SavedAttachedDisk_Type) Enum() *SavedAttachedDisk_Type {
	p := new(SavedAttachedDisk_Type)
	*p = x
	return p
}

func (x SavedAttachedDisk_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SavedAttachedDisk_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[205].Descriptor()
}

func (SavedAttachedDisk_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[205]
}

func (x SavedAttachedDisk_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SavedAttachedDisk_Type.Descriptor instead.
func (SavedAttachedDisk_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1020, 3}
}

// [Output Only] The architecture of the attached disk.
type SavedDisk_Architecture int32

const (
	// A value indicating that the enum field is not set.
	SavedDisk_UNDEFINED_ARCHITECTURE SavedDisk_Architecture = 0
	// Default value indicating Architecture is not set.
	SavedDisk_ARCHITECTURE_UNSPECIFIED SavedDisk_Architecture = 394750507
	// Machines with architecture ARM64
	SavedDisk_ARM64 SavedDisk_Architecture = 62547450
	// Machines with architecture X86_64
	SavedDisk_X86_64 SavedDisk_Architecture = 425300551
)

// Enum value maps for SavedDisk_Architecture.
var (
	SavedDisk_Architecture_name = map[int32]string{
		0:         "UNDEFINED_ARCHITECTURE",
		394750507: "ARCHITECTURE_UNSPECIFIED",
		62547450:  "ARM64",
		425300551: "X86_64",
	}
	SavedDisk_Architecture_value = map[string]int32{
		"UNDEFINED_ARCHITECTURE":   0,
		"ARCHITECTURE_UNSPECIFIED": 394750507,
		"ARM64":                    62547450,
		"X86_64":                   425300551,
	}
)

func (x SavedDisk_Architecture) Enum() *SavedDisk_Architecture {
	p := new(SavedDisk_Architecture)
	*p = x
	return p
}

func (x SavedDisk_Architecture) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SavedDisk_Architecture) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[206].Descriptor()
}

func (SavedDisk_Architecture) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[206]
}

func (x SavedDisk_Architecture) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SavedDisk_Architecture.Descriptor instead.
func (SavedDisk_Architecture) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1021, 0}
}

// [Output Only] An indicator whether storageBytes is in a stable state or it is being adjusted as a result of shared storage reallocation. This status can either be UPDATING, meaning the size of the snapshot is being updated, or UP_TO_DATE, meaning the size of the snapshot is up-to-date.
type SavedDisk_StorageBytesStatus int32

const (
	// A value indicating that the enum field is not set.
	SavedDisk_UNDEFINED_STORAGE_BYTES_STATUS SavedDisk_StorageBytesStatus = 0
	SavedDisk_UPDATING                       SavedDisk_StorageBytesStatus = 494614342
	SavedDisk_UP_TO_DATE                     SavedDisk_StorageBytesStatus = 101306702
)

// Enum value maps for SavedDisk_StorageBytesStatus.
var (
	SavedDisk_StorageBytesStatus_name = map[int32]string{
		0:         "UNDEFINED_STORAGE_BYTES_STATUS",
		494614342: "UPDATING",
		101306702: "UP_TO_DATE",
	}
	SavedDisk_StorageBytesStatus_value = map[string]int32{
		"UNDEFINED_STORAGE_BYTES_STATUS": 0,
		"UPDATING":                       494614342,
		"UP_TO_DATE":                     101306702,
	}
)

func (x SavedDisk_StorageBytesStatus) Enum() *SavedDisk_StorageBytesStatus {
	p := new(SavedDisk_StorageBytesStatus)
	*p = x
	return p
}

func (x SavedDisk_StorageBytesStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SavedDisk_StorageBytesStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[207].Descriptor()
}

func (SavedDisk_StorageBytesStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[207]
}

func (x SavedDisk_StorageBytesStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SavedDisk_StorageBytesStatus.Descriptor instead.
func (SavedDisk_StorageBytesStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1021, 1}
}

// [Output Only] The current state of a scaling schedule.
type ScalingScheduleStatus_State int32

const (
	// A value indicating that the enum field is not set.
	ScalingScheduleStatus_UNDEFINED_STATE ScalingScheduleStatus_State = 0
	// The current autoscaling recommendation is influenced by this scaling schedule.
	ScalingScheduleStatus_ACTIVE ScalingScheduleStatus_State = 314733318
	// This scaling schedule has been disabled by the user.
	ScalingScheduleStatus_DISABLED ScalingScheduleStatus_State = 516696700
	// This scaling schedule will never become active again.
	ScalingScheduleStatus_OBSOLETE ScalingScheduleStatus_State = 66532761
	// The current autoscaling recommendation is not influenced by this scaling schedule.
	ScalingScheduleStatus_READY ScalingScheduleStatus_State = 77848963
)

// Enum value maps for ScalingScheduleStatus_State.
var (
	ScalingScheduleStatus_State_name = map[int32]string{
		0:         "UNDEFINED_STATE",
		314733318: "ACTIVE",
		516696700: "DISABLED",
		66532761:  "OBSOLETE",
		77848963:  "READY",
	}
	ScalingScheduleStatus_State_value = map[string]int32{
		"UNDEFINED_STATE": 0,
		"ACTIVE":          314733318,
		"DISABLED":        516696700,
		"OBSOLETE":        66532761,
		"READY":           77848963,
	}
)

func (x ScalingScheduleStatus_State) Enum() *ScalingScheduleStatus_State {
	p := new(ScalingScheduleStatus_State)
	*p = x
	return p
}

func (x ScalingScheduleStatus_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ScalingScheduleStatus_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[208].Descriptor()
}

func (ScalingScheduleStatus_State) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[208]
}

func (x ScalingScheduleStatus_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ScalingScheduleStatus_State.Descriptor instead.
func (ScalingScheduleStatus_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1022, 0}
}

// Specifies the termination action for the instance.
type Scheduling_InstanceTerminationAction int32

const (
	// A value indicating that the enum field is not set.
	Scheduling_UNDEFINED_INSTANCE_TERMINATION_ACTION Scheduling_InstanceTerminationAction = 0
	// Delete the VM.
	Scheduling_DELETE Scheduling_InstanceTerminationAction = 402225579
	// Default value. This value is unused.
	Scheduling_INSTANCE_TERMINATION_ACTION_UNSPECIFIED Scheduling_InstanceTerminationAction = 92954803
	// Stop the VM without storing in-memory content. default action.
	Scheduling_STOP Scheduling_InstanceTerminationAction = 2555906
)

// Enum value maps for Scheduling_InstanceTerminationAction.
var (
	Scheduling_InstanceTerminationAction_name = map[int32]string{
		0:         "UNDEFINED_INSTANCE_TERMINATION_ACTION",
		402225579: "DELETE",
		92954803:  "INSTANCE_TERMINATION_ACTION_UNSPECIFIED",
		2555906:   "STOP",
	}
	Scheduling_InstanceTerminationAction_value = map[string]int32{
		"UNDEFINED_INSTANCE_TERMINATION_ACTION":   0,
		"DELETE":                                  402225579,
		"INSTANCE_TERMINATION_ACTION_UNSPECIFIED": 92954803,
		"STOP": 2555906,
	}
)

func (x Scheduling_InstanceTerminationAction) Enum() *Scheduling_InstanceTerminationAction {
	p := new(Scheduling_InstanceTerminationAction)
	*p = x
	return p
}

func (x Scheduling_InstanceTerminationAction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Scheduling_InstanceTerminationAction) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[209].Descriptor()
}

func (Scheduling_InstanceTerminationAction) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[209]
}

func (x Scheduling_InstanceTerminationAction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Scheduling_InstanceTerminationAction.Descriptor instead.
func (Scheduling_InstanceTerminationAction) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1023, 0}
}

// Defines the maintenance behavior for this instance. For standard instances, the default behavior is MIGRATE. For preemptible instances, the default and only possible behavior is TERMINATE. For more information, see Set VM host maintenance policy.
type Scheduling_OnHostMaintenance int32

const (
	// A value indicating that the enum field is not set.
	Scheduling_UNDEFINED_ON_HOST_MAINTENANCE Scheduling_OnHostMaintenance = 0
	// *[Default]* Allows Compute Engine to automatically migrate instances out of the way of maintenance events.
	Scheduling_MIGRATE Scheduling_OnHostMaintenance = 165699979
	// Tells Compute Engine to terminate and (optionally) restart the instance away from the maintenance activity. If you would like your instance to be restarted, set the automaticRestart flag to true. Your instance may be restarted more than once, and it may be restarted outside the window of maintenance events.
	Scheduling_TERMINATE Scheduling_OnHostMaintenance = 527617601
)

// Enum value maps for Scheduling_OnHostMaintenance.
var (
	Scheduling_OnHostMaintenance_name = map[int32]string{
		0:         "UNDEFINED_ON_HOST_MAINTENANCE",
		165699979: "MIGRATE",
		527617601: "TERMINATE",
	}
	Scheduling_OnHostMaintenance_value = map[string]int32{
		"UNDEFINED_ON_HOST_MAINTENANCE": 0,
		"MIGRATE":                       165699979,
		"TERMINATE":                     527617601,
	}
)

func (x Scheduling_OnHostMaintenance) Enum() *Scheduling_OnHostMaintenance {
	p := new(Scheduling_OnHostMaintenance)
	*p = x
	return p
}

func (x Scheduling_OnHostMaintenance) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Scheduling_OnHostMaintenance) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[210].Descriptor()
}

func (Scheduling_OnHostMaintenance) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[210]
}

func (x Scheduling_OnHostMaintenance) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Scheduling_OnHostMaintenance.Descriptor instead.
func (Scheduling_OnHostMaintenance) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1023, 1}
}

// Specifies the provisioning model of the instance.
type Scheduling_ProvisioningModel int32

const (
	// A value indicating that the enum field is not set.
	Scheduling_UNDEFINED_PROVISIONING_MODEL Scheduling_ProvisioningModel = 0
	// Heavily discounted, no guaranteed runtime.
	Scheduling_SPOT Scheduling_ProvisioningModel = 2552066
	// Standard provisioning with user controlled runtime, no discounts.
	Scheduling_STANDARD Scheduling_ProvisioningModel = 484642493
)

// Enum value maps for Scheduling_ProvisioningModel.
var (
	Scheduling_ProvisioningModel_name = map[int32]string{
		0:         "UNDEFINED_PROVISIONING_MODEL",
		2552066:   "SPOT",
		484642493: "STANDARD",
	}
	Scheduling_ProvisioningModel_value = map[string]int32{
		"UNDEFINED_PROVISIONING_MODEL": 0,
		"SPOT":                         2552066,
		"STANDARD":                     484642493,
	}
)

func (x Scheduling_ProvisioningModel) Enum() *Scheduling_ProvisioningModel {
	p := new(Scheduling_ProvisioningModel)
	*p = x
	return p
}

func (x Scheduling_ProvisioningModel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Scheduling_ProvisioningModel) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[211].Descriptor()
}

func (Scheduling_ProvisioningModel) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[211]
}

func (x Scheduling_ProvisioningModel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Scheduling_ProvisioningModel.Descriptor instead.
func (Scheduling_ProvisioningModel) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1023, 2}
}

// Defines the operation of node selection. Valid operators are IN for affinity and NOT_IN for anti-affinity.
type SchedulingNodeAffinity_Operator int32

const (
	// A value indicating that the enum field is not set.
	SchedulingNodeAffinity_UNDEFINED_OPERATOR SchedulingNodeAffinity_Operator = 0
	// Requires Compute Engine to seek for matched nodes.
	SchedulingNodeAffinity_IN SchedulingNodeAffinity_Operator = 2341
	// Requires Compute Engine to avoid certain nodes.
	SchedulingNodeAffinity_NOT_IN               SchedulingNodeAffinity_Operator = 161144369
	SchedulingNodeAffinity_OPERATOR_UNSPECIFIED SchedulingNodeAffinity_Operator = 128892924
)

// Enum value maps for SchedulingNodeAffinity_Operator.
var (
	SchedulingNodeAffinity_Operator_name = map[int32]string{
		0:         "UNDEFINED_OPERATOR",
		2341:      "IN",
		161144369: "NOT_IN",
		128892924: "OPERATOR_UNSPECIFIED",
	}
	SchedulingNodeAffinity_Operator_value = map[string]int32{
		"UNDEFINED_OPERATOR":   0,
		"IN":                   2341,
		"NOT_IN":               161144369,
		"OPERATOR_UNSPECIFIED": 128892924,
	}
)

func (x SchedulingNodeAffinity_Operator) Enum() *SchedulingNodeAffinity_Operator {
	p := new(SchedulingNodeAffinity_Operator)
	*p = x
	return p
}

func (x SchedulingNodeAffinity_Operator) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SchedulingNodeAffinity_Operator) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[212].Descriptor()
}

func (SchedulingNodeAffinity_Operator) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[212]
}

func (x SchedulingNodeAffinity_Operator) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SchedulingNodeAffinity_Operator.Descriptor instead.
func (SchedulingNodeAffinity_Operator) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1024, 0}
}

// The type indicates the intended use of the security policy. - CLOUD_ARMOR: Cloud Armor backend security policies can be configured to filter incoming HTTP requests targeting backend services. They filter requests before they hit the origin servers. - CLOUD_ARMOR_EDGE: Cloud Armor edge security policies can be configured to filter incoming HTTP requests targeting backend services (including Cloud CDN-enabled) as well as backend buckets (Cloud Storage). They filter requests before the request is served from Google's cache. - CLOUD_ARMOR_INTERNAL_SERVICE: Cloud Armor internal service policies can be configured to filter HTTP requests targeting services managed by Traffic Director in a service mesh. They filter requests before the request is served from the application. - CLOUD_ARMOR_NETWORK: Cloud Armor network policies can be configured to filter packets targeting network load balancing resources such as backend services, target pools, target instances, and instances with external IPs. They filter requests before the request is served from the application. This field can be set only at resource creation time.
type SecurityPolicy_Type int32

const (
	// A value indicating that the enum field is not set.
	SecurityPolicy_UNDEFINED_TYPE      SecurityPolicy_Type = 0
	SecurityPolicy_CLOUD_ARMOR         SecurityPolicy_Type = 260640373
	SecurityPolicy_CLOUD_ARMOR_EDGE    SecurityPolicy_Type = 250728775
	SecurityPolicy_CLOUD_ARMOR_NETWORK SecurityPolicy_Type = 488527428
)

// Enum value maps for SecurityPolicy_Type.
var (
	SecurityPolicy_Type_name = map[int32]string{
		0:         "UNDEFINED_TYPE",
		260640373: "CLOUD_ARMOR",
		250728775: "CLOUD_ARMOR_EDGE",
		488527428: "CLOUD_ARMOR_NETWORK",
	}
	SecurityPolicy_Type_value = map[string]int32{
		"UNDEFINED_TYPE":      0,
		"CLOUD_ARMOR":         260640373,
		"CLOUD_ARMOR_EDGE":    250728775,
		"CLOUD_ARMOR_NETWORK": 488527428,
	}
)

func (x SecurityPolicy_Type) Enum() *SecurityPolicy_Type {
	p := new(SecurityPolicy_Type)
	*p = x
	return p
}

func (x SecurityPolicy_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SecurityPolicy_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[213].Descriptor()
}

func (SecurityPolicy_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[213]
}

func (x SecurityPolicy_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SecurityPolicy_Type.Descriptor instead.
func (SecurityPolicy_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1031, 0}
}

// Rule visibility can be one of the following: STANDARD - opaque rules. (default) PREMIUM - transparent rules.
type SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig_RuleVisibility int32

const (
	// A value indicating that the enum field is not set.
	SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig_UNDEFINED_RULE_VISIBILITY SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig_RuleVisibility = 0
	SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig_PREMIUM                   SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig_RuleVisibility = 399530551
	SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig_STANDARD                  SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig_RuleVisibility = 484642493
)

// Enum value maps for SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig_RuleVisibility.
var (
	SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig_RuleVisibility_name = map[int32]string{
		0:         "UNDEFINED_RULE_VISIBILITY",
		399530551: "PREMIUM",
		484642493: "STANDARD",
	}
	SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig_RuleVisibility_value = map[string]int32{
		"UNDEFINED_RULE_VISIBILITY": 0,
		"PREMIUM":                   399530551,
		"STANDARD":                  484642493,
	}
)

func (x SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig_RuleVisibility) Enum() *SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig_RuleVisibility {
	p := new(SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig_RuleVisibility)
	*p = x
	return p
}

func (x SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig_RuleVisibility) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig_RuleVisibility) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[214].Descriptor()
}

func (SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig_RuleVisibility) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[214]
}

func (x SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig_RuleVisibility) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig_RuleVisibility.Descriptor instead.
func (SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig_RuleVisibility) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1033, 0}
}

type SecurityPolicyAdvancedOptionsConfig_JsonParsing int32

const (
	// A value indicating that the enum field is not set.
	SecurityPolicyAdvancedOptionsConfig_UNDEFINED_JSON_PARSING SecurityPolicyAdvancedOptionsConfig_JsonParsing = 0
	SecurityPolicyAdvancedOptionsConfig_DISABLED               SecurityPolicyAdvancedOptionsConfig_JsonParsing = 516696700
	SecurityPolicyAdvancedOptionsConfig_STANDARD               SecurityPolicyAdvancedOptionsConfig_JsonParsing = 484642493
)

// Enum value maps for SecurityPolicyAdvancedOptionsConfig_JsonParsing.
var (
	SecurityPolicyAdvancedOptionsConfig_JsonParsing_name = map[int32]string{
		0:         "UNDEFINED_JSON_PARSING",
		516696700: "DISABLED",
		484642493: "STANDARD",
	}
	SecurityPolicyAdvancedOptionsConfig_JsonParsing_value = map[string]int32{
		"UNDEFINED_JSON_PARSING": 0,
		"DISABLED":               516696700,
		"STANDARD":               484642493,
	}
)

func (x SecurityPolicyAdvancedOptionsConfig_JsonParsing) Enum() *SecurityPolicyAdvancedOptionsConfig_JsonParsing {
	p := new(SecurityPolicyAdvancedOptionsConfig_JsonParsing)
	*p = x
	return p
}

func (x SecurityPolicyAdvancedOptionsConfig_JsonParsing) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SecurityPolicyAdvancedOptionsConfig_JsonParsing) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[215].Descriptor()
}

func (SecurityPolicyAdvancedOptionsConfig_JsonParsing) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[215]
}

func (x SecurityPolicyAdvancedOptionsConfig_JsonParsing) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SecurityPolicyAdvancedOptionsConfig_JsonParsing.Descriptor instead.
func (SecurityPolicyAdvancedOptionsConfig_JsonParsing) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1034, 0}
}

type SecurityPolicyAdvancedOptionsConfig_LogLevel int32

const (
	// A value indicating that the enum field is not set.
	SecurityPolicyAdvancedOptionsConfig_UNDEFINED_LOG_LEVEL SecurityPolicyAdvancedOptionsConfig_LogLevel = 0
	SecurityPolicyAdvancedOptionsConfig_NORMAL              SecurityPolicyAdvancedOptionsConfig_LogLevel = 161067239
	SecurityPolicyAdvancedOptionsConfig_VERBOSE             SecurityPolicyAdvancedOptionsConfig_LogLevel = 532219234
)

// Enum value maps for SecurityPolicyAdvancedOptionsConfig_LogLevel.
var (
	SecurityPolicyAdvancedOptionsConfig_LogLevel_name = map[int32]string{
		0:         "UNDEFINED_LOG_LEVEL",
		161067239: "NORMAL",
		532219234: "VERBOSE",
	}
	SecurityPolicyAdvancedOptionsConfig_LogLevel_value = map[string]int32{
		"UNDEFINED_LOG_LEVEL": 0,
		"NORMAL":              161067239,
		"VERBOSE":             532219234,
	}
)

func (x SecurityPolicyAdvancedOptionsConfig_LogLevel) Enum() *SecurityPolicyAdvancedOptionsConfig_LogLevel {
	p := new(SecurityPolicyAdvancedOptionsConfig_LogLevel)
	*p = x
	return p
}

func (x SecurityPolicyAdvancedOptionsConfig_LogLevel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SecurityPolicyAdvancedOptionsConfig_LogLevel) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[216].Descriptor()
}

func (SecurityPolicyAdvancedOptionsConfig_LogLevel) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[216]
}

func (x SecurityPolicyAdvancedOptionsConfig_LogLevel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SecurityPolicyAdvancedOptionsConfig_LogLevel.Descriptor instead.
func (SecurityPolicyAdvancedOptionsConfig_LogLevel) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1034, 1}
}

type SecurityPolicyDdosProtectionConfig_DdosProtection int32

const (
	// A value indicating that the enum field is not set.
	SecurityPolicyDdosProtectionConfig_UNDEFINED_DDOS_PROTECTION SecurityPolicyDdosProtectionConfig_DdosProtection = 0
	SecurityPolicyDdosProtectionConfig_ADVANCED                  SecurityPolicyDdosProtectionConfig_DdosProtection = 63789090
	SecurityPolicyDdosProtectionConfig_STANDARD                  SecurityPolicyDdosProtectionConfig_DdosProtection = 484642493
)

// Enum value maps for SecurityPolicyDdosProtectionConfig_DdosProtection.
var (
	SecurityPolicyDdosProtectionConfig_DdosProtection_name = map[int32]string{
		0:         "UNDEFINED_DDOS_PROTECTION",
		63789090:  "ADVANCED",
		484642493: "STANDARD",
	}
	SecurityPolicyDdosProtectionConfig_DdosProtection_value = map[string]int32{
		"UNDEFINED_DDOS_PROTECTION": 0,
		"ADVANCED":                  63789090,
		"STANDARD":                  484642493,
	}
)

func (x SecurityPolicyDdosProtectionConfig_DdosProtection) Enum() *SecurityPolicyDdosProtectionConfig_DdosProtection {
	p := new(SecurityPolicyDdosProtectionConfig_DdosProtection)
	*p = x
	return p
}

func (x SecurityPolicyDdosProtectionConfig_DdosProtection) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SecurityPolicyDdosProtectionConfig_DdosProtection) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[217].Descriptor()
}

func (SecurityPolicyDdosProtectionConfig_DdosProtection) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[217]
}

func (x SecurityPolicyDdosProtectionConfig_DdosProtection) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SecurityPolicyDdosProtectionConfig_DdosProtection.Descriptor instead.
func (SecurityPolicyDdosProtectionConfig_DdosProtection) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1036, 0}
}

// Preconfigured versioned expression. If this field is specified, config must also be specified. Available preconfigured expressions along with their requirements are: SRC_IPS_V1 - must specify the corresponding src_ip_range field in config.
type SecurityPolicyRuleMatcher_VersionedExpr int32

const (
	// A value indicating that the enum field is not set.
	SecurityPolicyRuleMatcher_UNDEFINED_VERSIONED_EXPR SecurityPolicyRuleMatcher_VersionedExpr = 0
	// Matches the source IP address of a request to the IP ranges supplied in config.
	SecurityPolicyRuleMatcher_SRC_IPS_V1 SecurityPolicyRuleMatcher_VersionedExpr = 70925961
)

// Enum value maps for SecurityPolicyRuleMatcher_VersionedExpr.
var (
	SecurityPolicyRuleMatcher_VersionedExpr_name = map[int32]string{
		0:        "UNDEFINED_VERSIONED_EXPR",
		70925961: "SRC_IPS_V1",
	}
	SecurityPolicyRuleMatcher_VersionedExpr_value = map[string]int32{
		"UNDEFINED_VERSIONED_EXPR": 0,
		"SRC_IPS_V1":               70925961,
	}
)

func (x SecurityPolicyRuleMatcher_VersionedExpr) Enum() *SecurityPolicyRuleMatcher_VersionedExpr {
	p := new(SecurityPolicyRuleMatcher_VersionedExpr)
	*p = x
	return p
}

func (x SecurityPolicyRuleMatcher_VersionedExpr) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SecurityPolicyRuleMatcher_VersionedExpr) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[218].Descriptor()
}

func (SecurityPolicyRuleMatcher_VersionedExpr) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[218]
}

func (x SecurityPolicyRuleMatcher_VersionedExpr) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SecurityPolicyRuleMatcher_VersionedExpr.Descriptor instead.
func (SecurityPolicyRuleMatcher_VersionedExpr) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1043, 0}
}

// The match operator for the field.
type SecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams_Op int32

const (
	// A value indicating that the enum field is not set.
	SecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams_UNDEFINED_OP SecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams_Op = 0
	// The operator matches if the field value contains the specified value.
	SecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams_CONTAINS SecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams_Op = 215180831
	// The operator matches if the field value ends with the specified value.
	SecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams_ENDS_WITH SecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams_Op = 490402221
	// The operator matches if the field value equals the specified value.
	SecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams_EQUALS SecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams_Op = 442201023
	// The operator matches if the field value is any value.
	SecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams_EQUALS_ANY SecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams_Op = 337226060
	// The operator matches if the field value starts with the specified value.
	SecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams_STARTS_WITH SecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams_Op = 139505652
)

// Enum value maps for SecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams_Op.
var (
	SecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams_Op_name = map[int32]string{
		0:         "UNDEFINED_OP",
		215180831: "CONTAINS",
		490402221: "ENDS_WITH",
		442201023: "EQUALS",
		337226060: "EQUALS_ANY",
		139505652: "STARTS_WITH",
	}
	SecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams_Op_value = map[string]int32{
		"UNDEFINED_OP": 0,
		"CONTAINS":     215180831,
		"ENDS_WITH":    490402221,
		"EQUALS":       442201023,
		"EQUALS_ANY":   337226060,
		"STARTS_WITH":  139505652,
	}
)

func (x SecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams_Op) Enum() *SecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams_Op {
	p := new(SecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams_Op)
	*p = x
	return p
}

func (x SecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams_Op) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams_Op) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[219].Descriptor()
}

func (SecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams_Op) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[219]
}

func (x SecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams_Op) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams_Op.Descriptor instead.
func (SecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams_Op) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1047, 0}
}

// Determines the key to enforce the rate_limit_threshold on. Possible values are: - ALL: A single rate limit threshold is applied to all the requests matching this rule. This is the default value if "enforceOnKey" is not configured. - IP: The source IP address of the request is the key. Each IP has this limit enforced separately. - HTTP_HEADER: The value of the HTTP header whose name is configured under "enforceOnKeyName". The key value is truncated to the first 128 bytes of the header value. If no such header is present in the request, the key type defaults to ALL. - XFF_IP: The first IP address (i.e. the originating client IP address) specified in the list of IPs under X-Forwarded-For HTTP header. If no such header is present or the value is not a valid IP, the key defaults to the source IP address of the request i.e. key type IP. - HTTP_COOKIE: The value of the HTTP cookie whose name is configured under "enforceOnKeyName". The key value is truncated to the first 128 bytes of the cookie value. If no such cookie is present in the request, the key type defaults to ALL. - HTTP_PATH: The URL path of the HTTP request. The key value is truncated to the first 128 bytes. - SNI: Server name indication in the TLS session of the HTTPS request. The key value is truncated to the first 128 bytes. The key type defaults to ALL on a HTTP session. - REGION_CODE: The country/region from which the request originates.
type SecurityPolicyRuleRateLimitOptions_EnforceOnKey int32

const (
	// A value indicating that the enum field is not set.
	SecurityPolicyRuleRateLimitOptions_UNDEFINED_ENFORCE_ON_KEY SecurityPolicyRuleRateLimitOptions_EnforceOnKey = 0
	SecurityPolicyRuleRateLimitOptions_ALL                      SecurityPolicyRuleRateLimitOptions_EnforceOnKey = 64897
	SecurityPolicyRuleRateLimitOptions_HTTP_COOKIE              SecurityPolicyRuleRateLimitOptions_EnforceOnKey = 494981627
	SecurityPolicyRuleRateLimitOptions_HTTP_HEADER              SecurityPolicyRuleRateLimitOptions_EnforceOnKey = 91597348
	SecurityPolicyRuleRateLimitOptions_HTTP_PATH                SecurityPolicyRuleRateLimitOptions_EnforceOnKey = 311503228
	SecurityPolicyRuleRateLimitOptions_IP                       SecurityPolicyRuleRateLimitOptions_EnforceOnKey = 2343
	SecurityPolicyRuleRateLimitOptions_REGION_CODE              SecurityPolicyRuleRateLimitOptions_EnforceOnKey = 79559768
	SecurityPolicyRuleRateLimitOptions_SNI                      SecurityPolicyRuleRateLimitOptions_EnforceOnKey = 82254
	SecurityPolicyRuleRateLimitOptions_XFF_IP                   SecurityPolicyRuleRateLimitOptions_EnforceOnKey = 438707118
)

// Enum value maps for SecurityPolicyRuleRateLimitOptions_EnforceOnKey.
var (
	SecurityPolicyRuleRateLimitOptions_EnforceOnKey_name = map[int32]string{
		0:         "UNDEFINED_ENFORCE_ON_KEY",
		64897:     "ALL",
		494981627: "HTTP_COOKIE",
		91597348:  "HTTP_HEADER",
		311503228: "HTTP_PATH",
		2343:      "IP",
		79559768:  "REGION_CODE",
		82254:     "SNI",
		438707118: "XFF_IP",
	}
	SecurityPolicyRuleRateLimitOptions_EnforceOnKey_value = map[string]int32{
		"UNDEFINED_ENFORCE_ON_KEY": 0,
		"ALL":                      64897,
		"HTTP_COOKIE":              494981627,
		"HTTP_HEADER":              91597348,
		"HTTP_PATH":                311503228,
		"IP":                       2343,
		"REGION_CODE":              79559768,
		"SNI":                      82254,
		"XFF_IP":                   438707118,
	}
)

func (x SecurityPolicyRuleRateLimitOptions_EnforceOnKey) Enum() *SecurityPolicyRuleRateLimitOptions_EnforceOnKey {
	p := new(SecurityPolicyRuleRateLimitOptions_EnforceOnKey)
	*p = x
	return p
}

func (x SecurityPolicyRuleRateLimitOptions_EnforceOnKey) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SecurityPolicyRuleRateLimitOptions_EnforceOnKey) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[220].Descriptor()
}

func (SecurityPolicyRuleRateLimitOptions_EnforceOnKey) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[220]
}

func (x SecurityPolicyRuleRateLimitOptions_EnforceOnKey) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SecurityPolicyRuleRateLimitOptions_EnforceOnKey.Descriptor instead.
func (SecurityPolicyRuleRateLimitOptions_EnforceOnKey) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1048, 0}
}

// Type of the redirect action.
type SecurityPolicyRuleRedirectOptions_Type int32

const (
	// A value indicating that the enum field is not set.
	SecurityPolicyRuleRedirectOptions_UNDEFINED_TYPE   SecurityPolicyRuleRedirectOptions_Type = 0
	SecurityPolicyRuleRedirectOptions_EXTERNAL_302     SecurityPolicyRuleRedirectOptions_Type = 395733761
	SecurityPolicyRuleRedirectOptions_GOOGLE_RECAPTCHA SecurityPolicyRuleRedirectOptions_Type = 518803009
)

// Enum value maps for SecurityPolicyRuleRedirectOptions_Type.
var (
	SecurityPolicyRuleRedirectOptions_Type_name = map[int32]string{
		0:         "UNDEFINED_TYPE",
		395733761: "EXTERNAL_302",
		518803009: "GOOGLE_RECAPTCHA",
	}
	SecurityPolicyRuleRedirectOptions_Type_value = map[string]int32{
		"UNDEFINED_TYPE":   0,
		"EXTERNAL_302":     395733761,
		"GOOGLE_RECAPTCHA": 518803009,
	}
)

func (x SecurityPolicyRuleRedirectOptions_Type) Enum() *SecurityPolicyRuleRedirectOptions_Type {
	p := new(SecurityPolicyRuleRedirectOptions_Type)
	*p = x
	return p
}

func (x SecurityPolicyRuleRedirectOptions_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SecurityPolicyRuleRedirectOptions_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[221].Descriptor()
}

func (SecurityPolicyRuleRedirectOptions_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[221]
}

func (x SecurityPolicyRuleRedirectOptions_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SecurityPolicyRuleRedirectOptions_Type.Descriptor instead.
func (SecurityPolicyRuleRedirectOptions_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1050, 0}
}

type ServerBinding_Type int32

const (
	// A value indicating that the enum field is not set.
	ServerBinding_UNDEFINED_TYPE ServerBinding_Type = 0
	// Node may associate with any physical server over its lifetime.
	ServerBinding_RESTART_NODE_ON_ANY_SERVER ServerBinding_Type = 502950985
	// Node may associate with minimal physical servers over its lifetime.
	ServerBinding_RESTART_NODE_ON_MINIMAL_SERVERS ServerBinding_Type = 204166495
	ServerBinding_SERVER_BINDING_TYPE_UNSPECIFIED ServerBinding_Type = 180825512
)

// Enum value maps for ServerBinding_Type.
var (
	ServerBinding_Type_name = map[int32]string{
		0:         "UNDEFINED_TYPE",
		502950985: "RESTART_NODE_ON_ANY_SERVER",
		204166495: "RESTART_NODE_ON_MINIMAL_SERVERS",
		180825512: "SERVER_BINDING_TYPE_UNSPECIFIED",
	}
	ServerBinding_Type_value = map[string]int32{
		"UNDEFINED_TYPE":                  0,
		"RESTART_NODE_ON_ANY_SERVER":      502950985,
		"RESTART_NODE_ON_MINIMAL_SERVERS": 204166495,
		"SERVER_BINDING_TYPE_UNSPECIFIED": 180825512,
	}
)

func (x ServerBinding_Type) Enum() *ServerBinding_Type {
	p := new(ServerBinding_Type)
	*p = x
	return p
}

func (x ServerBinding_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ServerBinding_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[222].Descriptor()
}

func (ServerBinding_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[222]
}

func (x ServerBinding_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ServerBinding_Type.Descriptor instead.
func (ServerBinding_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1055, 0}
}

// The connection preference of service attachment. The value can be set to ACCEPT_AUTOMATIC. An ACCEPT_AUTOMATIC service attachment is one that always accepts the connection from consumer forwarding rules.
type ServiceAttachment_ConnectionPreference int32

const (
	// A value indicating that the enum field is not set.
	ServiceAttachment_UNDEFINED_CONNECTION_PREFERENCE   ServiceAttachment_ConnectionPreference = 0
	ServiceAttachment_ACCEPT_AUTOMATIC                  ServiceAttachment_ConnectionPreference = 75250580
	ServiceAttachment_ACCEPT_MANUAL                     ServiceAttachment_ConnectionPreference = 373061341
	ServiceAttachment_CONNECTION_PREFERENCE_UNSPECIFIED ServiceAttachment_ConnectionPreference = 34590772
)

// Enum value maps for ServiceAttachment_ConnectionPreference.
var (
	ServiceAttachment_ConnectionPreference_name = map[int32]string{
		0:         "UNDEFINED_CONNECTION_PREFERENCE",
		75250580:  "ACCEPT_AUTOMATIC",
		373061341: "ACCEPT_MANUAL",
		34590772:  "CONNECTION_PREFERENCE_UNSPECIFIED",
	}
	ServiceAttachment_ConnectionPreference_value = map[string]int32{
		"UNDEFINED_CONNECTION_PREFERENCE":   0,
		"ACCEPT_AUTOMATIC":                  75250580,
		"ACCEPT_MANUAL":                     373061341,
		"CONNECTION_PREFERENCE_UNSPECIFIED": 34590772,
	}
)

func (x ServiceAttachment_ConnectionPreference) Enum() *ServiceAttachment_ConnectionPreference {
	p := new(ServiceAttachment_ConnectionPreference)
	*p = x
	return p
}

func (x ServiceAttachment_ConnectionPreference) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ServiceAttachment_ConnectionPreference) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[223].Descriptor()
}

func (ServiceAttachment_ConnectionPreference) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[223]
}

func (x ServiceAttachment_ConnectionPreference) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ServiceAttachment_ConnectionPreference.Descriptor instead.
func (ServiceAttachment_ConnectionPreference) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1057, 0}
}

// The status of a connected endpoint to this service attachment.
type ServiceAttachmentConnectedEndpoint_Status int32

const (
	// A value indicating that the enum field is not set.
	ServiceAttachmentConnectedEndpoint_UNDEFINED_STATUS ServiceAttachmentConnectedEndpoint_Status = 0
	// The connection has been accepted by the producer.
	ServiceAttachmentConnectedEndpoint_ACCEPTED ServiceAttachmentConnectedEndpoint_Status = 246714279
	// The connection has been closed by the producer.
	ServiceAttachmentConnectedEndpoint_CLOSED ServiceAttachmentConnectedEndpoint_Status = 380163436
	// The connection has been accepted by the producer, but the producer needs to take further action before the forwarding rule can serve traffic.
	ServiceAttachmentConnectedEndpoint_NEEDS_ATTENTION ServiceAttachmentConnectedEndpoint_Status = 344491452
	// The connection is pending acceptance by the producer.
	ServiceAttachmentConnectedEndpoint_PENDING ServiceAttachmentConnectedEndpoint_Status = 35394935
	// The consumer is still connected but not using the connection.
	ServiceAttachmentConnectedEndpoint_REJECTED           ServiceAttachmentConnectedEndpoint_Status = 174130302
	ServiceAttachmentConnectedEndpoint_STATUS_UNSPECIFIED ServiceAttachmentConnectedEndpoint_Status = 42133066
)

// Enum value maps for ServiceAttachmentConnectedEndpoint_Status.
var (
	ServiceAttachmentConnectedEndpoint_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		246714279: "ACCEPTED",
		380163436: "CLOSED",
		344491452: "NEEDS_ATTENTION",
		35394935:  "PENDING",
		174130302: "REJECTED",
		42133066:  "STATUS_UNSPECIFIED",
	}
	ServiceAttachmentConnectedEndpoint_Status_value = map[string]int32{
		"UNDEFINED_STATUS":   0,
		"ACCEPTED":           246714279,
		"CLOSED":             380163436,
		"NEEDS_ATTENTION":    344491452,
		"PENDING":            35394935,
		"REJECTED":           174130302,
		"STATUS_UNSPECIFIED": 42133066,
	}
)

func (x ServiceAttachmentConnectedEndpoint_Status) Enum() *ServiceAttachmentConnectedEndpoint_Status {
	p := new(ServiceAttachmentConnectedEndpoint_Status)
	*p = x
	return p
}

func (x ServiceAttachmentConnectedEndpoint_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ServiceAttachmentConnectedEndpoint_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[224].Descriptor()
}

func (ServiceAttachmentConnectedEndpoint_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[224]
}

func (x ServiceAttachmentConnectedEndpoint_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ServiceAttachmentConnectedEndpoint_Status.Descriptor instead.
func (ServiceAttachmentConnectedEndpoint_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1059, 0}
}

// Type of sharing for this shared-reservation
type ShareSettings_ShareType int32

const (
	// A value indicating that the enum field is not set.
	ShareSettings_UNDEFINED_SHARE_TYPE ShareSettings_ShareType = 0
	// Default value.
	ShareSettings_LOCAL ShareSettings_ShareType = 72607563
	// Shared-reservation is open to entire Organization
	ShareSettings_ORGANIZATION ShareSettings_ShareType = 274978099
	// Default value. This value is unused.
	ShareSettings_SHARE_TYPE_UNSPECIFIED ShareSettings_ShareType = 494771730
	// Shared-reservation is open to specific projects
	ShareSettings_SPECIFIC_PROJECTS ShareSettings_ShareType = 347838695
)

// Enum value maps for ShareSettings_ShareType.
var (
	ShareSettings_ShareType_name = map[int32]string{
		0:         "UNDEFINED_SHARE_TYPE",
		72607563:  "LOCAL",
		274978099: "ORGANIZATION",
		494771730: "SHARE_TYPE_UNSPECIFIED",
		347838695: "SPECIFIC_PROJECTS",
	}
	ShareSettings_ShareType_value = map[string]int32{
		"UNDEFINED_SHARE_TYPE":   0,
		"LOCAL":                  72607563,
		"ORGANIZATION":           274978099,
		"SHARE_TYPE_UNSPECIFIED": 494771730,
		"SPECIFIC_PROJECTS":      347838695,
	}
)

func (x ShareSettings_ShareType) Enum() *ShareSettings_ShareType {
	p := new(ShareSettings_ShareType)
	*p = x
	return p
}

func (x ShareSettings_ShareType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ShareSettings_ShareType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[225].Descriptor()
}

func (ShareSettings_ShareType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[225]
}

func (x ShareSettings_ShareType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ShareSettings_ShareType.Descriptor instead.
func (ShareSettings_ShareType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1143, 0}
}

// [Output Only] The architecture of the snapshot. Valid values are ARM64 or X86_64.
type Snapshot_Architecture int32

const (
	// A value indicating that the enum field is not set.
	Snapshot_UNDEFINED_ARCHITECTURE Snapshot_Architecture = 0
	// Default value indicating Architecture is not set.
	Snapshot_ARCHITECTURE_UNSPECIFIED Snapshot_Architecture = 394750507
	// Machines with architecture ARM64
	Snapshot_ARM64 Snapshot_Architecture = 62547450
	// Machines with architecture X86_64
	Snapshot_X86_64 Snapshot_Architecture = 425300551
)

// Enum value maps for Snapshot_Architecture.
var (
	Snapshot_Architecture_name = map[int32]string{
		0:         "UNDEFINED_ARCHITECTURE",
		394750507: "ARCHITECTURE_UNSPECIFIED",
		62547450:  "ARM64",
		425300551: "X86_64",
	}
	Snapshot_Architecture_value = map[string]int32{
		"UNDEFINED_ARCHITECTURE":   0,
		"ARCHITECTURE_UNSPECIFIED": 394750507,
		"ARM64":                    62547450,
		"X86_64":                   425300551,
	}
)

func (x Snapshot_Architecture) Enum() *Snapshot_Architecture {
	p := new(Snapshot_Architecture)
	*p = x
	return p
}

func (x Snapshot_Architecture) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Snapshot_Architecture) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[226].Descriptor()
}

func (Snapshot_Architecture) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[226]
}

func (x Snapshot_Architecture) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Snapshot_Architecture.Descriptor instead.
func (Snapshot_Architecture) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1152, 0}
}

// Indicates the type of the snapshot.
type Snapshot_SnapshotType int32

const (
	// A value indicating that the enum field is not set.
	Snapshot_UNDEFINED_SNAPSHOT_TYPE Snapshot_SnapshotType = 0
	Snapshot_ARCHIVE                 Snapshot_SnapshotType = 506752162
	Snapshot_STANDARD                Snapshot_SnapshotType = 484642493
)

// Enum value maps for Snapshot_SnapshotType.
var (
	Snapshot_SnapshotType_name = map[int32]string{
		0:         "UNDEFINED_SNAPSHOT_TYPE",
		506752162: "ARCHIVE",
		484642493: "STANDARD",
	}
	Snapshot_SnapshotType_value = map[string]int32{
		"UNDEFINED_SNAPSHOT_TYPE": 0,
		"ARCHIVE":                 506752162,
		"STANDARD":                484642493,
	}
)

func (x Snapshot_SnapshotType) Enum() *Snapshot_SnapshotType {
	p := new(Snapshot_SnapshotType)
	*p = x
	return p
}

func (x Snapshot_SnapshotType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Snapshot_SnapshotType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[227].Descriptor()
}

func (Snapshot_SnapshotType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[227]
}

func (x Snapshot_SnapshotType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Snapshot_SnapshotType.Descriptor instead.
func (Snapshot_SnapshotType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1152, 1}
}

// [Output Only] The status of the snapshot. This can be CREATING, DELETING, FAILED, READY, or UPLOADING.
type Snapshot_Status int32

const (
	// A value indicating that the enum field is not set.
	Snapshot_UNDEFINED_STATUS Snapshot_Status = 0
	// Snapshot creation is in progress.
	Snapshot_CREATING Snapshot_Status = 455564985
	// Snapshot is currently being deleted.
	Snapshot_DELETING Snapshot_Status = 528602024
	// Snapshot creation failed.
	Snapshot_FAILED Snapshot_Status = 455706685
	// Snapshot has been created successfully.
	Snapshot_READY Snapshot_Status = 77848963
	// Snapshot is being uploaded.
	Snapshot_UPLOADING Snapshot_Status = 267603489
)

// Enum value maps for Snapshot_Status.
var (
	Snapshot_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		455564985: "CREATING",
		528602024: "DELETING",
		455706685: "FAILED",
		77848963:  "READY",
		267603489: "UPLOADING",
	}
	Snapshot_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"CREATING":         455564985,
		"DELETING":         528602024,
		"FAILED":           455706685,
		"READY":            77848963,
		"UPLOADING":        267603489,
	}
)

func (x Snapshot_Status) Enum() *Snapshot_Status {
	p := new(Snapshot_Status)
	*p = x
	return p
}

func (x Snapshot_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Snapshot_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[228].Descriptor()
}

func (Snapshot_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[228]
}

func (x Snapshot_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Snapshot_Status.Descriptor instead.
func (Snapshot_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1152, 2}
}

// [Output Only] An indicator whether storageBytes is in a stable state or it is being adjusted as a result of shared storage reallocation. This status can either be UPDATING, meaning the size of the snapshot is being updated, or UP_TO_DATE, meaning the size of the snapshot is up-to-date.
type Snapshot_StorageBytesStatus int32

const (
	// A value indicating that the enum field is not set.
	Snapshot_UNDEFINED_STORAGE_BYTES_STATUS Snapshot_StorageBytesStatus = 0
	Snapshot_UPDATING                       Snapshot_StorageBytesStatus = 494614342
	Snapshot_UP_TO_DATE                     Snapshot_StorageBytesStatus = 101306702
)

// Enum value maps for Snapshot_StorageBytesStatus.
var (
	Snapshot_StorageBytesStatus_name = map[int32]string{
		0:         "UNDEFINED_STORAGE_BYTES_STATUS",
		494614342: "UPDATING",
		101306702: "UP_TO_DATE",
	}
	Snapshot_StorageBytesStatus_value = map[string]int32{
		"UNDEFINED_STORAGE_BYTES_STATUS": 0,
		"UPDATING":                       494614342,
		"UP_TO_DATE":                     101306702,
	}
)

func (x Snapshot_StorageBytesStatus) Enum() *Snapshot_StorageBytesStatus {
	p := new(Snapshot_StorageBytesStatus)
	*p = x
	return p
}

func (x Snapshot_StorageBytesStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Snapshot_StorageBytesStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[229].Descriptor()
}

func (Snapshot_StorageBytesStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[229]
}

func (x Snapshot_StorageBytesStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Snapshot_StorageBytesStatus.Descriptor instead.
func (Snapshot_StorageBytesStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1152, 3}
}

// KeyRevocationActionType of the instance. Supported options are "STOP" and "NONE". The default value is "NONE" if it is not specified.
type SourceInstanceProperties_KeyRevocationActionType int32

const (
	// A value indicating that the enum field is not set.
	SourceInstanceProperties_UNDEFINED_KEY_REVOCATION_ACTION_TYPE SourceInstanceProperties_KeyRevocationActionType = 0
	// Default value. This value is unused.
	SourceInstanceProperties_KEY_REVOCATION_ACTION_TYPE_UNSPECIFIED SourceInstanceProperties_KeyRevocationActionType = 467110106
	// Indicates user chose no operation.
	SourceInstanceProperties_NONE SourceInstanceProperties_KeyRevocationActionType = 2402104
	// Indicates user chose to opt for VM shutdown on key revocation.
	SourceInstanceProperties_STOP SourceInstanceProperties_KeyRevocationActionType = 2555906
)

// Enum value maps for SourceInstanceProperties_KeyRevocationActionType.
var (
	SourceInstanceProperties_KeyRevocationActionType_name = map[int32]string{
		0:         "UNDEFINED_KEY_REVOCATION_ACTION_TYPE",
		467110106: "KEY_REVOCATION_ACTION_TYPE_UNSPECIFIED",
		2402104:   "NONE",
		2555906:   "STOP",
	}
	SourceInstanceProperties_KeyRevocationActionType_value = map[string]int32{
		"UNDEFINED_KEY_REVOCATION_ACTION_TYPE":   0,
		"KEY_REVOCATION_ACTION_TYPE_UNSPECIFIED": 467110106,
		"NONE":                                   2402104,
		"STOP":                                   2555906,
	}
)

func (x SourceInstanceProperties_KeyRevocationActionType) Enum() *SourceInstanceProperties_KeyRevocationActionType {
	p := new(SourceInstanceProperties_KeyRevocationActionType)
	*p = x
	return p
}

func (x SourceInstanceProperties_KeyRevocationActionType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SourceInstanceProperties_KeyRevocationActionType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[230].Descriptor()
}

func (SourceInstanceProperties_KeyRevocationActionType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[230]
}

func (x SourceInstanceProperties_KeyRevocationActionType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SourceInstanceProperties_KeyRevocationActionType.Descriptor instead.
func (SourceInstanceProperties_KeyRevocationActionType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1156, 0}
}

// (Optional) Specifies the type of SSL certificate, either "SELF_MANAGED" or "MANAGED". If not specified, the certificate is self-managed and the fields certificate and private_key are used.
type SslCertificate_Type int32

const (
	// A value indicating that the enum field is not set.
	SslCertificate_UNDEFINED_TYPE SslCertificate_Type = 0
	// Google-managed SSLCertificate.
	SslCertificate_MANAGED SslCertificate_Type = 479501183
	// Certificate uploaded by user.
	SslCertificate_SELF_MANAGED     SslCertificate_Type = 434437516
	SslCertificate_TYPE_UNSPECIFIED SslCertificate_Type = 437714322
)

// Enum value maps for SslCertificate_Type.
var (
	SslCertificate_Type_name = map[int32]string{
		0:         "UNDEFINED_TYPE",
		479501183: "MANAGED",
		434437516: "SELF_MANAGED",
		437714322: "TYPE_UNSPECIFIED",
	}
	SslCertificate_Type_value = map[string]int32{
		"UNDEFINED_TYPE":   0,
		"MANAGED":          479501183,
		"SELF_MANAGED":     434437516,
		"TYPE_UNSPECIFIED": 437714322,
	}
)

func (x SslCertificate_Type) Enum() *SslCertificate_Type {
	p := new(SslCertificate_Type)
	*p = x
	return p
}

func (x SslCertificate_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SslCertificate_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[231].Descriptor()
}

func (SslCertificate_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[231]
}

func (x SslCertificate_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SslCertificate_Type.Descriptor instead.
func (SslCertificate_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1157, 0}
}

// [Output only] Status of the managed certificate resource.
type SslCertificateManagedSslCertificate_Status int32

const (
	// A value indicating that the enum field is not set.
	SslCertificateManagedSslCertificate_UNDEFINED_STATUS SslCertificateManagedSslCertificate_Status = 0
	// The certificate management is working, and a certificate has been provisioned.
	SslCertificateManagedSslCertificate_ACTIVE                                 SslCertificateManagedSslCertificate_Status = 314733318
	SslCertificateManagedSslCertificate_MANAGED_CERTIFICATE_STATUS_UNSPECIFIED SslCertificateManagedSslCertificate_Status = 474800850
	// The certificate management is working. GCP will attempt to provision the first certificate.
	SslCertificateManagedSslCertificate_PROVISIONING SslCertificateManagedSslCertificate_Status = 290896621
	// Certificate provisioning failed due to an issue with the DNS or load balancing configuration. For details of which domain failed, consult domain_status field.
	SslCertificateManagedSslCertificate_PROVISIONING_FAILED SslCertificateManagedSslCertificate_Status = 76813775
	// Certificate provisioning failed due to an issue with the DNS or load balancing configuration. It won't be retried. To try again delete and create a new managed SslCertificate resource. For details of which domain failed, consult domain_status field.
	SslCertificateManagedSslCertificate_PROVISIONING_FAILED_PERMANENTLY SslCertificateManagedSslCertificate_Status = 275036203
	// Renewal of the certificate has failed due to an issue with the DNS or load balancing configuration. The existing cert is still serving; however, it will expire shortly. To provision a renewed certificate, delete and create a new managed SslCertificate resource. For details on which domain failed, consult domain_status field.
	SslCertificateManagedSslCertificate_RENEWAL_FAILED SslCertificateManagedSslCertificate_Status = 434659076
)

// Enum value maps for SslCertificateManagedSslCertificate_Status.
var (
	SslCertificateManagedSslCertificate_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		314733318: "ACTIVE",
		474800850: "MANAGED_CERTIFICATE_STATUS_UNSPECIFIED",
		290896621: "PROVISIONING",
		76813775:  "PROVISIONING_FAILED",
		275036203: "PROVISIONING_FAILED_PERMANENTLY",
		434659076: "RENEWAL_FAILED",
	}
	SslCertificateManagedSslCertificate_Status_value = map[string]int32{
		"UNDEFINED_STATUS":                       0,
		"ACTIVE":                                 314733318,
		"MANAGED_CERTIFICATE_STATUS_UNSPECIFIED": 474800850,
		"PROVISIONING":                           290896621,
		"PROVISIONING_FAILED":                    76813775,
		"PROVISIONING_FAILED_PERMANENTLY":        275036203,
		"RENEWAL_FAILED":                         434659076,
	}
)

func (x SslCertificateManagedSslCertificate_Status) Enum() *SslCertificateManagedSslCertificate_Status {
	p := new(SslCertificateManagedSslCertificate_Status)
	*p = x
	return p
}

func (x SslCertificateManagedSslCertificate_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SslCertificateManagedSslCertificate_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[232].Descriptor()
}

func (SslCertificateManagedSslCertificate_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[232]
}

func (x SslCertificateManagedSslCertificate_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SslCertificateManagedSslCertificate_Status.Descriptor instead.
func (SslCertificateManagedSslCertificate_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1160, 0}
}

// The minimum version of SSL protocol that can be used by the clients to establish a connection with the load balancer. This can be one of TLS_1_0, TLS_1_1, TLS_1_2.
type SslPolicy_MinTlsVersion int32

const (
	// A value indicating that the enum field is not set.
	SslPolicy_UNDEFINED_MIN_TLS_VERSION SslPolicy_MinTlsVersion = 0
	// TLS 1.0
	SslPolicy_TLS_1_0 SslPolicy_MinTlsVersion = 33116734
	// TLS 1.1
	SslPolicy_TLS_1_1 SslPolicy_MinTlsVersion = 33116735
	// TLS 1.2
	SslPolicy_TLS_1_2 SslPolicy_MinTlsVersion = 33116736
)

// Enum value maps for SslPolicy_MinTlsVersion.
var (
	SslPolicy_MinTlsVersion_name = map[int32]string{
		0:        "UNDEFINED_MIN_TLS_VERSION",
		33116734: "TLS_1_0",
		33116735: "TLS_1_1",
		33116736: "TLS_1_2",
	}
	SslPolicy_MinTlsVersion_value = map[string]int32{
		"UNDEFINED_MIN_TLS_VERSION": 0,
		"TLS_1_0":                   33116734,
		"TLS_1_1":                   33116735,
		"TLS_1_2":                   33116736,
	}
)

func (x SslPolicy_MinTlsVersion) Enum() *SslPolicy_MinTlsVersion {
	p := new(SslPolicy_MinTlsVersion)
	*p = x
	return p
}

func (x SslPolicy_MinTlsVersion) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SslPolicy_MinTlsVersion) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[233].Descriptor()
}

func (SslPolicy_MinTlsVersion) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[233]
}

func (x SslPolicy_MinTlsVersion) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SslPolicy_MinTlsVersion.Descriptor instead.
func (SslPolicy_MinTlsVersion) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1167, 0}
}

// Profile specifies the set of SSL features that can be used by the load balancer when negotiating SSL with clients. This can be one of COMPATIBLE, MODERN, RESTRICTED, or CUSTOM. If using CUSTOM, the set of SSL features to enable must be specified in the customFeatures field.
type SslPolicy_Profile int32

const (
	// A value indicating that the enum field is not set.
	SslPolicy_UNDEFINED_PROFILE SslPolicy_Profile = 0
	// Compatible profile. Allows the broadset set of clients, even those which support only out-of-date SSL features to negotiate with the load balancer.
	SslPolicy_COMPATIBLE SslPolicy_Profile = 179357396
	// Custom profile. Allow only the set of allowed SSL features specified in the customFeatures field.
	SslPolicy_CUSTOM SslPolicy_Profile = 388595569
	// Modern profile. Supports a wide set of SSL features, allowing modern clients to negotiate SSL with the load balancer.
	SslPolicy_MODERN SslPolicy_Profile = 132013855
	// Restricted profile. Supports a reduced set of SSL features, intended to meet stricter compliance requirements.
	SslPolicy_RESTRICTED SslPolicy_Profile = 261551195
)

// Enum value maps for SslPolicy_Profile.
var (
	SslPolicy_Profile_name = map[int32]string{
		0:         "UNDEFINED_PROFILE",
		179357396: "COMPATIBLE",
		388595569: "CUSTOM",
		132013855: "MODERN",
		261551195: "RESTRICTED",
	}
	SslPolicy_Profile_value = map[string]int32{
		"UNDEFINED_PROFILE": 0,
		"COMPATIBLE":        179357396,
		"CUSTOM":            388595569,
		"MODERN":            132013855,
		"RESTRICTED":        261551195,
	}
)

func (x SslPolicy_Profile) Enum() *SslPolicy_Profile {
	p := new(SslPolicy_Profile)
	*p = x
	return p
}

func (x SslPolicy_Profile) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SslPolicy_Profile) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[234].Descriptor()
}

func (SslPolicy_Profile) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[234]
}

func (x SslPolicy_Profile) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SslPolicy_Profile.Descriptor instead.
func (SslPolicy_Profile) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1167, 1}
}

// These stateful disks will never be deleted during autohealing, update or VM instance recreate operations. This flag is used to configure if the disk should be deleted after it is no longer used by the group, e.g. when the given instance or the whole group is deleted. Note: disks attached in READ_ONLY mode cannot be auto-deleted.
type StatefulPolicyPreservedStateDiskDevice_AutoDelete int32

const (
	// A value indicating that the enum field is not set.
	StatefulPolicyPreservedStateDiskDevice_UNDEFINED_AUTO_DELETE          StatefulPolicyPreservedStateDiskDevice_AutoDelete = 0
	StatefulPolicyPreservedStateDiskDevice_NEVER                          StatefulPolicyPreservedStateDiskDevice_AutoDelete = 74175084
	StatefulPolicyPreservedStateDiskDevice_ON_PERMANENT_INSTANCE_DELETION StatefulPolicyPreservedStateDiskDevice_AutoDelete = 95727719
)

// Enum value maps for StatefulPolicyPreservedStateDiskDevice_AutoDelete.
var (
	StatefulPolicyPreservedStateDiskDevice_AutoDelete_name = map[int32]string{
		0:        "UNDEFINED_AUTO_DELETE",
		74175084: "NEVER",
		95727719: "ON_PERMANENT_INSTANCE_DELETION",
	}
	StatefulPolicyPreservedStateDiskDevice_AutoDelete_value = map[string]int32{
		"UNDEFINED_AUTO_DELETE":          0,
		"NEVER":                          74175084,
		"ON_PERMANENT_INSTANCE_DELETION": 95727719,
	}
)

func (x StatefulPolicyPreservedStateDiskDevice_AutoDelete) Enum() *StatefulPolicyPreservedStateDiskDevice_AutoDelete {
	p := new(StatefulPolicyPreservedStateDiskDevice_AutoDelete)
	*p = x
	return p
}

func (x StatefulPolicyPreservedStateDiskDevice_AutoDelete) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StatefulPolicyPreservedStateDiskDevice_AutoDelete) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[235].Descriptor()
}

func (StatefulPolicyPreservedStateDiskDevice_AutoDelete) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[235]
}

func (x StatefulPolicyPreservedStateDiskDevice_AutoDelete) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StatefulPolicyPreservedStateDiskDevice_AutoDelete.Descriptor instead.
func (StatefulPolicyPreservedStateDiskDevice_AutoDelete) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1173, 0}
}

// The access type of IPv6 address this subnet holds. It's immutable and can only be specified during creation or the first time the subnet is updated into IPV4_IPV6 dual stack.
type Subnetwork_Ipv6AccessType int32

const (
	// A value indicating that the enum field is not set.
	Subnetwork_UNDEFINED_IPV6_ACCESS_TYPE Subnetwork_Ipv6AccessType = 0
	// VMs on this subnet will be assigned IPv6 addresses that are accessible via the Internet, as well as the VPC network.
	Subnetwork_EXTERNAL Subnetwork_Ipv6AccessType = 35607499
	// VMs on this subnet will be assigned IPv6 addresses that are only accessible over the VPC network.
	Subnetwork_INTERNAL                     Subnetwork_Ipv6AccessType = 279295677
	Subnetwork_UNSPECIFIED_IPV6_ACCESS_TYPE Subnetwork_Ipv6AccessType = 313080613
)

// Enum value maps for Subnetwork_Ipv6AccessType.
var (
	Subnetwork_Ipv6AccessType_name = map[int32]string{
		0:         "UNDEFINED_IPV6_ACCESS_TYPE",
		35607499:  "EXTERNAL",
		279295677: "INTERNAL",
		313080613: "UNSPECIFIED_IPV6_ACCESS_TYPE",
	}
	Subnetwork_Ipv6AccessType_value = map[string]int32{
		"UNDEFINED_IPV6_ACCESS_TYPE":   0,
		"EXTERNAL":                     35607499,
		"INTERNAL":                     279295677,
		"UNSPECIFIED_IPV6_ACCESS_TYPE": 313080613,
	}
)

func (x Subnetwork_Ipv6AccessType) Enum() *Subnetwork_Ipv6AccessType {
	p := new(Subnetwork_Ipv6AccessType)
	*p = x
	return p
}

func (x Subnetwork_Ipv6AccessType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Subnetwork_Ipv6AccessType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[236].Descriptor()
}

func (Subnetwork_Ipv6AccessType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[236]
}

func (x Subnetwork_Ipv6AccessType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Subnetwork_Ipv6AccessType.Descriptor instead.
func (Subnetwork_Ipv6AccessType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1175, 0}
}

// This field is for internal use. This field can be both set at resource creation time and updated using patch.
type Subnetwork_PrivateIpv6GoogleAccess int32

const (
	// A value indicating that the enum field is not set.
	Subnetwork_UNDEFINED_PRIVATE_IPV6_GOOGLE_ACCESS Subnetwork_PrivateIpv6GoogleAccess = 0
	// Disable private IPv6 access to/from Google services.
	Subnetwork_DISABLE_GOOGLE_ACCESS Subnetwork_PrivateIpv6GoogleAccess = 450958579
	// Bidirectional private IPv6 access to/from Google services.
	Subnetwork_ENABLE_BIDIRECTIONAL_ACCESS_TO_GOOGLE Subnetwork_PrivateIpv6GoogleAccess = 427975994
	// Outbound private IPv6 access from VMs in this subnet to Google services.
	Subnetwork_ENABLE_OUTBOUND_VM_ACCESS_TO_GOOGLE Subnetwork_PrivateIpv6GoogleAccess = 288210263
)

// Enum value maps for Subnetwork_PrivateIpv6GoogleAccess.
var (
	Subnetwork_PrivateIpv6GoogleAccess_name = map[int32]string{
		0:         "UNDEFINED_PRIVATE_IPV6_GOOGLE_ACCESS",
		450958579: "DISABLE_GOOGLE_ACCESS",
		427975994: "ENABLE_BIDIRECTIONAL_ACCESS_TO_GOOGLE",
		288210263: "ENABLE_OUTBOUND_VM_ACCESS_TO_GOOGLE",
	}
	Subnetwork_PrivateIpv6GoogleAccess_value = map[string]int32{
		"UNDEFINED_PRIVATE_IPV6_GOOGLE_ACCESS":  0,
		"DISABLE_GOOGLE_ACCESS":                 450958579,
		"ENABLE_BIDIRECTIONAL_ACCESS_TO_GOOGLE": 427975994,
		"ENABLE_OUTBOUND_VM_ACCESS_TO_GOOGLE":   288210263,
	}
)

func (x Subnetwork_PrivateIpv6GoogleAccess) Enum() *Subnetwork_PrivateIpv6GoogleAccess {
	p := new(Subnetwork_PrivateIpv6GoogleAccess)
	*p = x
	return p
}

func (x Subnetwork_PrivateIpv6GoogleAccess) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Subnetwork_PrivateIpv6GoogleAccess) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[237].Descriptor()
}

func (Subnetwork_PrivateIpv6GoogleAccess) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[237]
}

func (x Subnetwork_PrivateIpv6GoogleAccess) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Subnetwork_PrivateIpv6GoogleAccess.Descriptor instead.
func (Subnetwork_PrivateIpv6GoogleAccess) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1175, 1}
}

// The purpose of the resource. This field can be either PRIVATE_RFC_1918 or INTERNAL_HTTPS_LOAD_BALANCER. A subnetwork with purpose set to INTERNAL_HTTPS_LOAD_BALANCER is a user-created subnetwork that is reserved for Internal HTTP(S) Load Balancing. If unspecified, the purpose defaults to PRIVATE_RFC_1918. The enableFlowLogs field isn't supported with the purpose field set to INTERNAL_HTTPS_LOAD_BALANCER.
type Subnetwork_Purpose int32

const (
	// A value indicating that the enum field is not set.
	Subnetwork_UNDEFINED_PURPOSE Subnetwork_Purpose = 0
	// Subnet reserved for Internal HTTP(S) Load Balancing.
	Subnetwork_INTERNAL_HTTPS_LOAD_BALANCER Subnetwork_Purpose = 248748889
	// Regular user created or automatically created subnet.
	Subnetwork_PRIVATE Subnetwork_Purpose = 403485027
	// Regular user created or automatically created subnet.
	Subnetwork_PRIVATE_RFC_1918 Subnetwork_Purpose = 254902107
	// Subnetworks created for Private Service Connect in the producer network.
	Subnetwork_PRIVATE_SERVICE_CONNECT Subnetwork_Purpose = 48134724
	// Subnetwork used for Regional Internal/External HTTP(S) Load Balancing.
	Subnetwork_REGIONAL_MANAGED_PROXY Subnetwork_Purpose = 153049966
)

// Enum value maps for Subnetwork_Purpose.
var (
	Subnetwork_Purpose_name = map[int32]string{
		0:         "UNDEFINED_PURPOSE",
		248748889: "INTERNAL_HTTPS_LOAD_BALANCER",
		403485027: "PRIVATE",
		254902107: "PRIVATE_RFC_1918",
		48134724:  "PRIVATE_SERVICE_CONNECT",
		153049966: "REGIONAL_MANAGED_PROXY",
	}
	Subnetwork_Purpose_value = map[string]int32{
		"UNDEFINED_PURPOSE":            0,
		"INTERNAL_HTTPS_LOAD_BALANCER": 248748889,
		"PRIVATE":                      403485027,
		"PRIVATE_RFC_1918":             254902107,
		"PRIVATE_SERVICE_CONNECT":      48134724,
		"REGIONAL_MANAGED_PROXY":       153049966,
	}
)

func (x Subnetwork_Purpose) Enum() *Subnetwork_Purpose {
	p := new(Subnetwork_Purpose)
	*p = x
	return p
}

func (x Subnetwork_Purpose) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Subnetwork_Purpose) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[238].Descriptor()
}

func (Subnetwork_Purpose) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[238]
}

func (x Subnetwork_Purpose) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Subnetwork_Purpose.Descriptor instead.
func (Subnetwork_Purpose) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1175, 2}
}

// The role of subnetwork. Currently, this field is only used when purpose = INTERNAL_HTTPS_LOAD_BALANCER. The value can be set to ACTIVE or BACKUP. An ACTIVE subnetwork is one that is currently being used for Internal HTTP(S) Load Balancing. A BACKUP subnetwork is one that is ready to be promoted to ACTIVE or is currently draining. This field can be updated with a patch request.
type Subnetwork_Role int32

const (
	// A value indicating that the enum field is not set.
	Subnetwork_UNDEFINED_ROLE Subnetwork_Role = 0
	// The ACTIVE subnet that is currently used.
	Subnetwork_ACTIVE Subnetwork_Role = 314733318
	// The BACKUP subnet that could be promoted to ACTIVE.
	Subnetwork_BACKUP Subnetwork_Role = 341010882
)

// Enum value maps for Subnetwork_Role.
var (
	Subnetwork_Role_name = map[int32]string{
		0:         "UNDEFINED_ROLE",
		314733318: "ACTIVE",
		341010882: "BACKUP",
	}
	Subnetwork_Role_value = map[string]int32{
		"UNDEFINED_ROLE": 0,
		"ACTIVE":         314733318,
		"BACKUP":         341010882,
	}
)

func (x Subnetwork_Role) Enum() *Subnetwork_Role {
	p := new(Subnetwork_Role)
	*p = x
	return p
}

func (x Subnetwork_Role) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Subnetwork_Role) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[239].Descriptor()
}

func (Subnetwork_Role) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[239]
}

func (x Subnetwork_Role) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Subnetwork_Role.Descriptor instead.
func (Subnetwork_Role) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1175, 3}
}

// The stack type for the subnet. If set to IPV4_ONLY, new VMs in the subnet are assigned IPv4 addresses only. If set to IPV4_IPV6, new VMs in the subnet can be assigned both IPv4 and IPv6 addresses. If not specified, IPV4_ONLY is used. This field can be both set at resource creation time and updated using patch.
type Subnetwork_StackType int32

const (
	// A value indicating that the enum field is not set.
	Subnetwork_UNDEFINED_STACK_TYPE Subnetwork_StackType = 0
	// New VMs in this subnet can have both IPv4 and IPv6 addresses.
	Subnetwork_IPV4_IPV6 Subnetwork_StackType = 22197249
	// New VMs in this subnet will only be assigned IPv4 addresses.
	Subnetwork_IPV4_ONLY              Subnetwork_StackType = 22373798
	Subnetwork_UNSPECIFIED_STACK_TYPE Subnetwork_StackType = 298084569
)

// Enum value maps for Subnetwork_StackType.
var (
	Subnetwork_StackType_name = map[int32]string{
		0:         "UNDEFINED_STACK_TYPE",
		22197249:  "IPV4_IPV6",
		22373798:  "IPV4_ONLY",
		298084569: "UNSPECIFIED_STACK_TYPE",
	}
	Subnetwork_StackType_value = map[string]int32{
		"UNDEFINED_STACK_TYPE":   0,
		"IPV4_IPV6":              22197249,
		"IPV4_ONLY":              22373798,
		"UNSPECIFIED_STACK_TYPE": 298084569,
	}
)

func (x Subnetwork_StackType) Enum() *Subnetwork_StackType {
	p := new(Subnetwork_StackType)
	*p = x
	return p
}

func (x Subnetwork_StackType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Subnetwork_StackType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[240].Descriptor()
}

func (Subnetwork_StackType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[240]
}

func (x Subnetwork_StackType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Subnetwork_StackType.Descriptor instead.
func (Subnetwork_StackType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1175, 4}
}

// [Output Only] The state of the subnetwork, which can be one of the following values: READY: Subnetwork is created and ready to use DRAINING: only applicable to subnetworks that have the purpose set to INTERNAL_HTTPS_LOAD_BALANCER and indicates that connections to the load balancer are being drained. A subnetwork that is draining cannot be used or modified until it reaches a status of READY
type Subnetwork_State int32

const (
	// A value indicating that the enum field is not set.
	Subnetwork_UNDEFINED_STATE Subnetwork_State = 0
	// Subnetwork is being drained.
	Subnetwork_DRAINING Subnetwork_State = 480455402
	// Subnetwork is ready for use.
	Subnetwork_READY Subnetwork_State = 77848963
)

// Enum value maps for Subnetwork_State.
var (
	Subnetwork_State_name = map[int32]string{
		0:         "UNDEFINED_STATE",
		480455402: "DRAINING",
		77848963:  "READY",
	}
	Subnetwork_State_value = map[string]int32{
		"UNDEFINED_STATE": 0,
		"DRAINING":        480455402,
		"READY":           77848963,
	}
)

func (x Subnetwork_State) Enum() *Subnetwork_State {
	p := new(Subnetwork_State)
	*p = x
	return p
}

func (x Subnetwork_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Subnetwork_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[241].Descriptor()
}

func (Subnetwork_State) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[241]
}

func (x Subnetwork_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Subnetwork_State.Descriptor instead.
func (Subnetwork_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1175, 5}
}

// Can only be specified if VPC flow logging for this subnetwork is enabled. Toggles the aggregation interval for collecting flow logs. Increasing the interval time will reduce the amount of generated flow logs for long lasting connections. Default is an interval of 5 seconds per connection.
type SubnetworkLogConfig_AggregationInterval int32

const (
	// A value indicating that the enum field is not set.
	SubnetworkLogConfig_UNDEFINED_AGGREGATION_INTERVAL SubnetworkLogConfig_AggregationInterval = 0
	SubnetworkLogConfig_INTERVAL_10_MIN                SubnetworkLogConfig_AggregationInterval = 487155916
	SubnetworkLogConfig_INTERVAL_15_MIN                SubnetworkLogConfig_AggregationInterval = 491773521
	SubnetworkLogConfig_INTERVAL_1_MIN                 SubnetworkLogConfig_AggregationInterval = 69052714
	SubnetworkLogConfig_INTERVAL_30_SEC                SubnetworkLogConfig_AggregationInterval = 7548937
	SubnetworkLogConfig_INTERVAL_5_MIN                 SubnetworkLogConfig_AggregationInterval = 72746798
	SubnetworkLogConfig_INTERVAL_5_SEC                 SubnetworkLogConfig_AggregationInterval = 72752429
)

// Enum value maps for SubnetworkLogConfig_AggregationInterval.
var (
	SubnetworkLogConfig_AggregationInterval_name = map[int32]string{
		0:         "UNDEFINED_AGGREGATION_INTERVAL",
		487155916: "INTERVAL_10_MIN",
		491773521: "INTERVAL_15_MIN",
		69052714:  "INTERVAL_1_MIN",
		7548937:   "INTERVAL_30_SEC",
		72746798:  "INTERVAL_5_MIN",
		72752429:  "INTERVAL_5_SEC",
	}
	SubnetworkLogConfig_AggregationInterval_value = map[string]int32{
		"UNDEFINED_AGGREGATION_INTERVAL": 0,
		"INTERVAL_10_MIN":                487155916,
		"INTERVAL_15_MIN":                491773521,
		"INTERVAL_1_MIN":                 69052714,
		"INTERVAL_30_SEC":                7548937,
		"INTERVAL_5_MIN":                 72746798,
		"INTERVAL_5_SEC":                 72752429,
	}
)

func (x SubnetworkLogConfig_AggregationInterval) Enum() *SubnetworkLogConfig_AggregationInterval {
	p := new(SubnetworkLogConfig_AggregationInterval)
	*p = x
	return p
}

func (x SubnetworkLogConfig_AggregationInterval) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SubnetworkLogConfig_AggregationInterval) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[242].Descriptor()
}

func (SubnetworkLogConfig_AggregationInterval) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[242]
}

func (x SubnetworkLogConfig_AggregationInterval) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SubnetworkLogConfig_AggregationInterval.Descriptor instead.
func (SubnetworkLogConfig_AggregationInterval) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1178, 0}
}

// Can only be specified if VPC flow logs for this subnetwork is enabled. Configures whether all, none or a subset of metadata fields should be added to the reported VPC flow logs. Default is EXCLUDE_ALL_METADATA.
type SubnetworkLogConfig_Metadata int32

const (
	// A value indicating that the enum field is not set.
	SubnetworkLogConfig_UNDEFINED_METADATA   SubnetworkLogConfig_Metadata = 0
	SubnetworkLogConfig_CUSTOM_METADATA      SubnetworkLogConfig_Metadata = 62450749
	SubnetworkLogConfig_EXCLUDE_ALL_METADATA SubnetworkLogConfig_Metadata = 334519954
	SubnetworkLogConfig_INCLUDE_ALL_METADATA SubnetworkLogConfig_Metadata = 164619908
)

// Enum value maps for SubnetworkLogConfig_Metadata.
var (
	SubnetworkLogConfig_Metadata_name = map[int32]string{
		0:         "UNDEFINED_METADATA",
		62450749:  "CUSTOM_METADATA",
		334519954: "EXCLUDE_ALL_METADATA",
		164619908: "INCLUDE_ALL_METADATA",
	}
	SubnetworkLogConfig_Metadata_value = map[string]int32{
		"UNDEFINED_METADATA":   0,
		"CUSTOM_METADATA":      62450749,
		"EXCLUDE_ALL_METADATA": 334519954,
		"INCLUDE_ALL_METADATA": 164619908,
	}
)

func (x SubnetworkLogConfig_Metadata) Enum() *SubnetworkLogConfig_Metadata {
	p := new(SubnetworkLogConfig_Metadata)
	*p = x
	return p
}

func (x SubnetworkLogConfig_Metadata) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SubnetworkLogConfig_Metadata) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[243].Descriptor()
}

func (SubnetworkLogConfig_Metadata) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[243]
}

func (x SubnetworkLogConfig_Metadata) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SubnetworkLogConfig_Metadata.Descriptor instead.
func (SubnetworkLogConfig_Metadata) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1178, 1}
}

type Subsetting_Policy int32

const (
	// A value indicating that the enum field is not set.
	Subsetting_UNDEFINED_POLICY Subsetting_Policy = 0
	// Subsetting based on consistent hashing. For Traffic Director, the number of backends per backend group (the subset size) is based on the `subset_size` parameter. For Internal HTTP(S) load balancing, the number of backends per backend group (the subset size) is dynamically adjusted in two cases: - As the number of proxy instances participating in Internal HTTP(S) load balancing increases, the subset size decreases. - When the total number of backends in a network exceeds the capacity of a single proxy instance, subset sizes are reduced automatically for each service that has backend subsetting enabled.
	Subsetting_CONSISTENT_HASH_SUBSETTING Subsetting_Policy = 108989492
	// No Subsetting. Clients may open connections and send traffic to all backends of this backend service. This can lead to performance issues if there is substantial imbalance in the count of clients and backends.
	Subsetting_NONE Subsetting_Policy = 2402104
)

// Enum value maps for Subsetting_Policy.
var (
	Subsetting_Policy_name = map[int32]string{
		0:         "UNDEFINED_POLICY",
		108989492: "CONSISTENT_HASH_SUBSETTING",
		2402104:   "NONE",
	}
	Subsetting_Policy_value = map[string]int32{
		"UNDEFINED_POLICY":           0,
		"CONSISTENT_HASH_SUBSETTING": 108989492,
		"NONE":                       2402104,
	}
)

func (x Subsetting_Policy) Enum() *Subsetting_Policy {
	p := new(Subsetting_Policy)
	*p = x
	return p
}

func (x Subsetting_Policy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Subsetting_Policy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[244].Descriptor()
}

func (Subsetting_Policy) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[244]
}

func (x Subsetting_Policy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Subsetting_Policy.Descriptor instead.
func (Subsetting_Policy) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1183, 0}
}

// Specifies how a port is selected for health checking. Can be one of the following values: USE_FIXED_PORT: Specifies a port number explicitly using the port field in the health check. Supported by backend services for pass-through load balancers and backend services for proxy load balancers. Not supported by target pools. The health check supports all backends supported by the backend service provided the backend can be health checked. For example, GCE_VM_IP network endpoint groups, GCE_VM_IP_PORT network endpoint groups, and instance group backends. USE_NAMED_PORT: Not supported. USE_SERVING_PORT: Provides an indirect method of specifying the health check port by referring to the backend service. Only supported by backend services for proxy load balancers. Not supported by target pools. Not supported by backend services for pass-through load balancers. Supports all backends that can be health checked; for example, GCE_VM_IP_PORT network endpoint groups and instance group backends. For GCE_VM_IP_PORT network endpoint group backends, the health check uses the port number specified for each endpoint in the network endpoint group. For instance group backends, the health check uses the port number determined by looking up the backend service's named port in the instance group's list of named ports.
type TCPHealthCheck_PortSpecification int32

const (
	// A value indicating that the enum field is not set.
	TCPHealthCheck_UNDEFINED_PORT_SPECIFICATION TCPHealthCheck_PortSpecification = 0
	// The port number in the health check's port is used for health checking. Applies to network endpoint group and instance group backends.
	TCPHealthCheck_USE_FIXED_PORT TCPHealthCheck_PortSpecification = 190235748
	// Not supported.
	TCPHealthCheck_USE_NAMED_PORT TCPHealthCheck_PortSpecification = 349300671
	// For network endpoint group backends, the health check uses the port number specified on each endpoint in the network endpoint group. For instance group backends, the health check uses the port number specified for the backend service's named port defined in the instance group's named ports.
	TCPHealthCheck_USE_SERVING_PORT TCPHealthCheck_PortSpecification = 362637516
)

// Enum value maps for TCPHealthCheck_PortSpecification.
var (
	TCPHealthCheck_PortSpecification_name = map[int32]string{
		0:         "UNDEFINED_PORT_SPECIFICATION",
		190235748: "USE_FIXED_PORT",
		349300671: "USE_NAMED_PORT",
		362637516: "USE_SERVING_PORT",
	}
	TCPHealthCheck_PortSpecification_value = map[string]int32{
		"UNDEFINED_PORT_SPECIFICATION": 0,
		"USE_FIXED_PORT":               190235748,
		"USE_NAMED_PORT":               349300671,
		"USE_SERVING_PORT":             362637516,
	}
)

func (x TCPHealthCheck_PortSpecification) Enum() *TCPHealthCheck_PortSpecification {
	p := new(TCPHealthCheck_PortSpecification)
	*p = x
	return p
}

func (x TCPHealthCheck_PortSpecification) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TCPHealthCheck_PortSpecification) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[245].Descriptor()
}

func (TCPHealthCheck_PortSpecification) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[245]
}

func (x TCPHealthCheck_PortSpecification) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TCPHealthCheck_PortSpecification.Descriptor instead.
func (TCPHealthCheck_PortSpecification) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1186, 0}
}

// Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
type TCPHealthCheck_ProxyHeader int32

const (
	// A value indicating that the enum field is not set.
	TCPHealthCheck_UNDEFINED_PROXY_HEADER TCPHealthCheck_ProxyHeader = 0
	TCPHealthCheck_NONE                   TCPHealthCheck_ProxyHeader = 2402104
	TCPHealthCheck_PROXY_V1               TCPHealthCheck_ProxyHeader = 334352940
)

// Enum value maps for TCPHealthCheck_ProxyHeader.
var (
	TCPHealthCheck_ProxyHeader_name = map[int32]string{
		0:         "UNDEFINED_PROXY_HEADER",
		2402104:   "NONE",
		334352940: "PROXY_V1",
	}
	TCPHealthCheck_ProxyHeader_value = map[string]int32{
		"UNDEFINED_PROXY_HEADER": 0,
		"NONE":                   2402104,
		"PROXY_V1":               334352940,
	}
)

func (x TCPHealthCheck_ProxyHeader) Enum() *TCPHealthCheck_ProxyHeader {
	p := new(TCPHealthCheck_ProxyHeader)
	*p = x
	return p
}

func (x TCPHealthCheck_ProxyHeader) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TCPHealthCheck_ProxyHeader) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[246].Descriptor()
}

func (TCPHealthCheck_ProxyHeader) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[246]
}

func (x TCPHealthCheck_ProxyHeader) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TCPHealthCheck_ProxyHeader.Descriptor instead.
func (TCPHealthCheck_ProxyHeader) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1186, 1}
}

// QUIC policy for the TargetHttpsProxy resource.
type TargetHttpsProxiesSetQuicOverrideRequest_QuicOverride int32

const (
	// A value indicating that the enum field is not set.
	TargetHttpsProxiesSetQuicOverrideRequest_UNDEFINED_QUIC_OVERRIDE TargetHttpsProxiesSetQuicOverrideRequest_QuicOverride = 0
	// The load balancer will not attempt to negotiate QUIC with clients.
	TargetHttpsProxiesSetQuicOverrideRequest_DISABLE TargetHttpsProxiesSetQuicOverrideRequest_QuicOverride = 241807048
	// The load balancer will attempt to negotiate QUIC with clients.
	TargetHttpsProxiesSetQuicOverrideRequest_ENABLE TargetHttpsProxiesSetQuicOverrideRequest_QuicOverride = 438835587
	// No overrides to the default QUIC policy. This option is implicit if no QUIC override has been specified in the request.
	TargetHttpsProxiesSetQuicOverrideRequest_NONE TargetHttpsProxiesSetQuicOverrideRequest_QuicOverride = 2402104
)

// Enum value maps for TargetHttpsProxiesSetQuicOverrideRequest_QuicOverride.
var (
	TargetHttpsProxiesSetQuicOverrideRequest_QuicOverride_name = map[int32]string{
		0:         "UNDEFINED_QUIC_OVERRIDE",
		241807048: "DISABLE",
		438835587: "ENABLE",
		2402104:   "NONE",
	}
	TargetHttpsProxiesSetQuicOverrideRequest_QuicOverride_value = map[string]int32{
		"UNDEFINED_QUIC_OVERRIDE": 0,
		"DISABLE":                 241807048,
		"ENABLE":                  438835587,
		"NONE":                    2402104,
	}
)

func (x TargetHttpsProxiesSetQuicOverrideRequest_QuicOverride) Enum() *TargetHttpsProxiesSetQuicOverrideRequest_QuicOverride {
	p := new(TargetHttpsProxiesSetQuicOverrideRequest_QuicOverride)
	*p = x
	return p
}

func (x TargetHttpsProxiesSetQuicOverrideRequest_QuicOverride) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TargetHttpsProxiesSetQuicOverrideRequest_QuicOverride) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[247].Descriptor()
}

func (TargetHttpsProxiesSetQuicOverrideRequest_QuicOverride) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[247]
}

func (x TargetHttpsProxiesSetQuicOverrideRequest_QuicOverride) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TargetHttpsProxiesSetQuicOverrideRequest_QuicOverride.Descriptor instead.
func (TargetHttpsProxiesSetQuicOverrideRequest_QuicOverride) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1196, 0}
}

// Specifies the QUIC override policy for this TargetHttpsProxy resource. This setting determines whether the load balancer attempts to negotiate QUIC with clients. You can specify NONE, ENABLE, or DISABLE. - When quic-override is set to NONE, Google manages whether QUIC is used. - When quic-override is set to ENABLE, the load balancer uses QUIC when possible. - When quic-override is set to DISABLE, the load balancer doesn't use QUIC. - If the quic-override flag is not specified, NONE is implied.
type TargetHttpsProxy_QuicOverride int32

const (
	// A value indicating that the enum field is not set.
	TargetHttpsProxy_UNDEFINED_QUIC_OVERRIDE TargetHttpsProxy_QuicOverride = 0
	// The load balancer will not attempt to negotiate QUIC with clients.
	TargetHttpsProxy_DISABLE TargetHttpsProxy_QuicOverride = 241807048
	// The load balancer will attempt to negotiate QUIC with clients.
	TargetHttpsProxy_ENABLE TargetHttpsProxy_QuicOverride = 438835587
	// No overrides to the default QUIC policy. This option is implicit if no QUIC override has been specified in the request.
	TargetHttpsProxy_NONE TargetHttpsProxy_QuicOverride = 2402104
)

// Enum value maps for TargetHttpsProxy_QuicOverride.
var (
	TargetHttpsProxy_QuicOverride_name = map[int32]string{
		0:         "UNDEFINED_QUIC_OVERRIDE",
		241807048: "DISABLE",
		438835587: "ENABLE",
		2402104:   "NONE",
	}
	TargetHttpsProxy_QuicOverride_value = map[string]int32{
		"UNDEFINED_QUIC_OVERRIDE": 0,
		"DISABLE":                 241807048,
		"ENABLE":                  438835587,
		"NONE":                    2402104,
	}
)

func (x TargetHttpsProxy_QuicOverride) Enum() *TargetHttpsProxy_QuicOverride {
	p := new(TargetHttpsProxy_QuicOverride)
	*p = x
	return p
}

func (x TargetHttpsProxy_QuicOverride) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TargetHttpsProxy_QuicOverride) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[248].Descriptor()
}

func (TargetHttpsProxy_QuicOverride) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[248]
}

func (x TargetHttpsProxy_QuicOverride) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TargetHttpsProxy_QuicOverride.Descriptor instead.
func (TargetHttpsProxy_QuicOverride) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1198, 0}
}

// Must have a value of NO_NAT. Protocol forwarding delivers packets while preserving the destination IP address of the forwarding rule referencing the target instance.
type TargetInstance_NatPolicy int32

const (
	// A value indicating that the enum field is not set.
	TargetInstance_UNDEFINED_NAT_POLICY TargetInstance_NatPolicy = 0
	// No NAT performed.
	TargetInstance_NO_NAT TargetInstance_NatPolicy = 161455491
)

// Enum value maps for TargetInstance_NatPolicy.
var (
	TargetInstance_NatPolicy_name = map[int32]string{
		0:         "UNDEFINED_NAT_POLICY",
		161455491: "NO_NAT",
	}
	TargetInstance_NatPolicy_value = map[string]int32{
		"UNDEFINED_NAT_POLICY": 0,
		"NO_NAT":               161455491,
	}
)

func (x TargetInstance_NatPolicy) Enum() *TargetInstance_NatPolicy {
	p := new(TargetInstance_NatPolicy)
	*p = x
	return p
}

func (x TargetInstance_NatPolicy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TargetInstance_NatPolicy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[249].Descriptor()
}

func (TargetInstance_NatPolicy) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[249]
}

func (x TargetInstance_NatPolicy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TargetInstance_NatPolicy.Descriptor instead.
func (TargetInstance_NatPolicy) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1201, 0}
}

// Session affinity option, must be one of the following values: NONE: Connections from the same client IP may go to any instance in the pool. CLIENT_IP: Connections from the same client IP will go to the same instance in the pool while that instance remains healthy. CLIENT_IP_PROTO: Connections from the same client IP with the same IP protocol will go to the same instance in the pool while that instance remains healthy.
type TargetPool_SessionAffinity int32

const (
	// A value indicating that the enum field is not set.
	TargetPool_UNDEFINED_SESSION_AFFINITY TargetPool_SessionAffinity = 0
	// 2-tuple hash on packet's source and destination IP addresses. Connections from the same source IP address to the same destination IP address will be served by the same backend VM while that VM remains healthy.
	TargetPool_CLIENT_IP TargetPool_SessionAffinity = 345665051
	// 1-tuple hash only on packet's source IP address. Connections from the same source IP address will be served by the same backend VM while that VM remains healthy. This option can only be used for Internal TCP/UDP Load Balancing.
	TargetPool_CLIENT_IP_NO_DESTINATION TargetPool_SessionAffinity = 106122516
	// 5-tuple hash on packet's source and destination IP addresses, IP protocol, and source and destination ports. Connections for the same IP protocol from the same source IP address and port to the same destination IP address and port will be served by the same backend VM while that VM remains healthy. This option cannot be used for HTTP(S) load balancing.
	TargetPool_CLIENT_IP_PORT_PROTO TargetPool_SessionAffinity = 221722926
	// 3-tuple hash on packet's source and destination IP addresses, and IP protocol. Connections for the same IP protocol from the same source IP address to the same destination IP address will be served by the same backend VM while that VM remains healthy. This option cannot be used for HTTP(S) load balancing.
	TargetPool_CLIENT_IP_PROTO TargetPool_SessionAffinity = 25322148
	// Hash based on a cookie generated by the L7 loadbalancer. Only valid for HTTP(S) load balancing.
	TargetPool_GENERATED_COOKIE TargetPool_SessionAffinity = 370321204
	// The hash is based on a user specified header field.
	TargetPool_HEADER_FIELD TargetPool_SessionAffinity = 200737960
	// The hash is based on a user provided cookie.
	TargetPool_HTTP_COOKIE TargetPool_SessionAffinity = 494981627
	// No session affinity. Connections from the same client IP may go to any instance in the pool.
	TargetPool_NONE TargetPool_SessionAffinity = 2402104
)

// Enum value maps for TargetPool_SessionAffinity.
var (
	TargetPool_SessionAffinity_name = map[int32]string{
		0:         "UNDEFINED_SESSION_AFFINITY",
		345665051: "CLIENT_IP",
		106122516: "CLIENT_IP_NO_DESTINATION",
		221722926: "CLIENT_IP_PORT_PROTO",
		25322148:  "CLIENT_IP_PROTO",
		370321204: "GENERATED_COOKIE",
		200737960: "HEADER_FIELD",
		494981627: "HTTP_COOKIE",
		2402104:   "NONE",
	}
	TargetPool_SessionAffinity_value = map[string]int32{
		"UNDEFINED_SESSION_AFFINITY": 0,
		"CLIENT_IP":                  345665051,
		"CLIENT_IP_NO_DESTINATION":   106122516,
		"CLIENT_IP_PORT_PROTO":       221722926,
		"CLIENT_IP_PROTO":            25322148,
		"GENERATED_COOKIE":           370321204,
		"HEADER_FIELD":               200737960,
		"HTTP_COOKIE":                494981627,
		"NONE":                       2402104,
	}
)

func (x TargetPool_SessionAffinity) Enum() *TargetPool_SessionAffinity {
	p := new(TargetPool_SessionAffinity)
	*p = x
	return p
}

func (x TargetPool_SessionAffinity) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TargetPool_SessionAffinity) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[250].Descriptor()
}

func (TargetPool_SessionAffinity) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[250]
}

func (x TargetPool_SessionAffinity) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TargetPool_SessionAffinity.Descriptor instead.
func (TargetPool_SessionAffinity) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1205, 0}
}

// The new type of proxy header to append before sending data to the backend. NONE or PROXY_V1 are allowed.
type TargetSslProxiesSetProxyHeaderRequest_ProxyHeader int32

const (
	// A value indicating that the enum field is not set.
	TargetSslProxiesSetProxyHeaderRequest_UNDEFINED_PROXY_HEADER TargetSslProxiesSetProxyHeaderRequest_ProxyHeader = 0
	TargetSslProxiesSetProxyHeaderRequest_NONE                   TargetSslProxiesSetProxyHeaderRequest_ProxyHeader = 2402104
	TargetSslProxiesSetProxyHeaderRequest_PROXY_V1               TargetSslProxiesSetProxyHeaderRequest_ProxyHeader = 334352940
)

// Enum value maps for TargetSslProxiesSetProxyHeaderRequest_ProxyHeader.
var (
	TargetSslProxiesSetProxyHeaderRequest_ProxyHeader_name = map[int32]string{
		0:         "UNDEFINED_PROXY_HEADER",
		2402104:   "NONE",
		334352940: "PROXY_V1",
	}
	TargetSslProxiesSetProxyHeaderRequest_ProxyHeader_value = map[string]int32{
		"UNDEFINED_PROXY_HEADER": 0,
		"NONE":                   2402104,
		"PROXY_V1":               334352940,
	}
)

func (x TargetSslProxiesSetProxyHeaderRequest_ProxyHeader) Enum() *TargetSslProxiesSetProxyHeaderRequest_ProxyHeader {
	p := new(TargetSslProxiesSetProxyHeaderRequest_ProxyHeader)
	*p = x
	return p
}

func (x TargetSslProxiesSetProxyHeaderRequest_ProxyHeader) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TargetSslProxiesSetProxyHeaderRequest_ProxyHeader) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[251].Descriptor()
}

func (TargetSslProxiesSetProxyHeaderRequest_ProxyHeader) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[251]
}

func (x TargetSslProxiesSetProxyHeaderRequest_ProxyHeader) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TargetSslProxiesSetProxyHeaderRequest_ProxyHeader.Descriptor instead.
func (TargetSslProxiesSetProxyHeaderRequest_ProxyHeader) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1217, 0}
}

// Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
type TargetSslProxy_ProxyHeader int32

const (
	// A value indicating that the enum field is not set.
	TargetSslProxy_UNDEFINED_PROXY_HEADER TargetSslProxy_ProxyHeader = 0
	TargetSslProxy_NONE                   TargetSslProxy_ProxyHeader = 2402104
	TargetSslProxy_PROXY_V1               TargetSslProxy_ProxyHeader = 334352940
)

// Enum value maps for TargetSslProxy_ProxyHeader.
var (
	TargetSslProxy_ProxyHeader_name = map[int32]string{
		0:         "UNDEFINED_PROXY_HEADER",
		2402104:   "NONE",
		334352940: "PROXY_V1",
	}
	TargetSslProxy_ProxyHeader_value = map[string]int32{
		"UNDEFINED_PROXY_HEADER": 0,
		"NONE":                   2402104,
		"PROXY_V1":               334352940,
	}
)

func (x TargetSslProxy_ProxyHeader) Enum() *TargetSslProxy_ProxyHeader {
	p := new(TargetSslProxy_ProxyHeader)
	*p = x
	return p
}

func (x TargetSslProxy_ProxyHeader) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TargetSslProxy_ProxyHeader) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[252].Descriptor()
}

func (TargetSslProxy_ProxyHeader) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[252]
}

func (x TargetSslProxy_ProxyHeader) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TargetSslProxy_ProxyHeader.Descriptor instead.
func (TargetSslProxy_ProxyHeader) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1219, 0}
}

// The new type of proxy header to append before sending data to the backend. NONE or PROXY_V1 are allowed.
type TargetTcpProxiesSetProxyHeaderRequest_ProxyHeader int32

const (
	// A value indicating that the enum field is not set.
	TargetTcpProxiesSetProxyHeaderRequest_UNDEFINED_PROXY_HEADER TargetTcpProxiesSetProxyHeaderRequest_ProxyHeader = 0
	TargetTcpProxiesSetProxyHeaderRequest_NONE                   TargetTcpProxiesSetProxyHeaderRequest_ProxyHeader = 2402104
	TargetTcpProxiesSetProxyHeaderRequest_PROXY_V1               TargetTcpProxiesSetProxyHeaderRequest_ProxyHeader = 334352940
)

// Enum value maps for TargetTcpProxiesSetProxyHeaderRequest_ProxyHeader.
var (
	TargetTcpProxiesSetProxyHeaderRequest_ProxyHeader_name = map[int32]string{
		0:         "UNDEFINED_PROXY_HEADER",
		2402104:   "NONE",
		334352940: "PROXY_V1",
	}
	TargetTcpProxiesSetProxyHeaderRequest_ProxyHeader_value = map[string]int32{
		"UNDEFINED_PROXY_HEADER": 0,
		"NONE":                   2402104,
		"PROXY_V1":               334352940,
	}
)

func (x TargetTcpProxiesSetProxyHeaderRequest_ProxyHeader) Enum() *TargetTcpProxiesSetProxyHeaderRequest_ProxyHeader {
	p := new(TargetTcpProxiesSetProxyHeaderRequest_ProxyHeader)
	*p = x
	return p
}

func (x TargetTcpProxiesSetProxyHeaderRequest_ProxyHeader) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TargetTcpProxiesSetProxyHeaderRequest_ProxyHeader) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[253].Descriptor()
}

func (TargetTcpProxiesSetProxyHeaderRequest_ProxyHeader) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[253]
}

func (x TargetTcpProxiesSetProxyHeaderRequest_ProxyHeader) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TargetTcpProxiesSetProxyHeaderRequest_ProxyHeader.Descriptor instead.
func (TargetTcpProxiesSetProxyHeaderRequest_ProxyHeader) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1223, 0}
}

// Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
type TargetTcpProxy_ProxyHeader int32

const (
	// A value indicating that the enum field is not set.
	TargetTcpProxy_UNDEFINED_PROXY_HEADER TargetTcpProxy_ProxyHeader = 0
	TargetTcpProxy_NONE                   TargetTcpProxy_ProxyHeader = 2402104
	TargetTcpProxy_PROXY_V1               TargetTcpProxy_ProxyHeader = 334352940
)

// Enum value maps for TargetTcpProxy_ProxyHeader.
var (
	TargetTcpProxy_ProxyHeader_name = map[int32]string{
		0:         "UNDEFINED_PROXY_HEADER",
		2402104:   "NONE",
		334352940: "PROXY_V1",
	}
	TargetTcpProxy_ProxyHeader_value = map[string]int32{
		"UNDEFINED_PROXY_HEADER": 0,
		"NONE":                   2402104,
		"PROXY_V1":               334352940,
	}
)

func (x TargetTcpProxy_ProxyHeader) Enum() *TargetTcpProxy_ProxyHeader {
	p := new(TargetTcpProxy_ProxyHeader)
	*p = x
	return p
}

func (x TargetTcpProxy_ProxyHeader) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TargetTcpProxy_ProxyHeader) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[254].Descriptor()
}

func (TargetTcpProxy_ProxyHeader) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[254]
}

func (x TargetTcpProxy_ProxyHeader) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TargetTcpProxy_ProxyHeader.Descriptor instead.
func (TargetTcpProxy_ProxyHeader) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1224, 0}
}

// [Output Only] The status of the VPN gateway, which can be one of the following: CREATING, READY, FAILED, or DELETING.
type TargetVpnGateway_Status int32

const (
	// A value indicating that the enum field is not set.
	TargetVpnGateway_UNDEFINED_STATUS TargetVpnGateway_Status = 0
	TargetVpnGateway_CREATING         TargetVpnGateway_Status = 455564985
	TargetVpnGateway_DELETING         TargetVpnGateway_Status = 528602024
	TargetVpnGateway_FAILED           TargetVpnGateway_Status = 455706685
	TargetVpnGateway_READY            TargetVpnGateway_Status = 77848963
)

// Enum value maps for TargetVpnGateway_Status.
var (
	TargetVpnGateway_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		455564985: "CREATING",
		528602024: "DELETING",
		455706685: "FAILED",
		77848963:  "READY",
	}
	TargetVpnGateway_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"CREATING":         455564985,
		"DELETING":         528602024,
		"FAILED":           455706685,
		"READY":            77848963,
	}
)

func (x TargetVpnGateway_Status) Enum() *TargetVpnGateway_Status {
	p := new(TargetVpnGateway_Status)
	*p = x
	return p
}

func (x TargetVpnGateway_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TargetVpnGateway_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[255].Descriptor()
}

func (TargetVpnGateway_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[255]
}

func (x TargetVpnGateway_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TargetVpnGateway_Status.Descriptor instead.
func (TargetVpnGateway_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1227, 0}
}

// Specifies the action to take when updating an instance even if the updated properties do not require it. If not specified, then Compute Engine acts based on the minimum action that the updated properties require.
// Additional supported values which may be not listed in the enum directly due to technical reasons:
// INVALID
// NO_EFFECT
// REFRESH
// RESTART
type UpdateInstanceRequest_MinimalAction int32

const (
	// A value indicating that the enum field is not set.
	UpdateInstanceRequest_UNDEFINED_MINIMAL_ACTION UpdateInstanceRequest_MinimalAction = 0
)

// Enum value maps for UpdateInstanceRequest_MinimalAction.
var (
	UpdateInstanceRequest_MinimalAction_name = map[int32]string{
		0: "UNDEFINED_MINIMAL_ACTION",
	}
	UpdateInstanceRequest_MinimalAction_value = map[string]int32{
		"UNDEFINED_MINIMAL_ACTION": 0,
	}
)

func (x UpdateInstanceRequest_MinimalAction) Enum() *UpdateInstanceRequest_MinimalAction {
	p := new(UpdateInstanceRequest_MinimalAction)
	*p = x
	return p
}

func (x UpdateInstanceRequest_MinimalAction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (UpdateInstanceRequest_MinimalAction) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[256].Descriptor()
}

func (UpdateInstanceRequest_MinimalAction) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[256]
}

func (x UpdateInstanceRequest_MinimalAction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use UpdateInstanceRequest_MinimalAction.Descriptor instead.
func (UpdateInstanceRequest_MinimalAction) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1266, 0}
}

// Specifies the most disruptive action that can be taken on the instance as part of the update. Compute Engine returns an error if the instance properties require a more disruptive action as part of the instance update. Valid options from lowest to highest are NO_EFFECT, REFRESH, and RESTART.
// Additional supported values which may be not listed in the enum directly due to technical reasons:
// INVALID
// NO_EFFECT
// REFRESH
// RESTART
type UpdateInstanceRequest_MostDisruptiveAllowedAction int32

const (
	// A value indicating that the enum field is not set.
	UpdateInstanceRequest_UNDEFINED_MOST_DISRUPTIVE_ALLOWED_ACTION UpdateInstanceRequest_MostDisruptiveAllowedAction = 0
)

// Enum value maps for UpdateInstanceRequest_MostDisruptiveAllowedAction.
var (
	UpdateInstanceRequest_MostDisruptiveAllowedAction_name = map[int32]string{
		0: "UNDEFINED_MOST_DISRUPTIVE_ALLOWED_ACTION",
	}
	UpdateInstanceRequest_MostDisruptiveAllowedAction_value = map[string]int32{
		"UNDEFINED_MOST_DISRUPTIVE_ALLOWED_ACTION": 0,
	}
)

func (x UpdateInstanceRequest_MostDisruptiveAllowedAction) Enum() *UpdateInstanceRequest_MostDisruptiveAllowedAction {
	p := new(UpdateInstanceRequest_MostDisruptiveAllowedAction)
	*p = x
	return p
}

func (x UpdateInstanceRequest_MostDisruptiveAllowedAction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (UpdateInstanceRequest_MostDisruptiveAllowedAction) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[257].Descriptor()
}

func (UpdateInstanceRequest_MostDisruptiveAllowedAction) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[257]
}

func (x UpdateInstanceRequest_MostDisruptiveAllowedAction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use UpdateInstanceRequest_MostDisruptiveAllowedAction.Descriptor instead.
func (UpdateInstanceRequest_MostDisruptiveAllowedAction) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1266, 1}
}

type UrlMapsValidateRequest_LoadBalancingSchemes int32

const (
	// A value indicating that the enum field is not set.
	UrlMapsValidateRequest_UNDEFINED_LOAD_BALANCING_SCHEMES UrlMapsValidateRequest_LoadBalancingSchemes = 0
	// Signifies that this will be used for Classic L7 External Load Balancing.
	UrlMapsValidateRequest_EXTERNAL UrlMapsValidateRequest_LoadBalancingSchemes = 35607499
	// Signifies that this will be used for Envoy-based L7 External Load Balancing.
	UrlMapsValidateRequest_EXTERNAL_MANAGED UrlMapsValidateRequest_LoadBalancingSchemes = 512006923
	// If unspecified, the validation will try to infer the scheme from the backend service resources this Url map references. If the inferrence is not possible, EXTERNAL will be used as the default type.
	UrlMapsValidateRequest_LOAD_BALANCING_SCHEME_UNSPECIFIED UrlMapsValidateRequest_LoadBalancingSchemes = 526507452
)

// Enum value maps for UrlMapsValidateRequest_LoadBalancingSchemes.
var (
	UrlMapsValidateRequest_LoadBalancingSchemes_name = map[int32]string{
		0:         "UNDEFINED_LOAD_BALANCING_SCHEMES",
		35607499:  "EXTERNAL",
		512006923: "EXTERNAL_MANAGED",
		526507452: "LOAD_BALANCING_SCHEME_UNSPECIFIED",
	}
	UrlMapsValidateRequest_LoadBalancingSchemes_value = map[string]int32{
		"UNDEFINED_LOAD_BALANCING_SCHEMES":  0,
		"EXTERNAL":                          35607499,
		"EXTERNAL_MANAGED":                  512006923,
		"LOAD_BALANCING_SCHEME_UNSPECIFIED": 526507452,
	}
)

func (x UrlMapsValidateRequest_LoadBalancingSchemes) Enum() *UrlMapsValidateRequest_LoadBalancingSchemes {
	p := new(UrlMapsValidateRequest_LoadBalancingSchemes)
	*p = x
	return p
}

func (x UrlMapsValidateRequest_LoadBalancingSchemes) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (UrlMapsValidateRequest_LoadBalancingSchemes) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[258].Descriptor()
}

func (UrlMapsValidateRequest_LoadBalancingSchemes) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[258]
}

func (x UrlMapsValidateRequest_LoadBalancingSchemes) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use UrlMapsValidateRequest_LoadBalancingSchemes.Descriptor instead.
func (UrlMapsValidateRequest_LoadBalancingSchemes) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1289, 0}
}

// The access type of IPv6 address this subnet holds. It's immutable and can only be specified during creation or the first time the subnet is updated into IPV4_IPV6 dual stack.
type UsableSubnetwork_Ipv6AccessType int32

const (
	// A value indicating that the enum field is not set.
	UsableSubnetwork_UNDEFINED_IPV6_ACCESS_TYPE UsableSubnetwork_Ipv6AccessType = 0
	// VMs on this subnet will be assigned IPv6 addresses that are accessible via the Internet, as well as the VPC network.
	UsableSubnetwork_EXTERNAL UsableSubnetwork_Ipv6AccessType = 35607499
	// VMs on this subnet will be assigned IPv6 addresses that are only accessible over the VPC network.
	UsableSubnetwork_INTERNAL UsableSubnetwork_Ipv6AccessType = 279295677
)

// Enum value maps for UsableSubnetwork_Ipv6AccessType.
var (
	UsableSubnetwork_Ipv6AccessType_name = map[int32]string{
		0:         "UNDEFINED_IPV6_ACCESS_TYPE",
		35607499:  "EXTERNAL",
		279295677: "INTERNAL",
	}
	UsableSubnetwork_Ipv6AccessType_value = map[string]int32{
		"UNDEFINED_IPV6_ACCESS_TYPE": 0,
		"EXTERNAL":                   35607499,
		"INTERNAL":                   279295677,
	}
)

func (x UsableSubnetwork_Ipv6AccessType) Enum() *UsableSubnetwork_Ipv6AccessType {
	p := new(UsableSubnetwork_Ipv6AccessType)
	*p = x
	return p
}

func (x UsableSubnetwork_Ipv6AccessType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (UsableSubnetwork_Ipv6AccessType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[259].Descriptor()
}

func (UsableSubnetwork_Ipv6AccessType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[259]
}

func (x UsableSubnetwork_Ipv6AccessType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use UsableSubnetwork_Ipv6AccessType.Descriptor instead.
func (UsableSubnetwork_Ipv6AccessType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1292, 0}
}

// The purpose of the resource. This field can be either PRIVATE_RFC_1918 or INTERNAL_HTTPS_LOAD_BALANCER. A subnetwork with purpose set to INTERNAL_HTTPS_LOAD_BALANCER is a user-created subnetwork that is reserved for Internal HTTP(S) Load Balancing. If unspecified, the purpose defaults to PRIVATE_RFC_1918. The enableFlowLogs field isn't supported with the purpose field set to INTERNAL_HTTPS_LOAD_BALANCER.
type UsableSubnetwork_Purpose int32

const (
	// A value indicating that the enum field is not set.
	UsableSubnetwork_UNDEFINED_PURPOSE UsableSubnetwork_Purpose = 0
	// Subnet reserved for Internal HTTP(S) Load Balancing.
	UsableSubnetwork_INTERNAL_HTTPS_LOAD_BALANCER UsableSubnetwork_Purpose = 248748889
	// Regular user created or automatically created subnet.
	UsableSubnetwork_PRIVATE UsableSubnetwork_Purpose = 403485027
	// Regular user created or automatically created subnet.
	UsableSubnetwork_PRIVATE_RFC_1918 UsableSubnetwork_Purpose = 254902107
	// Subnetworks created for Private Service Connect in the producer network.
	UsableSubnetwork_PRIVATE_SERVICE_CONNECT UsableSubnetwork_Purpose = 48134724
	// Subnetwork used for Regional Internal/External HTTP(S) Load Balancing.
	UsableSubnetwork_REGIONAL_MANAGED_PROXY UsableSubnetwork_Purpose = 153049966
)

// Enum value maps for UsableSubnetwork_Purpose.
var (
	UsableSubnetwork_Purpose_name = map[int32]string{
		0:         "UNDEFINED_PURPOSE",
		248748889: "INTERNAL_HTTPS_LOAD_BALANCER",
		403485027: "PRIVATE",
		254902107: "PRIVATE_RFC_1918",
		48134724:  "PRIVATE_SERVICE_CONNECT",
		153049966: "REGIONAL_MANAGED_PROXY",
	}
	UsableSubnetwork_Purpose_value = map[string]int32{
		"UNDEFINED_PURPOSE":            0,
		"INTERNAL_HTTPS_LOAD_BALANCER": 248748889,
		"PRIVATE":                      403485027,
		"PRIVATE_RFC_1918":             254902107,
		"PRIVATE_SERVICE_CONNECT":      48134724,
		"REGIONAL_MANAGED_PROXY":       153049966,
	}
)

func (x UsableSubnetwork_Purpose) Enum() *UsableSubnetwork_Purpose {
	p := new(UsableSubnetwork_Purpose)
	*p = x
	return p
}

func (x UsableSubnetwork_Purpose) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (UsableSubnetwork_Purpose) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[260].Descriptor()
}

func (UsableSubnetwork_Purpose) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[260]
}

func (x UsableSubnetwork_Purpose) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use UsableSubnetwork_Purpose.Descriptor instead.
func (UsableSubnetwork_Purpose) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1292, 1}
}

// The role of subnetwork. Currently, this field is only used when purpose = INTERNAL_HTTPS_LOAD_BALANCER. The value can be set to ACTIVE or BACKUP. An ACTIVE subnetwork is one that is currently being used for Internal HTTP(S) Load Balancing. A BACKUP subnetwork is one that is ready to be promoted to ACTIVE or is currently draining. This field can be updated with a patch request.
type UsableSubnetwork_Role int32

const (
	// A value indicating that the enum field is not set.
	UsableSubnetwork_UNDEFINED_ROLE UsableSubnetwork_Role = 0
	// The ACTIVE subnet that is currently used.
	UsableSubnetwork_ACTIVE UsableSubnetwork_Role = 314733318
	// The BACKUP subnet that could be promoted to ACTIVE.
	UsableSubnetwork_BACKUP UsableSubnetwork_Role = 341010882
)

// Enum value maps for UsableSubnetwork_Role.
var (
	UsableSubnetwork_Role_name = map[int32]string{
		0:         "UNDEFINED_ROLE",
		314733318: "ACTIVE",
		341010882: "BACKUP",
	}
	UsableSubnetwork_Role_value = map[string]int32{
		"UNDEFINED_ROLE": 0,
		"ACTIVE":         314733318,
		"BACKUP":         341010882,
	}
)

func (x UsableSubnetwork_Role) Enum() *UsableSubnetwork_Role {
	p := new(UsableSubnetwork_Role)
	*p = x
	return p
}

func (x UsableSubnetwork_Role) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (UsableSubnetwork_Role) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[261].Descriptor()
}

func (UsableSubnetwork_Role) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[261]
}

func (x UsableSubnetwork_Role) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use UsableSubnetwork_Role.Descriptor instead.
func (UsableSubnetwork_Role) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1292, 2}
}

// The stack type for the subnet. If set to IPV4_ONLY, new VMs in the subnet are assigned IPv4 addresses only. If set to IPV4_IPV6, new VMs in the subnet can be assigned both IPv4 and IPv6 addresses. If not specified, IPV4_ONLY is used. This field can be both set at resource creation time and updated using patch.
type UsableSubnetwork_StackType int32

const (
	// A value indicating that the enum field is not set.
	UsableSubnetwork_UNDEFINED_STACK_TYPE UsableSubnetwork_StackType = 0
	// New VMs in this subnet can have both IPv4 and IPv6 addresses.
	UsableSubnetwork_IPV4_IPV6 UsableSubnetwork_StackType = 22197249
	// New VMs in this subnet will only be assigned IPv4 addresses.
	UsableSubnetwork_IPV4_ONLY UsableSubnetwork_StackType = 22373798
)

// Enum value maps for UsableSubnetwork_StackType.
var (
	UsableSubnetwork_StackType_name = map[int32]string{
		0:        "UNDEFINED_STACK_TYPE",
		22197249: "IPV4_IPV6",
		22373798: "IPV4_ONLY",
	}
	UsableSubnetwork_StackType_value = map[string]int32{
		"UNDEFINED_STACK_TYPE": 0,
		"IPV4_IPV6":            22197249,
		"IPV4_ONLY":            22373798,
	}
)

func (x UsableSubnetwork_StackType) Enum() *UsableSubnetwork_StackType {
	p := new(UsableSubnetwork_StackType)
	*p = x
	return p
}

func (x UsableSubnetwork_StackType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (UsableSubnetwork_StackType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[262].Descriptor()
}

func (UsableSubnetwork_StackType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[262]
}

func (x UsableSubnetwork_StackType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use UsableSubnetwork_StackType.Descriptor instead.
func (UsableSubnetwork_StackType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1292, 3}
}

// The stack type for this VPN gateway to identify the IP protocols that are enabled. Possible values are: IPV4_ONLY, IPV4_IPV6. If not specified, IPV4_ONLY will be used.
type VpnGateway_StackType int32

const (
	// A value indicating that the enum field is not set.
	VpnGateway_UNDEFINED_STACK_TYPE VpnGateway_StackType = 0
	// Enable VPN gateway with both IPv4 and IPv6 protocols.
	VpnGateway_IPV4_IPV6 VpnGateway_StackType = 22197249
	// Enable VPN gateway with only IPv4 protocol.
	VpnGateway_IPV4_ONLY VpnGateway_StackType = 22373798
)

// Enum value maps for VpnGateway_StackType.
var (
	VpnGateway_StackType_name = map[int32]string{
		0:        "UNDEFINED_STACK_TYPE",
		22197249: "IPV4_IPV6",
		22373798: "IPV4_ONLY",
	}
	VpnGateway_StackType_value = map[string]int32{
		"UNDEFINED_STACK_TYPE": 0,
		"IPV4_IPV6":            22197249,
		"IPV4_ONLY":            22373798,
	}
)

func (x VpnGateway_StackType) Enum() *VpnGateway_StackType {
	p := new(VpnGateway_StackType)
	*p = x
	return p
}

func (x VpnGateway_StackType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VpnGateway_StackType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[263].Descriptor()
}

func (VpnGateway_StackType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[263]
}

func (x VpnGateway_StackType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VpnGateway_StackType.Descriptor instead.
func (VpnGateway_StackType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1302, 0}
}

// Indicates the high availability requirement state for the VPN connection. Valid values are CONNECTION_REDUNDANCY_MET, CONNECTION_REDUNDANCY_NOT_MET.
type VpnGatewayStatusHighAvailabilityRequirementState_State int32

const (
	// A value indicating that the enum field is not set.
	VpnGatewayStatusHighAvailabilityRequirementState_UNDEFINED_STATE VpnGatewayStatusHighAvailabilityRequirementState_State = 0
	// VPN tunnels are configured with adequate redundancy from Cloud VPN gateway to the peer VPN gateway. For both GCP-to-non-GCP and GCP-to-GCP connections, the adequate redundancy is a pre-requirement for users to get 99.99% availability on GCP side; please note that for any connection, end-to-end 99.99% availability is subject to proper configuration on the peer VPN gateway.
	VpnGatewayStatusHighAvailabilityRequirementState_CONNECTION_REDUNDANCY_MET VpnGatewayStatusHighAvailabilityRequirementState_State = 505242907
	// VPN tunnels are not configured with adequate redundancy from the Cloud VPN gateway to the peer gateway
	VpnGatewayStatusHighAvailabilityRequirementState_CONNECTION_REDUNDANCY_NOT_MET VpnGatewayStatusHighAvailabilityRequirementState_State = 511863311
)

// Enum value maps for VpnGatewayStatusHighAvailabilityRequirementState_State.
var (
	VpnGatewayStatusHighAvailabilityRequirementState_State_name = map[int32]string{
		0:         "UNDEFINED_STATE",
		505242907: "CONNECTION_REDUNDANCY_MET",
		511863311: "CONNECTION_REDUNDANCY_NOT_MET",
	}
	VpnGatewayStatusHighAvailabilityRequirementState_State_value = map[string]int32{
		"UNDEFINED_STATE":               0,
		"CONNECTION_REDUNDANCY_MET":     505242907,
		"CONNECTION_REDUNDANCY_NOT_MET": 511863311,
	}
)

func (x VpnGatewayStatusHighAvailabilityRequirementState_State) Enum() *VpnGatewayStatusHighAvailabilityRequirementState_State {
	p := new(VpnGatewayStatusHighAvailabilityRequirementState_State)
	*p = x
	return p
}

func (x VpnGatewayStatusHighAvailabilityRequirementState_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VpnGatewayStatusHighAvailabilityRequirementState_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[264].Descriptor()
}

func (VpnGatewayStatusHighAvailabilityRequirementState_State) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[264]
}

func (x VpnGatewayStatusHighAvailabilityRequirementState_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VpnGatewayStatusHighAvailabilityRequirementState_State.Descriptor instead.
func (VpnGatewayStatusHighAvailabilityRequirementState_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1306, 0}
}

// Indicates the reason why the VPN connection does not meet the high availability redundancy criteria/requirement. Valid values is INCOMPLETE_TUNNELS_COVERAGE.
type VpnGatewayStatusHighAvailabilityRequirementState_UnsatisfiedReason int32

const (
	// A value indicating that the enum field is not set.
	VpnGatewayStatusHighAvailabilityRequirementState_UNDEFINED_UNSATISFIED_REASON VpnGatewayStatusHighAvailabilityRequirementState_UnsatisfiedReason = 0
	VpnGatewayStatusHighAvailabilityRequirementState_INCOMPLETE_TUNNELS_COVERAGE  VpnGatewayStatusHighAvailabilityRequirementState_UnsatisfiedReason = 55917437
)

// Enum value maps for VpnGatewayStatusHighAvailabilityRequirementState_UnsatisfiedReason.
var (
	VpnGatewayStatusHighAvailabilityRequirementState_UnsatisfiedReason_name = map[int32]string{
		0:        "UNDEFINED_UNSATISFIED_REASON",
		55917437: "INCOMPLETE_TUNNELS_COVERAGE",
	}
	VpnGatewayStatusHighAvailabilityRequirementState_UnsatisfiedReason_value = map[string]int32{
		"UNDEFINED_UNSATISFIED_REASON": 0,
		"INCOMPLETE_TUNNELS_COVERAGE":  55917437,
	}
)

func (x VpnGatewayStatusHighAvailabilityRequirementState_UnsatisfiedReason) Enum() *VpnGatewayStatusHighAvailabilityRequirementState_UnsatisfiedReason {
	p := new(VpnGatewayStatusHighAvailabilityRequirementState_UnsatisfiedReason)
	*p = x
	return p
}

func (x VpnGatewayStatusHighAvailabilityRequirementState_UnsatisfiedReason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VpnGatewayStatusHighAvailabilityRequirementState_UnsatisfiedReason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[265].Descriptor()
}

func (VpnGatewayStatusHighAvailabilityRequirementState_UnsatisfiedReason) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[265]
}

func (x VpnGatewayStatusHighAvailabilityRequirementState_UnsatisfiedReason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VpnGatewayStatusHighAvailabilityRequirementState_UnsatisfiedReason.Descriptor instead.
func (VpnGatewayStatusHighAvailabilityRequirementState_UnsatisfiedReason) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1306, 1}
}

// [Output Only] The status of the VPN tunnel, which can be one of the following: - PROVISIONING: Resource is being allocated for the VPN tunnel. - WAITING_FOR_FULL_CONFIG: Waiting to receive all VPN-related configs from the user. Network, TargetVpnGateway, VpnTunnel, ForwardingRule, and Route resources are needed to setup the VPN tunnel. - FIRST_HANDSHAKE: Successful first handshake with the peer VPN. - ESTABLISHED: Secure session is successfully established with the peer VPN. - NETWORK_ERROR: Deprecated, replaced by NO_INCOMING_PACKETS - AUTHORIZATION_ERROR: Auth error (for example, bad shared secret). - NEGOTIATION_FAILURE: Handshake failed. - DEPROVISIONING: Resources are being deallocated for the VPN tunnel. - FAILED: Tunnel creation has failed and the tunnel is not ready to be used. - NO_INCOMING_PACKETS: No incoming packets from peer. - REJECTED: Tunnel configuration was rejected, can be result of being denied access. - ALLOCATING_RESOURCES: Cloud VPN is in the process of allocating all required resources. - STOPPED: Tunnel is stopped due to its Forwarding Rules being deleted for Classic VPN tunnels or the project is in frozen state. - PEER_IDENTITY_MISMATCH: Peer identity does not match peer IP, probably behind NAT. - TS_NARROWING_NOT_ALLOWED: Traffic selector narrowing not allowed for an HA-VPN tunnel.
type VpnTunnel_Status int32

const (
	// A value indicating that the enum field is not set.
	VpnTunnel_UNDEFINED_STATUS VpnTunnel_Status = 0
	// Cloud VPN is in the process of allocating all required resources (specifically, a borg task).
	VpnTunnel_ALLOCATING_RESOURCES VpnTunnel_Status = 320922816
	// Auth error (e.g. bad shared secret).
	VpnTunnel_AUTHORIZATION_ERROR VpnTunnel_Status = 23580290
	// Resources is being deallocated for the VPN tunnel.
	VpnTunnel_DEPROVISIONING VpnTunnel_Status = 428935662
	// Secure session is successfully established with peer VPN.
	VpnTunnel_ESTABLISHED VpnTunnel_Status = 88852344
	// Tunnel creation has failed and the tunnel is not ready to be used.
	VpnTunnel_FAILED VpnTunnel_Status = 455706685
	// Successful first handshake with peer VPN.
	VpnTunnel_FIRST_HANDSHAKE VpnTunnel_Status = 191393000
	// Handshake failed.
	VpnTunnel_NEGOTIATION_FAILURE VpnTunnel_Status = 360325868
	// Deprecated, replaced by NO_INCOMING_PACKETS
	VpnTunnel_NETWORK_ERROR VpnTunnel_Status = 193912951
	// No incoming packets from peer
	VpnTunnel_NO_INCOMING_PACKETS VpnTunnel_Status = 119983216
	// Resource is being allocated for the VPN tunnel.
	VpnTunnel_PROVISIONING VpnTunnel_Status = 290896621
	// Tunnel configuration was rejected, can be result of being denylisted.
	VpnTunnel_REJECTED VpnTunnel_Status = 174130302
	// Tunnel is stopped due to its Forwarding Rules being deleted.
	VpnTunnel_STOPPED VpnTunnel_Status = 444276141
	// Waiting to receive all VPN-related configs from user. Network, TargetVpnGateway, VpnTunnel, ForwardingRule and Route resources are needed to setup VPN tunnel.
	VpnTunnel_WAITING_FOR_FULL_CONFIG VpnTunnel_Status = 41640522
)

// Enum value maps for VpnTunnel_Status.
var (
	VpnTunnel_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		320922816: "ALLOCATING_RESOURCES",
		23580290:  "AUTHORIZATION_ERROR",
		428935662: "DEPROVISIONING",
		88852344:  "ESTABLISHED",
		455706685: "FAILED",
		191393000: "FIRST_HANDSHAKE",
		360325868: "NEGOTIATION_FAILURE",
		193912951: "NETWORK_ERROR",
		119983216: "NO_INCOMING_PACKETS",
		290896621: "PROVISIONING",
		174130302: "REJECTED",
		444276141: "STOPPED",
		41640522:  "WAITING_FOR_FULL_CONFIG",
	}
	VpnTunnel_Status_value = map[string]int32{
		"UNDEFINED_STATUS":        0,
		"ALLOCATING_RESOURCES":    320922816,
		"AUTHORIZATION_ERROR":     23580290,
		"DEPROVISIONING":          428935662,
		"ESTABLISHED":             88852344,
		"FAILED":                  455706685,
		"FIRST_HANDSHAKE":         191393000,
		"NEGOTIATION_FAILURE":     360325868,
		"NETWORK_ERROR":           193912951,
		"NO_INCOMING_PACKETS":     119983216,
		"PROVISIONING":            290896621,
		"REJECTED":                174130302,
		"STOPPED":                 444276141,
		"WAITING_FOR_FULL_CONFIG": 41640522,
	}
)

func (x VpnTunnel_Status) Enum() *VpnTunnel_Status {
	p := new(VpnTunnel_Status)
	*p = x
	return p
}

func (x VpnTunnel_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VpnTunnel_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[266].Descriptor()
}

func (VpnTunnel_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[266]
}

func (x VpnTunnel_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VpnTunnel_Status.Descriptor instead.
func (VpnTunnel_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1312, 0}
}

// [Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.
type Warning_Code int32

const (
	// A value indicating that the enum field is not set.
	Warning_UNDEFINED_CODE Warning_Code = 0
	// Warning about failed cleanup of transient changes made by a failed operation.
	Warning_CLEANUP_FAILED Warning_Code = 150308440
	// A link to a deprecated resource was created.
	Warning_DEPRECATED_RESOURCE_USED Warning_Code = 391835586
	// When deploying and at least one of the resources has a type marked as deprecated
	Warning_DEPRECATED_TYPE_USED Warning_Code = 346526230
	// The user created a boot disk that is larger than image size.
	Warning_DISK_SIZE_LARGER_THAN_IMAGE_SIZE Warning_Code = 369442967
	// When deploying and at least one of the resources has a type marked as experimental
	Warning_EXPERIMENTAL_TYPE_USED Warning_Code = 451954443
	// Warning that is present in an external api call
	Warning_EXTERNAL_API_WARNING Warning_Code = 175546307
	// Warning that value of a field has been overridden. Deprecated unused field.
	Warning_FIELD_VALUE_OVERRIDEN Warning_Code = 329669423
	// The operation involved use of an injected kernel, which is deprecated.
	Warning_INJECTED_KERNELS_DEPRECATED Warning_Code = 417377419
	// A WEIGHTED_MAGLEV backend service is associated with a health check that is not of type HTTP/HTTPS/HTTP2.
	Warning_INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB Warning_Code = 401542606
	// When deploying a deployment with a exceedingly large number of resources
	Warning_LARGE_DEPLOYMENT_WARNING Warning_Code = 481440678
	// A resource depends on a missing type
	Warning_MISSING_TYPE_DEPENDENCY Warning_Code = 344505463
	// The route's nextHopIp address is not assigned to an instance on the network.
	Warning_NEXT_HOP_ADDRESS_NOT_ASSIGNED Warning_Code = 324964999
	// The route's next hop instance cannot ip forward.
	Warning_NEXT_HOP_CANNOT_IP_FORWARD Warning_Code = 383382887
	// The route's nextHopInstance URL refers to an instance that does not have an ipv6 interface on the same network as the route.
	Warning_NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE Warning_Code = 146748434
	// The route's nextHopInstance URL refers to an instance that does not exist.
	Warning_NEXT_HOP_INSTANCE_NOT_FOUND Warning_Code = 464250446
	// The route's nextHopInstance URL refers to an instance that is not on the same network as the route.
	Warning_NEXT_HOP_INSTANCE_NOT_ON_NETWORK Warning_Code = 243758146
	// The route's next hop instance does not have a status of RUNNING.
	Warning_NEXT_HOP_NOT_RUNNING Warning_Code = 417081265
	// Error which is not critical. We decided to continue the process despite the mentioned error.
	Warning_NOT_CRITICAL_ERROR Warning_Code = 105763924
	// No results are present on a particular list page.
	Warning_NO_RESULTS_ON_PAGE Warning_Code = 30036744
	// Success is reported, but some results may be missing due to errors
	Warning_PARTIAL_SUCCESS Warning_Code = 39966469
	// The user attempted to use a resource that requires a TOS they have not accepted.
	Warning_REQUIRED_TOS_AGREEMENT Warning_Code = 3745539
	// Warning that a resource is in use.
	Warning_RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING Warning_Code = 496728641
	// One or more of the resources set to auto-delete could not be deleted because they were in use.
	Warning_RESOURCE_NOT_DELETED Warning_Code = 168598460
	// When a resource schema validation is ignored.
	Warning_SCHEMA_VALIDATION_IGNORED Warning_Code = 275245642
	// Instance template used in instance group manager is valid as such, but its application does not make a lot of sense, because it allows only single instance in instance group.
	Warning_SINGLE_INSTANCE_PROPERTY_TEMPLATE Warning_Code = 268305617
	// When undeclared properties in the schema are present
	Warning_UNDECLARED_PROPERTIES Warning_Code = 390513439
	// A given scope cannot be reached.
	Warning_UNREACHABLE Warning_Code = 13328052
)

// Enum value maps for Warning_Code.
var (
	Warning_Code_name = map[int32]string{
		0:         "UNDEFINED_CODE",
		150308440: "CLEANUP_FAILED",
		391835586: "DEPRECATED_RESOURCE_USED",
		346526230: "DEPRECATED_TYPE_USED",
		369442967: "DISK_SIZE_LARGER_THAN_IMAGE_SIZE",
		451954443: "EXPERIMENTAL_TYPE_USED",
		175546307: "EXTERNAL_API_WARNING",
		329669423: "FIELD_VALUE_OVERRIDEN",
		417377419: "INJECTED_KERNELS_DEPRECATED",
		401542606: "INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB",
		481440678: "LARGE_DEPLOYMENT_WARNING",
		344505463: "MISSING_TYPE_DEPENDENCY",
		324964999: "NEXT_HOP_ADDRESS_NOT_ASSIGNED",
		383382887: "NEXT_HOP_CANNOT_IP_FORWARD",
		146748434: "NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE",
		464250446: "NEXT_HOP_INSTANCE_NOT_FOUND",
		243758146: "NEXT_HOP_INSTANCE_NOT_ON_NETWORK",
		417081265: "NEXT_HOP_NOT_RUNNING",
		105763924: "NOT_CRITICAL_ERROR",
		30036744:  "NO_RESULTS_ON_PAGE",
		39966469:  "PARTIAL_SUCCESS",
		3745539:   "REQUIRED_TOS_AGREEMENT",
		496728641: "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING",
		168598460: "RESOURCE_NOT_DELETED",
		275245642: "SCHEMA_VALIDATION_IGNORED",
		268305617: "SINGLE_INSTANCE_PROPERTY_TEMPLATE",
		390513439: "UNDECLARED_PROPERTIES",
		13328052:  "UNREACHABLE",
	}
	Warning_Code_value = map[string]int32{
		"UNDEFINED_CODE":                               0,
		"CLEANUP_FAILED":                               150308440,
		"DEPRECATED_RESOURCE_USED":                     391835586,
		"DEPRECATED_TYPE_USED":                         346526230,
		"DISK_SIZE_LARGER_THAN_IMAGE_SIZE":             369442967,
		"EXPERIMENTAL_TYPE_USED":                       451954443,
		"EXTERNAL_API_WARNING":                         175546307,
		"FIELD_VALUE_OVERRIDEN":                        329669423,
		"INJECTED_KERNELS_DEPRECATED":                  417377419,
		"INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB": 401542606,
		"LARGE_DEPLOYMENT_WARNING":                     481440678,
		"MISSING_TYPE_DEPENDENCY":                      344505463,
		"NEXT_HOP_ADDRESS_NOT_ASSIGNED":                324964999,
		"NEXT_HOP_CANNOT_IP_FORWARD":                   383382887,
		"NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE":      146748434,
		"NEXT_HOP_INSTANCE_NOT_FOUND":                  464250446,
		"NEXT_HOP_INSTANCE_NOT_ON_NETWORK":             243758146,
		"NEXT_HOP_NOT_RUNNING":                         417081265,
		"NOT_CRITICAL_ERROR":                           105763924,
		"NO_RESULTS_ON_PAGE":                           30036744,
		"PARTIAL_SUCCESS":                              39966469,
		"REQUIRED_TOS_AGREEMENT":                       3745539,
		"RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING":    496728641,
		"RESOURCE_NOT_DELETED":                         168598460,
		"SCHEMA_VALIDATION_IGNORED":                    275245642,
		"SINGLE_INSTANCE_PROPERTY_TEMPLATE":            268305617,
		"UNDECLARED_PROPERTIES":                        390513439,
		"UNREACHABLE":                                  13328052,
	}
)

func (x Warning_Code) Enum() *Warning_Code {
	p := new(Warning_Code)
	*p = x
	return p
}

func (x Warning_Code) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Warning_Code) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[267].Descriptor()
}

func (Warning_Code) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[267]
}

func (x Warning_Code) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Warning_Code.Descriptor instead.
func (Warning_Code) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1321, 0}
}

// [Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.
type Warnings_Code int32

const (
	// A value indicating that the enum field is not set.
	Warnings_UNDEFINED_CODE Warnings_Code = 0
	// Warning about failed cleanup of transient changes made by a failed operation.
	Warnings_CLEANUP_FAILED Warnings_Code = 150308440
	// A link to a deprecated resource was created.
	Warnings_DEPRECATED_RESOURCE_USED Warnings_Code = 391835586
	// When deploying and at least one of the resources has a type marked as deprecated
	Warnings_DEPRECATED_TYPE_USED Warnings_Code = 346526230
	// The user created a boot disk that is larger than image size.
	Warnings_DISK_SIZE_LARGER_THAN_IMAGE_SIZE Warnings_Code = 369442967
	// When deploying and at least one of the resources has a type marked as experimental
	Warnings_EXPERIMENTAL_TYPE_USED Warnings_Code = 451954443
	// Warning that is present in an external api call
	Warnings_EXTERNAL_API_WARNING Warnings_Code = 175546307
	// Warning that value of a field has been overridden. Deprecated unused field.
	Warnings_FIELD_VALUE_OVERRIDEN Warnings_Code = 329669423
	// The operation involved use of an injected kernel, which is deprecated.
	Warnings_INJECTED_KERNELS_DEPRECATED Warnings_Code = 417377419
	// A WEIGHTED_MAGLEV backend service is associated with a health check that is not of type HTTP/HTTPS/HTTP2.
	Warnings_INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB Warnings_Code = 401542606
	// When deploying a deployment with a exceedingly large number of resources
	Warnings_LARGE_DEPLOYMENT_WARNING Warnings_Code = 481440678
	// A resource depends on a missing type
	Warnings_MISSING_TYPE_DEPENDENCY Warnings_Code = 344505463
	// The route's nextHopIp address is not assigned to an instance on the network.
	Warnings_NEXT_HOP_ADDRESS_NOT_ASSIGNED Warnings_Code = 324964999
	// The route's next hop instance cannot ip forward.
	Warnings_NEXT_HOP_CANNOT_IP_FORWARD Warnings_Code = 383382887
	// The route's nextHopInstance URL refers to an instance that does not have an ipv6 interface on the same network as the route.
	Warnings_NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE Warnings_Code = 146748434
	// The route's nextHopInstance URL refers to an instance that does not exist.
	Warnings_NEXT_HOP_INSTANCE_NOT_FOUND Warnings_Code = 464250446
	// The route's nextHopInstance URL refers to an instance that is not on the same network as the route.
	Warnings_NEXT_HOP_INSTANCE_NOT_ON_NETWORK Warnings_Code = 243758146
	// The route's next hop instance does not have a status of RUNNING.
	Warnings_NEXT_HOP_NOT_RUNNING Warnings_Code = 417081265
	// Error which is not critical. We decided to continue the process despite the mentioned error.
	Warnings_NOT_CRITICAL_ERROR Warnings_Code = 105763924
	// No results are present on a particular list page.
	Warnings_NO_RESULTS_ON_PAGE Warnings_Code = 30036744
	// Success is reported, but some results may be missing due to errors
	Warnings_PARTIAL_SUCCESS Warnings_Code = 39966469
	// The user attempted to use a resource that requires a TOS they have not accepted.
	Warnings_REQUIRED_TOS_AGREEMENT Warnings_Code = 3745539
	// Warning that a resource is in use.
	Warnings_RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING Warnings_Code = 496728641
	// One or more of the resources set to auto-delete could not be deleted because they were in use.
	Warnings_RESOURCE_NOT_DELETED Warnings_Code = 168598460
	// When a resource schema validation is ignored.
	Warnings_SCHEMA_VALIDATION_IGNORED Warnings_Code = 275245642
	// Instance template used in instance group manager is valid as such, but its application does not make a lot of sense, because it allows only single instance in instance group.
	Warnings_SINGLE_INSTANCE_PROPERTY_TEMPLATE Warnings_Code = 268305617
	// When undeclared properties in the schema are present
	Warnings_UNDECLARED_PROPERTIES Warnings_Code = 390513439
	// A given scope cannot be reached.
	Warnings_UNREACHABLE Warnings_Code = 13328052
)

// Enum value maps for Warnings_Code.
var (
	Warnings_Code_name = map[int32]string{
		0:         "UNDEFINED_CODE",
		150308440: "CLEANUP_FAILED",
		391835586: "DEPRECATED_RESOURCE_USED",
		346526230: "DEPRECATED_TYPE_USED",
		369442967: "DISK_SIZE_LARGER_THAN_IMAGE_SIZE",
		451954443: "EXPERIMENTAL_TYPE_USED",
		175546307: "EXTERNAL_API_WARNING",
		329669423: "FIELD_VALUE_OVERRIDEN",
		417377419: "INJECTED_KERNELS_DEPRECATED",
		401542606: "INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB",
		481440678: "LARGE_DEPLOYMENT_WARNING",
		344505463: "MISSING_TYPE_DEPENDENCY",
		324964999: "NEXT_HOP_ADDRESS_NOT_ASSIGNED",
		383382887: "NEXT_HOP_CANNOT_IP_FORWARD",
		146748434: "NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE",
		464250446: "NEXT_HOP_INSTANCE_NOT_FOUND",
		243758146: "NEXT_HOP_INSTANCE_NOT_ON_NETWORK",
		417081265: "NEXT_HOP_NOT_RUNNING",
		105763924: "NOT_CRITICAL_ERROR",
		30036744:  "NO_RESULTS_ON_PAGE",
		39966469:  "PARTIAL_SUCCESS",
		3745539:   "REQUIRED_TOS_AGREEMENT",
		496728641: "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING",
		168598460: "RESOURCE_NOT_DELETED",
		275245642: "SCHEMA_VALIDATION_IGNORED",
		268305617: "SINGLE_INSTANCE_PROPERTY_TEMPLATE",
		390513439: "UNDECLARED_PROPERTIES",
		13328052:  "UNREACHABLE",
	}
	Warnings_Code_value = map[string]int32{
		"UNDEFINED_CODE":                               0,
		"CLEANUP_FAILED":                               150308440,
		"DEPRECATED_RESOURCE_USED":                     391835586,
		"DEPRECATED_TYPE_USED":                         346526230,
		"DISK_SIZE_LARGER_THAN_IMAGE_SIZE":             369442967,
		"EXPERIMENTAL_TYPE_USED":                       451954443,
		"EXTERNAL_API_WARNING":                         175546307,
		"FIELD_VALUE_OVERRIDEN":                        329669423,
		"INJECTED_KERNELS_DEPRECATED":                  417377419,
		"INVALID_HEALTH_CHECK_FOR_DYNAMIC_WIEGHTED_LB": 401542606,
		"LARGE_DEPLOYMENT_WARNING":                     481440678,
		"MISSING_TYPE_DEPENDENCY":                      344505463,
		"NEXT_HOP_ADDRESS_NOT_ASSIGNED":                324964999,
		"NEXT_HOP_CANNOT_IP_FORWARD":                   383382887,
		"NEXT_HOP_INSTANCE_HAS_NO_IPV6_INTERFACE":      146748434,
		"NEXT_HOP_INSTANCE_NOT_FOUND":                  464250446,
		"NEXT_HOP_INSTANCE_NOT_ON_NETWORK":             243758146,
		"NEXT_HOP_NOT_RUNNING":                         417081265,
		"NOT_CRITICAL_ERROR":                           105763924,
		"NO_RESULTS_ON_PAGE":                           30036744,
		"PARTIAL_SUCCESS":                              39966469,
		"REQUIRED_TOS_AGREEMENT":                       3745539,
		"RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING":    496728641,
		"RESOURCE_NOT_DELETED":                         168598460,
		"SCHEMA_VALIDATION_IGNORED":                    275245642,
		"SINGLE_INSTANCE_PROPERTY_TEMPLATE":            268305617,
		"UNDECLARED_PROPERTIES":                        390513439,
		"UNREACHABLE":                                  13328052,
	}
)

func (x Warnings_Code) Enum() *Warnings_Code {
	p := new(Warnings_Code)
	*p = x
	return p
}

func (x Warnings_Code) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Warnings_Code) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[268].Descriptor()
}

func (Warnings_Code) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[268]
}

func (x Warnings_Code) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Warnings_Code.Descriptor instead.
func (Warnings_Code) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1322, 0}
}

// The type of the service resource.
type XpnResourceId_Type int32

const (
	// A value indicating that the enum field is not set.
	XpnResourceId_UNDEFINED_TYPE                XpnResourceId_Type = 0
	XpnResourceId_PROJECT                       XpnResourceId_Type = 408671993
	XpnResourceId_XPN_RESOURCE_TYPE_UNSPECIFIED XpnResourceId_Type = 151607034
)

// Enum value maps for XpnResourceId_Type.
var (
	XpnResourceId_Type_name = map[int32]string{
		0:         "UNDEFINED_TYPE",
		408671993: "PROJECT",
		151607034: "XPN_RESOURCE_TYPE_UNSPECIFIED",
	}
	XpnResourceId_Type_value = map[string]int32{
		"UNDEFINED_TYPE":                0,
		"PROJECT":                       408671993,
		"XPN_RESOURCE_TYPE_UNSPECIFIED": 151607034,
	}
)

func (x XpnResourceId_Type) Enum() *XpnResourceId_Type {
	p := new(XpnResourceId_Type)
	*p = x
	return p
}

func (x XpnResourceId_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (XpnResourceId_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[269].Descriptor()
}

func (XpnResourceId_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[269]
}

func (x XpnResourceId_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use XpnResourceId_Type.Descriptor instead.
func (XpnResourceId_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1325, 0}
}

// [Output Only] Status of the zone, either UP or DOWN.
type Zone_Status int32

const (
	// A value indicating that the enum field is not set.
	Zone_UNDEFINED_STATUS Zone_Status = 0
	Zone_DOWN             Zone_Status = 2104482
	Zone_UP               Zone_Status = 2715
)

// Enum value maps for Zone_Status.
var (
	Zone_Status_name = map[int32]string{
		0:       "UNDEFINED_STATUS",
		2104482: "DOWN",
		2715:    "UP",
	}
	Zone_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"DOWN":             2104482,
		"UP":               2715,
	}
)

func (x Zone_Status) Enum() *Zone_Status {
	p := new(Zone_Status)
	*p = x
	return p
}

func (x Zone_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Zone_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[270].Descriptor()
}

func (Zone_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[270]
}

func (x Zone_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Zone_Status.Descriptor instead.
func (Zone_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1326, 0}
}

// Messages
//
// A request message for InstanceGroupManagers.AbandonInstances. See the method description for details.
type AbandonInstancesInstanceGroupManagerRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the managed instance group.
	InstanceGroupManager string `protobuf:"bytes,249363395,opt,name=instance_group_manager,json=instanceGroupManager,proto3" json:"instance_group_manager,omitempty"`
	// The body resource for this request
	InstanceGroupManagersAbandonInstancesRequestResource *InstanceGroupManagersAbandonInstancesRequest `protobuf:"bytes,320929016,opt,name=instance_group_managers_abandon_instances_request_resource,json=instanceGroupManagersAbandonInstancesRequestResource,proto3" json:"instance_group_managers_abandon_instances_request_resource,omitempty"`
	// Project ID for this request.
	Project string `protobuf:"bytes,227560217,opt,name=project,proto3" json:"project,omitempty"`
	// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
	RequestId *string `protobuf:"bytes,37109963,opt,name=request_id,json=requestId,proto3,oneof" json:"request_id,omitempty"`
	// The name of the zone where the managed instance group is located.
	Zone string `protobuf:"bytes,3744684,opt,name=zone,proto3" json:"zone,omitempty"`
}

func (x *AbandonInstancesInstanceGroupManagerRequest) Reset() {
	*x = AbandonInstancesInstanceGroupManagerRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AbandonInstancesInstanceGroupManagerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AbandonInstancesInstanceGroupManagerRequest) ProtoMessage() {}

func (x *AbandonInstancesInstanceGroupManagerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AbandonInstancesInstanceGroupManagerRequest.ProtoReflect.Descriptor instead.
func (*AbandonInstancesInstanceGroupManagerRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{0}
}

func (x *AbandonInstancesInstanceGroupManagerRequest) GetInstanceGroupManager() string {
	if x != nil {
		return x.InstanceGroupManager
	}
	return ""
}

func (x *AbandonInstancesInstanceGroupManagerRequest) GetInstanceGroupManagersAbandonInstancesRequestResource() *InstanceGroupManagersAbandonInstancesRequest {
	if x != nil {
		return x.InstanceGroupManagersAbandonInstancesRequestResource
	}
	return nil
}

func (x *AbandonInstancesInstanceGroupManagerRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *AbandonInstancesInstanceGroupManagerRequest) GetRequestId() string {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return ""
}

func (x *AbandonInstancesInstanceGroupManagerRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// A request message for RegionInstanceGroupManagers.AbandonInstances. See the method description for details.
type AbandonInstancesRegionInstanceGroupManagerRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the managed instance group.
	InstanceGroupManager string `protobuf:"bytes,249363395,opt,name=instance_group_manager,json=instanceGroupManager,proto3" json:"instance_group_manager,omitempty"`
	// Project ID for this request.
	Project string `protobuf:"bytes,227560217,opt,name=project,proto3" json:"project,omitempty"`
	// Name of the region scoping this request.
	Region string `protobuf:"bytes,138946292,opt,name=region,proto3" json:"region,omitempty"`
	// The body resource for this request
	RegionInstanceGroupManagersAbandonInstancesRequestResource *RegionInstanceGroupManagersAbandonInstancesRequest `protobuf:"bytes,488499491,opt,name=region_instance_group_managers_abandon_instances_request_resource,json=regionInstanceGroupManagersAbandonInstancesRequestResource,proto3" json:"region_instance_group_managers_abandon_instances_request_resource,omitempty"`
	// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
	RequestId *string `protobuf:"bytes,37109963,opt,name=request_id,json=requestId,proto3,oneof" json:"request_id,omitempty"`
}

func (x *AbandonInstancesRegionInstanceGroupManagerRequest) Reset() {
	*x = AbandonInstancesRegionInstanceGroupManagerRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AbandonInstancesRegionInstanceGroupManagerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AbandonInstancesRegionInstanceGroupManagerRequest) ProtoMessage() {}

func (x *AbandonInstancesRegionInstanceGroupManagerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AbandonInstancesRegionInstanceGroupManagerRequest.ProtoReflect.Descriptor instead.
func (*AbandonInstancesRegionInstanceGroupManagerRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1}
}

func (x *AbandonInstancesRegionInstanceGroupManagerRequest) GetInstanceGroupManager() string {
	if x != nil {
		return x.InstanceGroupManager
	}
	return ""
}

func (x *AbandonInstancesRegionInstanceGroupManagerRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *AbandonInstancesRegionInstanceGroupManagerRequest) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

func (x *AbandonInstancesRegionInstanceGroupManagerRequest) GetRegionInstanceGroupManagersAbandonInstancesRequestResource() *RegionInstanceGroupManagersAbandonInstancesRequest {
	if x != nil {
		return x.RegionInstanceGroupManagersAbandonInstancesRequestResource
	}
	return nil
}

func (x *AbandonInstancesRegionInstanceGroupManagerRequest) GetRequestId() string {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return ""
}

// A specification of the type and number of accelerator cards attached to the instance.
type AcceleratorConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of the guest accelerator cards exposed to this instance.
	AcceleratorCount *int32 `protobuf:"varint,504879675,opt,name=accelerator_count,json=acceleratorCount,proto3,oneof" json:"accelerator_count,omitempty"`
	// Full or partial URL of the accelerator type resource to attach to this instance. For example: projects/my-project/zones/us-central1-c/acceleratorTypes/nvidia-tesla-p100 If you are creating an instance template, specify only the accelerator name. See GPUs on Compute Engine for a full list of accelerator types.
	AcceleratorType *string `protobuf:"bytes,138031246,opt,name=accelerator_type,json=acceleratorType,proto3,oneof" json:"accelerator_type,omitempty"`
}

func (x *AcceleratorConfig) Reset() {
	*x = AcceleratorConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AcceleratorConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AcceleratorConfig) ProtoMessage() {}

func (x *AcceleratorConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AcceleratorConfig.ProtoReflect.Descriptor instead.
func (*AcceleratorConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{2}
}

func (x *AcceleratorConfig) GetAcceleratorCount() int32 {
	if x != nil && x.AcceleratorCount != nil {
		return *x.AcceleratorCount
	}
	return 0
}

func (x *AcceleratorConfig) GetAcceleratorType() string {
	if x != nil && x.AcceleratorType != nil {
		return *x.AcceleratorType
	}
	return ""
}

// Represents an Accelerator Type resource. Google Cloud Platform provides graphics processing units (accelerators) that you can add to VM instances to improve or accelerate performance when working with intensive workloads. For more information, read GPUs on Compute Engine.
type AcceleratorType struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Output Only] Creation timestamp in RFC3339 text format.
	CreationTimestamp *string `protobuf:"bytes,30525366,opt,name=creation_timestamp,json=creationTimestamp,proto3,oneof" json:"creation_timestamp,omitempty"`
	// [Output Only] The deprecation status associated with this accelerator type.
	Deprecated *DeprecationStatus `protobuf:"bytes,515138995,opt,name=deprecated,proto3,oneof" json:"deprecated,omitempty"`
	// [Output Only] An optional textual description of the resource.
	Description *string `protobuf:"bytes,422937596,opt,name=description,proto3,oneof" json:"description,omitempty"`
	// [Output Only] The unique identifier for the resource. This identifier is defined by the server.
	Id *uint64 `protobuf:"varint,3355,opt,name=id,proto3,oneof" json:"id,omitempty"`
	// [Output Only] The type of the resource. Always compute#acceleratorType for accelerator types.
	Kind *string `protobuf:"bytes,3292052,opt,name=kind,proto3,oneof" json:"kind,omitempty"`
	// [Output Only] Maximum number of accelerator cards allowed per instance.
	MaximumCardsPerInstance *int32 `protobuf:"varint,263814482,opt,name=maximum_cards_per_instance,json=maximumCardsPerInstance,proto3,oneof" json:"maximum_cards_per_instance,omitempty"`
	// [Output Only] Name of the resource.
	Name *string `protobuf:"bytes,3373707,opt,name=name,proto3,oneof" json:"name,omitempty"`
	// [Output Only] Server-defined, fully qualified URL for this resource.
	SelfLink *string `protobuf:"bytes,456214797,opt,name=self_link,json=selfLink,proto3,oneof" json:"self_link,omitempty"`
	// [Output Only] The name of the zone where the accelerator type resides, such as us-central1-a. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
	Zone *string `protobuf:"bytes,3744684,opt,name=zone,proto3,oneof" json:"zone,omitempty"`
}

func (x *AcceleratorType) Reset() {
	*x = AcceleratorType{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AcceleratorType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AcceleratorType) ProtoMessage() {}

func (x *AcceleratorType) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AcceleratorType.ProtoReflect.Descriptor instead.
func (*AcceleratorType) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{3}
}

func (x *AcceleratorType) GetCreationTimestamp() string {
	if x != nil && x.CreationTimestamp != nil {
		return *x.CreationTimestamp
	}
	return ""
}

func (x *AcceleratorType) GetDeprecated() *DeprecationStatus {
	if x != nil {
		return x.Deprecated
	}
	return nil
}

func (x *AcceleratorType) GetDescription() string {
	if x != nil && x.Description != nil {
		return *x.Description
	}
	return ""
}

func (x *AcceleratorType) GetId() uint64 {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return 0
}

func (x *AcceleratorType) GetKind() string {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return ""
}

func (x *AcceleratorType) GetMaximumCardsPerInstance() int32 {
	if x != nil && x.MaximumCardsPerInstance != nil {
		return *x.MaximumCardsPerInstance
	}
	return 0
}

func (x *AcceleratorType) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (x *AcceleratorType) GetSelfLink() string {
	if x != nil && x.SelfLink != nil {
		return *x.SelfLink
	}
	return ""
}

func (x *AcceleratorType) GetZone() string {
	if x != nil && x.Zone != nil {
		return *x.Zone
	}
	return ""
}

type AcceleratorTypeAggregatedList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Output Only] Unique identifier for the resource; defined by the server.
	Id *string `protobuf:"bytes,3355,opt,name=id,proto3,oneof" json:"id,omitempty"`
	// A list of AcceleratorTypesScopedList resources.
	Items map[string]*AcceleratorTypesScopedList `protobuf:"bytes,100526016,rep,name=items,proto3" json:"items,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// [Output Only] Type of resource. Always compute#acceleratorTypeAggregatedList for aggregated lists of accelerator types.
	Kind *string `protobuf:"bytes,3292052,opt,name=kind,proto3,oneof" json:"kind,omitempty"`
	// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
	NextPageToken *string `protobuf:"bytes,79797525,opt,name=next_page_token,json=nextPageToken,proto3,oneof" json:"next_page_token,omitempty"`
	// [Output Only] Server-defined URL for this resource.
	SelfLink *string `protobuf:"bytes,456214797,opt,name=self_link,json=selfLink,proto3,oneof" json:"self_link,omitempty"`
	// [Output Only] Unreachable resources.
	Unreachables []string `protobuf:"bytes,243372063,rep,name=unreachables,proto3" json:"unreachables,omitempty"`
	// [Output Only] Informational warning message.
	Warning *Warning `protobuf:"bytes,50704284,opt,name=warning,proto3,oneof" json:"warning,omitempty"`
}

func (x *AcceleratorTypeAggregatedList) Reset() {
	*x = AcceleratorTypeAggregatedList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AcceleratorTypeAggregatedList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AcceleratorTypeAggregatedList) ProtoMessage() {}

func (x *AcceleratorTypeAggregatedList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AcceleratorTypeAggregatedList.ProtoReflect.Descriptor instead.
func (*AcceleratorTypeAggregatedList) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{4}
}

func (x *AcceleratorTypeAggregatedList) GetId() string {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return ""
}

func (x *AcceleratorTypeAggregatedList) GetItems() map[string]*AcceleratorTypesScopedList {
	if x != nil {
		return x.Items
	}
	return nil
}

func (x *AcceleratorTypeAggregatedList) GetKind() string {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return ""
}

func (x *AcceleratorTypeAggregatedList) GetNextPageToken() string {
	if x != nil && x.NextPageToken != nil {
		return *x.NextPageToken
	}
	return ""
}

func (x *AcceleratorTypeAggregatedList) GetSelfLink() string {
	if x != nil && x.SelfLink != nil {
		return *x.SelfLink
	}
	return ""
}

func (x *AcceleratorTypeAggregatedList) GetUnreachables() []string {
	if x != nil {
		return x.Unreachables
	}
	return nil
}

func (x *AcceleratorTypeAggregatedList) GetWarning() *Warning {
	if x != nil {
		return x.Warning
	}
	return nil
}

// Contains a list of accelerator types.
type AcceleratorTypeList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Output Only] Unique identifier for the resource; defined by the server.
	Id *string `protobuf:"bytes,3355,opt,name=id,proto3,oneof" json:"id,omitempty"`
	// A list of AcceleratorType resources.
	Items []*AcceleratorType `protobuf:"bytes,100526016,rep,name=items,proto3" json:"items,omitempty"`
	// [Output Only] Type of resource. Always compute#acceleratorTypeList for lists of accelerator types.
	Kind *string `protobuf:"bytes,3292052,opt,name=kind,proto3,oneof" json:"kind,omitempty"`
	// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
	NextPageToken *string `protobuf:"bytes,79797525,opt,name=next_page_token,json=nextPageToken,proto3,oneof" json:"next_page_token,omitempty"`
	// [Output Only] Server-defined URL for this resource.
	SelfLink *string `protobuf:"bytes,456214797,opt,name=self_link,json=selfLink,proto3,oneof" json:"self_link,omitempty"`
	// [Output Only] Informational warning message.
	Warning *Warning `protobuf:"bytes,50704284,opt,name=warning,proto3,oneof" json:"warning,omitempty"`
}

func (x *AcceleratorTypeList) Reset() {
	*x = AcceleratorTypeList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AcceleratorTypeList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AcceleratorTypeList) ProtoMessage() {}

func (x *AcceleratorTypeList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AcceleratorTypeList.ProtoReflect.Descriptor instead.
func (*AcceleratorTypeList) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{5}
}

func (x *AcceleratorTypeList) GetId() string {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return ""
}

func (x *AcceleratorTypeList) GetItems() []*AcceleratorType {
	if x != nil {
		return x.Items
	}
	return nil
}

func (x *AcceleratorTypeList) GetKind() string {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return ""
}

func (x *AcceleratorTypeList) GetNextPageToken() string {
	if x != nil && x.NextPageToken != nil {
		return *x.NextPageToken
	}
	return ""
}

func (x *AcceleratorTypeList) GetSelfLink() string {
	if x != nil && x.SelfLink != nil {
		return *x.SelfLink
	}
	return ""
}

func (x *AcceleratorTypeList) GetWarning() *Warning {
	if x != nil {
		return x.Warning
	}
	return nil
}

type AcceleratorTypesScopedList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Output Only] A list of accelerator types contained in this scope.
	AcceleratorTypes []*AcceleratorType `protobuf:"bytes,520872357,rep,name=accelerator_types,json=acceleratorTypes,proto3" json:"accelerator_types,omitempty"`
	// [Output Only] An informational warning that appears when the accelerator types list is empty.
	Warning *Warning `protobuf:"bytes,50704284,opt,name=warning,proto3,oneof" json:"warning,omitempty"`
}

func (x *AcceleratorTypesScopedList) Reset() {
	*x = AcceleratorTypesScopedList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AcceleratorTypesScopedList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AcceleratorTypesScopedList) ProtoMessage() {}

func (x *AcceleratorTypesScopedList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AcceleratorTypesScopedList.ProtoReflect.Descriptor instead.
func (*AcceleratorTypesScopedList) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{6}
}

func (x *AcceleratorTypesScopedList) GetAcceleratorTypes() []*AcceleratorType {
	if x != nil {
		return x.AcceleratorTypes
	}
	return nil
}

func (x *AcceleratorTypesScopedList) GetWarning() *Warning {
	if x != nil {
		return x.Warning
	}
	return nil
}

type Accelerators struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Number of accelerator cards exposed to the guest.
	GuestAcceleratorCount *int32 `protobuf:"varint,479079316,opt,name=guest_accelerator_count,json=guestAcceleratorCount,proto3,oneof" json:"guest_accelerator_count,omitempty"`
	// The accelerator type resource name, not a full URL, e.g. 'nvidia-tesla-k80'.
	GuestAcceleratorType *string `protobuf:"bytes,293064725,opt,name=guest_accelerator_type,json=guestAcceleratorType,proto3,oneof" json:"guest_accelerator_type,omitempty"`
}

func (x *Accelerators) Reset() {
	*x = Accelerators{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Accelerators) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Accelerators) ProtoMessage() {}

func (x *Accelerators) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Accelerators.ProtoReflect.Descriptor instead.
func (*Accelerators) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{7}
}

func (x *Accelerators) GetGuestAcceleratorCount() int32 {
	if x != nil && x.GuestAcceleratorCount != nil {
		return *x.GuestAcceleratorCount
	}
	return 0
}

func (x *Accelerators) GetGuestAcceleratorType() string {
	if x != nil && x.GuestAcceleratorType != nil {
		return *x.GuestAcceleratorType
	}
	return ""
}

// An access configuration attached to an instance's network interface. Only one access config per instance is supported.
type AccessConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The first IPv6 address of the external IPv6 range associated with this instance, prefix length is stored in externalIpv6PrefixLength in ipv6AccessConfig. To use a static external IP address, it must be unused and in the same region as the instance's zone. If not specified, Google Cloud will automatically assign an external IPv6 address from the instance's subnetwork.
	ExternalIpv6 *string `protobuf:"bytes,532703707,opt,name=external_ipv6,json=externalIpv6,proto3,oneof" json:"external_ipv6,omitempty"`
	// The prefix length of the external IPv6 range.
	ExternalIpv6PrefixLength *int32 `protobuf:"varint,425672143,opt,name=external_ipv6_prefix_length,json=externalIpv6PrefixLength,proto3,oneof" json:"external_ipv6_prefix_length,omitempty"`
	// [Output Only] Type of the resource. Always compute#accessConfig for access configs.
	Kind *string `protobuf:"bytes,3292052,opt,name=kind,proto3,oneof" json:"kind,omitempty"`
	// The name of this access configuration. The default and recommended name is External NAT, but you can use any arbitrary string, such as My external IP or Network Access.
	Name *string `protobuf:"bytes,3373707,opt,name=name,proto3,oneof" json:"name,omitempty"`
	// An external IP address associated with this instance. Specify an unused static external IP address available to the project or leave this field undefined to use an IP from a shared ephemeral IP address pool. If you specify a static external IP address, it must live in the same region as the zone of the instance.
	NatIP *string `protobuf:"bytes,117634556,opt,name=nat_i_p,json=natIP,proto3,oneof" json:"nat_i_p,omitempty"`
	// This signifies the networking tier used for configuring this access configuration and can only take the following values: PREMIUM, STANDARD. If an AccessConfig is specified without a valid external IP address, an ephemeral IP will be created with this networkTier. If an AccessConfig with a valid external IP address is specified, it must match that of the networkTier associated with the Address resource owning that IP.
	// Check the NetworkTier enum for the list of possible values.
	NetworkTier *string `protobuf:"bytes,517397843,opt,name=network_tier,json=networkTier,proto3,oneof" json:"network_tier,omitempty"`
	// The DNS domain name for the public PTR record. You can set this field only if the `setPublicPtr` field is enabled in accessConfig. If this field is unspecified in ipv6AccessConfig, a default PTR record will be createc for first IP in associated external IPv6 range.
	PublicPtrDomainName *string `protobuf:"bytes,316599167,opt,name=public_ptr_domain_name,json=publicPtrDomainName,proto3,oneof" json:"public_ptr_domain_name,omitempty"`
	// Specifies whether a public DNS 'PTR' record should be created to map the external IP address of the instance to a DNS domain name. This field is not used in ipv6AccessConfig. A default PTR record will be created if the VM has external IPv6 range associated.
	SetPublicPtr *bool `protobuf:"varint,523870229,opt,name=set_public_ptr,json=setPublicPtr,proto3,oneof" json:"set_public_ptr,omitempty"`
	// The type of configuration. The default and only option is ONE_TO_ONE_NAT.
	// Check the Type enum for the list of possible values.
	Type *string `protobuf:"bytes,3575610,opt,name=type,proto3,oneof" json:"type,omitempty"`
}

func (x *AccessConfig) Reset() {
	*x = AccessConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AccessConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccessConfig) ProtoMessage() {}

func (x *AccessConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccessConfig.ProtoReflect.Descriptor instead.
func (*AccessConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{8}
}

func (x *AccessConfig) GetExternalIpv6() string {
	if x != nil && x.ExternalIpv6 != nil {
		return *x.ExternalIpv6
	}
	return ""
}

func (x *AccessConfig) GetExternalIpv6PrefixLength() int32 {
	if x != nil && x.ExternalIpv6PrefixLength != nil {
		return *x.ExternalIpv6PrefixLength
	}
	return 0
}

func (x *AccessConfig) GetKind() string {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return ""
}

func (x *AccessConfig) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (x *AccessConfig) GetNatIP() string {
	if x != nil && x.NatIP != nil {
		return *x.NatIP
	}
	return ""
}

func (x *AccessConfig) GetNetworkTier() string {
	if x != nil && x.NetworkTier != nil {
		return *x.NetworkTier
	}
	return ""
}

func (x *AccessConfig) GetPublicPtrDomainName() string {
	if x != nil && x.PublicPtrDomainName != nil {
		return *x.PublicPtrDomainName
	}
	return ""
}

func (x *AccessConfig) GetSetPublicPtr() bool {
	if x != nil && x.SetPublicPtr != nil {
		return *x.SetPublicPtr
	}
	return false
}

func (x *AccessConfig) GetType() string {
	if x != nil && x.Type != nil {
		return *x.Type
	}
	return ""
}

// A request message for Instances.AddAccessConfig. See the method description for details.
type AddAccessConfigInstanceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The body resource for this request
	AccessConfigResource *AccessConfig `protobuf:"bytes,387825552,opt,name=access_config_resource,json=accessConfigResource,proto3" json:"access_config_resource,omitempty"`
	// The instance name for this request.
	Instance string `protobuf:"bytes,18257045,opt,name=instance,proto3" json:"instance,omitempty"`
	// The name of the network interface to add to this instance.
	NetworkInterface string `protobuf:"bytes,365387880,opt,name=network_interface,json=networkInterface,proto3" json:"network_interface,omitempty"`
	// Project ID for this request.
	Project string `protobuf:"bytes,227560217,opt,name=project,proto3" json:"project,omitempty"`
	// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
	RequestId *string `protobuf:"bytes,37109963,opt,name=request_id,json=requestId,proto3,oneof" json:"request_id,omitempty"`
	// The name of the zone for this request.
	Zone string `protobuf:"bytes,3744684,opt,name=zone,proto3" json:"zone,omitempty"`
}

func (x *AddAccessConfigInstanceRequest) Reset() {
	*x = AddAccessConfigInstanceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddAccessConfigInstanceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddAccessConfigInstanceRequest) ProtoMessage() {}

func (x *AddAccessConfigInstanceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddAccessConfigInstanceRequest.ProtoReflect.Descriptor instead.
func (*AddAccessConfigInstanceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{9}
}

func (x *AddAccessConfigInstanceRequest) GetAccessConfigResource() *AccessConfig {
	if x != nil {
		return x.AccessConfigResource
	}
	return nil
}

func (x *AddAccessConfigInstanceRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *AddAccessConfigInstanceRequest) GetNetworkInterface() string {
	if x != nil {
		return x.NetworkInterface
	}
	return ""
}

func (x *AddAccessConfigInstanceRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *AddAccessConfigInstanceRequest) GetRequestId() string {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return ""
}

func (x *AddAccessConfigInstanceRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// A request message for FirewallPolicies.AddAssociation. See the method description for details.
type AddAssociationFirewallPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the firewall policy to update.
	FirewallPolicy string `protobuf:"bytes,498173265,opt,name=firewall_policy,json=firewallPolicy,proto3" json:"firewall_policy,omitempty"`
	// The body resource for this request
	FirewallPolicyAssociationResource *FirewallPolicyAssociation `protobuf:"bytes,259546170,opt,name=firewall_policy_association_resource,json=firewallPolicyAssociationResource,proto3" json:"firewall_policy_association_resource,omitempty"`
	// Indicates whether or not to replace it if an association of the attachment already exists. This is false by default, in which case an error will be returned if an association already exists.
	ReplaceExistingAssociation *bool `protobuf:"varint,209541240,opt,name=replace_existing_association,json=replaceExistingAssociation,proto3,oneof" json:"replace_existing_association,omitempty"`
	// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
	RequestId *string `protobuf:"bytes,37109963,opt,name=request_id,json=requestId,proto3,oneof" json:"request_id,omitempty"`
}

func (x *AddAssociationFirewallPolicyRequest) Reset() {
	*x = AddAssociationFirewallPolicyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddAssociationFirewallPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddAssociationFirewallPolicyRequest) ProtoMessage() {}

func (x *AddAssociationFirewallPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddAssociationFirewallPolicyRequest.ProtoReflect.Descriptor instead.
func (*AddAssociationFirewallPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{10}
}

func (x *AddAssociationFirewallPolicyRequest) GetFirewallPolicy() string {
	if x != nil {
		return x.FirewallPolicy
	}
	return ""
}

func (x *AddAssociationFirewallPolicyRequest) GetFirewallPolicyAssociationResource() *FirewallPolicyAssociation {
	if x != nil {
		return x.FirewallPolicyAssociationResource
	}
	return nil
}

func (x *AddAssociationFirewallPolicyRequest) GetReplaceExistingAssociation() bool {
	if x != nil && x.ReplaceExistingAssociation != nil {
		return *x.ReplaceExistingAssociation
	}
	return false
}

func (x *AddAssociationFirewallPolicyRequest) GetRequestId() string {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return ""
}

// A request message for NetworkFirewallPolicies.AddAssociation. See the method description for details.
type AddAssociationNetworkFirewallPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the firewall policy to update.
	FirewallPolicy string `protobuf:"bytes,498173265,opt,name=firewall_policy,json=firewallPolicy,proto3" json:"firewall_policy,omitempty"`
	// The body resource for this request
	FirewallPolicyAssociationResource *FirewallPolicyAssociation `protobuf:"bytes,259546170,opt,name=firewall_policy_association_resource,json=firewallPolicyAssociationResource,proto3" json:"firewall_policy_association_resource,omitempty"`
	// Project ID for this request.
	Project string `protobuf:"bytes,227560217,opt,name=project,proto3" json:"project,omitempty"`
	// Indicates whether or not to replace it if an association of the attachment already exists. This is false by default, in which case an error will be returned if an association already exists.
	ReplaceExistingAssociation *bool `protobuf:"varint,209541240,opt,name=replace_existing_association,json=replaceExistingAssociation,proto3,oneof" json:"replace_existing_association,omitempty"`
	// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
	RequestId *string `protobuf:"bytes,37109963,opt,name=request_id,json=requestId,proto3,oneof" json:"request_id,omitempty"`
}

func (x *AddAssociationNetworkFirewallPolicyRequest) Reset() {
	*x = AddAssociationNetworkFirewallPolicyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddAssociationNetworkFirewallPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddAssociationNetworkFirewallPolicyRequest) ProtoMessage() {}

func (x *AddAssociationNetworkFirewallPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddAssociationNetworkFirewallPolicyRequest.ProtoReflect.Descriptor instead.
func (*AddAssociationNetworkFirewallPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{11}
}

func (x *AddAssociationNetworkFirewallPolicyRequest) GetFirewallPolicy() string {
	if x != nil {
		return x.FirewallPolicy
	}
	return ""
}

func (x *AddAssociationNetworkFirewallPolicyRequest) GetFirewallPolicyAssociationResource() *FirewallPolicyAssociation {
	if x != nil {
		return x.FirewallPolicyAssociationResource
	}
	return nil
}

func (x *AddAssociationNetworkFirewallPolicyRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *AddAssociationNetworkFirewallPolicyRequest) GetReplaceExistingAssociation() bool {
	if x != nil && x.ReplaceExistingAssociation != nil {
		return *x.ReplaceExistingAssociation
	}
	return false
}

func (x *AddAssociationNetworkFirewallPolicyRequest) GetRequestId() string {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return ""
}

// A request message for RegionNetworkFirewallPolicies.AddAssociation. See the method description for details.
type AddAssociationRegionNetworkFirewallPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the firewall policy to update.
	FirewallPolicy string `protobuf:"bytes,498173265,opt,name=firewall_policy,json=firewallPolicy,proto3" json:"firewall_policy,omitempty"`
	// The body resource for this request
	FirewallPolicyAssociationResource *FirewallPolicyAssociation `protobuf:"bytes,259546170,opt,name=firewall_policy_association_resource,json=firewallPolicyAssociationResource,proto3" json:"firewall_policy_association_resource,omitempty"`
	// Project ID for this request.
	Project string `protobuf:"bytes,227560217,opt,name=project,proto3" json:"project,omitempty"`
	// Name of the region scoping this request.
	Region string `protobuf:"bytes,138946292,opt,name=region,proto3" json:"region,omitempty"`
	// Indicates whether or not to replace it if an association already exists. This is false by default, in which case an error will be returned if an association already exists.
	ReplaceExistingAssociation *bool `protobuf:"varint,209541240,opt,name=replace_existing_association,json=replaceExistingAssociation,proto3,oneof" json:"replace_existing_association,omitempty"`
	// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
	RequestId *string `protobuf:"bytes,37109963,opt,name=request_id,json=requestId,proto3,oneof" json:"request_id,omitempty"`
}

func (x *AddAssociationRegionNetworkFirewallPolicyRequest) Reset() {
	*x = AddAssociationRegionNetworkFirewallPolicyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddAssociationRegionNetworkFirewallPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddAssociationRegionNetworkFirewallPolicyRequest) ProtoMessage() {}

func (x *AddAssociationRegionNetworkFirewallPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddAssociationRegionNetworkFirewallPolicyRequest.ProtoReflect.Descriptor instead.
func (*AddAssociationRegionNetworkFirewallPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{12}
}

func (x *AddAssociationRegionNetworkFirewallPolicyRequest) GetFirewallPolicy() string {
	if x != nil {
		return x.FirewallPolicy
	}
	return ""
}

func (x *AddAssociationRegionNetworkFirewallPolicyRequest) GetFirewallPolicyAssociationResource() *FirewallPolicyAssociation {
	if x != nil {
		return x.FirewallPolicyAssociationResource
	}
	return nil
}

func (x *AddAssociationRegionNetworkFirewallPolicyRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *AddAssociationRegionNetworkFirewallPolicyRequest) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

func (x *AddAssociationRegionNetworkFirewallPolicyRequest) GetReplaceExistingAssociation() bool {
	if x != nil && x.ReplaceExistingAssociation != nil {
		return *x.ReplaceExistingAssociation
	}
	return false
}

func (x *AddAssociationRegionNetworkFirewallPolicyRequest) GetRequestId() string {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return ""
}

// A request message for TargetPools.AddHealthCheck. See the method description for details.
type AddHealthCheckTargetPoolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Project ID for this request.
	Project string `protobuf:"bytes,227560217,opt,name=project,proto3" json:"project,omitempty"`
	// Name of the region scoping this request.
	Region string `protobuf:"bytes,138946292,opt,name=region,proto3" json:"region,omitempty"`
	// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
	RequestId *string `protobuf:"bytes,37109963,opt,name=request_id,json=requestId,proto3,oneof" json:"request_id,omitempty"`
	// Name of the target pool to add a health check to.
	TargetPool string `protobuf:"bytes,62796298,opt,name=target_pool,json=targetPool,proto3" json:"target_pool,omitempty"`
	// The body resource for this request
	TargetPoolsAddHealthCheckRequestResource *TargetPoolsAddHealthCheckRequest `protobuf:"bytes,269573412,opt,name=target_pools_add_health_check_request_resource,json=targetPoolsAddHealthCheckRequestResource,proto3" json:"target_pools_add_health_check_request_resource,omitempty"`
}

func (x *AddHealthCheckTargetPoolRequest) Reset() {
	*x = AddHealthCheckTargetPoolRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddHealthCheckTargetPoolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddHealthCheckTargetPoolRequest) ProtoMessage() {}

func (x *AddHealthCheckTargetPoolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddHealthCheckTargetPoolRequest.ProtoReflect.Descriptor instead.
func (*AddHealthCheckTargetPoolRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{13}
}

func (x *AddHealthCheckTargetPoolRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *AddHealthCheckTargetPoolRequest) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

func (x *AddHealthCheckTargetPoolRequest) GetRequestId() string {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return ""
}

func (x *AddHealthCheckTargetPoolRequest) GetTargetPool() string {
	if x != nil {
		return x.TargetPool
	}
	return ""
}

func (x *AddHealthCheckTargetPoolRequest) GetTargetPoolsAddHealthCheckRequestResource() *TargetPoolsAddHealthCheckRequest {
	if x != nil {
		return x.TargetPoolsAddHealthCheckRequestResource
	}
	return nil
}

// A request message for TargetPools.AddInstance. See the method description for details.
type AddInstanceTargetPoolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Project ID for this request.
	Project string `protobuf:"bytes,227560217,opt,name=project,proto3" json:"project,omitempty"`
	// Name of the region scoping this request.
	Region string `protobuf:"bytes,138946292,opt,name=region,proto3" json:"region,omitempty"`
	// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
	RequestId *string `protobuf:"bytes,37109963,opt,name=request_id,json=requestId,proto3,oneof" json:"request_id,omitempty"`
	// Name of the TargetPool resource to add instances to.
	TargetPool string `protobuf:"bytes,62796298,opt,name=target_pool,json=targetPool,proto3" json:"target_pool,omitempty"`
	// The body resource for this request
	TargetPoolsAddInstanceRequestResource *TargetPoolsAddInstanceRequest `protobuf:"bytes,428796404,opt,name=target_pools_add_instance_request_resource,json=targetPoolsAddInstanceRequestResource,proto3" json:"target_pools_add_instance_request_resource,omitempty"`
}

func (x *AddInstanceTargetPoolRequest) Reset() {
	*x = AddInstanceTargetPoolRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddInstanceTargetPoolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddInstanceTargetPoolRequest) ProtoMessage() {}

func (x *AddInstanceTargetPoolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddInstanceTargetPoolRequest.ProtoReflect.Descriptor instead.
func (*AddInstanceTargetPoolRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{14}
}

func (x *AddInstanceTargetPoolRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *AddInstanceTargetPoolRequest) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

func (x *AddInstanceTargetPoolRequest) GetRequestId() string {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return ""
}

func (x *AddInstanceTargetPoolRequest) GetTargetPool() string {
	if x != nil {
		return x.TargetPool
	}
	return ""
}

func (x *AddInstanceTargetPoolRequest) GetTargetPoolsAddInstanceRequestResource() *TargetPoolsAddInstanceRequest {
	if x != nil {
		return x.TargetPoolsAddInstanceRequestResource
	}
	return nil
}

// A request message for InstanceGroups.AddInstances. See the method description for details.
type AddInstancesInstanceGroupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the instance group where you are adding instances.
	InstanceGroup string `protobuf:"bytes,81095253,opt,name=instance_group,json=instanceGroup,proto3" json:"instance_group,omitempty"`
	// The body resource for this request
	InstanceGroupsAddInstancesRequestResource *InstanceGroupsAddInstancesRequest `protobuf:"bytes,453713246,opt,name=instance_groups_add_instances_request_resource,json=instanceGroupsAddInstancesRequestResource,proto3" json:"instance_groups_add_instances_request_resource,omitempty"`
	// Project ID for this request.
	Project string `protobuf:"bytes,227560217,opt,name=project,proto3" json:"project,omitempty"`
	// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
	RequestId *string `protobuf:"bytes,37109963,opt,name=request_id,json=requestId,proto3,oneof" json:"request_id,omitempty"`
	// The name of the zone where the instance group is located.
	Zone string `protobuf:"bytes,3744684,opt,name=zone,proto3" json:"zone,omitempty"`
}

func (x *AddInstancesInstanceGroupRequest) Reset() {
	*x = AddInstancesInstanceGroupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddInstancesInstanceGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddInstancesInstanceGroupRequest) ProtoMessage() {}

func (x *AddInstancesInstanceGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddInstancesInstanceGroupRequest.ProtoReflect.Descriptor instead.
func (*AddInstancesInstanceGroupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{15}
}

func (x *AddInstancesInstanceGroupRequest) GetInstanceGroup() string {
	if x != nil {
		return x.InstanceGroup
	}
	return ""
}

func (x *AddInstancesInstanceGroupRequest) GetInstanceGroupsAddInstancesRequestResource() *InstanceGroupsAddInstancesRequest {
	if x != nil {
		return x.InstanceGroupsAddInstancesRequestResource
	}
	return nil
}

func (x *AddInstancesInstanceGroupRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *AddInstancesInstanceGroupRequest) GetRequestId() string {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return ""
}

func (x *AddInstancesInstanceGroupRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// A request message for NodeGroups.AddNodes. See the method description for details.
type AddNodesNodeGroupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the NodeGroup resource.
	NodeGroup string `protobuf:"bytes,469958146,opt,name=node_group,json=nodeGroup,proto3" json:"node_group,omitempty"`
	// The body resource for this request
	NodeGroupsAddNodesRequestResource *NodeGroupsAddNodesRequest `protobuf:"bytes,131263288,opt,name=node_groups_add_nodes_request_resource,json=nodeGroupsAddNodesRequestResource,proto3" json:"node_groups_add_nodes_request_resource,omitempty"`
	// Project ID for this request.
	Project string `protobuf:"bytes,227560217,opt,name=project,proto3" json:"project,omitempty"`
	// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
	RequestId *string `protobuf:"bytes,37109963,opt,name=request_id,json=requestId,proto3,oneof" json:"request_id,omitempty"`
	// The name of the zone for this request.
	Zone string `protobuf:"bytes,3744684,opt,name=zone,proto3" json:"zone,omitempty"`
}

func (x *AddNodesNodeGroupRequest) Reset() {
	*x = AddNodesNodeGroupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddNodesNodeGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddNodesNodeGroupRequest) ProtoMessage() {}

func (x *AddNodesNodeGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddNodesNodeGroupRequest.ProtoReflect.Descriptor instead.
func (*AddNodesNodeGroupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{16}
}

func (x *AddNodesNodeGroupRequest) GetNodeGroup() string {
	if x != nil {
		return x.NodeGroup
	}
	return ""
}

func (x *AddNodesNodeGroupRequest) GetNodeGroupsAddNodesRequestResource() *NodeGroupsAddNodesRequest {
	if x != nil {
		return x.NodeGroupsAddNodesRequestResource
	}
	return nil
}

func (x *AddNodesNodeGroupRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *AddNodesNodeGroupRequest) GetRequestId() string {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return ""
}

func (x *AddNodesNodeGroupRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// A request message for Networks.AddPeering. See the method description for details.
type AddPeeringNetworkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the network resource to add peering to.
	Network string `protobuf:"bytes,232872494,opt,name=network,proto3" json:"network,omitempty"`
	// The body resource for this request
	NetworksAddPeeringRequestResource *NetworksAddPeeringRequest `protobuf:"bytes,388810421,opt,name=networks_add_peering_request_resource,json=networksAddPeeringRequestResource,proto3" json:"networks_add_peering_request_resource,omitempty"`
	// Project ID for this request.
	Project string `protobuf:"bytes,227560217,opt,name=project,proto3" json:"project,omitempty"`
	// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
	RequestId *string `protobuf:"bytes,37109963,opt,name=request_id,json=requestId,proto3,oneof" json:"request_id,omitempty"`
}

func (x *AddPeeringNetworkRequest) Reset() {
	*x = AddPeeringNetworkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddPeeringNetworkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddPeeringNetworkRequest) ProtoMessage() {}

func (x *AddPeeringNetworkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddPeeringNetworkRequest.ProtoReflect.Descriptor instead.
func (*AddPeeringNetworkRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{17}
}

func (x *AddPeeringNetworkRequest) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *AddPeeringNetworkRequest) GetNetworksAddPeeringRequestResource() *NetworksAddPeeringRequest {
	if x != nil {
		return x.NetworksAddPeeringRequestResource
	}
	return nil
}

func (x *AddPeeringNetworkRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *AddPeeringNetworkRequest) GetRequestId() string {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return ""
}

// A request message for Disks.AddResourcePolicies. See the method description for details.
type AddResourcePoliciesDiskRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The disk name for this request.
	Disk string `protobuf:"bytes,3083677,opt,name=disk,proto3" json:"disk,omitempty"`
	// The body resource for this request
	DisksAddResourcePoliciesRequestResource *DisksAddResourcePoliciesRequest `protobuf:"bytes,496483363,opt,name=disks_add_resource_policies_request_resource,json=disksAddResourcePoliciesRequestResource,proto3" json:"disks_add_resource_policies_request_resource,omitempty"`
	// Project ID for this request.
	Project string `protobuf:"bytes,227560217,opt,name=project,proto3" json:"project,omitempty"`
	// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
	RequestId *string `protobuf:"bytes,37109963,opt,name=request_id,json=requestId,proto3,oneof" json:"request_id,omitempty"`
	// The name of the zone for this request.
	Zone string `protobuf:"bytes,3744684,opt,name=zone,proto3" json:"zone,omitempty"`
}

func (x *AddResourcePoliciesDiskRequest) Reset() {
	*x = AddResourcePoliciesDiskRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddResourcePoliciesDiskRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddResourcePoliciesDiskRequest) ProtoMessage() {}

func (x *AddResourcePoliciesDiskRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddResourcePoliciesDiskRequest.ProtoReflect.Descriptor instead.
func (*AddResourcePoliciesDiskRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{18}
}

func (x *AddResourcePoliciesDiskRequest) GetDisk() string {
	if x != nil {
		return x.Disk
	}
	return ""
}

func (x *AddResourcePoliciesDiskRequest) GetDisksAddResourcePoliciesRequestResource() *DisksAddResourcePoliciesRequest {
	if x != nil {
		return x.DisksAddResourcePoliciesRequestResource
	}
	return nil
}

func (x *AddResourcePoliciesDiskRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *AddResourcePoliciesDiskRequest) GetRequestId() string {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return ""
}

func (x *AddResourcePoliciesDiskRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// A request message for Instances.AddResourcePolicies. See the method description for details.
type AddResourcePoliciesInstanceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The instance name for this request.
	Instance string `protobuf:"bytes,18257045,opt,name=instance,proto3" json:"instance,omitempty"`
	// The body resource for this request
	InstancesAddResourcePoliciesRequestResource *InstancesAddResourcePoliciesRequest `protobuf:"bytes,489351963,opt,name=instances_add_resource_policies_request_resource,json=instancesAddResourcePoliciesRequestResource,proto3" json:"instances_add_resource_policies_request_resource,omitempty"`
	// Project ID for this request.
	Project string `protobuf:"bytes,227560217,opt,name=project,proto3" json:"project,omitempty"`
	// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
	RequestId *string `protobuf:"bytes,37109963,opt,name=request_id,json=requestId,proto3,oneof" json:"request_id,omitempty"`
	// The name of the zone for this request.
	Zone string `protobuf:"bytes,3744684,opt,name=zone,proto3" json:"zone,omitempty"`
}

func (x *AddResourcePoliciesInstanceRequest) Reset() {
	*x = AddResourcePoliciesInstanceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddResourcePoliciesInstanceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddResourcePoliciesInstanceRequest) ProtoMessage() {}

func (x *AddResourcePoliciesInstanceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddResourcePoliciesInstanceRequest.ProtoReflect.Descriptor instead.
func (*AddResourcePoliciesInstanceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{19}
}

func (x *AddResourcePoliciesInstanceRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *AddResourcePoliciesInstanceRequest) GetInstancesAddResourcePoliciesRequestResource() *InstancesAddResourcePoliciesRequest {
	if x != nil {
		return x.InstancesAddResourcePoliciesRequestResource
	}
	return nil
}

func (x *AddResourcePoliciesInstanceRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *AddResourcePoliciesInstanceRequest) GetRequestId() string {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return ""
}

func (x *AddResourcePoliciesInstanceRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// A request message for RegionDisks.AddResourcePolicies. See the method description for details.
type AddResourcePoliciesRegionDiskRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The disk name for this request.
	Disk string `protobuf:"bytes,3083677,opt,name=disk,proto3" json:"disk,omitempty"`
	// Project ID for this request.
	Project string `protobuf:"bytes,227560217,opt,name=project,proto3" json:"project,omitempty"`
	// The name of the region for this request.
	Region string `protobuf:"bytes,138946292,opt,name=region,proto3" json:"region,omitempty"`
	// The body resource for this request
	RegionDisksAddResourcePoliciesRequestResource *RegionDisksAddResourcePoliciesRequest `protobuf:"bytes,284196750,opt,name=region_disks_add_resource_policies_request_resource,json=regionDisksAddResourcePoliciesRequestResource,proto3" json:"region_disks_add_resource_policies_request_resource,omitempty"`
	// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
	RequestId *string `protobuf:"bytes,37109963,opt,name=request_id,json=requestId,proto3,oneof" json:"request_id,omitempty"`
}

func (x *AddResourcePoliciesRegionDiskRequest) Reset() {
	*x = AddResourcePoliciesRegionDiskRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddResourcePoliciesRegionDiskRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddResourcePoliciesRegionDiskRequest) ProtoMessage() {}

func (x *AddResourcePoliciesRegionDiskRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddResourcePoliciesRegionDiskRequest.ProtoReflect.Descriptor instead.
func (*AddResourcePoliciesRegionDiskRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{20}
}

func (x *AddResourcePoliciesRegionDiskRequest) GetDisk() string {
	if x != nil {
		return x.Disk
	}
	return ""
}

func (x *AddResourcePoliciesRegionDiskRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *AddResourcePoliciesRegionDiskRequest) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

func (x *AddResourcePoliciesRegionDiskRequest) GetRegionDisksAddResourcePoliciesRequestResource() *RegionDisksAddResourcePoliciesRequest {
	if x != nil {
		return x.RegionDisksAddResourcePoliciesRequestResource
	}
	return nil
}

func (x *AddResourcePoliciesRegionDiskRequest) GetRequestId() string {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return ""
}

// A request message for FirewallPolicies.AddRule. See the method description for details.
type AddRuleFirewallPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the firewall policy to update.
	FirewallPolicy string `protobuf:"bytes,498173265,opt,name=firewall_policy,json=firewallPolicy,proto3" json:"firewall_policy,omitempty"`
	// The body resource for this request
	FirewallPolicyRuleResource *FirewallPolicyRule `protobuf:"bytes,250523523,opt,name=firewall_policy_rule_resource,json=firewallPolicyRuleResource,proto3" json:"firewall_policy_rule_resource,omitempty"`
	// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
	RequestId *string `protobuf:"bytes,37109963,opt,name=request_id,json=requestId,proto3,oneof" json:"request_id,omitempty"`
}

func (x *AddRuleFirewallPolicyRequest) Reset() {
	*x = AddRuleFirewallPolicyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddRuleFirewallPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddRuleFirewallPolicyRequest) ProtoMessage() {}

func (x *AddRuleFirewallPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddRuleFirewallPolicyRequest.ProtoReflect.Descriptor instead.
func (*AddRuleFirewallPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{21}
}

func (x *AddRuleFirewallPolicyRequest) GetFirewallPolicy() string {
	if x != nil {
		return x.FirewallPolicy
	}
	return ""
}

func (x *AddRuleFirewallPolicyRequest) GetFirewallPolicyRuleResource() *FirewallPolicyRule {
	if x != nil {
		return x.FirewallPolicyRuleResource
	}
	return nil
}

func (x *AddRuleFirewallPolicyRequest) GetRequestId() string {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return ""
}

// A request message for NetworkFirewallPolicies.AddRule. See the method description for details.
type AddRuleNetworkFirewallPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the firewall policy to update.
	FirewallPolicy string `protobuf:"bytes,498173265,opt,name=firewall_policy,json=firewallPolicy,proto3" json:"firewall_policy,omitempty"`
	// The body resource for this request
	FirewallPolicyRuleResource *FirewallPolicyRule `protobuf:"bytes,250523523,opt,name=firewall_policy_rule_resource,json=firewallPolicyRuleResource,proto3" json:"firewall_policy_rule_resource,omitempty"`
	// When rule.priority is not specified, auto choose a unused priority between minPriority and maxPriority>. This field is exclusive with rule.priority.
	MaxPriority *int32 `protobuf:"varint,329635359,opt,name=max_priority,json=maxPriority,proto3,oneof" json:"max_priority,omitempty"`
	// When rule.priority is not specified, auto choose a unused priority between minPriority and maxPriority>. This field is exclusive with rule.priority.
	MinPriority *int32 `protobuf:"varint,267190513,opt,name=min_priority,json=minPriority,proto3,oneof" json:"min_priority,omitempty"`
	// Project ID for this request.
	Project string `protobuf:"bytes,227560217,opt,name=project,proto3" json:"project,omitempty"`
	// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
	RequestId *string `protobuf:"bytes,37109963,opt,name=request_id,json=requestId,proto3,oneof" json:"request_id,omitempty"`
}

func (x *AddRuleNetworkFirewallPolicyRequest) Reset() {
	*x = AddRuleNetworkFirewallPolicyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddRuleNetworkFirewallPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddRuleNetworkFirewallPolicyRequest) ProtoMessage() {}

func (x *AddRuleNetworkFirewallPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddRuleNetworkFirewallPolicyRequest.ProtoReflect.Descriptor instead.
func (*AddRuleNetworkFirewallPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{22}
}

func (x *AddRuleNetworkFirewallPolicyRequest) GetFirewallPolicy() string {
	if x != nil {
		return x.FirewallPolicy
	}
	return ""
}

func (x *AddRuleNetworkFirewallPolicyRequest) GetFirewallPolicyRuleResource() *FirewallPolicyRule {
	if x != nil {
		return x.FirewallPolicyRuleResource
	}
	return nil
}

func (x *AddRuleNetworkFirewallPolicyRequest) GetMaxPriority() int32 {
	if x != nil && x.MaxPriority != nil {
		return *x.MaxPriority
	}
	return 0
}

func (x *AddRuleNetworkFirewallPolicyRequest) GetMinPriority() int32 {
	if x != nil && x.MinPriority != nil {
		return *x.MinPriority
	}
	return 0
}

func (x *AddRuleNetworkFirewallPolicyRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *AddRuleNetworkFirewallPolicyRequest) GetRequestId() string {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return ""
}

// A request message for RegionNetworkFirewallPolicies.AddRule. See the method description for details.
type AddRuleRegionNetworkFirewallPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the firewall policy to update.
	FirewallPolicy string `protobuf:"bytes,498173265,opt,name=firewall_policy,json=firewallPolicy,proto3" json:"firewall_policy,omitempty"`
	// The body resource for this request
	FirewallPolicyRuleResource *FirewallPolicyRule `protobuf:"bytes,250523523,opt,name=firewall_policy_rule_resource,json=firewallPolicyRuleResource,proto3" json:"firewall_policy_rule_resource,omitempty"`
	// When rule.priority is not specified, auto choose a unused priority between minPriority and maxPriority>. This field is exclusive with rule.priority.
	MaxPriority *int32 `protobuf:"varint,329635359,opt,name=max_priority,json=maxPriority,proto3,oneof" json:"max_priority,omitempty"`
	// When rule.priority is not specified, auto choose a unused priority between minPriority and maxPriority>. This field is exclusive with rule.priority.
	MinPriority *int32 `protobuf:"varint,267190513,opt,name=min_priority,json=minPriority,proto3,oneof" json:"min_priority,omitempty"`
	// Project ID for this request.
	Project string `protobuf:"bytes,227560217,opt,name=project,proto3" json:"project,omitempty"`
	// Name of the region scoping this request.
	Region string `protobuf:"bytes,138946292,opt,name=region,proto3" json:"region,omitempty"`
	// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
	RequestId *string `protobuf:"bytes,37109963,opt,name=request_id,json=requestId,proto3,oneof" json:"request_id,omitempty"`
}

func (x *AddRuleRegionNetworkFirewallPolicyRequest) Reset() {
	*x = AddRuleRegionNetworkFirewallPolicyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddRuleRegionNetworkFirewallPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddRuleRegionNetworkFirewallPolicyRequest) ProtoMessage() {}

func (x *AddRuleRegionNetworkFirewallPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddRuleRegionNetworkFirewallPolicyRequest.ProtoReflect.Descriptor instead.
func (*AddRuleRegionNetworkFirewallPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{23}
}

func (x *AddRuleRegionNetworkFirewallPolicyRequest) GetFirewallPolicy() string {
	if x != nil {
		return x.FirewallPolicy
	}
	return ""
}

func (x *AddRuleRegionNetworkFirewallPolicyRequest) GetFirewallPolicyRuleResource() *FirewallPolicyRule {
	if x != nil {
		return x.FirewallPolicyRuleResource
	}
	return nil
}

func (x *AddRuleRegionNetworkFirewallPolicyRequest) GetMaxPriority() int32 {
	if x != nil && x.MaxPriority != nil {
		return *x.MaxPriority
	}
	return 0
}

func (x *AddRuleRegionNetworkFirewallPolicyRequest) GetMinPriority() int32 {
	if x != nil && x.MinPriority != nil {
		return *x.MinPriority
	}
	return 0
}

func (x *AddRuleRegionNetworkFirewallPolicyRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *AddRuleRegionNetworkFirewallPolicyRequest) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

func (x *AddRuleRegionNetworkFirewallPolicyRequest) GetRequestId() string {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return ""
}

// A request message for SecurityPolicies.AddRule. See the method description for details.
type AddRuleSecurityPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Project ID for this request.
	Project string `protobuf:"bytes,227560217,opt,name=project,proto3" json:"project,omitempty"`
	// Name of the security policy to update.
	SecurityPolicy string `protobuf:"bytes,171082513,opt,name=security_policy,json=securityPolicy,proto3" json:"security_policy,omitempty"`
	// The body resource for this request
	SecurityPolicyRuleResource *SecurityPolicyRule `protobuf:"bytes,402693443,opt,name=security_policy_rule_resource,json=securityPolicyRuleResource,proto3" json:"security_policy_rule_resource,omitempty"`
	// If true, the request will not be committed.
	ValidateOnly *bool `protobuf:"varint,242744629,opt,name=validate_only,json=validateOnly,proto3,oneof" json:"validate_only,omitempty"`
}

func (x *AddRuleSecurityPolicyRequest) Reset() {
	*x = AddRuleSecurityPolicyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddRuleSecurityPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddRuleSecurityPolicyRequest) ProtoMessage() {}

func (x *AddRuleSecurityPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddRuleSecurityPolicyRequest.ProtoReflect.Descriptor instead.
func (*AddRuleSecurityPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{24}
}

func (x *AddRuleSecurityPolicyRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *AddRuleSecurityPolicyRequest) GetSecurityPolicy() string {
	if x != nil {
		return x.SecurityPolicy
	}
	return ""
}

func (x *AddRuleSecurityPolicyRequest) GetSecurityPolicyRuleResource() *SecurityPolicyRule {
	if x != nil {
		return x.SecurityPolicyRuleResource
	}
	return nil
}

func (x *AddRuleSecurityPolicyRequest) GetValidateOnly() bool {
	if x != nil && x.ValidateOnly != nil {
		return *x.ValidateOnly
	}
	return false
}

// A request message for BackendBuckets.AddSignedUrlKey. See the method description for details.
type AddSignedUrlKeyBackendBucketRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the BackendBucket resource to which the Signed URL Key should be added. The name should conform to RFC1035.
	BackendBucket string `protobuf:"bytes,91714037,opt,name=backend_bucket,json=backendBucket,proto3" json:"backend_bucket,omitempty"`
	// Project ID for this request.
	Project string `protobuf:"bytes,227560217,opt,name=project,proto3" json:"project,omitempty"`
	// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
	RequestId *string `protobuf:"bytes,37109963,opt,name=request_id,json=requestId,proto3,oneof" json:"request_id,omitempty"`
	// The body resource for this request
	SignedUrlKeyResource *SignedUrlKey `protobuf:"bytes,457625985,opt,name=signed_url_key_resource,json=signedUrlKeyResource,proto3" json:"signed_url_key_resource,omitempty"`
}

func (x *AddSignedUrlKeyBackendBucketRequest) Reset() {
	*x = AddSignedUrlKeyBackendBucketRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddSignedUrlKeyBackendBucketRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddSignedUrlKeyBackendBucketRequest) ProtoMessage() {}

func (x *AddSignedUrlKeyBackendBucketRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddSignedUrlKeyBackendBucketRequest.ProtoReflect.Descriptor instead.
func (*AddSignedUrlKeyBackendBucketRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{25}
}

func (x *AddSignedUrlKeyBackendBucketRequest) GetBackendBucket() string {
	if x != nil {
		return x.BackendBucket
	}
	return ""
}

func (x *AddSignedUrlKeyBackendBucketRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *AddSignedUrlKeyBackendBucketRequest) GetRequestId() string {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return ""
}

func (x *AddSignedUrlKeyBackendBucketRequest) GetSignedUrlKeyResource() *SignedUrlKey {
	if x != nil {
		return x.SignedUrlKeyResource
	}
	return nil
}

// A request message for BackendServices.AddSignedUrlKey. See the method description for details.
type AddSignedUrlKeyBackendServiceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the BackendService resource to which the Signed URL Key should be added. The name should conform to RFC1035.
	BackendService string `protobuf:"bytes,306946058,opt,name=backend_service,json=backendService,proto3" json:"backend_service,omitempty"`
	// Project ID for this request.
	Project string `protobuf:"bytes,227560217,opt,name=project,proto3" json:"project,omitempty"`
	// An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
	RequestId *string `protobuf:"bytes,37109963,opt,name=request_id,json=requestId,proto3,oneof" json:"request_id,omitempty"`
	// The body resource for this request
	SignedUrlKeyResource *SignedUrlKey `protobuf:"bytes,457625985,opt,name=signed_url_key_resource,json=signedUrlKeyResource,proto3" json:"signed_url_key_resource,omitempty"`
}

func (x *AddSignedUrlKeyBackendServiceRequest) Reset() {
	*x = AddSignedUrlKeyBackendServiceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddSignedUrlKeyBackendServiceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddSignedUrlKeyBackendServiceRequest) ProtoMessage() {}

func (x *AddSignedUrlKeyBackendServiceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddSignedUrlKeyBackendServiceRequest.ProtoReflect.Descriptor instead.
func (*AddSignedUrlKeyBackendServiceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{26}
}

func (x *AddSignedUrlKeyBackendServiceRequest) GetBackendService() string {
	if x != nil {
		return x.BackendService
	}
	return ""
}

func (x *AddSignedUrlKeyBackendServiceRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *AddSignedUrlKeyBackendServiceRequest) GetRequestId() string {
	if x != nil && x.RequestId != nil {
		return *x.RequestId
	}
	return ""
}

func (x *AddSignedUrlKeyBackendServiceRequest) GetSignedUrlKeyResource() *SignedUrlKey {
	if x != nil {
		return x.SignedUrlKeyResource
	}
	return nil
}

// Represents an IP Address resource. Google Compute Engine has two IP Address resources: * [Global (external and internal)](https://cloud.google.com/compute/docs/reference/rest/v1/globalAddresses) * [Regional (external and internal)](https://cloud.google.com/compute/docs/reference/rest/v1/addresses) For more information, see Reserving a static external IP address.
type Address struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The static IP address represented by this resource.
	Address *string `protobuf:"bytes,462920692,opt,name=address,proto3,oneof" json:"address,omitempty"`
	// The type of address to reserve, either INTERNAL or EXTERNAL. If unspecified, defaults to EXTERNAL.
	// Check the AddressType enum for the list of possible values.
	AddressType *string `protobuf:"bytes,264307877,opt,name=address_type,json=addressType,proto3,oneof" json:"address_type,omitempty"`
	// [Output Only] Creation timestamp in RFC3339 text format.
	CreationTimestamp *string `protobuf:"bytes,30525366,opt,name=creation_timestamp,json=creationTimestamp,proto3,oneof" json:"creation_timestamp,omitempty"`
	// An optional description of this resource. Provide this field when you create the resource.
	Description *string `protobuf:"bytes,422937596,opt,name=description,proto3,oneof" json:"description,omitempty"`
	// [Output Only] The unique identifier for the resource. This identifier is defined by the server.
	Id *uint64 `protobuf:"varint,3355,opt,name=id,proto3,oneof" json:"id,omitempty"`
	// The IP version that will be used by this address. Valid options are IPV4 or IPV6. This can only be specified for a global address.
	// Check the IpVersion enum for the list of possible values.
	IpVersion *string `protobuf:"bytes,294959552,opt,name=ip_version,json=ipVersion,proto3,oneof" json:"ip_version,omitempty"`
	// The endpoint type of this address, which should be VM or NETLB. This is used for deciding which type of endpoint this address can be used after the external IPv6 address reservation.
	// Check the Ipv6EndpointType enum for the list of possible values.
	Ipv6EndpointType *string `protobuf:"bytes,97501004,opt,name=ipv6_endpoint_type,json=ipv6EndpointType,proto3,oneof" json:"ipv6_endpoint_type,omitempty"`
	// [Output Only] Type of the resource. Always compute#address for addresses.
	Kind *string `protobuf:"bytes,3292052,opt,name=kind,proto3,oneof" json:"kind,omitempty"`
	// Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first character must be a lowercase letter, and all following characters (except for the last character) must be a dash, lowercase letter, or digit. The last character must be a lowercase letter or digit.
	Name *string `protobuf:"bytes,3373707,opt,name=name,proto3,oneof" json:"name,omitempty"`
	// The URL of the network in which to reserve the address. This field can only be used with INTERNAL type with the VPC_PEERING purpose.
	Network *string `protobuf:"bytes,232872494,opt,name=network,proto3,oneof" json:"network,omitempty"`
	// This signifies the networking tier used for configuring this address and can only take the following values: PREMIUM or STANDARD. Internal IP addresses are always Premium Tier; global external IP addresses are always Premium Tier; regional external IP addresses can be either Standard or Premium Tier. If this field is not specified, it is assumed to be PREMIUM.
	// Check the NetworkTier enum for the list of possible values.
	NetworkTier *string `protobuf:"bytes,517397843,opt,name=network_tier,json=networkTier,proto3,oneof" json:"network_tier,omitempty"`
	// The prefix length if the resource represents an IP range.
	PrefixLength *int32 `protobuf:"varint,453565747,opt,name=prefix_length,json=prefixLength,proto3,oneof" json:"prefix_length,omitempty"`
	// The purpose of this resource, which can be one of the following values: - GCE_ENDPOINT for addresses that are used by VM instances, alias IP ranges, load balancers, and similar resources. - DNS_RESOLVER for a DNS resolver address in a subnetwork for a Cloud DNS inbound forwarder IP addresses (regional internal IP address in a subnet of a VPC network) - VPC_PEERING for global internal IP addresses used for private services access allocated ranges. - NAT_AUTO for the regional external IP addresses used by Cloud NAT when allocating addresses using automatic NAT IP address allocation. - IPSEC_INTERCONNECT for addresses created from a private IP range that are reserved for a VLAN attachment in an *HA VPN over Cloud Interconnect* configuration. These addresses are regional resources. - `SHARED_LOADBALANCER_VIP` for an internal IP address that is assigned to multiple internal forwarding rules. - `PRIVATE_SERVICE_CONNECT` for a private network address that is used to configure Private Service Connect. Only global internal addresses can use this purpose.
	// Check the Purpose enum for the list of possible values.
	Purpose *string `protobuf:"bytes,316407070,opt,name=purpose,proto3,oneof" json:"purpose,omitempty"`
	// [Output Only] The URL of the region where a regional address resides. For regional addresses, you must specify the region as a path parameter in the HTTP request URL. *This field is not applicable to global addresses.*
	Region *string `protobuf:"bytes,138946292,opt,name=region,proto3,oneof" json:"region,omitempty"`
	// [Output Only] Server-defined URL for the resource.
	SelfLink *string `protobuf:"bytes,456214797,opt,name=self_link,json=selfLink,proto3,oneof" json:"self_link,omitempty"`
	// [Output Only] The status of the address, which can be one of RESERVING, RESERVED, or IN_USE. An address that is RESERVING is currently in the process of being reserved. A RESERVED address is currently reserved and available to use. An IN_USE address is currently being used by another resource and is not available.
	// Check the Status enum for the list of possible values.
	Status *string `protobuf:"bytes,181260274,opt,name=status,proto3,oneof" json:"status,omitempty"`
	// The URL of the subnetwork in which to reserve the address. If an IP address is specified, it must be within the subnetwork's IP range. This field can only be used with INTERNAL type with a GCE_ENDPOINT or DNS_RESOLVER purpose.
	Subnetwork *string `protobuf:"bytes,307827694,opt,name=subnetwork,proto3,oneof" json:"subnetwork,omitempty"`
	// [Output Only] The URLs of the resources that are using this address.
	Users []string `protobuf:"bytes,111578632,rep,name=users,proto3" json:"users,omitempty"`
}

func (x *Address) Reset() {
	*x = Address{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Address) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Address) ProtoMessage() {}

func (x *Address) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Address.ProtoReflect.Descriptor instead.
func (*Address) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{27}
}

func (x *Address) GetAddress() string {
	if x != nil && x.Address != nil {
		return *x.Address
	}
	return ""
}

func (x *Address) GetAddressType() string {
	if x != nil && x.AddressType != nil {
		return *x.AddressType
	}
	return ""
}

func (x *Address) GetCreationTimestamp() string {
	if x != nil && x.CreationTimestamp != nil {
		return *x.CreationTimestamp
	}
	return ""
}

func (x *Address) GetDescription() string {
	if x != nil && x.Description != nil {
		return *x.Description
	}
	return ""
}

func (x *Address) GetId() uint64 {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return 0
}

func (x *Address) GetIpVersion() string {
	if x != nil && x.IpVersion != nil {
		return *x.IpVersion
	}
	return ""
}

func (x *Address) GetIpv6EndpointType() string {
	if x != nil && x.Ipv6EndpointType != nil {
		return *x.Ipv6EndpointType
	}
	return ""
}

func (x *Address) GetKind() string {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return ""
}

func (x *Address) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (x *Address) GetNetwork() string {
	if x != nil && x.Network != nil {
		return *x.Network
	}
	return ""
}

func (x *Address) GetNetworkTier() string {
	if x != nil && x.NetworkTier != nil {
		return *x.NetworkTier
	}
	return ""
}

func (x *Address) GetPrefixLength() int32 {
	if x != nil && x.PrefixLength != nil {
		return *x.PrefixLength
	}
	return 0
}

func (x *Address) GetPurpose() string {
	if x != nil && x.Purpose != nil {
		return *x.Purpose
	}
	return ""
}

func (x *Address) GetRegion() string {
	if x != nil && x.Region != nil {
		return *x.Region
	}
	return ""
}

func (x *Address) GetSelfLink() string {
	if x != nil && x.SelfLink != nil {
		return *x.SelfLink
	}
	return ""
}

func (x *Address) GetStatus() string {
	if x != nil && x.Status != nil {
		return *x.Status
	}
	return ""
}

func (x *Address) GetSubnetwork() string {
	if x != nil && x.Subnetwork != nil {
		return *x.Subnetwork
	}
	return ""
}

func (x *Address) GetUsers() []string {
	if x != nil {
		return x.Users
	}
	return nil
}

type AddressAggregatedList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Output Only] Unique identifier for the resource; defined by the server.
	Id *string `protobuf:"bytes,3355,opt,name=id,proto3,oneof" json:"id,omitempty"`
	// A list of AddressesScopedList resources.
	Items map[string]*AddressesScopedList `protobuf:"bytes,100526016,rep,name=items,proto3" json:"items,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// [Output Only] Type of resource. Always compute#addressAggregatedList for aggregated lists of addresses.
	Kind *string `protobuf:"bytes,3292052,opt,name=kind,proto3,oneof" json:"kind,omitempty"`
	// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
	NextPageToken *string `protobuf:"bytes,79797525,opt,name=next_page_token,json=nextPageToken,proto3,oneof" json:"next_page_token,omitempty"`
	// [Output Only] Server-defined URL for this resource.
	SelfLink *string `protobuf:"bytes,456214797,opt,name=self_link,json=selfLink,proto3,oneof" json:"self_link,omitempty"`
	// [Output Only] Unreachable resources.
	Unreachables []string `protobuf:"bytes,243372063,rep,name=unreachables,proto3" json:"unreachables,omitempty"`
	// [Output Only] Informational warning message.
	Warning *Warning `protobuf:"bytes,50704284,opt,name=warning,proto3,oneof" json:"warning,omitempty"`
}

func (x *AddressAggregatedList) Reset() {
	*x = AddressAggregatedList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddressAggregatedList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddressAggregatedList) ProtoMessage() {}

func (x *AddressAggregatedList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddressAggregatedList.ProtoReflect.Descriptor instead.
func (*AddressAggregatedList) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{28}
}

func (x *AddressAggregatedList) GetId() string {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return ""
}

func (x *AddressAggregatedList) GetItems() map[string]*AddressesScopedList {
	if x != nil {
		return x.Items
	}
	return nil
}

func (x *AddressAggregatedList) GetKind() string {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return ""
}

func (x *AddressAggregatedList) GetNextPageToken() string {
	if x != nil && x.NextPageToken != nil {
		return *x.NextPageToken
	}
	return ""
}

func (x *AddressAggregatedList) GetSelfLink() string {
	if x != nil && x.SelfLink != nil {
		return *x.SelfLink
	}
	return ""
}

func (x *AddressAggregatedList) GetUnreachables() []string {
	if x != nil {
		return x.Unreachables
	}
	return nil
}

func (x *AddressAggregatedList) GetWarning() *Warning {
	if x != nil {
		return x.Warning
	}
	return nil
}

// Contains a list of addresses.
type AddressList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Output Only] Unique identifier for the resource; defined by the server.
	Id *string `protobuf:"bytes,3355,opt,name=id,proto3,oneof" json:"id,omitempty"`
	// A list of Address resources.
	Items []*Address `protobuf:"bytes,100526016,rep,name=items,proto3" json:"items,omitempty"`
	// [Output Only] Type of resource. Always compute#addressList for lists of addresses.
	Kind *string `protobuf:"bytes,3292052,opt,name=kind,proto3,oneof" json:"kind,omitempty"`
	// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
	NextPageToken *string `protobuf:"bytes,79797525,opt,name=next_page_token,json=nextPageToken,proto3,oneof" json:"next_page_token,omitempty"`
	// [Output Only] Server-defined URL for this resource.
	SelfLink *string `protobuf:"bytes,456214797,opt,name=self_link,json=selfLink,proto3,oneof" json:"self_link,omitempty"`
	// [Output Only] Informational warning message.
	Warning *Warning `protobuf:"bytes,50704284,opt,name=warning,proto3,oneof" json:"warning,omitempty"`
}

func (x *AddressList) Reset() {
	*x = AddressList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddressList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddressList) ProtoMessage() {}

func (x *AddressList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddressList.ProtoReflect.Descriptor instead.
func (*AddressList) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{29}
}

func (x *AddressList) GetId() string {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return ""
}

func (x *AddressList) GetItems() []*Address {
	if x != nil {
		return x.Items
	}
	return nil
}

func (x *AddressList) GetKind() string {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return ""
}

func (x *AddressList) GetNextPageToken() string {
	if x != nil && x.NextPageToken != nil {
		return *x.NextPageToken
	}
	return ""
}

func (x *AddressList) GetSelfLink() string {
	if x != nil && x.SelfLink != nil {
		return *x.SelfLink
	}
	return ""
}

func (x *AddressList) GetWarning() *Warning {
	if x != nil {
		return x.Warning
	}
	return nil
}

type AddressesScopedList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Output Only] A list of addresses contained in this scope.
	Addresses []*Address `protobuf:"bytes,337673122,rep,name=addresses,proto3" json:"addresses,omitempty"`
	// [Output Only] Informational warning which replaces the list of addresses when the list is empty.
	Warning *Warning `protobuf:"bytes,50704284,opt,name=warning,proto3,oneof" json:"warning,omitempty"`
}

func (x *AddressesScopedList) Reset() {
	*x = AddressesScopedList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddressesScopedList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddressesScopedList) ProtoMessage() {}

func (x *AddressesScopedList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddressesScopedList.ProtoReflect.Descriptor instead.
func (*AddressesScopedList) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{30}
}

func (x *AddressesScopedList) GetAddresses() []*Address {
	if x != nil {
		return x.Addresses
	}
	return nil
}

func (x *AddressesScopedList) GetWarning() *Warning {
	if x != nil {
		return x.Warning
	}
	return nil
}

// Specifies options for controlling advanced machine features. Options that would traditionally be configured in a BIOS belong here. Features that require operating system support may have corresponding entries in the GuestOsFeatures of an Image (e.g., whether or not the OS in the Image supports nested virtualization being enabled or disabled).
type AdvancedMachineFeatures struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether to enable nested virtualization or not (default is false).
	EnableNestedVirtualization *bool `protobuf:"varint,16639365,opt,name=enable_nested_virtualization,json=enableNestedVirtualization,proto3,oneof" json:"enable_nested_virtualization,omitempty"`
	// Whether to enable UEFI networking for instance creation.
	EnableUefiNetworking *bool `protobuf:"varint,334485668,opt,name=enable_uefi_networking,json=enableUefiNetworking,proto3,oneof" json:"enable_uefi_networking,omitempty"`
	// The number of threads per physical core. To disable simultaneous multithreading (SMT) set this to 1. If unset, the maximum number of threads supported per core by the underlying processor is assumed.
	ThreadsPerCore *int32 `protobuf:"varint,352611671,opt,name=threads_per_core,json=threadsPerCore,proto3,oneof" json:"threads_per_core,omitempty"`
	// The number of physical cores to expose to an instance. Multiply by the number of threads per core to compute the total number of virtual CPUs to expose to the instance. If unset, the number of cores is inferred from the instance's nominal CPU count and the underlying platform's SMT width.
	VisibleCoreCount *int32 `protobuf:"varint,193198684,opt,name=visible_core_count,json=visibleCoreCount,proto3,oneof" json:"visible_core_count,omitempty"`
}

func (x *AdvancedMachineFeatures) Reset() {
	*x = AdvancedMachineFeatures{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AdvancedMachineFeatures) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AdvancedMachineFeatures) ProtoMessage() {}

func (x *AdvancedMachineFeatures) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AdvancedMachineFeatures.ProtoReflect.Descriptor instead.
func (*AdvancedMachineFeatures) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{31}
}

func (x *AdvancedMachineFeatures) GetEnableNestedVirtualization() bool {
	if x != nil && x.EnableNestedVirtualization != nil {
		return *x.EnableNestedVirtualization
	}
	return false
}

func (x *AdvancedMachineFeatures) GetEnableUefiNetworking() bool {
	if x != nil && x.EnableUefiNetworking != nil {
		return *x.EnableUefiNetworking
	}
	return false
}

func (x *AdvancedMachineFeatures) GetThreadsPerCore() int32 {
	if x != nil && x.ThreadsPerCore != nil {
		return *x.ThreadsPerCore
	}
	return 0
}

func (x *AdvancedMachineFeatures) GetVisibleCoreCount() int32 {
	if x != nil && x.VisibleCoreCount != nil {
		return *x.VisibleCoreCount
	}
	return 0
}

// A request message for AcceleratorTypes.AggregatedList. See the method description for details.
type AggregatedListAcceleratorTypesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:` operator can be used with string fields to match substrings. For non-string fields it is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`.
	Filter *string `protobuf:"bytes,336120696,opt,name=filter,proto3,oneof" json:"filter,omitempty"`
	// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
	IncludeAllScopes *bool `protobuf:"varint,391327988,opt,name=include_all_scopes,json=includeAllScopes,proto3,oneof" json:"include_all_scopes,omitempty"`
	// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
	MaxResults *uint32 `protobuf:"varint,54715419,opt,name=max_results,json=maxResults,proto3,oneof" json:"max_results,omitempty"`
	// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
	OrderBy *string `protobuf:"bytes,160562920,opt,name=order_by,json=orderBy,proto3,oneof" json:"order_by,omitempty"`
	// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
	PageToken *string `protobuf:"bytes,19994697,opt,name=page_token,json=pageToken,proto3,oneof" json:"page_token,omitempty"`
	// Project ID for this request.
	Project string `protobuf:"bytes,227560217,opt,name=project,proto3" json:"project,omitempty"`
	// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
	ReturnPartialSuccess *bool `protobuf:"varint,517198390,opt,name=return_partial_success,json=returnPartialSuccess,proto3,oneof" json:"return_partial_success,omitempty"`
}

func (x *AggregatedListAcceleratorTypesRequest) Reset() {
	*x = AggregatedListAcceleratorTypesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AggregatedListAcceleratorTypesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AggregatedListAcceleratorTypesRequest) ProtoMessage() {}

func (x *AggregatedListAcceleratorTypesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AggregatedListAcceleratorTypesRequest.ProtoReflect.Descriptor instead.
func (*AggregatedListAcceleratorTypesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{32}
}

func (x *AggregatedListAcceleratorTypesRequest) GetFilter() string {
	if x != nil && x.Filter != nil {
		return *x.Filter
	}
	return ""
}

func (x *AggregatedListAcceleratorTypesRequest) GetIncludeAllScopes() bool {
	if x != nil && x.IncludeAllScopes != nil {
		return *x.IncludeAllScopes
	}
	return false
}

func (x *AggregatedListAcceleratorTypesRequest) GetMaxResults() uint32 {
	if x != nil && x.MaxResults != nil {
		return *x.MaxResults
	}
	return 0
}

func (x *AggregatedListAcceleratorTypesRequest) GetOrderBy() string {
	if x != nil && x.OrderBy != nil {
		return *x.OrderBy
	}
	return ""
}

func (x *AggregatedListAcceleratorTypesRequest) GetPageToken() string {
	if x != nil && x.PageToken != nil {
		return *x.PageToken
	}
	return ""
}

func (x *AggregatedListAcceleratorTypesRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *AggregatedListAcceleratorTypesRequest) GetReturnPartialSuccess() bool {
	if x != nil && x.ReturnPartialSuccess != nil {
		return *x.ReturnPartialSuccess
	}
	return false
}

// A request message for Addresses.AggregatedList. See the method description for details.
type AggregatedListAddressesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:` operator can be used with string fields to match substrings. For non-string fields it is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`.
	Filter *string `protobuf:"bytes,336120696,opt,name=filter,proto3,oneof" json:"filter,omitempty"`
	// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
	IncludeAllScopes *bool `protobuf:"varint,391327988,opt,name=include_all_scopes,json=includeAllScopes,proto3,oneof" json:"include_all_scopes,omitempty"`
	// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
	MaxResults *uint32 `protobuf:"varint,54715419,opt,name=max_results,json=maxResults,proto3,oneof" json:"max_results,omitempty"`
	// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
	OrderBy *string `protobuf:"bytes,160562920,opt,name=order_by,json=orderBy,proto3,oneof" json:"order_by,omitempty"`
	// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
	PageToken *string `protobuf:"bytes,19994697,opt,name=page_token,json=pageToken,proto3,oneof" json:"page_token,omitempty"`
	// Project ID for this request.
	Project string `protobuf:"bytes,227560217,opt,name=project,proto3" json:"project,omitempty"`
	// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
	ReturnPartialSuccess *bool `protobuf:"varint,517198390,opt,name=return_partial_success,json=returnPartialSuccess,proto3,oneof" json:"return_partial_success,omitempty"`
}

func (x *AggregatedListAddressesRequest) Reset() {
	*x = AggregatedListAddressesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AggregatedListAddressesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AggregatedListAddressesRequest) ProtoMessage() {}

func (x *AggregatedListAddressesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AggregatedListAddressesRequest.ProtoReflect.Descriptor instead.
func (*AggregatedListAddressesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{33}
}

func (x *AggregatedListAddressesRequest) GetFilter() string {
	if x != nil && x.Filter != nil {
		return *x.Filter
	}
	return ""
}

func (x *AggregatedListAddressesRequest) GetIncludeAllScopes() bool {
	if x != nil && x.IncludeAllScopes != nil {
		return *x.IncludeAllScopes
	}
	return false
}

func (x *AggregatedListAddressesRequest) GetMaxResults() uint32 {
	if x != nil && x.MaxResults != nil {
		return *x.MaxResults
	}
	return 0
}

func (x *AggregatedListAddressesRequest) GetOrderBy() string {
	if x != nil && x.OrderBy != nil {
		return *x.OrderBy
	}
	return ""
}

func (x *AggregatedListAddressesRequest) GetPageToken() string {
	if x != nil && x.PageToken != nil {
		return *x.PageToken
	}
	return ""
}

func (x *AggregatedListAddressesRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *AggregatedListAddressesRequest) GetReturnPartialSuccess() bool {
	if x != nil && x.ReturnPartialSuccess != nil {
		return *x.ReturnPartialSuccess
	}
	return false
}

// A request message for Autoscalers.AggregatedList. See the method description for details.
type AggregatedListAutoscalersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:` operator can be used with string fields to match substrings. For non-string fields it is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`.
	Filter *string `protobuf:"bytes,336120696,opt,name=filter,proto3,oneof" json:"filter,omitempty"`
	// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
	IncludeAllScopes *bool `protobuf:"varint,391327988,opt,name=include_all_scopes,json=includeAllScopes,proto3,oneof" json:"include_all_scopes,omitempty"`
	// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
	MaxResults *uint32 `protobuf:"varint,54715419,opt,name=max_results,json=maxResults,proto3,oneof" json:"max_results,omitempty"`
	// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
	OrderBy *string `protobuf:"bytes,160562920,opt,name=order_by,json=orderBy,proto3,oneof" json:"order_by,omitempty"`
	// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
	PageToken *string `protobuf:"bytes,19994697,opt,name=page_token,json=pageToken,proto3,oneof" json:"page_token,omitempty"`
	// Project ID for this request.
	Project string `protobuf:"bytes,227560217,opt,name=project,proto3" json:"project,omitempty"`
	// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
	ReturnPartialSuccess *bool `protobuf:"varint,517198390,opt,name=return_partial_success,json=returnPartialSuccess,proto3,oneof" json:"return_partial_success,omitempty"`
}

func (x *AggregatedListAutoscalersRequest) Reset() {
	*x = AggregatedListAutoscalersRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AggregatedListAutoscalersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AggregatedListAutoscalersRequest) ProtoMessage() {}

func (x *AggregatedListAutoscalersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AggregatedListAutoscalersRequest.ProtoReflect.Descriptor instead.
func (*AggregatedListAutoscalersRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{34}
}

func (x *AggregatedListAutoscalersRequest) GetFilter() string {
	if x != nil && x.Filter != nil {
		return *x.Filter
	}
	return ""
}

func (x *AggregatedListAutoscalersRequest) GetIncludeAllScopes() bool {
	if x != nil && x.IncludeAllScopes != nil {
		return *x.IncludeAllScopes
	}
	return false
}

func (x *AggregatedListAutoscalersRequest) GetMaxResults() uint32 {
	if x != nil && x.MaxResults != nil {
		return *x.MaxResults
	}
	return 0
}

func (x *AggregatedListAutoscalersRequest) GetOrderBy() string {
	if x != nil && x.OrderBy != nil {
		return *x.OrderBy
	}
	return ""
}

func (x *AggregatedListAutoscalersRequest) GetPageToken() string {
	if x != nil && x.PageToken != nil {
		return *x.PageToken
	}
	return ""
}

func (x *AggregatedListAutoscalersRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *AggregatedListAutoscalersRequest) GetReturnPartialSuccess() bool {
	if x != nil && x.ReturnPartialSuccess != nil {
		return *x.ReturnPartialSuccess
	}
	return false
}

// A request message for BackendServices.AggregatedList. See the method description for details.
type AggregatedListBackendServicesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:` operator can be used with string fields to match substrings. For non-string fields it is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`.
	Filter *string `protobuf:"bytes,336120696,opt,name=filter,proto3,oneof" json:"filter,omitempty"`
	// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
	IncludeAllScopes *bool `protobuf:"varint,391327988,opt,name=include_all_scopes,json=includeAllScopes,proto3,oneof" json:"include_all_scopes,omitempty"`
	// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
	MaxResults *uint32 `protobuf:"varint,54715419,opt,name=max_results,json=maxResults,proto3,oneof" json:"max_results,omitempty"`
	// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
	OrderBy *string `protobuf:"bytes,160562920,opt,name=order_by,json=orderBy,proto3,oneof" json:"order_by,omitempty"`
	// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
	PageToken *string `protobuf:"bytes,19994697,opt,name=page_token,json=pageToken,proto3,oneof" json:"page_token,omitempty"`
	// Name of the project scoping this request.
	Project string `protobuf:"bytes,227560217,opt,name=project,proto3" json:"project,omitempty"`
	// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
	ReturnPartialSuccess *bool `protobuf:"varint,517198390,opt,name=return_partial_success,json=returnPartialSuccess,proto3,oneof" json:"return_partial_success,omitempty"`
}

func (x *AggregatedListBackendServicesRequest) Reset() {
	*x = AggregatedListBackendServicesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AggregatedListBackendServicesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AggregatedListBackendServicesRequest) ProtoMessage() {}

func (x *AggregatedListBackendServicesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AggregatedListBackendServicesRequest.ProtoReflect.Descriptor instead.
func (*AggregatedListBackendServicesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{35}
}

func (x *AggregatedListBackendServicesRequest) GetFilter() string {
	if x != nil && x.Filter != nil {
		return *x.Filter
	}
	return ""
}

func (x *AggregatedListBackendServicesRequest) GetIncludeAllScopes() bool {
	if x != nil && x.IncludeAllScopes != nil {
		return *x.IncludeAllScopes
	}
	return false
}

func (x *AggregatedListBackendServicesRequest) GetMaxResults() uint32 {
	if x != nil && x.MaxResults != nil {
		return *x.MaxResults
	}
	return 0
}

func (x *AggregatedListBackendServicesRequest) GetOrderBy() string {
	if x != nil && x.OrderBy != nil {
		return *x.OrderBy
	}
	return ""
}

func (x *AggregatedListBackendServicesRequest) GetPageToken() string {
	if x != nil && x.PageToken != nil {
		return *x.PageToken
	}
	return ""
}

func (x *AggregatedListBackendServicesRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *AggregatedListBackendServicesRequest) GetReturnPartialSuccess() bool {
	if x != nil && x.ReturnPartialSuccess != nil {
		return *x.ReturnPartialSuccess
	}
	return false
}

// A request message for DiskTypes.AggregatedList. See the method description for details.
type AggregatedListDiskTypesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:` operator can be used with string fields to match substrings. For non-string fields it is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`.
	Filter *string `protobuf:"bytes,336120696,opt,name=filter,proto3,oneof" json:"filter,omitempty"`
	// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
	IncludeAllScopes *bool `protobuf:"varint,391327988,opt,name=include_all_scopes,json=includeAllScopes,proto3,oneof" json:"include_all_scopes,omitempty"`
	// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
	MaxResults *uint32 `protobuf:"varint,54715419,opt,name=max_results,json=maxResults,proto3,oneof" json:"max_results,omitempty"`
	// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
	OrderBy *string `protobuf:"bytes,160562920,opt,name=order_by,json=orderBy,proto3,oneof" json:"order_by,omitempty"`
	// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
	PageToken *string `protobuf:"bytes,19994697,opt,name=page_token,json=pageToken,proto3,oneof" json:"page_token,omitempty"`
	// Project ID for this request.
	Project string `protobuf:"bytes,227560217,opt,name=project,proto3" json:"project,omitempty"`
	// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
	ReturnPartialSuccess *bool `protobuf:"varint,517198390,opt,name=return_partial_success,json=returnPartialSuccess,proto3,oneof" json:"return_partial_success,omitempty"`
}

func (x *AggregatedListDiskTypesRequest) Reset() {
	*x = AggregatedListDiskTypesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AggregatedListDiskTypesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AggregatedListDiskTypesRequest) ProtoMessage() {}

func (x *AggregatedListDiskTypesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AggregatedListDiskTypesRequest.ProtoReflect.Descriptor instead.
func (*AggregatedListDiskTypesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{36}
}

func (x *AggregatedListDiskTypesRequest) GetFilter() string {
	if x != nil && x.Filter != nil {
		return *x.Filter
	}
	return ""
}

func (x *AggregatedListDiskTypesRequest) GetIncludeAllScopes() bool {
	if x != nil && x.IncludeAllScopes != nil {
		return *x.IncludeAllScopes
	}
	return false
}

func (x *AggregatedListDiskTypesRequest) GetMaxResults() uint32 {
	if x != nil && x.MaxResults != nil {
		return *x.MaxResults
	}
	return 0
}

func (x *AggregatedListDiskTypesRequest) GetOrderBy() string {
	if x != nil && x.OrderBy != nil {
		return *x.OrderBy
	}
	return ""
}

func (x *AggregatedListDiskTypesRequest) GetPageToken() string {
	if x != nil && x.PageToken != nil {
		return *x.PageToken
	}
	return ""
}

func (x *AggregatedListDiskTypesRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *AggregatedListDiskTypesRequest) GetReturnPartialSuccess() bool {
	if x != nil && x.ReturnPartialSuccess != nil {
		return *x.ReturnPartialSuccess
	}
	return false
}

// A request message for Disks.AggregatedList. See the method description for details.
type AggregatedListDisksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:` operator can be used with string fields to match substrings. For non-string fields it is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`.
	Filter *string `protobuf:"bytes,336120696,opt,name=filter,proto3,oneof" json:"filter,omitempty"`
	// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
	IncludeAllScopes *bool `protobuf:"varint,391327988,opt,name=include_all_scopes,json=includeAllScopes,proto3,oneof" json:"include_all_scopes,omitempty"`
	// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
	MaxResults *uint32 `protobuf:"varint,54715419,opt,name=max_results,json=maxResults,proto3,oneof" json:"max_results,omitempty"`
	// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
	OrderBy *string `protobuf:"bytes,160562920,opt,name=order_by,json=orderBy,proto3,oneof" json:"order_by,omitempty"`
	// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
	PageToken *string `protobuf:"bytes,19994697,opt,name=page_token,json=pageToken,proto3,oneof" json:"page_token,omitempty"`
	// Project ID for this request.
	Project string `protobuf:"bytes,227560217,opt,name=project,proto3" json:"project,omitempty"`
	// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
	ReturnPartialSuccess *bool `protobuf:"varint,517198390,opt,name=return_partial_success,json=returnPartialSuccess,proto3,oneof" json:"return_partial_success,omitempty"`
}

func (x *AggregatedListDisksRequest) Reset() {
	*x = AggregatedListDisksRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AggregatedListDisksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AggregatedListDisksRequest) ProtoMessage() {}

func (x *AggregatedListDisksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AggregatedListDisksRequest.ProtoReflect.Descriptor instead.
func (*AggregatedListDisksRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{37}
}

func (x *AggregatedListDisksRequest) GetFilter() string {
	if x != nil && x.Filter != nil {
		return *x.Filter
	}
	return ""
}

func (x *AggregatedListDisksRequest) GetIncludeAllScopes() bool {
	if x != nil && x.IncludeAllScopes != nil {
		return *x.IncludeAllScopes
	}
	return false
}

func (x *AggregatedListDisksRequest) GetMaxResults() uint32 {
	if x != nil && x.MaxResults != nil {
		return *x.MaxResults
	}
	return 0
}

func (x *AggregatedListDisksRequest) GetOrderBy() string {
	if x != nil && x.OrderBy != nil {
		return *x.OrderBy
	}
	return ""
}

func (x *AggregatedListDisksRequest) GetPageToken() string {
	if x != nil && x.PageToken != nil {
		return *x.PageToken
	}
	return ""
}

func (x *AggregatedListDisksRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *AggregatedListDisksRequest) GetReturnPartialSuccess() bool {
	if x != nil && x.ReturnPartialSuccess != nil {
		return *x.ReturnPartialSuccess
	}
	return false
}

// A request message for ForwardingRules.AggregatedList. See the method description for details.
type AggregatedListForwardingRulesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:` operator can be used with string fields to match substrings. For non-string fields it is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`.
	Filter *string `protobuf:"bytes,336120696,opt,name=filter,proto3,oneof" json:"filter,omitempty"`
	// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
	IncludeAllScopes *bool `protobuf:"varint,391327988,opt,name=include_all_scopes,json=includeAllScopes,proto3,oneof" json:"include_all_scopes,omitempty"`
	// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
	MaxResults *uint32 `protobuf:"varint,54715419,opt,name=max_results,json=maxResults,proto3,oneof" json:"max_results,omitempty"`
	// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
	OrderBy *string `protobuf:"bytes,160562920,opt,name=order_by,json=orderBy,proto3,oneof" json:"order_by,omitempty"`
	// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
	PageToken *string `protobuf:"bytes,19994697,opt,name=page_token,json=pageToken,proto3,oneof" json:"page_token,omitempty"`
	// Project ID for this request.
	Project string `protobuf:"bytes,227560217,opt,name=project,proto3" json:"project,omitempty"`
	// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
	ReturnPartialSuccess *bool `protobuf:"varint,517198390,opt,name=return_partial_success,json=returnPartialSuccess,proto3,oneof" json:"return_partial_success,omitempty"`
}

func (x *AggregatedListForwardingRulesRequest) Reset() {
	*x = AggregatedListForwardingRulesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AggregatedListForwardingRulesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AggregatedListForwardingRulesRequest) ProtoMessage() {}

func (x *AggregatedListForwardingRulesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AggregatedListForwardingRulesRequest.ProtoReflect.Descriptor instead.
func (*AggregatedListForwardingRulesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{38}
}

func (x *AggregatedListForwardingRulesRequest) GetFilter() string {
	if x != nil && x.Filter != nil {
		return *x.Filter
	}
	return ""
}

func (x *AggregatedListForwardingRulesRequest) GetIncludeAllScopes() bool {
	if x != nil && x.IncludeAllScopes != nil {
		return *x.IncludeAllScopes
	}
	return false
}

func (x *AggregatedListForwardingRulesRequest) GetMaxResults() uint32 {
	if x != nil && x.MaxResults != nil {
		return *x.MaxResults
	}
	return 0
}

func (x *AggregatedListForwardingRulesRequest) GetOrderBy() string {
	if x != nil && x.OrderBy != nil {
		return *x.OrderBy
	}
	return ""
}

func (x *AggregatedListForwardingRulesRequest) GetPageToken() string {
	if x != nil && x.PageToken != nil {
		return *x.PageToken
	}
	return ""
}

func (x *AggregatedListForwardingRulesRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *AggregatedListForwardingRulesRequest) GetReturnPartialSuccess() bool {
	if x != nil && x.ReturnPartialSuccess != nil {
		return *x.ReturnPartialSuccess
	}
	return false
}

// A request message for GlobalOperations.AggregatedList. See the method description for details.
type AggregatedListGlobalOperationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:` operator can be used with string fields to match substrings. For non-string fields it is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`.
	Filter *string `protobuf:"bytes,336120696,opt,name=filter,proto3,oneof" json:"filter,omitempty"`
	// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
	IncludeAllScopes *bool `protobuf:"varint,391327988,opt,name=include_all_scopes,json=includeAllScopes,proto3,oneof" json:"include_all_scopes,omitempty"`
	// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
	MaxResults *uint32 `protobuf:"varint,54715419,opt,name=max_results,json=maxResults,proto3,oneof" json:"max_results,omitempty"`
	// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
	OrderBy *string `protobuf:"bytes,160562920,opt,name=order_by,json=orderBy,proto3,oneof" json:"order_by,omitempty"`
	// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
	PageToken *string `protobuf:"bytes,19994697,opt,name=page_token,json=pageToken,proto3,oneof" json:"page_token,omitempty"`
	// Project ID for this request.
	Project string `protobuf:"bytes,227560217,opt,name=project,proto3" json:"project,omitempty"`
	// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
	ReturnPartialSuccess *bool `protobuf:"varint,517198390,opt,name=return_partial_success,json=returnPartialSuccess,proto3,oneof" json:"return_partial_success,omitempty"`
}

func (x *AggregatedListGlobalOperationsRequest) Reset() {
	*x = AggregatedListGlobalOperationsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AggregatedListGlobalOperationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AggregatedListGlobalOperationsRequest) ProtoMessage() {}

func (x *AggregatedListGlobalOperationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AggregatedListGlobalOperationsRequest.ProtoReflect.Descriptor instead.
func (*AggregatedListGlobalOperationsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{39}
}

func (x *AggregatedListGlobalOperationsRequest) GetFilter() string {
	if x != nil && x.Filter != nil {
		return *x.Filter
	}
	return ""
}

func (x *AggregatedListGlobalOperationsRequest) GetIncludeAllScopes() bool {
	if x != nil && x.IncludeAllScopes != nil {
		return *x.IncludeAllScopes
	}
	return false
}

func (x *AggregatedListGlobalOperationsRequest) GetMaxResults() uint32 {
	if x != nil && x.MaxResults != nil {
		return *x.MaxResults
	}
	return 0
}

func (x *AggregatedListGlobalOperationsRequest) GetOrderBy() string {
	if x != nil && x.OrderBy != nil {
		return *x.OrderBy
	}
	return ""
}

func (x *AggregatedListGlobalOperationsRequest) GetPageToken() string {
	if x != nil && x.PageToken != nil {
		return *x.PageToken
	}
	return ""
}

func (x *AggregatedListGlobalOperationsRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *AggregatedListGlobalOperationsRequest) GetReturnPartialSuccess() bool {
	if x != nil && x.ReturnPartialSuccess != nil {
		return *x.ReturnPartialSuccess
	}
	return false
}

// A request message for HealthChecks.AggregatedList. See the method description for details.
type AggregatedListHealthChecksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:` operator can be used with string fields to match substrings. For non-string fields it is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`.
	Filter *string `protobuf:"bytes,336120696,opt,name=filter,proto3,oneof" json:"filter,omitempty"`
	// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
	IncludeAllScopes *bool `protobuf:"varint,391327988,opt,name=include_all_scopes,json=includeAllScopes,proto3,oneof" json:"include_all_scopes,omitempty"`
	// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
	MaxResults *uint32 `protobuf:"varint,54715419,opt,name=max_results,json=maxResults,proto3,oneof" json:"max_results,omitempty"`
	// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
	OrderBy *string `protobuf:"bytes,160562920,opt,name=order_by,json=orderBy,proto3,oneof" json:"order_by,omitempty"`
	// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
	PageToken *string `protobuf:"bytes,19994697,opt,name=page_token,json=pageToken,proto3,oneof" json:"page_token,omitempty"`
	// Name of the project scoping this request.
	Project string `protobuf:"bytes,227560217,opt,name=project,proto3" json:"project,omitempty"`
	// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
	ReturnPartialSuccess *bool `protobuf:"varint,517198390,opt,name=return_partial_success,json=returnPartialSuccess,proto3,oneof" json:"return_partial_success,omitempty"`
}

func (x *AggregatedListHealthChecksRequest) Reset() {
	*x = AggregatedListHealthChecksRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AggregatedListHealthChecksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AggregatedListHealthChecksRequest) ProtoMessage() {}

func (x *AggregatedListHealthChecksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AggregatedListHealthChecksRequest.ProtoReflect.Descriptor instead.
func (*AggregatedListHealthChecksRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{40}
}

func (x *AggregatedListHealthChecksRequest) GetFilter() string {
	if x != nil && x.Filter != nil {
		return *x.Filter
	}
	return ""
}

func (x *AggregatedListHealthChecksRequest) GetIncludeAllScopes() bool {
	if x != nil && x.IncludeAllScopes != nil {
		return *x.IncludeAllScopes
	}
	return false
}

func (x *AggregatedListHealthChecksRequest) GetMaxResults() uint32 {
	if x != nil && x.MaxResults != nil {
		return *x.MaxResults
	}
	return 0
}

func (x *AggregatedListHealthChecksRequest) GetOrderBy() string {
	if x != nil && x.OrderBy != nil {
		return *x.OrderBy
	}
	return ""
}

func (x *AggregatedListHealthChecksRequest) GetPageToken() string {
	if x != nil && x.PageToken != nil {
		return *x.PageToken
	}
	return ""
}

func (x *AggregatedListHealthChecksRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *AggregatedListHealthChecksRequest) GetReturnPartialSuccess() bool {
	if x != nil && x.ReturnPartialSuccess != nil {
		return *x.ReturnPartialSuccess
	}
	return false
}

// A request message for InstanceGroupManagers.AggregatedList. See the method description for details.
type AggregatedListInstanceGroupManagersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:` operator can be used with string fields to match substrings. For non-string fields it is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`.
	Filter *string `protobuf:"bytes,336120696,opt,name=filter,proto3,oneof" json:"filter,omitempty"`
	// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
	IncludeAllScopes *bool `protobuf:"varint,391327988,opt,name=include_all_scopes,json=includeAllScopes,proto3,oneof" json:"include_all_scopes,omitempty"`
	// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
	MaxResults *uint32 `protobuf:"varint,54715419,opt,name=max_results,json=maxResults,proto3,oneof" json:"max_results,omitempty"`
	// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
	OrderBy *string `protobuf:"bytes,160562920,opt,name=order_by,json=orderBy,proto3,oneof" json:"order_by,omitempty"`
	// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
	PageToken *string `protobuf:"bytes,19994697,opt,name=page_token,json=pageToken,proto3,oneof" json:"page_token,omitempty"`
	// Project ID for this request.
	Project string `protobuf:"bytes,227560217,opt,name=project,proto3" json:"project,omitempty"`
	// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
	ReturnPartialSuccess *bool `protobuf:"varint,517198390,opt,name=return_partial_success,json=returnPartialSuccess,proto3,oneof" json:"return_partial_success,omitempty"`
}

func (x *AggregatedListInstanceGroupManagersRequest) Reset() {
	*x = AggregatedListInstanceGroupManagersRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AggregatedListInstanceGroupManagersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AggregatedListInstanceGroupManagersRequest) ProtoMessage() {}

func (x *AggregatedListInstanceGroupManagersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AggregatedListInstanceGroupManagersRequest.ProtoReflect.Descriptor instead.
func (*AggregatedListInstanceGroupManagersRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{41}
}

func (x *AggregatedListInstanceGroupManagersRequest) GetFilter() string {
	if x != nil && x.Filter != nil {
		return *x.Filter
	}
	return ""
}

func (x *AggregatedListInstanceGroupManagersRequest) GetIncludeAllScopes() bool {
	if x != nil && x.IncludeAllScopes != nil {
		return *x.IncludeAllScopes
	}
	return false
}

func (x *AggregatedListInstanceGroupManagersRequest) GetMaxResults() uint32 {
	if x != nil && x.MaxResults != nil {
		return *x.MaxResults
	}
	return 0
}

func (x *AggregatedListInstanceGroupManagersRequest) GetOrderBy() string {
	if x != nil && x.OrderBy != nil {
		return *x.OrderBy
	}
	return ""
}

func (x *AggregatedListInstanceGroupManagersRequest) GetPageToken() string {
	if x != nil && x.PageToken != nil {
		return *x.PageToken
	}
	return ""
}

func (x *AggregatedListInstanceGroupManagersRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *AggregatedListInstanceGroupManagersRequest) GetReturnPartialSuccess() bool {
	if x != nil && x.ReturnPartialSuccess != nil {
		return *x.ReturnPartialSuccess
	}
	return false
}

// A request message for InstanceGroups.AggregatedList. See the method description for details.
type AggregatedListInstanceGroupsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:` operator can be used with string fields to match substrings. For non-string fields it is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`.
	Filter *string `protobuf:"bytes,336120696,opt,name=filter,proto3,oneof" json:"filter,omitempty"`
	// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
	IncludeAllScopes *bool `protobuf:"varint,391327988,opt,name=include_all_scopes,json=includeAllScopes,proto3,oneof" json:"include_all_scopes,omitempty"`
	// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
	MaxResults *uint32 `protobuf:"varint,54715419,opt,name=max_results,json=maxResults,proto3,oneof" json:"max_results,omitempty"`
	// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
	OrderBy *string `protobuf:"bytes,160562920,opt,name=order_by,json=orderBy,proto3,oneof" json:"order_by,omitempty"`
	// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
	PageToken *string `protobuf:"bytes,19994697,opt,name=page_token,json=pageToken,proto3,oneof" json:"page_token,omitempty"`
	// Project ID for this request.
	Project string `protobuf:"bytes,227560217,opt,name=project,proto3" json:"project,omitempty"`
	// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
	ReturnPartialSuccess *bool `protobuf:"varint,517198390,opt,name=return_partial_success,json=returnPartialSuccess,proto3,oneof" json:"return_partial_success,omitempty"`
}

func (x *AggregatedListInstanceGroupsRequest) Reset() {
	*x = AggregatedListInstanceGroupsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AggregatedListInstanceGroupsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AggregatedListInstanceGroupsRequest) ProtoMessage() {}

func (x *AggregatedListInstanceGroupsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AggregatedListInstanceGroupsRequest.ProtoReflect.Descriptor instead.
func (*AggregatedListInstanceGroupsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{42}
}

func (x *AggregatedListInstanceGroupsRequest) GetFilter() string {
	if x != nil && x.Filter != nil {
		return *x.Filter
	}
	return ""
}

func (x *AggregatedListInstanceGroupsRequest) GetIncludeAllScopes() bool {
	if x != nil && x.IncludeAllScopes != nil {
		return *x.IncludeAllScopes
	}
	return false
}

func (x *AggregatedListInstanceGroupsRequest) GetMaxResults() uint32 {
	if x != nil && x.MaxResults != nil {
		return *x.MaxResults
	}
	return 0
}

func (x *AggregatedListInstanceGroupsRequest) GetOrderBy() string {
	if x != nil && x.OrderBy != nil {
		return *x.OrderBy
	}
	return ""
}

func (x *AggregatedListInstanceGroupsRequest) GetPageToken() string {
	if x != nil && x.PageToken != nil {
		return *x.PageToken
	}
	return ""
}

func (x *AggregatedListInstanceGroupsRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *AggregatedListInstanceGroupsRequest) GetReturnPartialSuccess() bool {
	if x != nil && x.ReturnPartialSuccess != nil {
		return *x.ReturnPartialSuccess
	}
	return false
}

// A request message for InstanceTemplates.AggregatedList. See the method description for details.
type AggregatedListInstanceTemplatesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:` operator can be used with string fields to match substrings. For non-string fields it is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`.
	Filter *string `protobuf:"bytes,336120696,opt,name=filter,proto3,oneof" json:"filter,omitempty"`
	// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
	IncludeAllScopes *bool `protobuf:"varint,391327988,opt,name=include_all_scopes,json=includeAllScopes,proto3,oneof" json:"include_all_scopes,omitempty"`
	// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
	MaxResults *uint32 `protobuf:"varint,54715419,opt,name=max_results,json=maxResults,proto3,oneof" json:"max_results,omitempty"`
	// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
	OrderBy *string `protobuf:"bytes,160562920,opt,name=order_by,json=orderBy,proto3,oneof" json:"order_by,omitempty"`
	// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
	PageToken *string `protobuf:"bytes,19994697,opt,name=page_token,json=pageToken,proto3,oneof" json:"page_token,omitempty"`
	// Name of the project scoping this request.
	Project string `protobuf:"bytes,227560217,opt,name=project,proto3" json:"project,omitempty"`
	// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
	ReturnPartialSuccess *bool `protobuf:"varint,517198390,opt,name=return_partial_success,json=returnPartialSuccess,proto3,oneof" json:"return_partial_success,omitempty"`
}

func (x *AggregatedListInstanceTemplatesRequest) Reset() {
	*x = AggregatedListInstanceTemplatesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AggregatedListInstanceTemplatesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AggregatedListInstanceTemplatesRequest) ProtoMessage() {}

func (x *AggregatedListInstanceTemplatesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AggregatedListInstanceTemplatesRequest.ProtoReflect.Descriptor instead.
func (*AggregatedListInstanceTemplatesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{43}
}

func (x *AggregatedListInstanceTemplatesRequest) GetFilter() string {
	if x != nil && x.Filter != nil {
		return *x.Filter
	}
	return ""
}

func (x *AggregatedListInstanceTemplatesRequest) GetIncludeAllScopes() bool {
	if x != nil && x.IncludeAllScopes != nil {
		return *x.IncludeAllScopes
	}
	return false
}

func (x *AggregatedListInstanceTemplatesRequest) GetMaxResults() uint32 {
	if x != nil && x.MaxResults != nil {
		return *x.MaxResults
	}
	return 0
}

func (x *AggregatedListInstanceTemplatesRequest) GetOrderBy() string {
	if x != nil && x.OrderBy != nil {
		return *x.OrderBy
	}
	return ""
}

func (x *AggregatedListInstanceTemplatesRequest) GetPageToken() string {
	if x != nil && x.PageToken != nil {
		return *x.PageToken
	}
	return ""
}

func (x *AggregatedListInstanceTemplatesRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *AggregatedListInstanceTemplatesRequest) GetReturnPartialSuccess() bool {
	if x != nil && x.ReturnPartialSuccess != nil {
		return *x.ReturnPartialSuccess
	}
	return false
}

// A request message for Instances.AggregatedList. See the method description for details.
type AggregatedListInstancesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:` operator can be used with string fields to match substrings. For non-string fields it is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`.
	Filter *string `protobuf:"bytes,336120696,opt,name=filter,proto3,oneof" json:"filter,omitempty"`
	// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
	IncludeAllScopes *bool `protobuf:"varint,391327988,opt,name=include_all_scopes,json=includeAllScopes,proto3,oneof" json:"include_all_scopes,omitempty"`
	// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
	MaxResults *uint32 `protobuf:"varint,54715419,opt,name=max_results,json=maxResults,proto3,oneof" json:"max_results,omitempty"`
	// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
	OrderBy *string `protobuf:"bytes,160562920,opt,name=order_by,json=orderBy,proto3,oneof" json:"order_by,omitempty"`
	// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
	PageToken *string `protobuf:"bytes,19994697,opt,name=page_token,json=pageToken,proto3,oneof" json:"page_token,omitempty"`
	// Project ID for this request.
	Project string `protobuf:"bytes,227560217,opt,name=project,proto3" json:"project,omitempty"`
	// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
	ReturnPartialSuccess *bool `protobuf:"varint,517198390,opt,name=return_partial_success,json=returnPartialSuccess,proto3,oneof" json:"return_partial_success,omitempty"`
}

func (x *AggregatedListInstancesRequest) Reset() {
	*x = AggregatedListInstancesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AggregatedListInstancesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AggregatedListInstancesRequest) ProtoMessage() {}

func (x *AggregatedListInstancesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AggregatedListInstancesRequest.ProtoReflect.Descriptor instead.
func (*AggregatedListInstancesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{44}
}

func (x *AggregatedListInstancesRequest) GetFilter() string {
	if x != nil && x.Filter != nil {
		return *x.Filter
	}
	return ""
}

func (x *AggregatedListInstancesRequest) GetIncludeAllScopes() bool {
	if x != nil && x.IncludeAllScopes != nil {
		return *x.IncludeAllScopes
	}
	return false
}

func (x *AggregatedListInstancesRequest) GetMaxResults() uint32 {
	if x != nil && x.MaxResults != nil {
		return *x.MaxResults
	}
	return 0
}

func (x *AggregatedListInstancesRequest) GetOrderBy() string {
	if x != nil && x.OrderBy != nil {
		return *x.OrderBy
	}
	return ""
}

func (x *AggregatedListInstancesRequest) GetPageToken() string {
	if x != nil && x.PageToken != nil {
		return *x.PageToken
	}
	return ""
}

func (x *AggregatedListInstancesRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *AggregatedListInstancesRequest) GetReturnPartialSuccess() bool {
	if x != nil && x.ReturnPartialSuccess != nil {
		return *x.ReturnPartialSuccess
	}
	return false
}

// A request message for InterconnectAttachments.AggregatedList. See the method description for details.
type AggregatedListInterconnectAttachmentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:` operator can be used with string fields to match substrings. For non-string fields it is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`.
	Filter *string `protobuf:"bytes,336120696,opt,name=filter,proto3,oneof" json:"filter,omitempty"`
	// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
	IncludeAllScopes *bool `protobuf:"varint,391327988,opt,name=include_all_scopes,json=includeAllScopes,proto3,oneof" json:"include_all_scopes,omitempty"`
	// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
	MaxResults *uint32 `protobuf:"varint,54715419,opt,name=max_results,json=maxResults,proto3,oneof" json:"max_results,omitempty"`
	// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
	OrderBy *string `protobuf:"bytes,160562920,opt,name=order_by,json=orderBy,proto3,oneof" json:"order_by,omitempty"`
	// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
	PageToken *string `protobuf:"bytes,19994697,opt,name=page_token,json=pageToken,proto3,oneof" json:"page_token,omitempty"`
	// Project ID for this request.
	Project string `protobuf:"bytes,227560217,opt,name=project,proto3" json:"project,omitempty"`
	// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
	ReturnPartialSuccess *bool `protobuf:"varint,517198390,opt,name=return_partial_success,json=returnPartialSuccess,proto3,oneof" json:"return_partial_success,omitempty"`
}

func (x *AggregatedListInterconnectAttachmentsRequest) Reset() {
	*x = AggregatedListInterconnectAttachmentsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AggregatedListInterconnectAttachmentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AggregatedListInterconnectAttachmentsRequest) ProtoMessage() {}

func (x *AggregatedListInterconnectAttachmentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AggregatedListInterconnectAttachmentsRequest.ProtoReflect.Descriptor instead.
func (*AggregatedListInterconnectAttachmentsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{45}
}

func (x *AggregatedListInterconnectAttachmentsRequest) GetFilter() string {
	if x != nil && x.Filter != nil {
		return *x.Filter
	}
	return ""
}

func (x *AggregatedListInterconnectAttachmentsRequest) GetIncludeAllScopes() bool {
	if x != nil && x.IncludeAllScopes != nil {
		return *x.IncludeAllScopes
	}
	return false
}

func (x *AggregatedListInterconnectAttachmentsRequest) GetMaxResults() uint32 {
	if x != nil && x.MaxResults != nil {
		return *x.MaxResults
	}
	return 0
}

func (x *AggregatedListInterconnectAttachmentsRequest) GetOrderBy() string {
	if x != nil && x.OrderBy != nil {
		return *x.OrderBy
	}
	return ""
}

func (x *AggregatedListInterconnectAttachmentsRequest) GetPageToken() string {
	if x != nil && x.PageToken != nil {
		return *x.PageToken
	}
	return ""
}

func (x *AggregatedListInterconnectAttachmentsRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *AggregatedListInterconnectAttachmentsRequest) GetReturnPartialSuccess() bool {
	if x != nil && x.ReturnPartialSuccess != nil {
		return *x.ReturnPartialSuccess
	}
	return false
}

// A request message for MachineTypes.AggregatedList. See the method description for details.
type AggregatedListMachineTypesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:` operator can be used with string fields to match substrings. For non-string fields it is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`.
	Filter *string `protobuf:"bytes,336120696,opt,name=filter,proto3,oneof" json:"filter,omitempty"`
	// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
	IncludeAllScopes *bool `protobuf:"varint,391327988,opt,name=include_all_scopes,json=includeAllScopes,proto3,oneof" json:"include_all_scopes,omitempty"`
	// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
	MaxResults *uint32 `protobuf:"varint,54715419,opt,name=max_results,json=maxResults,proto3,oneof" json:"max_results,omitempty"`
	// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
	OrderBy *string `protobuf:"bytes,160562920,opt,name=order_by,json=orderBy,proto3,oneof" json:"order_by,omitempty"`
	// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
	PageToken *string `protobuf:"bytes,19994697,opt,name=page_token,json=pageToken,proto3,oneof" json:"page_token,omitempty"`
	// Project ID for this request.
	Project string `protobuf:"bytes,227560217,opt,name=project,proto3" json:"project,omitempty"`
	// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
	ReturnPartialSuccess *bool `protobuf:"varint,517198390,opt,name=return_partial_success,json=returnPartialSuccess,proto3,oneof" json:"return_partial_success,omitempty"`
}

func (x *AggregatedListMachineTypesRequest) Reset() {
	*x = AggregatedListMachineTypesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AggregatedListMachineTypesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AggregatedListMachineTypesRequest) ProtoMessage() {}

func (x *AggregatedListMachineTypesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AggregatedListMachineTypesRequest.ProtoReflect.Descriptor instead.
func (*AggregatedListMachineTypesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{46}
}

func (x *AggregatedListMachineTypesRequest) GetFilter() string {
	if x != nil && x.Filter != nil {
		return *x.Filter
	}
	return ""
}

func (x *AggregatedListMachineTypesRequest) GetIncludeAllScopes() bool {
	if x != nil && x.IncludeAllScopes != nil {
		return *x.IncludeAllScopes
	}
	return false
}

func (x *AggregatedListMachineTypesRequest) GetMaxResults() uint32 {
	if x != nil && x.MaxResults != nil {
		return *x.MaxResults
	}
	return 0
}

func (x *AggregatedListMachineTypesRequest) GetOrderBy() string {
	if x != nil && x.OrderBy != nil {
		return *x.OrderBy
	}
	return ""
}

func (x *AggregatedListMachineTypesRequest) GetPageToken() string {
	if x != nil && x.PageToken != nil {
		return *x.PageToken
	}
	return ""
}

func (x *AggregatedListMachineTypesRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *AggregatedListMachineTypesRequest) GetReturnPartialSuccess() bool {
	if x != nil && x.ReturnPartialSuccess != nil {
		return *x.ReturnPartialSuccess
	}
	return false
}

// A request message for NetworkAttachments.AggregatedList. See the method description for details.
type AggregatedListNetworkAttachmentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:` operator can be used with string fields to match substrings. For non-string fields it is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`.
	Filter *string `protobuf:"bytes,336120696,opt,name=filter,proto3,oneof" json:"filter,omitempty"`
	// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
	IncludeAllScopes *bool `protobuf:"varint,391327988,opt,name=include_all_scopes,json=includeAllScopes,proto3,oneof" json:"include_all_scopes,omitempty"`
	// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
	MaxResults *uint32 `protobuf:"varint,54715419,opt,name=max_results,json=maxResults,proto3,oneof" json:"max_results,omitempty"`
	// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
	OrderBy *string `protobuf:"bytes,160562920,opt,name=order_by,json=orderBy,proto3,oneof" json:"order_by,omitempty"`
	// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
	PageToken *string `protobuf:"bytes,19994697,opt,name=page_token,json=pageToken,proto3,oneof" json:"page_token,omitempty"`
	// Project ID for this request.
	Project string `protobuf:"bytes,227560217,opt,name=project,proto3" json:"project,omitempty"`
	// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
	ReturnPartialSuccess *bool `protobuf:"varint,517198390,opt,name=return_partial_success,json=returnPartialSuccess,proto3,oneof" json:"return_partial_success,omitempty"`
}

func (x *AggregatedListNetworkAttachmentsRequest) Reset() {
	*x = AggregatedListNetworkAttachmentsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AggregatedListNetworkAttachmentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AggregatedListNetworkAttachmentsRequest) ProtoMessage() {}

func (x *AggregatedListNetworkAttachmentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AggregatedListNetworkAttachmentsRequest.ProtoReflect.Descriptor instead.
func (*AggregatedListNetworkAttachmentsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{47}
}

func (x *AggregatedListNetworkAttachmentsRequest) GetFilter() string {
	if x != nil && x.Filter != nil {
		return *x.Filter
	}
	return ""
}

func (x *AggregatedListNetworkAttachmentsRequest) GetIncludeAllScopes() bool {
	if x != nil && x.IncludeAllScopes != nil {
		return *x.IncludeAllScopes
	}
	return false
}

func (x *AggregatedListNetworkAttachmentsRequest) GetMaxResults() uint32 {
	if x != nil && x.MaxResults != nil {
		return *x.MaxResults
	}
	return 0
}

func (x *AggregatedListNetworkAttachmentsRequest) GetOrderBy() string {
	if x != nil && x.OrderBy != nil {
		return *x.OrderBy
	}
	return ""
}

func (x *AggregatedListNetworkAttachmentsRequest) GetPageToken() string {
	if x != nil && x.PageToken != nil {
		return *x.PageToken
	}
	return ""
}

func (x *AggregatedListNetworkAttachmentsRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *AggregatedListNetworkAttachmentsRequest) GetReturnPartialSuccess() bool {
	if x != nil && x.ReturnPartialSuccess != nil {
		return *x.ReturnPartialSuccess
	}
	return false
}

// A request message for NetworkEdgeSecurityServices.AggregatedList. See the method description for details.
type AggregatedListNetworkEdgeSecurityServicesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:` operator can be used with string fields to match substrings. For non-string fields it is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`.
	Filter *string `protobuf:"bytes,336120696,opt,name=filter,proto3,oneof" json:"filter,omitempty"`
	// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
	IncludeAllScopes *bool `protobuf:"varint,391327988,opt,name=include_all_scopes,json=includeAllScopes,proto3,oneof" json:"include_all_scopes,omitempty"`
	// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
	MaxResults *uint32 `protobuf:"varint,54715419,opt,name=max_results,json=maxResults,proto3,oneof" json:"max_results,omitempty"`
	// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
	OrderBy *string `protobuf:"bytes,160562920,opt,name=order_by,json=orderBy,proto3,oneof" json:"order_by,omitempty"`
	// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
	PageToken *string `protobuf:"bytes,19994697,opt,name=page_token,json=pageToken,proto3,oneof" json:"page_token,omitempty"`
	// Name of the project scoping this request.
	Project string `protobuf:"bytes,227560217,opt,name=project,proto3" json:"project,omitempty"`
	// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
	ReturnPartialSuccess *bool `protobuf:"varint,517198390,opt,name=return_partial_success,json=returnPartialSuccess,proto3,oneof" json:"return_partial_success,omitempty"`
}

func (x *AggregatedListNetworkEdgeSecurityServicesRequest) Reset() {
	*x = AggregatedListNetworkEdgeSecurityServicesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AggregatedListNetworkEdgeSecurityServicesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AggregatedListNetworkEdgeSecurityServicesRequest) ProtoMessage() {}

func (x *AggregatedListNetworkEdgeSecurityServicesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AggregatedListNetworkEdgeSecurityServicesRequest.ProtoReflect.Descriptor instead.
func (*AggregatedListNetworkEdgeSecurityServicesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{48}
}

func (x *AggregatedListNetworkEdgeSecurityServicesRequest) GetFilter() string {
	if x != nil && x.Filter != nil {
		return *x.Filter
	}
	return ""
}

func (x *AggregatedListNetworkEdgeSecurityServicesRequest) GetIncludeAllScopes() bool {
	if x != nil && x.IncludeAllScopes != nil {
		return *x.IncludeAllScopes
	}
	return false
}

func (x *AggregatedListNetworkEdgeSecurityServicesRequest) GetMaxResults() uint32 {
	if x != nil && x.MaxResults != nil {
		return *x.MaxResults
	}
	return 0
}

func (x *AggregatedListNetworkEdgeSecurityServicesRequest) GetOrderBy() string {
	if x != nil && x.OrderBy != nil {
		return *x.OrderBy
	}
	return ""
}

func (x *AggregatedListNetworkEdgeSecurityServicesRequest) GetPageToken() string {
	if x != nil && x.PageToken != nil {
		return *x.PageToken
	}
	return ""
}

func (x *AggregatedListNetworkEdgeSecurityServicesRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *AggregatedListNetworkEdgeSecurityServicesRequest) GetReturnPartialSuccess() bool {
	if x != nil && x.ReturnPartialSuccess != nil {
		return *x.ReturnPartialSuccess
	}
	return false
}

// A request message for NetworkEndpointGroups.AggregatedList. See the method description for details.
type AggregatedListNetworkEndpointGroupsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:` operator can be used with string fields to match substrings. For non-string fields it is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`.
	Filter *string `protobuf:"bytes,336120696,opt,name=filter,proto3,oneof" json:"filter,omitempty"`
	// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
	IncludeAllScopes *bool `protobuf:"varint,391327988,opt,name=include_all_scopes,json=includeAllScopes,proto3,oneof" json:"include_all_scopes,omitempty"`
	// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
	MaxResults *uint32 `protobuf:"varint,54715419,opt,name=max_results,json=maxResults,proto3,oneof" json:"max_results,omitempty"`
	// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
	OrderBy *string `protobuf:"bytes,160562920,opt,name=order_by,json=orderBy,proto3,oneof" json:"order_by,omitempty"`
	// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
	PageToken *string `protobuf:"bytes,19994697,opt,name=page_token,json=pageToken,proto3,oneof" json:"page_token,omitempty"`
	// Project ID for this request.
	Project string `protobuf:"bytes,227560217,opt,name=project,proto3" json:"project,omitempty"`
	// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
	ReturnPartialSuccess *bool `protobuf:"varint,517198390,opt,name=return_partial_success,json=returnPartialSuccess,proto3,oneof" json:"return_partial_success,omitempty"`
}

func (x *AggregatedListNetworkEndpointGroupsRequest) Reset() {
	*x = AggregatedListNetworkEndpointGroupsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AggregatedListNetworkEndpointGroupsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AggregatedListNetworkEndpointGroupsRequest) ProtoMessage() {}

func (x *AggregatedListNetworkEndpointGroupsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AggregatedListNetworkEndpointGroupsRequest.ProtoReflect.Descriptor instead.
func (*AggregatedListNetworkEndpointGroupsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{49}
}

func (x *AggregatedListNetworkEndpointGroupsRequest) GetFilter() string {
	if x != nil && x.Filter != nil {
		return *x.Filter
	}
	return ""
}

func (x *AggregatedListNetworkEndpointGroupsRequest) GetIncludeAllScopes() bool {
	if x != nil && x.IncludeAllScopes != nil {
		return *x.IncludeAllScopes
	}
	return false
}

func (x *AggregatedListNetworkEndpointGroupsRequest) GetMaxResults() uint32 {
	if x != nil && x.MaxResults != nil {
		return *x.MaxResults
	}
	return 0
}

func (x *AggregatedListNetworkEndpointGroupsRequest) GetOrderBy() string {
	if x != nil && x.OrderBy != nil {
		return *x.OrderBy
	}
	return ""
}

func (x *AggregatedListNetworkEndpointGroupsRequest) GetPageToken() string {
	if x != nil && x.PageToken != nil {
		return *x.PageToken
	}
	return ""
}

func (x *AggregatedListNetworkEndpointGroupsRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *AggregatedListNetworkEndpointGroupsRequest) GetReturnPartialSuccess() bool {
	if x != nil && x.ReturnPartialSuccess != nil {
		return *x.ReturnPartialSuccess
	}
	return false
}

// A request message for NodeGroups.AggregatedList. See the method description for details.
type AggregatedListNodeGroupsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:` operator can be used with string fields to match substrings. For non-string fields it is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`.
	Filter *string `protobuf:"bytes,336120696,opt,name=filter,proto3,oneof" json:"filter,omitempty"`
	// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
	IncludeAllScopes *bool `protobuf:"varint,391327988,opt,name=include_all_scopes,json=includeAllScopes,proto3,oneof" json:"include_all_scopes,omitempty"`
	// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
	MaxResults *uint32 `protobuf:"varint,54715419,opt,name=max_results,json=maxResults,proto3,oneof" json:"max_results,omitempty"`
	// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
	OrderBy *string `protobuf:"bytes,160562920,opt,name=order_by,json=orderBy,proto3,oneof" json:"order_by,omitempty"`
	// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
	PageToken *string `protobuf:"bytes,19994697,opt,name=page_token,json=pageToken,proto3,oneof" json:"page_token,omitempty"`
	// Project ID for this request.
	Project string `protobuf:"bytes,227560217,opt,name=project,proto3" json:"project,omitempty"`
	// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
	ReturnPartialSuccess *bool `protobuf:"varint,517198390,opt,name=return_partial_success,json=returnPartialSuccess,proto3,oneof" json:"return_partial_success,omitempty"`
}

func (x *AggregatedListNodeGroupsRequest) Reset() {
	*x = AggregatedListNodeGroupsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[50]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AggregatedListNodeGroupsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AggregatedListNodeGroupsRequest) ProtoMessage() {}

func (x *AggregatedListNodeGroupsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[50]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AggregatedListNodeGroupsRequest.ProtoReflect.Descriptor instead.
func (*AggregatedListNodeGroupsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{50}
}

func (x *AggregatedListNodeGroupsRequest) GetFilter() string {
	if x != nil && x.Filter != nil {
		return *x.Filter
	}
	return ""
}

func (x *AggregatedListNodeGroupsRequest) GetIncludeAllScopes() bool {
	if x != nil && x.IncludeAllScopes != nil {
		return *x.IncludeAllScopes
	}
	return false
}

func (x *AggregatedListNodeGroupsRequest) GetMaxResults() uint32 {
	if x != nil && x.MaxResults != nil {
		return *x.MaxResults
	}
	return 0
}

func (x *AggregatedListNodeGroupsRequest) GetOrderBy() string {
	if x != nil && x.OrderBy != nil {
		return *x.OrderBy
	}
	return ""
}

func (x *AggregatedListNodeGroupsRequest) GetPageToken() string {
	if x != nil && x.PageToken != nil {
		return *x.PageToken
	}
	return ""
}

func (x *AggregatedListNodeGroupsRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *AggregatedListNodeGroupsRequest) GetReturnPartialSuccess() bool {
	if x != nil && x.ReturnPartialSuccess != nil {
		return *x.ReturnPartialSuccess
	}
	return false
}

// A request message for NodeTemplates.AggregatedList. See the method description for details.
type AggregatedListNodeTemplatesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:` operator can be used with string fields to match substrings. For non-string fields it is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`.
	Filter *string `protobuf:"bytes,336120696,opt,name=filter,proto3,oneof" json:"filter,omitempty"`
	// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
	IncludeAllScopes *bool `protobuf:"varint,391327988,opt,name=include_all_scopes,json=includeAllScopes,proto3,oneof" json:"include_all_scopes,omitempty"`
	// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
	MaxResults *uint32 `protobuf:"varint,54715419,opt,name=max_results,json=maxResults,proto3,oneof" json:"max_results,omitempty"`
	// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
	OrderBy *string `protobuf:"bytes,160562920,opt,name=order_by,json=orderBy,proto3,oneof" json:"order_by,omitempty"`
	// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
	PageToken *string `protobuf:"bytes,19994697,opt,name=page_token,json=pageToken,proto3,oneof" json:"page_token,omitempty"`
	// Project ID for this request.
	Project string `protobuf:"bytes,227560217,opt,name=project,proto3" json:"project,omitempty"`
	// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
	ReturnPartialSuccess *bool `protobuf:"varint,517198390,opt,name=return_partial_success,json=returnPartialSuccess,proto3,oneof" json:"return_partial_success,omitempty"`
}

func (x *AggregatedListNodeTemplatesRequest) Reset() {
	*x = AggregatedListNodeTemplatesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AggregatedListNodeTemplatesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AggregatedListNodeTemplatesRequest) ProtoMessage() {}

func (x *AggregatedListNodeTemplatesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AggregatedListNodeTemplatesRequest.ProtoReflect.Descriptor instead.
func (*AggregatedListNodeTemplatesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{51}
}

func (x *AggregatedListNodeTemplatesRequest) GetFilter() string {
	if x != nil && x.Filter != nil {
		return *x.Filter
	}
	return ""
}

func (x *AggregatedListNodeTemplatesRequest) GetIncludeAllScopes() bool {
	if x != nil && x.IncludeAllScopes != nil {
		return *x.IncludeAllScopes
	}
	return false
}

func (x *AggregatedListNodeTemplatesRequest) GetMaxResults() uint32 {
	if x != nil && x.MaxResults != nil {
		return *x.MaxResults
	}
	return 0
}

func (x *AggregatedListNodeTemplatesRequest) GetOrderBy() string {
	if x != nil && x.OrderBy != nil {
		return *x.OrderBy
	}
	return ""
}

func (x *AggregatedListNodeTemplatesRequest) GetPageToken() string {
	if x != nil && x.PageToken != nil {
		return *x.PageToken
	}
	return ""
}

func (x *AggregatedListNodeTemplatesRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *AggregatedListNodeTemplatesRequest) GetReturnPartialSuccess() bool {
	if x != nil && x.ReturnPartialSuccess != nil {
		return *x.ReturnPartialSuccess
	}
	return false
}

// A request message for NodeTypes.AggregatedList. See the method description for details.
type AggregatedListNodeTypesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:` operator can be used with string fields to match substrings. For non-string fields it is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`.
	Filter *string `protobuf:"bytes,336120696,opt,name=filter,proto3,oneof" json:"filter,omitempty"`
	// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
	IncludeAllScopes *bool `protobuf:"varint,391327988,opt,name=include_all_scopes,json=includeAllScopes,proto3,oneof" json:"include_all_scopes,omitempty"`
	// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
	MaxResults *uint32 `protobuf:"varint,54715419,opt,name=max_results,json=maxResults,proto3,oneof" json:"max_results,omitempty"`
	// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
	OrderBy *string `protobuf:"bytes,160562920,opt,name=order_by,json=orderBy,proto3,oneof" json:"order_by,omitempty"`
	// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
	PageToken *string `protobuf:"bytes,19994697,opt,name=page_token,json=pageToken,proto3,oneof" json:"page_token,omitempty"`
	// Project ID for this request.
	Project string `protobuf:"bytes,227560217,opt,name=project,proto3" json:"project,omitempty"`
	// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
	ReturnPartialSuccess *bool `protobuf:"varint,517198390,opt,name=return_partial_success,json=returnPartialSuccess,proto3,oneof" json:"return_partial_success,omitempty"`
}

func (x *AggregatedListNodeTypesRequest) Reset() {
	*x = AggregatedListNodeTypesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AggregatedListNodeTypesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AggregatedListNodeTypesRequest) ProtoMessage() {}

func (x *AggregatedListNodeTypesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AggregatedListNodeTypesRequest.ProtoReflect.Descriptor instead.
func (*AggregatedListNodeTypesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{52}
}

func (x *AggregatedListNodeTypesRequest) GetFilter() string {
	if x != nil && x.Filter != nil {
		return *x.Filter
	}
	return ""
}

func (x *AggregatedListNodeTypesRequest) GetIncludeAllScopes() bool {
	if x != nil && x.IncludeAllScopes != nil {
		return *x.IncludeAllScopes
	}
	return false
}

func (x *AggregatedListNodeTypesRequest) GetMaxResults() uint32 {
	if x != nil && x.MaxResults != nil {
		return *x.MaxResults
	}
	return 0
}

func (x *AggregatedListNodeTypesRequest) GetOrderBy() string {
	if x != nil && x.OrderBy != nil {
		return *x.OrderBy
	}
	return ""
}

func (x *AggregatedListNodeTypesRequest) GetPageToken() string {
	if x != nil && x.PageToken != nil {
		return *x.PageToken
	}
	return ""
}

func (x *AggregatedListNodeTypesRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *AggregatedListNodeTypesRequest) GetReturnPartialSuccess() bool {
	if x != nil && x.ReturnPartialSuccess != nil {
		return *x.ReturnPartialSuccess
	}
	return false
}

// A request message for PacketMirrorings.AggregatedList. See the method description for details.
type AggregatedListPacketMirroringsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:` operator can be used with string fields to match substrings. For non-string fields it is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`.
	Filter *string `protobuf:"bytes,336120696,opt,name=filter,proto3,oneof" json:"filter,omitempty"`
	// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
	IncludeAllScopes *bool `protobuf:"varint,391327988,opt,name=include_all_scopes,json=includeAllScopes,proto3,oneof" json:"include_all_scopes,omitempty"`
	// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
	MaxResults *uint32 `protobuf:"varint,54715419,opt,name=max_results,json=maxResults,proto3,oneof" json:"max_results,omitempty"`
	// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
	OrderBy *string `protobuf:"bytes,160562920,opt,name=order_by,json=orderBy,proto3,oneof" json:"order_by,omitempty"`
	// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
	PageToken *string `protobuf:"bytes,19994697,opt,name=page_token,json=pageToken,proto3,oneof" json:"page_token,omitempty"`
	// Project ID for this request.
	Project string `protobuf:"bytes,227560217,opt,name=project,proto3" json:"project,omitempty"`
	// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
	ReturnPartialSuccess *bool `protobuf:"varint,517198390,opt,name=return_partial_success,json=returnPartialSuccess,proto3,oneof" json:"return_partial_success,omitempty"`
}

func (x *AggregatedListPacketMirroringsRequest) Reset() {
	*x = AggregatedListPacketMirroringsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[53]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AggregatedListPacketMirroringsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AggregatedListPacketMirroringsRequest) ProtoMessage() {}

func (x *AggregatedListPacketMirroringsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[53]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AggregatedListPacketMirroringsRequest.ProtoReflect.Descriptor instead.
func (*AggregatedListPacketMirroringsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{53}
}

func (x *AggregatedListPacketMirroringsRequest) GetFilter() string {
	if x != nil && x.Filter != nil {
		return *x.Filter
	}
	return ""
}

func (x *AggregatedListPacketMirroringsRequest) GetIncludeAllScopes() bool {
	if x != nil && x.IncludeAllScopes != nil {
		return *x.IncludeAllScopes
	}
	return false
}

func (x *AggregatedListPacketMirroringsRequest) GetMaxResults() uint32 {
	if x != nil && x.MaxResults != nil {
		return *x.MaxResults
	}
	return 0
}

func (x *AggregatedListPacketMirroringsRequest) GetOrderBy() string {
	if x != nil && x.OrderBy != nil {
		return *x.OrderBy
	}
	return ""
}

func (x *AggregatedListPacketMirroringsRequest) GetPageToken() string {
	if x != nil && x.PageToken != nil {
		return *x.PageToken
	}
	return ""
}

func (x *AggregatedListPacketMirroringsRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *AggregatedListPacketMirroringsRequest) GetReturnPartialSuccess() bool {
	if x != nil && x.ReturnPartialSuccess != nil {
		return *x.ReturnPartialSuccess
	}
	return false
}

// A request message for PublicDelegatedPrefixes.AggregatedList. See the method description for details.
type AggregatedListPublicDelegatedPrefixesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:` operator can be used with string fields to match substrings. For non-string fields it is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`.
	Filter *string `protobuf:"bytes,336120696,opt,name=filter,proto3,oneof" json:"filter,omitempty"`
	// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
	IncludeAllScopes *bool `protobuf:"varint,391327988,opt,name=include_all_scopes,json=includeAllScopes,proto3,oneof" json:"include_all_scopes,omitempty"`
	// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
	MaxResults *uint32 `protobuf:"varint,54715419,opt,name=max_results,json=maxResults,proto3,oneof" json:"max_results,omitempty"`
	// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
	OrderBy *string `protobuf:"bytes,160562920,opt,name=order_by,json=orderBy,proto3,oneof" json:"order_by,omitempty"`
	// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
	PageToken *string `protobuf:"bytes,19994697,opt,name=page_token,json=pageToken,proto3,oneof" json:"page_token,omitempty"`
	// Name of the project scoping this request.
	Project string `protobuf:"bytes,227560217,opt,name=project,proto3" json:"project,omitempty"`
	// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
	ReturnPartialSuccess *bool `protobuf:"varint,517198390,opt,name=return_partial_success,json=returnPartialSuccess,proto3,oneof" json:"return_partial_success,omitempty"`
}

func (x *AggregatedListPublicDelegatedPrefixesRequest) Reset() {
	*x = AggregatedListPublicDelegatedPrefixesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[54]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AggregatedListPublicDelegatedPrefixesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AggregatedListPublicDelegatedPrefixesRequest) ProtoMessage() {}

func (x *AggregatedListPublicDelegatedPrefixesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[54]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AggregatedListPublicDelegatedPrefixesRequest.ProtoReflect.Descriptor instead.
func (*AggregatedListPublicDelegatedPrefixesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{54}
}

func (x *AggregatedListPublicDelegatedPrefixesRequest) GetFilter() string {
	if x != nil && x.Filter != nil {
		return *x.Filter
	}
	return ""
}

func (x *AggregatedListPublicDelegatedPrefixesRequest) GetIncludeAllScopes() bool {
	if x != nil && x.IncludeAllScopes != nil {
		return *x.IncludeAllScopes
	}
	return false
}

func (x *AggregatedListPublicDelegatedPrefixesRequest) GetMaxResults() uint32 {
	if x != nil && x.MaxResults != nil {
		return *x.MaxResults
	}
	return 0
}

func (x *AggregatedListPublicDelegatedPrefixesRequest) GetOrderBy() string {
	if x != nil && x.OrderBy != nil {
		return *x.OrderBy
	}
	return ""
}

func (x *AggregatedListPublicDelegatedPrefixesRequest) GetPageToken() string {
	if x != nil && x.PageToken != nil {
		return *x.PageToken
	}
	return ""
}

func (x *AggregatedListPublicDelegatedPrefixesRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *AggregatedListPublicDelegatedPrefixesRequest) GetReturnPartialSuccess() bool {
	if x != nil && x.ReturnPartialSuccess != nil {
		return *x.ReturnPartialSuccess
	}
	return false
}

// A request message for RegionCommitments.AggregatedList. See the method description for details.
type AggregatedListRegionCommitmentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:` operator can be used with string fields to match substrings. For non-string fields it is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`.
	Filter *string `protobuf:"bytes,336120696,opt,name=filter,proto3,oneof" json:"filter,omitempty"`
	// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
	IncludeAllScopes *bool `protobuf:"varint,391327988,opt,name=include_all_scopes,json=includeAllScopes,proto3,oneof" json:"include_all_scopes,omitempty"`
	// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
	MaxResults *uint32 `protobuf:"varint,54715419,opt,name=max_results,json=maxResults,proto3,oneof" json:"max_results,omitempty"`
	// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
	OrderBy *string `protobuf:"bytes,160562920,opt,name=order_by,json=orderBy,proto3,oneof" json:"order_by,omitempty"`
	// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
	PageToken *string `protobuf:"bytes,19994697,opt,name=page_token,json=pageToken,proto3,oneof" json:"page_token,omitempty"`
	// Project ID for this request.
	Project string `protobuf:"bytes,227560217,opt,name=project,proto3" json:"project,omitempty"`
	// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
	ReturnPartialSuccess *bool `protobuf:"varint,517198390,opt,name=return_partial_success,json=returnPartialSuccess,proto3,oneof" json:"return_partial_success,omitempty"`
}

func (x *AggregatedListRegionCommitmentsRequest) Reset() {
	*x = AggregatedListRegionCommitmentsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[55]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AggregatedListRegionCommitmentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AggregatedListRegionCommitmentsRequest) ProtoMessage() {}

func (x *AggregatedListRegionCommitmentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[55]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AggregatedListRegionCommitmentsRequest.ProtoReflect.Descriptor instead.
func (*AggregatedListRegionCommitmentsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{55}
}

func (x *AggregatedListRegionCommitmentsRequest) GetFilter() string {
	if x != nil && x.Filter != nil {
		return *x.Filter
	}
	return ""
}

func (x *AggregatedListRegionCommitmentsRequest) GetIncludeAllScopes() bool {
	if x != nil && x.IncludeAllScopes != nil {
		return *x.IncludeAllScopes
	}
	return false
}

func (x *AggregatedListRegionCommitmentsRequest) GetMaxResults() uint32 {
	if x != nil && x.MaxResults != nil {
		return *x.MaxResults
	}
	return 0
}

func (x *AggregatedListRegionCommitmentsRequest) GetOrderBy() string {
	if x != nil && x.OrderBy != nil {
		return *x.OrderBy
	}
	return ""
}

func (x *AggregatedListRegionCommitmentsRequest) GetPageToken() string {
	if x != nil && x.PageToken != nil {
		return *x.PageToken
	}
	return ""
}

func (x *AggregatedListRegionCommitmentsRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *AggregatedListRegionCommitmentsRequest) GetReturnPartialSuccess() bool {
	if x != nil && x.ReturnPartialSuccess != nil {
		return *x.ReturnPartialSuccess
	}
	return false
}

// A request message for Reservations.AggregatedList. See the method description for details.
type AggregatedListReservationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:` operator can be used with string fields to match substrings. For non-string fields it is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`.
	Filter *string `protobuf:"bytes,336120696,opt,name=filter,proto3,oneof" json:"filter,omitempty"`
	// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
	IncludeAllScopes *bool `protobuf:"varint,391327988,opt,name=include_all_scopes,json=includeAllScopes,proto3,oneof" json:"include_all_scopes,omitempty"`
	// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
	MaxResults *uint32 `protobuf:"varint,54715419,opt,name=max_results,json=maxResults,proto3,oneof" json:"max_results,omitempty"`
	// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
	OrderBy *string `protobuf:"bytes,160562920,opt,name=order_by,json=orderBy,proto3,oneof" json:"order_by,omitempty"`
	// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
	PageToken *string `protobuf:"bytes,19994697,opt,name=page_token,json=pageToken,proto3,oneof" json:"page_token,omitempty"`
	// Project ID for this request.
	Project string `protobuf:"bytes,227560217,opt,name=project,proto3" json:"project,omitempty"`
	// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
	ReturnPartialSuccess *bool `protobuf:"varint,517198390,opt,name=return_partial_success,json=returnPartialSuccess,proto3,oneof" json:"return_partial_success,omitempty"`
}

func (x *AggregatedListReservationsRequest) Reset() {
	*x = AggregatedListReservationsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[56]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AggregatedListReservationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AggregatedListReservationsRequest) ProtoMessage() {}

func (x *AggregatedListReservationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[56]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AggregatedListReservationsRequest.ProtoReflect.Descriptor instead.
func (*AggregatedListReservationsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{56}
}

func (x *AggregatedListReservationsRequest) GetFilter() string {
	if x != nil && x.Filter != nil {
		return *x.Filter
	}
	return ""
}

func (x *AggregatedListReservationsRequest) GetIncludeAllScopes() bool {
	if x != nil && x.IncludeAllScopes != nil {
		return *x.IncludeAllScopes
	}
	return false
}

func (x *AggregatedListReservationsRequest) GetMaxResults() uint32 {
	if x != nil && x.MaxResults != nil {
		return *x.MaxResults
	}
	return 0
}

func (x *AggregatedListReservationsRequest) GetOrderBy() string {
	if x != nil && x.OrderBy != nil {
		return *x.OrderBy
	}
	return ""
}

func (x *AggregatedListReservationsRequest) GetPageToken() string {
	if x != nil && x.PageToken != nil {
		return *x.PageToken
	}
	return ""
}

func (x *AggregatedListReservationsRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *AggregatedListReservationsRequest) GetReturnPartialSuccess() bool {
	if x != nil && x.ReturnPartialSuccess != nil {
		return *x.ReturnPartialSuccess
	}
	return false
}

// A request message for ResourcePolicies.AggregatedList. See the method description for details.
type AggregatedListResourcePoliciesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:` operator can be used with string fields to match substrings. For non-string fields it is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`.
	Filter *string `protobuf:"bytes,336120696,opt,name=filter,proto3,oneof" json:"filter,omitempty"`
	// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
	IncludeAllScopes *bool `protobuf:"varint,391327988,opt,name=include_all_scopes,json=includeAllScopes,proto3,oneof" json:"include_all_scopes,omitempty"`
	// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
	MaxResults *uint32 `protobuf:"varint,54715419,opt,name=max_results,json=maxResults,proto3,oneof" json:"max_results,omitempty"`
	// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
	OrderBy *string `protobuf:"bytes,160562920,opt,name=order_by,json=orderBy,proto3,oneof" json:"order_by,omitempty"`
	// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
	PageToken *string `protobuf:"bytes,19994697,opt,name=page_token,json=pageToken,proto3,oneof" json:"page_token,omitempty"`
	// Project ID for this request.
	Project string `protobuf:"bytes,227560217,opt,name=project,proto3" json:"project,omitempty"`
	// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
	ReturnPartialSuccess *bool `protobuf:"varint,517198390,opt,name=return_partial_success,json=returnPartialSuccess,proto3,oneof" json:"return_partial_success,omitempty"`
}

func (x *AggregatedListResourcePoliciesRequest) Reset() {
	*x = AggregatedListResourcePoliciesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[57]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AggregatedListResourcePoliciesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AggregatedListResourcePoliciesRequest) ProtoMessage() {}

func (x *AggregatedListResourcePoliciesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[57]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AggregatedListResourcePoliciesRequest.ProtoReflect.Descriptor instead.
func (*AggregatedListResourcePoliciesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{57}
}

func (x *AggregatedListResourcePoliciesRequest) GetFilter() string {
	if x != nil && x.Filter != nil {
		return *x.Filter
	}
	return ""
}

func (x *AggregatedListResourcePoliciesRequest) GetIncludeAllScopes() bool {
	if x != nil && x.IncludeAllScopes != nil {
		return *x.IncludeAllScopes
	}
	return false
}

func (x *AggregatedListResourcePoliciesRequest) GetMaxResults() uint32 {
	if x != nil && x.MaxResults != nil {
		return *x.MaxResults
	}
	return 0
}

func (x *AggregatedListResourcePoliciesRequest) GetOrderBy() string {
	if x != nil && x.OrderBy != nil {
		return *x.OrderBy
	}
	return ""
}

func (x *AggregatedListResourcePoliciesRequest) GetPageToken() string {
	if x != nil && x.PageToken != nil {
		return *x.PageToken
	}
	return ""
}

func (x *AggregatedListResourcePoliciesRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *AggregatedListResourcePoliciesRequest) GetReturnPartialSuccess() bool {
	if x != nil && x.ReturnPartialSuccess != nil {
		return *x.ReturnPartialSuccess
	}
	return false
}

// A request message for Routers.AggregatedList. See the method description for details.
type AggregatedListRoutersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:` operator can be used with string fields to match substrings. For non-string fields it is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq "double quoted literal"` `(fieldname1 eq literal) (fieldname2 ne "literal")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name "instance", you would use `name ne .*instance`.
	Filter *string `protobuf:"bytes,336120696,opt,name=filter,proto3,oneof" json:"filter,omitempty"`
	// Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
	IncludeAllScopes *bool `protobuf:"varint,391327988,opt,name=include_all_scopes,json=includeAllScopes,proto3,oneof" json:"include_all_scopes,omitempty"`
	// The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
	MaxResults *uint32 `protobuf:"varint,54715419,opt,name=max_results,json=maxResults,proto3,oneof" json:"max_results,omitempty"`
	// Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
	OrderBy *string `protobuf:"bytes,160562920,opt,name=order_by,json=orderBy,proto3,oneof" json:"order_by,omitempty"`
	// Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list request to get the next page of results.
	PageToken *string `protobuf:"bytes,19994697,opt,name=page_token,json=pageToken,proto3,oneof" json:"page_token,omitempty"`
	// Project ID for this request.
	Project string `protobuf:"bytes,227560217,opt,name=project,proto3" json:"project,omitempty"`
	// Opt-in for partial success behavior which provides partial results in case of failure. The default value is false.
	ReturnPartialSuccess *bool `protobuf:"varint,517198390,opt,name=return_partial_success,json=returnPartialSuccess,proto3,oneof" json:"return_partial_success,omitempty"`
}

func (x *AggregatedListRoutersRequest) Reset() {
	*x = AggregatedListRoutersRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[58]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AggregatedListRoutersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AggregatedListRoutersRequest) ProtoMessage() {}

func (x *AggregatedListRoutersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[58]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AggregatedListRoutersRequest.ProtoReflect.Descriptor instead.
func (*AggregatedListRoutersRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{58}
}

func (x *AggregatedListRoutersRequest) GetFilter() string {
	if x != nil && x.Filter != nil {
		return *x.Filter
	}
	return ""
}

func (x *AggregatedListRoutersRequest) GetIncludeAllScopes() bool {
	if x != nil && x.IncludeAllScopes != nil {
		return *x.IncludeAllScopes
	}
	return false
}

func (x *AggregatedListRoutersRequest) GetMaxResults() uint32 {
	if x != nil && x.MaxResults != nil {
		return *x.MaxResults
	}
	return 0
}

func (x *AggregatedListRoutersRequest) GetOrderBy() string {
	if x != nil && x.OrderBy != nil {
		return *x.OrderBy
	}
	return ""
}

func (x *AggregatedListRoutersRequest) GetPageToken() string {
	if x != nil && x.PageToken != nil {
		return *x.PageToken
	}
	return ""
}

func (x *AggregatedListRoutersRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *AggregatedListRoutersRequest) GetReturnPartialSuccess() bool {
	if x != nil && x.ReturnPartialSuccess != nil {
		return *x.ReturnPartialSuccess
	}
	return false
}

// A request message for SecurityPolicies.AggregatedList. See the method description for details.
type AggregatedListSecurityPoliciesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A filter expression that filters resources listed in the response. Most Compute resources support two types of filter e