//go:build go1.16
// +build go1.16

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armresources

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"net/http"
)

// ClientCreateOrUpdateByIDPoller provides polling facilities until the operation reaches a terminal state.
type ClientCreateOrUpdateByIDPoller struct {
	pt *azcore.Poller
}

// Done returns true if the LRO has reached a terminal state.
func (p *ClientCreateOrUpdateByIDPoller) Done() bool {
	return p.pt.Done()
}

// Poll fetches the latest state of the LRO.  It returns an HTTP response or error.
// If the LRO has completed successfully, the poller's state is updated and the HTTP
// response is returned.
// If the LRO has completed with failure or was cancelled, the poller's state is
// updated and the error is returned.
// If the LRO has not reached a terminal state, the poller's state is updated and
// the latest HTTP response is returned.
// If Poll fails, the poller's state is unmodified and the error is returned.
// Calling Poll on an LRO that has reached a terminal state will return the final
// HTTP response or error.
func (p *ClientCreateOrUpdateByIDPoller) Poll(ctx context.Context) (*http.Response, error) {
	return p.pt.Poll(ctx)
}

// FinalResponse performs a final GET to the service and returns the final response
// for the polling operation. If there is an error performing the final GET then an error is returned.
// If the final GET succeeded then the final ClientCreateOrUpdateByIDResponse will be returned.
func (p *ClientCreateOrUpdateByIDPoller) FinalResponse(ctx context.Context) (ClientCreateOrUpdateByIDResponse, error) {
	respType := ClientCreateOrUpdateByIDResponse{}
	resp, err := p.pt.FinalResponse(ctx, &respType.GenericResource)
	if err != nil {
		return ClientCreateOrUpdateByIDResponse{}, err
	}
	respType.RawResponse = resp
	return respType, nil
}

// ResumeToken returns a value representing the poller that can be used to resume
// the LRO at a later time. ResumeTokens are unique per service operation.
func (p *ClientCreateOrUpdateByIDPoller) ResumeToken() (string, error) {
	return p.pt.ResumeToken()
}

// ClientCreateOrUpdatePoller provides polling facilities until the operation reaches a terminal state.
type ClientCreateOrUpdatePoller struct {
	pt *azcore.Poller
}

// Done returns true if the LRO has reached a terminal state.
func (p *ClientCreateOrUpdatePoller) Done() bool {
	return p.pt.Done()
}

// Poll fetches the latest state of the LRO.  It returns an HTTP response or error.
// If the LRO has completed successfully, the poller's state is updated and the HTTP
// response is returned.
// If the LRO has completed with failure or was cancelled, the poller's state is
// updated and the error is returned.
// If the LRO has not reached a terminal state, the poller's state is updated and
// the latest HTTP response is returned.
// If Poll fails, the poller's state is unmodified and the error is returned.
// Calling Poll on an LRO that has reached a terminal state will return the final
// HTTP response or error.
func (p *ClientCreateOrUpdatePoller) Poll(ctx context.Context) (*http.Response, error) {
	return p.pt.Poll(ctx)
}

// FinalResponse performs a final GET to the service and returns the final response
// for the polling operation. If there is an error performing the final GET then an error is returned.
// If the final GET succeeded then the final ClientCreateOrUpdateResponse will be returned.
func (p *ClientCreateOrUpdatePoller) FinalResponse(ctx context.Context) (ClientCreateOrUpdateResponse, error) {
	respType := ClientCreateOrUpdateResponse{}
	resp, err := p.pt.FinalResponse(ctx, &respType.GenericResource)
	if err != nil {
		return ClientCreateOrUpdateResponse{}, err
	}
	respType.RawResponse = resp
	return respType, nil
}

// ResumeToken returns a value representing the poller that can be used to resume
// the LRO at a later time. ResumeTokens are unique per service operation.
func (p *ClientCreateOrUpdatePoller) ResumeToken() (string, error) {
	return p.pt.ResumeToken()
}

// ClientDeleteByIDPoller provides polling facilities until the operation reaches a terminal state.
type ClientDeleteByIDPoller struct {
	pt *azcore.Poller
}

// Done returns true if the LRO has reached a terminal state.
func (p *ClientDeleteByIDPoller) Done() bool {
	return p.pt.Done()
}

// Poll fetches the latest state of the LRO.  It returns an HTTP response or error.
// If the LRO has completed successfully, the poller's state is updated and the HTTP
// response is returned.
// If the LRO has completed with failure or was cancelled, the poller's state is
// updated and the error is returned.
// If the LRO has not reached a terminal state, the poller's state is updated and
// the latest HTTP response is returned.
// If Poll fails, the poller's state is unmodified and the error is returned.
// Calling Poll on an LRO that has reached a terminal state will return the final
// HTTP response or error.
func (p *ClientDeleteByIDPoller) Poll(ctx context.Context) (*http.Response, error) {
	return p.pt.Poll(ctx)
}

// FinalResponse performs a final GET to the service and returns the final response
// for the polling operation. If there is an error performing the final GET then an error is returned.
// If the final GET succeeded then the final ClientDeleteByIDResponse will be returned.
func (p *ClientDeleteByIDPoller) FinalResponse(ctx context.Context) (ClientDeleteByIDResponse, error) {
	respType := ClientDeleteByIDResponse{}
	resp, err := p.pt.FinalResponse(ctx, nil)
	if err != nil {
		return ClientDeleteByIDResponse{}, err
	}
	respType.RawResponse = resp
	return respType, nil
}

// ResumeToken returns a value representing the poller that can be used to resume
// the LRO at a later time. ResumeTokens are unique per service operation.
func (p *ClientDeleteByIDPoller) ResumeToken() (string, error) {
	return p.pt.ResumeToken()
}

// ClientDeletePoller provides polling facilities until the operation reaches a terminal state.
type ClientDeletePoller struct {
	pt *azcore.Poller
}

// Done returns true if the LRO has reached a terminal state.
func (p *ClientDeletePoller) Done() bool {
	return p.pt.Done()
}

// Poll fetches the latest state of the LRO.  It returns an HTTP response or error.
// If the LRO has completed successfully, the poller's state is updated and the HTTP
// response is returned.
// If the LRO has completed with failure or was cancelled, the poller's state is
// updated and the error is returned.
// If the LRO has not reached a terminal state, the poller's state is updated and
// the latest HTTP response is returned.
// If Poll fails, the poller's state is unmodified and the error is returned.
// Calling Poll on an LRO that has reached a terminal state will return the final
// HTTP response or error.
func (p *ClientDeletePoller) Poll(ctx context.Context) (*http.Response, error) {
	return p.pt.Poll(ctx)
}

// FinalResponse performs a final GET to the service and returns the final response
// for the polling operation. If there is an error performing the final GET then an error is returned.
// If the final GET succeeded then the final ClientDeleteResponse will be returned.
func (p *ClientDeletePoller) FinalResponse(ctx context.Context) (ClientDeleteResponse, error) {
	respType := ClientDeleteResponse{}
	resp, err := p.pt.FinalResponse(ctx, nil)
	if err != nil {
		return ClientDeleteResponse{}, err
	}
	respType.RawResponse = resp
	return respType, nil
}

// ResumeToken returns a value representing the poller that can be used to resume
// the LRO at a later time. ResumeTokens are unique per service operation.
func (p *ClientDeletePoller) ResumeToken() (string, error) {
	return p.pt.ResumeToken()
}

// ClientMoveResourcesPoller provides polling facilities until the operation reaches a terminal state.
type ClientMoveResourcesPoller struct {
	pt *azcore.Poller
}

// Done returns true if the LRO has reached a terminal state.
func (p *ClientMoveResourcesPoller) Done() bool {
	return p.pt.Done()
}

// Poll fetches the latest state of the LRO.  It returns an HTTP response or error.
// If the LRO has completed successfully, the poller's state is updated and the HTTP
// response is returned.
// If the LRO has completed with failure or was cancelled, the poller's state is
// updated and the error is returned.
// If the LRO has not reached a terminal state, the poller's state is updated and
// the latest HTTP response is returned.
// If Poll fails, the poller's state is unmodified and the error is returned.
// Calling Poll on an LRO that has reached a terminal state will return the final
// HTTP response or error.
func (p *ClientMoveResourcesPoller) Poll(ctx context.Context) (*http.Response, error) {
	return p.pt.Poll(ctx)
}

// FinalResponse performs a final GET to the service and returns the final response
// for the polling operation. If there is an error performing the final GET then an error is returned.
// If the final GET succeeded then the final ClientMoveResourcesResponse will be returned.
func (p *ClientMoveResourcesPoller) FinalResponse(ctx context.Context) (ClientMoveResourcesResponse, error) {
	respType := ClientMoveResourcesResponse{}
	resp, err := p.pt.FinalResponse(ctx, nil)
	if err != nil {
		return ClientMoveResourcesResponse{}, err
	}
	respType.RawResponse = resp
	return respType, nil
}

// ResumeToken returns a value representing the poller that can be used to resume
// the LRO at a later time. ResumeTokens are unique per service operation.
func (p *ClientMoveResourcesPoller) ResumeToken() (string, error) {
	return p.pt.ResumeToken()
}

// ClientUpdateByIDPoller provides polling facilities until the operation reaches a terminal state.
type ClientUpdateByIDPoller struct {
	pt *azcore.Poller
}

// Done returns true if the LRO has reached a terminal state.
func (p *ClientUpdateByIDPoller) Done() bool {
	return p.pt.Done()
}

// Poll fetches the latest state of the LRO.  It returns an HTTP response or error.
// If the LRO has completed successfully, the poller's state is updated and the HTTP
// response is returned.
// If the LRO has completed with failure or was cancelled, the poller's state is
// updated and the error is returned.
// If the LRO has not reached a terminal state, the poller's state is updated and
// the latest HTTP response is returned.
// If Poll fails, the poller's state is unmodified and the error is returned.
// Calling Poll on an LRO that has reached a terminal state will return the final
// HTTP response or error.
func (p *ClientUpdateByIDPoller) Poll(ctx context.Context) (*http.Response, error) {
	return p.pt.Poll(ctx)
}

// FinalResponse performs a final GET to the service and returns the final response
// for the polling operation. If there is an error performing the final GET then an error is returned.
// If the final GET succeeded then the final ClientUpdateByIDResponse will be returned.
func (p *ClientUpdateByIDPoller) FinalResponse(ctx context.Context) (ClientUpdateByIDResponse, error) {
	respType := ClientUpdateByIDResponse{}
	resp, err := p.pt.FinalResponse(ctx, &respType.GenericResource)
	if err != nil {
		return ClientUpdateByIDResponse{}, err
	}
	respType.RawResponse = resp
	return respType, nil
}

// ResumeToken returns a value representing the poller that can be used to resume
// the LRO at a later time. ResumeTokens are unique per service operation.
func (p *ClientUpdateByIDPoller) ResumeToken() (string, error) {
	return p.pt.ResumeToken()
}

// ClientUpdatePoller provides polling facilities until the operation reaches a terminal state.
type ClientUpdatePoller struct {
	pt *azcore.Poller
}

// Done returns true if the LRO has reached a terminal state.
func (p *ClientUpdatePoller) Done() bool {
	return p.pt.Done()
}

// Poll fetches the latest state of the LRO.  It returns an HTTP response or error.
// If the LRO has completed successfully, the poller's state is updated and the HTTP
// response is returned.
// If the LRO has completed with failure or was cancelled, the poller's state is
// updated and the error is returned.
// If the LRO has not reached a terminal state, the poller's state is updated and
// the latest HTTP response is returned.
// If Poll fails, the poller's state is unmodified and the error is returned.
// Calling Poll on an LRO that has reached a terminal state will return the final
// HTTP response or error.
func (p *ClientUpdatePoller) Poll(ctx context.Context) (*http.Response, error) {
	return p.pt.Poll(ctx)
}

// FinalResponse performs a final GET to the service and returns the final response
// for the polling operation. If there is an error performing the final GET then an error is returned.
// If the final GET succeeded then the final ClientUpdateResponse will be returned.
func (p *ClientUpdatePoller) FinalResponse(ctx context.Context) (ClientUpdateResponse, error) {
	respType := ClientUpdateResponse{}
	resp, err := p.pt.FinalResponse(ctx, &respType.GenericResource)
	if err != nil {
		return ClientUpdateResponse{}, err
	}
	respType.RawResponse = resp
	return respType, nil
}

// ResumeToken returns a value representing the poller that can be used to resume
// the LRO at a later time. ResumeTokens are unique per service operation.
func (p *ClientUpdatePoller) ResumeToken() (string, error) {
	return p.pt.ResumeToken()
}

// ClientValidateMoveResourcesPoller provides polling facilities until the operation reaches a terminal state.
type ClientValidateMoveResourcesPoller struct {
	pt *azcore.Poller
}

// Done returns true if the LRO has reached a terminal state.
func (p *ClientValidateMoveResourcesPoller) Done() bool {
	return p.pt.Done()
}

// Poll fetches the latest state of the LRO.  It returns an HTTP response or error.
// If the LRO has completed successfully, the poller's state is updated and the HTTP
// response is returned.
// If the LRO has completed with failure or was cancelled, the poller's state is
// updated and the error is returned.
// If the LRO has not reached a terminal state, the poller's state is updated and
// the latest HTTP response is returned.
// If Poll fails, the poller's state is unmodified and the error is returned.
// Calling Poll on an LRO that has reached a terminal state will return the final
// HTTP response or error.
func (p *ClientValidateMoveResourcesPoller) Poll(ctx context.Context) (*http.Response, error) {
	return p.pt.Poll(ctx)
}

// FinalResponse performs a final GET to the service and returns the final response
// for the polling operation. If there is an error performing the final GET then an error is returned.
// If the final GET succeeded then the final ClientValidateMoveResourcesResponse will be returned.
func (p *ClientValidateMoveResourcesPoller) FinalResponse(ctx context.Context) (ClientValidateMoveResourcesResponse, error) {
	respType := ClientValidateMoveResourcesResponse{}
	resp, err := p.pt.FinalResponse(ctx, nil)
	if err != nil {
		return ClientValidateMoveResourcesResponse{}, err
	}
	respType.RawResponse = resp
	return respType, nil
}

// ResumeToken returns a value representing the poller that can be used to resume
// the LRO at a later time. ResumeTokens are unique per service operation.
func (p *ClientValidateMoveResourcesPoller) ResumeToken() (string, error) {
	return p.pt.ResumeToken()
}

// DeploymentsClientCreateOrUpdateAtManagementGroupScopePoller provides polling facilities until the operation reaches a terminal state.
type DeploymentsClientCreateOrUpdateAtManagementGroupScopePoller struct {
	pt *azcore.Poller
}

// Done returns true if the LRO has reached a terminal state.
func (p *DeploymentsClientCreateOrUpdateAtManagementGroupScopePoller) Done() bool {
	return p.pt.Done()
}

// Poll fetches the latest state of the LRO.  It returns an HTTP response or error.
// If the LRO has completed successfully, the poller's state is updated and the HTTP
// response is returned.
// If the LRO has completed with failure or was cancelled, the poller's state is
// updated and the error is returned.
// If the LRO has not reached a terminal state, the poller's state is updated and
// the latest HTTP response is returned.
// If Poll fails, the poller's state is unmodified and the error is returned.
// Calling Poll on an LRO that has reached a terminal state will return the final
// HTTP response or error.
func (p *DeploymentsClientCreateOrUpdateAtManagementGroupScopePoller) Poll(ctx context.Context) (*http.Response, error) {
	return p.pt.Poll(ctx)
}

// FinalResponse performs a final GET to the service and returns the final response
// for the polling operation. If there is an error performing the final GET then an error is returned.
// If the final GET succeeded then the final DeploymentsClientCreateOrUpdateAtManagementGroupScopeResponse will be returned.
func (p *DeploymentsClientCreateOrUpdateAtManagementGroupScopePoller) FinalResponse(ctx context.Context) (DeploymentsClientCreateOrUpdateAtManagementGroupScopeResponse, error) {
	respType := DeploymentsClientCreateOrUpdateAtManagementGroupScopeResponse{}
	resp, err := p.pt.FinalResponse(ctx, &respType.DeploymentExtended)
	if err != nil {
		return DeploymentsClientCreateOrUpdateAtManagementGroupScopeResponse{}, err
	}
	respType.RawResponse = resp
	return respType, nil
}

// ResumeToken returns a value representing the poller that can be used to resume
// the LRO at a later time. ResumeTokens are unique per service operation.
func (p *DeploymentsClientCreateOrUpdateAtManagementGroupScopePoller) ResumeToken() (string, error) {
	return p.pt.ResumeToken()
}

// DeploymentsClientCreateOrUpdateAtScopePoller provides polling facilities until the operation reaches a terminal state.
type DeploymentsClientCreateOrUpdateAtScopePoller struct {
	pt *azcore.Poller
}

// Done returns true if the LRO has reached a terminal state.
func (p *DeploymentsClientCreateOrUpdateAtScopePoller) Done() bool {
	return p.pt.Done()
}

// Poll fetches the latest state of the LRO.  It returns an HTTP response or error.
// If the LRO has completed successfully, the poller's state is updated and the HTTP
// response is returned.
// If the LRO has completed with failure or was cancelled, the poller's state is
// updated and the error is returned.
// If the LRO has not reached a terminal state, the poller's state is updated and
// the latest HTTP response is returned.
// If Poll fails, the poller's state is unmodified and the error is returned.
// Calling Poll on an LRO that has reached a terminal state will return the final
// HTTP response or error.
func (p *DeploymentsClientCreateOrUpdateAtScopePoller) Poll(ctx context.Context) (*http.Response, error) {
	return p.pt.Poll(ctx)
}

// FinalResponse performs a final GET to the service and returns the final response
// for the polling operation. If there is an error performing the final GET then an error is returned.
// If the final GET succeeded then the final DeploymentsClientCreateOrUpdateAtScopeResponse will be returned.
func (p *DeploymentsClientCreateOrUpdateAtScopePoller) FinalResponse(ctx context.Context) (DeploymentsClientCreateOrUpdateAtScopeResponse, error) {
	respType := DeploymentsClientCreateOrUpdateAtScopeResponse{}
	resp, err := p.pt.FinalResponse(ctx, &respType.DeploymentExtended)
	if err != nil {
		return DeploymentsClientCreateOrUpdateAtScopeResponse{}, err
	}
	respType.RawResponse = resp
	return respType, nil
}

// ResumeToken returns a value representing the poller that can be used to resume
// the LRO at a later time. ResumeTokens are unique per service operation.
func (p *DeploymentsClientCreateOrUpdateAtScopePoller) ResumeToken() (string, error) {
	return p.pt.ResumeToken()
}

// DeploymentsClientCreateOrUpdateAtSubscriptionScopePoller provides polling facilities until the operation reaches a terminal state.
type DeploymentsClientCreateOrUpdateAtSubscriptionScopePoller struct {
	pt *azcore.Poller
}

// Done returns true if the LRO has reached a terminal state.
func (p *DeploymentsClientCreateOrUpdateAtSubscriptionScopePoller) Done() bool {
	return p.pt.Done()
}

// Poll fetches the latest state of the LRO.  It returns an HTTP response or error.
// If the LRO has completed successfully, the poller's state is updated and the HTTP
// response is returned.
// If the LRO has completed with failure or was cancelled, the poller's state is
// updated and the error is returned.
// If the LRO has not reached a terminal state, the poller's state is updated and
// the latest HTTP response is returned.
// If Poll fails, the poller's state is unmodified and the error is returned.
// Calling Poll on an LRO that has reached a terminal state will return the final
// HTTP response or error.
func (p *DeploymentsClientCreateOrUpdateAtSubscriptionScopePoller) Poll(ctx context.Context) (*http.Response, error) {
	return p.pt.Poll(ctx)
}

// FinalResponse performs a final GET to the service and returns the final response
// for the polling operation. If there is an error performing the final GET then an error is returned.
// If the final GET succeeded then the final DeploymentsClientCreateOrUpdateAtSubscriptionScopeResponse will be returned.
func (p *DeploymentsClientCreateOrUpdateAtSubscriptionScopePoller) FinalResponse(ctx context.Context) (DeploymentsClientCreateOrUpdateAtSubscriptionScopeResponse, error) {
	respType := DeploymentsClientCreateOrUpdateAtSubscriptionScopeResponse{}
	resp, err := p.pt.FinalResponse(ctx, &respType.DeploymentExtended)
	if err != nil {
		return DeploymentsClientCreateOrUpdateAtSubscriptionScopeResponse{}, err
	}
	respType.RawResponse = resp
	return respType, nil
}

// ResumeToken returns a value representing the poller that can be used to resume
// the LRO at a later time. ResumeTokens are unique per service operation.
func (p *DeploymentsClientCreateOrUpdateAtSubscriptionScopePoller) ResumeToken() (string, error) {
	return p.pt.ResumeToken()
}

// DeploymentsClientCreateOrUpdateAtTenantScopePoller provides polling facilities until the operation reaches a terminal state.
type DeploymentsClientCreateOrUpdateAtTenantScopePoller struct {
	pt *azcore.Poller
}

// Done returns true if the LRO has reached a terminal state.
func (p *DeploymentsClientCreateOrUpdateAtTenantScopePoller) Done() bool {
	return p.pt.Done()
}

// Poll fetches the latest state of the LRO.  It returns an HTTP response or error.
// If the LRO has completed successfully, the poller's state is updated and the HTTP
// response is returned.
// If the LRO has completed with failure or was cancelled, the poller's state is
// updated and the error is returned.
// If the LRO has not reached a terminal state, the poller's state is updated and
// the latest HTTP response is returned.
// If Poll fails, the poller's state is unmodified and the error is returned.
// Calling Poll on an LRO that has reached a terminal state will return the final
// HTTP response or error.
func (p *DeploymentsClientCreateOrUpdateAtTenantScopePoller) Poll(ctx context.Context) (*http.Response, error) {
	return p.pt.Poll(ctx)
}

// FinalResponse performs a final GET to the service and returns the final response
// for the polling operation. If there is an error performing the final GET then an error is returned.
// If the final GET succeeded then the final DeploymentsClientCreateOrUpdateAtTenantScopeResponse will be returned.
func (p *DeploymentsClientCreateOrUpdateAtTenantScopePoller) FinalResponse(ctx context.Context) (DeploymentsClientCreateOrUpdateAtTenantScopeResponse, error) {
	respType := DeploymentsClientCreateOrUpdateAtTenantScopeResponse{}
	resp, err := p.pt.FinalResponse(ctx, &respType.DeploymentExtended)
	if err != nil {
		return DeploymentsClientCreateOrUpdateAtTenantScopeResponse{}, err
	}
	respType.RawResponse = resp
	return respType, nil
}

// ResumeToken returns a value representing the poller that can be used to resume
// the LRO at a later time. ResumeTokens are unique per service operation.
func (p *DeploymentsClientCreateOrUpdateAtTenantScopePoller) ResumeToken() (string, error) {
	return p.pt.ResumeToken()
}

// DeploymentsClientCreateOrUpdatePoller provides polling facilities until the operation reaches a terminal state.
type DeploymentsClientCreateOrUpdatePoller struct {
	pt *azcore.Poller
}

// Done returns true if the LRO has reached a terminal state.
func (p *DeploymentsClientCreateOrUpdatePoller) Done() bool {
	return p.pt.Done()
}

// Poll fetches the latest state of the LRO.  It returns an HTTP response or error.
// If the LRO has completed successfully, the poller's state is updated and the HTTP
// response is returned.
// If the LRO has completed with failure or was cancelled, the poller's state is
// updated and the error is returned.
// If the LRO has not reached a terminal state, the poller's state is updated and
// the latest HTTP response is returned.
// If Poll fails, the poller's state is unmodified and the error is returned.
// Calling Poll on an LRO that has reached a terminal state will return the final
// HTTP response or error.
func (p *DeploymentsClientCreateOrUpdatePoller) Poll(ctx context.Context) (*http.Response, error) {
	return p.pt.Poll(ctx)
}

// FinalResponse performs a final GET to the service and returns the final response
// for the polling operation. If there is an error performing the final GET then an error is returned.
// If the final GET succeeded then the final DeploymentsClientCreateOrUpdateResponse will be returned.
func (p *DeploymentsClientCreateOrUpdatePoller) FinalResponse(ctx context.Context) (DeploymentsClientCreateOrUpdateResponse, error) {
	respType := DeploymentsClientCreateOrUpdateResponse{}
	resp, err := p.pt.FinalResponse(ctx, &respType.DeploymentExtended)
	if err != nil {
		return DeploymentsClientCreateOrUpdateResponse{}, err
	}
	respType.RawResponse = resp
	return respType, nil
}

// ResumeToken returns a value representing the poller that can be used to resume
// the LRO at a later time. ResumeTokens are unique per service operation.
func (p *DeploymentsClientCreateOrUpdatePoller) ResumeToken() (string, error) {
	return p.pt.ResumeToken()
}

// DeploymentsClientDeleteAtManagementGroupScopePoller provides polling facilities until the operation reaches a terminal state.
type DeploymentsClientDeleteAtManagementGroupScopePoller struct {
	pt *azcore.Poller
}

// Done returns true if the LRO has reached a terminal state.
func (p *DeploymentsClientDeleteAtManagementGroupScopePoller) Done() bool {
	return p.pt.Done()
}

// Poll fetches the latest state of the LRO.  It returns an HTTP response or error.
// If the LRO has completed successfully, the poller's state is updated and the HTTP
// response is returned.
// If the LRO has completed with failure or was cancelled, the poller's state is
// updated and the error is returned.
// If the LRO has not reached a terminal state, the poller's state is updated and
// the latest HTTP response is returned.
// If Poll fails, the poller's state is unmodified and the error is returned.
// Calling Poll on an LRO that has reached a terminal state will return the final
// HTTP response or error.
func (p *DeploymentsClientDeleteAtManagementGroupScopePoller) Poll(ctx context.Context) (*http.Response, error) {
	return p.pt.Poll(ctx)
}

// FinalResponse performs a final GET to the service and returns the final response
// for the polling operation. If there is an error performing the final GET then an error is returned.
// If the final GET succeeded then the final DeploymentsClientDeleteAtManagementGroupScopeResponse will be returned.
func (p *DeploymentsClientDeleteAtManagementGroupScopePoller) FinalResponse(ctx context.Context) (DeploymentsClientDeleteAtManagementGroupScopeResponse, error) {
	respType := DeploymentsClientDeleteAtManagementGroupScopeResponse{}
	resp, err := p.pt.FinalResponse(ctx, nil)
	if err != nil {
		return DeploymentsClientDeleteAtManagementGroupScopeResponse{}, err
	}
	respType.RawResponse = resp
	return respType, nil
}

// ResumeToken returns a value representing the poller that can be used to resume
// the LRO at a later time. ResumeTokens are unique per service operation.
func (p *DeploymentsClientDeleteAtManagementGroupScopePoller) ResumeToken() (string, error) {
	return p.pt.ResumeToken()
}

// DeploymentsClientDeleteAtScopePoller provides polling facilities until the operation reaches a terminal state.
type DeploymentsClientDeleteAtScopePoller struct {
	pt *azcore.Poller
}

// Done returns true if the LRO has reached a terminal state.
func (p *DeploymentsClientDeleteAtScopePoller) Done() bool {
	return p.pt.Done()
}

// Poll fetches the latest state of the LRO.  It returns an HTTP response or error.
// If the LRO has completed successfully, the poller's state is updated and the HTTP
// response is returned.
// If the LRO has completed with failure or was cancelled, the poller's state is
// updated and the error is returned.
// If the LRO has not reached a terminal state, the poller's state is updated and
// the latest HTTP response is returned.
// If Poll fails, the poller's state is unmodified and the error is returned.
// Calling Poll on an LRO that has reached a terminal state will return the final
// HTTP response or error.
func (p *DeploymentsClientDeleteAtScopePoller) Poll(ctx context.Context) (*http.Response, error) {
	return p.pt.Poll(ctx)
}

// FinalResponse performs a final GET to the service and returns the final response
// for the polling operation. If there is an error performing the final GET then an error is returned.
// If the final GET succeeded then the final DeploymentsClientDeleteAtScopeResponse will be returned.
func (p *DeploymentsClientDeleteAtScopePoller) FinalResponse(ctx context.Context) (DeploymentsClientDeleteAtScopeResponse, error) {
	respType := DeploymentsClientDeleteAtScopeResponse{}
	resp, err := p.pt.FinalResponse(ctx, nil)
	if err != nil {
		return DeploymentsClientDeleteAtScopeResponse{}, err
	}
	respType.RawResponse = resp
	return respType, nil
}

// ResumeToken returns a value representing the poller that can be used to resume
// the LRO at a later time. ResumeTokens are unique per service operation.
func (p *DeploymentsClientDeleteAtScopePoller) ResumeToken() (string, error) {
	return p.pt.ResumeToken()
}

// DeploymentsClientDeleteAtSubscriptionScopePoller provides polling facilities until the operation reaches a terminal state.
type DeploymentsClientDeleteAtSubscriptionScopePoller struct {
	pt *azcore.Poller
}

// Done returns true if the LRO has reached a terminal state.
func (p *DeploymentsClientDeleteAtSubscriptionScopePoller) Done() bool {
	return p.pt.Done()
}

// Poll fetches the latest state of the LRO.  It returns an HTTP response or error.
// If the LRO has completed successfully, the poller's state is updated and the HTTP
// response is returned.
// If the LRO has completed with failure or was cancelled, the poller's state is
// updated and the error is returned.
// If the LRO has not reached a terminal state, the poller's state is updated and
// the latest HTTP response is returned.
// If Poll fails, the poller's state is unmodified and the error is returned.
// Calling Poll on an LRO that has reached a terminal state will return the final
// HTTP response or error.
func (p *DeploymentsClientDeleteAtSubscriptionScopePoller) Poll(ctx context.Context) (*http.Response, error) {
	return p.pt.Poll(ctx)
}

// FinalResponse performs a final GET to the service and returns the final response
// for the polling operation. If there is an error performing the final GET then an error is returned.
// If the final GET succeeded then the final DeploymentsClientDeleteAtSubscriptionScopeResponse will be returned.
func (p *DeploymentsClientDeleteAtSubscriptionScopePoller) FinalResponse(ctx context.Context) (DeploymentsClientDeleteAtSubscriptionScopeResponse, error) {
	respType := DeploymentsClientDeleteAtSubscriptionScopeResponse{}
	resp, err := p.pt.FinalResponse(ctx, nil)
	if err != nil {
		return DeploymentsClientDeleteAtSubscriptionScopeResponse{}, err
	}
	respType.RawResponse = resp
	return respType, nil
}

// ResumeToken returns a value representing the poller that can be used to resume
// the LRO at a later time. ResumeTokens are unique per service operation.
func (p *DeploymentsClientDeleteAtSubscriptionScopePoller) ResumeToken() (string, error) {
	return p.pt.ResumeToken()
}

// DeploymentsClientDeleteAtTenantScopePoller provides polling facilities until the operation reaches a terminal state.
type DeploymentsClientDeleteAtTenantScopePoller struct {
	pt *azcore.Poller
}

// Done returns true if the LRO has reached a terminal state.
func (p *DeploymentsClientDeleteAtTenantScopePoller) Done() bool {
	return p.pt.Done()
}

// Poll fetches the latest state of the LRO.  It returns an HTTP response or error.
// If the LRO has completed successfully, the poller's state is updated and the HTTP
// response is returned.
// If the LRO has completed with failure or was cancelled, the poller's state is
// updated and the error is returned.
// If the LRO has not reached a terminal state, the poller's state is updated and
// the latest HTTP response is returned.
// If Poll fails, the poller's state is unmodified and the error is returned.
// Calling Poll on an LRO that has reached a terminal state will return the final
// HTTP response or error.
func (p *DeploymentsClientDeleteAtTenantScopePoller) Poll(ctx context.Context) (*http.Response, error) {
	return p.pt.Poll(ctx)
}

// FinalResponse performs a final GET to the service and returns the final response
// for the polling operation. If there is an error performing the final GET then an error is returned.
// If the final GET succeeded then the final DeploymentsClientDeleteAtTenantScopeResponse will be returned.
func (p *DeploymentsClientDeleteAtTenantScopePoller) FinalResponse(ctx context.Context) (DeploymentsClientDeleteAtTenantScopeResponse, error) {
	respType := DeploymentsClientDeleteAtTenantScopeResponse{}
	resp, err := p.pt.FinalResponse(ctx, nil)
	if err != nil {
		return DeploymentsClientDeleteAtTenantScopeResponse{}, err
	}
	respType.RawResponse = resp
	return respType, nil
}

// ResumeToken returns a value representing the poller that can be used to resume
// the LRO at a later time. ResumeTokens are unique per service operation.
func (p *DeploymentsClientDeleteAtTenantScopePoller) ResumeToken() (string, error) {
	return p.pt.ResumeToken()
}

// DeploymentsClientDeletePoller provides polling facilities until the operation reaches a terminal state.
type DeploymentsClientDeletePoller struct {
	pt *azcore.Poller
}

// Done returns true if the LRO has reached a terminal state.
func (p *DeploymentsClientDeletePoller) Done() bool {
	return p.pt.Done()
}

// Poll fetches the latest state of the LRO.  It returns an HTTP response or error.
// If the LRO has completed successfully, the poller's state is updated and the HTTP
// response is returned.
// If the LRO has completed with failure or was cancelled, the poller's state is
// updated and the error is returned.
// If the LRO has not reached a terminal state, the poller's state is updated and
// the latest HTTP response is returned.
// If Poll fails, the poller's state is unmodified and the error is returned.
// Calling Poll on an LRO that has reached a terminal state will return the final
// HTTP response or error.
func (p *DeploymentsClientDeletePoller) Poll(ctx context.Context) (*http.Response, error) {
	return p.pt.Poll(ctx)
}

// FinalResponse performs a final GET to the service and returns the final response
// for the polling operation. If there is an error performing the final GET then an error is returned.
// If the final GET succeeded then the final DeploymentsClientDeleteResponse will be returned.
func (p *DeploymentsClientDeletePoller) FinalResponse(ctx context.Context) (DeploymentsClientDeleteResponse, error) {
	respType := DeploymentsClientDeleteResponse{}
	resp, err := p.pt.FinalResponse(ctx, nil)
	if err != nil {
		return DeploymentsClientDeleteResponse{}, err
	}
	respType.RawResponse = resp
	return respType, nil
}

// ResumeToken returns a value representing the poller that can be used to resume
// the LRO at a later time. ResumeTokens are unique per service operation.
func (p *DeploymentsClientDeletePoller) ResumeToken() (string, error) {
	return p.pt.ResumeToken()
}

// DeploymentsClientValidateAtManagementGroupScopePoller provides polling facilities until the operation reaches a terminal state.
type DeploymentsClientValidateAtManagementGroupScopePoller struct {
	pt *azcore.Poller
}

// Done returns true if the LRO has reached a terminal state.
func (p *DeploymentsClientValidateAtManagementGroupScopePoller) Done() bool {
	return p.pt.Done()
}

// Poll fetches the latest state of the LRO.  It returns an HTTP response or error.
// If the LRO has completed successfully, the poller's state is updated and the HTTP
// response is returned.
// If the LRO has completed with failure or was cancelled, the poller's state is
// updated and the error is returned.
// If the LRO has not reached a terminal state, the poller's state is updated and
// the latest HTTP response is returned.
// If Poll fails, the poller's state is unmodified and the error is returned.
// Calling Poll on an LRO that has reached a terminal state will return the final
// HTTP response or error.
func (p *DeploymentsClientValidateAtManagementGroupScopePoller) Poll(ctx context.Context) (*http.Response, error) {
	return p.pt.Poll(ctx)
}

// FinalResponse performs a final GET to the service and returns the final response
// for the polling operation. If there is an error performing the final GET then an error is returned.
// If the final GET succeeded then the final DeploymentsClientValidateAtManagementGroupScopeResponse will be returned.
func (p *DeploymentsClientValidateAtManagementGroupScopePoller) FinalResponse(ctx context.Context) (DeploymentsClientValidateAtManagementGroupScopeResponse, error) {
	respType := DeploymentsClientValidateAtManagementGroupScopeResponse{}
	resp, err := p.pt.FinalResponse(ctx, &respType.DeploymentValidateResult)
	if err != nil {
		return DeploymentsClientValidateAtManagementGroupScopeResponse{}, err
	}
	respType.RawResponse = resp
	return respType, nil
}

// ResumeToken returns a value representing the poller that can be used to resume
// the LRO at a later time. ResumeTokens are unique per service operation.
func (p *DeploymentsClientValidateAtManagementGroupScopePoller) ResumeToken() (string, error) {
	return p.pt.ResumeToken()
}

// DeploymentsClientValidateAtScopePoller provides polling facilities until the operation reaches a terminal state.
type DeploymentsClientValidateAtScopePoller struct {
	pt *azcore.Poller
}

// Done returns true if the LRO has reached a terminal state.
func (p *DeploymentsClientValidateAtScopePoller) Done() bool {
	return p.pt.Done()
}

// Poll fetches the latest state of the LRO.  It returns an HTTP response or error.
// If the LRO has completed successfully, the poller's state is updated and the HTTP
// response is returned.
// If the LRO has completed with failure or was cancelled, the poller's state is
// updated and the error is returned.
// If the LRO has not reached a terminal state, the poller's state is updated and
// the latest HTTP response is returned.
// If Poll fails, the poller's state is unmodified and the error is returned.
// Calling Poll on an LRO that has reached a terminal state will return the final
// HTTP response or error.
func (p *DeploymentsClientValidateAtScopePoller) Poll(ctx context.Context) (*http.Response, error) {
	return p.pt.Poll(ctx)
}

// FinalResponse performs a final GET to the service and returns the final response
// for the polling operation. If there is an error performing the final GET then an error is returned.
// If the final GET succeeded then the final DeploymentsClientValidateAtScopeResponse will be returned.
func (p *DeploymentsClientValidateAtScopePoller) FinalResponse(ctx context.Context) (DeploymentsClientValidateAtScopeResponse, error) {
	respType := DeploymentsClientValidateAtScopeResponse{}
	resp, err := p.pt.FinalResponse(ctx, &respType.DeploymentValidateResult)
	if err != nil {
		return DeploymentsClientValidateAtScopeResponse{}, err
	}
	respType.RawResponse = resp
	return respType, nil
}

// ResumeToken returns a value representing the poller that can be used to resume
// the LRO at a later time. ResumeTokens are unique per service operation.
func (p *DeploymentsClientValidateAtScopePoller) ResumeToken() (string, error) {
	return p.pt.ResumeToken()
}

// DeploymentsClientValidateAtSubscriptionScopePoller provides polling facilities until the operation reaches a terminal state.
type DeploymentsClientValidateAtSubscriptionScopePoller struct {
	pt *azcore.Poller
}

// Done returns true if the LRO has reached a terminal state.
func (p *DeploymentsClientValidateAtSubscriptionScopePoller) Done() bool {
	return p.pt.Done()
}

// Poll fetches the latest state of the LRO.  It returns an HTTP response or error.
// If the LRO has completed successfully, the poller's state is updated and the HTTP
// response is returned.
// If the LRO has completed with failure or was cancelled, the poller's state is
// updated and the error is returned.
// If the LRO has not reached a terminal state, the poller's state is updated and
// the latest HTTP response is returned.
// If Poll fails, the poller's state is unmodified and the error is returned.
// Calling Poll on an LRO that has reached a terminal state will return the final
// HTTP response or error.
func (p *DeploymentsClientValidateAtSubscriptionScopePoller) Poll(ctx context.Context) (*http.Response, error) {
	return p.pt.Poll(ctx)
}

// FinalResponse performs a final GET to the service and returns the final response
// for the polling operation. If there is an error performing the final GET then an error is returned.
// If the final GET succeeded then the final DeploymentsClientValidateAtSubscriptionScopeResponse will be returned.
func (p *DeploymentsClientValidateAtSubscriptionScopePoller) FinalResponse(ctx context.Context) (DeploymentsClientValidateAtSubscriptionScopeResponse, error) {
	respType := DeploymentsClientValidateAtSubscriptionScopeResponse{}
	resp, err := p.pt.FinalResponse(ctx, &respType.DeploymentValidateResult)
	if err != nil {
		return DeploymentsClientValidateAtSubscriptionScopeResponse{}, err
	}
	respType.RawResponse = resp
	return respType, nil
}

// ResumeToken returns a value representing the poller that can be used to resume
// the LRO at a later time. ResumeTokens are unique per service operation.
func (p *DeploymentsClientValidateAtSubscriptionScopePoller) ResumeToken() (string, error) {
	return p.pt.ResumeToken()
}

// DeploymentsClientValidateAtTenantScopePoller provides polling facilities until the operation reaches a terminal state.
type DeploymentsClientValidateAtTenantScopePoller struct {
	pt *azcore.Poller
}

// Done returns true if the LRO has reached a terminal state.
func (p *DeploymentsClientValidateAtTenantScopePoller) Done() bool {
	return p.pt.Done()
}

// Poll fetches the latest state of the LRO.  It returns an HTTP response or error.
// If the LRO has completed successfully, the poller's state is updated and the HTTP
// response is returned.
// If the LRO has completed with failure or was cancelled, the poller's state is
// updated and the error is returned.
// If the LRO has not reached a terminal state, the poller's state is updated and
// the latest HTTP response is returned.
// If Poll fails, the poller's state is unmodified and the error is returned.
// Calling Poll on an LRO that has reached a terminal state will return the final
// HTTP response or error.
func (p *DeploymentsClientValidateAtTenantScopePoller) Poll(ctx context.Context) (*http.Response, error) {
	return p.pt.Poll(ctx)
}

// FinalResponse performs a final GET to the service and returns the final response
// for the polling operation. If there is an error performing the final GET then an error is returned.
// If the final GET succeeded then the final DeploymentsClientValidateAtTenantScopeResponse will be returned.
func (p *DeploymentsClientValidateAtTenantScopePoller) FinalResponse(ctx context.Context) (DeploymentsClientValidateAtTenantScopeResponse, error) {
	respType := DeploymentsClientValidateAtTenantScopeResponse{}
	resp, err := p.pt.FinalResponse(ctx, &respType.DeploymentValidateResult)
	if err != nil {
		return DeploymentsClientValidateAtTenantScopeResponse{}, err
	}
	respType.RawResponse = resp
	return respType, nil
}

// ResumeToken returns a value representing the poller that can be used to resume
// the LRO at a later time. ResumeTokens are unique per service operation.
func (p *DeploymentsClientValidateAtTenantScopePoller) ResumeToken() (string, error) {
	return p.pt.ResumeToken()
}

// DeploymentsClientValidatePoller provides polling facilities until the operation reaches a terminal state.
type DeploymentsClientValidatePoller struct {
	pt *azcore.Poller
}

// Done returns true if the LRO has reached a terminal state.
func (p *DeploymentsClientValidatePoller) Done() bool {
	return p.pt.Done()
}

// Poll fetches the latest state of the LRO.  It returns an HTTP response or error.
// If the LRO has completed successfully, the poller's state is updated and the HTTP
// response is returned.
// If the LRO has completed with failure or was cancelled, the poller's state is
// updated and the error is returned.
// If the LRO has not reached a terminal state, the poller's state is updated and
// the latest HTTP response is returned.
// If Poll fails, the poller's state is unmodified and the error is returned.
// Calling Poll on an LRO that has reached a terminal state will return the final
// HTTP response or error.
func (p *DeploymentsClientValidatePoller) Poll(ctx context.Context) (*http.Response, error) {
	return p.pt.Poll(ctx)
}

// FinalResponse performs a final GET to the service and returns the final response
// for the polling operation. If there is an error performing the final GET then an error is returned.
// If the final GET succeeded then the final DeploymentsClientValidateResponse will be returned.
func (p *DeploymentsClientValidatePoller) FinalResponse(ctx context.Context) (DeploymentsClientValidateResponse, error) {
	respType := DeploymentsClientValidateResponse{}
	resp, err := p.pt.FinalResponse(ctx, &respType.DeploymentValidateResult)
	if err != nil {
		return DeploymentsClientValidateResponse{}, err
	}
	respType.RawResponse = resp
	return respType, nil
}

// ResumeToken returns a value representing the poller that can be used to resume
// the LRO at a later time. ResumeTokens are unique per service operation.
func (p *DeploymentsClientValidatePoller) ResumeToken() (string, error) {
	return p.pt.ResumeToken()
}

// DeploymentsClientWhatIfAtManagementGroupScopePoller provides polling facilities until the operation reaches a terminal state.
type DeploymentsClientWhatIfAtManagementGroupScopePoller struct {
	pt *azcore.Poller
}

// Done returns true if the LRO has reached a terminal state.
func (p *DeploymentsClientWhatIfAtManagementGroupScopePoller) Done() bool {
	return p.pt.Done()
}

// Poll fetches the latest state of the LRO.  It returns an HTTP response or error.
// If the LRO has completed successfully, the poller's state is updated and the HTTP
// response is returned.
// If the LRO has completed with failure or was cancelled, the poller's state is
// updated and the error is returned.
// If the LRO has not reached a terminal state, the poller's state is updated and
// the latest HTTP response is returned.
// If Poll fails, the poller's state is unmodified and the error is returned.
// Calling Poll on an LRO that has reached a terminal state will return the final
// HTTP response or error.
func (p *DeploymentsClientWhatIfAtManagementGroupScopePoller) Poll(ctx context.Context) (*http.Response, error) {
	return p.pt.Poll(ctx)
}

// FinalResponse performs a final GET to the service and returns the final response
// for the polling operation. If there is an error performing the final GET then an error is returned.
// If the final GET succeeded then the final DeploymentsClientWhatIfAtManagementGroupScopeResponse will be returned.
func (p *DeploymentsClientWhatIfAtManagementGroupScopePoller) FinalResponse(ctx context.Context) (DeploymentsClientWhatIfAtManagementGroupScopeResponse, error) {
	respType := DeploymentsClientWhatIfAtManagementGroupScopeResponse{}
	resp, err := p.pt.FinalResponse(ctx, &respType.WhatIfOperationResult)
	if err != nil {
		return DeploymentsClientWhatIfAtManagementGroupScopeResponse{}, err
	}
	respType.RawResponse = resp
	return respType, nil
}

// ResumeToken returns a value representing the poller that can be used to resume
// the LRO at a later time. ResumeTokens are unique per service operation.
func (p *DeploymentsClientWhatIfAtManagementGroupScopePoller) ResumeToken() (string, error) {
	return p.pt.ResumeToken()
}

// DeploymentsClientWhatIfAtSubscriptionScopePoller provides polling facilities until the operation reaches a terminal state.
type DeploymentsClientWhatIfAtSubscriptionScopePoller struct {
	pt *azcore.Poller
}

// Done returns true if the LRO has reached a terminal state.
func (p *DeploymentsClientWhatIfAtSubscriptionScopePoller) Done() bool {
	return p.pt.Done()
}

// Poll fetches the latest state of the LRO.  It returns an HTTP response or error.
// If the LRO has completed successfully, the poller's state is updated and the HTTP
// response is returned.
// If the LRO has completed with failure or was cancelled, the poller's state is
// updated and the error is returned.
// If the LRO has not reached a terminal state, the poller's state is updated and
// the latest HTTP response is returned.
// If Poll fails, the poller's state is unmodified and the error is returned.
// Calling Poll on an LRO that has reached a terminal state will return the final
// HTTP response or error.
func (p *DeploymentsClientWhatIfAtSubscriptionScopePoller) Poll(ctx context.Context) (*http.Response, error) {
	return p.pt.Poll(ctx)
}

// FinalResponse performs a final GET to the service and returns the final response
// for the polling operation. If there is an error performing the final GET then an error is returned.
// If the final GET succeeded then the final DeploymentsClientWhatIfAtSubscriptionScopeResponse will be returned.
func (p *DeploymentsClientWhatIfAtSubscriptionScopePoller) FinalResponse(ctx context.Context) (DeploymentsClientWhatIfAtSubscriptionScopeResponse, error) {
	respType := DeploymentsClientWhatIfAtSubscriptionScopeResponse{}
	resp, err := p.pt.FinalResponse(ctx, &respType.WhatIfOperationResult)
	if err != nil {
		return DeploymentsClientWhatIfAtSubscriptionScopeResponse{}, err
	}
	respType.RawResponse = resp
	return respType, nil
}

// ResumeToken returns a value representing the poller that can be used to resume
// the LRO at a later time. ResumeTokens are unique per service operation.
func (p *DeploymentsClientWhatIfAtSubscriptionScopePoller) ResumeToken() (string, error) {
	return p.pt.ResumeToken()
}

// DeploymentsClientWhatIfAtTenantScopePoller provides polling facilities until the operation reaches a terminal state.
type DeploymentsClientWhatIfAtTenantScopePoller struct {
	pt *azcore.Poller
}

// Done returns true if the LRO has reached a terminal state.
func (p *DeploymentsClientWhatIfAtTenantScopePoller) Done() bool {
	return p.pt.Done()
}

// Poll fetches the latest state of the LRO.  It returns an HTTP response or error.
// If the LRO has completed successfully, the poller's state is updated and the HTTP
// response is returned.
// If the LRO has completed with failure or was cancelled, the poller's state is
// updated and the error is returned.
// If the LRO has not reached a terminal state, the poller's state is updated and
// the latest HTTP response is returned.
// If Poll fails, the poller's state is unmodified and the error is returned.
// Calling Poll on an LRO that has reached a terminal state will return the final
// HTTP response or error.
func (p *DeploymentsClientWhatIfAtTenantScopePoller) Poll(ctx context.Context) (*http.Response, error) {
	return p.pt.Poll(ctx)
}

// FinalResponse performs a final GET to the service and returns the final response
// for the polling operation. If there is an error performing the final GET then an error is returned.
// If the final GET succeeded then the final DeploymentsClientWhatIfAtTenantScopeResponse will be returned.
func (p *DeploymentsClientWhatIfAtTenantScopePoller) FinalResponse(ctx context.Context) (DeploymentsClientWhatIfAtTenantScopeResponse, error) {
	respType := DeploymentsClientWhatIfAtTenantScopeResponse{}
	resp, err := p.pt.FinalResponse(ctx, &respType.WhatIfOperationResult)
	if err != nil {
		return DeploymentsClientWhatIfAtTenantScopeResponse{}, err
	}
	respType.RawResponse = resp
	return respType, nil
}

// ResumeToken returns a value representing the poller that can be used to resume
// the LRO at a later time. ResumeTokens are unique per service operation.
func (p *DeploymentsClientWhatIfAtTenantScopePoller) ResumeToken() (string, error) {
	return p.pt.ResumeToken()
}

// DeploymentsClientWhatIfPoller provides polling facilities until the operation reaches a terminal state.
type DeploymentsClientWhatIfPoller struct {
	pt *azcore.Poller
}

// Done returns true if the LRO has reached a terminal state.
func (p *DeploymentsClientWhatIfPoller) Done() bool {
	return p.pt.Done()
}

// Poll fetches the latest state of the LRO.  It returns an HTTP response or error.
// If the LRO has completed successfully, the poller's state is updated and the HTTP
// response is returned.
// If the LRO has completed with failure or was cancelled, the poller's state is
// updated and the error is returned.
// If the LRO has not reached a terminal state, the poller's state is updated and
// the latest HTTP response is returned.
// If Poll fails, the poller's state is unmodified and the error is returned.
// Calling Poll on an LRO that has reached a terminal state will return the final
// HTTP response or error.
func (p *DeploymentsClientWhatIfPoller) Poll(ctx context.Context) (*http.Response, error) {
	return p.pt.Poll(ctx)
}

// FinalResponse performs a final GET to the service and returns the final response
// for the polling operation. If there is an error performing the final GET then an error is returned.
// If the final GET succeeded then the final DeploymentsClientWhatIfResponse will be returned.
func (p *DeploymentsClientWhatIfPoller) FinalResponse(ctx context.Context) (DeploymentsClientWhatIfResponse, error) {
	respType := DeploymentsClientWhatIfResponse{}
	resp, err := p.pt.FinalResponse(ctx, &respType.WhatIfOperationResult)
	if err != nil {
		return DeploymentsClientWhatIfResponse{}, err
	}
	respType.RawResponse = resp
	return respType, nil
}

// ResumeToken returns a value representing the poller that can be used to resume
// the LRO at a later time. ResumeTokens are unique per service operation.
func (p *DeploymentsClientWhatIfPoller) ResumeToken() (string, error) {
	return p.pt.ResumeToken()
}

// ResourceGroupsClientDeletePoller provides polling facilities until the operation reaches a terminal state.
type ResourceGroupsClientDeletePoller struct {
	pt *azcore.Poller
}

// Done returns true if the LRO has reached a terminal state.
func (p *ResourceGroupsClientDeletePoller) Done() bool {
	return p.pt.Done()
}

// Poll fetches the latest state of the LRO.  It returns an HTTP response or error.
// If the LRO has completed successfully, the poller's state is updated and the HTTP
// response is returned.
// If the LRO has completed with failure or was cancelled, the poller's state is
// updated and the error is returned.
// If the LRO has not reached a terminal state, the poller's state is updated and
// the latest HTTP response is returned.
// If Poll fails, the poller's state is unmodified and the error is returned.
// Calling Poll on an LRO that has reached a terminal state will return the final
// HTTP response or error.
func (p *ResourceGroupsClientDeletePoller) Poll(ctx context.Context) (*http.Response, error) {
	return p.pt.Poll(ctx)
}

// FinalResponse performs a final GET to the service and returns the final response
// for the polling operation. If there is an error performing the final GET then an error is returned.
// If the final GET succeeded then the final ResourceGroupsClientDeleteResponse will be returned.
func (p *ResourceGroupsClientDeletePoller) FinalResponse(ctx context.Context) (ResourceGroupsClientDeleteResponse, error) {
	respType := ResourceGroupsClientDeleteResponse{}
	resp, err := p.pt.FinalResponse(ctx, nil)
	if err != nil {
		return ResourceGroupsClientDeleteResponse{}, err
	}
	respType.RawResponse = resp
	return respType, nil
}

// ResumeToken returns a value representing the poller that can be used to resume
// the LRO at a later time. ResumeTokens are unique per service operation.
func (p *ResourceGroupsClientDeletePoller) ResumeToken() (string, error) {
	return p.pt.ResumeToken()
}

// ResourceGroupsClientExportTemplatePoller provides polling facilities until the operation reaches a terminal state.
type ResourceGroupsClientExportTemplatePoller struct {
	pt *azcore.Poller
}

// Done returns true if the LRO has reached a terminal state.
func (p *ResourceGroupsClientExportTemplatePoller) Done() bool {
	return p.pt.Done()
}

// Poll fetches the latest state of the LRO.  It returns an HTTP response or error.
// If the LRO has completed successfully, the poller's state is updated and the HTTP
// response is returned.
// If the LRO has completed with failure or was cancelled, the poller's state is
// updated and the error is returned.
// If the LRO has not reached a terminal state, the poller's state is updated and
// the latest HTTP response is returned.
// If Poll fails, the poller's state is unmodified and the error is returned.
// Calling Poll on an LRO that has reached a terminal state will return the final
// HTTP response or error.
func (p *ResourceGroupsClientExportTemplatePoller) Poll(ctx context.Context) (*http.Response, error) {
	return p.pt.Poll(ctx)
}

// FinalResponse performs a final GET to the service and returns the final response
// for the polling operation. If there is an error performing the final GET then an error is returned.
// If the final GET succeeded then the final ResourceGroupsClientExportTemplateResponse will be returned.
func (p *ResourceGroupsClientExportTemplatePoller) FinalResponse(ctx context.Context) (ResourceGroupsClientExportTemplateResponse, error) {
	respType := ResourceGroupsClientExportTemplateResponse{}
	resp, err := p.pt.FinalResponse(ctx, &respType.ResourceGroupExportResult)
	if err != nil {
		return ResourceGroupsClientExportTemplateResponse{}, err
	}
	respType.RawResponse = resp
	return respType, nil
}

// ResumeToken returns a value representing the poller that can be used to resume
// the LRO at a later time. ResumeTokens are unique per service operation.
func (p *ResourceGroupsClientExportTemplatePoller) ResumeToken() (string, error) {
	return p.pt.ResumeToken()
}
