// Copyright The OpenTelemetry Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by "pdata/internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pmetric

import (
	"testing"

	"github.com/stretchr/testify/assert"

	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
)

func TestExponentialHistogram_MoveTo(t *testing.T) {
	ms := generateTestExponentialHistogram()
	dest := NewExponentialHistogram()
	ms.MoveTo(dest)
	assert.Equal(t, NewExponentialHistogram(), ms)
	assert.Equal(t, generateTestExponentialHistogram(), dest)
}

func TestExponentialHistogram_CopyTo(t *testing.T) {
	ms := NewExponentialHistogram()
	orig := NewExponentialHistogram()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = generateTestExponentialHistogram()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
}

func TestExponentialHistogram_AggregationTemporality(t *testing.T) {
	ms := NewExponentialHistogram()
	assert.Equal(t, AggregationTemporality(otlpmetrics.AggregationTemporality(0)), ms.AggregationTemporality())
	testValAggregationTemporality := AggregationTemporality(otlpmetrics.AggregationTemporality(1))
	ms.SetAggregationTemporality(testValAggregationTemporality)
	assert.Equal(t, testValAggregationTemporality, ms.AggregationTemporality())
}

func TestExponentialHistogram_DataPoints(t *testing.T) {
	ms := NewExponentialHistogram()
	assert.Equal(t, NewExponentialHistogramDataPointSlice(), ms.DataPoints())
	fillTestExponentialHistogramDataPointSlice(ms.DataPoints())
	assert.Equal(t, generateTestExponentialHistogramDataPointSlice(), ms.DataPoints())
}

func generateTestExponentialHistogram() ExponentialHistogram {
	tv := NewExponentialHistogram()
	fillTestExponentialHistogram(tv)
	return tv
}

func fillTestExponentialHistogram(tv ExponentialHistogram) {
	tv.orig.AggregationTemporality = otlpmetrics.AggregationTemporality(1)
	fillTestExponentialHistogramDataPointSlice(newExponentialHistogramDataPointSlice(&tv.orig.DataPoints))
}
