package datamigrationapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/datamigration/mgmt/2021-10-30-preview/datamigration"
	"github.com/Azure/go-autorest/autorest"
	"github.com/gofrs/uuid"
)

// DatabaseMigrationsSQLMiClientAPI contains the set of methods on the DatabaseMigrationsSQLMiClient type.
type DatabaseMigrationsSQLMiClientAPI interface {
	Cancel(ctx context.Context, resourceGroupName string, managedInstanceName string, targetDbName string, parameters datamigration.MigrationOperationInput) (result datamigration.DatabaseMigrationsSQLMiCancelFuture, err error)
	CreateOrUpdate(ctx context.Context, resourceGroupName string, managedInstanceName string, targetDbName string, parameters datamigration.DatabaseMigrationSQLMi) (result datamigration.DatabaseMigrationsSQLMiCreateOrUpdateFuture, err error)
	Cutover(ctx context.Context, resourceGroupName string, managedInstanceName string, targetDbName string, parameters datamigration.MigrationOperationInput) (result datamigration.DatabaseMigrationsSQLMiCutoverFuture, err error)
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string, targetDbName string, migrationOperationID *uuid.UUID, expand string) (result datamigration.DatabaseMigrationSQLMi, err error)
}

var _ DatabaseMigrationsSQLMiClientAPI = (*datamigration.DatabaseMigrationsSQLMiClient)(nil)

// DatabaseMigrationsSQLVMClientAPI contains the set of methods on the DatabaseMigrationsSQLVMClient type.
type DatabaseMigrationsSQLVMClientAPI interface {
	Cancel(ctx context.Context, resourceGroupName string, SQLVirtualMachineName string, targetDbName string, parameters datamigration.MigrationOperationInput) (result datamigration.DatabaseMigrationsSQLVMCancelFuture, err error)
	CreateOrUpdate(ctx context.Context, resourceGroupName string, SQLVirtualMachineName string, targetDbName string, parameters datamigration.DatabaseMigrationSQLVM) (result datamigration.DatabaseMigrationsSQLVMCreateOrUpdateFuture, err error)
	Cutover(ctx context.Context, resourceGroupName string, SQLVirtualMachineName string, targetDbName string, parameters datamigration.MigrationOperationInput) (result datamigration.DatabaseMigrationsSQLVMCutoverFuture, err error)
	Get(ctx context.Context, resourceGroupName string, SQLVirtualMachineName string, targetDbName string, migrationOperationID *uuid.UUID, expand string) (result datamigration.DatabaseMigrationSQLVM, err error)
}

var _ DatabaseMigrationsSQLVMClientAPI = (*datamigration.DatabaseMigrationsSQLVMClient)(nil)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result datamigration.OperationListResultPage, err error)
	ListComplete(ctx context.Context) (result datamigration.OperationListResultIterator, err error)
}

var _ OperationsClientAPI = (*datamigration.OperationsClient)(nil)

// SQLMigrationServicesClientAPI contains the set of methods on the SQLMigrationServicesClient type.
type SQLMigrationServicesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, SQLMigrationServiceName string, parameters datamigration.SQLMigrationService) (result datamigration.SQLMigrationServicesCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, SQLMigrationServiceName string) (result datamigration.SQLMigrationServicesDeleteFuture, err error)
	DeleteNodeMethod(ctx context.Context, resourceGroupName string, SQLMigrationServiceName string, parameters datamigration.DeleteNode) (result datamigration.DeleteNode, err error)
	Get(ctx context.Context, resourceGroupName string, SQLMigrationServiceName string) (result datamigration.SQLMigrationService, err error)
	ListAuthKeys(ctx context.Context, resourceGroupName string, SQLMigrationServiceName string) (result datamigration.AuthenticationKeys, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result datamigration.SQLMigrationListResultPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result datamigration.SQLMigrationListResultIterator, err error)
	ListBySubscription(ctx context.Context) (result datamigration.SQLMigrationListResultPage, err error)
	ListBySubscriptionComplete(ctx context.Context) (result datamigration.SQLMigrationListResultIterator, err error)
	ListMigrations(ctx context.Context, resourceGroupName string, SQLMigrationServiceName string) (result datamigration.DatabaseMigrationListResultPage, err error)
	ListMigrationsComplete(ctx context.Context, resourceGroupName string, SQLMigrationServiceName string) (result datamigration.DatabaseMigrationListResultIterator, err error)
	ListMonitoringData(ctx context.Context, resourceGroupName string, SQLMigrationServiceName string) (result datamigration.IntegrationRuntimeMonitoringData, err error)
	RegenerateAuthKeys(ctx context.Context, resourceGroupName string, SQLMigrationServiceName string, parameters datamigration.RegenAuthKeys) (result datamigration.RegenAuthKeys, err error)
	Update(ctx context.Context, resourceGroupName string, SQLMigrationServiceName string, parameters datamigration.SQLMigrationServiceUpdate) (result datamigration.SQLMigrationServicesUpdateFuture, err error)
}

var _ SQLMigrationServicesClientAPI = (*datamigration.SQLMigrationServicesClient)(nil)

// ResourceSkusClientAPI contains the set of methods on the ResourceSkusClient type.
type ResourceSkusClientAPI interface {
	ListSkus(ctx context.Context) (result datamigration.ResourceSkusResultPage, err error)
	ListSkusComplete(ctx context.Context) (result datamigration.ResourceSkusResultIterator, err error)
}

var _ ResourceSkusClientAPI = (*datamigration.ResourceSkusClient)(nil)

// ServicesClientAPI contains the set of methods on the ServicesClient type.
type ServicesClientAPI interface {
	CheckChildrenNameAvailability(ctx context.Context, groupName string, serviceName string, parameters datamigration.NameAvailabilityRequest) (result datamigration.NameAvailabilityResponse, err error)
	CheckNameAvailability(ctx context.Context, location string, parameters datamigration.NameAvailabilityRequest) (result datamigration.NameAvailabilityResponse, err error)
	CheckStatus(ctx context.Context, groupName string, serviceName string) (result datamigration.ServiceStatusResponse, err error)
	CreateOrUpdate(ctx context.Context, parameters datamigration.Service, groupName string, serviceName string) (result datamigration.ServicesCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, groupName string, serviceName string, deleteRunningTasks *bool) (result datamigration.ServicesDeleteFuture, err error)
	Get(ctx context.Context, groupName string, serviceName string) (result datamigration.Service, err error)
	List(ctx context.Context) (result datamigration.ServiceListPage, err error)
	ListComplete(ctx context.Context) (result datamigration.ServiceListIterator, err error)
	ListByResourceGroup(ctx context.Context, groupName string) (result datamigration.ServiceListPage, err error)
	ListByResourceGroupComplete(ctx context.Context, groupName string) (result datamigration.ServiceListIterator, err error)
	ListSkus(ctx context.Context, groupName string, serviceName string) (result datamigration.ServiceSkuListPage, err error)
	ListSkusComplete(ctx context.Context, groupName string, serviceName string) (result datamigration.ServiceSkuListIterator, err error)
	Start(ctx context.Context, groupName string, serviceName string) (result datamigration.ServicesStartFuture, err error)
	Stop(ctx context.Context, groupName string, serviceName string) (result datamigration.ServicesStopFuture, err error)
	Update(ctx context.Context, parameters datamigration.Service, groupName string, serviceName string) (result datamigration.ServicesUpdateFuture, err error)
}

var _ ServicesClientAPI = (*datamigration.ServicesClient)(nil)

// TasksClientAPI contains the set of methods on the TasksClient type.
type TasksClientAPI interface {
	Cancel(ctx context.Context, groupName string, serviceName string, projectName string, taskName string) (result datamigration.ProjectTask, err error)
	Command(ctx context.Context, groupName string, serviceName string, projectName string, taskName string, parameters datamigration.BasicCommandProperties) (result datamigration.CommandPropertiesModel, err error)
	CreateOrUpdate(ctx context.Context, parameters datamigration.ProjectTask, groupName string, serviceName string, projectName string, taskName string) (result datamigration.ProjectTask, err error)
	Delete(ctx context.Context, groupName string, serviceName string, projectName string, taskName string, deleteRunningTasks *bool) (result autorest.Response, err error)
	Get(ctx context.Context, groupName string, serviceName string, projectName string, taskName string, expand string) (result datamigration.ProjectTask, err error)
	List(ctx context.Context, groupName string, serviceName string, projectName string, taskType string) (result datamigration.TaskListPage, err error)
	ListComplete(ctx context.Context, groupName string, serviceName string, projectName string, taskType string) (result datamigration.TaskListIterator, err error)
	Update(ctx context.Context, parameters datamigration.ProjectTask, groupName string, serviceName string, projectName string, taskName string) (result datamigration.ProjectTask, err error)
}

var _ TasksClientAPI = (*datamigration.TasksClient)(nil)

// ServiceTasksClientAPI contains the set of methods on the ServiceTasksClient type.
type ServiceTasksClientAPI interface {
	Cancel(ctx context.Context, groupName string, serviceName string, taskName string) (result datamigration.ProjectTask, err error)
	CreateOrUpdate(ctx context.Context, parameters datamigration.ProjectTask, groupName string, serviceName string, taskName string) (result datamigration.ProjectTask, err error)
	Delete(ctx context.Context, groupName string, serviceName string, taskName string, deleteRunningTasks *bool) (result autorest.Response, err error)
	Get(ctx context.Context, groupName string, serviceName string, taskName string, expand string) (result datamigration.ProjectTask, err error)
	List(ctx context.Context, groupName string, serviceName string, taskType string) (result datamigration.TaskListPage, err error)
	ListComplete(ctx context.Context, groupName string, serviceName string, taskType string) (result datamigration.TaskListIterator, err error)
	Update(ctx context.Context, parameters datamigration.ProjectTask, groupName string, serviceName string, taskName string) (result datamigration.ProjectTask, err error)
}

var _ ServiceTasksClientAPI = (*datamigration.ServiceTasksClient)(nil)

// ProjectsClientAPI contains the set of methods on the ProjectsClient type.
type ProjectsClientAPI interface {
	CreateOrUpdate(ctx context.Context, parameters datamigration.Project, groupName string, serviceName string, projectName string) (result datamigration.Project, err error)
	Delete(ctx context.Context, groupName string, serviceName string, projectName string, deleteRunningTasks *bool) (result autorest.Response, err error)
	Get(ctx context.Context, groupName string, serviceName string, projectName string) (result datamigration.Project, err error)
	List(ctx context.Context, groupName string, serviceName string) (result datamigration.ProjectListPage, err error)
	ListComplete(ctx context.Context, groupName string, serviceName string) (result datamigration.ProjectListIterator, err error)
	Update(ctx context.Context, parameters datamigration.Project, groupName string, serviceName string, projectName string) (result datamigration.Project, err error)
}

var _ ProjectsClientAPI = (*datamigration.ProjectsClient)(nil)

// UsagesClientAPI contains the set of methods on the UsagesClient type.
type UsagesClientAPI interface {
	List(ctx context.Context, location string) (result datamigration.QuotaListPage, err error)
	ListComplete(ctx context.Context, location string) (result datamigration.QuotaListIterator, err error)
}

var _ UsagesClientAPI = (*datamigration.UsagesClient)(nil)

// FilesClientAPI contains the set of methods on the FilesClient type.
type FilesClientAPI interface {
	CreateOrUpdate(ctx context.Context, parameters datamigration.ProjectFile, groupName string, serviceName string, projectName string, fileName string) (result datamigration.ProjectFile, err error)
	Delete(ctx context.Context, groupName string, serviceName string, projectName string, fileName string) (result autorest.Response, err error)
	Get(ctx context.Context, groupName string, serviceName string, projectName string, fileName string) (result datamigration.ProjectFile, err error)
	List(ctx context.Context, groupName string, serviceName string, projectName string) (result datamigration.FileListPage, err error)
	ListComplete(ctx context.Context, groupName string, serviceName string, projectName string) (result datamigration.FileListIterator, err error)
	Read(ctx context.Context, groupName string, serviceName string, projectName string, fileName string) (result datamigration.FileStorageInfo, err error)
	ReadWrite(ctx context.Context, groupName string, serviceName string, projectName string, fileName string) (result datamigration.FileStorageInfo, err error)
	Update(ctx context.Context, parameters datamigration.ProjectFile, groupName string, serviceName string, projectName string, fileName string) (result datamigration.ProjectFile, err error)
}

var _ FilesClientAPI = (*datamigration.FilesClient)(nil)
