/*
  Copyright (C) 2004-2005 Tommi Tervonen, Petteri Klemola, Pasi Orovuo

  This file is part of Kajaani Kombat.

  Kajaani Kombat is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  Kajaani Kombat is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with Kajaani Kombat; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __MOSAIC_H
#define __MOSAIC_H

#include "SDL.h"
#include <math.h>

static const int bsizes[] = {
  2,
  4,
  5,
  8,
  10,
  16,
  20,
  32,
  40
};

/**
 * Class for Super Mario World style screen mosaic.
 *
 * \author Petteri Klemola <kk@medusa.tutka.net>
 */
class mosaic
{
 public:
   /**
    * Constructor.
    */
   mosaic(SDL_Surface *_surf, SDL_Surface *_dest, Uint32 stime,bool _reverse);
   ~mosaic();
   
   void update(Uint32 ctime);
   bool is_finished();
  
 protected:
   SDL_Surface *surf, *orginal, *dest;
   
   int blocksize;
   bool finished, reverse;
   Uint32 start_time, o_time;
   

   /**
    * Performs mosaic for for surface
    */
   void draw_mosaic();
   
};

#endif
