/*
  Copyright (C) 2004-2005 Tommi Tervonen, Petteri Klemola, Pasi Orovuo

  This file is part of Kajaani Kombat.

  Kajaani Kombat is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  Kajaani Kombat is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with Kajaani Kombat; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "gfx_functions.h"

SDL_Surface *copy_surface (SDL_Surface *surf)
{
  return SDL_CreateRGBSurface (SDL_SWSURFACE, surf->w, surf->h, surf->format->BitsPerPixel, 
							   surf->format->Rmask, surf->format->Gmask, 
							   surf->format->Bmask, surf->format->Amask);
}

SDL_Surface *deep_copy_surface (SDL_Surface *surf)
{
  SDL_Surface *d = copy_surface(surf);
  
  SDL_BlitSurface (surf, NULL, d, NULL);

  return d;
}

SDL_Rect draw_text (SDL_Surface *dst, TTF_Font *font, const char *text, const coord &c)
{
  SDL_Color col;
  col.r = 0xff;
  col.g = 0xff;
  col.b = 0xff;
  return draw_text (dst, font, text, c, col);
}

SDL_Rect draw_text (SDL_Surface *dst, TTF_Font *font, const char *text, const coord &c, SDL_Color &col)
{
  SDL_Rect r;
  r.x = c.getPX();
  r.y = c.getPY();
  SDL_Surface *surf = TTF_RenderText_Blended (font, text,col);
  if (surf == NULL)
    {
      fprintf (stderr, "Error rendering font: %s\n", TTF_GetError());
      exit(1);
    }
      
  r.w = surf->w;
  r.h = surf->h;
  SDL_BlitSurface (surf, NULL, dst, &r);
  SDL_FreeSurface (surf);
  return r;
}

SDL_Rect draw_text_centered (SDL_Surface *dst, TTF_Font *font, const char *text, const coord &c)
{
  SDL_Color col;
  col.r = 0xff;
  col.g = 0xff;
  col.b = 0xff;
  return draw_text_centered (dst, font, text, c, col);
}
SDL_Rect draw_text_baseline (SDL_Surface *dst, TTF_Font *font, const char *text, const coord &c)
{
  SDL_Color col;
  col.r = 0xff;
  col.g = 0xff;
  col.b = 0xff;
  return draw_text_baseline (dst, font, text, c, col);
}


SDL_Rect draw_text_baseline (SDL_Surface *dst, TTF_Font *font, const char *text, const coord &c, SDL_Color &col)
{
  SDL_Rect r;
  r.x = c.getPX();
  r.y = c.getPY();
  SDL_Surface *surf = TTF_RenderText_Blended (font, text,col);
  if (surf == NULL)
    {
      fprintf (stderr, "Error rendering text: %s\n", TTF_GetError());
      exit(1);
    }
  r.w = surf->w;
  r.h = surf->h;
  r.y -= r.h;
  SDL_BlitSurface (surf, NULL, dst, &r);
  //  printf ("text %s to %d %d\n", text, r.x, r.y);
  SDL_FreeSurface (surf);
  return r;
}

SDL_Rect draw_text_baseline_centered (SDL_Surface *dst, TTF_Font *font, const char *text, const coord &c, SDL_Color &col)
{
  SDL_Rect r;
  r.x = c.getPX();
  r.y = c.getPY();
  SDL_Surface *surf = TTF_RenderText_Blended (font, text,col);
  if (surf == NULL)
    {
      fprintf (stderr, "Error rendering text: %s\n", TTF_GetError());
      exit(1);
    }
  r.w = surf->w;
  r.h = surf->h;
  r.y -= r.h;
  r.x -= r.w / 2;

  SDL_BlitSurface (surf, NULL, dst, &r);
  //  printf ("text %s to %d %d\n", text, r.x, r.y);
  SDL_FreeSurface (surf);
  return r;
}

SDL_Rect draw_text_centered (SDL_Surface *dst, TTF_Font *font, const char *text, const coord &c, SDL_Color &col)
{
  SDL_Rect r;
  r.x = c.getPX();
  r.y = c.getPY();
  SDL_Surface *surf = TTF_RenderText_Blended (font, text,col);
  if (surf == NULL)
    {
      fprintf (stderr, "Error rendering text: %s\n", TTF_GetError());
      exit(1);
    }
  r.w = surf->w;
  r.h = surf->h;
  r.y -= r.h / 2;
  r.x -= r.w / 2;
  SDL_BlitSurface (surf, NULL, dst, &r);
  //  printf ("text %s to %d %d\n", text, r.x, r.y);
  SDL_FreeSurface (surf);
  return r;
}
void draw_hline (SDL_Surface *dst, const coord &spos, const coord &dpos, Uint32 col)
{
  int x1 = spos.getPX();
  int y1 = spos.getPY();
  int x2 = dpos.getPX();
  int y2 = dpos.getPY();

  assert (y1 == y2);

  Uint32 *pix = (Uint32 *)dst->pixels;
  pix += (x1 + y1 * dst->w);
  for (;x1<=x2;x1++,pix++)
    *pix = col;
}

void draw_vline (SDL_Surface *dst, const coord &spos, const coord &dpos, Uint32 col)
{
  int x1 = spos.getPX();
  int y1 = spos.getPY();
  int x2 = dpos.getPX();
  int y2 = dpos.getPY();

  assert (x1 == x2);

  Uint32 *pix = (Uint32 *)dst->pixels;
  int inc = dst->w;
  pix += (x1 + y1 * dst->w);
  for (;y1<=y2;y1++,pix+=inc)
    *pix = col;
}

void draw_rectangle (SDL_Surface *dst, const coord &spos, const coord &dpos, Uint32 col)
{
  // right upper corner
  coord ruc = coord::pc(dpos.getPX(), spos.getPY());
  // left lower corner
  coord llc = coord::pc(spos.getPX(), dpos.getPY());

  draw_hline(dst, spos, ruc, col);
  draw_vline(dst, ruc, dpos, col);

  draw_hline(dst, llc, dpos, col);
  draw_vline(dst, spos, llc, col);

}

SDL_Surface *img_load (const char *fname)
{
  string buffer = string(MEDIA_PATH);
  buffer += fname;

  return IMG_Load(buffer.c_str());
}

TTF_Font *font_load (const char *fname, int size)
{
  string buf = string(MEDIA_PATH);
  buf += fname;

  // first try to open it, if it doesnt exist we can't try to ttf_openfont
  FILE *fp = fopen(buf.c_str(), "r");
  if (fp == NULL)
    return NULL;
  fclose(fp);
  return TTF_OpenFont(buf.c_str(), size);
}

void pix_compext (Uint32 pix, int &r, int &g, int &b, int &a)
{
  a = pix >> 24;
  r = (pix & 0xFF0000) >> 16;
  g = (pix & 0xFF00) >> 8;
  b = pix & 0xFF;
}
