/*
  Copyright (C) 2004-2005 Tommi Tervonen, Petteri Klemola, Pasi Orovuo

  This file is part of Kajaani Kombat.

  Kajaani Kombat is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  Kajaani Kombat is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with Kajaani Kombat; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __GFX_H
#define __GFX_H

#include "SDL.h"
#include "SDL_image.h"
#include <string>
#include <vector>
#include <typeinfo>
#include "terrain.h"
#include "coord.h"
#include "game_obj.h"
#include "SDL.h"
#include "SDL_ttf.h"
#include "rotozoom.h"
#include "particle_efects.h"
#include "animation.h"
#include "globals.h"
#include "gfx_functions.h"
#include "player.h"
#include "game_statistic.h"

#define BG_IMAGE "bg.png"

#define NUM_TILES 17
#define NUM_TILEPACKS 5

#define SCR_BPP 32

#define BAR_LINE_COL 0xFFFF00FF
#define BAR_HEIGHT 20


class gfx
{
 public:
  static const char* const tile_files[][NUM_TILES];

  gfx(SDL_Surface *screen, TTF_Font *font);
  ~gfx();

  void draw_bg (terrain *t, player *players);
  void update_bg (terrain *t, player *players,bool keep_castlegfx = false, bool keep_cannongfx = false);

  void update();
  void draw_cursors(coord *curs, int max_players, bool *lock, int num_cannons, int player_index, player *players);
  void draw_blockplacers (block *bp, int max_players, player *players);
  void draw_characterchoosers(coord *centers, player *players, int max_num, bool* lock);
  void draw_castlechoosers(coord *centers, player *players, int max_num);
  void draw_cannonplacers (terrain* t, coord* c, int num_pl, player *players, int* c_size);
  void draw_centered_to_tile (SDL_Surface *surf, SDL_Surface *dsurf, coord &c);
  void draw_centered_to_pixel (SDL_Surface *surf, const coord &c);
  void draw_tile (SDL_Surface *surf, SDL_Surface *dest_surf, coord &c);
  void draw_intro (coord &c, int kulma, const char* names[], int players);
  void draw_characters(int maxplayers);
  void clear_updates(terrain *t);
  void draw_objects (vector<game_obj *> &objs, player *players);
  void draw_objects (vector<game_obj *> &objs);//this one is used only in gui.cpp line 112. use the other one normally. Fix this later!
  void draw_bar(float tleft, const char *modestr); 
  void draw_animation (anim_explosion_obj &a);
  void draw_castle_ownertext(player &pl, const coord &c);

  void draw_player_statistics(player * players, vector<player_statistic*> *stats, const coord &from);

  void set_bg_fademask(bool towhite, double intensity);
  void unset_bg_fademask();

  void draw_talkmode(bool talk, string txt, player &talker);

  void draw_hud (int n1, int n2, const coord &c);

  void draw_fadebox(double intensity, SDL_Rect *r, SDL_Surface *s);

  SDL_Surface* get_tileimage (int pindex, int index)
	{ return tiles[pindex][index]; }

  // tilet
  enum tiles {
	TILEINDEX_CASTLE = 0,
	TILEINDEX_WALL,
	TILEINDEX_CANNON,
	TILEINDEX_BIG_CANNON,
	TILEINDEX_CONQGRASS,
	TILEINDEX_AMMO,
	TILEINDEX_BIG_AMMO,
	TILEINDEX_BLOCKPLACER,
	TILEINDEX_CANNONPLACER,
	TILEINDEX_BIG_CANNONPLACER,
	TILEINDEX_CHOOSER,
	TILEINDEX_CURSOR,
	TILEINDEX_CANNON_DEST,
	TILEINDEX_BIG_CANNON_DEST,
	TILEINDEX_CURSOR_LOCK,
	TILEINDEX_FACE,
	TILEINDEX_CURSOR_CH
  };

 protected:
  SDL_Surface* tiles[NUM_TILEPACKS][NUM_TILES];
  SDL_Surface* screen;
  SDL_Surface* bg_image;
  SDL_Surface* play_bg;
  TTF_Font *font;
  lookup *lut;
  exp_anim_container *exp_anims;
  ammo_anim_container *ammo_anims;
  ammo_anim_container *big_ammo_anims;

  bool fademask;
  bool fademask_towhite;
  double fademask_intensity;

  void draw_fademask(SDL_Surface *to);

};


#endif
