#include "connects.h"

connects::connects()
{
  ready_to_change = false;
}

connects::~connects()
{
}

bool connects::includes_player(int pindex)
{
  for (unsigned int i=0;i<pindices.size();i++)
    if (pindices[i] == pindex) return true;
  return false;
}

void connects::remove_player(int pindex)
{
  vector<int>::iterator it = pindices.begin();
  while (it != pindices.end())
    {
      int i = *it;
      if (i == pindex)
	{
	  pindices.erase(it);
	  return;
	}
      it++;
    }
  assert(0);
}

int connects::num_players() const
{
  return pindices.size();
}

const vector<int> & connects::get_player_indices()
{
  return pindices;
}


void connects::set_ready(bool read)
{
  ready_to_change = read;
}

bool connects::is_ready() const
{
  return ready_to_change; 
}

void connects::add_player(int pind)
{
  pindices.push_back(pind);
}

tcp_connects::tcp_connects(TCPsocket s) throw (string &)
{
  sockset = SDLNet_AllocSocketSet (1);
  if (!sockset)
    throw string ("Error initializing socket set: ") + string(SDLNet_GetError());
  sock = s;

  int ret = SDLNet_TCP_AddSocket(sockset, s);
  assert (ret != -1);
}

tcp_connects::tcp_connects(const tcp_connects &c)
{
  sock = c.sock;
  sockset = c.sockset;
  ready_to_change = c.ready_to_change;
  pindices = c.pindices;
}

tcp_connects::~tcp_connects()
{
  SDLNet_TCP_Close(sock);
  SDLNet_TCP_DelSocket(sockset, sock);
  SDLNet_FreeSocketSet(sockset);
}

void tcp_connects::send (msg *m) throw (string &)
{
  m->send(sock);
}

bool tcp_connects::has_msgs() const throw (string &)
{
  int nready = SDLNet_CheckSockets(sockset, 0);
  if (nready == -1)
    {
      fprintf (stderr, "Error %s\n", SDLNet_GetError());
      perror("SDLNet_CheckSockets");
    }
  return (nready > 0);
}

msg *tcp_connects::receive() throw (string &)
{
  if (SDLNet_SocketReady(sock))
    return msg::recv (sock);
  assert(0); // should never get here
  return NULL;
}

local_connects::local_connects(monitor_queue<msg *> *_in, monitor_queue<msg *> *_out) throw (string &)
{
  in = _in;
  out = _out;
}

void local_connects::send(msg *m) throw (string &)
{
  out->push(m->deep_copy());
}

bool local_connects::has_msgs() const throw (string &)
{
  return (!in->empty());
}

msg *local_connects::receive() throw (string &)
{
  return in->pop();
}

local_connects::~local_connects()
{

}
