/*
  Copyright (C) 2004-2005 Tommi Tervonen, Petteri Klemola, Pasi Orovuo

  This file is part of Kajaani Kombat.

  Kajaani Kombat is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  Kajaani Kombat is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with Kajaani Kombat; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "block.h"

block::block (const coord &_center)
{
  center = _center;
  type = block_type(rand() % NUM_BLOCK_TYPES);
  fill_block();
  orientation = 0;
  int r = rand() % 4;
  for (int ii=0;ii<r;ii++)
    rotate();
}

block::block ()
{
  orientation = 0;
  center = coord::tc(-1,-1);
  type = block_type(rand() % NUM_BLOCK_TYPES);
  fill_block();
  int r = rand() % 4;
  for (int ii=0;ii<r;ii++)
    rotate();
}

block::block (const coord &_center, block_type _type)
{
  center = _center;
  type = _type;
  orientation = 0;
  fill_block();
  int r = rand() % 4;
  for (int ii=0;ii<r;ii++)
    rotate();
}

block::block (const coord &_center, block_type _type, int _orient)
{
  center = _center;
  type = _type;
  fill_block();

  orientation = 0;
  for (int i=0;i<_orient;i++)
	rotate();
}


void block::fill_block()
{
  tiles.clear();
  orientation = 0;
  switch (type)
	{
	case TYPE_SINGLE:
	  tiles.push_back (coord::tc(0,0));
	  break;
	case TYPE_L:
	  tiles.push_back (coord::tc(0,0));
	  tiles.push_back (coord::tc(1,0));
	  tiles.push_back (coord::tc(-1, 0));
	  tiles.push_back (coord::tc(-1, -1));
	  break;
	case TYPE_U:
	  tiles.push_back (coord::tc (0, 0));
	  tiles.push_back (coord::tc (-1,0));
	  tiles.push_back (coord::tc (1,0));
	  tiles.push_back (coord::tc (-1,-1));
	  tiles.push_back (coord::tc (1,-1));
	  break;
	case TYPE_CORNER:
	  tiles.push_back (coord::tc (0, 0));
	  tiles.push_back (coord::tc (1,0));
	  tiles.push_back (coord::tc (0,-1));
	  break;
	case TYPE_CROSS:
	  tiles.push_back (coord::tc (0, 0));
	  tiles.push_back (coord::tc (1,0));
	  tiles.push_back (coord::tc (0,-1));
	  tiles.push_back (coord::tc (-1,0));
	  tiles.push_back (coord::tc (0, 1));
	  break;
	case TYPE_I:
	  tiles.push_back (coord::tc(0,0));
	  tiles.push_back (coord::tc(1,0));
	  tiles.push_back (coord::tc(-1,0));
	  break;
	case TYPE_E:
	  tiles.push_back( coord::tc( 0, 0 ) );
	  tiles.push_back( coord::tc( 1, 0 ) );
	  tiles.push_back( coord::tc( -1, 0 ) );
	  tiles.push_back( coord::tc( 0, -1 ) );
	  break;
	  /*	case TYPE_Z:
	  tiles.push_back( coord( 0, 0 ) );
	  tiles.push_back( coord( 1, 0 ) );
	  tiles.push_back( coord( 2, 0 ) );
	  tiles.push_back( coord( 0, -1 ) );
	  tiles.push_back( coord( -1, -1 ) );
	  tiles.push_back( coord( -2, -1 ) );
	  break;
	  */
	}
}

void block::rotate()
{
  vector<coord>::iterator it = tiles.begin();

  orientation++;
  if (orientation >= 4)
	orientation = 0;

  while (it != tiles.end())
	{
	  coord &c = *it++;

	  // this might be better done with affine transformations with lookup tables. dunno.
	  if (c.getTX() > 0)
		{
		  if (c.getTY() < 0)
			c.setTY(0-c.getTY());
		  else if (c.getTY() > 0)
			c.setTX(0-c.getTX());
		  else
			{ c.setTY(c.getTX()); c.setTX(0); }
		}
	  else if (c.getTX() < 0)
		{
		  if (c.getTY() < 0)
			c.setTX(0-c.getTX());
		  else if (c.getTY() > 0)
			c.setTY(0-c.getTY());
		  else
			{ c.setTY(c.getTX()); c.setTX(0); }
		}
	  else // c.x = 0
		{
		  if (c.getTY() < 0 || c.getTY() > 0)
		    {
		      c.setTX(0-c.getTY()); 
		      c.setTY(0);
		    }
		  // else a center-block. no need to rotate.
		}
	  int d1 = center.getTX() + c.getTX();
	  if (d1 < 0) center.setTX(center.getTX()-d1);

	  d1 = center.getTX() + c.getTX();
	  if (d1 >= XTILES) center.setTX(center.getTX() - (d1 - XTILES)-1);

	  d1 = center.getTY() + c.getTY();
	  if (d1 < 0) center.setTY(center.getTY()-d1);

	  d1 = center.getTY() + c.getTY();
	  if (d1 >= YTILES) center.setTY(center.getTY() - (d1 - YTILES)-1);
	    
	}
  
}

void block::set_type (int _type)
{
  type = block_type(_type); 
  fill_block();
}

void block::set_orientation(int ori)
{
  while (orientation != ori)
    rotate();
}

bool block::move (const coord &dir)
{
  vector<coord>::iterator it = tiles.begin();

  while (it != tiles.end())
    {
      coord newtil = center + dir + (*it);

      it++;

      if (newtil.getTX() < 0 ||
	  newtil.getTY() < 0 ||
	  newtil.getTX() >= XTILES ||
	  newtil.getTY() >= YTILES) return false;
    }
  center += dir;
  return true;
}
