# Part of the StreamDVD project
package StreamDVD::Defs;

use strict;
use vars qw($VERSION @ISA @EXPORT);

require Exporter;
@ISA = qw(Exporter);


# this stuff is always exported
@EXPORT = qw(
                  PROG_NAME
                  PROG_VERSION
                  PROJECT_NAME
                  PREVIEW_FRAMES
                  FACTOR_DIFF
                  DVD_SIZE_BYTES
                  DVD_SIZE_MB
                  DVD_SIZE_GB
                  CONFIG_FILE
                  DIR_DVD
                  DIR_ISO
                  ID_VIDEO
                  ID_AUDIO
                  ID_SUBTITLE
                  STATE_NEW
                  STATE_READ
                  STATE_BUILD
                  STATE_BURN
                  STATE_COMPLETE
);

$VERSION = "0.1";


# some values
use constant PROG_NAME           => "StreamDVD Gui";            # program name
use constant PROG_VERSION        => "0.1";                      # program version number
use constant PROJECT_NAME        => "Unnamed";                  # default project name
use constant PREVIEW_FRAMES      => "24-25";                    # frame num. used for chapter previews
use constant FACTOR_DIFF         => 0.05;                       # factor calc. correction

# dvd stuff
use constant DVD_SIZE_BYTES      => 4707319808;                 # dvd store size in bytes
use constant DVD_SIZE_KB         => 4596992;                    # dvd store size in KB
use constant DVD_SIZE_MB         => 4489.25;                    # dvd store size in MB
use constant DVD_SIZE_GB         => 4.38;                       # dvd store size in GB

# files and directories
use constant CONFIG_FILE         => $ENV{HOME}."/.streamdvdrc"; # configuration file
use constant DIR_DVD             => "/dvd";                     # directory to store new dvd structure
use constant DIR_ISO             => "/iso";                     # directory to store dvd iso image

# stream id values
use constant ID_VIDEO            => "0xe0";                     # video stream id
use constant ID_AUDIO            => "0x8";                      # generic audio stream id
use constant ID_SUBTITLE         => "0x2";                      # generic subtitle stream id

# runtime condition flags
use constant STATE_NEW           => 1;
use constant STATE_READ          => 2;
use constant STATE_BUILD         => 3;
use constant STATE_BURN          => 4;
use constant STATE_COMPLETE      => 5;


1;

