#include "wmxkb.h"


#include <X11/Xutil.h>
#include <X11/Xresource.h>


#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include "datadir.h"

//#if HAVE_LIMITS_H
//#include <limits.h>
//#endif



#define GlobalResDir "/usr/lib/X11/app-defaults"

#define ResFileName "WMxkb"
const char *ResClassName = "WMxkb";
const char *ResModuleName = "wmxkb";

#ifndef PATH_MAX
// For GNU this is 4096
#define PATH_MAX 1024
#endif

#if WITH_IMAGE
int ImageMode;
char *ImageDir;
char *ImageFileName;
//char ImageDir[PATH_MAX];
//char FileName[128];
#endif

#if HAVE_XSHAPES
Bool UseShapes;
#endif

extern Display *disp;
extern Colormap cmap;
extern int screen;

GeometryInfo WndGeometry, TextGeometry;

Bool Transient;
Bool IconTitle;
int WndMode;
char *DispName;

#if HAVE_XINPUT
//char *KbdDevName = NULL;
int KbdDevOrder;
#endif

unsigned long BgColours[StoredGroupCount];
unsigned long FgColours[StoredGroupCount];
unsigned long FrColours[StoredGroupCount];

FunctionKey GroupSetKeys[StoredGroupCount];
FunctionKey GroupLatchKeys[StoredGroupCount];

FunctionKey GroupSwitchKeys[2];


XFontStruct *GroupFonts[StoredGroupCount];
char *CustomNames[StoredGroupCount];
char *GroupScripts[StoredGroupCount];
char *GroupCodes[StoredGroupCount];

int GroupTitleSource;
Bool FlexyGroups;

int  BgColourCount, FgColourCount, FrColourCount;
int  GroupFontCount;
int  GroupScriptCount, GroupCodeCount;
int  SetKeyCount, LatchKeyCount, SwitchKeyCount;

static Bool saveMode;


static const XrmOptionDescRec NonStoredOptTable[] =
{
	{"-display",  "display",  XrmoptionSepArg,  (XPointer)NULL },
	{"-help",     "help",     XrmoptionNoArg,  (XPointer)"1" },
	{"-save",     "save",     XrmoptionNoArg,  (XPointer)"1" }
};
static const int NonStoredOptCount = sizeof(NonStoredOptTable) / sizeof(XrmOptionDescRec);

static const XrmOptionDescRec ShortOptTable[] =
{
	{"-names",    "name",     XrmoptionSepArg,  (XPointer)NULL },
	{"-codes",     "code",     XrmoptionSepArg,  (XPointer)NULL },
	{"-fgcol",    "fgcol",    XrmoptionSepArg,  (XPointer)NULL },
	{"-bgcol",    "bgcol",    XrmoptionSepArg,  (XPointer)NULL },
	{"-frcol",    "frcol",    XrmoptionSepArg,  (XPointer)NULL },
	{"-font",     "tfont",    XrmoptionSepArg,  (XPointer)NULL },
	{"-tfont",    "tfont",    XrmoptionSepArg,  (XPointer)NULL },
	{"-latchkey", "latchKey", XrmoptionSepArg,  (XPointer)NULL },
	{"-setkey",   "setKey",    XrmoptionSepArg,  (XPointer)NULL },
	{"-scripts",  "script",    XrmoptionSepArg,  (XPointer)NULL }
};	

static const int ShortOptCount = sizeof(ShortOptTable) / sizeof(XrmOptionDescRec);

static const XrmOptionDescRec StoredOptTable[] =
{
	{"-geometry",     "geometry",     	 XrmoptionSepArg, (XPointer)NULL },
	{"-nogeometry",   "geometry",    	 XrmoptionNoArg,  (XPointer)"" },
	{"-tgeometry",    "textGeometry",  	 XrmoptionSepArg, (XPointer)NULL },
	{"-notgeometry",  "textGeometry",  	 XrmoptionNoArg,  (XPointer)""},
	{"-transient",    "transient",       XrmoptionNoArg,  (XPointer)"1"},
	{"-notransient",  "transient",       XrmoptionNoArg,  (XPointer)"0"},
	{"-iconic",       "windowMode",      XrmoptionNoArg,  (XPointer)"I" },
	{"-docked",       "windowMode",      XrmoptionNoArg,  (XPointer)"D" },
	{"-wnd",          "windowMode",      XrmoptionNoArg,  (XPointer)"W" },
	{"-wmode",        "windowMode",      XrmoptionSepArg, (XPointer)NULL },
	{"-tsource",      "titleSource",     XrmoptionSepArg, (XPointer)NULL },
	{"-fwdswitch",    "fwdSwitchKey",    XrmoptionSepArg, (XPointer)NULL },
	{"-backswitch",   "backSwitchKey",   XrmoptionSepArg, (XPointer)NULL },
	{"-flexy",		  "flexibleGroups",  XrmoptionNoArg,  (XPointer)"1" },
	{"-stiff",		  "flexibleGroups",  XrmoptionNoArg,  (XPointer)"0" },
	{"-ititle",		  "iconTitle",       XrmoptionNoArg,  (XPointer)"1" },
	{"-noititle",	  "iconTitle",       XrmoptionNoArg,  (XPointer)"0" },

#if HAVE_XINPUT	
//	{"-devname",    "devName",  XrmoptionSepArg, (XPointer)NULL },
//	{"-nodevname",  "devName",  XrmoptionNoArg, (XPointer)"*" },
	{"-devorder",     "devOrder",        XrmoptionSepArg, (XPointer)NULL },
	{"-coredev",      "devOrder",        XrmoptionNoArg,  (XPointer)"256" },
#endif	

#if HAVE_XSHAPES
	{"-shapes",		  "useShapes",    	 XrmoptionNoArg,  (XPointer)"1" },
	{"-noshapes",	  "useShapes",    	 XrmoptionNoArg,  (XPointer)"0" },
#endif


#if WITH_IMAGE
	{"-noimage",      "imageMode",       XrmoptionNoArg,   (XPointer)"N"},
	{"-image",        "imageMode",       XrmoptionNoArg,   (XPointer)"F"},
	{"-imgmode",      "imageMode",       XrmoptionSepArg,  (XPointer)NULL},
	{"-imgfile", 	  "imageFile",       XrmoptionSepArg,  (XPointer)NULL},
	{"-imgdir", 	  "imageDir",        XrmoptionSepArg,  (XPointer)NULL},
#endif

	{"-name1",       "group1.name",      XrmoptionSepArg,  (XPointer)NULL },
	{"-code1",       "group1.code",      XrmoptionSepArg,  (XPointer)NULL },
	{"-fgcol1",      "group1.fgcol",     XrmoptionSepArg,  (XPointer)NULL },
	{"-bgcol1",      "group1.bgcol",     XrmoptionSepArg,  (XPointer)NULL },
	{"-frcol1",      "group1.frcol",     XrmoptionSepArg,  (XPointer)NULL },
	{"-tfont1",      "group1.tfont",     XrmoptionSepArg,  (XPointer)NULL },
	{"-setkey1",     "group1.setKey",    XrmoptionSepArg,  (XPointer)NULL },
	{"-latchkey1",   "group1.latchKey",  XrmoptionSepArg,  (XPointer)NULL },
	{"-script1", 	 "group1.script",    XrmoptionSepArg,  (XPointer)NULL },

	{"-name2",       "group2.name",      XrmoptionSepArg,  (XPointer)NULL },
	{"-code2",       "group2.code",      XrmoptionSepArg,  (XPointer)NULL },
	{"-fgcol2",      "group2.fgcol",     XrmoptionSepArg,  (XPointer)NULL },
	{"-bgcol2",      "group2.bgcol",     XrmoptionSepArg,  (XPointer)NULL },
	{"-frcol2",      "group2.frcol",     XrmoptionSepArg,  (XPointer)NULL },
	{"-tfont2",      "group2.tfont",     XrmoptionSepArg,  (XPointer)NULL },
	{"-setkey2",     "group2.setKey",    XrmoptionSepArg,  (XPointer)NULL },
	{"-latchkey2",   "group2.latchKey",  XrmoptionSepArg,  (XPointer)NULL },
	{"-script2", 	 "group2.script",    XrmoptionSepArg,  (XPointer)NULL },

	{"-name3",       "group3.name",     XrmoptionSepArg,  (XPointer)NULL },
	{"-code3",       "group3.code",     XrmoptionSepArg,  (XPointer)NULL },
	{"-fgcol3",      "group3.fgcol",    XrmoptionSepArg,  (XPointer)NULL },
	{"-bgcol3",      "group3.bgcol",    XrmoptionSepArg,  (XPointer)NULL },
	{"-frcol3",      "group3.frcol",    XrmoptionSepArg,  (XPointer)NULL },
	{"-tfont3",      "group3.tfont",    XrmoptionSepArg,  (XPointer)NULL },
	{"-setkey3",     "group3.setKey",    XrmoptionSepArg,  (XPointer)NULL },
	{"-latchkey3",   "group3.latchKey",  XrmoptionSepArg,  (XPointer)NULL },
	{"-script3", 	 "group3.script",    XrmoptionSepArg,  (XPointer)NULL },

	{"-name4",       "group4.name",     XrmoptionSepArg,  (XPointer)NULL },
	{"-code4",       "group4.code",     XrmoptionSepArg,  (XPointer)NULL },
	{"-fgcol4",      "group4.fgcol",    XrmoptionSepArg,  (XPointer)NULL },
	{"-bgcol4",      "group4.bgcol",    XrmoptionSepArg,  (XPointer)NULL },
	{"-frcol4",      "group4.frcol",    XrmoptionSepArg,  (XPointer)NULL },
	{"-tfont4",      "group4.tfont",    XrmoptionSepArg,  (XPointer)NULL },
	{"-setkey4",     "group4.setKey",    XrmoptionSepArg,  (XPointer)NULL },
	{"-latchkey4",   "group4.latchKey",  XrmoptionSepArg,  (XPointer)NULL },
	{"-script4", 	 "group4.script",    XrmoptionSepArg,  (XPointer)NULL }

};	

static const int StoredOptCount = sizeof(StoredOptTable) / sizeof(XrmOptionDescRec);

typedef struct
{
  const char *argument;
  const char *description;
} HlpTable;

static const HlpTable HelpTable[] =
{
	{"-display",   "display name"},
	{"-save",      "save settings"},
	{"-geometry",  "window geometry: wxh+x+y, wxh-x-y, etc"},
	{"-tgeometry", "text geometry (realtive to window)"},
	{"-wmode",     "window mode: Docked, Window, Iconic, Guess"},
	{"-trans",     "apply transient window status"},
	{"-notrans",   "don't apply transient window status"},

#if HAVE_XINPUT	
//	{"-devname",   "keyboard device name"},
//	{"-nodevname",   "use default (core) keyboard"},
	{"-devorder",    "keyboard device order (0 - based)"},
	{"-coredev",     "use default (core) keyboard"},
#endif
	
#if WITH_IMAGE	
	{"-imgmode",   "image mode: Fixed, Variable, None"},
	{"-imgdir",    "image directory"},
	{"-imgfile",   "image file name"},
#endif	

#if HAVE_XSHAPES
	{"-shapes",	   "use shapes extension" },
	{"-noshapes",  "don't use shapes extension"},
#endif	


	{"-tsource",   "title source (Group, Symbols, User, None)"},
	{"-ititle",    "show title as icon name" },
	{"-flexy",	   "flexible groups"},
	{"-stiff",	   "stiff groups"},

	{"-codes",     "group codes"},
	{"-names",     "group user names (with -tsource User)"},
	{"-fgcol",     "foreground (title) colour(-s)"},
	{"-bgcol",     "background colour(-s)"},
	{"-frcol",     "frame colour(-s)"},
	{"-tfont",     "title font(-s)"},
	{"-fwdswitch",    "key to selext next group"},
	{"-backswitch",   "key to select previous group"},
	{"-setkey",    "keys to set a group"},
	{"-latchkey",  "keys to latch a group"},
	{"-script",    "run script on activating a group"}
	
};   

static const int HlpCount = sizeof(HelpTable) / sizeof(HlpTable);




Bool initXrm()
{
	int i;

	XrmInitialize();

	for (i=0; i<StoredGroupCount; i++) {
		CustomNames[i] = NULL;
		GroupScripts[i] = NULL;
		GroupCodes[i] = NULL;
	}
	
	return True;
}

void deinitXrm()
{
	int i;
	char *name;

	
	if (DispName) {
		free (DispName);
		DispName = NULL;
	}	

/*
#if HAVE_XINPUT
  	if (KbdDevName != NULL) {
		free(KbdDevName);
		KbdDevName = NULL;
	}
#endif
*/	
#if WITH_IMAGE	
	if (ImageFileName != NULL) {
		free(ImageFileName);	
		ImageFileName = NULL;
	}

	if (ImageDir != NULL) {
		free(ImageDir);	
		ImageDir = NULL;
	}
#endif

	for (i=0; i<GroupFontCount; i++) {
		XFreeFont(disp, GroupFonts[i]);
		GroupFonts[i] = NULL;
	}

	for (i=0; i<StoredGroupCount; i++) {
		name = CustomNames[i];
		if (name != NULL) {
			free(name);
			CustomNames[i] = NULL;
		}	
		name = GroupScripts[i];
		if (name != NULL) {
			free(name);
			GroupScripts[i] = NULL;
		}	
		name = GroupCodes[i];
		if (name != NULL) {
			free(name);
			GroupCodes[i] = NULL;
		}	
	}
}


/* ---------------------------------------------------------- */
/*               Arguments                                    */
/* ---------------------------------------------------------- */

static Status GetResourceString(XrmDatabase database, const char *parmname,
                         char **string_return)
{
	char fullname[121];
	XrmValue xrmv;
	Status stat;	

	sprintf(fullname, "%s.%s", ResModuleName, parmname);
	stat = XrmGetResource(database, fullname, ResClassName,  string_return, &xrmv);
	if (stat)  *string_return  = strdup(xrmv.addr);

	return stat;
}

/*
static Status GetResourceString2(XrmDatabase database, const char *parmname,
                         char *string, int maxlength)
{
	XrmValue xrmv;
	char *argtype;
	char fullname[121];
	Status stat;	

	sprintf(fullname, "%s.%s", ResModuleName, parmname);

	stat = XrmGetResource(database, fullname, ResClassName,  &argtype, &xrmv);

	if (stat) {
		int sz = xrmv.size;

		maxlength--;		// Reserve space for trailing zero
		if (sz >= maxlength) sz = maxlength;

		memcpy(string, xrmv.addr, sz);
		*(string + sz) = '\0';
	}	

	return stat;
}
*/

static Status ParseCommandLineValue(XrmDatabase sourcedb, XrmDatabase *targetdb, const char *parmname)
{
	char *sourcevalue;
	const char *seps=",;:";
	Bool status = False;

	if (GetResourceString(sourcedb, parmname, &sourcevalue) && sourcevalue != NULL) {
		int i;
		char targetparmname[81];

		//char *sourceportion = strtokm(sourcevalue, seps);
		char *sourceportion = sourcevalue;
		char *nextportion=sourceportion, c;
	
		for (i=0; i<StoredGroupCount && sourceportion!=NULL; i++) {
			while ((c=*nextportion) != '\0' && strchr(seps,c) == NULL) nextportion++;
			if (c == '\0') nextportion = NULL; else *nextportion++ = '\0';
			
			sprintf(targetparmname, "%s.group%d.%s", ResModuleName, i+1, parmname);
			XrmPutStringResource(targetdb, targetparmname, sourceportion);		

			//sourceportion = strtokm(NULL, seps);
			sourceportion = nextportion;
		}

		status = (i>0);
			
		free(sourcevalue);		
	}

	return status;
}


static void ProcessGeometry(XrmDatabase database, const char *parmname, GeometryInfo *ginfo)
{
	int  x=0, y=0, w=0, h=0, gmask=0;
	char *geometry;


	if (GetResourceString(database, parmname, &geometry) && geometry != NULL)
	{ 
		if (*geometry != '\0')
		  gmask = XParseGeometry(geometry, &x, &y,  &w, &h);   
		  
	  	free(geometry);
	}		  
	
	ginfo->mask = gmask;
	ginfo->x = x;
	ginfo->y = y;
	ginfo->w = w;
	ginfo->h = h;
	
}


static unsigned long GetColourForName(const char *colourName)
{
	XColor exactColour, screenColour;
	XAllocNamedColor(disp,  cmap,  colourName, &exactColour, &screenColour);
	return screenColour.pixel;
}


static int ProcessColours(XrmDatabase database, const char *parmname, const char *defaultColourName, unsigned long *target)
{
	char tempname[81];
	char *colourName = NULL;
	unsigned long curColour = -1;
	int i;
	
	for (i=0; i<StoredGroupCount; i++) {
		sprintf(tempname, "group%d.%s", i+1, parmname);
		if (GetResourceString(database, tempname, &colourName) == False) break;

		if (*colourName != '\0') 
			curColour = GetColourForName(colourName);
		else
		if (i == 0)
			curColour = GetColourForName(defaultColourName);
			
		target[i] = curColour;
		free (colourName);
	}
	
	if (i==0) 
		target[i++] = GetColourForName(defaultColourName);
	

	return i;

}



static int ProcessFonts(XrmDatabase database, const char *parmname, XFontStruct **target, int count)
{
	char tempname[81];
	char *newFontName = NULL;
	char *oldFontName = NULL;
  	const char *defaultFontName1 = "6x13"; // "6x13bold";   
  	const char *defaultFontName2 = "fixed"; 
	const char *currentFontName = NULL;
	XFontStruct *xfs;
	int i;

	
	for (i=0; i<count; i++) {
		sprintf(tempname, "group%d.%s", i+1, parmname);

		if (GetResourceString(database, tempname, &newFontName) == False) {
			if (i>0) break;
			newFontName = NULL;
		}	
		else
		if (*newFontName == '\0') {
			free (newFontName);
			newFontName = NULL;
		}	

		if (newFontName != NULL) {
			if (oldFontName != NULL) free(oldFontName);
			currentFontName = oldFontName = newFontName;
		}	
		else
		if (currentFontName == NULL)
			currentFontName = defaultFontName1;
			
		xfs = XLoadQueryFont(disp, currentFontName);
		if (xfs == None && strcmp(defaultFontName1, currentFontName) != 0) {
		  currentFontName = defaultFontName1;
		  xfs = XLoadQueryFont(disp, currentFontName);
		}  
		if (xfs == None) {
		  currentFontName = defaultFontName2;
	  	  xfs = XLoadQueryFont(disp, currentFontName);
		}

		target[i] = xfs;
		
	}

	if (oldFontName != NULL) free(oldFontName);

	return i;

}

static int ProcessGroupText(XrmDatabase database, const char *parmname, char **target, int mincount, int maxcount)
{
	char tempname[81], c;
	char *groupText, *oldText;
	int i;

	
	for (i=0; i<maxcount; i++) {
		sprintf(tempname, "group%d.%s", i+1, parmname);
		if (GetResourceString(database, tempname, &groupText) == False) {
			if (i >= mincount) break;
			continue;
		}	
		if ((c = *groupText) != '\0' && c != '*') {
			oldText = target[i];
			if (oldText != NULL) free(oldText);
			target[i] = strdup(groupText);
		}	

		free(groupText);
	}
	

	return i;

}

static int GetResourceChoice(XrmDatabase database, const char *parmname, const char *choices, int defaultVal)
{
    char *choiceSource;
	int result = defaultVal;

	if (GetResourceString(database, parmname, &choiceSource)) {
		char code = toupper(*choiceSource);
		if (isdigit(code)) {
			int tmp = atoi(choiceSource);
			if (tmp >=0 && tmp < strlen(choices))
				result = tmp;
		} else {
			char *ptr = strchr(choices, code);
			if (ptr != NULL) 
				result = (int) (ptr-choices);		
		}			

		free (choiceSource);
	}
	
	return result;
}

/*
static int GetResourceInteger(XrmDatabase database, const char *parmname, 
                               int minvalue, int maxvalue, int defvalue)
{
	char *txtValue;  
	int intValue = defvalue;

	if (GetResourceString(database, parmname, &txtValue)) {
		if (*txtValue != '\0') {
			char *tmp;
			int intVal1 = strtol(txtValue, &tmp, 0);
			if (*tmp == '\0' && intVal1 >= minvalue && intVal1 <= maxvalue)
				intValue = intVal1;
		}

		free(txtValue);
	}	

	return intValue;
  
}
*/
static Bool GetResourceBool(XrmDatabase database, const char *parmname, Bool defval)
{
	XrmValue xrmv;
	char fullname[121];
	char *argtype;
	Bool result = defval;
  
	sprintf(fullname, "%s.%s", ResModuleName, parmname);
  
	if (XrmGetResource(database, fullname, ResClassName,  &argtype, &xrmv)
           && xrmv.size > 0)
	{	 char chr  = * (char *) xrmv.addr;
     
    	 if (strchr("Yy1", chr)) result = True;
		 else
    	 if (strchr("Ny0", chr)) result = False;
	}	 

	return result;
}


static Status GetFunctionKey(XrmDatabase database, const char *parmname, unsigned int *scan, unsigned int *modifier)
{
	char *keyName, *sep;
	Status result = False;
	
	if (GetResourceString(database, parmname, &keyName)) {
		Bool hasKey = False;
		
		if (*keyName != '\0') {
			*scan = strtoul(keyName, &sep, 0);
			*modifier = (*sep == '-') ? strtoul(sep+1, &sep, 0) : 0;
			hasKey = (*sep=='\0') || isspace(*sep);
		}

		free(keyName);				
		
		if (hasKey == False) 
			*scan = *modifier = -1;
		
		result = True;
	}	
		
	return result;

}

static int ProcessGroupKeys(XrmDatabase database, const char *parmname, FunctionKey *target, int mincount)
{
	char tempname[81];
	unsigned int  scanCode, modifier;
	int i;

	for (i=0; i<StoredGroupCount; i++) {

		sprintf(tempname, "group%d.%s", i+1, parmname);
		if (! GetFunctionKey(database, tempname, &scanCode, &modifier)) {
			if (i>=mincount) break;
			scanCode = modifier = -1;
		}	
	
		target[i].scan = scanCode;
		target[i].modifier = modifier;
		target[i].active = (modifier != -1);
	}

	return i;
}

static int ProcessSwitchKeys(XrmDatabase database, FunctionKey *target, int mincount)
{
	const char *tempname;
	unsigned int  scanCode, modifier;
	int i;

	for (i=0; i<2; i++) {
		tempname = (i==0) ? "fwdSwitchKey" : "backSwitchKey";
		if (! GetFunctionKey(database, tempname, &scanCode, &modifier)) {
			if (i>=mincount) break;
			scanCode = modifier = -1;
		}	

		target[i].scan = scanCode;
		target[i].modifier = modifier;
		target[i].active = (modifier != -1);
	}
	
	return i;
}

/*
#ifdef HAVE_XINPUT
static char *ProcessKbdName(XrmDatabase database,  const char *parmname)
{
  char *kbdName = NULL;
  if (GetResourceString(database, parmname, &kbdName) ) {
	char kbdStart = *kbdName;
	if (kbdStart == '\0' || strchr("*_", kbdStart)) {
	  free(kbdName); kbdName = NULL;
	}
  }	
  return kbdName;
}
#endif
*/
static void showHelp(FILE *f)
{
  int i;

  fprintf (f, "\n");
  fprintf (f, "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
  fprintf (f, "wmXKB. Docked / swallowed XKB group indicator and switch. \n");
  fprintf (f, "Version " VERSION_TXT ", compiled " __DATE__ " " __TIME__ "\n");
  fprintf (f, "Copyright (C) 2003 Michael Glickman <wmalms@yahoo.com>\n");
  fprintf (f, "Web site: http://wmalms.tripod.com\n");
  fprintf (f, "------------------------------------------------------------\n");

  for (i=0; i<HlpCount; i++)
	fprintf (f, "%-12s %s\n", HelpTable[i].argument, HelpTable[i].description);
	
  fprintf (f, "------------------------------------------------------------\n");
  fprintf (f, "Group values are separated by commas or semicolons.\n");
  fprintf (f, "CONSULT THE MANUAL FOR DETAILS\n");
  fprintf (f, "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");

}


Bool processNonStoredOptionsXrm(int *argc, char **argv)
{
  XrmDatabase  xrmdb = NULL; 
  Bool rc = True;


  XrmParseCommand(&xrmdb, (XrmOptionDescList)  NonStoredOptTable, NonStoredOptCount,
         ResModuleName, argc, argv);

  if (xrmdb != NULL)
  {
	
	if (GetResourceBool (xrmdb, "help", False))
    {
	  showHelp(stderr);
	  rc = False;  
    }
	else
	{  
	  DispName = NULL;
	  GetResourceString(xrmdb, "display", &DispName);
  	  saveMode = GetResourceBool (xrmdb, "save",  False);
	}	  
	
	XrmDestroyDatabase(xrmdb);
  }	

  return rc;  
}


Bool processOptionsXrm(int *argc, char **argv)
{
	int	i, j;
	const char *homedir;
	char *FullResFileName = NULL;
	XrmDatabase  xrmdb = NULL; 
	XrmDatabase  xrmdbShort = NULL; 
	Bool rc = True;
    

	// Getting resources from file
	xrmdb = XrmGetFileDatabase(GlobalResDir "/" ResFileName);

	homedir = getenv("HOME");
	if (homedir != NULL  &&
        (FullResFileName = malloc(strlen(homedir) + 32)) != NULL)
  	{
		sprintf (FullResFileName, "%s/.%s", homedir, ResFileName);
	    XrmCombineFileDatabase(FullResFileName, &xrmdb, True);
	}            


	
	// Processing "shortcut" options
	XrmParseCommand(&xrmdbShort, (XrmOptionDescList) ShortOptTable, ShortOptCount,
				     ResModuleName, argc, argv);

	for (i=0; i<ShortOptCount; i++) 
			ParseCommandLineValue(xrmdbShort, &xrmdb, ShortOptTable[i].specifier);

	XrmDestroyDatabase(xrmdbShort);



	// Getting resources directly from command line
	XrmParseCommand(&xrmdb, (XrmOptionDescList) StoredOptTable, StoredOptCount,
         ResModuleName, argc, argv);



	//=============================================================================
	// Now we are ready to process 
	// ----------------------------


	// This has to preceed geomentry
	Transient = GetResourceBool(xrmdb, "transient", False);

	ProcessGeometry(xrmdb, "geometry", &WndGeometry);
	ProcessGeometry(xrmdb, "textGeometry", &TextGeometry);

	WndMode = GetResourceChoice(xrmdb, "windowMode", "DWIG", 3);
	IconTitle = GetResourceBool(xrmdb, "iconTitle", False);

	FgColourCount = ProcessColours(xrmdb, "fgcol", "yellow",   FgColours);  // Foreground
	BgColourCount = ProcessColours(xrmdb, "bgcol", "black",    BgColours);	// Background
	FrColourCount = ProcessColours(xrmdb, "frcol", "black",    FrColours);	// Frame
	GroupTitleSource = GetResourceChoice(xrmdb, "titleSource","SGUN", 0);
	FlexyGroups = GetResourceBool(xrmdb, "flexibleGroups", False);

	i = FlexyGroups ?  StoredGroupCount : XkbNumKbdGroups;
	
	GroupCodeCount =  ProcessGroupText (xrmdb, "code", GroupCodes,  0, i);
	
	if (FlexyGroups) {
		i = j =  GroupCodeCount;
	} else {
		i = 1; j = XkbNumKbdGroups;
	}	
		
	ProcessGroupText (xrmdb, "name", CustomNames, i, j);
	ProcessGroupText (xrmdb, "script", GroupScripts, i, j);
	GroupFontCount = ProcessFonts (xrmdb, "tfont", GroupFonts, j);

	LatchKeyCount = ProcessGroupKeys(xrmdb, "latchKey", GroupLatchKeys, j);
	SetKeyCount = ProcessGroupKeys(xrmdb, "setKey", GroupSetKeys, j);
	SwitchKeyCount = ProcessSwitchKeys(xrmdb, GroupSwitchKeys, 2);

#if WITH_IMAGE
	ImageFileName = NULL;
	ImageDir = NULL;
	
	if (GetResourceString(xrmdb, "imageFile", &ImageFileName) == False)
		ImageFileName = NULL;

	if (GetResourceString(xrmdb, "imageDir", &ImageDir) == False)
		ImageDir = strdup(IMAGEDIR_DEFAULT);
		

#if HAVE_XSHAPES
	UseShapes = GetResourceBool(xrmdb, "useShapes", True);
#endif

	ImageMode = GetResourceChoice(xrmdb, "imageMode", "NFV", 2);
#endif

#if HAVE_XINPUT	
//	KbdDevName = ProcessKbdName(xrmdb, "devName");
	KbdDevOrder = GetResourceInteger(xrmdb, "devOrder", -1, 256, 256);
#endif	


	if (*argc > 1) {
		showHelp(stderr);
		fprintf (stderr, "Unrecognised arguments:\n");
		for (i=1; i<*argc; i++) {
			fprintf (stderr, "\t%s\n", argv[i]);
		}
		rc = False;
	}


	if (rc && saveMode && FullResFileName != NULL)
	  XrmPutFileDatabase(xrmdb, FullResFileName);
  						   
	XrmDestroyDatabase(xrmdb);
	if (FullResFileName) free(FullResFileName);
	return rc;    

}

/* A fixed version of strtok, based on strpbrk */
/*
char *strtokm(char *line, const char *delim)
{
	static char *nextpos = NULL;

    if (line == NULL) line = nextpos;
    if (line)
    { nextpos = strpbrk(line, delim);
    	if (nextpos) *nextpos++ = '\0';
    }
    return line;
}
*/
