//=============================================
//  wmxkbg - WM XKB groups
// --------------------------------------------
//  Michael Glickman <wmalms@yahooo.com>
//  03-Oct-03
//=============================================

#include "wmxkb.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <sys/wait.h>
#include <sys/types.h>
#include <signal.h>

extern char *DispName;

Display *disp = NULL;

static RETSIGTYPE (*oldTerminateHandler)(int) = NULL;
static RETSIGTYPE (*oldChildExitHandler)(int) = NULL; 
char **environ;

//=============================================================================
static void terminate(void)
{
	signal(SIGTERM, oldTerminateHandler);
	signal(SIGCHLD, oldChildExitHandler);


//#if HAVE_FSLIB
//	deinitFontServer();
//#endif
	deinitX11();
	deinitXKB();
	deinitXrm();
	if (disp) XCloseDisplay(disp);
}

static RETSIGTYPE killHandler(int signum)
{
	terminate();
}


static RETSIGTYPE childExitHandler(int sigCode)
{
	wait(NULL);
}

//=============================================================================

int main(int argc, char **argv, char *envp[])
{
	XkbEvent evnt;
	int retcode = 0;

	environ = envp;
	
	oldTerminateHandler = signal(SIGTERM, killHandler);	
	oldChildExitHandler	= signal(SIGCHLD, childExitHandler); 	

	initXrm();

	if (! processNonStoredOptionsXrm(&argc, argv)) {
		retcode = 20;
		goto Arrivederci;
	}	

	disp = XOpenDisplay(DispName);	
	if (disp == NULL) {
		fprintf(stderr, "Couldn't open display.\n(FYI: This is an X11 application)\n");
		retcode = 16;
		goto Arrivederci;
	}	

	if (!initXKB() || !initX11() || 
		!processOptionsXrm(&argc, argv)) {
		retcode = 12;
		goto Arrivederci;
	}

	if (!prepareXKB() || !prepareX11(argc, argv)) {
		retcode = 8;
		goto Arrivederci;
	}	

/*	
#if HAVE_FSLIB
	if (code <= 0) 
		initFontServer();
#endif
*/
	
	accomodateGroupXKB();
	showIt();

	for (;; ) {
		XNextEvent(disp, &evnt.core);
		if (processEventX11(&evnt.core)) break;		// Termination 
		if (processEventXKB(&evnt)) break;
		processFunctionKey((&evnt.core));
	}	

Arrivederci:
	terminate();
	return retcode;		

}



Status runScriptNow(const char * cmdline)
{
	int pid;
	Bool status = False;
	  
	if (cmdline == NULL) return status;
  
	pid = fork();
	if (pid == 0) {
		char *shell, *sh_name;
		char * argv[4];
		char cmdcopy[512];
	
		shell = getenv("SHELL");
		if (shell == NULL)  shell = "/bin/sh";
  
		sh_name = strrchr(shell, '/');
		if (sh_name == NULL) sh_name = shell; else sh_name++;

		strncpy(cmdcopy, cmdline, sizeof(cmdcopy));
		argv[0] = sh_name;
		argv[1] = "-c";
		argv[2] = cmdcopy;
		argv[3] = NULL;
		freopen("/dev/null", "w", stdout);
		freopen("/dev/null", "r", stdin);
		execve(shell, argv, environ);
	} else
		status = (pid != -1);
	
	if (status == False) XBell(disp, 50);

	return status;
}



