// Copyright 2017 VMware, Inc. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package registry

import mock "github.com/stretchr/testify/mock"

// MockEntry is an autogenerated mock type for the Entry type
type MockEntry struct {
	mock.Mock
}

// Contains provides a mock function with given fields: e
func (_m *MockEntry) Contains(e Entry) bool {
	ret := _m.Called(e)

	var r0 bool
	if rf, ok := ret.Get(0).(func(Entry) bool); ok {
		r0 = rf(e)
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// Equal provides a mock function with given fields: other
func (_m *MockEntry) Equal(other Entry) bool {
	ret := _m.Called(other)

	var r0 bool
	if rf, ok := ret.Get(0).(func(Entry) bool); ok {
		r0 = rf(other)
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// IsCIDR provides a mock function with given fields:
func (_m *MockEntry) IsCIDR() bool {
	ret := _m.Called()

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// IsURL provides a mock function with given fields:
func (_m *MockEntry) IsURL() bool {
	ret := _m.Called()

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// Match provides a mock function with given fields: e
func (_m *MockEntry) Match(e string) bool {
	ret := _m.Called(e)

	var r0 bool
	if rf, ok := ret.Get(0).(func(string) bool); ok {
		r0 = rf(e)
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// String provides a mock function with given fields:
func (_m *MockEntry) String() string {
	ret := _m.Called()

	var r0 string
	if rf, ok := ret.Get(0).(func() string); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(string)
	}

	return r0
}

var _ Entry = (*MockEntry)(nil)
