/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.video.timecode;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openimaj.video.timecode.FrameNumberVideoTimecode;

public class HrsMinSecFrameTimecode
extends FrameNumberVideoTimecode {
    public HrsMinSecFrameTimecode(long number, double framesPerSec) {
        super(number, framesPerSec);
    }

    public int getHours() {
        return (int)((double)this.getFrameNumber() / this.fps / 3600.0);
    }

    public int getMinutes() {
        return (int)((double)this.getFrameNumber() / this.fps / 60.0) % 60;
    }

    public int getSeconds() {
        return (int)((double)this.getFrameNumber() / this.fps) % 60;
    }

    public int getFrames() {
        return (int)((double)this.getFrameNumber() % this.fps);
    }

    @Override
    public String toString() {
        return this.getHours() + ":" + this.getMinutes() + ":" + this.getSeconds() + ":" + this.getFrames() + "/" + this.fps;
    }

    public static HrsMinSecFrameTimecode fromString(String s) {
        Pattern p = Pattern.compile("(\\d+):(\\d+):(\\d+):(\\d+)/([\\d.]+)");
        Matcher m = p.matcher(s);
        if (!m.find()) {
            return null;
        }
        double fps = Double.parseDouble(m.group(3));
        int hrs = Integer.parseInt(m.group(0));
        int min = Integer.parseInt(m.group(1));
        int sec = Integer.parseInt(m.group(2));
        int frames = Integer.parseInt(m.group(3));
        int frameNumber = (int)((double)frames + (double)sec * fps + (double)(min * 60) * fps + (double)(hrs * 3600) * fps);
        HrsMinSecFrameTimecode h = new HrsMinSecFrameTimecode(frameNumber, fps);
        return h;
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof HrsMinSecFrameTimecode) {
            HrsMinSecFrameTimecode h = (HrsMinSecFrameTimecode)obj;
            return h.getHours() == this.getHours() && h.getMinutes() == this.getMinutes() && h.getSeconds() == this.getSeconds() && h.getFrames() == this.getFrames();
        }
        return false;
    }

    @Override
    public HrsMinSecFrameTimecode clone() {
        return new HrsMinSecFrameTimecode(this.getFrameNumber(), this.fps);
    }
}

