/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Component;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import org.nlogo.api.FileIO$;
import org.nlogo.api.Version$;
import org.nlogo.core.I18N;
import org.nlogo.swing.BrowserLauncher;

strictfp final class QuickHelp<TokenType> {
    private static boolean quickHelpLoaded = false;
    private static final String QUICKHELPWORDS_PATH = "/system/dict.txt";
    private static final String QUICKHELPWORDS_PATH3D = "/system/dict3d.txt";
    private static Map<String, String> quickHelpWords;
    private static Map<String, String> quickHelpWords3d;

    private QuickHelp() {
        throw new IllegalStateException();
    }

    private static Map<String, String> loadHelp(String path) {
        String[] lines = FileIO$.MODULE$.getResourceAsStringArray(path);
        HashMap<String, String> words = new HashMap<String, String>();
        for (int i = 0; i < lines.length; ++i) {
            String anchor = lines[i].substring(0, lines[i].indexOf(32));
            String file = lines[i].substring(lines[i].indexOf(32) + 1);
            words.put(anchor, file);
        }
        return words;
    }

    private static Path docPath(String docName) {
        return BrowserLauncher.docPath(docName);
    }

    private static void openDictionary(Component comp, String theWord, Map<String, String> words) {
        String theFile = words.get(theWord);
        BrowserLauncher.openPath(comp, QuickHelp.docPath("dict/" + theFile), null);
    }

    public static void doHelp(Component comp, String token) {
        if (!quickHelpLoaded) {
            quickHelpWords = QuickHelp.loadHelp(QUICKHELPWORDS_PATH);
            quickHelpWords3d = Version$.MODULE$.is3D() ? QuickHelp.loadHelp(QUICKHELPWORDS_PATH3D) : new HashMap<String, String>();
            quickHelpLoaded = true;
        }
        if (token == null) {
            return;
        }
        if (quickHelpWords3d.containsKey(token = token.toLowerCase())) {
            QuickHelp.openDictionary(comp, token, quickHelpWords3d);
        } else if (quickHelpWords.containsKey(token)) {
            QuickHelp.openDictionary(comp, token, quickHelpWords);
        } else if (0 == JOptionPane.showConfirmDialog(comp, I18N.guiJ().getN("tabs.code.rightclick.quickhelp.notfound", token.toUpperCase()), I18N.guiJ().get("common.netlogo"), 0)) {
            BrowserLauncher.openPath(comp, QuickHelp.docPath("index2.html"), null);
        }
    }
}

