/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.shape.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;
import org.nlogo.core.I18N;
import org.nlogo.core.Shape;
import org.nlogo.shape.editor.DrawableList;
import org.nlogo.shape.editor.ManagerDialog;
import org.nlogo.swing.ButtonPanel;
import org.nlogo.swing.Utils;

public strictfp class ImportDialog
extends JDialog
implements ListSelectionListener {
    final ManagerDialog<? extends Shape> manager;
    final DrawableList<? extends Shape> list;

    public ImportDialog(Dialog dialog, ManagerDialog<? extends Shape> manager, DrawableList<? extends Shape> drawableList) {
        super(dialog, "Library", true);
        this.manager = manager;
        this.list = drawableList;
        this.list.update();
        JButton importButton = new JButton("Import");
        importButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportDialog.this.importSelectedShapes();
            }
        });
        AbstractAction cancelAction = new AbstractAction(I18N.guiJ().get("common.buttons.cancel")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportDialog.this.dispose();
            }
        };
        JButton cancelButton = new JButton(cancelAction);
        Utils.addEscKeyAction(this, (Action)cancelAction);
        this.list.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    ImportDialog.this.importSelectedShapes();
                }
            }
        });
        ButtonPanel panel = new ButtonPanel(new JButton[]{importButton, cancelButton});
        JScrollPane scrollPane = new JScrollPane(this.list);
        this.getContentPane().setLayout(new BorderLayout(0, 10));
        this.getContentPane().add((Component)scrollPane, "Center");
        this.getContentPane().add((Component)panel, "South");
        this.pack();
        this.setLocation(manager.getLocation().x + 10, manager.getLocation().y + 10);
        this.getRootPane().setDefaultButton(importButton);
        this.setVisible(true);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int[] selected = this.list.getSelectedIndices();
        if (selected.length == 1) {
            this.list.ensureIndexIsVisible(selected[0]);
        }
    }

    private void importSelectedShapes() {
        int i;
        Object[] choices = new Object[]{"Replace", "Rename", I18N.guiJ().get("common.buttons.cancel")};
        int[] selected = this.list.getSelectedIndices();
        ArrayList<Shape> shapesToAdd = new ArrayList<Shape>();
        for (i = 0; i < selected.length; ++i) {
            Shape shape = this.list.getShape(selected[i]).get();
            while (this.manager.shapesList().exists(shape.name())) {
                int choice = JOptionPane.showOptionDialog(this, "A shape with the name \"" + shape.name() + "\" already exists in this model.\nDo you want to replace the existing shape or rename the imported one?", "Import", 1, 2, null, choices, choices[0]);
                if (choice == 0) {
                    shapesToAdd.add(shape);
                    break;
                }
                if (choice == 1) {
                    String name = JOptionPane.showInputDialog(this, "Import shape as:", "Import Shapes", -1);
                    if (name == null) continue;
                    shape.name_$eq(name);
                    continue;
                }
                return;
            }
            shapesToAdd.add(shape);
        }
        for (i = 0; i < shapesToAdd.size(); ++i) {
            this.manager.shapesList().addShape((Shape)shapesToAdd.get(i));
        }
        this.manager.shapesList().update();
        this.manager.shapesList().selectShapeName("default");
        this.dispose();
    }

    void sendImportWarning(String message) {
        JOptionPane.showMessageDialog(this, message, "Import", 2);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        d.width = StrictMath.max(d.width, 260);
        return d;
    }
}

