/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.gl.render;

import com.jogamp.opengl.GL2;
import java.util.ArrayList;
import java.util.List;
import org.nlogo.api.Agent;
import org.nlogo.api.AgentException;
import org.nlogo.api.DrawingInterface;
import org.nlogo.api.Exceptions;
import org.nlogo.api.Patch3D;
import org.nlogo.api.Turtle;
import org.nlogo.api.Turtle3D;
import org.nlogo.api.ViewSettings;
import org.nlogo.api.World;
import org.nlogo.api.World3D;
import org.nlogo.api.WorldWithWorldRenderable;
import org.nlogo.gl.render.ExportRenderer;
import org.nlogo.gl.render.ExportRenderer3D;
import org.nlogo.gl.render.GLViewSettings;
import org.nlogo.gl.render.LinkRenderer;
import org.nlogo.gl.render.LinkRenderer3D;
import org.nlogo.gl.render.PatchRenderer;
import org.nlogo.gl.render.PatchRenderer3D;
import org.nlogo.gl.render.Renderer;
import org.nlogo.gl.render.ShapeRenderer3D;
import org.nlogo.gl.render.TurtleRenderer;
import org.nlogo.gl.render.TurtleRenderer3D;
import org.nlogo.gl.render.WorldRenderer;
import org.nlogo.gl.render.WorldRenderer3D;

public class Renderer3D
extends Renderer {
    public Renderer3D(WorldWithWorldRenderable world, ViewSettings graphicsSettings, DrawingInterface drawing, GLViewSettings glSettings) {
        super(world, graphicsSettings, drawing, glSettings, new ShapeRenderer3D((World3D)((Object)world)));
    }

    public Renderer3D(Renderer glrenderer) {
        super(glrenderer);
    }

    @Override
    void setClippingPlanes(GL2 gl) {
        super.setClippingPlanes(gl);
        World3D w = (World3D)((Object)this.world);
        if (w.worldDepth() > 1) {
            this.renderClippingPlane(gl, new double[]{0.0, 0.0, 1.0, (float)(-((double)w.minPzcor() - 0.5) * (double)0.3f) + 0.01f}, 12292);
            this.renderClippingPlane(gl, new double[]{0.0, 0.0, -1.0, (float)(((double)w.maxPzcor() + 0.5) * (double)0.3f) + 0.01f}, 12293);
        }
    }

    @Override
    void disableClippingPlanes(GL2 gl) {
        super.disableClippingPlanes(gl);
        gl.glDisable(12292);
        gl.glDisable(12293);
    }

    @Override
    TurtleRenderer createTurtleRenderer(World world) {
        return new TurtleRenderer3D(world, this.shapeRenderer);
    }

    @Override
    WorldRenderer createWorldRenderer(World world, PatchRenderer patchRenderer, DrawingInterface drawing, TurtleRenderer turtleRenderer, GLViewSettings settings) {
        return new WorldRenderer3D((World3D)world, (PatchRenderer3D)patchRenderer, drawing, (TurtleRenderer3D)turtleRenderer, (LinkRenderer3D)this.linkRenderer, settings);
    }

    @Override
    PatchRenderer createPatchRenderer(World world, DrawingInterface drawing) {
        return new PatchRenderer3D((World3D)world, drawing, this.shapeRenderer);
    }

    @Override
    LinkRenderer createLinkRenderer(World world) {
        return new LinkRenderer3D(world, this.shapeRenderer);
    }

    @Override
    public ExportRenderer createExportRenderer() {
        return new ExportRenderer3D(this);
    }

    @Override
    void renderWorld(GL2 gl, World world) {
        gl.glPushMatrix();
        this.translateWorld(gl, world);
        this.worldRenderer.renderWorld(gl, this.renderer.fontSize(), this.renderer.patchSize());
        gl.glPopMatrix();
    }

    @Override
    public void translateWorld(GL2 gl, World world) {
        World3D w = (World3D)world;
        gl.glTranslated((double)(world.maxPxcor() + world.minPxcor()) / 2.0 * (double)0.3f, (double)(world.maxPycor() + world.minPycor()) / 2.0 * (double)0.3f, (double)(w.maxPzcor() + w.minPzcor()) / 2.0 * (double)0.3f);
    }

    @Override
    double[] getTurtleCoords(Turtle turtle, double height) {
        Turtle3D t = (Turtle3D)turtle;
        double[] coords = new double[]{t.xcor(), t.ycor(), t.zcor()};
        coords[0] = this.world.wrappedObserverX(coords[0]) * (double)0.3f;
        coords[1] = this.world.wrappedObserverY(coords[1]) * (double)0.3f;
        coords[2] = ((World3D)((Object)this.world)).wrappedObserverZ(coords[2]) * (double)0.3f;
        return coords;
    }

    double[] getPatchCoords(Patch3D patch) {
        double[] coords = new double[]{patch.pxcor(), patch.pycor(), patch.pzcor()};
        coords[0] = this.world.wrappedObserverX(coords[0]) * (double)0.3f;
        coords[1] = this.world.wrappedObserverY(coords[1]) * (double)0.3f;
        coords[2] = ((World3D)((Object)this.world)).wrappedObserverZ(coords[2]) * (double)0.3f;
        return coords;
    }

    @Override
    void performPick() {
        ArrayList<Agent> agents = new ArrayList<Agent>();
        double[][] ray = this.generatePickRay(this.mouseState.point().getX(), (double)this.height - this.mouseState.point().getY());
        this.pickTurtles(agents, ray);
        this.pickLinks(agents, ray);
        this.pickPatches(agents, ray);
        this.pickListener.pick(this.mouseState.point(), agents);
        this.mouseState.pickRequest_$eq(false);
    }

    double wrapZ(double z) {
        return ((World3D)((Object)this.world)).wrapZ(z);
    }

    @Override
    void pickPatches(List<Agent> agents, double[][] ray) {
        if (agents == null) {
            return;
        }
        World3D w = (World3D)((Object)this.world);
        double scale = 3.3333332538604736;
        double deltaz = Math.abs(ray[0][2] - ray[1][2]);
        double deltay = Math.abs(ray[0][1] - ray[1][1]);
        double deltax = Math.abs(ray[0][0] - ray[1][0]);
        double xi = ray[0][0] * scale;
        double yi = ray[0][1] * scale;
        double zi = ray[0][2] * scale;
        double xinc = 0.0;
        double yinc = 0.0;
        double zinc = 0.0;
        double t = 0.0;
        double min = 0.0;
        double max = 0.0;
        if (deltaz >= deltay && deltaz >= deltax) {
            zinc = 1.0;
            t = 1.0 / (ray[1][2] - ray[0][2]);
            xinc = (ray[1][0] - ray[0][0]) * t;
            yinc = (ray[1][1] - ray[0][1]) * t;
            min = w.minPzcor();
            max = w.maxPzcor();
            zi = min;
            xi -= xinc * ray[0][2] * scale - min * xinc;
            yi -= yinc * ray[0][2] * scale - min * yinc;
        } else if (deltay >= deltax) {
            yinc = 1.0;
            t = 1.0 / (ray[1][1] - ray[0][1]);
            xinc = (ray[1][0] - ray[0][0]) * t;
            zinc = (ray[1][2] - ray[0][2]) * t;
            min = w.minPycor();
            max = w.maxPycor();
            yi = min;
            xi -= xinc * ray[0][1] * scale - min * xinc;
            zi -= zinc * ray[0][1] * scale - min * zinc;
        } else {
            xinc = 1.0;
            t = -1.0 / (ray[0][0] - ray[1][0]);
            yinc = (ray[1][1] - ray[0][1]) * t;
            zinc = (ray[1][2] - ray[0][2]) * t;
            min = w.minPxcor();
            max = w.maxPxcor();
            xi = min;
            yi -= yinc * ray[0][0] * scale - min * yinc;
            zi -= zinc * ray[0][0] * scale - min * zinc;
        }
        for (double c = min; c <= max; c += 1.0) {
            double x = xi;
            double y = yi;
            double z = zi;
            if (x < (double)this.world.maxPxcor() + 0.5 && x >= (double)this.world.minPxcor() - 0.5 && y < (double)this.world.maxPycor() + 0.5 && y >= (double)this.world.minPycor() - 0.5 && z < (double)w.maxPzcor() + 0.5 && z >= (double)w.minPzcor() - 0.5) {
                try {
                    agents.add(w.getPatchAt(this.wrapX(x + w.followOffsetX()), this.wrapY(y + w.followOffsetY()), this.wrapZ(z + w.followOffsetZ())));
                }
                catch (AgentException e) {
                    Exceptions.ignore(e);
                }
            }
            xi += xinc;
            yi += yinc;
            zi += zinc;
        }
    }
}

