/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.gl.render;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.glu.GLU;
import java.awt.Color;
import java.io.Serializable;
import java.nio.FloatBuffer;
import org.nlogo.api.Agent;
import org.nlogo.api.AgentFollowingPerspective;
import org.nlogo.api.Color$;
import org.nlogo.api.Link;
import org.nlogo.api.Perspective;
import org.nlogo.api.World;
import org.nlogo.gl.render.AgentRenderer;
import org.nlogo.gl.render.GLLinkShape;
import org.nlogo.gl.render.ShapeRenderer;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005Uc\u0001\u0002\u0007\u000e\tYA\u0011b\u0007\u0001\u0003\u0002\u0003\u0006I\u0001\b\u0012\t\u0013\r\u0002!\u0011!Q\u0001\n\u0011:\u0003\"\u0002\u0015\u0001\t\u0003I\u0003\"B\u0017\u0001\t\u0013q\u0003\"B\u001b\u0001\t\u00031\u0004\"\u0002-\u0001\t\u0003I\u0006\"B3\u0001\t\u00031\u0007\"B9\u0001\t\u0013\u0011\bbBA\u0019\u0001\u0011\u0005\u00111\u0007\u0005\b\u0003\u0003\u0002A\u0011AA\"\u0011\u001d\tY\u0005\u0001C\u0005\u0003\u001b\u0012A\u0002T5oWJ+g\u000eZ3sKJT!AD\b\u0002\rI,g\u000eZ3s\u0015\t\u0001\u0012#\u0001\u0002hY*\u0011!cE\u0001\u0006]2|wm\u001c\u0006\u0002)\u0005\u0019qN]4\u0004\u0001M\u0011\u0001a\u0006\t\u00031ei\u0011!D\u0005\u000355\u0011Q\"Q4f]R\u0014VM\u001c3fe\u0016\u0014\u0018!B<pe2$\u0007CA\u000f!\u001b\u0005q\"BA\u0010\u0012\u0003\r\t\u0007/[\u0005\u0003Cy\u0011QaV8sY\u0012L!aG\r\u0002\u001bMD\u0017\r]3SK:$WM]3s!\tAR%\u0003\u0002'\u001b\ti1\u000b[1qKJ+g\u000eZ3sKJL!aI\r\u0002\rqJg.\u001b;?)\rQ3\u0006\f\t\u00031\u0001AQaG\u0002A\u0002qAQaI\u0002A\u0002\u0011\n\u0011\u0002\\5oKN\u001b\u0017\r\\3\u0016\u0003=\u0002\"\u0001M\u001a\u000e\u0003ER\u0011AM\u0001\u0006g\u000e\fG.Y\u0005\u0003iE\u0012a\u0001R8vE2,\u0017a\u0003:f]\u0012,'\u000fT5oWN$ba\u000e\u001eF\u0019F\u001b\u0006C\u0001\u00199\u0013\tI\u0014G\u0001\u0003V]&$\b\"\u0002\t\u0006\u0001\u0004Y\u0004C\u0001\u001fD\u001b\u0005i$B\u0001 @\u0003\u0019y\u0007/\u001a8hY*\u0011\u0001)Q\u0001\u0007U><\u0017-\u001c9\u000b\u0003\t\u000b1aY8n\u0013\t!UHA\u0002H\u0019JBQAR\u0003A\u0002\u001d\u000b1a\u001a7v!\tA%*D\u0001J\u0015\t1U(\u0003\u0002L\u0013\n\u0019q\tT+\t\u000b5+\u0001\u0019\u0001(\u0002\u0011\u0019|g\u000e^*ju\u0016\u0004\"\u0001M(\n\u0005A\u000b$aA%oi\")!+\u0002a\u0001_\u0005I\u0001/\u0019;dQNK'0\u001a\u0005\u0006)\u0016\u0001\r!V\u0001\r_V$H.\u001b8f\u0003\u001e,g\u000e\u001e\t\u0003;YK!a\u0016\u0010\u0003\u000b\u0005;WM\u001c;\u0002\u001b\u001d,G\u000fT5oW\u000e{wN\u001d3t)\tQ\u0006\rE\u000217vK!\u0001X\u0019\u0003\u000b\u0005\u0013(/Y=\u0011\u0005Ar\u0016BA02\u0005\u00151En\\1u\u0011\u0015\tg\u00011\u0001c\u0003\u0011a\u0017N\\6\u0011\u0005u\u0019\u0017B\u00013\u001f\u0005\u0011a\u0015N\\6\u0002#I,g\u000eZ3s/J\f\u0007\u000f]3e\u0019&t7\u000eF\u00048O\"L'n\u001b9\t\u000bA9\u0001\u0019A\u001e\t\u000b\u0005<\u0001\u0019\u00012\t\u000b5;\u0001\u0019\u0001(\t\u000bI;\u0001\u0019A\u0018\t\u000b1<\u0001\u0019A7\u0002\u000f=,H\u000f\\5oKB\u0011\u0001G\\\u0005\u0003_F\u0012qAQ8pY\u0016\fg\u000eC\u0003.\u000f\u0001\u0007q&\u0001\u0006sK:$WM\u001d'j].$BdN:us\u0006\u001d\u00111BA\b\u0003'\t9\"a\u0007\u0002 \u0005\r\u0012QEA\u0015\u0003[\ty\u0003C\u0003\u0011\u0011\u0001\u00071\bC\u0003v\u0011\u0001\u0007a/A\u0003tQ\u0006\u0004X\r\u0005\u0002\u0019o&\u0011\u00010\u0004\u0002\f\u000f2c\u0015N\\6TQ\u0006\u0004X\rC\u0003{\u0011\u0001\u000710A\u0003d_2|'\u000fE\u0002}\u0003\u0007i\u0011! \u0006\u0003}~\f1!Y<u\u0015\t\t\t!\u0001\u0003kCZ\f\u0017bAA\u0003{\n)1i\u001c7pe\"1\u0011\u0011\u0002\u0005A\u0002=\nAa]5{K\"1\u0011Q\u0002\u0005A\u0002u\u000b!\u0001_\u0019\t\r\u0005E\u0001\u00021\u0001^\u0003\tI\u0018\u0007\u0003\u0004\u0002\u0016!\u0001\r!X\u0001\u0003uFBa!!\u0007\t\u0001\u0004i\u0016A\u0001=3\u0011\u0019\ti\u0002\u0003a\u0001;\u0006\u0011\u0011P\r\u0005\u0007\u0003CA\u0001\u0019A/\u0002\u0005i\u0014\u0004\"\u0002*\t\u0001\u0004y\u0003BBA\u0014\u0011\u0001\u0007q&A\u0007mS:,G\u000b[5dW:,7o\u001d\u0005\u0007\u0003WA\u0001\u0019A7\u0002\u0015%\u001cH)\u001b:fGR,G\rC\u0003b\u0011\u0001\u0007!\rC\u0003m\u0011\u0001\u0007Q.A\u000bsK:$WM]%oI&4\u0018\u000eZ;bY2Kgn[:\u0015\u001b]\n)$a\u000e\u0002:\u0005m\u0012QHA \u0011\u0015\u0001\u0012\u00021\u0001<\u0011\u00151\u0015\u00021\u0001H\u0011\u0015\t\u0017\u00021\u0001c\u0011\u0015i\u0015\u00021\u0001O\u0011\u0015\u0011\u0016\u00021\u00010\u0011\u0015!\u0016\u00021\u0001V\u000399W\r^(sS\u0016tG/\u0019;j_:$B!!\u0012\u0002HA\u0019\u0001gW\u0018\t\r\u0005%#\u00021\u0001V\u0003\u0015\tw-\u001a8u\u000399W\r^!hK:$8i\\8sIN$b!!\u0012\u0002P\u0005E\u0003BBA%\u0017\u0001\u0007Q\u000b\u0003\u0004\u0002T-\u0001\raL\u0001\u0007Q\u0016Lw\r\u001b;")
public class LinkRenderer
extends AgentRenderer {
    private double lineScale() {
        Perspective perspective = super.world().observer().perspective();
        double d = perspective instanceof AgentFollowingPerspective ? (double)((AgentFollowingPerspective)((Object)perspective)).followDistance() : super.world().observer().orientation().get().dist();
        if (d == 0.0) {
            return 0.0;
        }
        return (double)RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(super.world().worldWidth()), super.world().worldHeight()) * 1.5 / d;
    }

    public void renderLinks(GL2 gl, GLU glu, int fontSize, double patchSize, Agent outlineAgent) {
        if (super.world().links() == null) {
            return;
        }
        double scale = this.lineScale();
        ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(super.world().links().agents()).asScala()).map((Function1<Agent, Link> & Serializable & scala.Serializable)x$1 -> (Link)x$1, Iterable$.MODULE$.canBuildFrom())).foreach((Function1<Link, Object> & Serializable & scala.Serializable)link -> {
            LinkRenderer.$anonfun$renderLinks$2(this, gl, fontSize, patchSize, outlineAgent, scale, link);
            return BoxedUnit.UNIT;
        });
    }

    public float[] getLinkCoords(Link link) {
        return (float[])Array$.MODULE$.apply(Predef$.MODULE$.wrapFloatArray(new float[]{(float)link.x1(), (float)link.y1(), 0.0f, (float)link.x2(), (float)link.y2(), 0.0f}), ClassTag$.MODULE$.Float());
    }

    public void renderWrappedLink(GL2 gl, Link link, int fontSize, double patchSize, boolean outline, double lineScale) {
        double maxx = (double)super.world().maxPxcor() + 0.5;
        double minx = (double)super.world().minPxcor() - 0.5;
        double maxy = (double)super.world().maxPycor() + 0.5;
        double miny = (double)super.world().minPycor() - 0.5;
        int worldWidth = super.world().worldWidth();
        int worldHeight = super.world().worldHeight();
        boolean wrapXRight = false;
        boolean wrapXLeft = false;
        float[] coords = this.getLinkCoords(link);
        double size = link.size();
        GLLinkShape shape = super.shapeRenderer().getLinkShape(link.shape());
        Color color = Color$.MODULE$.getColor(link.color());
        this.renderLink(gl, shape, color, size, coords[0], coords[1], coords[2], coords[3], coords[4], coords[5], patchSize, link.lineThickness(), link.isDirectedLink(), link, outline);
        if (super.world().wrappingAllowedInX()) {
            if ((double)coords[3] + size / (double)2 > maxx) {
                this.renderLink(gl, shape, color, size, coords[0] - (float)worldWidth, coords[1], coords[2], coords[3] - (float)worldWidth, coords[4], coords[5], patchSize, link.lineThickness(), link.isDirectedLink(), link, outline);
                wrapXRight = true;
            }
            if ((double)coords[0] - size / (double)2 < minx) {
                this.renderLink(gl, shape, color, size, coords[0] + (float)worldWidth, coords[1], coords[2], coords[3] + (float)worldWidth, coords[4], coords[5], patchSize, link.lineThickness(), link.isDirectedLink(), link, outline);
                wrapXLeft = true;
            }
        }
        if (super.world().wrappingAllowedInY()) {
            if ((double)coords[4] + size / (double)2 > maxy) {
                this.renderLink(gl, shape, color, size, coords[0], coords[1] - (float)worldHeight, coords[2], coords[3], coords[4] - (float)worldHeight, coords[5], patchSize, link.lineThickness(), link.isDirectedLink(), link, outline);
                if (wrapXRight) {
                    this.renderLink(gl, shape, color, size, coords[0] - (float)worldWidth, coords[1] - (float)worldHeight, coords[2], coords[3] - (float)worldWidth, coords[4] - (float)worldHeight, coords[5], patchSize, link.lineThickness(), link.isDirectedLink(), link, outline);
                }
                if (wrapXLeft) {
                    this.renderLink(gl, shape, color, size, coords[0] + (float)worldWidth, coords[1] - (float)worldHeight, coords[2], coords[3] + (float)worldWidth, coords[4] - (float)worldHeight, coords[5], patchSize, link.lineThickness(), link.isDirectedLink(), link, outline);
                }
            }
            if ((double)coords[1] - size / (double)2 < miny) {
                this.renderLink(gl, shape, color, size, coords[0], coords[1] + (float)worldHeight, coords[2], coords[3], coords[4] + (float)worldHeight, coords[5], patchSize, link.lineThickness(), link.isDirectedLink(), link, outline);
                if (wrapXRight) {
                    this.renderLink(gl, shape, color, size, coords[0] - (float)worldWidth, coords[1] + (float)worldHeight, coords[2], coords[3] - (float)worldWidth, coords[4] + (float)worldHeight, coords[5], patchSize, link.lineThickness(), link.isDirectedLink(), link, outline);
                }
                if (wrapXLeft) {
                    this.renderLink(gl, shape, color, size, coords[0] + (float)worldWidth, coords[1] + (float)worldHeight, coords[2], coords[3] + (float)worldWidth, coords[4] + (float)worldHeight, coords[5], patchSize, link.lineThickness(), link.isDirectedLink(), link, outline);
                }
            }
        }
        if (link.hasLabel()) {
            double[] labelCoords = this.getAgentCoords(link, 1.0);
            super.shapeRenderer().renderLabel(gl, link.labelString(), link.labelColor(), (float)(labelCoords[0] * (double)0.3f), (float)(labelCoords[1] * (double)0.3f), (float)(labelCoords[2] * (double)0.3f), 1.0f, fontSize, patchSize);
        }
    }

    private void renderLink(GL2 gl, GLLinkShape shape, Color color, double size, float x1, float y1, float z1, float x2, float y2, float z2, double patchSize, double lineThickness, boolean isDirected, Link link, boolean outline) {
        gl.glPushMatrix();
        gl.glColor4fv(FloatBuffer.wrap(color.getRGBColorComponents(null)));
        gl.glEnable(2852);
        float stroke = (float)RichDouble$.MODULE$.max$extension(Predef$.MODULE$.doubleWrapper(1.0), patchSize * lineThickness);
        gl.glLineWidth(stroke);
        shape.render(gl, x1, y1, z1, x2, y2, z2, stroke, isDirected, link, super.shapeRenderer(), outline, color, super.world());
        gl.glLineWidth(1.0f);
        gl.glDisable(2852);
        gl.glPopMatrix();
    }

    public void renderIndividualLinks(GL2 gl, GLU glu, Link link, int fontSize, double patchSize, Agent outlineAgent) {
        if (super.world().links() == null) {
            return;
        }
        if (!link.hidden()) {
            Agent agent = outlineAgent;
            this.renderWrappedLink(gl, link, fontSize, patchSize, agent != null && agent.equals(link), this.lineScale());
        }
    }

    public double[] getOrientation(Agent agent) {
        return (double[])Array$.MODULE$.apply(Predef$.MODULE$.wrapDoubleArray(new double[]{((Link)agent).heading(), 0.0, 0.0}), ClassTag$.MODULE$.Double());
    }

    private double[] getAgentCoords(Agent agent, double height) {
        Link link = (Link)agent;
        double[] coords = (double[])Array$.MODULE$.apply(Predef$.MODULE$.wrapDoubleArray(new double[]{super.world().wrappedObserverX(link.midpointX()), super.world().wrappedObserverY(link.midpointY()), (height - 1.0) / (double)2}), ClassTag$.MODULE$.Double());
        String string2 = link.shape();
        String string3 = "default";
        if (string2 != null && string2.equals(string3)) {
            coords[2] = coords[2] / (double)2;
        }
        return coords;
    }

    public static final /* synthetic */ void $anonfun$renderLinks$2(LinkRenderer $this, GL2 gl$1, int fontSize$1, double patchSize$1, Agent outlineAgent$1, double scale$1, Link link) {
        if (!link.hidden()) {
            Agent agent = outlineAgent$1;
            $this.renderWrappedLink(gl$1, link, fontSize$1, patchSize$1, agent != null && agent.equals(link), scale$1);
        }
    }

    public LinkRenderer(World world, ShapeRenderer shapeRenderer) {
        super(world, shapeRenderer);
    }
}

