/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;

class ImportLexer {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int COMMA = 2;
    public static final int QUOTED = 4;
    public static final int YYINITIAL = 0;
    private static final int[] ZZ_LEXSTATE = new int[]{0, 0, 1, 1, 2, 2};
    private static final String ZZ_CMAP_PACKED = "\b\u0000\u0002\u0002\u0001\u0004\u0015\u0000\u0001\u0002\u0001\u0000\u0001\u0003\t\u0000\u0001\u0001\uffd3\u0000";
    private static final char[] ZZ_CMAP = ImportLexer.zzUnpackCMap("\b\u0000\u0002\u0002\u0001\u0004\u0015\u0000\u0001\u0002\u0001\u0000\u0001\u0003\t\u0000\u0001\u0001\uffd3\u0000");
    private static final int[] ZZ_ACTION = ImportLexer.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0003\u0000\u0001\u0001\u0001\u0002\u0001\u0001\u0001\u0003\u0001\u0004\u0001\u0005\u0001\u0006\u0001\u0007\u0001\u0000\u0001\b\u0001\u0007\u0001\b";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unkown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[16384];
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private int yyline;
    private int yychar;
    private int yycolumn;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    private boolean zzEOFDone;

    private static int[] zzUnpackAction() {
        int[] result = new int[15];
        int offset = 0;
        offset = ImportLexer.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    static String[] lex(String source) throws LexerException {
        ImportLexer yy = new ImportLexer(new StringReader(source + ","));
        ArrayList<String> result = new ArrayList<String>();
        try {
            String s;
            while ((s = yy.yylex()) != null) {
                result.add(s);
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        return result.toArray(new String[result.size()]);
    }

    private static String unescape(String s) {
        if (s.indexOf("\"\"") == -1) {
            return s;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\"' && i < s.length() - 1 && s.charAt(i + 1) == '\"') {
                result.append('\"');
                ++i;
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    ImportLexer(Reader in) {
        this.zzReader = in;
    }

    ImportLexer(InputStream in) {
        this(new InputStreamReader(in));
    }

    private static char[] zzUnpackCMap(String packed) {
        char[] map = new char[65536];
        int i = 0;
        int j = 0;
        while (i < 20) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map[j++] = value;
            } while (--count > 0);
        }
        return map;
    }

    private boolean zzRefill() throws IOException {
        int numRead;
        if (this.zzStartRead > 0) {
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length) {
            char[] newBuffer = new char[this.zzCurrentPos * 2];
            System.arraycopy(this.zzBuffer, 0, newBuffer, 0, this.zzBuffer.length);
            this.zzBuffer = newBuffer;
        }
        if ((numRead = this.zzReader.read(this.zzBuffer, this.zzEndRead, this.zzBuffer.length - this.zzEndRead)) > 0) {
            this.zzEndRead += numRead;
            return false;
        }
        if (numRead == 0) {
            int c = this.zzReader.read();
            if (c == -1) {
                return true;
            }
            this.zzBuffer[this.zzEndRead++] = (char)c;
            return false;
        }
        return true;
    }

    public final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    public final void yyreset(Reader reader) {
        this.zzReader = reader;
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzEOFDone = false;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzMarkedPos = 0;
        this.zzCurrentPos = 0;
        this.yycolumn = 0;
        this.yychar = 0;
        this.yyline = 0;
        this.zzLexicalState = 0;
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer[this.zzStartRead + pos];
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    public String yylex() throws IOException, LexerException {
        int zzEndReadL = this.zzEndRead;
        char[] zzBufferL = this.zzBuffer;
        char[] zzCMapL = ZZ_CMAP;
        block72: while (true) {
            int zzInput;
            int zzMarkedPosL = this.zzMarkedPos;
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            int zzCurrentPosL = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            block73: while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = zzBufferL[zzCurrentPosL++];
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = zzBufferL[zzCurrentPosL++];
                }
                zzInput = zzCMapL[zzInput];
                boolean zzIsFinal = false;
                boolean zzNoLookAhead = false;
                block0 : switch (this.zzState) {
                    case 0: {
                        switch (zzInput) {
                            case 0: {
                                zzIsFinal = true;
                                this.zzState = 3;
                                break block0;
                            }
                            case 1: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 4;
                                break block0;
                            }
                            case 3: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 6;
                                break block0;
                            }
                        }
                        zzIsFinal = true;
                        this.zzState = 5;
                        break;
                    }
                    case 1: {
                        switch (zzInput) {
                            case 1: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 8;
                                break;
                            }
                            case 4: {
                                break block73;
                            }
                            default: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 7;
                                break;
                            }
                        }
                        break;
                    }
                    case 2: {
                        switch (zzInput) {
                            case 3: {
                                zzIsFinal = true;
                                this.zzState = 10;
                                break block0;
                            }
                            case 4: {
                                this.zzState = 11;
                                break block0;
                            }
                        }
                        zzIsFinal = true;
                        this.zzState = 9;
                        break;
                    }
                    case 3: {
                        switch (zzInput) {
                            case 1: 
                            case 3: {
                                break block73;
                            }
                            default: {
                                zzIsFinal = true;
                                break;
                            }
                        }
                        break;
                    }
                    case 5: {
                        switch (zzInput) {
                            case 0: {
                                zzIsFinal = true;
                                this.zzState = 3;
                                break;
                            }
                            case 3: {
                                zzIsFinal = true;
                                zzNoLookAhead = true;
                                this.zzState = 6;
                                break;
                            }
                            case 1: {
                                break block73;
                            }
                            default: {
                                zzIsFinal = true;
                                break;
                            }
                        }
                        break;
                    }
                    case 9: {
                        switch (zzInput) {
                            case 3: {
                                zzIsFinal = true;
                                this.zzState = 12;
                                break block0;
                            }
                        }
                        this.zzState = 11;
                        break;
                    }
                    case 10: {
                        switch (zzInput) {
                            case 3: {
                                this.zzState = 11;
                                break;
                            }
                            case 0: 
                            case 1: {
                                break block73;
                            }
                            default: {
                                zzIsFinal = true;
                                this.zzState = 13;
                                break;
                            }
                        }
                        break;
                    }
                    case 11: {
                        switch (zzInput) {
                            case 3: {
                                zzIsFinal = true;
                                this.zzState = 12;
                                break block0;
                            }
                        }
                        break;
                    }
                    case 12: {
                        switch (zzInput) {
                            case 3: {
                                this.zzState = 11;
                                break;
                            }
                            case 0: 
                            case 1: {
                                break block73;
                            }
                            default: {
                                zzIsFinal = true;
                                this.zzState = 14;
                                break;
                            }
                        }
                        break;
                    }
                    case 13: {
                        switch (zzInput) {
                            case 2: 
                            case 4: {
                                zzIsFinal = true;
                                break block0;
                            }
                        }
                        break block73;
                    }
                    case 14: {
                        switch (zzInput) {
                            case 2: 
                            case 4: {
                                zzIsFinal = true;
                                break block0;
                            }
                        }
                        break block73;
                    }
                    default: {
                        this.zzScanError(0);
                    }
                }
                if (!zzIsFinal) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if (zzNoLookAhead) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 6: {
                    throw new LexerException("Unclosed double quote");
                }
                case 9: {
                    continue block72;
                }
                case 3: {
                    this.yybegin(4);
                }
                case 10: {
                    continue block72;
                }
                case 7: {
                    this.yybegin(2);
                    return "";
                }
                case 11: {
                    continue block72;
                }
                case 5: {
                    this.yybegin(0);
                }
                case 12: {
                    continue block72;
                }
                case 1: {
                    this.yybegin(2);
                    return this.yytext().trim();
                }
                case 13: {
                    continue block72;
                }
                case 4: {
                    throw new LexerException("Quoted fields must be followed by comma or end of line");
                }
                case 14: {
                    continue block72;
                }
                case 2: {
                    return "";
                }
                case 15: {
                    continue block72;
                }
                case 8: {
                    this.yybegin(2);
                    String text = this.yytext();
                    return ImportLexer.unescape(text.substring(0, text.lastIndexOf(34)));
                }
                case 16: {
                    continue block72;
                }
            }
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                return null;
            }
            this.zzScanError(1);
        }
    }

    static class LexerException
    extends Exception {
        public LexerException(String details) {
            super(details);
        }
    }
}

