/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.pair;

import gnu.trove.list.array.TByteArrayList;
import gnu.trove.list.array.TDoubleArrayList;
import java.util.Comparator;

public class ByteDoublePair {
    public static final Comparator<ByteDoublePair> FIRST_ITEM_ASCENDING_COMPARATOR = new Comparator<ByteDoublePair>(){

        @Override
        public int compare(ByteDoublePair o1, ByteDoublePair o2) {
            if (o1.first < o2.first) {
                return -1;
            }
            if (o1.first > o2.first) {
                return 1;
            }
            return 0;
        }
    };
    public static final Comparator<ByteDoublePair> FIRST_ITEM_DESCENDING_COMPARATOR = new Comparator<ByteDoublePair>(){

        @Override
        public int compare(ByteDoublePair o1, ByteDoublePair o2) {
            if (o1.first < o2.first) {
                return 1;
            }
            if (o1.first > o2.first) {
                return -1;
            }
            return 0;
        }
    };
    public static final Comparator<ByteDoublePair> SECOND_ITEM_ASCENDING_COMPARATOR = new Comparator<ByteDoublePair>(){

        @Override
        public int compare(ByteDoublePair o1, ByteDoublePair o2) {
            if (o1.second < o2.second) {
                return -1;
            }
            if (o1.second > o2.second) {
                return 1;
            }
            return 0;
        }
    };
    public static final Comparator<ByteDoublePair> SECOND_ITEM_DESCENDING_COMPARATOR = new Comparator<ByteDoublePair>(){

        @Override
        public int compare(ByteDoublePair o1, ByteDoublePair o2) {
            if (o1.second < o2.second) {
                return 1;
            }
            if (o1.second > o2.second) {
                return -1;
            }
            return 0;
        }
    };
    public byte first;
    public double second;

    public ByteDoublePair(byte f, double s) {
        this.first = f;
        this.second = s;
    }

    public ByteDoublePair() {
    }

    public byte getFirst() {
        return this.first;
    }

    public void setFirst(byte first) {
        this.first = first;
    }

    public double getSecond() {
        return this.second;
    }

    public void setSecond(double second) {
        this.second = second;
    }

    public static ByteDoublePair pair(byte a, double b) {
        return new ByteDoublePair(a, b);
    }

    public static TDoubleArrayList getSecond(Iterable<ByteDoublePair> data) {
        TDoubleArrayList extracted = new TDoubleArrayList();
        for (ByteDoublePair item : data) {
            extracted.add(item.second);
        }
        return extracted;
    }

    public static TByteArrayList getFirst(Iterable<ByteDoublePair> data) {
        TByteArrayList extracted = new TByteArrayList();
        for (ByteDoublePair item : data) {
            extracted.add(item.first);
        }
        return extracted;
    }

    public String toString() {
        return "(" + this.first + ", " + this.second + ")";
    }
}

