/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.list;

import java.io.DataInput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Scanner;
import org.openimaj.data.RandomData;
import org.openimaj.io.Readable;
import org.openimaj.util.list.RandomisableList;

public abstract class AbstractFileBackedList<T extends Readable>
extends AbstractList<T>
implements RandomisableList<T>,
Cloneable {
    protected final int size;
    protected final Class<T> clz;
    protected final boolean isBinary;
    protected final int headerLength;
    protected final int recordLength;
    protected final File file;
    private int ascii_offset = 0;
    protected String charset;

    protected AbstractFileBackedList(int size, boolean isBinary, int headerLength, int recordLength, File file, Class<T> clz) {
        this.size = size;
        this.isBinary = isBinary;
        this.headerLength = headerLength;
        this.recordLength = recordLength;
        this.file = file;
        this.clz = clz;
        this.charset = Charset.defaultCharset().name();
    }

    protected AbstractFileBackedList(int size, boolean isBinary, int headerLength, int recordLength, File file, Class<T> clz, String charset) {
        this.size = size;
        this.isBinary = isBinary;
        this.headerLength = headerLength;
        this.recordLength = recordLength;
        this.file = file;
        this.clz = clz;
        this.charset = charset;
    }

    protected T newElementInstance() {
        try {
            return (T)((Readable)this.clz.newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected T readRecord(DataInput input) throws IOException {
        T element = this.newElementInstance();
        element.readBinary(input);
        return element;
    }

    protected T readRecordASCII(Scanner br) throws IOException {
        T element = this.newElementInstance();
        element.readASCII(br);
        return element;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object o) {
        for (Readable k : this) {
            if (!k.equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        if (this.isBinary) {
            return new FLBinaryIterator();
        }
        return new FLAsciiIterator();
    }

    @Override
    public <E> E[] toArray(E[] a) {
        if (a.length < this.size) {
            return Arrays.copyOf(this.toArray(), this.size, a.getClass());
        }
        int i = 0;
        for (Readable k : this) {
            a[i++] = k;
        }
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        ArrayList<Readable> seen = new ArrayList<Readable>();
        for (Readable k : this) {
            if (!c.contains(k)) continue;
            seen.add(k);
        }
        return seen.size() == c.size();
    }

    @Override
    public T get(int index) {
        if (index > this.size) {
            throw new IllegalArgumentException("Index out of bounds");
        }
        if (!this.isBinary) {
            int count = 0;
            for (Readable k : this) {
                if (count++ != index) continue;
                return (T)k;
            }
        } else {
            T t;
            long offset = index * this.recordLength + this.headerLength;
            RandomAccessFile raf = null;
            try {
                raf = new RandomAccessFile(this.file, "r");
                raf.seek(offset);
                t = this.readRecord(raf);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (raf != null) {
                    try {
                        raf.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return t;
        }
        return null;
    }

    @Override
    public T set(int index, T element) {
        throw new UnsupportedOperationException("Modifying a FileList isn't supported");
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException("Modifying a FileList isn't supported");
    }

    @Override
    public int indexOf(Object o) {
        int count = 0;
        for (Readable k : this) {
            if (o.equals(k)) {
                return count;
            }
            ++count;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        int count = 0;
        int found = -1;
        for (Readable k : this) {
            if (o.equals(k)) {
                found = count;
            }
            ++count;
        }
        return found;
    }

    protected abstract AbstractFileBackedList<T> newInstance(int var1, boolean var2, int var3, int var4, File var5);

    @Override
    public RandomisableList<T> subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || fromIndex > this.size || toIndex < 0 || toIndex > this.size) {
            throw new IllegalArgumentException("bad offsets");
        }
        if (!this.isBinary) {
            AbstractFileBackedList<T> fkl = this.newInstance(toIndex - fromIndex, this.isBinary, this.headerLength, this.recordLength, this.file);
            fkl.ascii_offset = this.ascii_offset + fromIndex;
            return fkl;
        }
        int newHeaderLength = this.headerLength + fromIndex * this.recordLength;
        int newSize = toIndex - fromIndex;
        AbstractFileBackedList<T> fkl = this.newInstance(newSize, this.isBinary, newHeaderLength, this.recordLength, this.file);
        return fkl;
    }

    @Override
    public RandomisableList<T> randomSubList(int nelem) {
        if (nelem > this.size()) {
            throw new IllegalArgumentException("number of requested elements is greater than the list size");
        }
        int[] indices = RandomData.getUniqueRandomInts(nelem, 0, this.size());
        return new FLRandomSubList(this.isBinary, this.headerLength, this.recordLength, this.file, indices, this.clz);
    }

    @Override
    public Object[] toArray() {
        Object[] objs = new Object[this.size()];
        int i = 0;
        for (Readable o : this) {
            objs[i++] = o;
        }
        return objs;
    }

    class FLRandomSubList
    extends AbstractFileBackedList<T> {
        protected final int[] indices;

        FLRandomSubList(boolean isBinary, int headerLength, int recordLength, File file, int[] indices, Class<T> clz) {
            super(indices.length, isBinary, headerLength, recordLength, file, clz);
            this.indices = indices;
        }

        @Override
        public int size() {
            return this.indices.length;
        }

        @Override
        public T get(int index) {
            return super.get(this.indices[index]);
        }

        @Override
        public RandomisableList<T> subList(int fromIndex, int toIndex) {
            if (fromIndex < 0 || fromIndex > this.size() || toIndex < 0 || toIndex > this.size()) {
                throw new IllegalArgumentException("bad offsets");
            }
            int[] newIndices = new int[toIndex - fromIndex];
            return new FLRandomSubList(this.isBinary, this.headerLength, this.recordLength, this.file, newIndices, this.clz);
        }

        @Override
        public Iterator<T> iterator() {
            if (this.isBinary) {
                return new FLRandomBinaryIterator();
            }
            return new FLRandomAsciiIterator();
        }

        @Override
        public RandomisableList<T> randomSubList(int nelem) {
            if (nelem > this.size()) {
                throw new IllegalArgumentException("number of requested elements is greater than the list size");
            }
            int[] newindices = RandomData.getUniqueRandomInts(nelem, 0, this.size());
            for (int i = 0; i < newindices.length; ++i) {
                newindices[i] = this.indices[newindices[i]];
            }
            return new FLRandomSubList(this.isBinary, this.headerLength, this.recordLength, this.file, newindices, this.clz);
        }

        @Override
        public T readRecord(DataInput input) throws IOException {
            return AbstractFileBackedList.this.readRecord(input);
        }

        @Override
        public T readRecordASCII(Scanner br) throws IOException {
            return AbstractFileBackedList.this.readRecordASCII(br);
        }

        @Override
        protected AbstractFileBackedList<T> newInstance(int newSize, boolean isBinary, int newHeaderLength, int recordLength, File file) {
            return AbstractFileBackedList.this.newInstance(newSize, isBinary, newHeaderLength, recordLength, file);
        }

        class FLRandomAsciiIterator
        extends FLAsciiIterator {
            FLRandomAsciiIterator() {
            }

            @Override
            public T next() {
                try {
                    if (this.count >= FLRandomSubList.this.indices.length) {
                        return null;
                    }
                    int offset = 0;
                    if (this.count > 0) {
                        offset = FLRandomSubList.this.indices[this.count] - FLRandomSubList.this.indices[this.count - 1];
                    }
                    if (offset < 0) {
                        this.reset();
                        offset = FLRandomSubList.this.indices[this.count];
                    }
                    for (int i = 0; i < offset - 1; ++i) {
                        FLRandomSubList.this.readRecordASCII(this.br);
                    }
                    Object k = FLRandomSubList.this.readRecordASCII(this.br);
                    ++this.count;
                    return k;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        class FLRandomBinaryIterator
        extends FLBinaryIterator {
            FLRandomBinaryIterator() {
            }

            @Override
            public T next() {
                try {
                    if (this.count >= FLRandomSubList.this.indices.length) {
                        return null;
                    }
                    int idx = FLRandomSubList.this.indices[this.count];
                    this.raf.seek(FLRandomSubList.this.headerLength + idx * FLRandomSubList.this.recordLength);
                    Object k = FLRandomSubList.this.readRecord(this.raf);
                    ++this.count;
                    return k;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    class FLAsciiIterator
    implements Iterator<T> {
        protected int count = 0;
        protected Scanner br;

        FLAsciiIterator() {
            this.reset();
            for (int i = 0; i < AbstractFileBackedList.this.ascii_offset; ++i) {
                this.next();
            }
            this.count = 0;
        }

        protected void reset() {
            try {
                this.close();
                FileInputStream fis = new FileInputStream(AbstractFileBackedList.this.file);
                this.br = new Scanner((InputStream)fis, AbstractFileBackedList.this.charset);
                for (int i = 0; i < AbstractFileBackedList.this.headerLength; ++i) {
                    this.br.nextLine();
                }
            }
            catch (IOException e) {
                this.close();
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.count < AbstractFileBackedList.this.size()) {
                return true;
            }
            this.close();
            return false;
        }

        protected void close() {
            if (this.br != null) {
                this.br.close();
                this.br = null;
            }
        }

        @Override
        public T next() {
            try {
                if (this.br == null) {
                    return null;
                }
                Object k = AbstractFileBackedList.this.readRecordASCII(this.br);
                ++this.count;
                return k;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Modifying a FileList isn't supported");
        }

        public void finalize() {
            this.close();
        }
    }

    class FLBinaryIterator
    implements Iterator<T> {
        protected int count = 0;
        protected RandomAccessFile raf;

        FLBinaryIterator() {
            try {
                this.raf = new RandomAccessFile(AbstractFileBackedList.this.file, "r");
                this.raf.seek(AbstractFileBackedList.this.headerLength);
            }
            catch (IOException e) {
                this.close();
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.count < AbstractFileBackedList.this.size()) {
                return true;
            }
            this.close();
            return false;
        }

        protected void close() {
            if (this.raf != null) {
                try {
                    this.raf.close();
                    this.raf = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        @Override
        public T next() {
            try {
                if (this.raf == null) {
                    return null;
                }
                Object k = AbstractFileBackedList.this.readRecord(this.raf);
                ++this.count;
                return k;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Modifying a FileKeypointList isn't supported");
        }

        public void finalize() {
            this.close();
        }
    }
}

