/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.array;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.openimaj.util.array.SparseDoubleArray;

public class SparseBinSearchDoubleArray
extends SparseDoubleArray {
    protected int[] keys;
    protected double[] values;
    protected int used;

    public SparseBinSearchDoubleArray(double[] values) {
        this(values.length);
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == 0.0) continue;
            this.set(i, values[i]);
        }
    }

    public SparseBinSearchDoubleArray(int length, int used, int[] keys, double[] values) {
        if (length < 0) {
            throw new IllegalArgumentException("length must be >= 0");
        }
        if (length < values.length) {
            throw new IllegalArgumentException("length is shorter than number of current values!");
        }
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Number of keys does not match number of values.");
        }
        this.length = length;
        this.used = used;
        this.keys = keys;
        this.values = values;
    }

    public SparseBinSearchDoubleArray(int length) {
        this(length, 10);
    }

    public SparseBinSearchDoubleArray(int length, int capacity) {
        if (length < 0) {
            throw new IllegalArgumentException("length must be >= 0");
        }
        if (capacity <= 0) {
            throw new IllegalArgumentException("capacity must be > 0");
        }
        this.length = length;
        this.keys = new int[capacity];
        this.values = new double[capacity];
    }

    public SparseBinSearchDoubleArray(int length, float density) {
        if (length < 0) {
            throw new IllegalArgumentException("length must be >= 0");
        }
        if (density <= 0.0f || density > 1.0f) {
            throw new IllegalArgumentException("density must be > 0 and < 1");
        }
        this.length = length;
        int capacity = (int)(density * (float)length);
        this.keys = new int[capacity];
        this.values = new double[capacity];
    }

    @Override
    public int[] indices() {
        return Arrays.copyOf(this.keys, this.used);
    }

    @Override
    public double[] values() {
        return Arrays.copyOf(this.values, this.used);
    }

    @Override
    public Iterable<SparseDoubleArray.DualEntry> unionEntries(SparseDoubleArray otherArray) {
        if (otherArray instanceof SparseBinSearchDoubleArray) {
            return this.unionEntries((SparseBinSearchDoubleArray)otherArray);
        }
        return super.unionEntries(otherArray);
    }

    public Iterable<SparseDoubleArray.DualEntry> unionEntries(final SparseBinSearchDoubleArray otherArray) {
        return new Iterable<SparseDoubleArray.DualEntry>(){

            @Override
            public Iterator<SparseDoubleArray.DualEntry> iterator() {
                return new Iterator<SparseDoubleArray.DualEntry>(){
                    private SparseDoubleArray.DualEntry entry = new SparseDoubleArray.DualEntry();
                    private int innerIndex = 0;
                    private int otherInnerIndex = 0;

                    @Override
                    public boolean hasNext() {
                        return this.innerIndex < SparseBinSearchDoubleArray.this.used || this.otherInnerIndex < otherArray.used;
                    }

                    @Override
                    public SparseDoubleArray.DualEntry next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        if (this.innerIndex < SparseBinSearchDoubleArray.this.used && (this.otherInnerIndex >= otherArray.used || SparseBinSearchDoubleArray.this.keys[this.innerIndex] < otherArray.keys[this.otherInnerIndex])) {
                            this.entry.index = SparseBinSearchDoubleArray.this.keys[this.innerIndex];
                            this.entry.value = SparseBinSearchDoubleArray.this.values[this.innerIndex];
                            this.entry.otherValue = 0.0;
                            ++this.innerIndex;
                        } else if (this.otherInnerIndex < otherArray.used && (this.innerIndex >= SparseBinSearchDoubleArray.this.used || SparseBinSearchDoubleArray.this.keys[this.innerIndex] > otherArray.keys[this.otherInnerIndex])) {
                            this.entry.index = otherArray.keys[this.otherInnerIndex];
                            this.entry.value = 0.0;
                            this.entry.otherValue = otherArray.values[this.otherInnerIndex];
                            ++this.otherInnerIndex;
                        } else {
                            this.entry.index = SparseBinSearchDoubleArray.this.keys[this.innerIndex];
                            this.entry.value = SparseBinSearchDoubleArray.this.values[this.innerIndex];
                            this.entry.otherValue = otherArray.values[this.otherInnerIndex];
                            ++this.innerIndex;
                            ++this.otherInnerIndex;
                        }
                        return this.entry;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public Iterable<SparseDoubleArray.Entry> entries() {
        return new Iterable<SparseDoubleArray.Entry>(){

            @Override
            public Iterator<SparseDoubleArray.Entry> iterator() {
                return new Iterator<SparseDoubleArray.Entry>(){
                    private SparseDoubleArray.Entry entry = new SparseDoubleArray.Entry();
                    private int innerIndex = 0;

                    @Override
                    public boolean hasNext() {
                        return this.innerIndex < SparseBinSearchDoubleArray.this.used;
                    }

                    @Override
                    public SparseDoubleArray.Entry next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        this.entry.index = SparseBinSearchDoubleArray.this.keys[this.innerIndex];
                        this.entry.value = SparseBinSearchDoubleArray.this.values[this.innerIndex];
                        ++this.innerIndex;
                        return this.entry;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SparseBinSearchDoubleArray)) {
            return false;
        }
        return this.length == ((SparseBinSearchDoubleArray)obj).length && this.used == ((SparseBinSearchDoubleArray)obj).used && Arrays.equals(this.keys, ((SparseBinSearchDoubleArray)obj).keys) && Arrays.equals(this.values, this.values);
    }

    @Override
    public double get(int key) {
        if (key < 0 || key >= this.length) {
            throw new IndexOutOfBoundsException(Integer.toString(key));
        }
        int spot = Arrays.binarySearch(this.keys, 0, this.used, key);
        return spot < 0 ? 0.0 : this.values[spot];
    }

    public int hashCode() {
        return this.length ^ Arrays.hashCode(this.keys) ^ Arrays.hashCode(this.values);
    }

    @Override
    public boolean isUsed(int key) {
        return 0 <= Arrays.binarySearch(this.keys, 0, this.used, key);
    }

    @Override
    public double set(int key, double value) {
        if (key < 0 || key >= this.length) {
            throw new IndexOutOfBoundsException(Integer.toString(key));
        }
        int spot = Arrays.binarySearch(this.keys, 0, this.used, key);
        if (spot >= 0) {
            this.values[spot] = value;
            return this.values[spot];
        }
        return this.update(-1 - spot, key, value);
    }

    @Override
    public double increment(int key, double value) {
        if (key < 0 || key >= this.length) {
            throw new IndexOutOfBoundsException(Integer.toString(key));
        }
        int spot = Arrays.binarySearch(this.keys, 0, this.used, key);
        if (spot >= 0) {
            int n = spot;
            double d = this.values[n] + value;
            this.values[n] = d;
            return d;
        }
        return this.update(-1 - spot, key, value);
    }

    private double update(int spot, int key, double value) {
        if (this.used == this.keys.length) {
            int capacity = this.keys.length * 3 / 2 + 1;
            this.keys = Arrays.copyOf(this.keys, capacity);
            this.values = Arrays.copyOf(this.values, capacity);
        }
        if (spot < this.used) {
            System.arraycopy(this.keys, spot, this.keys, spot + 1, this.used - spot);
            System.arraycopy(this.values, spot, this.values, spot + 1, this.used - spot);
        }
        ++this.used;
        this.keys[spot] = key;
        this.values[spot] = value;
        return this.values[spot];
    }

    @Override
    public int used() {
        return this.used;
    }

    @Override
    public void compact() {
        this.keys = Arrays.copyOf(this.keys, this.used);
        this.values = Arrays.copyOf(this.values, this.used);
    }

    @Override
    public SparseDoubleArray copy() {
        SparseBinSearchDoubleArray copy = new SparseBinSearchDoubleArray(this.length);
        copy.used = this.used;
        copy.keys = Arrays.copyOf(this.keys, this.keys.length);
        copy.values = Arrays.copyOf(this.values, this.values.length);
        return copy;
    }

    @Override
    public SparseDoubleArray reverse() {
        int len = this.used;
        int hlen = len / 2;
        for (int i = 0; i < hlen; ++i) {
            double tmpVal = this.values[i];
            this.values[i] = this.values[len - i - 1];
            this.values[len - i - 1] = tmpVal;
            int tmpKey = this.keys[i];
            this.keys[i] = this.length - this.keys[len - i - 1];
            this.keys[len - i - 1] = this.length - tmpKey;
        }
        return this;
    }
}

