/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.array;

public class LongArrayView
implements Cloneable {
    private long[] array;
    private int l;
    private int r;

    public LongArrayView(long[] array, int l, int r) {
        this.array = array;
        this.l = l;
        this.r = r;
    }

    public LongArrayView(long[] array) {
        this(array, 0, array.length);
    }

    public LongArrayView(int n) {
        this(new long[n], 0, n);
    }

    public LongArrayView subView(int l1, int r1) {
        if (this.l + l1 < 0 || this.l + r1 > this.r) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return new LongArrayView(this.array, this.l + l1, this.l + r1);
    }

    public long get(int i) {
        int idx = i + this.l;
        if (idx < 0 || idx >= this.r) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.array[idx];
    }

    public long getFast(int i) {
        return this.array[i + this.l];
    }

    public void set(int i, long v) {
        int idx = i + this.l;
        if (idx < 0 || idx >= this.r) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.array[idx] = v;
    }

    public void setFast(int i, long v) {
        this.array[i + this.l] = v;
    }

    public long[] getUnderlyingStorage() {
        return this.array;
    }

    public int size() {
        return this.r - this.l;
    }

    public long[] toArray() {
        long[] a = new long[this.r - this.l];
        System.arraycopy(this.array, this.l, a, 0, this.r - this.l);
        return a;
    }

    public String toString() {
        String s = "[";
        for (int i = this.l; i < this.r - 1; ++i) {
            s = s + this.array[i] + ",";
        }
        s = s + this.array[this.r - 1] + "]";
        return s;
    }

    public LongArrayView clone() {
        return new LongArrayView(this.toArray());
    }
}

