/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.io.wrappers;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Scanner;
import org.openimaj.io.ReadWriteable;

public class ReadWriteableString
implements ReadWriteable {
    public String value;

    public ReadWriteableString(String value) {
        this.value = value;
    }

    public ReadWriteableString() {
        this.value = "";
    }

    @Override
    public void readBinary(DataInput in) throws IOException {
        this.value = in.readUTF();
    }

    @Override
    public void readASCII(Scanner in) throws IOException {
        int len = in.nextInt();
        this.value = in.next(".{" + len + "}");
    }

    @Override
    public byte[] binaryHeader() {
        return new byte[0];
    }

    @Override
    public String asciiHeader() {
        return "";
    }

    @Override
    public void writeBinary(DataOutput out) throws IOException {
        out.writeUTF(this.value);
    }

    @Override
    public void writeASCII(PrintWriter out) throws IOException {
        out.format("%d %s\n", this.value.length(), this.value);
    }

    public boolean equals(Object o) {
        return o instanceof ReadWriteableString && ((ReadWriteableString)o).value.equals(this.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

