/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.io;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Scanner;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;
import org.openimaj.io.InputStreamObjectReader;
import org.openimaj.io.InternalReadable;
import org.openimaj.io.ObjectReader;
import org.openimaj.io.ObjectWrapper;
import org.openimaj.io.ReadableASCII;
import org.openimaj.io.ReadableBinary;
import org.openimaj.io.WriteableASCII;
import org.openimaj.io.WriteableBinary;

public class IOUtils {
    public static <T extends InternalReadable> T newInstance(Class<T> cls) {
        try {
            return (T)((InternalReadable)cls.newInstance());
        }
        catch (Exception e) {
            try {
                Constructor<T> constr = cls.getDeclaredConstructor(new Class[0]);
                if (constr != null) {
                    constr.setAccessible(true);
                    return (T)((InternalReadable)constr.newInstance(new Object[0]));
                }
            }
            catch (Exception e1) {
                throw new RuntimeException(e);
            }
            throw new RuntimeException(e);
        }
    }

    public static <T extends InternalReadable> T newInstance(String className) {
        try {
            return (T)IOUtils.newInstance(Class.forName(className));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends InternalReadable> T read(File f) throws IOException {
        ObjectWrapper ow = (ObjectWrapper)((Object)IOUtils.read(f, ObjectWrapper.class));
        return (T)((InternalReadable)ow.object);
    }

    public static <T extends InternalReadable> T read(File f, String charset) throws IOException {
        ObjectWrapper ow = (ObjectWrapper)((Object)IOUtils.read(f, ObjectWrapper.class, charset));
        return (T)((InternalReadable)ow.object);
    }

    public static <T extends WriteableBinary> void writeBinaryFull(File f, T object) throws IOException {
        IOUtils.writeBinary(f, new ObjectWrapper(object));
    }

    public static <T extends WriteableASCII> void writeASCIIFull(File f, T object) throws IOException {
        IOUtils.writeASCII(f, new ObjectWrapper(object));
    }

    public static <T extends WriteableASCII> void writeASCIIFull(File f, T object, String charset) throws IOException {
        IOUtils.writeASCII(f, new ObjectWrapper(object), charset);
    }

    public static <T extends InternalReadable> T read(File f, Class<T> cls) throws IOException {
        return IOUtils.read(f, IOUtils.newInstance(cls));
    }

    public static <T extends InternalReadable> T read(File f, Class<T> cls, String charset) throws IOException {
        return IOUtils.read(f, IOUtils.newInstance(cls), charset);
    }

    public static <T extends InternalReadable> T read(InputStream ios, Class<T> cls) throws IOException {
        return IOUtils.read(ios, IOUtils.newInstance(cls));
    }

    public static <T extends InternalReadable> T read(InputStream ios, Class<T> cls, String charset) throws IOException {
        return IOUtils.read(ios, IOUtils.newInstance(cls), charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends InternalReadable> T read(File f, T obj) throws IOException {
        try (FileInputStream fos = new FileInputStream(f);){
            T t = IOUtils.read((InputStream)fos, obj);
            return t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends InternalReadable> T read(File f, T obj, String charset) throws IOException {
        try (FileInputStream fos = new FileInputStream(f);){
            T t = IOUtils.read((InputStream)fos, obj, charset);
            return t;
        }
    }

    public static <T extends InternalReadable> T read(InputStream fis, T obj) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(fis);
        if (obj instanceof ReadableBinary && IOUtils.isBinary(bis, ((ReadableBinary)obj).binaryHeader())) {
            byte[] header = new byte[((ReadableBinary)obj).binaryHeader().length];
            bis.read(header, 0, header.length);
            ((ReadableBinary)obj).readBinary(new DataInputStream(bis));
            return obj;
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(bis));
        char[] holder = new char[((ReadableASCII)obj).asciiHeader().length()];
        br.read(holder);
        ((ReadableASCII)obj).readASCII(new Scanner(br));
        return obj;
    }

    public static <T extends InternalReadable> T read(InputStream fis, T obj, String charset) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(fis);
        if (obj instanceof ReadableBinary && IOUtils.isBinary(bis, ((ReadableBinary)obj).binaryHeader())) {
            byte[] header = new byte[((ReadableBinary)obj).binaryHeader().length];
            bis.read(header, 0, header.length);
            ((ReadableBinary)obj).readBinary(new DataInputStream(bis));
            return obj;
        }
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)bis, charset));
        char[] holder = new char[((ReadableASCII)obj).asciiHeader().length()];
        br.read(holder);
        ((ReadableASCII)obj).readASCII(new Scanner(br));
        return obj;
    }

    public static <T extends InternalReadable> T read(Reader fis, T obj) throws IOException {
        BufferedReader br = new BufferedReader(fis);
        char[] holder = new char[((ReadableASCII)obj).asciiHeader().length()];
        br.read(holder);
        ((ReadableASCII)obj).readASCII(new Scanner(br));
        return obj;
    }

    public static <T extends InternalReadable> T read(Reader fis, Class<T> cls) throws IOException {
        return IOUtils.read(fis, IOUtils.newInstance(cls));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isBinary(File f, byte[] header) throws IOException {
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        try {
            fis = new FileInputStream(f);
            bis = new BufferedInputStream(fis);
            boolean bl = IOUtils.isBinary(bis, header);
            return bl;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static <T extends ReadableBinary> boolean isBinary(BufferedInputStream bis, T obj) throws IOException {
        return IOUtils.isBinary(bis, obj.binaryHeader());
    }

    public static boolean isBinary(BufferedInputStream bis, byte[] header) throws IOException {
        bis.mark(header.length + 10);
        byte[] aheader = new byte[header.length];
        bis.read(aheader, 0, aheader.length);
        bis.reset();
        return Arrays.equals(aheader, header);
    }

    public static <T extends WriteableBinary> void writeBinary(File f, T obj) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(f);){
            IOUtils.writeBinary(fos, obj);
            fos.flush();
        }
    }

    public static <T extends WriteableBinary> void writeBinary(OutputStream fos, T obj) throws IOException {
        BufferedOutputStream bos = null;
        try {
            bos = new BufferedOutputStream(fos);
            IOUtils.writeBinary(bos, obj);
        }
        finally {
            if (bos != null) {
                bos.flush();
            }
        }
    }

    public static <T extends WriteableBinary> void writeBinary(BufferedOutputStream bos, T obj) throws IOException {
        DataOutputStream dos = new DataOutputStream(bos);
        dos.write(obj.binaryHeader());
        obj.writeBinary(dos);
    }

    public static <T extends WriteableASCII> void writeASCII(File f, T obj) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(f);){
            IOUtils.writeASCII(fos, obj);
            fos.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends WriteableASCII> void writeASCII(File f, T obj, String charset) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(f);){
            IOUtils.writeASCII(fos, obj, charset);
            fos.flush();
        }
    }

    public static <T extends WriteableASCII> void writeASCII(OutputStream fos, T obj) throws IOException {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(fos);
            pw.print(obj.asciiHeader());
            obj.writeASCII(pw);
        }
        finally {
            if (pw != null) {
                pw.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends WriteableASCII> void writeASCII(OutputStream fos, T obj, String charset) throws IOException {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(fos, charset)));
            pw.print(obj.asciiHeader());
            obj.writeASCII(pw);
        }
        finally {
            if (pw != null) {
                pw.flush();
            }
        }
    }

    public static <T extends WriteableASCII> void writeASCII(Writer writer, T obj) throws IOException {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(writer);
            pw.print(obj.asciiHeader());
            obj.writeASCII(pw);
        }
        finally {
            if (pw != null) {
                pw.flush();
            }
        }
    }

    public static <T extends InternalReadable> boolean readable(File f, Class<T> cls) throws IOException {
        T obj = IOUtils.newInstance(cls);
        return obj instanceof ReadableBinary && IOUtils.readable(f, ((ReadableBinary)obj).binaryHeader()) || obj instanceof ReadableASCII && IOUtils.readable(f, ((ReadableASCII)obj).asciiHeader());
    }

    public static boolean readable(File f, String header) throws IOException {
        return IOUtils.readable(f, header.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean readable(File f, byte[] header) throws IOException {
        FileInputStream fos = null;
        try {
            fos = new FileInputStream(f);
            BufferedInputStream bis = new BufferedInputStream(fos);
            boolean bl = IOUtils.isBinary(bis, header);
            return bl;
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static <T extends InternalReadable> boolean readable(BufferedInputStream bis, Class<T> cls) throws IOException {
        T obj = IOUtils.newInstance(cls);
        return obj instanceof ReadableBinary && IOUtils.readable(bis, ((ReadableBinary)obj).binaryHeader()) || obj instanceof ReadableASCII && IOUtils.readable(bis, ((ReadableASCII)obj).asciiHeader());
    }

    public static boolean readable(BufferedInputStream bis, String header) throws IOException {
        return IOUtils.readable(bis, header.getBytes());
    }

    public static boolean readable(BufferedInputStream bis, byte[] header) throws IOException {
        return IOUtils.isBinary(bis, header);
    }

    public static byte[] serialize(WriteableBinary object) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        IOUtils.writeBinary(stream, object);
        return stream.toByteArray();
    }

    public static <T extends ReadableASCII> T fromString(String source, Class<T> clazz) throws IOException {
        ReadableASCII out = (ReadableASCII)((Object)IOUtils.read((InputStream)new ByteArrayInputStream(source.getBytes()), clazz));
        return (T)out;
    }

    public static <T extends ReadableBinary> T deserialize(byte[] source, Class<T> clazz) throws IOException {
        ByteArrayInputStream stream = new ByteArrayInputStream(source);
        ReadableBinary out = (ReadableBinary)((Object)IOUtils.read((InputStream)stream, clazz));
        return (T)out;
    }

    public static <T extends ReadableBinary> T deserialize(byte[] source, long skip, Class<T> clazz) throws IOException {
        ByteArrayInputStream stream = new ByteArrayInputStream(source);
        stream.skip(skip);
        ReadableBinary out = (ReadableBinary)((Object)IOUtils.read((InputStream)stream, clazz));
        return (T)out;
    }

    public static <T extends InternalReadable> T deserialize(byte[] source, T instance) throws IOException {
        ByteArrayInputStream stream = new ByteArrayInputStream(source);
        T out = IOUtils.read((InputStream)stream, instance);
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(Object obj, File out) throws IOException {
        FilterOutputStream dos = null;
        try {
            dos = new DataOutputStream(new FileOutputStream(out));
            IOUtils.write(obj, (DataOutput)((Object)dos));
        }
        finally {
            if (dos != null) {
                try {
                    dos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void write(Object obj, DataOutput out) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Output output = new Output((OutputStream)bos);
        Kryo kryo = new Kryo();
        kryo.writeClassAndObject(output, obj);
        output.flush();
        byte[] array = bos.toByteArray();
        out.writeInt(array.length);
        out.write(array);
    }

    public static <T> T read(DataInput in) throws IOException {
        Object obj;
        int length = in.readInt();
        byte[] bytes = new byte[length];
        in.readFully(bytes);
        Kryo kryo = new Kryo();
        try {
            obj = kryo.readClassAndObject(new Input(bytes));
        }
        catch (KryoException e) {
            kryo.setInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy());
            obj = kryo.readClassAndObject(new Input(bytes));
        }
        return (T)obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T readFromFile(File in) throws IOException {
        FilterInputStream din = null;
        din = new DataInputStream(new FileInputStream(in));
        T t = IOUtils.read((DataInput)((Object)din));
        return t;
        finally {
            if (din != null) {
                try {
                    din.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canRead(InputStreamObjectReader<?> reader, BufferedInputStream is, String name) throws IOException {
        try {
            is.mark(0x100000);
            boolean bl = reader.canRead(is, name);
            return bl;
        }
        finally {
            is.reset();
        }
    }

    public static <SRC> boolean canRead(ObjectReader<?, SRC> reader, SRC source, String name) throws IOException {
        return reader.canRead(source, name);
    }
}

