/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.scene.control.skin.TreeTableRowSkin;
import java.lang.ref.WeakReference;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ListChangeListener;
import javafx.collections.WeakListChangeListener;
import javafx.css.PseudoClass;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.Skin;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTablePosition;
import javafx.scene.control.TreeTableView;

public class TreeTableRow<T>
extends IndexedCell<T> {
    private final ListChangeListener<Integer> selectedListener = c -> this.updateSelection();
    private final InvalidationListener focusedListener = valueModel -> this.updateFocus();
    private final InvalidationListener editingListener = valueModel -> this.updateEditing();
    private final InvalidationListener leafListener = new InvalidationListener(){

        @Override
        public void invalidated(Observable valueModel) {
            TreeItem treeItem = TreeTableRow.this.getTreeItem();
            if (treeItem != null) {
                TreeTableRow.this.requestLayout();
            }
        }
    };
    private boolean oldExpanded;
    private final InvalidationListener treeItemExpandedInvalidationListener = o -> {
        boolean expanded = ((BooleanProperty)o).get();
        this.pseudoClassStateChanged(EXPANDED_PSEUDOCLASS_STATE, expanded);
        this.pseudoClassStateChanged(COLLAPSED_PSEUDOCLASS_STATE, !expanded);
        if (expanded != this.oldExpanded) {
            this.notifyAccessibleAttributeChanged(AccessibleAttribute.EXPANDED);
        }
        this.oldExpanded = expanded;
    };
    private final WeakListChangeListener<Integer> weakSelectedListener = new WeakListChangeListener<Integer>(this.selectedListener);
    private final WeakInvalidationListener weakFocusedListener = new WeakInvalidationListener(this.focusedListener);
    private final WeakInvalidationListener weakEditingListener = new WeakInvalidationListener(this.editingListener);
    private final WeakInvalidationListener weakLeafListener = new WeakInvalidationListener(this.leafListener);
    private final WeakInvalidationListener weakTreeItemExpandedInvalidationListener = new WeakInvalidationListener(this.treeItemExpandedInvalidationListener);
    private ReadOnlyObjectWrapper<TreeItem<T>> treeItem = new ReadOnlyObjectWrapper<TreeItem<T>>(this, "treeItem"){
        TreeItem<T> oldValue;
        {
            this.oldValue = null;
        }

        @Override
        protected void invalidated() {
            if (this.oldValue != null) {
                this.oldValue.expandedProperty().removeListener(TreeTableRow.this.weakTreeItemExpandedInvalidationListener);
            }
            this.oldValue = (TreeItem)this.get();
            if (this.oldValue != null) {
                TreeTableRow.this.oldExpanded = this.oldValue.isExpanded();
                this.oldValue.expandedProperty().addListener(TreeTableRow.this.weakTreeItemExpandedInvalidationListener);
                TreeTableRow.this.weakTreeItemExpandedInvalidationListener.invalidated(this.oldValue.expandedProperty());
            }
        }
    };
    private ObjectProperty<Node> disclosureNode = new SimpleObjectProperty<Node>(this, "disclosureNode");
    private ReadOnlyObjectWrapper<TreeTableView<T>> treeTableView = new ReadOnlyObjectWrapper<TreeTableView<T>>(this, "treeTableView"){
        private WeakReference<TreeTableView<T>> weakTreeTableViewRef;

        @Override
        protected void invalidated() {
            TreeTableView.TreeTableViewFocusModel fm;
            TreeTableView.TreeTableViewSelectionModel sm;
            if (this.weakTreeTableViewRef != null) {
                TreeTableView oldTreeTableView = (TreeTableView)this.weakTreeTableViewRef.get();
                if (oldTreeTableView != null) {
                    sm = oldTreeTableView.getSelectionModel();
                    if (sm != null) {
                        sm.getSelectedIndices().removeListener(TreeTableRow.this.weakSelectedListener);
                    }
                    if ((fm = oldTreeTableView.getFocusModel()) != null) {
                        fm.focusedIndexProperty().removeListener(TreeTableRow.this.weakFocusedListener);
                    }
                    oldTreeTableView.editingCellProperty().removeListener(TreeTableRow.this.weakEditingListener);
                }
                this.weakTreeTableViewRef = null;
            }
            if (this.get() != null) {
                sm = ((TreeTableView)this.get()).getSelectionModel();
                if (sm != null) {
                    sm.getSelectedIndices().addListener(TreeTableRow.this.weakSelectedListener);
                }
                if ((fm = ((TreeTableView)this.get()).getFocusModel()) != null) {
                    fm.focusedIndexProperty().addListener(TreeTableRow.this.weakFocusedListener);
                }
                ((TreeTableView)this.get()).editingCellProperty().addListener(TreeTableRow.this.weakEditingListener);
                this.weakTreeTableViewRef = new WeakReference(this.get());
            }
            TreeTableRow.this.updateItem();
            TreeTableRow.this.requestLayout();
        }
    };
    private int index = -1;
    private boolean isFirstRun = true;
    private static final String DEFAULT_STYLE_CLASS = "tree-table-row-cell";
    private static final PseudoClass EXPANDED_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("expanded");
    private static final PseudoClass COLLAPSED_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("collapsed");

    public TreeTableRow() {
        this.getStyleClass().addAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        this.setAccessibleRole(AccessibleRole.TREE_TABLE_ROW);
    }

    private void setTreeItem(TreeItem<T> value) {
        this.treeItem.set(value);
    }

    public final TreeItem<T> getTreeItem() {
        return (TreeItem)this.treeItem.get();
    }

    public final ReadOnlyObjectProperty<TreeItem<T>> treeItemProperty() {
        return this.treeItem.getReadOnlyProperty();
    }

    public final void setDisclosureNode(Node value) {
        this.disclosureNodeProperty().set(value);
    }

    public final Node getDisclosureNode() {
        return (Node)this.disclosureNode.get();
    }

    public final ObjectProperty<Node> disclosureNodeProperty() {
        return this.disclosureNode;
    }

    private void setTreeTableView(TreeTableView<T> value) {
        this.treeTableView.set(value);
    }

    public final TreeTableView<T> getTreeTableView() {
        return (TreeTableView)this.treeTableView.get();
    }

    public final ReadOnlyObjectProperty<TreeTableView<T>> treeTableViewProperty() {
        return this.treeTableView.getReadOnlyProperty();
    }

    @Override
    void indexChanged(int oldIndex, int newIndex) {
        this.index = this.getIndex();
        this.updateItem();
        this.updateSelection();
        this.updateFocus();
    }

    @Override
    public void startEdit() {
        TreeTableView<T> treeTable = this.getTreeTableView();
        if (!this.isEditable() || treeTable != null && !treeTable.isEditable()) {
            return;
        }
        super.startEdit();
        if (treeTable != null) {
            treeTable.fireEvent(new TreeTableView.EditEvent<Object>((TreeTableView<Object>)treeTable, TreeTableView.editStartEvent(), (TreeItem<Object>)this.getTreeItem(), this.getItem(), null));
            treeTable.requestFocus();
        }
    }

    @Override
    public void commitEdit(T newValue) {
        if (!this.isEditing()) {
            return;
        }
        TreeItem<T> treeItem = this.getTreeItem();
        TreeTableView<T> treeTable = this.getTreeTableView();
        if (treeTable != null) {
            treeTable.fireEvent(new TreeTableView.EditEvent<T>(treeTable, TreeTableView.editCommitEvent(), treeItem, this.getItem(), newValue));
        }
        if (treeItem != null) {
            treeItem.setValue(newValue);
            this.updateTreeItem(treeItem);
            this.updateItem(newValue, false);
        }
        super.commitEdit(newValue);
        if (treeTable != null) {
            treeTable.edit(-1, null);
            treeTable.requestFocus();
        }
    }

    @Override
    public void cancelEdit() {
        if (!this.isEditing()) {
            return;
        }
        TreeTableView<T> treeTable = this.getTreeTableView();
        if (treeTable != null) {
            treeTable.fireEvent(new TreeTableView.EditEvent<Object>((TreeTableView<Object>)treeTable, TreeTableView.editCancelEvent(), (TreeItem<Object>)this.getTreeItem(), this.getItem(), null));
        }
        super.cancelEdit();
        if (treeTable != null) {
            treeTable.edit(-1, null);
            treeTable.requestFocus();
        }
    }

    private void updateItem() {
        TreeTableView<T> tv = this.getTreeTableView();
        if (tv == null) {
            return;
        }
        boolean valid = this.index >= 0 && this.index < tv.getExpandedItemCount();
        TreeItem<T> oldTreeItem = this.getTreeItem();
        boolean isEmpty = this.isEmpty();
        if (valid) {
            TreeItem<T> newTreeItem = tv.getTreeItem(this.index);
            Object newValue = newTreeItem == null ? null : (Object)newTreeItem.getValue();
            this.updateTreeItem(newTreeItem);
            this.updateItem(newValue, false);
        } else if (!isEmpty && oldTreeItem != null || this.isFirstRun) {
            this.updateTreeItem(null);
            this.updateItem(null, true);
            this.isFirstRun = false;
        }
    }

    private void updateSelection() {
        if (this.isEmpty()) {
            return;
        }
        if (this.index == -1 || this.getTreeTableView() == null) {
            return;
        }
        if (this.getTreeTableView().getSelectionModel() == null) {
            return;
        }
        boolean isSelected = this.getTreeTableView().getSelectionModel().isSelected(this.index);
        if (this.isSelected() == isSelected) {
            return;
        }
        this.updateSelected(isSelected);
    }

    private void updateFocus() {
        if (this.getIndex() == -1 || this.getTreeTableView() == null) {
            return;
        }
        if (this.getTreeTableView().getFocusModel() == null) {
            return;
        }
        this.setFocused(this.getTreeTableView().getFocusModel().isFocused(this.getIndex()));
    }

    private void updateEditing() {
        TreeItem<T> editItem;
        if (this.getIndex() == -1 || this.getTreeTableView() == null || this.getTreeItem() == null) {
            return;
        }
        TreeTablePosition<T, ?> editingCell = this.getTreeTableView().getEditingCell();
        if (editingCell != null && editingCell.getTableColumn() != null) {
            return;
        }
        TreeItem<T> treeItem = editItem = editingCell == null ? null : editingCell.getTreeItem();
        if (!this.isEditing() && this.getTreeItem().equals(editItem)) {
            this.startEdit();
        } else if (this.isEditing() && !this.getTreeItem().equals(editItem)) {
            this.cancelEdit();
        }
    }

    public final void updateTreeTableView(TreeTableView<T> treeTable) {
        this.setTreeTableView(treeTable);
    }

    public final void updateTreeItem(TreeItem<T> treeItem) {
        TreeItem<T> _treeItem = this.getTreeItem();
        if (_treeItem != null) {
            _treeItem.leafProperty().removeListener(this.weakLeafListener);
        }
        this.setTreeItem(treeItem);
        if (treeItem != null) {
            treeItem.leafProperty().addListener(this.weakLeafListener);
        }
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new TreeTableRowSkin(this);
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
        TreeItem<T> treeItem = this.getTreeItem();
        TreeTableView<T> treeTableView = this.getTreeTableView();
        switch (attribute) {
            case TREE_ITEM_PARENT: {
                if (treeItem == null) {
                    return null;
                }
                TreeItem<T> parent = treeItem.getParent();
                if (parent == null) {
                    return null;
                }
                int parentIndex = treeTableView.getRow(parent);
                return treeTableView.queryAccessibleAttribute(AccessibleAttribute.ROW_AT_INDEX, parentIndex);
            }
            case TREE_ITEM_COUNT: {
                if (treeItem == null) {
                    return 0;
                }
                if (!treeItem.isExpanded()) {
                    return 0;
                }
                return treeItem.getChildren().size();
            }
            case TREE_ITEM_AT_INDEX: {
                if (treeItem == null) {
                    return null;
                }
                if (!treeItem.isExpanded()) {
                    return null;
                }
                int index = (Integer)parameters[0];
                if (index >= treeItem.getChildren().size()) {
                    return null;
                }
                TreeItem child = (TreeItem)treeItem.getChildren().get(index);
                if (child == null) {
                    return null;
                }
                int childIndex = treeTableView.getRow(child);
                return treeTableView.queryAccessibleAttribute(AccessibleAttribute.ROW_AT_INDEX, childIndex);
            }
            case LEAF: {
                return treeItem == null ? true : treeItem.isLeaf();
            }
            case EXPANDED: {
                return treeItem == null ? false : treeItem.isExpanded();
            }
            case INDEX: {
                return this.getIndex();
            }
            case DISCLOSURE_LEVEL: {
                return treeTableView == null ? 0 : treeTableView.getTreeItemLevel(treeItem);
            }
        }
        return super.queryAccessibleAttribute(attribute, parameters);
    }

    @Override
    public void executeAccessibleAction(AccessibleAction action, Object ... parameters) {
        switch (action) {
            case EXPAND: {
                TreeItem<T> treeItem = this.getTreeItem();
                if (treeItem == null) break;
                treeItem.setExpanded(true);
                break;
            }
            case COLLAPSE: {
                TreeItem<T> treeItem = this.getTreeItem();
                if (treeItem == null) break;
                treeItem.setExpanded(false);
                break;
            }
            default: {
                super.executeAccessibleAction(action, new Object[0]);
            }
        }
    }
}

