/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.application.PlatformImpl;
import com.sun.javafx.css.CssError;
import com.sun.javafx.css.StyleManager;
import com.sun.javafx.css.converters.StringConverter;
import com.sun.javafx.scene.control.Logging;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.application.Application;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.StringProperty;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableSet;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.css.StyleableStringProperty;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.Skinnable;
import javafx.scene.layout.Pane;
import javafx.stage.PopupWindow;
import javafx.stage.Window;
import sun.util.logging.PlatformLogger;

public class PopupControl
extends PopupWindow
implements Skinnable,
Styleable {
    public static final double USE_PREF_SIZE = Double.NEGATIVE_INFINITY;
    public static final double USE_COMPUTED_SIZE = -1.0;
    protected CSSBridge bridge;
    private final ObjectProperty<Skin<?>> skin = new ObjectPropertyBase<Skin<?>>(){
        private Skin<?> oldValue;

        @Override
        public void set(Skin<?> v) {
            if (v == null ? this.oldValue == null : this.oldValue != null && v.getClass().equals(this.oldValue.getClass())) {
                return;
            }
            super.set(v);
        }

        @Override
        protected void invalidated() {
            Skin skin = (Skin)this.get();
            PopupControl.this.currentSkinClassName = skin == null ? null : skin.getClass().getName();
            PopupControl.this.skinClassNameProperty().set(PopupControl.this.currentSkinClassName);
            if (this.oldValue != null) {
                this.oldValue.dispose();
            }
            this.oldValue = (Skin)this.getValue();
            PopupControl.this.prefWidthCache = -1.0;
            PopupControl.this.prefHeightCache = -1.0;
            PopupControl.this.minWidthCache = -1.0;
            PopupControl.this.minHeightCache = -1.0;
            PopupControl.this.maxWidthCache = -1.0;
            PopupControl.this.maxHeightCache = -1.0;
            PopupControl.this.skinSizeComputed = false;
            Node n = PopupControl.this.getSkinNode();
            if (n != null) {
                PopupControl.this.bridge.getChildren().setAll((Node[])new Node[]{n});
            } else {
                PopupControl.this.bridge.getChildren().clear();
            }
            PopupControl.this.bridge.impl_reapplyCSS();
            PlatformLogger logger = Logging.getControlsLogger();
            if (logger.isLoggable(PlatformLogger.Level.FINEST)) {
                logger.finest("Stored skin[" + this.getValue() + "] on " + this);
            }
        }

        @Override
        public Object getBean() {
            return PopupControl.this;
        }

        @Override
        public String getName() {
            return "skin";
        }
    };
    private String currentSkinClassName = null;
    private StringProperty skinClassName = null;
    private DoubleProperty minWidth;
    private DoubleProperty minHeight;
    private DoubleProperty prefWidth;
    private DoubleProperty prefHeight;
    private DoubleProperty maxWidth;
    private DoubleProperty maxHeight;
    private double prefWidthCache = -1.0;
    private double prefHeightCache = -1.0;
    private double minWidthCache = -1.0;
    private double minHeightCache = -1.0;
    private double maxWidthCache = -1.0;
    private double maxHeightCache = -1.0;
    private boolean skinSizeComputed = false;
    private static final CssMetaData<CSSBridge, String> SKIN;
    private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

    public PopupControl() {
        this.bridge = new CSSBridge();
        this.setAnchorLocation(PopupWindow.AnchorLocation.CONTENT_TOP_LEFT);
        this.getContent().add(this.bridge);
    }

    public final StringProperty idProperty() {
        return this.bridge.idProperty();
    }

    public final void setId(String value) {
        this.idProperty().set(value);
    }

    @Override
    public final String getId() {
        return (String)this.idProperty().get();
    }

    @Override
    public final ObservableList<String> getStyleClass() {
        return this.bridge.getStyleClass();
    }

    public final void setStyle(String value) {
        this.styleProperty().set(value);
    }

    @Override
    public final String getStyle() {
        return (String)this.styleProperty().get();
    }

    public final StringProperty styleProperty() {
        return this.bridge.styleProperty();
    }

    @Override
    public final ObjectProperty<Skin<?>> skinProperty() {
        return this.skin;
    }

    @Override
    public final void setSkin(Skin<?> value) {
        this.skinProperty().setValue(value);
    }

    @Override
    public final Skin<?> getSkin() {
        return (Skin)this.skinProperty().getValue();
    }

    private StringProperty skinClassNameProperty() {
        if (this.skinClassName == null) {
            this.skinClassName = new StyleableStringProperty(){

                @Override
                public void set(String v) {
                    if (v == null || v.isEmpty() || v.equals(this.get())) {
                        return;
                    }
                    super.set(v);
                }

                @Override
                public void invalidated() {
                    if (this.get() != null && !this.get().equals(PopupControl.this.currentSkinClassName)) {
                        Control.loadSkinClass(PopupControl.this, this.get());
                    }
                }

                @Override
                public Object getBean() {
                    return PopupControl.this;
                }

                @Override
                public String getName() {
                    return "skinClassName";
                }

                @Override
                public CssMetaData<CSSBridge, String> getCssMetaData() {
                    return SKIN;
                }
            };
        }
        return this.skinClassName;
    }

    private Node getSkinNode() {
        return this.getSkin() == null ? null : this.getSkin().getNode();
    }

    public final void setMinWidth(double value) {
        this.minWidthProperty().set(value);
    }

    public final double getMinWidth() {
        return this.minWidth == null ? -1.0 : this.minWidth.get();
    }

    public final DoubleProperty minWidthProperty() {
        if (this.minWidth == null) {
            this.minWidth = new DoublePropertyBase(-1.0){

                @Override
                public void invalidated() {
                    if (PopupControl.this.isShowing()) {
                        PopupControl.this.bridge.requestLayout();
                    }
                }

                @Override
                public Object getBean() {
                    return PopupControl.this;
                }

                @Override
                public String getName() {
                    return "minWidth";
                }
            };
        }
        return this.minWidth;
    }

    public final void setMinHeight(double value) {
        this.minHeightProperty().set(value);
    }

    public final double getMinHeight() {
        return this.minHeight == null ? -1.0 : this.minHeight.get();
    }

    public final DoubleProperty minHeightProperty() {
        if (this.minHeight == null) {
            this.minHeight = new DoublePropertyBase(-1.0){

                @Override
                public void invalidated() {
                    if (PopupControl.this.isShowing()) {
                        PopupControl.this.bridge.requestLayout();
                    }
                }

                @Override
                public Object getBean() {
                    return PopupControl.this;
                }

                @Override
                public String getName() {
                    return "minHeight";
                }
            };
        }
        return this.minHeight;
    }

    public void setMinSize(double minWidth, double minHeight) {
        this.setMinWidth(minWidth);
        this.setMinHeight(minHeight);
    }

    public final void setPrefWidth(double value) {
        this.prefWidthProperty().set(value);
    }

    public final double getPrefWidth() {
        return this.prefWidth == null ? -1.0 : this.prefWidth.get();
    }

    public final DoubleProperty prefWidthProperty() {
        if (this.prefWidth == null) {
            this.prefWidth = new DoublePropertyBase(-1.0){

                @Override
                public void invalidated() {
                    if (PopupControl.this.isShowing()) {
                        PopupControl.this.bridge.requestLayout();
                    }
                }

                @Override
                public Object getBean() {
                    return PopupControl.this;
                }

                @Override
                public String getName() {
                    return "prefWidth";
                }
            };
        }
        return this.prefWidth;
    }

    public final void setPrefHeight(double value) {
        this.prefHeightProperty().set(value);
    }

    public final double getPrefHeight() {
        return this.prefHeight == null ? -1.0 : this.prefHeight.get();
    }

    public final DoubleProperty prefHeightProperty() {
        if (this.prefHeight == null) {
            this.prefHeight = new DoublePropertyBase(-1.0){

                @Override
                public void invalidated() {
                    if (PopupControl.this.isShowing()) {
                        PopupControl.this.bridge.requestLayout();
                    }
                }

                @Override
                public Object getBean() {
                    return PopupControl.this;
                }

                @Override
                public String getName() {
                    return "prefHeight";
                }
            };
        }
        return this.prefHeight;
    }

    public void setPrefSize(double prefWidth, double prefHeight) {
        this.setPrefWidth(prefWidth);
        this.setPrefHeight(prefHeight);
    }

    public final void setMaxWidth(double value) {
        this.maxWidthProperty().set(value);
    }

    public final double getMaxWidth() {
        return this.maxWidth == null ? -1.0 : this.maxWidth.get();
    }

    public final DoubleProperty maxWidthProperty() {
        if (this.maxWidth == null) {
            this.maxWidth = new DoublePropertyBase(-1.0){

                @Override
                public void invalidated() {
                    if (PopupControl.this.isShowing()) {
                        PopupControl.this.bridge.requestLayout();
                    }
                }

                @Override
                public Object getBean() {
                    return PopupControl.this;
                }

                @Override
                public String getName() {
                    return "maxWidth";
                }
            };
        }
        return this.maxWidth;
    }

    public final void setMaxHeight(double value) {
        this.maxHeightProperty().set(value);
    }

    public final double getMaxHeight() {
        return this.maxHeight == null ? -1.0 : this.maxHeight.get();
    }

    public final DoubleProperty maxHeightProperty() {
        if (this.maxHeight == null) {
            this.maxHeight = new DoublePropertyBase(-1.0){

                @Override
                public void invalidated() {
                    if (PopupControl.this.isShowing()) {
                        PopupControl.this.bridge.requestLayout();
                    }
                }

                @Override
                public Object getBean() {
                    return PopupControl.this;
                }

                @Override
                public String getName() {
                    return "maxHeight";
                }
            };
        }
        return this.maxHeight;
    }

    public void setMaxSize(double maxWidth, double maxHeight) {
        this.setMaxWidth(maxWidth);
        this.setMaxHeight(maxHeight);
    }

    public final double minWidth(double height) {
        double override = this.getMinWidth();
        if (override == -1.0) {
            if (this.minWidthCache == -1.0) {
                this.minWidthCache = this.recalculateMinWidth(height);
            }
            return this.minWidthCache;
        }
        if (override == Double.NEGATIVE_INFINITY) {
            return this.prefWidth(height);
        }
        return override;
    }

    public final double minHeight(double width) {
        double override = this.getMinHeight();
        if (override == -1.0) {
            if (this.minHeightCache == -1.0) {
                this.minHeightCache = this.recalculateMinHeight(width);
            }
            return this.minHeightCache;
        }
        if (override == Double.NEGATIVE_INFINITY) {
            return this.prefHeight(width);
        }
        return override;
    }

    public final double prefWidth(double height) {
        double override = this.getPrefWidth();
        if (override == -1.0) {
            if (this.prefWidthCache == -1.0) {
                this.prefWidthCache = this.recalculatePrefWidth(height);
            }
            return this.prefWidthCache;
        }
        if (override == Double.NEGATIVE_INFINITY) {
            return this.prefWidth(height);
        }
        return override;
    }

    public final double prefHeight(double width) {
        double override = this.getPrefHeight();
        if (override == -1.0) {
            if (this.prefHeightCache == -1.0) {
                this.prefHeightCache = this.recalculatePrefHeight(width);
            }
            return this.prefHeightCache;
        }
        if (override == Double.NEGATIVE_INFINITY) {
            return this.prefHeight(width);
        }
        return override;
    }

    public final double maxWidth(double height) {
        double override = this.getMaxWidth();
        if (override == -1.0) {
            if (this.maxWidthCache == -1.0) {
                this.maxWidthCache = this.recalculateMaxWidth(height);
            }
            return this.maxWidthCache;
        }
        if (override == Double.NEGATIVE_INFINITY) {
            return this.prefWidth(height);
        }
        return override;
    }

    public final double maxHeight(double width) {
        double override = this.getMaxHeight();
        if (override == -1.0) {
            if (this.maxHeightCache == -1.0) {
                this.maxHeightCache = this.recalculateMaxHeight(width);
            }
            return this.maxHeightCache;
        }
        if (override == Double.NEGATIVE_INFINITY) {
            return this.prefHeight(width);
        }
        return override;
    }

    private double recalculateMinWidth(double height) {
        this.recomputeSkinSize();
        return this.getSkinNode() == null ? 0.0 : this.getSkinNode().minWidth(height);
    }

    private double recalculateMinHeight(double width) {
        this.recomputeSkinSize();
        return this.getSkinNode() == null ? 0.0 : this.getSkinNode().minHeight(width);
    }

    private double recalculateMaxWidth(double height) {
        this.recomputeSkinSize();
        return this.getSkinNode() == null ? 0.0 : this.getSkinNode().maxWidth(height);
    }

    private double recalculateMaxHeight(double width) {
        this.recomputeSkinSize();
        return this.getSkinNode() == null ? 0.0 : this.getSkinNode().maxHeight(width);
    }

    private double recalculatePrefWidth(double height) {
        this.recomputeSkinSize();
        return this.getSkinNode() == null ? 0.0 : this.getSkinNode().prefWidth(height);
    }

    private double recalculatePrefHeight(double width) {
        this.recomputeSkinSize();
        return this.getSkinNode() == null ? 0.0 : this.getSkinNode().prefHeight(width);
    }

    private void recomputeSkinSize() {
        if (!this.skinSizeComputed) {
            this.bridge.applyCss();
            this.skinSizeComputed = true;
        }
    }

    protected Skin<?> createDefaultSkin() {
        return null;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return PopupControl.getClassCssMetaData();
    }

    public final void pseudoClassStateChanged(PseudoClass pseudoClass, boolean active) {
        this.bridge.pseudoClassStateChanged(pseudoClass, active);
    }

    @Override
    public String getTypeSelector() {
        return "PopupControl";
    }

    @Override
    public Styleable getStyleableParent() {
        Scene ownerScene;
        Node ownerNode = this.getOwnerNode();
        if (ownerNode != null) {
            return ownerNode;
        }
        Window ownerWindow = this.getOwnerWindow();
        if (ownerWindow != null && (ownerScene = ownerWindow.getScene()) != null) {
            return ownerScene.getRoot();
        }
        return this.bridge.getParent();
    }

    @Override
    public final ObservableSet<PseudoClass> getPseudoClassStates() {
        return FXCollections.emptyObservableSet();
    }

    @Deprecated
    public Node impl_styleableGetNode() {
        return this.bridge;
    }

    static {
        if (Application.getUserAgentStylesheet() == null) {
            PlatformImpl.setDefaultPlatformUserAgentStylesheet();
        }
        SKIN = new CssMetaData<CSSBridge, String>("-fx-skin", StringConverter.getInstance()){

            @Override
            public boolean isSettable(CSSBridge cssBridge) {
                return !cssBridge.popupControl.skinProperty().isBound();
            }

            @Override
            public StyleableProperty<String> getStyleableProperty(CSSBridge cssBridge) {
                return (StyleableProperty)((Object)cssBridge.popupControl.skinClassNameProperty());
            }
        };
        ArrayList styleables = new ArrayList();
        Collections.addAll(styleables, SKIN);
        STYLEABLES = Collections.unmodifiableList(styleables);
    }

    protected class CSSBridge
    extends Pane {
        private final PopupControl popupControl;

        protected CSSBridge() {
            this.popupControl = PopupControl.this;
        }

        @Override
        public void requestLayout() {
            PopupControl.this.prefWidthCache = -1.0;
            PopupControl.this.prefHeightCache = -1.0;
            PopupControl.this.minWidthCache = -1.0;
            PopupControl.this.minHeightCache = -1.0;
            PopupControl.this.maxWidthCache = -1.0;
            PopupControl.this.maxHeightCache = -1.0;
            super.requestLayout();
        }

        @Override
        public Styleable getStyleableParent() {
            return PopupControl.this.getStyleableParent();
        }

        @Deprecated
        protected void setSkinClassName(String skinClassName) {
        }

        @Override
        public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
            return PopupControl.this.getCssMetaData();
        }

        @Override
        @Deprecated
        public List<String> impl_getAllParentStylesheets() {
            Styleable styleable = this.getStyleableParent();
            if (styleable instanceof Parent) {
                return ((Parent)styleable).impl_getAllParentStylesheets();
            }
            return null;
        }

        @Override
        @Deprecated
        protected void impl_processCSS(WritableValue<Boolean> unused) {
            super.impl_processCSS(unused);
            if (PopupControl.this.getSkin() == null) {
                Skin<?> defaultSkin = PopupControl.this.createDefaultSkin();
                if (defaultSkin != null) {
                    PopupControl.this.skinProperty().set(defaultSkin);
                    super.impl_processCSS(unused);
                } else {
                    String msg = "The -fx-skin property has not been defined in CSS for " + this + " and createDefaultSkin() returned null.";
                    ObservableList<CssError> errors = StyleManager.getErrors();
                    if (errors != null) {
                        CssError error = new CssError(msg);
                        errors.add(error);
                    }
                    Logging.getControlsLogger().severe(msg);
                }
            }
        }
    }
}

