/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.webkit.prism;

import com.sun.javafx.geom.Arc2D;
import com.sun.javafx.geom.Ellipse2D;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.PathIterator;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.RoundRectangle2D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.prism.BasicStroke;
import com.sun.webkit.graphics.WCPath;
import com.sun.webkit.graphics.WCPathIterator;
import com.sun.webkit.graphics.WCRectangle;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

final class WCPathImpl
extends WCPath<Path2D> {
    private final Path2D path;
    private boolean hasCP = false;
    private static final Logger log = Logger.getLogger(WCPathImpl.class.getName());

    WCPathImpl() {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Create empty WCPathImpl({0})", this.getID());
        }
        this.path = new Path2D();
    }

    WCPathImpl(WCPathImpl wcp) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Create WCPathImpl({0}) from WCPathImpl({1})", new Object[]{this.getID(), wcp.getID()});
        }
        this.path = new Path2D(wcp.path);
        this.hasCP = wcp.hasCP;
    }

    @Override
    public void addRect(double x, double y, double w, double h) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "WCPathImpl({0}).addRect({1},{2},{3},{4})", new Object[]{this.getID(), x, y, w, h});
        }
        this.hasCP = true;
        this.path.append(new RoundRectangle2D((float)x, (float)y, (float)w, (int)h, 0.0f, 0.0f), false);
    }

    @Override
    public void addEllipse(double x, double y, double w, double h) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "WCPathImpl({0}).addEllipse({1},{2},{3},{4})", new Object[]{this.getID(), x, y, w, h});
        }
        this.hasCP = true;
        this.path.append(new Ellipse2D((float)x, (float)y, (float)w, (float)h), false);
    }

    @Override
    public void addArcTo(double x1, double y1, double x2, double y2, double r) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "WCPathImpl({0}).addArcTo({1},{2},{3},{4})", new Object[]{this.getID(), x1, y1, x2, y2});
        }
        Arc2D arc = new Arc2D();
        arc.setArcByTangent(this.path.getCurrentPoint(), new Point2D((float)x1, (float)y1), new Point2D((float)x2, (float)y2), (float)r);
        this.hasCP = true;
        this.path.append(arc, true);
    }

    @Override
    public void addArc(double x, double y, double r, double sa, double ea, boolean aclockwise) {
        float TWO_PI = (float)Math.PI * 2;
        float startAngle = (float)sa;
        float endAngle = (float)ea;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "WCPathImpl({0}).addArc(x={1},y={2},r={3},sa=|{4}|,ea=|{5}|,aclock={6})", new Object[]{this.getID(), x, y, r, Float.valueOf(startAngle), Float.valueOf(endAngle), aclockwise});
        }
        this.hasCP = true;
        float newEndAngle = endAngle;
        if (!aclockwise && startAngle > endAngle) {
            newEndAngle = startAngle + ((float)Math.PI * 2 - (startAngle - endAngle) % ((float)Math.PI * 2));
        } else if (aclockwise && startAngle < endAngle) {
            newEndAngle = startAngle - ((float)Math.PI * 2 - (endAngle - startAngle) % ((float)Math.PI * 2));
        }
        this.path.append(new Arc2D((float)(x - r), (float)(y - r), (float)(2.0 * r), (float)(2.0 * r), (float)Math.toDegrees(-startAngle), (float)Math.toDegrees(startAngle - newEndAngle), 0), true);
    }

    @Override
    public boolean contains(int rule, double x, double y) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "WCPathImpl({0}).contains({1},{2},{3})", new Object[]{this.getID(), rule, x, y});
        }
        int savedRule = this.path.getWindingRule();
        this.path.setWindingRule(rule);
        boolean res = this.path.contains((float)x, (float)y);
        this.path.setWindingRule(savedRule);
        return res;
    }

    @Override
    public WCRectangle getBounds() {
        RectBounds b = this.path.getBounds();
        return new WCRectangle(b.getMinX(), b.getMinY(), b.getWidth(), b.getHeight());
    }

    @Override
    public void clear() {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "WCPathImpl({0}).clear()", this.getID());
        }
        this.hasCP = false;
        this.path.reset();
    }

    @Override
    public void moveTo(double x, double y) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "WCPathImpl({0}).moveTo({1},{2})", new Object[]{this.getID(), x, y});
        }
        this.hasCP = true;
        this.path.moveTo((float)x, (float)y);
    }

    @Override
    public void addLineTo(double x, double y) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "WCPathImpl({0}).addLineTo({1},{2})", new Object[]{this.getID(), x, y});
        }
        this.hasCP = true;
        this.path.lineTo((float)x, (float)y);
    }

    @Override
    public void addQuadCurveTo(double x0, double y0, double x1, double y1) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "WCPathImpl({0}).addQuadCurveTo({1},{2},{3},{4})", new Object[]{this.getID(), x0, y0, x1, y1});
        }
        this.hasCP = true;
        this.path.quadTo((float)x0, (float)y0, (float)x1, (float)y1);
    }

    @Override
    public void addBezierCurveTo(double x0, double y0, double x1, double y1, double x2, double y2) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "WCPathImpl({0}).addBezierCurveTo({1},{2},{3},{4},{5},{6})", new Object[]{this.getID(), x0, y0, x1, y1, x2, y2});
        }
        this.hasCP = true;
        this.path.curveTo((float)x0, (float)y0, (float)x1, (float)y1, (float)x2, (float)y2);
    }

    @Override
    public void addPath(WCPath p) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "WCPathImpl({0}).addPath({1})", new Object[]{this.getID(), p.getID()});
        }
        this.hasCP = this.hasCP || ((WCPathImpl)p).hasCP;
        this.path.append(((WCPathImpl)p).path, false);
    }

    @Override
    public void closeSubpath() {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "WCPathImpl({0}).closeSubpath()", this.getID());
        }
        this.path.closePath();
    }

    @Override
    public boolean hasCurrentPoint() {
        return this.hasCP;
    }

    @Override
    public boolean isEmpty() {
        PathIterator pi = this.path.getPathIterator(null);
        float[] coords = new float[6];
        while (!pi.isDone()) {
            switch (pi.currentSegment(coords)) {
                case 1: 
                case 2: 
                case 3: {
                    return false;
                }
            }
            pi.next();
        }
        return true;
    }

    @Override
    public int getWindingRule() {
        return 1 - this.path.getWindingRule();
    }

    @Override
    public void setWindingRule(int rule) {
        this.path.setWindingRule(1 - rule);
    }

    @Override
    public Path2D getPlatformPath() {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "WCPathImpl({0}).getPath() BEGIN=====", this.getID());
            PathIterator pi = this.path.getPathIterator(null);
            float[] coords = new float[6];
            while (!pi.isDone()) {
                switch (pi.currentSegment(coords)) {
                    case 0: {
                        log.log(Level.FINE, "SEG_MOVETO ({0},{1})", new Object[]{Float.valueOf(coords[0]), Float.valueOf(coords[1])});
                        break;
                    }
                    case 1: {
                        log.log(Level.FINE, "SEG_LINETO ({0},{1})", new Object[]{Float.valueOf(coords[0]), Float.valueOf(coords[1])});
                        break;
                    }
                    case 2: {
                        log.log(Level.FINE, "SEG_QUADTO ({0},{1},{2},{3})", new Object[]{Float.valueOf(coords[0]), Float.valueOf(coords[1]), Float.valueOf(coords[2]), Float.valueOf(coords[3])});
                        break;
                    }
                    case 3: {
                        log.log(Level.FINE, "SEG_CUBICTO ({0},{1},{2},{3},{4},{5})", new Object[]{Float.valueOf(coords[0]), Float.valueOf(coords[1]), Float.valueOf(coords[2]), Float.valueOf(coords[3]), Float.valueOf(coords[4]), Float.valueOf(coords[5])});
                        break;
                    }
                    case 4: {
                        log.fine("SEG_CLOSE");
                    }
                }
                pi.next();
            }
            log.fine("========getPath() END=====");
        }
        return this.path;
    }

    @Override
    public WCPathIterator getPathIterator() {
        final PathIterator pi = this.path.getPathIterator(null);
        return new WCPathIterator(){

            @Override
            public int getWindingRule() {
                return pi.getWindingRule();
            }

            @Override
            public boolean isDone() {
                return pi.isDone();
            }

            @Override
            public void next() {
                pi.next();
            }

            @Override
            public int currentSegment(double[] coords) {
                float[] _coords = new float[6];
                int segmentType = pi.currentSegment(_coords);
                for (int i = 0; i < coords.length; ++i) {
                    coords[i] = _coords[i];
                }
                return segmentType;
            }
        };
    }

    @Override
    public void translate(double x, double y) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "WCPathImpl({0}).translate({1}, {2})", new Object[]{this.getID(), x, y});
        }
        this.path.transform(BaseTransform.getTranslateInstance(x, y));
    }

    @Override
    public void transform(double mxx, double myx, double mxy, double myy, double mxt, double myt) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "WCPathImpl({0}).transform({1},{2},{3},{4},{5},{6})", new Object[]{this.getID(), mxx, myx, mxy, myy, mxt, myt});
        }
        this.path.transform(BaseTransform.getInstance(mxx, myx, mxy, myy, mxt, myt));
    }

    @Override
    public boolean strokeContains(double x, double y, double thickness, double miterLimit, int cap, int join, double dashOffset, double[] dashArray) {
        BasicStroke stroke = new BasicStroke((float)thickness, cap, join, (float)miterLimit);
        if (dashArray.length > 0) {
            stroke.set(dashArray, (float)dashOffset);
        }
        boolean result = stroke.createCenteredStrokedShape(this.path).contains((float)x, (float)y);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "WCPathImpl({0}).strokeContains({1},{2},{3},{4},{5},{6},{7},{8}) = {9}", new Object[]{this.getID(), x, y, thickness, miterLimit, cap, join, dashOffset, Arrays.toString(dashArray), result});
        }
        return result;
    }
}

