/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.TwoLevelFocusBehavior;
import com.sun.javafx.scene.traversal.Direction;
import javafx.beans.value.ChangeListener;
import javafx.event.Event;
import javafx.event.EventDispatcher;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.PopupControl;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;

public class TwoLevelFocusPopupBehavior
extends TwoLevelFocusBehavior {
    final EventDispatcher preemptiveEventDispatcher = (event, tail) -> {
        if (event instanceof KeyEvent && event.getEventType() == KeyEvent.KEY_PRESSED && !((KeyEvent)event).isMetaDown() && !((KeyEvent)event).isControlDown() && !((KeyEvent)event).isAltDown() && this.isExternalFocus()) {
            EventTarget obj = event.getTarget();
            switch (((KeyEvent)event).getCode()) {
                case TAB: {
                    if (((KeyEvent)event).isShiftDown()) {
                        ((Node)obj).impl_traverse(Direction.PREVIOUS);
                    } else {
                        ((Node)obj).impl_traverse(Direction.NEXT);
                    }
                    event.consume();
                    break;
                }
                case UP: {
                    ((Node)obj).impl_traverse(Direction.UP);
                    event.consume();
                    break;
                }
                case DOWN: {
                    ((Node)obj).impl_traverse(Direction.DOWN);
                    event.consume();
                    break;
                }
                case LEFT: {
                    ((Node)obj).impl_traverse(Direction.LEFT);
                    event.consume();
                    break;
                }
                case RIGHT: {
                    ((Node)obj).impl_traverse(Direction.RIGHT);
                    event.consume();
                    break;
                }
                case ENTER: {
                    this.setExternalFocus(false);
                    event.consume();
                    break;
                }
                default: {
                    Scene s = this.tlNode.getScene();
                    Event.fireEvent(s, event);
                    event.consume();
                }
            }
        }
        return event;
    };
    final EventDispatcher preemptivePopupEventDispatcher = (event, tail) -> {
        if (!(!(event instanceof KeyEvent) || event.getEventType() != KeyEvent.KEY_PRESSED || ((KeyEvent)event).isMetaDown() || ((KeyEvent)event).isControlDown() || ((KeyEvent)event).isAltDown() || this.isExternalFocus())) {
            EventTarget obj = event.getTarget();
            switch (((KeyEvent)event).getCode()) {
                case TAB: 
                case ENTER: {
                    event.consume();
                    break;
                }
                case UP: 
                case DOWN: {
                    break;
                }
                case LEFT: {
                    Node node;
                    if (obj instanceof Node) {
                        ((Node)obj).impl_traverse(Direction.LEFT);
                        event.consume();
                        break;
                    }
                    if (!(obj instanceof Scene) || (node = ((Scene)obj).getFocusOwner()) == null) break;
                    node.impl_traverse(Direction.LEFT);
                    event.consume();
                    break;
                }
                case RIGHT: {
                    Node node;
                    if (obj instanceof Node) {
                        ((Node)obj).impl_traverse(Direction.RIGHT);
                        event.consume();
                        break;
                    }
                    if (!(obj instanceof Scene) || (node = ((Scene)obj).getFocusOwner()) == null) break;
                    node.impl_traverse(Direction.RIGHT);
                    event.consume();
                    break;
                }
                default: {
                    Scene s = null;
                    if (this.tlNode != null) {
                        s = this.tlNode.getScene();
                        Event.fireEvent(s, event);
                    }
                    event.consume();
                }
            }
        }
        return event;
    };
    final EventDispatcher tlfEventDispatcher = (event, tail) -> {
        if (event instanceof KeyEvent) {
            if (this.isExternalFocus()) {
                tail = tail.prepend(this.preemptiveEventDispatcher);
                return tail.dispatchEvent(event);
            }
            tail = tail.prepend(this.preemptivePopupEventDispatcher);
            tail = tail.prepend(this.origEventDispatcher);
            return tail.dispatchEvent(event);
        }
        return this.origEventDispatcher.dispatchEvent(event, tail);
    };
    private final EventHandler<KeyEvent> keyEventListener = e -> this.postDispatchTidyup(e);
    final ChangeListener<Boolean> focusListener;
    private final EventHandler<MouseEvent> mouseEventListener;

    public TwoLevelFocusPopupBehavior(PopupControl popup) {
        this.focusListener = (observable, oldVal, newVal) -> {};
        this.mouseEventListener = e -> this.setExternalFocus(false);
        this.tlPopup = popup;
        this.setExternalFocus(false);
        this.tlPopup.addEventHandler(KeyEvent.ANY, this.keyEventListener);
        this.tlPopup.addEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseEventListener);
        this.tlPopup.focusedProperty().addListener(this.focusListener);
        this.origEventDispatcher = this.tlPopup.getEventDispatcher();
        this.tlPopup.setEventDispatcher(this.tlfEventDispatcher);
    }

    public TwoLevelFocusPopupBehavior(Node node) {
        this.focusListener = (observable, oldVal, newVal) -> {};
        this.mouseEventListener = e -> this.setExternalFocus(false);
        this.tlNode = node;
        this.setExternalFocus(false);
        this.tlNode.addEventHandler(KeyEvent.ANY, this.keyEventListener);
        this.tlNode.addEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseEventListener);
        this.tlNode.focusedProperty().addListener(this.focusListener);
        this.origEventDispatcher = this.tlNode.getEventDispatcher();
        this.tlNode.setEventDispatcher(this.tlfEventDispatcher);
    }

    @Override
    public void dispose() {
        this.tlNode.removeEventHandler(KeyEvent.ANY, this.keyEventListener);
        this.tlNode.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseEventListener);
        this.tlNode.focusedProperty().removeListener(this.focusListener);
        this.tlNode.setEventDispatcher(this.origEventDispatcher);
    }

    private Event postDispatchTidyup(Event event) {
        if (!(!(event instanceof KeyEvent) || event.getEventType() != KeyEvent.KEY_PRESSED || this.isExternalFocus() || ((KeyEvent)event).isMetaDown() || ((KeyEvent)event).isControlDown() || ((KeyEvent)event).isAltDown())) {
            switch (((KeyEvent)event).getCode()) {
                case TAB: 
                case UP: 
                case DOWN: 
                case LEFT: 
                case RIGHT: {
                    event.consume();
                    break;
                }
                case ENTER: {
                    this.setExternalFocus(true);
                    event.consume();
                    break;
                }
            }
        }
        return event;
    }
}

