/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font.coretext;

import com.sun.javafx.font.Disposer;
import com.sun.javafx.font.DisposerRecord;
import com.sun.javafx.font.FontStrikeDesc;
import com.sun.javafx.font.PrismFontFile;
import com.sun.javafx.font.PrismFontStrike;
import com.sun.javafx.font.coretext.CGAffineTransform;
import com.sun.javafx.font.coretext.CGRect;
import com.sun.javafx.font.coretext.CTFontStrike;
import com.sun.javafx.font.coretext.OS;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.transform.BaseTransform;

class CTFontFile
extends PrismFontFile {
    private final long cgFontRef;
    private static final CGAffineTransform tx = new CGAffineTransform();

    CTFontFile(String name, String filename, int fIndex, boolean register, boolean embedded, boolean copy, boolean tracked) throws Exception {
        super(name, filename, fIndex, register, embedded, copy, tracked);
        if (embedded) {
            this.cgFontRef = this.createCGFontForEmbeddedFont();
            Disposer.addRecord(this, new SelfDisposerRecord(this.cgFontRef));
        } else {
            this.cgFontRef = 0L;
        }
    }

    public static boolean registerFont(String fontfile) {
        if (fontfile == null) {
            return false;
        }
        long alloc = OS.kCFAllocatorDefault();
        boolean result = false;
        long fileRef = OS.CFStringCreate(fontfile);
        if (fileRef != 0L) {
            int pathStyle = 0;
            long urlRef = OS.CFURLCreateWithFileSystemPath(alloc, fileRef, pathStyle, false);
            if (urlRef != 0L) {
                int scope = 1;
                result = OS.CTFontManagerRegisterFontsForURL(urlRef, scope, 0L);
                OS.CFRelease(urlRef);
            }
            OS.CFRelease(fileRef);
        }
        return result;
    }

    private long createCGFontForEmbeddedFont() {
        long cgFontRef = 0L;
        long fileNameRef = OS.CFStringCreate(this.getFileName());
        if (fileNameRef != 0L) {
            long url = OS.CFURLCreateWithFileSystemPath(OS.kCFAllocatorDefault(), fileNameRef, 0L, false);
            if (url != 0L) {
                long dataProvider = OS.CGDataProviderCreateWithURL(url);
                if (dataProvider != 0L) {
                    cgFontRef = OS.CGFontCreateWithDataProvider(dataProvider);
                    OS.CFRelease(dataProvider);
                }
                OS.CFRelease(url);
            }
            OS.CFRelease(fileNameRef);
        }
        return cgFontRef;
    }

    long getCGFontRef() {
        return this.cgFontRef;
    }

    CGRect getBBox(int gc, float size) {
        CTFontStrike strike = (CTFontStrike)this.getStrike(size, BaseTransform.IDENTITY_TRANSFORM);
        long fontRef = strike.getFontRef();
        if (fontRef == 0L) {
            return null;
        }
        long pathRef = OS.CTFontCreatePathForGlyph(fontRef, (short)gc, tx);
        if (pathRef == 0L) {
            return null;
        }
        CGRect rect = OS.CGPathGetPathBoundingBox(pathRef);
        OS.CGPathRelease(pathRef);
        return rect;
    }

    Path2D getGlyphOutline(int gc, float size) {
        CTFontStrike strike = (CTFontStrike)this.getStrike(size, BaseTransform.IDENTITY_TRANSFORM);
        long fontRef = strike.getFontRef();
        if (fontRef == 0L) {
            return null;
        }
        long pathRef = OS.CTFontCreatePathForGlyph(fontRef, (short)gc, tx);
        if (pathRef == 0L) {
            return null;
        }
        Path2D path = OS.CGPathApply(pathRef);
        OS.CGPathRelease(pathRef);
        return path;
    }

    @Override
    protected int[] createGlyphBoundingBox(int gc) {
        short format;
        float size = 12.0f;
        CTFontStrike strike = (CTFontStrike)this.getStrike(size, BaseTransform.IDENTITY_TRANSFORM);
        long fontRef = strike.getFontRef();
        if (fontRef == 0L) {
            return null;
        }
        int[] bb = new int[4];
        if (!this.isCFF() && OS.CTFontGetBoundingRectForGlyphUsingTables(fontRef, (short)gc, format = this.getIndexToLocFormat(), bb)) {
            return bb;
        }
        long pathRef = OS.CTFontCreatePathForGlyph(fontRef, (short)gc, null);
        if (pathRef == 0L) {
            return null;
        }
        CGRect rect = OS.CGPathGetPathBoundingBox(pathRef);
        OS.CGPathRelease(pathRef);
        float scale = (float)this.getUnitsPerEm() / size;
        bb[0] = (int)Math.round(rect.origin.x * (double)scale);
        bb[1] = (int)Math.round(rect.origin.y * (double)scale);
        bb[2] = (int)Math.round((rect.origin.x + rect.size.width) * (double)scale);
        bb[3] = (int)Math.round((rect.origin.y + rect.size.height) * (double)scale);
        return bb;
    }

    @Override
    protected PrismFontStrike<CTFontFile> createStrike(float size, BaseTransform transform, int aaMode, FontStrikeDesc desc) {
        return new CTFontStrike(this, size, transform, aaMode, desc);
    }

    static {
        CTFontFile.tx.a = 1.0;
        CTFontFile.tx.d = -1.0;
    }

    private static class SelfDisposerRecord
    implements DisposerRecord {
        private long cgFontRef;

        SelfDisposerRecord(long cgFontRef) {
            this.cgFontRef = cgFontRef;
        }

        @Override
        public synchronized void dispose() {
            if (this.cgFontRef != 0L) {
                OS.CFRelease(this.cgFontRef);
                this.cgFontRef = 0L;
            }
        }
    }
}

