/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.application;

import java.awt.Desktop;
import java.io.File;
import java.net.URI;
import javafx.application.Application;

public abstract class HostServicesDelegate {
    public static HostServicesDelegate getInstance(Application app) {
        return StandaloneHostService.getInstance(app);
    }

    protected HostServicesDelegate() {
    }

    public abstract String getCodeBase();

    public abstract String getDocumentBase();

    public abstract void showDocument(String var1);

    private static class StandaloneHostService
    extends HostServicesDelegate {
        private static HostServicesDelegate instance = null;
        private Class appClass = null;
        static final String[] browsers = new String[]{"google-chrome", "firefox", "opera", "konqueror", "mozilla"};

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static HostServicesDelegate getInstance(Application app) {
            Class<StandaloneHostService> clazz = StandaloneHostService.class;
            synchronized (StandaloneHostService.class) {
                if (instance == null) {
                    instance = new StandaloneHostService(app);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return instance;
            }
        }

        private StandaloneHostService(Application app) {
            this.appClass = app.getClass();
        }

        @Override
        public String getCodeBase() {
            String codebase;
            String classUrlString;
            String theClassFile = this.appClass.getName();
            int idx = theClassFile.lastIndexOf(".");
            if (idx >= 0) {
                theClassFile = theClassFile.substring(idx + 1);
            }
            if (!(classUrlString = this.appClass.getResource(theClassFile = theClassFile + ".class").toString()).startsWith("jar:file:") || classUrlString.indexOf("!") == -1) {
                return "";
            }
            String urlString = classUrlString.substring(4, classUrlString.lastIndexOf("!"));
            File jarFile = null;
            try {
                jarFile = new File(new URI(urlString).getPath());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (jarFile != null && (codebase = jarFile.getParent()) != null) {
                return this.toURIString(codebase);
            }
            return "";
        }

        private String toURIString(String filePath) {
            try {
                return new File(filePath).toURI().toString();
            }
            catch (Exception e) {
                e.printStackTrace();
                return "";
            }
        }

        @Override
        public String getDocumentBase() {
            return this.toURIString(System.getProperty("user.dir"));
        }

        @Override
        public void showDocument(String uri) {
            String osName = System.getProperty("os.name");
            try {
                if (osName.startsWith("Mac OS")) {
                    Desktop.getDesktop().browse(URI.create(uri));
                } else if (osName.startsWith("Windows")) {
                    Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + uri);
                } else {
                    String browser = null;
                    for (String b : browsers) {
                        if (browser != null || Runtime.getRuntime().exec(new String[]{"which", b}).getInputStream().read() == -1) continue;
                        Runtime.getRuntime().exec(new String[]{browser = b, uri});
                    }
                    if (browser == null) {
                        throw new Exception("No web browser found");
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

