/*
 * Decompiled with CFR 0.152.
 */
package com.caffeineowl.graphics.bezier.flatnessalgos;

import com.caffeineowl.graphics.bezier.CubicFlatnessAlgorithm;
import com.caffeineowl.graphics.bezier.CubicSubdivisionCriterion;
import com.caffeineowl.graphics.bezier.flatnessalgos.ConvexHullFlatnessAlgo;
import java.awt.geom.CubicCurve2D;

public class GenericCubicSubdivCriterion
implements CubicSubdivisionCriterion {
    private static final double defaultTol = 1.0E-5;
    private static final CubicFlatnessAlgorithm defaultFlatness = new ConvexHullFlatnessAlgo();
    protected CubicFlatnessAlgorithm flatnessAlgo = null;
    protected double tol;
    protected double sqTol;

    public GenericCubicSubdivCriterion() {
        this(defaultFlatness, 1.0E-5);
    }

    public GenericCubicSubdivCriterion(double tolerance) {
        this(defaultFlatness, tolerance);
    }

    public GenericCubicSubdivCriterion(CubicFlatnessAlgorithm algo) {
        this(algo, 1.0E-5);
    }

    public GenericCubicSubdivCriterion(CubicFlatnessAlgorithm algo, double tolerance) {
        if (null == algo) {
            throw new NullPointerException();
        }
        this.flatnessAlgo = algo;
        if (0.0 == tolerance) {
            tolerance = 2.0 * Math.sqrt(Double.MIN_VALUE);
        }
        this.tol = tolerance;
        this.sqTol = tolerance * tolerance;
    }

    public boolean shouldSplit(CubicCurve2D curve) {
        if (this.flatnessAlgo.isSquaredFlatenessPreferred()) {
            return this.flatnessAlgo.getSquaredFlatness(curve) > this.sqTol;
        }
        return this.flatnessAlgo.getFlatness(curve) > this.tol;
    }
}

