/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.colour;

import org.openimaj.image.FImage;
import org.openimaj.image.MBFImage;
import org.openimaj.image.colour.Transforms;

public enum ColourSpace {
    RGB{

        @Override
        public MBFImage convertFromRGB(MBFImage input) {
            return input;
        }

        @Override
        public int getNumBands() {
            return 3;
        }

        @Override
        public MBFImage convertToRGB(MBFImage input) {
            return input;
        }

        @Override
        public float computeIntensity(float[] colour) {
            return (colour[0] + colour[1] + colour[2]) / 3.0f;
        }
    }
    ,
    HSV{

        @Override
        public MBFImage convertFromRGB(MBFImage input) {
            return Transforms.RGB_TO_HSV(input);
        }

        @Override
        public int getNumBands() {
            return 3;
        }

        @Override
        public MBFImage convertToRGB(MBFImage input) {
            return Transforms.HSV_TO_RGB(input);
        }

        @Override
        public float computeIntensity(float[] colour) {
            return colour[2];
        }
    }
    ,
    HSI{

        @Override
        public MBFImage convertFromRGB(MBFImage input) {
            return Transforms.RGB_TO_HSI(input);
        }

        @Override
        public int getNumBands() {
            return 3;
        }

        @Override
        public MBFImage convertToRGB(MBFImage input) {
            throw new UnsupportedOperationException("colour transform not implemented");
        }

        @Override
        public float computeIntensity(float[] colour) {
            return colour[2];
        }
    }
    ,
    H2SV{

        @Override
        public MBFImage convertFromRGB(MBFImage input) {
            return Transforms.RGB_TO_H2SV(input);
        }

        @Override
        public int getNumBands() {
            return 4;
        }

        @Override
        public MBFImage convertToRGB(MBFImage input) {
            return Transforms.HSV_TO_RGB(Transforms.H2SV_TO_HSV_Simple(input));
        }

        @Override
        public float computeIntensity(float[] colour) {
            return colour[3];
        }
    }
    ,
    H2SV_2{

        @Override
        public MBFImage convertFromRGB(MBFImage input) {
            return Transforms.RGB_TO_H2SV_2(input);
        }

        @Override
        public int getNumBands() {
            return 4;
        }

        @Override
        public MBFImage convertToRGB(MBFImage input) {
            return Transforms.HSV_TO_RGB(Transforms.H2SV2_TO_HSV_Simple(input));
        }

        @Override
        public float computeIntensity(float[] colour) {
            return colour[3];
        }
    }
    ,
    H2S{

        @Override
        public MBFImage convertFromRGB(MBFImage input) {
            return Transforms.RGB_TO_H2S(input);
        }

        @Override
        public int getNumBands() {
            return 3;
        }

        @Override
        public MBFImage convertToRGB(MBFImage input) {
            throw new UnsupportedOperationException("colour transform not implemented");
        }

        @Override
        public float computeIntensity(float[] colour) {
            return 0.0f;
        }
    }
    ,
    H2S_2{

        @Override
        public MBFImage convertFromRGB(MBFImage input) {
            return Transforms.RGB_TO_H2S_2(input);
        }

        @Override
        public int getNumBands() {
            return 3;
        }

        @Override
        public MBFImage convertToRGB(MBFImage input) {
            throw new UnsupportedOperationException("colour transform not implemented");
        }

        @Override
        public float computeIntensity(float[] colour) {
            return 0.0f;
        }
    }
    ,
    LUMINANCE_AVG{

        @Override
        public MBFImage convertFromRGB(MBFImage input) {
            return new MBFImage((ColourSpace)this, Transforms.calculateIntensity(input));
        }

        @Override
        public int getNumBands() {
            return 1;
        }

        @Override
        public MBFImage convertToRGB(MBFImage input) {
            return new MBFImage(((FImage)input.bands.get(0)).clone(), ((FImage)input.bands.get(0)).clone(), ((FImage)input.bands.get(0)).clone());
        }

        @Override
        public float computeIntensity(float[] colour) {
            return colour[0];
        }
    }
    ,
    LUMINANCE_NTSC{

        @Override
        public MBFImage convertFromRGB(MBFImage input) {
            return new MBFImage((ColourSpace)this, Transforms.calculateIntensityNTSC(input));
        }

        @Override
        public int getNumBands() {
            return 1;
        }

        @Override
        public MBFImage convertToRGB(MBFImage input) {
            return new MBFImage(((FImage)input.bands.get(0)).clone(), ((FImage)input.bands.get(0)).clone(), ((FImage)input.bands.get(0)).clone());
        }

        @Override
        public float computeIntensity(float[] colour) {
            return colour[0];
        }
    }
    ,
    HUE{

        @Override
        public MBFImage convertFromRGB(MBFImage input) {
            return new MBFImage((ColourSpace)this, Transforms.calculateHue(input));
        }

        @Override
        public int getNumBands() {
            return 1;
        }

        @Override
        public MBFImage convertToRGB(MBFImage input) {
            return new MBFImage(((FImage)input.bands.get(0)).clone(), ((FImage)input.bands.get(0)).clone(), ((FImage)input.bands.get(0)).clone());
        }

        @Override
        public float computeIntensity(float[] colour) {
            return 0.0f;
        }
    }
    ,
    SATURATION{

        @Override
        public MBFImage convertFromRGB(MBFImage input) {
            return new MBFImage((ColourSpace)this, Transforms.calculateSaturation(input));
        }

        @Override
        public int getNumBands() {
            return 1;
        }

        @Override
        public MBFImage convertToRGB(MBFImage input) {
            return new MBFImage(((FImage)input.bands.get(0)).clone(), ((FImage)input.bands.get(0)).clone(), ((FImage)input.bands.get(0)).clone());
        }

        @Override
        public float computeIntensity(float[] colour) {
            return 0.0f;
        }
    }
    ,
    RGB_INTENSITY_NORMALISED{

        @Override
        public MBFImage convertFromRGB(MBFImage input) {
            return Transforms.RGB_TO_RGB_NORMALISED(input);
        }

        @Override
        public int getNumBands() {
            return 3;
        }

        @Override
        public MBFImage convertToRGB(MBFImage input) {
            return input;
        }

        @Override
        public float computeIntensity(float[] colour) {
            return (colour[0] + colour[1] + colour[2]) / 3.0f;
        }
    }
    ,
    CUSTOM{

        @Override
        public MBFImage convertFromRGB(MBFImage input) {
            throw new UnsupportedOperationException("Cannot convert to the custom color-space");
        }

        @Override
        public int getNumBands() {
            return 1;
        }

        @Override
        public MBFImage convertToRGB(MBFImage input) {
            throw new UnsupportedOperationException("colour transform not implemented");
        }

        @Override
        public float computeIntensity(float[] colour) {
            return 0.0f;
        }
    }
    ,
    RGBA{

        @Override
        public MBFImage convertFromRGB(MBFImage input) {
            return new MBFImage((FImage)input.bands.get(0), (FImage)input.bands.get(1), (FImage)input.bands.get(2), new FImage(((FImage)input.bands.get((int)0)).width, ((FImage)input.bands.get((int)0)).height).addInplace(Float.valueOf(1.0f)));
        }

        @Override
        public int getNumBands() {
            return 4;
        }

        @Override
        public MBFImage convertToRGB(MBFImage input) {
            return new MBFImage(((FImage)input.bands.get(0)).clone(), ((FImage)input.bands.get(1)).clone(), ((FImage)input.bands.get(2)).clone());
        }

        @Override
        public float computeIntensity(float[] colour) {
            return (colour[0] + colour[1] + colour[2]) / 3.0f;
        }
    }
    ,
    HSL{

        @Override
        public MBFImage convertFromRGB(MBFImage input) {
            return Transforms.RGB_TO_HSL(input);
        }

        @Override
        public MBFImage convertToRGB(MBFImage input) {
            throw new UnsupportedOperationException("colour transform not implemented");
        }

        @Override
        public int getNumBands() {
            return 3;
        }

        @Override
        public float computeIntensity(float[] colour) {
            return colour[2];
        }
    }
    ,
    HSY{

        @Override
        public MBFImage convertFromRGB(MBFImage input) {
            return Transforms.RGB_TO_HSY(input);
        }

        @Override
        public MBFImage convertToRGB(MBFImage input) {
            throw new UnsupportedOperationException("colour transform not implemented");
        }

        @Override
        public int getNumBands() {
            return 3;
        }

        @Override
        public float computeIntensity(float[] colour) {
            return colour[2];
        }
    }
    ,
    HS{

        @Override
        public MBFImage convertFromRGB(MBFImage input) {
            return Transforms.RGB_TO_HS(input);
        }

        @Override
        public MBFImage convertToRGB(MBFImage input) {
            throw new UnsupportedOperationException("colour transform not implemented");
        }

        @Override
        public int getNumBands() {
            return 2;
        }

        @Override
        public float computeIntensity(float[] colour) {
            return 0.0f;
        }
    }
    ,
    HS_2{

        @Override
        public MBFImage convertFromRGB(MBFImage input) {
            return Transforms.RGB_TO_HS_2(input);
        }

        @Override
        public MBFImage convertToRGB(MBFImage input) {
            throw new UnsupportedOperationException("colour transform not implemented");
        }

        @Override
        public int getNumBands() {
            return 2;
        }

        @Override
        public float computeIntensity(float[] colour) {
            return 0.0f;
        }
    }
    ,
    H1H2{

        @Override
        public MBFImage convertFromRGB(MBFImage input) {
            return Transforms.H_TO_H1H2(Transforms.calculateHue(input));
        }

        @Override
        public MBFImage convertToRGB(MBFImage input) {
            throw new UnsupportedOperationException("colour transform not implemented");
        }

        @Override
        public int getNumBands() {
            return 2;
        }

        @Override
        public float computeIntensity(float[] colour) {
            return 0.0f;
        }
    }
    ,
    H1H2_2{

        @Override
        public MBFImage convertFromRGB(MBFImage input) {
            return Transforms.H_TO_H1H2_2(Transforms.calculateHue(input));
        }

        @Override
        public MBFImage convertToRGB(MBFImage input) {
            throw new UnsupportedOperationException("colour transform not implemented");
        }

        @Override
        public int getNumBands() {
            return 2;
        }

        @Override
        public float computeIntensity(float[] colour) {
            return 0.0f;
        }
    }
    ,
    CIE_XYZ{

        @Override
        public MBFImage convertFromRGB(MBFImage input) {
            return Transforms.RGB_TO_CIEXYZ(input);
        }

        @Override
        public MBFImage convertToRGB(MBFImage input) {
            return Transforms.CIEXYZ_TO_RGB(input);
        }

        @Override
        public int getNumBands() {
            return 3;
        }

        @Override
        public float computeIntensity(float[] colour) {
            return colour[1];
        }
    }
    ,
    CIE_Lab{

        @Override
        public MBFImage convertFromRGB(MBFImage input) {
            return Transforms.RGB_TO_CIELab(input);
        }

        @Override
        public MBFImage convertToRGB(MBFImage input) {
            return Transforms.CIELab_TO_RGB(input);
        }

        @Override
        public int getNumBands() {
            return 3;
        }

        @Override
        public float computeIntensity(float[] colour) {
            return colour[0];
        }
    }
    ,
    CIE_Lab_Norm{

        @Override
        public MBFImage convertFromRGB(MBFImage input) {
            return Transforms.RGB_TO_CIELabNormalised(input);
        }

        @Override
        public MBFImage convertToRGB(MBFImage input) {
            return Transforms.CIELabNormalised_TO_RGB(input);
        }

        @Override
        public int getNumBands() {
            return 3;
        }

        @Override
        public float computeIntensity(float[] colour) {
            return colour[0];
        }
    }
    ,
    CIE_Luv{

        @Override
        public MBFImage convertFromRGB(MBFImage input) {
            return Transforms.RGB_TO_CIELUV(input);
        }

        @Override
        public MBFImage convertToRGB(MBFImage input) {
            return Transforms.CIELUV_TO_RGB(input);
        }

        @Override
        public int getNumBands() {
            return 3;
        }

        @Override
        public float computeIntensity(float[] colour) {
            return colour[0];
        }
    }
    ,
    YUV{

        @Override
        public MBFImage convertFromRGB(MBFImage input) {
            return Transforms.RGB_TO_YUV(input);
        }

        @Override
        public MBFImage convertToRGB(MBFImage input) {
            return Transforms.YUV_TO_RGB(input);
        }

        @Override
        public int getNumBands() {
            return 3;
        }

        @Override
        public float computeIntensity(float[] colour) {
            return colour[2];
        }
    }
    ,
    YUV_Norm{

        @Override
        public MBFImage convertFromRGB(MBFImage input) {
            return Transforms.RGB_TO_YUVNormalised(input);
        }

        @Override
        public MBFImage convertToRGB(MBFImage input) {
            return Transforms.YUVNormalised_TO_RGB(input);
        }

        @Override
        public int getNumBands() {
            return 3;
        }

        @Override
        public float computeIntensity(float[] colour) {
            return colour[2];
        }
    }
    ,
    MODIFIED_OPPONENT{

        @Override
        public MBFImage convertFromRGB(MBFImage input) {
            FImage intensity = Transforms.calculateIntensityNTSC(input);
            float alpha = 0.01f;
            FImage rg = new FImage(input.getWidth(), input.getHeight());
            FImage rb = new FImage(input.getWidth(), input.getHeight());
            float[][] r = ((FImage)input.bands.get((int)0)).pixels;
            float[][] g = ((FImage)input.bands.get((int)1)).pixels;
            float[][] b = ((FImage)input.bands.get((int)2)).pixels;
            for (int y = 0; y < input.getHeight(); ++y) {
                for (int x = 0; x < input.getWidth(); ++x) {
                    rg.pixels[y][x] = (float)((double)r[y][x] - (double)g[y][x] / Math.sqrt(2.0) + (double)(0.01f * intensity.pixels[y][x]));
                    rb.pixels[y][x] = (float)((double)(r[y][x] + g[y][x] - 2.0f * b[y][x]) / Math.sqrt(6.0) + (double)(0.01f * intensity.pixels[y][x]));
                }
            }
            return new MBFImage(MODIFIED_OPPONENT, intensity, rg, rb);
        }

        @Override
        public MBFImage convertToRGB(MBFImage input) {
            throw new UnsupportedOperationException("Not supported (yet)");
        }

        @Override
        public int getNumBands() {
            return 3;
        }

        @Override
        public float computeIntensity(float[] colour) {
            return colour[0];
        }
    }
    ,
    OPPONENT{

        @Override
        public MBFImage convertFromRGB(MBFImage input) {
            FImage intensity = Transforms.calculateIntensity(input);
            FImage o1 = new FImage(input.getWidth(), input.getHeight());
            FImage o2 = new FImage(input.getWidth(), input.getHeight());
            float[][] r = ((FImage)input.bands.get((int)0)).pixels;
            float[][] g = ((FImage)input.bands.get((int)1)).pixels;
            float[][] b = ((FImage)input.bands.get((int)2)).pixels;
            for (int y = 0; y < input.getHeight(); ++y) {
                for (int x = 0; x < input.getWidth(); ++x) {
                    o1.pixels[y][x] = (float)((double)r[y][x] - (double)g[y][x] / Math.sqrt(2.0));
                    o2.pixels[y][x] = (float)((double)(r[y][x] + g[y][x] - 2.0f * b[y][x]) / Math.sqrt(6.0));
                }
            }
            return new MBFImage(MODIFIED_OPPONENT, intensity, o1, o2);
        }

        @Override
        public MBFImage convertToRGB(MBFImage input) {
            throw new UnsupportedOperationException("Not supported (yet)");
        }

        @Override
        public int getNumBands() {
            return 3;
        }

        @Override
        public float computeIntensity(float[] colour) {
            return colour[0];
        }
    };


    public abstract MBFImage convertFromRGB(MBFImage var1);

    public Float[] convertFromRGB(Float[] input) {
        MBFImage singlePixel = new MBFImage(1, 1, RGB);
        singlePixel.setPixel(0, 0, input);
        return this.convertFromRGB(singlePixel).getPixel(0, 0);
    }

    public Float[] convertToRGB(Float[] input) {
        MBFImage singlePixel = new MBFImage(1, 1, this);
        singlePixel.setPixel(0, 0, input);
        return this.convertToRGB(singlePixel).getPixel(0, 0);
    }

    public abstract MBFImage convertToRGB(MBFImage var1);

    public MBFImage convert(MBFImage input) {
        return this.convertFromRGB(input.getColourSpace().convertToRGB(input));
    }

    public static MBFImage convert(MBFImage image, ColourSpace cs) {
        return cs.convertFromRGB(image.colourSpace.convertToRGB(image));
    }

    public abstract int getNumBands();

    public abstract float computeIntensity(float[] var1);

    public Float[] sanitise(Float[] colour) {
        int i;
        if (colour.length >= this.getNumBands()) {
            return colour;
        }
        if (colour.length == 1) {
            Float[] newColour = new Float[this.getNumBands()];
            for (int i2 = 0; i2 < newColour.length; ++i2) {
                newColour[i2] = colour[0];
            }
            return newColour;
        }
        Float[] newColour = new Float[this.getNumBands()];
        for (i = 0; i < colour.length; ++i) {
            newColour[i] = colour[i];
        }
        for (i = colour.length; i < newColour.length; ++i) {
            newColour[i] = Float.valueOf(1.0f);
        }
        return newColour;
    }
}

