/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.util;

import com.vividsolutions.jts.geom.Coordinate;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public strictfp final class GeometryUtils {
    public static final double TWO_PI = Math.PI * 2;
    public static final double THREE_HALVES_PI = 4.71238898038469;
    public static final double THREE_QUARTERS_PI = 2.356194490192345;
    public static final double FIVE_EIGHTHS_PI = 1.9634954084936207;
    public static final double HALF_PI = 1.5707963267948966;
    public static final double THIRD_PI = 1.0471975511965976;
    public static final double QUARTER_PI = 0.7853981633974483;
    public static final double SIXTH_PI = 0.5235987755982988;
    public static final double EIGHTEENTH_PI = 0.17453292519943295;
    public static final int WIND_EVEN_ODD = 0;
    public static final int WIND_NON_ZERO = 1;
    public static final double EPSILON = 1.567855942887398E-7;
    public static final Rectangle2D EMPTY_RECT = new Rectangle2D.Double(0.0, 0.0, -1.0, -1.0);
    public static final Rectangle2D INFINITE_RECT = new Rectangle2D.Double(-8.988465674311579E307, -8.988465674311579E307, Double.MAX_VALUE, Double.MAX_VALUE);

    public static double straight_length(double x1, double y1, double x2, double y2) {
        return GeometryUtils.point_point_straight_distance(y1, x1, y2, x2);
    }

    public static double greatcircle_length(double lon1, double lat1, double lon2, double lat2) {
        return GeometryUtils.point_point_greatcircle_distance(lon1, lat1, lon2, lat2);
    }

    public static double rhumbline_length(double lon1, double lat1, double lon2, double lat2) {
        return GeometryUtils.point_point_rhumbline_distance(lon1, lat1, lon2, lat2);
    }

    public static double point_point_straight_distance_sq(double x1, double y1, double x2, double y2) {
        return Point2D.distanceSq(x1, y1, x2, y2);
    }

    public static double point_point_straight_distance(double x1, double y1, double x2, double y2) {
        return Point2D.distance(x1, y1, x2, y2);
    }

    public static double point_line_straight_distance_sq(double x, double y, double x1, double y1, double x2, double y2) {
        return Line2D.ptSegDistSq(x1, y1, x2, y2, x, y);
    }

    public static double point_line_straight_distance(double x, double y, double x1, double y1, double x2, double y2) {
        return Line2D.ptSegDist(x1, y1, x2, y2, x, y);
    }

    public static double line_line_straight_distance_sq(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
        if (GeometryUtils.intersects(x1, y1, x2, y2, x3, y3, x4, y4)) {
            return 0.0;
        }
        double dist_1_sq = GeometryUtils.point_line_straight_distance_sq(x1, y1, x3, y3, x4, y4);
        double dist_2_sq = GeometryUtils.point_line_straight_distance_sq(x2, y2, x3, y3, x4, y4);
        double dist_3_sq = GeometryUtils.point_line_straight_distance_sq(x3, y3, x1, y1, x2, y2);
        double dist_4_sq = GeometryUtils.point_line_straight_distance_sq(x4, y4, x1, y1, x2, y2);
        return StrictMath.min(StrictMath.min(dist_1_sq, dist_2_sq), StrictMath.min(dist_3_sq, dist_4_sq));
    }

    public static double line_line_straight_distance(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
        return StrictMath.sqrt(GeometryUtils.line_line_straight_distance_sq(x1, y1, x2, y2, x3, y3, x4, y4));
    }

    public static double point_poly_straight_distance_sq(double x, double y, double[] poly) {
        double min_distance_sq = Double.MAX_VALUE;
        for (int i = 2; i < poly.length; i += 2) {
            double distance_sq = GeometryUtils.point_line_straight_distance_sq(x, y, poly[i - 2], poly[i - 1], poly[i], poly[i + 1]);
            if (!(distance_sq < min_distance_sq)) continue;
            min_distance_sq = distance_sq;
        }
        return min_distance_sq;
    }

    public static double point_poly_straight_distance(double x, double y, double[] poly) {
        return StrictMath.sqrt(GeometryUtils.point_poly_straight_distance_sq(x, y, poly));
    }

    public static double line_poly_straight_distance_sq(double x1, double y1, double x2, double y2, double[] poly) {
        double min_distance_sq = Double.MAX_VALUE;
        double x3 = poly[0];
        double y3 = poly[1];
        for (int i = 2; i < poly.length; i += 2) {
            double x4 = poly[i];
            double y4 = poly[i + 1];
            double distance_sq = GeometryUtils.line_line_straight_distance_sq(x1, y1, x2, y2, x3, y3, x4, y4);
            if (distance_sq < min_distance_sq) {
                min_distance_sq = distance_sq;
            }
            x3 = x4;
            y3 = y4;
        }
        return min_distance_sq;
    }

    public static double line_poly_straight_distance(double x1, double y1, double x2, double y2, double[] poly) {
        return StrictMath.sqrt(GeometryUtils.line_poly_straight_distance_sq(x1, y1, x2, y2, poly));
    }

    public static double poly_poly_straight_distance_sq(double[] poly1, double[] poly2) {
        double min_distance_sq = Double.MAX_VALUE;
        double x1 = poly1[0];
        double y1 = poly1[1];
        for (int i = 2; i < poly1.length; i += 2) {
            double x2 = poly1[i];
            double y2 = poly1[i + 1];
            double x3 = poly2[0];
            double y3 = poly2[1];
            for (int j = 2; j < poly2.length; j += 2) {
                double x4 = poly2[j];
                double y4 = poly2[j + 1];
                double distance_sq = GeometryUtils.line_line_straight_distance_sq(x1, y1, x2, y2, x3, y3, x4, y4);
                if (distance_sq < min_distance_sq) {
                    min_distance_sq = distance_sq;
                }
                x3 = x4;
                y3 = y4;
            }
            x1 = x2;
            y1 = y2;
        }
        return min_distance_sq;
    }

    public static double poly_poly_straight_distance(double[] poly1, double[] poly2) {
        return StrictMath.sqrt(GeometryUtils.poly_poly_straight_distance_sq(poly1, poly2));
    }

    public static double point_point_greatcircle_distance(double lon1, double lat1, double lon2, double lat2) {
        double dlat = StrictMath.sin((lat2 - lat1) / 2.0);
        double dlon = StrictMath.sin((lon2 - lon1) / 2.0);
        double a = dlat * dlat + StrictMath.cos(lat1) * StrictMath.cos(lat2) * (dlon * dlon);
        return 2.0 * StrictMath.atan2(StrictMath.sqrt(a), StrictMath.sqrt(1.0 - a));
    }

    public static double point_line_greatcircle_distance(double lon, double lat, double lon1, double lat1, double lon2, double lat2) {
        double n3magnitude;
        double v3;
        double px = StrictMath.cos(lat) * StrictMath.cos(lon);
        double py = StrictMath.cos(lat) * StrictMath.sin(lon);
        double pz = StrictMath.sin(lat);
        double p1x = StrictMath.cos(lat1) * StrictMath.cos(lon1);
        double p1y = StrictMath.cos(lat1) * StrictMath.sin(lon1);
        double p1z = StrictMath.sin(lat1);
        double p2x = StrictMath.cos(lat2) * StrictMath.cos(lon2);
        double p2y = StrictMath.cos(lat2) * StrictMath.sin(lon2);
        double p2z = StrictMath.sin(lat2);
        double n1x = p2x - p1x;
        double n1y = p2y - p1y;
        double n1z = p2z - p1z;
        double n1magnitude = StrictMath.sqrt(n1x * n1x + n1y * n1y + n1z * n1z);
        double v1 = (px - p1x) * (n1x /= n1magnitude) + (py - p1y) * (n1y /= n1magnitude) + (pz - p1z) * (n1z /= n1magnitude);
        double v2 = (px - p2x) * n1x + (py - p2y) * n1y + (pz - p2z) * n1z;
        if (v1 < 0.0 && v2 < 0.0) {
            return GeometryUtils.point_point_greatcircle_distance(lon, lat, lon1, lat1);
        }
        if (v1 > 0.0 && v2 > 0.0) {
            return GeometryUtils.point_point_greatcircle_distance(lon, lat, lon2, lat2);
        }
        double n2x = p1y * p2z - p1z * p2y;
        double n2y = p1z * p2x - p1x * p2z;
        double n2z = p1x * p2y - p1y * p2x;
        double angle = StrictMath.abs(GeometryUtils.angle_between(px, py, pz, n2x, n2y, n2z) - 1.5707963267948966);
        double n3x = (p2x - p1x) / 2.0 + p1x;
        double n3y = (p2y - p1y) / 2.0 + p1y;
        double n3z = (p2z - p1z) / 2.0 + p1z;
        return (v3 = px * (n3x /= (n3magnitude = StrictMath.sqrt(n3x * n3x + n3y * n3y + n3z * n3z))) + py * (n3y /= n3magnitude) + pz * (n3z /= n3magnitude)) < 0.0 ? Math.PI - angle : angle;
    }

    public static double line_line_greatcircle_distance(double lon1, double lat1, double lon2, double lat2, double lon3, double lat3, double lon4, double lat4) {
        if (lat1 == lat2 && lon1 == lon2 && lat3 == lat4 && lon3 == lon4) {
            return GeometryUtils.point_point_greatcircle_distance(lon1, lat1, lon3, lat3);
        }
        if (lat1 == lat2 && lon1 == lon2) {
            return GeometryUtils.point_line_greatcircle_distance(lon1, lat1, lon3, lat3, lon4, lat4);
        }
        if (lat3 == lat4 && lon3 == lon4) {
            return GeometryUtils.point_line_greatcircle_distance(lon3, lat3, lon1, lat1, lon2, lat2);
        }
        double dist_1 = GeometryUtils.point_line_greatcircle_distance(lon1, lat1, lon3, lat3, lon4, lat4);
        double dist_2 = GeometryUtils.point_line_greatcircle_distance(lon2, lat2, lon3, lat3, lon4, lat4);
        double dist_3 = GeometryUtils.point_line_greatcircle_distance(lon3, lat3, lon1, lat1, lon2, lat2);
        double dist_4 = GeometryUtils.point_line_greatcircle_distance(lon4, lat4, lon1, lat1, lon2, lat2);
        return StrictMath.min(StrictMath.min(dist_1, dist_2), StrictMath.min(dist_3, dist_4));
    }

    public static double point_poly_greatcircle_distance(double lon, double lat, double[] poly) {
        double min_distance = Double.MAX_VALUE;
        double lon1 = poly[0];
        double lat1 = poly[1];
        for (int i = 2; i < poly.length; i += 2) {
            double lon2 = poly[i];
            double lat2 = poly[i + 1];
            double distance = GeometryUtils.point_line_greatcircle_distance(lon, lat, lon1, lat1, lon2, lat2);
            if (distance < min_distance) {
                min_distance = distance;
            }
            lon1 = lon2;
            lat1 = lat2;
        }
        return min_distance;
    }

    public static double line_poly_greatcircle_distance(double lon1, double lat1, double lon2, double lat2, double[] poly) {
        double min_distance = Double.MAX_VALUE;
        double lon3 = poly[0];
        double lat3 = poly[1];
        for (int i = 2; i < poly.length; i += 2) {
            double lon4 = poly[i];
            double lat4 = poly[i + 1];
            double distance = GeometryUtils.line_line_greatcircle_distance(lon1, lat1, lon2, lat2, lon3, lat3, lon4, lat4);
            if (distance < min_distance) {
                min_distance = distance;
            }
            lon3 = lon4;
            lat3 = lat4;
        }
        return min_distance;
    }

    public static double poly_poly_greatcircle_distance(double[] poly1, double[] poly2) {
        double min_distance = Double.MAX_VALUE;
        double lon1 = poly1[0];
        double lat1 = poly1[1];
        for (int i = 2; i < poly1.length; i += 2) {
            double lon2 = poly1[i];
            double lat2 = poly1[i + 1];
            double lon3 = poly2[0];
            double lat3 = poly2[1];
            for (int j = 2; j < poly2.length; j += 2) {
                double lon4 = poly2[j];
                double lat4 = poly2[j + 1];
                double distance = GeometryUtils.line_line_greatcircle_distance(lon1, lat1, lon2, lat2, lon3, lat3, lon4, lat4);
                if (distance < min_distance) {
                    min_distance = distance;
                }
                lon3 = lon4;
                lat3 = lat4;
            }
            lon1 = lon2;
            lat1 = lat2;
        }
        return min_distance;
    }

    public static double point_point_rhumbline_distance(double lon1, double lat1, double lon2, double lat2) {
        double dlat = lat2 - lat1;
        double dlon = lon2 - lon1;
        double q = StrictMath.abs(dlat) < 0.001 ? StrictMath.cos(lat1) : dlat / StrictMath.log(StrictMath.tan(lat2 / 2.0 + 0.7853981633974483) / StrictMath.tan(lat1 / 2.0 + 0.7853981633974483));
        return StrictMath.sqrt(dlat * dlat + q * q * (dlon * dlon));
    }

    public static double interior_angle(double lon1, double lat1, double lon2, double lat2, double lon3, double lat3) {
        double b2;
        double t2;
        double phiPrime2;
        double b1;
        double cosLat2 = StrictMath.cos(lat2);
        double sinLat2 = StrictMath.sin(lat2);
        double t1 = StrictMath.sin(lon1 - lon2) * StrictMath.cos(lat1);
        double phiPrime1 = StrictMath.atan2(t1, b1 = StrictMath.sin(lat1) * cosLat2 - StrictMath.cos(lat1) * sinLat2 * StrictMath.cos(lon1 - lon2));
        double angle = phiPrime1 - (phiPrime2 = StrictMath.atan2(t2 = StrictMath.sin(lon3 - lon2) * StrictMath.cos(lat3), b2 = StrictMath.sin(lat3) * cosLat2 - StrictMath.cos(lat3) * sinLat2 * StrictMath.cos(lon3 - lon2)));
        return angle < 0.0 ? angle + Math.PI * 2 : angle;
    }

    public static double angle_between(double x1, double y1, double z1, double x2, double y2, double z2) {
        double magnitude1 = StrictMath.sqrt(x1 * x1 + y1 * y1 + z1 * z1);
        double magnitude2 = StrictMath.sqrt(x2 * x2 + y2 * y2 + z2 * z2);
        double dotProduct = x1 * x2 + y1 * y2 + z1 * z2;
        return StrictMath.acos(dotProduct / (magnitude1 * magnitude2));
    }

    public static Coordinate north_pole_transform(double phi, double lambda, double alpha, double beta, double lambda0, Coordinate storage) {
        storage.y = StrictMath.asin(StrictMath.sin(alpha) * StrictMath.sin(phi) - StrictMath.cos(alpha) * StrictMath.cos(phi) * StrictMath.cos(lambda - lambda0));
        storage.x = StrictMath.atan2(StrictMath.cos(phi) * StrictMath.sin(lambda - lambda0), StrictMath.sin(alpha) * StrictMath.cos(phi) * StrictMath.cos(lambda - lambda0) + StrictMath.cos(alpha) * StrictMath.sin(phi)) + beta;
        return storage;
    }

    public static Coordinate inverse_north_pole(double phiPrime, double lambdaPrime, double alpha, double beta, double lambda0, Coordinate storage) {
        storage.y = StrictMath.asin(StrictMath.sin(alpha) * StrictMath.sin(phiPrime) + StrictMath.cos(alpha) * StrictMath.cos(phiPrime) * StrictMath.cos(lambdaPrime - beta));
        storage.x = StrictMath.atan2(StrictMath.cos(phiPrime) * StrictMath.sin(lambdaPrime - beta), StrictMath.sin(alpha) * StrictMath.cos(phiPrime) * StrictMath.cos(lambdaPrime - beta) - StrictMath.cos(alpha) * StrictMath.sin(phiPrime)) + lambda0;
        return storage;
    }

    public static boolean intersects(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
        return x1 == x3 && y1 == y3 || x1 == x4 && y1 == y4 || x2 == x3 && y2 == y3 || x2 == x4 && y2 == y4 || GeometryUtils.CCW(x1, y1, x2, y2, x3, y3) * GeometryUtils.CCW(x1, y1, x2, y2, x4, y4) <= 0 && GeometryUtils.CCW(x3, y3, x4, y4, x1, y1) * GeometryUtils.CCW(x3, y3, x4, y4, x2, y2) <= 0;
    }

    private static int CCW(double x1, double y1, double x2, double y2, double x3, double y3) {
        double dx1 = x2 - x1;
        double dy2 = y3 - y1;
        double dy1 = y2 - y1;
        double dx2 = x3 - x1;
        return dx1 * dy2 > dy1 * dx2 ? 1 : -1;
    }

    public static double sinh(double z) {
        return (StrictMath.pow(Math.E, z) - StrictMath.pow(Math.E, -z)) / 2.0;
    }

    public static double asinh(double z) {
        return StrictMath.log(z + StrictMath.sqrt(1.0 + z * z));
    }

    public static double cosh(double z) {
        return (StrictMath.pow(Math.E, z) + StrictMath.pow(Math.E, -z)) / 2.0;
    }

    public static double acosh(double z) {
        return StrictMath.log(z + (z + 1.0) / StrictMath.sqrt((z - 1.0) / (z + 1.0)));
    }

    public static double tanh(double z) {
        double eToTheZ = StrictMath.pow(Math.E, z);
        double eToTheMinusZ = StrictMath.pow(Math.E, -z);
        return (eToTheZ - eToTheMinusZ) / (eToTheZ + eToTheMinusZ);
    }

    public static double atanh(double z) {
        return StrictMath.log((1.0 + z) * StrictMath.sqrt(1.0 / (1.0 - z * z)));
    }

    public static int sign(double x) {
        return x < 0.0 ? -1 : 1;
    }

    public static double clamp_latitude(double lat) {
        if (lat > Math.PI) {
            return Math.PI;
        }
        if (lat < -Math.PI) {
            return -Math.PI;
        }
        return lat;
    }

    public static double wrap_longitude(double lon) {
        if (lon < -62.83185307179586 || lon > 62.83185307179586) {
            return Double.NaN;
        }
        while (lon > Math.PI) {
            lon -= Math.PI * 2;
        }
        while (lon < -Math.PI) {
            lon += Math.PI * 2;
        }
        return lon;
    }

    public static double wrap_longitude_positive(double lon) {
        if (lon < -62.83185307179586 || lon > 62.83185307179586) {
            return Double.NaN;
        }
        while (lon < 0.0) {
            lon += Math.PI * 2;
        }
        while (lon > Math.PI * 2) {
            lon -= Math.PI * 2;
        }
        return lon;
    }

    public static double longitude_span_width(double left, double right) {
        return left < right ? right - left : Math.PI - right + (left + Math.PI);
    }

    public static double spherical_azimuth(double lambda0, double phi1, double lambda, double phi) {
        double ldiff = lambda - lambda0;
        double cosphi = StrictMath.cos(phi);
        return StrictMath.atan2(cosphi * StrictMath.sin(ldiff), StrictMath.cos(phi1) * StrictMath.sin(phi) - StrictMath.sin(phi1) * cosphi * StrictMath.cos(ldiff));
    }

    public static Coordinate spherical_between(double lambda0, double phi1, double c, double Az) {
        return GeometryUtils.spherical_between(lambda0, phi1, c, Az, new Coordinate());
    }

    public static Coordinate spherical_between(double lambda0, double phi1, double c, double Az, Coordinate storage) {
        double cosphi1 = StrictMath.cos(phi1);
        double sinphi1 = StrictMath.sin(phi1);
        double cosAz = StrictMath.cos(Az);
        double sinAz = StrictMath.sin(Az);
        double sinc = StrictMath.sin(c);
        double cosc = StrictMath.cos(c);
        storage.y = StrictMath.asin(sinphi1 * cosc + cosphi1 * sinc * cosAz);
        storage.x = StrictMath.atan2(sinc * sinAz, cosphi1 * cosc - sinphi1 * sinc * cosAz) + lambda0;
        return storage;
    }

    public static Coordinate[] earth_circle(double lambda0, double phi1, double c, int n) {
        double cosphi1 = StrictMath.cos(phi1);
        double sinphi1 = StrictMath.sin(phi1);
        double sinc = StrictMath.sin(c);
        double cosc = StrictMath.cos(c);
        Coordinate[] result = new Coordinate[n];
        double inc = Math.PI * 2 / (double)(n - 1);
        double Az = -Math.PI;
        for (int i = 0; i < n; ++i) {
            double cosAz = StrictMath.cos(Az);
            double sinAz = StrictMath.sin(Az);
            result[i] = new Coordinate((double)((float)GeometryUtils.wrap_longitude(StrictMath.atan2(sinc * sinAz, cosphi1 * cosc - sinphi1 * sinc * cosAz) + lambda0)), (double)((float)StrictMath.asin(sinphi1 * cosc + cosphi1 * sinc * cosAz)));
            Az += inc;
        }
        return result;
    }

    public static double[] great_circle(double lambda0, double phi1, double lambda, double phi, int nsegs, boolean include_last) {
        double increment;
        double cosphi = StrictMath.cos(phi);
        double cosphi1 = StrictMath.cos(phi1);
        double sinphi1 = StrictMath.sin(phi1);
        double ldiff = lambda - lambda0;
        double p2diff = StrictMath.sin((phi - phi1) / 2.0);
        double l2diff = StrictMath.sin(ldiff / 2.0);
        double c = 2.0 * StrictMath.asin(StrictMath.sqrt(p2diff * p2diff + cosphi1 * cosphi * l2diff * l2diff));
        double Az = StrictMath.atan2(cosphi * StrictMath.sin(ldiff), cosphi1 * StrictMath.sin(phi) - sinphi1 * cosphi * StrictMath.cos(ldiff));
        double cosAz = StrictMath.cos(Az);
        double sinAz = StrictMath.sin(Az);
        double pointC = increment = c / (double)(include_last ? nsegs : nsegs + 1);
        double[] result = new double[(nsegs + 1) * 2];
        result[0] = lambda0;
        result[1] = phi1;
        for (int i = 2; i < result.length; i += 2) {
            double sinc = StrictMath.sin(pointC);
            double cosc = StrictMath.cos(pointC);
            result[i] = StrictMath.atan2(sinc * sinAz, cosphi1 * cosc - sinphi1 * sinc * cosAz) + lambda0;
            result[i + 1] = StrictMath.asin(sinphi1 * cosc + cosphi1 * sinc * cosAz);
            pointC += increment;
        }
        return result;
    }

    public static double[] rhumb_line(double lambda1, double phi1, double lambda2, double phi2, int nsegs, boolean include_last) {
        double[] result = new double[(nsegs + 1) * 2];
        result[0] = lambda1;
        result[1] = phi1;
        if (lambda1 < -1.5707963267948966 && lambda2 > 1.5707963267948966 || lambda1 > 1.5707963267948966 && lambda2 < -1.5707963267948966) {
            lambda1 = GeometryUtils.wrap_longitude_positive(lambda1);
            lambda2 = GeometryUtils.wrap_longitude_positive(lambda2);
        }
        if (phi1 == phi2) {
            double dLambda = (lambda2 - lambda1) / (double)(include_last ? nsegs : nsegs + 1);
            double lambda = lambda1 + dLambda;
            for (int i = 2; i < result.length; i += 2) {
                result[i] = GeometryUtils.wrap_longitude(lambda);
                result[i + 1] = phi1;
                lambda += dLambda;
            }
        } else if (lambda1 == lambda2) {
            double dPhi = (phi2 - phi1) / (double)(include_last ? nsegs : nsegs + 1);
            double phi = phi1 + dPhi;
            for (int i = 2; i < result.length; i += 2) {
                result[i] = GeometryUtils.wrap_longitude(lambda1);
                result[i + 1] = phi;
                phi += dPhi;
            }
        } else {
            double y1 = StrictMath.log(StrictMath.tan(0.7853981633974483 + phi1 / 2.0));
            double y2 = StrictMath.log(StrictMath.tan(0.7853981633974483 + phi2 / 2.0));
            double m = (lambda2 - lambda1) / (y2 - y1);
            double lonInc = (lambda2 - lambda1) / (double)(include_last ? nsegs : nsegs + 1);
            double lon = lambda1 + lonInc;
            for (int i = 2; i < result.length; i += 2) {
                double y = y1 + (lon - lambda1) / m;
                result[i] = GeometryUtils.wrap_longitude(lon);
                result[i + 1] = 1.5707963267948966 - 2.0 * StrictMath.atan(StrictMath.pow(Math.E, -y));
                lon += lonInc;
            }
        }
        return result;
    }
}

