/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.projection;

import com.vividsolutions.jts.geom.Coordinate;
import java.text.ParseException;
import org.myworldgis.projection.Azimuthal;
import org.myworldgis.projection.Ellipsoid;
import org.myworldgis.projection.ProjectionParameters;
import org.myworldgis.util.GeometryUtils;
import org.ngs.ngunits.SI;
import org.ngs.ngunits.Unit;
import org.ngs.ngunits.quantity.Angle;
import org.ngs.ngunits.quantity.Length;

public strictfp final class AzimuthalEqualArea
extends Azimuthal {
    public static final String WKT_NAME = "Lambert_Azimuthal_Equal_Area";
    public static final String CENTER_LON_PROPERTY = "longitude_of_center";
    public static final String CENTER_LAT_PROPERTY = "latitude_of_center";
    private double _e;
    private double _qp;
    private double _Rq;
    private double _D;
    private double _sinBeta1;
    private double _cosBeta1;
    private double[] _subPhi;

    public AzimuthalEqualArea(Ellipsoid ellipsoid, Coordinate center, Unit<Length> units, double falseEasting, double falseNorthing) {
        super(ellipsoid, center, units, falseEasting, falseNorthing);
        this._name = WKT_NAME;
        this._subPhi = new double[3];
        this.computeParameters();
    }

    public AzimuthalEqualArea(Ellipsoid ellipsoid, ProjectionParameters parameters) throws ParseException {
        super(ellipsoid, parameters);
        this._name = WKT_NAME;
        this._subPhi = new double[3];
        this.computeParameters();
    }

    @Override
    protected double getMaxC() {
        return 1.5707963267948966;
    }

    @Override
    protected Coordinate forwardPointRaw(double lambda, double phi, Coordinate storage) {
        double sinPhi = StrictMath.sin(phi);
        double q = (1.0 - this._e2) * (sinPhi / (1.0 - this._e2 * sinPhi * sinPhi) - 1.0 / (2.0 * this._e) * StrictMath.log((1.0 - this._e * sinPhi) / (1.0 + this._e * sinPhi)));
        double beta = StrictMath.asin(q / this._qp);
        double B = this._Rq * StrictMath.sqrt(2.0 / (1.0 + this._sinBeta1 * StrictMath.sin(beta) + this._cosBeta1 * StrictMath.cos(beta) * StrictMath.cos(GeometryUtils.wrap_longitude(lambda - this._lambda0))));
        storage.x = B * this._D * StrictMath.cos(beta) * StrictMath.sin(GeometryUtils.wrap_longitude(lambda - this._lambda0));
        storage.y = B / this._D * (this._cosBeta1 * StrictMath.sin(beta) - this._sinBeta1 * StrictMath.cos(beta) * StrictMath.cos(GeometryUtils.wrap_longitude(lambda - this._lambda0)));
        return storage;
    }

    @Override
    protected Coordinate inversePointRaw(double x, double y, Coordinate storage) {
        double rho = StrictMath.sqrt(x / this._D * (x / this._D) + this._D * y * this._D * y);
        if (rho == 0.0) {
            storage.y = this._phi0;
            storage.x = this._lambda0;
        } else {
            double ce = 2.0 * StrictMath.asin(rho / (2.0 * this._Rq));
            double beta = StrictMath.asin(StrictMath.cos(ce) * this._sinBeta1 + this._D * y * StrictMath.sin(ce) * this._cosBeta1 / rho);
            storage.y = beta + this._subPhi[0] * StrictMath.sin(2.0 * beta) + this._subPhi[1] * StrictMath.sin(4.0 * beta) + this._subPhi[2] * StrictMath.sin(6.0 * beta);
            storage.x = this._lambda0 + StrictMath.atan2(x * StrictMath.sin(ce), this._D * rho * this._cosBeta1 * StrictMath.cos(ce) - this._D * this._D * y * this._sinBeta1 * StrictMath.sin(ce));
        }
        return storage;
    }

    @Override
    protected void computeParameters() {
        this._e = StrictMath.sqrt(this._e2);
        this._qp = (1.0 - this._e2) * (1.0 / (1.0 - this._e2) - 1.0 / (2.0 * this._e) * StrictMath.log((1.0 - this._e) / (1.0 + this._e)));
        this._Rq = this._a * StrictMath.sqrt(this._qp / 2.0);
        double sinPhi1 = StrictMath.sin(this._phi0);
        double cosPhi1 = StrictMath.cos(this._phi0);
        double q1 = (1.0 - this._e2) * (sinPhi1 / (1.0 - this._e2 * sinPhi1 * sinPhi1) - 1.0 / (2.0 * this._e) * StrictMath.log((1.0 - this._e * sinPhi1) / (1.0 + this._e * sinPhi1)));
        double beta1 = StrictMath.asin(q1 / this._qp);
        this._sinBeta1 = StrictMath.sin(beta1);
        this._cosBeta1 = StrictMath.cos(beta1);
        double m1 = cosPhi1 / StrictMath.sqrt(1.0 - this._e2 * sinPhi1 * sinPhi1);
        this._D = this._a * m1 / (this._Rq * this._cosBeta1);
        this._subPhi[0] = this._e2 / 3.0 + 31.0 * this._e2 * this._e2 / 180.0 + 517.0 * this._e2 * this._e2 * this._e2 / 5040.0;
        this._subPhi[1] = 23.0 * this._e2 * this._e2 / 360.0 + 251.0 * this._e2 * this._e2 * this._e2 / 3780.0;
        this._subPhi[2] = 761.0 * this._e2 * this._e2 * this._e2 / 45360.0;
        super.computeParameters();
    }

    @Override
    public ProjectionParameters getParameters() {
        ProjectionParameters result = super.getParameters();
        result.addAngularParameter(CENTER_LON_PROPERTY, this._lambda0, (Unit<Angle>)SI.RADIAN);
        result.addAngularParameter(CENTER_LAT_PROPERTY, this._phi0, (Unit<Angle>)SI.RADIAN);
        return result;
    }

    @Override
    public Object clone() {
        AzimuthalEqualArea clone = (AzimuthalEqualArea)super.clone();
        clone._subPhi = (double[])this._subPhi.clone();
        return clone;
    }
}

