/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.netlogo;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.util.GeometryTransformer;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.WKTWriter;
import java.awt.image.BandedSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.net.InetAddress;
import java.net.Socket;
import java.text.ParseException;
import java.util.LinkedList;
import org.myworldgis.io.asciigrid.AsciiGridFileReader;
import org.myworldgis.io.asciigrid.AsciiGridFileWriter;
import org.myworldgis.netlogo.GISExtension;
import org.myworldgis.netlogo.GridDimensions;
import org.myworldgis.netlogo.RasterDataset;
import org.myworldgis.netlogo.StoreDataset;
import org.myworldgis.netlogo.VectorDataset;
import org.myworldgis.netlogo.VectorFeature;
import org.myworldgis.projection.Projection;
import org.myworldgis.projection.ProjectionFormat;
import org.myworldgis.util.StringUtils;
import org.nlogo.api.Argument;
import org.nlogo.api.Context;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.LogoException;
import org.nlogo.api.LogoListBuilder;
import org.nlogo.core.LogoList;
import org.nlogo.core.Syntax;
import org.nlogo.core.SyntaxJ;

public strictfp abstract class MyWorld {
    public static final int MYWORLD_PORT = 8328;
    private static final ProjectionFormat PROJ_FORMAT = new ProjectionFormat();

    private static VectorDataset readVectorDataset(BufferedReader in) throws IOException {
        Projection dstProj = GISExtension.getState().getProjection();
        Projection srcProj = null;
        try {
            srcProj = PROJ_FORMAT.parseProjection(in.readLine());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        GeometryTransformer inverse = null;
        GeometryTransformer forward = null;
        boolean reproject = false;
        if (srcProj != null && dstProj != null && !srcProj.equals(dstProj)) {
            inverse = srcProj.getInverseTransformer();
            forward = dstProj.getForwardTransformer();
            reproject = true;
        }
        VectorDataset.ShapeType shapeType = null;
        String shapeTypeName = in.readLine();
        if (StringUtils.startsWithIgnoreCase(shapeTypeName, "point") || StringUtils.startsWithIgnoreCase(shapeTypeName, "multipoint")) {
            shapeType = VectorDataset.ShapeType.POINT;
        } else if (StringUtils.startsWithIgnoreCase(shapeTypeName, "polyline")) {
            shapeType = VectorDataset.ShapeType.LINE;
        } else if (StringUtils.startsWithIgnoreCase(shapeTypeName, "polygon")) {
            shapeType = VectorDataset.ShapeType.POLYGON;
        }
        LinkedList<String> nameList = new LinkedList<String>();
        StringReader propertyNamesIn = new StringReader(in.readLine());
        String propName = null;
        while ((propName = StringUtils.readDelimited(propertyNamesIn, ' ')) != null) {
            nameList.add(propName);
        }
        String[] propertyNames = nameList.toArray(new String[nameList.size()]);
        LinkedList<VectorDataset.PropertyType> typeList = new LinkedList<VectorDataset.PropertyType>();
        StringReader propertyTypesIn = new StringReader(in.readLine());
        String typeName = null;
        while ((typeName = StringUtils.readDelimited(propertyTypesIn, ' ')) != null) {
            typeList.add(Enum.valueOf(VectorDataset.PropertyType.class, typeName));
        }
        VectorDataset.PropertyType[] propertyTypes = typeList.toArray(new VectorDataset.PropertyType[typeList.size()]);
        VectorDataset result = new VectorDataset(shapeType, propertyNames, propertyTypes);
        WKTReader gIn = new WKTReader(GISExtension.getState().factory());
        while (true) {
            String dataLine = in.readLine();
            String geomLine = in.readLine();
            if (dataLine == null || geomLine == null || dataLine.length() + geomLine.length() == 0) break;
            Object[] data = new Object[propertyNames.length];
            StringReader dataIn = new StringReader(dataLine);
            String datum = null;
            int index = 0;
            while ((datum = StringUtils.readDelimited(dataIn, ' ')) != null) {
                Object value = datum;
                if (propertyTypes[index] == VectorDataset.PropertyType.NUMBER) {
                    try {
                        value = Double.valueOf(datum);
                    }
                    catch (NumberFormatException e) {
                        value = null;
                    }
                }
                data[index++] = value;
            }
            try {
                Geometry geom = gIn.read(geomLine);
                if (reproject) {
                    geom = forward.transform(inverse.transform(geom));
                }
                result.add(geom, data);
            }
            catch (com.vividsolutions.jts.io.ParseException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private static void writeVectorDataset(VectorDataset dataset, Writer out) throws IOException {
        int i;
        out.write("VECTOR\n");
        if (GISExtension.getState().getProjection() != null) {
            out.write(PROJ_FORMAT.format(GISExtension.getState().getProjection()));
        }
        out.write(10);
        switch (StoreDataset.esriShapeType(dataset)) {
            case 1: {
                out.write("POINT");
                break;
            }
            case 8: {
                out.write("MULTIPOINT");
                break;
            }
            case 3: {
                out.write("POLYLINE");
                break;
            }
            case 5: {
                out.write("POLYGON");
                break;
            }
            default: {
                out.write("NULL");
            }
        }
        out.write(10);
        VectorDataset.Property[] properties = dataset.getProperties();
        for (i = 0; i < properties.length; ++i) {
            if (i > 0) {
                out.write(32);
            }
            StringUtils.writeDelimited(properties[i].getName(), ' ', out);
        }
        out.write(10);
        for (i = 0; i < properties.length; ++i) {
            if (i > 0) {
                out.write(32);
            }
            out.write(properties[i].getType().name());
        }
        out.write(10);
        WKTWriter gOut = new WKTWriter();
        for (VectorFeature feature : dataset.getFeatures()) {
            for (int j = 0; j < properties.length; ++j) {
                String value;
                Object datum = feature.getProperty(properties[j].getName());
                String string = value = datum != null ? datum.toString() : "";
                if (j > 0) {
                    out.write(32);
                }
                StringUtils.writeDelimited(value, ' ', out);
            }
            out.write(10);
            gOut.write(feature.getGeometry(), out);
            out.write(10);
        }
        out.write(10);
        out.write(10);
    }

    private static RasterDataset readRasterDataset(BufferedReader in) throws IOException {
        Projection dstProj = GISExtension.getState().getProjection();
        Projection srcProj = null;
        try {
            srcProj = PROJ_FORMAT.parseProjection(in.readLine());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        AsciiGridFileReader asc = new AsciiGridFileReader(in);
        GridDimensions dimensions = new GridDimensions(asc.getSize(), asc.getEnvelope());
        DataBuffer data = asc.getData();
        BandedSampleModel sampleModel = new BandedSampleModel(data.getDataType(), dimensions.getGridWidth(), dimensions.getGridHeight(), 1);
        WritableRaster raster = Raster.createWritableRaster(sampleModel, data, null);
        if (srcProj != null && dstProj != null && !srcProj.equals(dstProj)) {
            return new RasterDataset(raster, dimensions, srcProj, dstProj);
        }
        return new RasterDataset(dimensions, raster);
    }

    private static void writeRasterDataset(RasterDataset dataset, Writer out) throws IOException {
        out.write("RASTER\n");
        if (GISExtension.getState().getProjection() != null) {
            out.write(PROJ_FORMAT.format(GISExtension.getState().getProjection()));
        }
        out.write(10);
        AsciiGridFileWriter asc = new AsciiGridFileWriter(out);
        GridDimensions dimensions = dataset.getDimensions();
        asc.writeGridInfo(dimensions.getGridSize(), dimensions.getEnvelope(), Double.NaN);
        asc.writeGridData(dataset.getRaster().getDataBuffer());
        out.write(10);
    }

    public strictfp static final class PutDataset
    extends GISExtension.Command {
        public String getAgentClassString() {
            return "O";
        }

        public Syntax getSyntax() {
            return SyntaxJ.commandSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.NumberType() + Syntax.RepeatableType()}, (int)1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void performInternal(Argument[] args, Context context) throws ExtensionException, IOException, LogoException {
            Object arg0 = args[0].get();
            Socket socket = null;
            try {
                socket = new Socket(InetAddress.getLocalHost(), 8328);
                OutputStreamWriter out = new OutputStreamWriter(socket.getOutputStream());
                out.write("PUT LAYER");
                for (int i = 1; i < args.length; ++i) {
                    ((Writer)out).write(32);
                    out.write(Integer.toString(args[i].getIntValue()));
                }
                out.write("\n");
                ((Writer)out).flush();
                if (arg0 instanceof VectorDataset) {
                    MyWorld.writeVectorDataset((VectorDataset)arg0, out);
                } else if (arg0 instanceof RasterDataset) {
                    MyWorld.writeRasterDataset((RasterDataset)arg0, out);
                } else {
                    throw new ExtensionException("not a GIS dataset: " + arg0);
                }
                ((Writer)out).flush();
                BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                String response = in.readLine();
                if (StringUtils.startsWithIgnoreCase(response, "ERROR")) {
                    int space = response.indexOf(32);
                    throw new IOException(response.substring(space + 1));
                }
            }
            finally {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public strictfp static final class GetDataset
    extends GISExtension.Reporter {
        public String getAgentClassString() {
            return "O";
        }

        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.NumberType() + Syntax.RepeatableType()}, (int)Syntax.WildcardType(), (int)1);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Object reportInternal(Argument[] args, Context context) throws ExtensionException, IOException, LogoException {
            Socket socket = null;
            try {
                socket = new Socket(InetAddress.getLocalHost(), 8328);
                OutputStreamWriter out = new OutputStreamWriter(socket.getOutputStream());
                out.write("GET LAYER");
                for (int i = 0; i < args.length; ++i) {
                    ((Writer)out).write(32);
                    out.write(Integer.toString(args[i].getIntValue()));
                }
                out.write("\n");
                ((Writer)out).flush();
                BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                String type = in.readLine();
                if (StringUtils.startsWithIgnoreCase(type, "VECTOR")) {
                    VectorDataset vectorDataset = MyWorld.readVectorDataset(in);
                    return vectorDataset;
                }
                if (StringUtils.startsWithIgnoreCase(type, "RASTER")) {
                    RasterDataset rasterDataset = MyWorld.readRasterDataset(in);
                    return rasterDataset;
                }
                if (!StringUtils.startsWithIgnoreCase(type, "ERROR")) throw new ExtensionException("unrecognized response type: " + type);
                throw new ExtensionException(type.substring(type.indexOf(32) + 1));
            }
            finally {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public strictfp static final class GetLayers
    extends GISExtension.Reporter {
        public String getAgentClassString() {
            return "O";
        }

        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[0], (int)Syntax.ListType());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object reportInternal(Argument[] args, Context context) throws ExtensionException, IOException, LogoException {
            LogoListBuilder result = new LogoListBuilder();
            Socket socket = null;
            try {
                socket = new Socket(InetAddress.getLocalHost(), 8328);
                OutputStreamWriter out = new OutputStreamWriter(socket.getOutputStream());
                out.write("GET LIST\n");
                ((Writer)out).flush();
                BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                while (true) {
                    LogoListBuilder layerSpec = new LogoListBuilder();
                    String typeAndName = in.readLine();
                    String projection = in.readLine();
                    String properties = in.readLine();
                    if (typeAndName == null || projection == null || properties == null) break;
                    int space = typeAndName.indexOf(32);
                    String type = typeAndName.substring(0, space);
                    String name = typeAndName.substring(space + 1);
                    layerSpec.add((Object)type);
                    layerSpec.add((Object)name);
                    layerSpec.add((Object)projection);
                    LogoListBuilder propertyNames = new LogoListBuilder();
                    StringReader propsIn = new StringReader(properties);
                    String propName = null;
                    while ((propName = StringUtils.readDelimited(propsIn, ' ')) != null) {
                        propertyNames.add((Object)propName);
                    }
                    layerSpec.add((Object)propertyNames.toLogoList());
                    result.add((Object)layerSpec.toLogoList());
                }
                LogoList logoList = result.toLogoList();
                return logoList;
            }
            finally {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

