/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.netlogo;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import java.awt.geom.AffineTransform;
import org.nlogo.api.World;
import org.nlogo.core.ExtensionObject;

public strictfp final class CoordinateTransformation
implements ExtensionObject {
    private final Envelope _gisEnvelope;
    private final Envelope _netLogoEnvelope;
    private final Coordinate _gisSpaceCenter;
    private final Coordinate _netLogoSpaceCenter;
    private final double _scaleX;
    private final double _scaleY;

    public CoordinateTransformation(Envelope gisSpaceEnvelope, Envelope netLogoSpaceEnvelope, boolean equalizeScales) {
        this._gisEnvelope = new Envelope(gisSpaceEnvelope);
        this._netLogoEnvelope = new Envelope(netLogoSpaceEnvelope);
        this._netLogoEnvelope.expandBy(0.5);
        double sx = this._netLogoEnvelope.getWidth() / this._gisEnvelope.getWidth();
        double sy = this._netLogoEnvelope.getHeight() / this._gisEnvelope.getHeight();
        if (equalizeScales) {
            this._scaleY = this._scaleX = StrictMath.min(sx, sy);
        } else {
            this._scaleX = sx;
            this._scaleY = sy;
        }
        this._gisSpaceCenter = new Coordinate(this._gisEnvelope.getMinX() + this._gisEnvelope.getWidth() / 2.0, this._gisEnvelope.getMinY() + this._gisEnvelope.getHeight() / 2.0);
        this._netLogoSpaceCenter = new Coordinate(this._netLogoEnvelope.getMinX() + this._netLogoEnvelope.getWidth() / 2.0, this._netLogoEnvelope.getMinY() + this._netLogoEnvelope.getHeight() / 2.0);
    }

    public AffineTransform getNetLogoToGISTransform() {
        AffineTransform result = AffineTransform.getTranslateInstance(this._gisSpaceCenter.x, this._gisSpaceCenter.y);
        result.scale(1.0 / this._scaleX, 1.0 / this._scaleY);
        result.translate(-this._netLogoSpaceCenter.x, -this._netLogoSpaceCenter.y);
        return result;
    }

    public AffineTransform getGISToNetLogoTransform() {
        AffineTransform result = AffineTransform.getTranslateInstance(this._netLogoSpaceCenter.x, this._netLogoSpaceCenter.y);
        result.scale(this._scaleX, this._scaleY);
        result.translate(-this._gisSpaceCenter.x, -this._gisSpaceCenter.y);
        return result;
    }

    public Coordinate netLogoToGIS(Coordinate pt, Coordinate storage) {
        if (storage == null) {
            storage = new Coordinate();
        }
        storage.x = (pt.x - this._netLogoSpaceCenter.x) / this._scaleX + this._gisSpaceCenter.x;
        storage.y = (pt.y - this._netLogoSpaceCenter.y) / this._scaleY + this._gisSpaceCenter.y;
        return storage;
    }

    public Coordinate gisToNetLogo(Coordinate pt, Coordinate storage) {
        if (storage == null) {
            storage = new Coordinate();
        }
        storage.x = (pt.x - this._gisSpaceCenter.x) * this._scaleX + this._netLogoSpaceCenter.x;
        storage.y = (pt.y - this._gisSpaceCenter.y) * this._scaleY + this._netLogoSpaceCenter.y;
        if (this._netLogoEnvelope.contains(storage)) {
            return storage;
        }
        return null;
    }

    public Envelope getEnvelope(World world) {
        Coordinate bottomLeft = new Coordinate((double)world.minPxcor() - 0.5, (double)world.minPycor() - 0.5);
        Coordinate topRight = new Coordinate((double)world.maxPxcor() + 0.5, (double)world.maxPycor() + 0.5);
        this.netLogoToGIS(bottomLeft, bottomLeft);
        this.netLogoToGIS(topRight, topRight);
        return new Envelope(bottomLeft.x, topRight.x, bottomLeft.y, topRight.y);
    }

    public String dump(boolean readable, boolean exporting, boolean reference) {
        return "";
    }

    public String getExtensionName() {
        return "gis";
    }

    public String getNLTypeName() {
        return "CT";
    }

    public boolean recursivelyEqual(Object o) {
        if (o instanceof CoordinateTransformation) {
            CoordinateTransformation cs = (CoordinateTransformation)o;
            return cs._gisSpaceCenter.equals((Object)this._gisSpaceCenter) && cs._netLogoSpaceCenter.equals((Object)this._netLogoSpaceCenter) && cs._scaleX == this._scaleX && cs._scaleY == this._scaleY;
        }
        return false;
    }
}

