/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.support;

import java.awt.Color;
import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.jeuclid.layout.FillRectObject;
import net.sourceforge.jeuclid.layout.LayoutInfo;
import net.sourceforge.jeuclid.layout.LayoutStage;
import net.sourceforge.jeuclid.layout.LayoutView;
import net.sourceforge.jeuclid.layout.LayoutableNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ElementListSupport {
    private ElementListSupport() {
    }

    public static List<Node> createListOfChildren(Node node) {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        ArrayList<Node> arrayList = new ArrayList<Node>(n);
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            arrayList.add(node2);
        }
        return arrayList;
    }

    public static List<LayoutableNode> createListOfLayoutChildren(Node node) {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        ArrayList<LayoutableNode> arrayList = new ArrayList<LayoutableNode>(n);
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (!(node2 instanceof LayoutableNode)) continue;
            arrayList.add((LayoutableNode)node2);
        }
        return arrayList;
    }

    public static void fillInfoFromChildren(LayoutView layoutView, LayoutInfo layoutInfo, Node node, LayoutStage layoutStage, Dimension2D dimension2D, Dimension2D dimension2D2) {
        float f;
        float f2 = (float)dimension2D.getHeight();
        float f3 = (float)dimension2D2.getHeight();
        float f4 = f = (float)dimension2D.getWidth();
        for (LayoutableNode layoutableNode : ElementListSupport.createListOfLayoutChildren(node)) {
            LayoutInfo layoutInfo2 = layoutView.getInfo(layoutableNode);
            f2 = Math.max(f2, -layoutInfo2.getPosY(layoutStage) + layoutInfo2.getAscentHeight(layoutStage));
            f3 = Math.max(f3, layoutInfo2.getPosY(layoutStage) + layoutInfo2.getDescentHeight(layoutStage));
            f4 = Math.max(f4, layoutInfo2.getPosX(layoutStage) + layoutInfo2.getWidth(layoutStage));
        }
        layoutInfo.setAscentHeight(f2 + (float)dimension2D.getHeight(), layoutStage);
        layoutInfo.setDescentHeight(f3 + (float)dimension2D2.getHeight(), layoutStage);
        layoutInfo.setHorizontalCenterOffset((f4 + f) / 2.0f, layoutStage);
        layoutInfo.setWidth(f4 + (float)dimension2D2.getWidth(), layoutStage);
    }

    public static void layoutSequential(LayoutView layoutView, LayoutInfo layoutInfo, List<LayoutableNode> list, LayoutStage layoutStage) {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        for (LayoutableNode layoutableNode : list) {
            LayoutInfo layoutInfo2 = layoutView.getInfo(layoutableNode);
            f = Math.max(f, layoutInfo2.getAscentHeight(layoutStage));
            f2 = Math.max(f2, layoutInfo2.getDescentHeight(layoutStage));
            f4 = Math.max(f4, layoutInfo2.getStretchAscent());
            f5 = Math.max(f5, layoutInfo2.getStretchDescent());
            layoutInfo2.moveTo(f3, 0.0f, layoutStage);
            f3 += layoutInfo2.getWidth(layoutStage);
        }
        layoutInfo.setAscentHeight(f, layoutStage);
        layoutInfo.setDescentHeight(f2, layoutStage);
        layoutInfo.setStretchAscent(f4);
        layoutInfo.setStretchDescent(f5);
        layoutInfo.setHorizontalCenterOffset(f3 / 2.0f, layoutStage);
        layoutInfo.setWidth(f3, layoutStage);
    }

    public static void addBackground(Color color, LayoutInfo layoutInfo, boolean bl) {
        if (color != null) {
            FillRectObject fillRectObject = bl ? new FillRectObject(color, (float)Math.ceil(layoutInfo.getAscentHeight(LayoutStage.STAGE2)), (float)Math.ceil(layoutInfo.getDescentHeight(LayoutStage.STAGE2)), (float)Math.ceil(layoutInfo.getWidth(LayoutStage.STAGE2))) : new FillRectObject(color, layoutInfo.getAscentHeight(LayoutStage.STAGE2), layoutInfo.getDescentHeight(LayoutStage.STAGE2), layoutInfo.getWidth(LayoutStage.STAGE2));
            layoutInfo.getGraphicObjects().add(0, fillRectObject);
        }
    }
}

