/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.generic;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.List;
import net.sourceforge.jeuclid.LayoutContext;
import net.sourceforge.jeuclid.context.LayoutContextImpl;
import net.sourceforge.jeuclid.context.Parameter;
import net.sourceforge.jeuclid.elements.JEuclidElementFactory;
import net.sourceforge.jeuclid.elements.JEuclidNode;
import net.sourceforge.jeuclid.elements.generic.JEuclidDOMImplementation;
import net.sourceforge.jeuclid.elements.support.ElementListSupport;
import net.sourceforge.jeuclid.layout.JEuclidView;
import net.sourceforge.jeuclid.layout.LayoutInfo;
import net.sourceforge.jeuclid.layout.LayoutStage;
import net.sourceforge.jeuclid.layout.LayoutView;
import net.sourceforge.jeuclid.layout.LayoutableDocument;
import net.sourceforge.jeuclid.layout.LayoutableNode;
import org.apache.batik.dom.GenericDocument;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.mathml.MathMLDocument;
import org.w3c.dom.views.DocumentView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DocumentElement
extends GenericDocument
implements MathMLDocument,
JEuclidNode,
DocumentView,
LayoutableDocument {
    private static final long serialVersionUID = 1L;

    public DocumentElement() {
        this(null);
    }

    public DocumentElement(DocumentType documentType) {
        super(documentType, JEuclidDOMImplementation.getInstance());
        super.setEventsEnabled(true);
        this.ownerDocument = this;
    }

    @Override
    public String getDomain() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getReferrer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getURI() {
        throw new UnsupportedOperationException();
    }

    @Override
    public LayoutContext getChildLayoutContext(int n, LayoutContext layoutContext) {
        return layoutContext;
    }

    @Override
    public JEuclidView getDefaultView() {
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        Graphics2D graphics2D = (Graphics2D)((Image)bufferedImage).getGraphics();
        return new JEuclidView(this, LayoutContextImpl.getDefaultLayoutContext(), graphics2D);
    }

    @Override
    public List<LayoutableNode> getChildrenToLayout() {
        return ElementListSupport.createListOfLayoutChildren(this);
    }

    @Override
    public List<LayoutableNode> getChildrenToDraw() {
        return ElementListSupport.createListOfLayoutChildren(this);
    }

    @Override
    public void layoutStage1(LayoutView layoutView, LayoutInfo layoutInfo, LayoutStage layoutStage, LayoutContext layoutContext) {
        ElementListSupport.layoutSequential(layoutView, layoutInfo, this.getChildrenToLayout(), LayoutStage.STAGE1);
        layoutInfo.setLayoutStage(layoutStage);
        if (layoutContext.getParameter(Parameter.MATHBACKGROUND) == null) {
            layoutInfo.setLayoutStage(layoutStage);
        } else {
            layoutInfo.setLayoutStage(LayoutStage.STAGE1);
        }
    }

    @Override
    public void layoutStage2(LayoutView layoutView, LayoutInfo layoutInfo, LayoutContext layoutContext) {
        ElementListSupport.layoutSequential(layoutView, layoutInfo, this.getChildrenToLayout(), LayoutStage.STAGE2);
        ElementListSupport.addBackground((Color)layoutContext.getParameter(Parameter.MATHBACKGROUND), layoutInfo, true);
        layoutInfo.setLayoutStage(LayoutStage.STAGE2);
    }

    protected Node newNode() {
        return new DocumentElement();
    }

    @Override
    public Element createElement(String string) {
        return JEuclidElementFactory.elementFromName(null, string, this);
    }

    @Override
    public Element createElementNS(String string, String string2) {
        String string3 = string != null && string.length() == 0 ? null : string;
        return JEuclidElementFactory.elementFromName(string3, string2, this);
    }
}

