/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.utils;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.tinfour.utils.GridSpecification;

public class GridFileReader
implements Closeable {
    private final InputStream bins;
    private final StringBuilder sb = new StringBuilder(256);
    private final GridSpecification gridSpec;
    double noDataValue = Double.NaN;
    String noDataString = null;

    public GridFileReader(File file) throws IOException {
        FileInputStream fins = new FileInputStream(file);
        this.bins = new BufferedInputStream(fins);
        this.gridSpec = this.readHeader();
    }

    public GridFileReader(InputStream input) throws IOException {
        this.bins = input;
        this.gridSpec = this.readHeader();
    }

    public GridSpecification getGridSpecification() {
        return this.gridSpec;
    }

    public double[][] readGrid() throws IOException {
        int nRows = this.gridSpec.getRowCount();
        int nCols = this.gridSpec.getColumnCount();
        double[][] g = new double[nRows][nCols];
        int iRow = 0;
        int iCol = 0;
        this.sb.setLength(0);
        if (this.noDataString == null) {
            try {
                for (iRow = 0; iRow < nRows; ++iRow) {
                    for (iCol = 0; iCol < nCols; ++iCol) {
                        g[iRow][iCol] = Double.parseDouble(this.readString());
                    }
                }
            }
            catch (NumberFormatException nex) {
                throw new IOException("Invalid numeric reading row " + iRow + ", column " + iCol, nex);
            }
        }
        try {
            for (iRow = 0; iRow < nRows; ++iRow) {
                for (iCol = 0; iCol < nCols; ++iCol) {
                    String s = this.readString();
                    g[iRow][iCol] = this.noDataString.equalsIgnoreCase(s) ? Double.NaN : Double.parseDouble(s);
                }
            }
        }
        catch (NumberFormatException nex) {
            throw new IOException("Invalid numeric reading row " + iRow + ", column " + iCol, nex);
        }
        return g;
    }

    private GridSpecification readHeader() throws IOException {
        double ymax;
        double xmax;
        double ymin;
        double xmin;
        int nCols = 0;
        int nRows = 0;
        double xLL = Double.NaN;
        double yLL = Double.NaN;
        double cellSize = Double.NaN;
        GridSpecification.CellPosition cellPos = GridSpecification.CellPosition.CenterOfCell;
        for (int i = 0; i < 6; ++i) {
            String s = this.readString().toUpperCase();
            if ("NCOLS".equals(s)) {
                nCols = this.readIntParameter(s);
                continue;
            }
            if ("NROWS".equals(s)) {
                nRows = this.readIntParameter(s);
                continue;
            }
            if (s.startsWith("XLL")) {
                xLL = this.readDoubleParameter(s);
                if (s.contains("CENTER")) {
                    cellPos = GridSpecification.CellPosition.CenterOfCell;
                    continue;
                }
                if (!s.contains("CORNER")) continue;
                cellPos = GridSpecification.CellPosition.CornerOfCell;
                continue;
            }
            if (s.startsWith("YLL")) {
                yLL = this.readDoubleParameter(s);
                if (s.contains("CENTER")) {
                    cellPos = GridSpecification.CellPosition.CenterOfCell;
                    continue;
                }
                if (!s.contains("CORNER")) continue;
                cellPos = GridSpecification.CellPosition.CornerOfCell;
                continue;
            }
            if ("CELLSIZE".equals(s)) {
                cellSize = this.readDoubleParameter(s);
                continue;
            }
            if ("NODATA_VALUE".equals(s)) {
                String p = this.readString();
                if (p.isEmpty()) {
                    throw new IOException("Missing value for NODATA_VALUE");
                }
                if ("NaN".equalsIgnoreCase(p)) {
                    this.noDataString = p;
                }
                try {
                    this.noDataValue = Double.parseDouble(p);
                }
                catch (NumberFormatException dontCare) {
                    this.noDataString = p;
                }
                continue;
            }
            throw new IOException("Unrecognized specification in header " + s);
        }
        if (nCols <= 0 || nRows <= 0) {
            throw new IOException("Invalid column,row specification " + nCols + ", " + nRows);
        }
        if (Double.isNaN(xLL) || Double.isNaN(yLL) || Double.isNaN(cellSize)) {
            throw new IOException("Invalid coordinate or cellsize specification");
        }
        if (cellPos == GridSpecification.CellPosition.CenterOfCell) {
            xmin = xLL - 0.5 * cellSize;
            ymin = yLL - 0.5 * cellSize;
            xmax = xLL + (double)nCols * cellSize;
            ymax = yLL + (double)nRows * cellSize;
        } else {
            xmin = xLL;
            ymin = yLL;
            xmax = xLL + (double)nCols * cellSize;
            ymax = yLL + (double)nRows * cellSize;
        }
        return new GridSpecification(cellPos, cellSize, xmin, xmax, ymin, ymax);
    }

    private String readString() throws IOException {
        this.sb.setLength(0);
        int c = this.bins.read();
        if (c <= 0) {
            return "";
        }
        while (Character.isWhitespace(c)) {
            c = this.bins.read();
            if (c > 0) continue;
            return "";
        }
        this.sb.append((char)c);
        c = this.bins.read();
        if (c <= 0) {
            return this.sb.toString();
        }
        while (!Character.isWhitespace(c)) {
            this.sb.append((char)c);
            c = this.bins.read();
            if (c > 0) continue;
            break;
        }
        return this.sb.toString();
    }

    private int readIntParameter(String parameter) throws IOException {
        String s = this.readString();
        if (s.isEmpty()) {
            throw new IOException("Missing value for " + parameter);
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException nex) {
            throw new IOException("Invalid value \"" + s + "\" for integer " + parameter);
        }
    }

    private double readDoubleParameter(String parameter) throws IOException {
        String s = this.readString();
        if (s.isEmpty()) {
            throw new IOException("Missing value for " + parameter);
        }
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException nex) {
            throw new IOException("Invalid value \"" + s + "\" for numeric " + parameter);
        }
    }

    @Override
    public void close() throws IOException {
        this.bins.close();
    }
}

