/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.content.animation.animator;

import cern.jet.random.Uniform;
import cern.jet.random.engine.MersenneTwister;
import cern.jet.random.engine.RandomEngine;
import org.openimaj.content.animation.animator.LinearShortValueAnimator;
import org.openimaj.content.animation.animator.ValueAnimator;

public class RandomLinearShortValueAnimator
implements ValueAnimator<Short> {
    private int seed;
    Uniform rng;
    LinearShortValueAnimator animator;
    private short min;
    private short max;
    private int duration;

    public RandomLinearShortValueAnimator(short min, short max, int duration) {
        this.seed = (int)System.nanoTime();
        this.min = min;
        this.max = max;
        this.duration = duration;
        this.reset();
    }

    public RandomLinearShortValueAnimator(short min, short max, int duration, short initial) {
        this(min, max, duration);
        this.setNextAnimator(initial);
    }

    public RandomLinearShortValueAnimator(int startWait, int stopWait, short min, short max, int duration) {
        this.seed = (int)System.currentTimeMillis();
        this.min = min;
        this.max = max;
        this.duration = duration;
        this.reset();
    }

    public RandomLinearShortValueAnimator(int startWait, int stopWait, short min, short max, int duration, short initial) {
        this(min, max, duration);
        this.setNextAnimator(initial);
    }

    @Override
    public Short nextValue() {
        if (this.animator.hasFinished()) {
            this.setNextAnimator((Short)this.animator.nextValue());
        }
        return (Short)this.animator.nextValue();
    }

    @Override
    public boolean hasFinished() {
        return false;
    }

    @Override
    public void reset() {
        this.rng = new Uniform((RandomEngine)new MersenneTwister(this.seed));
        short v1 = (short)this.rng.nextIntFromTo((int)this.min, (int)this.max);
        this.setNextAnimator(v1);
    }

    protected void setNextAnimator(short v1) {
        short v2 = (short)this.rng.nextIntFromTo((int)this.min, (int)this.max);
        this.animator = new LinearShortValueAnimator(v1, v2, this.duration);
    }
}

