/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.content.animation.animator;

import org.openimaj.content.animation.animator.AbstractValueAnimator;
import org.openimaj.content.animation.animator.ReversableValueAnimator;

public class LinearFloatValueAnimator
extends AbstractValueAnimator<Float>
implements ReversableValueAnimator<Float> {
    float start;
    float finish;
    float incr;
    float current;

    public LinearFloatValueAnimator(float start, float finish, int duration) {
        super(Float.valueOf(start), 0, 0);
        this.current = start;
        this.start = start;
        this.finish = finish;
        this.incr = (finish - start) / (float)duration;
    }

    public LinearFloatValueAnimator(int startWait, int stopWait, float start, float finish, int duration) {
        super(Float.valueOf(start), startWait, stopWait);
        this.current = start;
        this.start = start;
        this.finish = finish;
        this.incr = (finish - start) / (float)duration;
    }

    @Override
    public Float makeNextValue() {
        this.current += this.incr;
        if (this.start < this.finish && this.current > this.finish) {
            this.current = this.finish;
        } else if (this.start > this.finish && this.current < this.finish) {
            this.current = this.finish;
        }
        return Float.valueOf(this.current);
    }

    @Override
    protected boolean complete() {
        if (this.incr == 0.0f) {
            return true;
        }
        float next = this.current + this.incr;
        if (this.start < this.finish && (double)next - 1.0E-7 > (double)this.finish) {
            return true;
        }
        return this.start > this.finish && (double)next + 1.0E-7 < (double)this.finish;
    }

    @Override
    protected void resetToInitial() {
        this.current = this.start;
    }

    @Override
    public ReversableValueAnimator<Float> reverseAnimator() {
        float curr = this.current;
        float sta = this.start;
        this.reset();
        this.current = curr;
        this.incr *= -1.0f;
        this.start = this.finish;
        this.finish = sta;
        return this;
    }
}

