/*
 * Decompiled with CFR 0.152.
 */
package bsearch.space;

import bsearch.space.ParameterSpec;
import java.util.ArrayList;
import java.util.List;
import org.nlogo.api.MersenneTwisterFast;

public strictfp class CategoricalSpec
extends ParameterSpec {
    private List<Object> choices;

    public CategoricalSpec(String name, List<Object> choices) {
        super(name);
        this.choices = new ArrayList<Object>(choices);
    }

    public CategoricalSpec(String name, Object ... choiceArray) {
        super(name);
        this.choices = new ArrayList<Object>();
        for (Object obj : choiceArray) {
            this.choices.add(obj);
        }
    }

    @Override
    public Object generateRandomValue(MersenneTwisterFast rng) {
        return this.choices.get(rng.nextInt(this.choices.size()));
    }

    @Override
    public Object mutate(Object obj, double mutStrength, MersenneTwisterFast rng) {
        int index = this.choices.indexOf(obj);
        int newchoice = rng.nextInt(this.choices.size() - 1);
        if (newchoice >= index) {
            ++newchoice;
        }
        return this.choices.get(newchoice);
    }

    @Override
    public int choiceCount() {
        return this.choices.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[ ");
        sb.append('\"');
        sb.append(this.name);
        sb.append('\"');
        for (Object obj : this.choices) {
            sb.append(" ");
            sb.append(obj);
        }
        sb.append(" ]");
        return sb.toString();
    }

    @Override
    public Object getValueFromChoice(long choice, long maxNumChoices) {
        return this.choices.get((int)(choice % (long)this.choices.size()));
    }

    @Override
    public long getChoiceIndexFromValue(Object val, long maxNumChoices) {
        return this.choices.indexOf(val);
    }
}

