/*
 * Decompiled with CFR 0.152.
 */
package bsearch.representations;

import bsearch.app.BehaviorSearchException;
import bsearch.representations.ChromosomeFactory;
import bsearch.util.GeneralUtils;
import java.io.FileNotFoundException;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;

public class ChromosomeTypeLoader {
    public static ChromosomeFactory createFromName(String chromosomeName) throws BehaviorSearchException {
        ChromosomeFactory factory;
        String chromosomeFactoryClassName = chromosomeName;
        if (!chromosomeFactoryClassName.contains(".")) {
            chromosomeFactoryClassName = "bsearch.representations." + chromosomeFactoryClassName + "$Factory";
        }
        try {
            factory = (ChromosomeFactory)Class.forName(chromosomeFactoryClassName).newInstance();
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
            ex.printStackTrace();
            throw new BehaviorSearchException("Failed to find/load ChromosomeFactory from Java class: " + chromosomeFactoryClassName);
        }
        return factory;
    }

    public static List<String> getAllChromosomeTypes() throws BehaviorSearchException {
        Scanner scanner;
        try {
            scanner = new Scanner(GeneralUtils.getResource("ChromosomeTypeList.txt"));
        }
        catch (FileNotFoundException e) {
            throw new BehaviorSearchException("Error loading list of Chromosome class names: File 'ChromosomeTypeList.txt' couldn't be found.");
        }
        LinkedList<String> list = new LinkedList<String>();
        while (scanner.hasNextLine()) {
            String s = scanner.nextLine();
            if (s.trim().length() <= 0) continue;
            list.add(s);
        }
        scanner.close();
        return list;
    }
}

