/*
 * Decompiled with CFR 0.152.
 */
import org.nlogo.api.Argument;
import org.nlogo.api.Command;
import org.nlogo.api.Context;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.Version$;
import org.nlogo.core.AgentKindJ;
import org.nlogo.core.Syntax;
import org.nlogo.core.SyntaxJ;

public class SetAgentTransparency
implements Command {
    public Syntax getSyntax() {
        int[] values = new int[]{Syntax.NumberType()};
        return SyntaxJ.commandSyntax((int[])values, (String)"-TPL");
    }

    public void perform(Argument[] args, Context context) throws ExtensionException {
        double alpha = args[0].getDoubleValue();
        if (alpha < 0.0 || alpha > 100.0) {
            throw new ExtensionException("Transparency must be in the range from 0 to 100.");
        }
        if (context.getAgent().kind() == AgentKindJ.Patch() && !Version$.MODULE$.is3D()) {
            throw new ExtensionException("Transparency for 2D patches cannot be changed.");
        }
        alpha = 255.0 * (1.0 - alpha / 100.0);
        SetAgentAlpha.setColor(context, alpha);
    }
}

