/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import org.jhotdraw.framework.ConnectionFigure;
import org.jhotdraw.framework.Connector;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureAttributeConstant;
import org.jhotdraw.framework.FigureChangeEvent;
import org.jhotdraw.framework.FigureChangeListener;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.framework.FigureVisitor;
import org.jhotdraw.framework.HandleEnumeration;
import org.jhotdraw.framework.Locator;
import org.jhotdraw.standard.ChopBoxConnector;
import org.jhotdraw.standard.FigureChangeEventMulticaster;
import org.jhotdraw.standard.FigureEnumerator;
import org.jhotdraw.standard.RelativeLocator;
import org.jhotdraw.standard.TextHolder;
import org.jhotdraw.util.CollectionsFactory;
import org.jhotdraw.util.Geom;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.StorableOutput;

public abstract class AbstractFigure
implements Figure {
    private transient FigureChangeListener fListener;
    private List myDependendFigures = CollectionsFactory.current().createList();
    private static final long serialVersionUID = -10857585979273442L;
    private int abstractFigureSerializedDataVersion = 1;
    private int _nZ;

    protected AbstractFigure() {
    }

    public void moveBy(int n, int n2) {
        this.willChange();
        this.basicMoveBy(n, n2);
        this.changed();
    }

    protected abstract void basicMoveBy(int var1, int var2);

    public void displayBox(Point point, Point point2) {
        this.willChange();
        this.basicDisplayBox(point, point2);
        this.changed();
    }

    public abstract void basicDisplayBox(Point var1, Point var2);

    public abstract Rectangle displayBox();

    public abstract HandleEnumeration handles();

    public FigureEnumeration figures() {
        return FigureEnumerator.getEmptyEnumeration();
    }

    public Dimension size() {
        return new Dimension(this.displayBox().width, this.displayBox().height);
    }

    public boolean isEmpty() {
        return this.size().width < 3 || this.size().height < 3;
    }

    public Figure findFigureInside(int n, int n2) {
        if (this.containsPoint(n, n2)) {
            return this;
        }
        return null;
    }

    public boolean containsPoint(int n, int n2) {
        return this.displayBox().contains(n, n2);
    }

    public void displayBox(Rectangle rectangle) {
        this.displayBox(new Point(rectangle.x, rectangle.y), new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height));
    }

    public boolean includes(Figure figure) {
        return figure == this;
    }

    public FigureEnumeration decompose() {
        List list = CollectionsFactory.current().createList(1);
        list.add(this);
        return new FigureEnumerator(list);
    }

    public void addToContainer(FigureChangeListener figureChangeListener) {
        this.addFigureChangeListener(figureChangeListener);
        this.invalidate();
    }

    public void removeFromContainer(FigureChangeListener figureChangeListener) {
        this.invalidate();
        this.removeFigureChangeListener(figureChangeListener);
    }

    public synchronized void addFigureChangeListener(FigureChangeListener figureChangeListener) {
        this.fListener = FigureChangeEventMulticaster.add(this.listener(), figureChangeListener);
    }

    public synchronized void removeFigureChangeListener(FigureChangeListener figureChangeListener) {
        this.fListener = FigureChangeEventMulticaster.remove(this.listener(), figureChangeListener);
    }

    public synchronized FigureChangeListener listener() {
        return this.fListener;
    }

    public void release() {
        if (this.listener() != null) {
            this.listener().figureRemoved(new FigureChangeEvent(this));
        }
    }

    public void invalidate() {
        if (this.listener() != null) {
            Rectangle rectangle = this.invalidateRectangle(this.displayBox());
            this.listener().figureInvalidated(new FigureChangeEvent(this, rectangle));
        }
    }

    protected Rectangle invalidateRectangle(Rectangle rectangle) {
        rectangle.grow(8, 8);
        return rectangle;
    }

    public void willChange() {
        this.invalidate();
    }

    public void changed() {
        this.invalidate();
        if (this.listener() != null) {
            this.listener().figureChanged(new FigureChangeEvent(this));
        }
    }

    public Point center() {
        return Geom.center(this.displayBox());
    }

    public boolean canConnect() {
        return true;
    }

    public Insets connectionInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public Connector connectorAt(int n, int n2) {
        return new ChopBoxConnector(this);
    }

    public void connectorVisibility(boolean bl, ConnectionFigure connectionFigure) {
    }

    public Locator connectedTextLocator(Figure figure) {
        return RelativeLocator.center();
    }

    public Object getAttribute(String string) {
        return null;
    }

    public Object getAttribute(FigureAttributeConstant figureAttributeConstant) {
        return null;
    }

    public void setAttribute(String string, Object object) {
    }

    public void setAttribute(FigureAttributeConstant figureAttributeConstant, Object object) {
    }

    public Object clone() {
        Closeable closeable;
        Object object = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(200);
        try {
            closeable = new ObjectOutputStream(byteArrayOutputStream);
            closeable.writeObject(this);
            closeable.close();
        }
        catch (IOException iOException) {
            System.err.println("Class not found: " + iOException);
        }
        closeable = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream((InputStream)closeable);
            object = objectInputStream.readObject();
        }
        catch (IOException iOException) {
            System.err.println(iOException.toString());
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Class not found: " + classNotFoundException);
        }
        return object;
    }

    public void write(StorableOutput storableOutput) {
    }

    public void read(StorableInput storableInput) throws IOException {
    }

    public int getZValue() {
        return this._nZ;
    }

    public void setZValue(int n) {
        this._nZ = n;
    }

    public void visit(FigureVisitor figureVisitor) {
        FigureEnumeration figureEnumeration = this.getDependendFigures();
        figureVisitor.visitFigure(this);
        FigureEnumeration figureEnumeration2 = this.figures();
        while (figureEnumeration2.hasNextFigure()) {
            figureEnumeration2.nextFigure().visit(figureVisitor);
        }
        HandleEnumeration handleEnumeration = this.handles();
        while (handleEnumeration.hasNextHandle()) {
            figureVisitor.visitHandle(handleEnumeration.nextHandle());
        }
        while (figureEnumeration.hasNextFigure()) {
            figureEnumeration.nextFigure().visit(figureVisitor);
        }
    }

    public synchronized FigureEnumeration getDependendFigures() {
        return new FigureEnumerator(this.myDependendFigures);
    }

    public synchronized void addDependendFigure(Figure figure) {
        this.myDependendFigures.add(figure);
    }

    public synchronized void removeDependendFigure(Figure figure) {
        this.myDependendFigures.remove(figure);
    }

    public TextHolder getTextHolder() {
        return null;
    }

    public Figure getDecoratedFigure() {
        return this;
    }
}

