/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.javadraw;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.standard.DecoratorFigure;
import org.jhotdraw.util.Animatable;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.StorableOutput;

public class AnimationDecorator
extends DecoratorFigure
implements Animatable {
    private int fXVelocity;
    private int fYVelocity;
    private static final long serialVersionUID = 7894632974364110685L;
    private int animationDecoratorSerializedDataVersion = 1;

    public AnimationDecorator() {
    }

    public AnimationDecorator(Figure figure) {
        super(figure);
        this.fXVelocity = 4;
        this.fYVelocity = 4;
    }

    public void velocity(int n, int n2) {
        this.fXVelocity = n;
        this.fYVelocity = n2;
    }

    public Point velocity() {
        return new Point(this.fXVelocity, this.fYVelocity);
    }

    public void animationStep() {
        int n = this.fXVelocity;
        int n2 = this.fYVelocity;
        Rectangle rectangle = this.displayBox();
        if (rectangle.x + rectangle.width > 300 && n > 0) {
            n = -n;
        }
        if (rectangle.y + rectangle.height > 300 && n2 > 0) {
            n2 = -n2;
        }
        if (rectangle.x < 0 && n < 0) {
            n = -n;
        }
        if (rectangle.y < 0 && n2 < 0) {
            n2 = -n2;
        }
        this.velocity(n, n2);
        this.moveBy(n, n2);
    }

    public synchronized void basicMoveBy(int n, int n2) {
        super.basicMoveBy(n, n2);
    }

    public synchronized void basicDisplayBox(Point point, Point point2) {
        super.basicDisplayBox(point, point2);
    }

    public synchronized Rectangle displayBox() {
        return super.displayBox();
    }

    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
        storableOutput.writeInt(this.fXVelocity);
        storableOutput.writeInt(this.fYVelocity);
    }

    public void read(StorableInput storableInput) throws IOException {
        super.read(storableInput);
        this.fXVelocity = storableInput.readInt();
        this.fYVelocity = storableInput.readInt();
    }
}

